/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgMemberSelectFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgMemberSelectFacadeControllerBean
extends AbstractBgMemberSelectFacadeControllerBean {
    private static final long serialVersionUID = 6434526987607477240L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgMemberSelectFacadeControllerBean");

    @Override
    protected IObjectCollection _getBgPropertys(Context ctx, String viewId, boolean isAccount, String quickText) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)viewId)) {
            return null;
        }
        String tableName = "T_MBG_BgAccount";
        String viewName = "FBgAccountViewId";
        if (!isAccount) {
            tableName = "T_MBG_MbgMember";
            viewName = "FViewId";
        }
        Locale locale = ctx.getLocale();
        StringBuffer sql = new StringBuffer();
        sql.append(" select distinct p.FId pId, p.FNumber pNumber, p.FName_" + locale + " pName, ").append(" p.FLongNumber pLongNumber, p.FIsLeaf pIsLeaf, p.FLevel pLevel, ").append(" sort.Fid sId, sort.FNumber sNumber, sort.FName_" + locale + " sName ").append(" from T_MBG_BgProperty p ").append(" left join T_MBG_BgPropertySort sort on sort.fid = p.FBgPropertySortID ").append(" left join T_MBG_PropertyRefSource source on source.FPropertyid = p.fid ").append(" left join " + tableName + " member on member.fid = source.fSourceid ").append(" where member." + viewName + " = '" + viewId + "' ");
        if (!StringUtils.isEmpty((String)quickText)) {
            sql.append(" and (pNumber like '%" + quickText + "%' or pName like '%" + quickText + "%' ) ");
        }
        sql.append(" order by sNumber ASC, pLongNumber ASC ");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BgPropertyCollection colls = new BgPropertyCollection();
        BgPropertyInfo info = null;
        BgPropertySortInfo sInfo = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                info = new BgPropertyInfo();
                sInfo = new BgPropertySortInfo();
                info.setId(BOSUuid.read((String)rst.getString("pId")));
                info.setNumber(rst.getString("pNumber"));
                info.setName(rst.getString("pName"));
                info.setLongNumber(rst.getString("pLongNumber"));
                info.setIsLeaf(rst.getBoolean("pIsLeaf"));
                info.setLevel(rst.getInt("pLevel"));
                sInfo.setId(BOSUuid.read((String)rst.getString("sId")));
                sInfo.setNumber(rst.getString("sNumber"));
                sInfo.setName(rst.getString("sName"));
                info.setBgPropertySort(sInfo);
                colls.add(info);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException(ex.getMessage());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return colls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _loadfromDB(Context ctx, BOSUuid bgSchemeId, BOSUuid bgOrgViewId, BOSUuid orgUnitId, List fieldDatas, Map filterDatas, BgFormInfo bgFormInfo, BgProcessEnum finalSelProcessType) throws BOSException, EASBizException {
        ArrayList<Object> combins = new ArrayList<Object>();
        if (ctx == null || bgSchemeId == null || orgUnitId == null || fieldDatas == null || fieldDatas.isEmpty()) {
            return combins;
        }
        Connection conn = null;
        IRowSet rst = null;
        BgSchemeInfo schemeInfo = null;
        BgOrgUnitInfo bgOrgUnit = null;
        String[] tmpStrs = null;
        String[] refFields = null;
        try {
            block74: {
                ArrayList<String> orgUnitIds;
                BgSchemeAccIntHelper accIntHelper;
                String refCube;
                block77: {
                    block76: {
                        block73: {
                            conn = this.getConnection(ctx);
                            schemeInfo = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), bgSchemeId);
                            refCube = this.getRefCubeByProcessType(finalSelProcessType, schemeInfo);
                            if (schemeInfo == null) break block74;
                            accIntHelper = new BgSchemeAccIntHelper(ctx, bgSchemeId.toString(), schemeInfo.getRefCube());
                            if (bgOrgViewId == null) {
                                bgOrgViewId = schemeInfo.getEditOrgViewId();
                            }
                            bgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), bgOrgViewId, orgUnitId);
                            String[] mbgOrgTables = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)schemeInfo.getEditOrgViewId(), (BOSUuid)orgUnitId, null);
                            String mbgOrgFact = null;
                            if (mbgOrgTables != null && StringUtils.isEmpty((String)(mbgOrgFact = mbgOrgTables[2]))) {
                                mbgOrgFact = mbgOrgTables[0];
                            }
                            boolean isSelectC01 = BgProcessEnum.C01.equals((Object)bgFormInfo.getProcessType()) || BgProcessEnum.C01.equals((Object)finalSelProcessType);
                            orgUnitIds = new ArrayList<String>();
                            if (!isSelectC01) break block76;
                            try {
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FOrgUnitId from T_MBG_BgOrgUnit where FViewId = ? and (FLongNumber = ? or FLongNumber like ?)", (Object[])new Object[]{bgOrgViewId.toString(), bgOrgUnit.getLongNumber(), bgOrgUnit.getLongNumber() + "!%"});
                                while (rst.next()) {
                                    orgUnitIds.add(rst.getString(1));
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                                boolean hasIgnore = false;
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select top 1 FID from T_MBG_BgOrgUnit where FViewID = ? and FPolAlgorithm = 3", (Object[])new Object[]{bgOrgViewId.toString()});
                                if (rst.next()) {
                                    hasIgnore = true;
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                                if (!hasIgnore || mbgOrgTables == null || mbgOrgTables[1] == null) break block73;
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FChildID from " + mbgOrgTables[1] + " where FID in (select FOrgUnitID from T_MBG_BgOrgUnit where FViewID = ? and FPolAlgorithm = " + 3 + " and FLongNumber like ?)"), (Object[])new Object[]{bgOrgViewId.toString(), bgOrgUnit.getLongNumber() + "!%"});
                                while (rst.next()) {
                                    orgUnitIds.remove(rst.getString(1));
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rst);
                                throw throwable;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                        break block77;
                    }
                    orgUnitIds.add(bgFormInfo.getBizOrgUnit().getId().toString());
                }
                if (!orgUnitIds.isEmpty()) {
                    refFields = (String[])fieldDatas.get(0);
                    ArrayList<String> refFieldList = new ArrayList<String>(Arrays.asList(refFields));
                    if (refFields != null && refFields.length > 0) {
                        combins.add(refFields);
                        StringBuffer sql = new StringBuffer();
                        StringBuffer fields = new StringBuffer();
                        StringBuffer join = new StringBuffer();
                        StringBuffer order = new StringBuffer();
                        HashSet<String> memberSet = new HashSet<String>();
                        int in = fieldDatas.size();
                        for (int i = 1; i < in; ++i) {
                            tmpStrs = (String[])fieldDatas.get(i);
                            if (tmpStrs != null) {
                                sql.setLength(0);
                                int jn = tmpStrs.length;
                                for (int j = 0; j < jn; ++j) {
                                    sql.append(tmpStrs[j] + ",");
                                }
                                memberSet.add(sql.toString());
                            }
                            combins.add(tmpStrs);
                        }
                        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
                        String tmpStr = null;
                        String tmpOrgUnit = null;
                        String tmpIndex = null;
                        String tmpPeriod = null;
                        String tmpElement = null;
                        String tmpCurrency = null;
                        String tmpScen = null;
                        String tmpVersion = null;
                        ArrayList tmpList = new ArrayList();
                        ArrayList<String> tmpTables = new ArrayList<String>();
                        try {
                            tmpOrgUnit = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT)");
                            tmpTables.add(tmpOrgUnit);
                            if (accIntHelper.isUseAccInt()) {
                                accIntHelper.insertToTmpTable(conn, tmpOrgUnit, new HashSet<String>(orgUnitIds), DimensionConstants.DEF_ORGUNIT_FIELD, true);
                            } else {
                                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnit + "(FID) values (?)"), orgUnitIds);
                            }
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_BGINDEX_FIELD)) {
                                tmpIndex = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntId INT)");
                                tmpTables.add(tmpIndex);
                                if (accIntHelper.isUseAccInt()) {
                                    accIntHelper.insertToTmpTable(conn, tmpIndex, (Set)filterDatas.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), DimensionConstants.DEF_BGINDEX_FIELD, false);
                                } else {
                                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpIndex + "(FNumber) values (?)"), (Collection)((Set)filterDatas.get(DimensionBaseConstants.DEF_BGINDEX_FIELD)));
                                }
                            }
                            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc((Set)filterDatas.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_PERIOD_FIELD)) {
                                tmpPeriod = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT NOT NULL)");
                                tmpTables.add(tmpPeriod);
                                tmpList.clear();
                                tmpList.addAll((Set)filterDatas.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
                                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID, FIntID) select FID, FIntId from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                                BgDBUtils.executeUpdate((Connection)conn, (String)("Insert Into " + tmpPeriod + " (FID, FIntID) select FID, FIntId from T_MBG_BgPeriod where FYear IN (select FYear from T_MBG_BgPeriod where FID IN (select FID from " + tmpPeriod + "))"));
                            }
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_ELEMENT_FIELD)) {
                                tmpElement = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FIntId INT NOT NULL)");
                                tmpTables.add(tmpElement);
                                tmpList.clear();
                                tmpList.addAll((Set)filterDatas.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
                                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpElement + " (FID, FIntId) select FID, FIntId from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            }
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_CURRENCY_FIELD)) {
                                tmpCurrency = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                                tmpTables.add(tmpCurrency);
                                tmpList.clear();
                                tmpList.addAll((Set)filterDatas.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
                                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            }
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_SCENARIO_FIELD)) {
                                tmpScen = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpScen);
                                tmpList.clear();
                                tmpList.addAll((Set)filterDatas.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
                                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpScen + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            }
                            if (filterDatas != null && filterDatas.containsKey(DimensionBaseConstants.DEF_VERSION_FIELD)) {
                                tmpVersion = BgDBUtils.createDBTmpTable((Connection)conn, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                                tmpTables.add(tmpVersion);
                                tmpList.clear();
                                tmpList.addAll((Set)filterDatas.get(DimensionBaseConstants.DEF_VERSION_FIELD));
                                BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + tmpVersion + " (FID) select FVersionId from T_MBG_BgVersion where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
                            }
                            for (String cubeName : cubeNames) {
                                int i;
                                fields.setLength(0);
                                join.setLength(0);
                                order.setLength(0);
                                sql.setLength(0);
                                sql.append("select distinct ");
                                int in2 = refFields.length;
                                for (i = 0; i < in2; ++i) {
                                    if (DimensionBaseConstants.DEF_ORGUNIT_FIELD.equals(refFields[i])) continue;
                                    if (DimensionConstants.DEF_PERIOD_FIELD.equals(refFields[i])) {
                                        fields.append("pd.FNumber " + refFields[i] + ", ");
                                        if (accIntHelper.isUseAccInt()) {
                                            join.append(" Inner Join T_MBG_BgPeriod pd ON pd.FIntID = t.FBgPeriodId");
                                        } else {
                                            join.append(" Inner Join T_MBG_BgPeriod pd ON pd.FID = t.FBgPeriodId");
                                        }
                                        order.append("pd.FNumber, ");
                                        continue;
                                    }
                                    if (DimensionConstants.DEF_ELEMENT_FIELD.equals(refFields[i])) {
                                        fields.append("em.FNumber " + refFields[i] + ", ");
                                        if (accIntHelper.isUseAccInt()) {
                                            join.append(" Inner Join T_MBG_BgElement em ON em.FIntID = t.FBgElementId");
                                        } else {
                                            join.append(" Inner Join T_MBG_BgElement em ON em.FID = t.FBgElementId");
                                        }
                                        order.append("em.FNumber, ");
                                        continue;
                                    }
                                    if (DimensionConstants.DEF_SCENARIO_FIELD.equals(refFields[i])) {
                                        fields.append("sc.FNumber " + refFields[i] + ", ");
                                        join.append(" Inner Join T_MBG_BgScenario sc ON sc.FScenarioID = t.FScenario");
                                        order.append("sc.FNumber, ");
                                        continue;
                                    }
                                    if (DimensionConstants.DEF_CURRENCY_FIELD.equals(refFields[i])) {
                                        fields.append("cc.FNumber " + refFields[i] + ", ");
                                        join.append(" Inner Join T_BD_Currency cc ON cc.FID = t.FCurrencyID");
                                        order.append("cc.FNumber, ");
                                        continue;
                                    }
                                    if (DimensionConstants.DEF_VERSION_FIELD.equals(refFields[i])) {
                                        fields.append("vv.FNumber " + refFields[i] + ", ");
                                        join.append(" Inner Join T_MBG_BgVersion vv ON vv.FVersionID = t.FVersion");
                                        order.append("vv.FNumber, ");
                                        continue;
                                    }
                                    fields.append("t." + refFields[i] + ", ");
                                    order.append("t." + refFields[i] + ", ");
                                }
                                if (fields.length() > 0) {
                                    fields.setLength(fields.length() - 2);
                                }
                                if (order.length() > 0) {
                                    order.setLength(order.length() - 2);
                                }
                                if (accIntHelper.isUseAccInt()) {
                                    sql.append(fields).append(" from " + cubeName + " t ").append(join).append(" where exists (select FIntID from " + tmpOrgUnit + " where FIntID = t.FOrgUnitId)");
                                } else {
                                    sql.append(fields).append(" from " + refCube + " t ").append(join).append(" where exists (select FID from " + tmpOrgUnit + " where FID = t.FOrgUnitId)");
                                }
                                if (tmpIndex != null) {
                                    if (accIntHelper.isUseAccInt()) {
                                        sql.append(" and exists (select FIntId from " + tmpIndex + " where FIntID = t.F2)");
                                    } else {
                                        sql.append(" and exists (select FNumber from " + tmpIndex + " where FNumber = t.F2)");
                                    }
                                }
                                if (tmpPeriod != null) {
                                    if (accIntHelper.isUseAccInt()) {
                                        sql.append(" and exists (select FIntID from " + tmpPeriod + " where FIntID = t.FBgPeriodID)");
                                    } else {
                                        sql.append(" and exists (select FID from " + tmpPeriod + " where FID = t.FBgPeriodID)");
                                    }
                                }
                                if (tmpElement != null) {
                                    if (accIntHelper.isUseAccInt()) {
                                        sql.append(" and exists (select FIntID from " + tmpElement + " where FIntID = t.FBgElementID)");
                                    } else {
                                        sql.append(" and exists (select FID from " + tmpElement + " where FID = t.FBgElementID)");
                                    }
                                }
                                if (tmpCurrency != null) {
                                    sql.append(" and exists (select FID from " + tmpCurrency + " where FID = t.FCurrencyID)");
                                }
                                if (tmpScen != null) {
                                    sql.append(" and exists (select FID from " + tmpScen + " where FID = t.FScenario)");
                                }
                                if (tmpVersion != null) {
                                    sql.append(" and exists (select FID from " + tmpVersion + " where FID = t.FVersion)");
                                }
                                sql.append(" order by ").append(order);
                                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
                                logger.info((Object)("refFieldList\uff1a" + ((Object)refFieldList).toString()));
                                while (rst.next()) {
                                    tmpStrs = new String[refFields.length];
                                    sql.setLength(0);
                                    in2 = rst.getMetaData().getColumnCount();
                                    for (i = 0; i < in2; ++i) {
                                        int index = refFieldList.indexOf(rst.getMetaData().getColumnName(i + 1));
                                        if (index == -1) {
                                            index = refFieldList.indexOf(rst.getMetaData().getColumnName(i + 1).toUpperCase());
                                        }
                                        logger.info((Object)("index:" + index + "Column :" + (i + 1) + " ColumnName: " + rst.getMetaData().getColumnName(i + 1)));
                                        tmpStrs[index] = DimUtils.getNumber(rst.getString(i + 1));
                                        if (accIntHelper.isUseAccInt()) {
                                            tmpStrs[index] = DimUtils.getNumber(accIntHelper.convertString(rst.getMetaData().getColumnName(i + 1).toUpperCase(), tmpStrs[index]));
                                        }
                                        sql.append(tmpStrs[index] + ",");
                                    }
                                    tmpStr = sql.toString();
                                    if (memberSet.contains(tmpStr)) continue;
                                    memberSet.add(tmpStr);
                                    combins.add(tmpStrs);
                                }
                                SQLUtils.cleanup((ResultSet)rst);
                            }
                        }
                        finally {
                            SQLUtils.cleanup((ResultSet)rst);
                            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpTables);
                        }
                    }
                }
            }
            if (!combins.isEmpty() && combins.size() > 1) {
                int i;
                HashMap queryMap = new HashMap();
                HashMap<String, Boolean> queryByName = new HashMap<String, Boolean>();
                Map<String, MbgDimInfo> fieldMap = DimUtils.getDimInfoByField(DimUtils.getDimensionColls(conn, ctx.getLocale()));
                refFields = (String[])combins.get(0);
                String dimNumber = null;
                int in = refFields.length;
                for (i = 0; i < in; ++i) {
                    HashMap tmp = new HashMap();
                    tmp.put(0, new HashSet());
                    dimNumber = DimensionFormulaHelper.getDefaultDimNumberByField(refFields[i]);
                    if (StringUtils.isEmpty((String)dimNumber)) {
                        dimNumber = fieldMap.get(refFields[i]).getNumber();
                    }
                    queryMap.put(dimNumber, tmp);
                    queryByName.put(dimNumber, false);
                }
                in = combins.size();
                for (i = 1; i < in; ++i) {
                    tmpStrs = (String[])combins.get(i);
                    int jn = tmpStrs.length;
                    for (int j = 0; j < jn; ++j) {
                        dimNumber = DimensionFormulaHelper.getDefaultDimNumberByField(refFields[j]);
                        if (StringUtils.isEmpty((String)dimNumber)) {
                            dimNumber = fieldMap.get(refFields[j]).getNumber();
                        }
                        ((Set)((Map)queryMap.get(dimNumber)).get(0)).add(tmpStrs[j]);
                    }
                }
                Map members = MBGViewListFormFacadeFactory.getLocalInstance(ctx).queryExistingMember(bgSchemeId.toString(), orgUnitId.toString(), queryMap, queryByName);
                if (members != null && !members.isEmpty()) {
                    ArrayList<Object[]> _members = new ArrayList<Object[]>();
                    _members.add(refFields);
                    BgDimensionMember[] _member = null;
                    int in3 = combins.size();
                    for (int i2 = 1; i2 < in3; ++i2) {
                        tmpStrs = (String[])combins.get(i2);
                        _member = new BgDimensionMember[tmpStrs.length];
                        boolean isEmpty = false;
                        int jn = tmpStrs.length;
                        for (int j = 0; j < jn; ++j) {
                            dimNumber = DimensionFormulaHelper.getDefaultDimNumberByField(refFields[j]);
                            if (StringUtils.isEmpty((String)dimNumber)) {
                                dimNumber = fieldMap.get(refFields[j]).getNumber();
                            }
                            if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) continue;
                            _member[j] = (BgDimensionMember)((Map)members.get(dimNumber)).get(tmpStrs[j]);
                            if (_member[j] != null) continue;
                            isEmpty = true;
                        }
                        if (isEmpty) continue;
                        _members.add(_member);
                    }
                    combins.clear();
                    combins.addAll(_members);
                }
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rst, null, (Connection)conn);
        }
        return combins;
    }

    private String getRefCubeByProcessType(BgProcessEnum finalSelProcessType, BgSchemeInfo schemeInfo) {
        String refCube = null;
        refCube = BgProcessEnum.C02.equals((Object)finalSelProcessType) ? BgCubeUtils.getDecomposeCubeName(schemeInfo.getRefCube()) : (BgProcessEnum.C04.equals((Object)finalSelProcessType) ? BgCubeUtils.getDecomposeGatherCubeName(schemeInfo.getRefCube()) : schemeInfo.getRefCube());
        return refCube;
    }
}

