/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.RptSrcTypeEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgNEditUIHandler;
import java.util.HashSet;

public class BgNEditUIHandler
extends AbstractBgNEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        SelectorItemCollection sic;
        super._handleInit(request, response, context);
        OrgUnitInfo unitInfo = (OrgUnitInfo)request.get(BgBaseConstants.ORGUNIT_INFO);
        if (unitInfo == null) {
            return;
        }
        String orgUnitId = unitInfo.getId().toString();
        String userId = (String)request.get("USER_ID");
        Integer type = (Integer)request.get("BGFORMINFO_TYPE");
        if ("ADDNEW".equals(request.getState())) {
            BgFormInfo bgFormInfo = new BgFormInfo();
            if (type != null) {
                bgFormInfo.setSourceType(RptSrcTypeEnum.getEnum((int)type));
            } else {
                bgFormInfo.setSourceType(RptSrcTypeEnum.PT_BUDGET_REPORT);
            }
            bgFormInfo.setName("");
            boolean hasCode = false;
            boolean hasShow = false;
            hasCode = BgCodeNumberNHelper.hasCodeNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId, (String)"sourceType");
            if (hasCode) {
                hasShow = BgCodeNumberNHelper.hasDisplayNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId, (String)"sourceType");
                if (hasShow) {
                    BgCodeNumberNHelper.applyNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId, (String)"sourceType");
                }
            } else {
                hasCode = BgCodeNumberNHelper.hasCodeNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId);
                if (hasCode && (hasShow = BgCodeNumberNHelper.hasDisplayNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId))) {
                    BgCodeNumberNHelper.applyNumber((Context)context, (IObjectValue)bgFormInfo, (String)orgUnitId);
                }
            }
            sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            sic.add("longnumber");
            sic.add("isCompanyOrgUnit");
            FullOrgUnitInfo tempOrg = FullOrgUnitFactory.getLocalInstance((Context)context).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(unitInfo.getId().toString()), sic);
            this.getCompanyByOrgUnit(context, (OrgUnitInfo)tempOrg);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        view.setFilter(filter);
        BgSchemeFactory.getLocalInstance(context).getBgSchemeCollection(view);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.setFilter(filter);
        CurrencyFactory.getLocalInstance((Context)context).getCurrencyCollection(view, true);
        this.getBaseCurrency(context, BOSUuid.read((String)orgUnitId));
        view = new EntityViewInfo();
        filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        view.setFilter(filter);
        sic = new SorterItemCollection();
        SorterItemInfo sort = new SorterItemInfo("number");
        sic.add(sort);
        view.setSorter((SorterItemCollection)sic);
        BgElementFactory.getLocalInstance((Context)context).getBgElementCollection(view);
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        view.setFilter(filter);
        view.getSorter().add(new SorterItemInfo("coefficient"));
        MeasureUnitFactory.getLocalInstance((Context)context).getMeasureUnitCollection(view);
    }

    private CompanyOrgUnitInfo getCompanyByOrgUnit(Context ctx, OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(ctx, parent);
        }
        return null;
    }

    private SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("accountPeriodType.id");
        return sic;
    }

    private void getBaseCurrency(Context ctx, BOSUuid orgUnitId) {
        if (ctx == null || orgUnitId == null) {
            return;
        }
        ObjectUuidPK pk = null;
        IFullOrgUnit iFullOrgUnit = null;
        try {
            iFullOrgUnit = FullOrgUnitFactory.getLocalInstance((Context)ctx);
            if (iFullOrgUnit == null) {
                return;
            }
            pk = new ObjectUuidPK(orgUnitId);
            FullOrgUnitInfo orgUnitInfo = iFullOrgUnit.getFullOrgUnitInfo((IObjectPK)pk);
            if (orgUnitInfo != null && orgUnitInfo.isIsCompanyOrgUnit()) {
                this.getOrgBaseCurrency(ctx, orgUnitInfo.getId());
            } else {
                this.getBaseCurrency(ctx, orgUnitInfo.getParent().getId());
            }
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }

    private void getOrgBaseCurrency(Context ctx, BOSUuid orgUnitId) {
        if (ctx == null || orgUnitId == null) {
            return;
        }
        ObjectUuidPK pk = null;
        ICompanyOrgUnit iCompany = null;
        try {
            iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            if (iCompany == null) {
                return;
            }
            pk = new ObjectUuidPK(orgUnitId);
            iCompany.getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        catch (BOSException bOSException) {
        }
        catch (EASBizException eASBizException) {
            // empty catch block
        }
    }
}

