/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.bos.workflow.service.ormrpc.IEnactmentService;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionCollection;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.BgPeriodHelper;
import com.kingdee.eas.ma.mbg.BgAdjustFacadaFactory;
import com.kingdee.eas.ma.mbg.BgAuditIdeaEnum;
import com.kingdee.eas.ma.mbg.BgCourseCommentFactory;
import com.kingdee.eas.ma.mbg.BgCourseCommentInfo;
import com.kingdee.eas.ma.mbg.BgCourseOperateEnum;
import com.kingdee.eas.ma.mbg.BgFormAuditFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormExportException;
import com.kingdee.eas.ma.mbg.BgFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgNFormFacadeFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgPastRecordFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgAdjustFacada;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormFacade;
import com.kingdee.eas.ma.mbg.IBgPastRecord;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.app.AbstractBgNFormFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.data.IMbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgDataFacade;
import com.kingdee.eas.ma.mbg.app.data.MbgTmpDataUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgDataHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgFormExportServerThread;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.query.AdjustData;
import com.kingdee.eas.ma.mbg.cube.query.IDimData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgDataSynStateBizHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityData;
import com.kingdee.eas.ma.mbg.utils.BgFormDiversityHelper;
import com.kingdee.eas.ma.mbg.utils.BgFormWorkFlowInfo;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.data.BizDataControlUtils;
import com.kingdee.eas.ma.mbg.utils.data.BizMbgDataControlUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class BgNFormFacadeControllerBean
extends AbstractBgNFormFacadeControllerBean {
    private static final long serialVersionUID = 5144756522180794088L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgNFormFacadeControllerBean");
    private static final String PERMISSION_STR = "mbg_form01_list";

    private String outTime(long startTime, long beginTime, long endTime) {
        return new StringBuffer("invoke process use = ").append(endTime - beginTime).append(" ms; alluse = ").append(endTime - startTime).append(" ms;").toString();
    }

    @Override
    protected void _getBudgetSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null || !(model instanceof BgFormInfo)) {
            return;
        }
        Set<String> budgetScens = new DimensionCacheHelper(ctx).getBudgetScens();
        long _startTime = 0L;
        long _beginTime = 0L;
        long _endTime = 0L;
        _beginTime = _startTime = System.currentTimeMillis();
        _endTime = _startTime;
        logger.info((Object)"invoke begin save bgData!");
        final BgFormInfo bgFormInfo = (BgFormInfo)model;
        BOSUuid bgFormId = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        String formulaStr = null;
        String _sheetName = null;
        BigDecimal budgetValue = null;
        HashSet<String> exprFormulas = new HashSet<String>();
        final BgDataHelper _helper = new BgDataHelper(ctx);
        _helper.setDataType(bgFormInfo.getDataType());
        _helper.setRootSchemeInfo(BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgFormInfo.getBgScheme()));
        if (_helper.getRootSchemeInfo() == null || StringUtils.isEmpty((String)_helper.getRootSchemeInfo().getRefCube())) {
            throw new BgFormException(BgFormException.CHECKCUBEERROR);
        }
        try {
            bgFormId = bgFormInfo.getId();
            if (bgFormInfo.getZipData() == null || bgFormInfo.getZipData().length == 0) {
                throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"data"});
            }
            HashSet oldFormulas = new HashSet();
            if (bgFormInfo.getId() != null) {
                BgFormCollection col = BgFormFactory.getLocalInstance(ctx).getBgFormCollection("select data where id = '" + bgFormInfo.getId() + "'");
                List formulaList = null;
                if (col != null && !col.isEmpty() && col.get(0).getZipData() != null) {
                    formulaList = BgNFSHelper.getFormulaListOfBook(col.get(0).getBook());
                }
                if (formulaList != null) {
                    oldFormulas.addAll(formulaList);
                }
            }
            _book = bgFormInfo.getBook();
            BgNFSHelper.disableCal(_book);
            BgNFSHelper.disableUndo(_book);
            int _sheetSize = _book.getSheetCount();
            for (int _sheetIndex = 0; _sheetIndex < _sheetSize; ++_sheetIndex) {
                _sheet = _book.getSheet(_sheetIndex);
                _sheetName = _sheet.getSheetName();
                if (!StringUtils.isEmpty((String)_sheetName)) {
                    _sheetName = _sheetName.length() > 80 ? _sheetName.substring(1, 80) : "";
                }
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        if (!BgNFSHelper.checkHasFormulaOfCell(_cell)) continue;
                        formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        oldFormulas.remove(formulaStr);
                        if (!budgetScens.contains(BgNFSHelper.parseFormulaPara(formulaStr)[3]) || _cell.isLocked() && !BgNFSHelper.checkHasExpression(_cell) && !bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C04)) continue;
                        if (BgNFSHelper.checkHasExpression(_cell)) {
                            exprFormulas.add(BgNFSHelper.getFormulaOfCell(_cell));
                        } else if (exprFormulas.contains(formulaStr)) continue;
                        try {
                            budgetValue = BgViewHelper.getNumeric(_cell, null);
                        }
                        catch (Exception ex) {
                            budgetValue = BgNConstants.ZERO;
                        }
                        _helper.addBgDataInfo(_cell, formulaStr, bgFormInfo.getBgVersion().getNumber(), budgetValue, exprFormulas);
                    }
                }
            }
            if (!oldFormulas.isEmpty()) {
                StringBuffer sql = new StringBuffer();
                String cubeName = BgCubeUtils.getCubeName(_helper.getRootSchemeInfo().getRefCube(), _helper.getDataType());
                String cubeEntry = BgCubeUtils.getCubeEntryName(_helper.getRootSchemeInfo().getRefCube(), _helper.getDataType());
                sql.append("select fformula from ").append(cubeName).append(" t0 where forgunitid = ? ").append("and exists(Select fdataid from ").append(cubeEntry).append(" t1 where t1.fformid = ? and t0.fid = t1.fdataid) ").append("and not exists(Select fdataid from ").append(cubeEntry).append(" t2 where t2.fformid <> ? and t0.fid = t2.fdataid) ").append("and fformula in(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgFormInfo.getOrgUnit().getId().toString(), bgFormId.toString(), bgFormId.toString()}, (Object[])oldFormulas.toArray(), (int)50), (IResultReader)new IResultReader(){

                    public void read(ResultSet res) throws SQLException {
                        try {
                            _helper.addBgDataInfo(null, res.getString(1), bgFormInfo.getBgVersion().getNumber(), null, null);
                        }
                        catch (EASBizException e) {
                            logger.error((Object)" ", (Throwable)e);
                        }
                    }
                });
                sql.setLength(0);
                sql.append("delete from ").append(cubeEntry).append(" where fformid = ? and exists(select fid from ").append(cubeName).append(" where ").append(cubeName).append(".FID = ").append(cubeEntry).append(".FDataId and fformula = ?)");
                DbUtil.executeBatch((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgFormId.toString()}, (Object[])oldFormulas.toArray(), (int)1));
            }
            Object[] _objs = _helper.compareBgDataInfo(ctx, bgFormInfo);
            _helper.disposeBgDataValue(ctx, bgFormInfo, _objs);
            BgFacadeHelper.saveGatherInfos(ctx, (List)bgFormInfo.get("GATHER_FORMULA"));
            this.updateSheetName(ctx, bgFormId.toString(), _book);
            bgFormInfo.setBook(_book);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        _endTime = System.currentTimeMillis();
        logger.info((Object)"invoke end save bgData!");
        logger.info((Object)this.outTime(_startTime, _beginTime, _endTime));
    }

    @Override
    protected List _singleCourse(Context ctx, BOSUuid bgFormId, BOSUuid orgUnitId, BOSUuid userId) throws BOSException, EASBizException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId.toString());
        return this._course(ctx, bgFormIds, orgUnitId == null ? null : orgUnitId.toString(), userId == null ? null : userId.toString());
    }

    @Override
    protected List _singleApprove(Context ctx, BOSUuid bgFormId, BOSUuid orgUnitId, BOSUuid userId) throws BOSException, EASBizException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId.toString());
        return this._approve(ctx, bgFormIds, orgUnitId, userId);
    }

    @Override
    protected List _singleAntiApprove(Context ctx, BOSUuid bgFormId, BOSUuid orgUnitId, BOSUuid userId) throws BOSException, EASBizException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId.toString());
        return this._antiApprove(ctx, bgFormIds, orgUnitId, userId);
    }

    @Override
    protected Map _singleBack(Context ctx, BOSUuid bgFormId, BOSUuid orgUnitId, BOSUuid userId) throws BOSException, EASBizException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId.toString());
        return this._back(ctx, bgFormIds, userId == null ? null : userId.toString(), orgUnitId == null ? null : orgUnitId.toString());
    }

    @Override
    protected Map _singleConfirm(Context ctx, BOSUuid bgFormId, BOSUuid orgUnitId, BOSUuid userId) throws BOSException, EASBizException {
        ArrayList<String> bgFormIds = new ArrayList<String>();
        bgFormIds.add(bgFormId.toString());
        return this._confirm(ctx, bgFormIds, userId == null ? null : userId.toString(), orgUnitId);
    }

    @Override
    protected void _getAdjustSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx == null || model == null) {
            return;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        Map<String, BgFormDiversityData> adjustMap = this.checkTmpData(ctx, bgFormInfo);
        this.savaAdjustData(ctx, bgFormInfo, adjustMap);
    }

    @Override
    protected void _savaAdjustData(Context ctx, IObjectValue model, Map adjustDataMap) throws BOSException, EASBizException {
        if (ctx == null || model == null || adjustDataMap == null) {
            return;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        this.savaAdjustData(ctx, bgFormInfo, (Map<String, BgFormDiversityData>)adjustDataMap);
    }

    private Map<String, BgFormDiversityData> checkTmpData(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (ctx == null || bgFormInfo == null) {
            return null;
        }
        Book _book = null;
        try {
            _book = bgFormInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)"_getAdjustSheet error:", (Throwable)e);
        }
        BgNFSHelper.disableCal(_book);
        BgNFSHelper.disableUndo(_book);
        HashMap<String, BgFormDiversityData> adjustMap = new HashMap<String, BgFormDiversityData>();
        Map<String, IDimData> initValueMap = null;
        initValueMap = bgFormInfo.getState().equals((Object)BgFormStateEnum.RollEdited) ? MbgTmpDataUtils.queryTmpDataBySchemeAndOrg(ctx, bgFormInfo) : MbgTmpDataUtils.queryTmpDataByBgForm(ctx, bgFormInfo);
        HashMap<String, Timestamp> lastUpdateTimeMap = new HashMap<String, Timestamp>();
        BgFormDiversityHelper.updateChangeValueInfo(_book, initValueMap, adjustMap, lastUpdateTimeMap);
        if (bgFormInfo.getState().equals((Object)BgFormStateEnum.RollEdited)) {
            this.filterBgAdjustMapByState(initValueMap, adjustMap);
        }
        HashSet<String> oldAdjust = new HashSet<String>();
        IRowSet rst = null;
        try {
            rst = DbUtil.executeQuery((Context)ctx, (String)"Select FFormula FROM T_MBG_BgTmpData Where FID IN(Select FDataId FROM T_MBG_BgTmpDataEntry Where FFormId = ?)", (Object[])new Object[]{bgFormInfo.getAdjust().getId().toString()});
            while (rst.next()) {
                oldAdjust.add(rst.getString("FFormula"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (!oldAdjust.isEmpty()) {
            oldAdjust.removeAll(BgNFSHelper.getFormulaListOfBook(_book));
        }
        if (!oldAdjust.isEmpty()) {
            IDimData dimData = null;
            BigDecimal newValue = null;
            Object oldValue = null;
            for (String formula : oldAdjust) {
                if (!initValueMap.containsKey(formula)) continue;
                dimData = initValueMap.get(formula);
                newValue = dimData.getState() == 5 ? null : dimData.getOldValue();
                BgFormDiversityHelper.createDivInfo(null, formula, newValue, newValue, adjustMap);
            }
        }
        HashMap<String, HashMap<String, BgFormDiversityData>> adjustDataMap = new HashMap<String, HashMap<String, BgFormDiversityData>>();
        HashSet<String> formIdSet = new HashSet<String>();
        if (bgFormInfo.getOrgUnit() != null && bgFormInfo.getOrgUnit().getId() != null) {
            adjustDataMap.put(bgFormInfo.getOrgUnit().getId().toString(), adjustMap);
        }
        if (bgFormInfo.getAdjust() != null && bgFormInfo.getAdjust().getId() != null) {
            formIdSet.add(bgFormInfo.getAdjust().getId().toString());
        }
        MbgTmpDataUtils.checkTmpData(ctx, bgFormInfo, adjustDataMap, formIdSet);
        return adjustMap;
    }

    private void filterBgAdjustMapByState(Map<String, IDimData> initValueMap, Map<String, BgFormDiversityData> adjustMap) {
        if (initValueMap == null || adjustMap == null) {
            return;
        }
        HashSet<String> filterFormulas = new HashSet<String>();
        for (Map.Entry<String, IDimData> entry : initValueMap.entrySet()) {
            IDimData value = entry.getValue();
            if (1 != value.getState()) continue;
            filterFormulas.add(entry.getKey());
        }
        for (String filterFormula : filterFormulas) {
            if (!adjustMap.containsKey(filterFormula)) continue;
            adjustMap.remove(filterFormula);
        }
    }

    private void savaAdjustData(Context ctx, BgFormInfo bgFormInfo, Map<String, BgFormDiversityData> adjustMap) throws EASBizException, BOSException {
        if (adjustMap == null || adjustMap.isEmpty()) {
            return;
        }
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String versionNum = bgFormInfo.getBgVersion().getNumber();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        try {
            IMbgDataFacade facade = MbgDataFacade.getInstance(ctx, user.getId().toString(), bgFormInfo.getBgScheme().getId().toString(), DimensionConstants.ADJUST_DATA_TYPE);
            facade.setBillId(bgFormInfo.getAdjust().getId().toString());
            facade.setProcessType(bgFormInfo.getProcessType());
            if (bgFormInfo.get("ignoreDataState") instanceof Boolean && ((Boolean)bgFormInfo.get("ignoreDataState")).booleanValue()) {
                facade.setIgnoreDataState(Boolean.TRUE);
            }
            AdjustData adjustData = null;
            BgFormDiversityData diverInfo2 = null;
            for (BgFormDiversityData diverInfo2 : adjustMap.values()) {
                adjustData = new AdjustData();
                adjustData.setOrgUnitId(orgUnitId);
                adjustData.setFormula(diverInfo2.getFormula());
                adjustData.setVersionNum(versionNum);
                adjustData.setValue(diverInfo2.getNewValue());
                adjustData.setOldValue(diverInfo2.getOldValue());
                facade.addMbgData(adjustData);
            }
            facade.submit();
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        BgFacadeHelper.saveGatherInfos(ctx, (List)bgFormInfo.get("GATHER_FORMULA"));
    }

    @Override
    protected void _getActualSheet(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return;
        }
        BgFormInfo _bgFormInfo = null;
        Book _book = null;
        Sheet _sheet = null;
        Cell _cell = null;
        boolean hasBgFormula = false;
        int rowIndex = 0;
        int rowCount = 0;
        int colIndex = 0;
        int colCount = 0;
        Object _obj = null;
        String _formulaStr = null;
        String _orgUnitId = null;
        String _bgSchemeId = null;
        String _expression = null;
        BigDecimal _value = null;
        HashMap<String, BigDecimal> formulaMap = new HashMap<String, BigDecimal>();
        _bgFormInfo = (BgFormInfo)model;
        _orgUnitId = _bgFormInfo.getOrgUnit().getId().toString();
        _bgSchemeId = _bgFormInfo.getBgScheme().getId().toString();
        try {
            _book = _bgFormInfo.getBook();
            BgNFSHelper.disableUndo(_book);
            BgNFSHelper.disableCal(_book);
            int sheetSize = _book.getSheetCount();
            for (int sheetIndex = 0; sheetIndex < sheetSize; ++sheetIndex) {
                _sheet = _book.getSheet(sheetIndex);
                rowCount = _sheet.getMaxRowIndex();
                colCount = _sheet.getMaxColIndex();
                for (rowIndex = 0; rowIndex <= rowCount; ++rowIndex) {
                    for (colIndex = 0; colIndex <= colCount; ++colIndex) {
                        _cell = _sheet.getCell(rowIndex, colIndex, false);
                        hasBgFormula = BgNFSHelper.checkHasFormulaOfCell(_cell);
                        _expression = BgNFSHelper.loadExpression(_cell, 0);
                        if (!StringUtils.isEmpty((String)_expression)) {
                            BgNFSHelper.setExpression(_cell, _expression);
                            if (!hasBgFormula) {
                                _obj = BgNFSHelper.getCellData(_cell, "BG_BUDGET_VALUE");
                                BgNFSHelper.setValue(_cell, _obj);
                            }
                        } else if (BgNFSHelper.checkHasExpression(_cell)) {
                            BgNFSHelper.clearExpression(_cell);
                            if (!hasBgFormula) {
                                BgNFSHelper.setValue(_cell, null);
                            }
                        }
                        if (!hasBgFormula) continue;
                        _formulaStr = BgNFSHelper.getFormulaOfCell(_cell);
                        _value = BgNFSHelper.getActualValue(_cell);
                        formulaMap.put(_formulaStr, _value);
                        _value = BgNFSHelper.getBudgetValue(_cell);
                        BgNFSHelper.setValue(_cell, _value);
                    }
                }
            }
            _bgFormInfo.setBook(_book);
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void updateActualValue(Context ctx, String orgUnitId, String bgSchemeId, Map formulaMap) throws BOSException, EASBizException {
        if (ctx == null || formulaMap == null || formulaMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        String _formulaStr2 = null;
        BigDecimal _value = null;
        int batchIndex = 0;
        int batchSize = 200;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Update T_MBg_BgData set FBgActual=?, FBizActual=? where FOrgUnitId=? AND FBgSchemeId=? AND FFormula=?");
            for (String _formulaStr2 : formulaMap.keySet()) {
                if (_formulaStr2 == null) continue;
                _value = (BigDecimal)formulaMap.get(_formulaStr2);
                pstmt.setBigDecimal(1, _value);
                pstmt.setBigDecimal(2, BgNConstants.ZERO);
                pstmt.setString(3, orgUnitId);
                pstmt.setString(4, bgSchemeId);
                pstmt.setString(5, _formulaStr2);
                pstmt.addBatch();
                if (++batchIndex < batchSize) continue;
                pstmt.executeBatch();
                batchIndex = 0;
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkCanAudit(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        if (bgFormId == null) {
            throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"id"});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String bgFormIdStr = bgFormId.toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where FID = ? and ( FState = ? or FState = ? or FState = ? or FState = ?) ");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormIdStr);
            pstmt.setInt(2, 1);
            pstmt.setInt(3, 4);
            pstmt.setInt(4, 41);
            pstmt.setInt(5, 6);
            rst = pstmt.executeQuery();
            if (!rst.next()) {
                throw new BgNFormException(BgNFormException.CANTAUDITBYSTATE01);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _checkCanAntiAudit(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        block34: {
            block33: {
                if (bgFormId == null) {
                    throw new BgFormException(BgFormException.CHECKBLANK, new String[]{"id"});
                }
                conn = null;
                pstmt = null;
                rst = null;
                bgFormIdStr = bgFormId.toString();
                sql = new StringBuffer();
                sql.append("select FID from T_MBg_BgForm where FID = ? and FState IN (").append(2).append(")");
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    pstmt.setString(1, bgFormIdStr);
                    rst = pstmt.executeQuery();
                    if (!rst.next()) {
                        throw new BgNFormException(BgNFormException.CANTANTIAUDITBYSTATE);
                    }
                    break block33;
                }
                catch (SQLException ex) {
                    try {
                        BgNFormFacadeControllerBean.logger.error((Object)ex.getMessage());
                        throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                        catch (BOSException ex) {
                            throw ex;
                        }
                    }
                    catch (Throwable var13_22) {
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw var13_22;
                    }
                }
                while (true) {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
                    return;
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql = new StringBuffer();
            sql.append("select FID from T_MBg_BgForm where (FAdjustId = ?) and (FState in (4,15)) and (FDataSource = 2)");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgFormIdStr);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    throw new BgNFormException(BgNFormException.CANTANTIAUDITBYADJUST);
                }
                break block34;
            }
            catch (SQLException ex) {
                throw ex;
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (SQLException ex) {
                try {
                    throw ex;
                    catch (EASBizException ex) {
                        throw ex;
                    }
                }
                catch (Throwable var9_18) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw var9_18;
                }
            }
            finally {
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
        }
        sql = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where (FAdjustId = ?) and (FState in (6,15)) and (FDataSource in (13))");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormIdStr);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                throw new BgNFormException(BgNFormException.CANTANTIAUDITBYROLL);
            }
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        sql = new StringBuffer();
        sql.append("select FBgFormId from T_MBg_BgActualRecord where FBgFormId = ?");
        try {
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgFormIdStr);
            if (!(rst = pstmt.executeQuery()).next()) ** continue;
            throw new BgNFormException(BgNFormException.CANTANTIAUDITBYACTUAL);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSheetName(Context ctx, String bgFormId, Book book) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgFormId == null) return;
        if (book == null) {
            return;
        }
        String _Sign = "A1B2C3D4";
        String _sheetId = null;
        String _sheetName = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        Sheet _sheet = null;
        try {
            conn = this.getConnection(ctx);
            try {
                pstmt = conn.prepareStatement("delete from T_MBg_BgSheet where FBgFormId = ?");
                pstmt.setString(1, bgFormId);
                pstmt.executeUpdate();
            }
            catch (SQLException ex) {
                throw ex;
            }
            finally {
                SQLUtils.cleanup((Statement)pstmt);
            }
            pstmt = conn.prepareStatement("Insert Into T_MBg_BgSheet (FID, FBgFormId, FSheetIndex, FSheetID, FSheetName) values (?, ?, ?, ?, ?)");
            int in = book.getSheetCount();
            for (int i = 0; i < in; ++i) {
                _sheet = book.getSheet(i);
                _sheetId = _sheet.getID();
                _sheetName = _sheet.getSheetName();
                pstmt.setString(1, BOSUuid.create((String)_Sign).toString());
                pstmt.setString(2, bgFormId);
                pstmt.setInt(3, i);
                pstmt.setString(4, _sheetId);
                pstmt.setString(5, _sheetName);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException ex) {
            try {
                throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
                catch (Exception ex3) {
                    throw new BOSException((Throwable)ex3);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    protected void _writeBgCtrlRecord(Context ctx, String bgFormId) throws BOSException, EASBizException {
    }

    @Override
    protected List _checkBatchAudit(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        int index;
        ArrayList<String> reList = new ArrayList<String>();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        int batchSize = 200;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_MBg_BgForm where (FState = ").append(1).append(" or FState = ").append(4).append(" or FState = ").append(6).append(" or FState = ").append(41);
        sql.append(") and FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    reList.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    @Override
    protected Map _batchAudit(Context ctx, List bgFormIds, BOSUuid auditUser, BOSUuid auditOrgId) throws BOSException, EASBizException {
        return this._batchAudit(ctx, bgFormIds, auditUser, false, auditOrgId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _batchAudit(Context ctx, List bgFormIds, BOSUuid auditUser, boolean isConfirm, BOSUuid auditOrgId) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return new HashMap();
        }
        this.sortByOrg(ctx, bgFormIds);
        int _state = 0;
        String _bgFormId = null;
        HashMap<String, Object> _batchAuditMap = new HashMap<String, Object>();
        LinkedHashMap _exceptionMap = new LinkedHashMap();
        HashMap<String, Integer> _formStateMap = new HashMap<String, Integer>();
        if (auditUser == null) {
            auditUser = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        int index = 0;
        int batchSize = 200;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FState from T_MBg_BgForm where FID IN (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgFormId = rst.getString(1);
                    _state = rst.getInt(2);
                    _formStateMap.put(_bgFormId, new Integer(_state));
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        HashSet<String> successFormIds = new HashSet<String>();
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
        Iterator iter = bgFormIds.iterator();
        while (iter.hasNext()) {
            _bgFormId = iter.next().toString();
            try {
                if (_formStateMap.containsKey(_bgFormId)) {
                    _state = (Integer)_formStateMap.get(_bgFormId);
                    if (_state == 1 || _state == 41) {
                        this.innerAudit(ctx, BOSUuid.read((String)_bgFormId), auditUser, auditOrgId, successFormIds);
                        ibgFormFacade.submitAuditIdea(BOSUuid.read((String)_bgFormId), auditUser, BgAuditIdeaEnum.AUDITPASS, "");
                        this._writeBgCtrlRecord(ctx, _bgFormId);
                    } else if (_state == 4 || _state == 6) {
                        SelectorItemCollection s = new SelectorItemCollection();
                        s.add("id");
                        s.add("bgType.id");
                        s.add("bgTemplate.id");
                        s.add("bgTemplate.formType");
                        IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
                        BgFormInfo info = ibgform.getBgFormInfo((IObjectPK)new ObjectUuidPK(_bgFormId), s);
                        if (info.getBgTemplate().getFormType().getValue() == 4) {
                            BgAdjustFacadaFactory.getLocalInstance(ctx).audit(_bgFormId);
                            _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                            continue;
                        }
                        boolean bSuccess = ibgFormFacade.auditFormAdjust(BOSUuid.read((String)_bgFormId));
                        if (ibgform == null) {
                            throw new BgFormException(BgFormException.NOINSTANCE);
                        }
                        if (bSuccess) {
                            ObjectUuidPK pk = new ObjectUuidPK(_bgFormId);
                            SelectorItemCollection sic = new SelectorItemCollection();
                            sic.add("id");
                            sic.add("adjust.id");
                            sic.add("state");
                            if (ibgform.exists((IObjectPK)pk)) {
                                BgFormInfo bgAdjustInfo = ibgform.getBgFormInfo((IObjectPK)pk, sic);
                                ibgFormFacade.submitAuditIdea(bgAdjustInfo.getAdjust().getId(), auditUser, BgFormStateEnum.RollEdited.equals((Object)bgAdjustInfo.getState()) ? BgAuditIdeaEnum.ROLLPASS : BgAuditIdeaEnum.ADJUSTPASS, "");
                            }
                        }
                    }
                    if (isConfirm) {
                        IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
                        BgFormInfo formInfo = ibgform.getBgFormInfo("select isConfirm where id = '" + _bgFormId + "'");
                        formInfo.setIsConfirm(true);
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add("isConfirm");
                        ibgform.updatePartial((CoreBaseInfo)formInfo, sic);
                    }
                    _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                    continue;
                }
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
            catch (EASBizException ex) {
                logger.error((Object)"", (Throwable)ex);
                _batchAuditMap.put(_bgFormId, ex.getMessage());
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                if (ex.getCause() instanceof EASBizException) {
                    _batchAuditMap.put(_bgFormId, ex.getCause().getMessage());
                    continue;
                }
                _batchAuditMap.put(_bgFormId, ex.getMessage());
            }
        }
        _formStateMap.clear();
        if (!_batchAuditMap.isEmpty()) {
            HashMap<String, String> idNumbers = new HashMap<String, String>();
            HashMap<String, String> idNnames = new HashMap<String, String>();
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", _batchAuditMap.keySet(), CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("number");
            sic.add("name");
            view.setSelector(sic);
            BgFormCollection collection = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
            for (int i = 0; i < collection.size(); ++i) {
                idNumbers.put(collection.get(i).getId().toString(), collection.get(i).getNumber());
                idNnames.put(collection.get(i).getId().toString(), collection.get(i).getName());
            }
            _batchAuditMap.put("idNumbers", idNumbers);
            _batchAuditMap.put("idNnames", idNnames);
        }
        return _batchAuditMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sortByOrg(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null) return;
        if (bgFormIds.isEmpty()) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmtSelect = null;
        PreparedStatement pstmtDelete = null;
        PreparedStatement pstmtInsert = null;
        ResultSet rst = null;
        String orgViewId2222222 = null;
        String orgUnitId = null;
        String bgFormId = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tableName = null;
        try {
            tableName = pool.createTempTable("Create Table T_Mbg_TmpOrgIds(FOrgUnitId Varchar(44) Not Null)");
            conn = this.getConnection(ctx);
            HashMap viewFormIds = new HashMap();
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgForm.FID, bgForm.FOrgUnitId, bgFormView.FMemberID FROM T_Mbg_BgForm bgForm, T_Mbg_BgDimSettings dimSet, T_MBG_BgDimSettingsMember bgFormView Where bgForm.FBgSchemeId = dimSet.FBgSchemeId AND dimSet.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' AND bgFormView.FBgDimSettingsID = dimSet.FID AND bgForm.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmtSelect = conn.prepareStatement(sql.toString());
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgFormIds.toArray(), (int)50);
            for (int i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmtSelect, (Object[])((Object[])paramList.get(i)));
                rst = pstmtSelect.executeQuery();
                while (rst.next()) {
                    orgViewId2222222 = rst.getString("FMemberID");
                    orgUnitId = rst.getString("FOrgUnitId");
                    bgFormId = rst.getString("FID");
                    if (!viewFormIds.containsKey(orgViewId2222222)) {
                        viewFormIds.put(orgViewId2222222, new HashMap());
                    }
                    if (!((Map)viewFormIds.get(orgViewId2222222)).containsKey(orgUnitId)) {
                        ((Map)viewFormIds.get(orgViewId2222222)).put(orgUnitId, new ArrayList());
                    }
                    ((List)((Map)viewFormIds.get(orgViewId2222222)).get(orgUnitId)).add(bgFormId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmtSelect);
            bgFormIds.clear();
            pstmtDelete = conn.prepareStatement("Delete FROM " + tableName);
            pstmtInsert = conn.prepareStatement("Insert Into " + tableName + "(FOrgUnitId) Values(?)");
            pstmtSelect = conn.prepareStatement("Select FOrgUnitId FROM T_MBg_BgOrgUnit Where FIsVirtual = 0 AND FViewId = ? AND FOrgUnitID IN(Select FOrgUnitId FROM " + tableName + ") Order By FLevel, FLongNumber");
            for (String orgViewId2222222 : viewFormIds.keySet()) {
                pstmtDelete.execute();
                MbgSqlHelper.executeBatchInsert((PreparedStatement)pstmtInsert, new ArrayList(((Map)viewFormIds.get(orgViewId2222222)).keySet()));
                pstmtSelect.setString(1, orgViewId2222222);
                rst = pstmtSelect.executeQuery();
                while (rst.next()) {
                    bgFormIds.addAll((Collection)((Map)viewFormIds.get(orgViewId2222222)).get(rst.getString("FOrgUnitId")));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmtDelete);
                SQLUtils.cleanup(pstmtInsert);
                SQLUtils.cleanup(rst, pstmtSelect, (Connection)conn);
                if (tableName == null) throw throwable;
                pool.releaseTable(tableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmtDelete);
        SQLUtils.cleanup((Statement)pstmtInsert);
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmtSelect, (Connection)conn);
        if (tableName == null) return;
        pool.releaseTable(tableName);
    }

    @Override
    protected Map _batchBasisAudit(Context ctx, List bgFormIds, BOSUuid userId, BOSUuid auditOrgId) throws BOSException, EASBizException {
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return new HashMap();
        }
        String _bgFormId = null;
        BOSUuid _analyseId = BOSUuid.read((String)"bgMAAAAKIcA7rHKd");
        HashSet bgFormIdSet = new HashSet();
        ArrayList<String> batchIdList = new ArrayList<String>();
        ArrayList<String> basisIdList = new ArrayList<String>();
        HashMap<String, Serializable> _batchAuditMap = new HashMap<String, Serializable>();
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = null;
        BgFormCollection collection = null;
        if (userId == null) {
            userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        bgFormIdSet.addAll(bgFormIds);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bgFormIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("state");
        sic.add("bgType.id");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.root.id");
        sic.add("bgTemplate.formType");
        sic.add("bgScheme.id");
        view.setSelector(sic);
        IBgAdjustFacada adjustFacade = BgAdjustFacadaFactory.getLocalInstance(ctx);
        collection = ibgForm.getBgFormCollection(view);
        if (collection != null) {
            int in = collection.size();
            for (int i = 0; i < in; ++i) {
                bgFormInfo = collection.get(i);
                _bgFormId = bgFormInfo.getId().toString();
                if (bgFormInfo.getState().getValue() == 4 && bgFormInfo.getBgTemplate().getFormType().getValue() == 4) {
                    adjustFacade.audit(bgFormInfo.getId().toString());
                    continue;
                }
                if (bgFormInfo.getState().equals((Object)BgFormStateEnum.Edited)) {
                    _batchAuditMap.put(_bgFormId, Boolean.TRUE);
                    if (bgFormInfo.getBgType() != null && _analyseId.equals((Object)bgFormInfo.getBgType().getId())) {
                        batchIdList.add(_bgFormId);
                        continue;
                    }
                    if (bgFormInfo.getBgTemplate().getId().equals((Object)bgFormInfo.getBgTemplate().getRootId())) {
                        batchIdList.add(_bgFormId);
                        continue;
                    }
                    basisIdList.add(_bgFormId);
                    continue;
                }
                _batchAuditMap.put(_bgFormId, Boolean.FALSE);
            }
            collection.clear();
        }
        IBgFormFacade ibgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
        java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=? where FID=?");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            Iterator iter = basisIdList.iterator();
            while (iter.hasNext()) {
                _bgFormId = iter.next().toString();
                pstmt.setInt(1, 3);
                pstmt.setString(2, userId.toString());
                pstmt.setDate(3, date);
                pstmt.setString(4, _bgFormId);
                pstmt.addBatch();
                ibgFormFacade.submitAuditIdea(BOSUuid.read((String)_bgFormId), userId, BgAuditIdeaEnum.AUDITPASS, "");
            }
            int[] sum = pstmt.executeBatch();
            if (sum != null && sum.length > 0) {
                BgDataSynStateBizHelper.updateDataStateBatchByFromIdSet(ctx, basisIdList, true, "OPERATOR_BASISAPPROVED");
            }
            SQLUtils.cleanup((Statement)pstmt);
            Map map = null;
            if (!batchIdList.isEmpty()) {
                map = this._batchAudit(ctx, batchIdList, userId, auditOrgId);
            }
            if (map != null) {
                _batchAuditMap.putAll(map);
            }
            if (!_batchAuditMap.isEmpty()) {
                HashMap<String, String> idNumbers = new HashMap<String, String>();
                HashMap<String, String> idNnames = new HashMap<String, String>();
                view = new EntityViewInfo();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", _batchAuditMap.keySet(), CompareType.INCLUDE));
                view.setFilter(filter);
                sic = new SelectorItemCollection();
                sic.add("id");
                sic.add("number");
                sic.add("name");
                view.setSelector(sic);
                collection = ibgForm.getBgFormCollection(view);
                for (int i = 0; i < collection.size(); ++i) {
                    idNumbers.put(collection.get(i).getId().toString(), collection.get(i).getNumber());
                    idNnames.put(collection.get(i).getId().toString(), collection.get(i).getName());
                }
                _batchAuditMap.put("idNumbers", idNumbers);
                _batchAuditMap.put("idNnames", idNnames);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        return _batchAuditMap;
    }

    protected void _audit(Context ctx, BOSUuid bgFormId, BOSUuid auditUser, BOSUuid auditOrgId) throws BOSException, EASBizException {
        this.innerAudit(ctx, bgFormId, auditUser, auditOrgId, null);
    }

    protected void innerAudit(Context ctx, BOSUuid bgFormId, BOSUuid auditUser, BOSUuid auditOrgId, Set<String> successFormIds) throws BOSException, EASBizException {
        if (bgFormId == null) {
            return;
        }
        if (successFormIds != null && successFormIds.contains(bgFormId.toString())) {
            return;
        }
        String _userId = null;
        _userId = auditUser == null ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : auditUser.toString();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        Connection conn = null;
        PreparedStatement pstmt = null;
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBg_BgForm set FState=?, FAuditorID=?, FAuditedTime=?, FStateBeforeAudit = ? where FID=?");
        BgFormInfo _bgFormInfo = null;
        try {
            conn = this.getConnection(ctx);
            _bgFormInfo = BgViewServerHelper.getBgFormInfo(conn, bgFormId, false);
            if (_bgFormInfo != null) {
                int _state = _bgFormInfo.getState().getValue();
                if (_state != 1 && _state != 41) {
                    throw new BgNFormException(BgNFormException.CANTAUDITBYSTATE);
                }
                BizDataControlUtils utils = new BizDataControlUtils(ctx);
                utils.updateAudOrgUnit(_bgFormInfo.getId(), auditOrgId, auditUser, 1, 9, null, successFormIds, new BgFormStateEnum[]{BgFormStateEnum.Edited, BgFormStateEnum.Back, BgFormStateEnum.Report, BgFormStateEnum.Certificate});
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setInt(1, 2);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, timestamp);
                pstmt.setInt(4, _state);
                pstmt.setString(5, bgFormId.toString());
                pstmt.executeUpdate();
                ArrayList<String> bgFormIds = new ArrayList<String>();
                bgFormIds.add(_bgFormInfo.getId().toString());
                this.updateOperateInfo(ctx, bgFormIds, _userId, 5);
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(pstmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _batchAntiAudit(Context ctx, List bgFormIds, BOSUuid auditOrgId, BOSUuid auditUserId) throws BOSException, EASBizException {
        ArrayList reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        this.sortByOrg(ctx, bgFormIds);
        HashSet _bgFormIdSet = new HashSet();
        ArrayList _bgFormIds = new ArrayList();
        _bgFormIds.addAll(bgFormIds);
        _bgFormIdSet.addAll(bgFormIds);
        int batchSize = 25;
        int batchIndex = 0;
        int size = _bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        IMutexServiceControl imc = null;
        int _state = 0;
        int _dataSource = 0;
        String _bgFormId = null;
        String _bgFormName = null;
        String[] _bgFormInfo = null;
        StringBuffer para = null;
        StringBuffer sql = null;
        para = new StringBuffer();
        for (int i = 1; i < batchSize; ++i) {
            para.append("?,");
        }
        para.append("?");
        try {
            String _bgFormNumber;
            conn = this.getConnection(ctx);
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            ArrayList<String[]> _checkUse = new ArrayList<String[]>();
            ArrayList<String[]> _checkState = new ArrayList<String[]>();
            reList.add(_checkUse);
            reList.add(_checkState);
            sql = new StringBuffer();
            sql.append("SELECT FID, FName, FNumber, FState FROM T_MBg_BgForm WHERE FID IN (" + para + ")");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                for (int index = 0; index < count; ++index) {
                    int x = 1;
                    while (x <= batchSize) {
                        if (pos < size) {
                            _bgFormId = ((String)_bgFormIds.get(pos)).toString();
                            pstmt.setString(x, _bgFormId);
                        } else {
                            pstmt.setString(x, "#");
                        }
                        ++x;
                        ++pos;
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _bgFormId = rst.getString("FID");
                        _bgFormName = rst.getString("FName");
                        _bgFormNumber = rst.getString("FNumber");
                        if (imc.requestObjIDForUpdate(_bgFormId)) {
                            imc.releaseObjIDForUpdate(_bgFormId);
                            _state = rst.getInt("FState");
                            if (_state == 2) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkState.add(_bgFormInfo);
                            continue;
                        }
                        _bgFormIdSet.remove(_bgFormId);
                        _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                        _checkUse.add(_bgFormInfo);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)ex.getMessage());
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            finally {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                _bgFormIds.clear();
                _bgFormIds.addAll(_bgFormIdSet);
            }
            ArrayList<String[]> _checkAdjust = new ArrayList<String[]>();
            ArrayList<String[]> _checkRoll = new ArrayList<String[]>();
            reList.add(_checkAdjust);
            reList.add(_checkRoll);
            HashMap bgFormIdMap = new HashMap();
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT FID, FName, FNumber, FState, FDataSource, FAdjustId FROM T_MBg_BgForm WHERE FAdjustId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = ((String)_bgFormIds.get(pos)).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FAdjustId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _state = rst.getInt("FState");
                            _dataSource = rst.getInt("FDataSource");
                            if (_state != 4 && _state != 15 && _state != 6 || _dataSource != 2 && _dataSource != 13 || bgFormIdMap.containsKey(_bgFormId)) continue;
                            _bgFormIdSet.remove(_bgFormId);
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            if (_dataSource == 13) {
                                _checkRoll.add(_bgFormInfo);
                            } else {
                                _checkAdjust.add(_bgFormInfo);
                            }
                            bgFormIdMap.put(_bgFormId, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList _checkBill = new ArrayList();
            reList.add(_checkBill);
            ArrayList<String[]> _checkRecord = new ArrayList<String[]>();
            reList.add(_checkRecord);
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                pos = 0;
                sql = new StringBuffer();
                sql.append("SELECT t.FID, t.FBgFormId, f.FName, f.FNumber FROM T_MBG_BgActualRecord t LEFT JOIN T_MBg_BgForm f on t.FBgFormId = f.FID WHERE FBgFormId IN (" + para + ")");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    for (int index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                _bgFormId = ((String)_bgFormIds.get(pos)).toString();
                                pstmt.setString(x, _bgFormId);
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _bgFormId = rst.getString("FBgFormId");
                            _bgFormName = rst.getString("FName");
                            _bgFormNumber = rst.getString("FNumber");
                            _bgFormIdSet.remove(_bgFormId);
                            if (bgFormIdMap.containsKey(_bgFormId)) continue;
                            _bgFormInfo = new String[]{_bgFormId, _bgFormName, _bgFormNumber};
                            _checkRecord.add(_bgFormInfo);
                            bgFormIdMap.put(_bgFormId, null);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    _bgFormIds.clear();
                    _bgFormIds.addAll(_bgFormIdSet);
                }
            }
            ArrayList _checkCtrlRecord = new ArrayList();
            reList.add(_checkCtrlRecord);
            ArrayList _useGather = new ArrayList();
            reList.add(_useGather);
            ArrayList<Object> _succeed = new ArrayList<Object>();
            reList.add(_succeed);
            HashMap bgFormIdsMap = new HashMap();
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            if (!_bgFormIds.isEmpty()) {
                sql = new StringBuffer();
                sql.append("update T_MBg_BgForm set FCertificateUserId = '', FCertificateTime = null, FIsConfirm = 0, FState=?, FAuditorID = ?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState<>?");
                String sql1 = "delete from T_MBG_BGPASTRECORD where FBgFormId = ? and FPastSource = ?";
                String sql2 = "delete from T_MBG_BGPASTDATA where FPASTRECORDID in (select FID from T_MBG_BGPASTRECORD where FBgFormId = ? and FPastSource = ?)";
                batchIndex = 0;
                String userId = user.getId().toString();
                java.sql.Date date = new java.sql.Date(System.currentTimeMillis());
                Object dataTableName = null;
                Object dataEntryTableName = null;
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    BizDataControlUtils utils = new BizDataControlUtils(ctx);
                    Iterator iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        utils.recoverAudOrgUnit(BOSUuid.read((String)_bgFormId), auditOrgId, auditUserId, 1, 1, false, null, null);
                        _succeed.add(_bgFormId);
                        pstmt.setInt(1, 1);
                        pstmt.setString(2, "");
                        pstmt.setDate(3, null);
                        pstmt.setString(4, userId);
                        pstmt.setDate(5, date);
                        pstmt.setString(6, _bgFormId);
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex >= batchSize) {
                            pstmt.executeBatch();
                            batchIndex = 0;
                        }
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql2, (Object[])new Object[]{_bgFormId, 12});
                        BgDBUtils.executeUpdate((Connection)conn, (String)sql1, (Object[])new Object[]{_bgFormId, 12});
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (!_succeed.isEmpty()) {
                    this.updateOperateInfo(ctx, _succeed, userId, 6);
                    HashSet<Object> idSet = new HashSet<Object>();
                    int in = _succeed.size();
                    for (int i = 0; i < in; ++i) {
                        idSet.add((String)_succeed.get(i));
                    }
                    idSet.add(_succeed);
                    EntityViewInfo view = new EntityViewInfo();
                    FilterInfo filter = new FilterInfo();
                    filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
                    view.setFilter(filter);
                    SelectorItemCollection sic = new SelectorItemCollection();
                    sic.add("id");
                    sic.add("number");
                    sic.add("name");
                    view.setSelector(sic);
                    BgFormCollection bgFormColl = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
                    _succeed.clear();
                    for (int i = 0; i < bgFormColl.size(); ++i) {
                        _bgFormInfo = new String[]{bgFormColl.get(i).getId().toString(), bgFormColl.get(i).getName(), bgFormColl.get(i).getNumber()};
                        _succeed.add(_bgFormInfo);
                    }
                }
                batchIndex = 0;
                sql = new StringBuffer();
                sql.append("update T_MBg_BgForm set FCertificateUserId = '', FCertificateTime = null, FIsConfirm = 0, FState=?, FAuditorID=?, FAuditedTime=?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID=? and FState=?");
                try {
                    pstmt = conn.prepareStatement(sql.toString());
                    Iterator iter = _bgFormIds.iterator();
                    while (iter.hasNext()) {
                        _bgFormId = iter.next().toString();
                        pstmt.setInt(1, 4);
                        pstmt.setString(2, userId);
                        pstmt.setDate(3, date);
                        pstmt.setString(4, userId);
                        pstmt.setDate(5, date);
                        pstmt.setString(6, _bgFormId);
                        pstmt.setInt(7, 4);
                        pstmt.addBatch();
                        bgFormIdsMap.put(_bgFormId, null);
                        if (++batchIndex < batchSize) continue;
                        pstmt.executeBatch();
                        batchIndex = 0;
                    }
                    if (batchIndex != 0) {
                        pstmt.executeBatch();
                    }
                }
                catch (SQLException ex) {
                    logger.error((Object)ex.getMessage());
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
            }
            if (!bgFormIdsMap.isEmpty()) {
                IBgFormFacade iBgFormFacade = BgFormFacadeFactory.getLocalInstance(ctx);
                BOSUuid auditUser = user.getId();
                Iterator formIt = bgFormIdsMap.keySet().iterator();
                while (formIt.hasNext()) {
                    iBgFormFacade.submitAuditIdea(BOSUuid.read((String)((String)formIt.next())), auditUser, BgAuditIdeaEnum.UNAUDIT, "");
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return reList;
    }

    @Override
    protected List _checkCourse(Context ctx, List bgFormIds, String bgOrgUnitId) throws BOSException, EASBizException {
        ArrayList<String[]> _bgFormIds = new ArrayList<String[]>();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _bgFormIds;
        }
        final HashMap bgFormMap = new HashMap();
        final HashMap bgTemplateOrgMap = new HashMap();
        Connection conn = null;
        Statement pstmt = null;
        Object pmstTem = null;
        ResultSet rst = null;
        StringBuffer sql = new StringBuffer();
        try {
            conn = this.getConnection(ctx);
            final BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select longNumber where id = '" + bgOrgUnitId + "'");
            sql.append("SELECT f.FID bgForm_id ,f.FNUMBER bgForm_number,f.FNAME bgForm_name, t.FRootID bgTemplate_rootid, o.FLongNumber org_longNumber, o.Fnumber org_number, o.FisVirtual org_virtual ");
            sql.append("FROM T_MBG_BGFORM f INNER JOIN T_MBG_BGTEMPLATE t ON f.FBGTEMPLATEID = t.FID INNER JOIN T_MBg_BgScheme s ON f.FBgSchemeId = s.FID INNER JOIN T_MBG_BgDimSettings ds on ds.FBgSchemeId = s.FID INNER JOIN T_MBG_BgDimSettingsMember dsm on dsm.FBgDimSettingsId = ds.FID INNER JOIN T_MBg_BgOrgUnit o ON o.FOrgUnitId = f.FOrgUnitId AND o.FViewId = dsm.FMemberId Where f.FID IN (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])bgFormIds.toArray(), (int)50);
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList, (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String longNumber = res.getString("org_longNumber");
                    boolean isVirtual = res.getBoolean("org_virtual");
                    String id = res.getString("bgForm_id");
                    if (!longNumber.equals(bgOrgUnitInfo.getLongNumber()) && !longNumber.startsWith(bgOrgUnitInfo.getLongNumber() + "!")) {
                        return;
                    }
                    if (bgFormMap.containsKey(id) && isVirtual) {
                        return;
                    }
                    BgFormInfo bgForm = new BgFormInfo();
                    String bgTemplateRootId = res.getString("bgTemplate_rootid");
                    bgForm.setId(BOSUuid.read((String)id));
                    bgForm.setNumber(res.getString("bgForm_number"));
                    bgForm.setName(res.getString("bgForm_name"));
                    bgForm.setBgTemplate(new BgTemplateInfo());
                    bgForm.getBgTemplate().setRootId(BOSUuid.read((String)bgTemplateRootId));
                    bgForm.setOrgUnit(new FullOrgUnitInfo());
                    bgForm.getOrgUnit().setLongNumber(longNumber);
                    bgForm.getOrgUnit().setNumber(res.getString("org_number"));
                    bgForm.getOrgUnit().setIsFreeze(isVirtual);
                    bgFormMap.put(bgForm.getId().toString(), bgForm);
                    if (!bgTemplateOrgMap.containsKey(bgTemplateRootId)) {
                        bgTemplateOrgMap.put(bgTemplateRootId, new HashSet());
                    }
                    String[] ls = bgForm.getOrgUnit().getLongNumber().split("!");
                    for (int i = 0; i < ls.length - 1; ++i) {
                        ((Set)bgTemplateOrgMap.get(bgTemplateRootId)).add(ls[i]);
                    }
                }
            });
            paramList.clear();
            sql.setLength(0);
            sql.append("Select t.FBgTemplateID, o.FNumber FROM T_MBG_BgTemplateNode t join T_Org_BaseUnit o ON t.FOrgUnitId = o.FID Where t.FBgTemplateID = ? AND o.FNumber IN (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            for (String rootId : bgTemplateOrgMap.keySet()) {
                paramList.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{rootId}, (Object[])((Set)bgTemplateOrgMap.get(rootId)).toArray(), (int)50));
            }
            bgTemplateOrgMap.clear();
            if (!paramList.isEmpty()) {
                MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)paramList, (IResultReader)new IResultReader(){

                    public void read(ResultSet res) throws SQLException {
                        String bgTemplateRootId = res.getString("FBgTemplateID");
                        if (!bgTemplateOrgMap.containsKey(bgTemplateRootId)) {
                            bgTemplateOrgMap.put(bgTemplateRootId, new HashSet());
                        }
                        ((Set)bgTemplateOrgMap.get(bgTemplateRootId)).add(res.getString("FNumber"));
                    }
                });
            }
            block6: for (BgFormInfo bgForm : bgFormMap.values()) {
                String bgTemplateRootId = bgForm.getBgTemplate().getRootId().toString();
                String[] ls = bgForm.getOrgUnit().getLongNumber().split("!");
                for (int i = 0; i < ls.length - 1; ++i) {
                    if (bgTemplateOrgMap.containsKey(bgTemplateRootId) && ((Set)bgTemplateOrgMap.get(bgTemplateRootId)).contains(ls[i])) continue block6;
                }
                _bgFormIds.add(new String[]{bgForm.getId().toString(), bgForm.getNumber(), bgForm.getName()});
            }
        }
        catch (BOSException ex) {
            logger.error((Object)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return _bgFormIds;
    }

    @Override
    protected List _course(Context ctx, List bgFormIds, String orgUnitId, String userId) throws BOSException, EASBizException {
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        boolean batchIndex = false;
        Object _bgFormId = null;
        Object _orgUnitId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        Map _orgUnitMap = null;
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList updateSucessIds = new ArrayList();
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        BgFormInfo bgFormInfo = new BgFormInfo();
        BgFormStateEnum stateEnum = BgFormStateEnum.Edited;
        _orgUnitMap = this.getCourseOrgMap(ctx, orgUnitId, bgFormIds);
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        BgSchemeInfo bgSchemeInfo = null;
        if (bgFormIds.get(0) instanceof String) {
            bgSchemeInfo = BgViewServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormIds.get(0).toString()), false).getBgScheme();
        } else if (bgFormIds.get(0) instanceof BOSUuid) {
            bgSchemeInfo = BgViewServerHelper.getBgFormInfo(ctx, (BOSUuid)bgFormIds.get(0), false).getBgScheme();
        }
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, stateEnum, true);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsSet.add(_bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        if (bgSchemeInfo == null) {
            return _reList;
        }
        Map courseResult = BgFormAuditFacadeFactory.getLocalInstance(ctx).courses(bgFormIds, this.getCourseParams(bgSchemeInfo.getId().toString(), String.valueOf(userId), String.valueOf(orgUnitId), false));
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        return _reList;
    }

    @Override
    protected List _courseWorkFlow(Context ctx, List bgFormIds, String userId) throws BOSException, EASBizException {
        return this._course(ctx, bgFormIds, null, userId);
    }

    private String getInsertCourseDataSql(Context ctx, String bgFormId, String userId) throws SQLException {
        if (StringUtils.isEmpty((String)bgFormId) || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        String dataTableName = BgCubeUtils.getBgDataTableNameByFormId(ctx, bgFormId);
        if (StringUtils.isEmpty((String)dataTableName)) {
            return null;
        }
        String dataEntryTableName = BgCubeUtils.getBudgetEntryCubeName(dataTableName);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MBg_BgCourseData(FID, FBValue, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgValue, ?, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from " + dataTableName + " bgdata where " + BgViewServerHelper.getBgDataFilterByBgFormId(dataEntryTableName) + " and ").append("(select count(fid) from T_MBg_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        return sql.toString();
    }

    private String getInsertCourseCauseSql(Context ctx, String bgFormId, String userId) throws SQLException {
        if (StringUtils.isEmpty((String)bgFormId) || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        String dataTableName = BgCubeUtils.getBgDataTableNameByFormId(ctx, bgFormId);
        if (StringUtils.isEmpty((String)dataTableName)) {
            return null;
        }
        String dataEntryTableName = BgCubeUtils.getBudgetEntryCubeName(dataTableName);
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MBg_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, ?, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from " + dataTableName + " bgdata where " + BgViewServerHelper.getBgDataFilterByBgFormId(dataEntryTableName) + " and ").append("(select count(fid) from T_MBg_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        return sql.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List queryBgFormIds(Context ctx, List bgFormIds, List pBgFormIds, BgFormStateEnum state, boolean isCheckWorkFlow) throws EASBizException, BOSException {
        if (ctx == null) return new ArrayList();
        if (bgFormIds == null) return new ArrayList();
        if (pBgFormIds == null) return new ArrayList();
        if (state == null) {
            return new ArrayList();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 100;
        int size = 0;
        int count = 0;
        int pos = 0;
        ArrayList<String[]> _bgFormInfos = new ArrayList<String[]>();
        ArrayList _bgFormIds = new ArrayList();
        HashSet _bgFormIdSet = new HashSet();
        int _state = 0;
        String _id = null;
        String _name = null;
        String _number = null;
        Object _bgFormId = null;
        String[] _bgFormStr = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName, FNumber, FState from T_MBg_BgForm where FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            int x;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            if (!_bgFormIds.isEmpty()) {
                size = _bgFormIds.size();
                count = (size - 1) / batchSize + 1;
                for (index = 0; index < count; ++index) {
                    for (x = 1; x <= batchSize; ++x, ++pos) {
                        if (pos < size) {
                            pstmt.setString(x, (String)_bgFormIds.get(pos));
                            continue;
                        }
                        pstmt.setString(x, "#");
                    }
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        _id = rst.getString(1);
                        _name = rst.getString(2);
                        _number = rst.getString(3);
                        _bgFormStr = new String[]{_id, _name, _number};
                        _bgFormInfos.add(_bgFormStr);
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
            pos = 0;
            size = bgFormIds.size();
            count = (size - 1) / batchSize + 1;
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _id = rst.getString(1);
                    _name = rst.getString(2);
                    _number = rst.getString(3);
                    _state = rst.getInt(4);
                    _bgFormStr = new String[]{_id, _name, _number};
                    if (_state == state.getValue()) {
                        pBgFormIds.add(_bgFormStr);
                        continue;
                    }
                    _bgFormInfos.add(_bgFormStr);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                _bgFormIds.clear();
                _bgFormIdSet.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        _bgFormIds.clear();
        _bgFormIdSet.clear();
        return _bgFormInfos;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Map getCourseOrgMap(Context ctx, String orgUnitId, List bgFormIds) throws BOSException, EASBizException {
        HashMap<String, String> bgFormIdsMap = new HashMap<String, String>();
        if (ctx == null) return bgFormIdsMap;
        if (bgFormIds == null) {
            return bgFormIdsMap;
        }
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            int i = 0;
            int in = bgFormIds.size();
            while (i < in) {
                bgFormIdsMap.put((String)bgFormIds.get(i), orgUnitId);
                ++i;
            }
            return bgFormIdsMap;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 100;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String _bgFormId = null;
        String _orgUnitId = null;
        String _pOrgUnitId = null;
        StringBuffer sql = new StringBuffer();
        StringBuffer query = new StringBuffer();
        sql.append("select FID, FOrgUnitId from T_MBg_BgForm where FID in (");
        for (index = 1; index < batchSize; ++index) {
            sql.append("?,");
        }
        sql.append("?)");
        ArrayList _orgUnitIdList = new ArrayList();
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        HashMap<String, String> _orgUnitIdMap = new HashMap<String, String>();
        Object var21_23 = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _bgFormId = rst.getString(1);
                    _orgUnitId = rst.getString(2);
                    bgFormIdsMap.put(_bgFormId, _orgUnitId);
                    _orgUnitIdSet.add(_orgUnitId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            _orgUnitIdList.addAll(_orgUnitIdSet);
            query.append("select FID, FParentID from T_ORG_CostCenter where FID IN (");
            for (index = 1; index < batchSize; ++index) {
                query.append("?,");
            }
            query.append("?)");
            pos = 0;
            size = _orgUnitIdList.size();
            count = (size - 1) / batchSize + 1;
            pstmt = conn.prepareStatement(query.toString());
            for (index = 0; index < count; ++index) {
                for (int y = 1; y <= batchSize; ++y, ++pos) {
                    if (pos < size) {
                        pstmt.setString(y, (String)_orgUnitIdList.get(pos));
                        continue;
                    }
                    pstmt.setString(y, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    _pOrgUnitId = rst.getString(2);
                    _orgUnitIdMap.put(_orgUnitId, _pOrgUnitId);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            for (Map.Entry entry : bgFormIdsMap.entrySet()) {
                _orgUnitId = (String)entry.getValue();
                _pOrgUnitId = (String)_orgUnitIdMap.get(_orgUnitId);
                if (_pOrgUnitId == null) continue;
                entry.setValue(_pOrgUnitId);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgFormIdsMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createCourseData(Context ctx, String userId, List bgFormIds, int state) throws BOSException, EASBizException {
        if (ctx == null) return;
        if (bgFormIds == null) return;
        if (bgFormIds.isEmpty()) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        StringBuffer cause = new StringBuffer();
        sql.append("insert into T_MBg_BgCourseData(FID, FBValue, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, FBgValue, ?, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from T_MBg_BgData bgdata where " + BgViewServerHelper.getBgDataFilterByBgFormId() + " and ").append("(select count(fid) from T_MBg_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        cause.append("insert into T_MBg_BgCourseCause(FID, FBgFormID, FFormula, FCreatorID, ").append("FCreatorTime, FLastUpdateUserId, FLastUpdateTime) ").append("(select FID, ?, FFormula, '" + userId + "' , ").append("NOW(), '" + userId + "', NOW() ").append("from T_MBg_BgData bgdata where " + BgViewServerHelper.getBgDataFilterByBgFormId() + " and ").append("(select count(fid) from T_MBg_BgCourseData course where course.FBgFormId=?").append(" and course.FFormula =bgdata.FFormula)=0)");
        String _bgFormId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstcau = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pstcau = conn.prepareStatement(cause.toString());
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)bgFormIds.get(i);
                pstmt.setString(1, _bgFormId);
                pstmt.setString(2, _bgFormId);
                pstmt.setString(3, _bgFormId);
                pstmt.executeUpdate();
                pstcau.setString(1, _bgFormId);
                pstcau.setString(2, _bgFormId);
                pstcau.setString(3, _bgFormId);
                pstcau.executeUpdate();
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstcau);
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstcau);
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    private IEnactmentService getWorkFlowInterface(Context ctx) throws BOSException {
        return EnactmentServiceFactory.createEnactService((Context)ctx);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _approve(Context ctx, List bgFormIds, BOSUuid audOrgUnitId, BOSUuid audUserId) throws BOSException, EASBizException {
        int i;
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        String _bgFormId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList _tmpList = new ArrayList();
        HashMap<String, String> _bgFormIdsMap = new HashMap<String, String>();
        IBgPastRecord _iPastRecord = BgPastRecordFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = new BgFormInfo();
        Object _record = null;
        Object _data = null;
        Object _user = null;
        if (audUserId == null) {
            audUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        String _userId = audUserId.toString();
        ArrayList tmpBgFormIds = new ArrayList();
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Report, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsMap.put(_bgFormStr[0], _bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        if (!_bgFormIdsMap.isEmpty()) {
            for (i = 0; i < bgFormIds.size(); ++i) {
                if (_bgFormIdsMap.containsKey(bgFormIds.get(i))) continue;
                tmpBgFormIds.add(bgFormIds.get(i));
            }
            bgFormIds = tmpBgFormIds;
        }
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        Statement pstdel = null;
        Statement pstQuy = null;
        ResultSet rst = null;
        IObjectPK pk = null;
        try {
            int i2;
            int in;
            if (!_pBgFormInfos.isEmpty()) {
                in = _pBgFormInfos.size();
                for (i2 = 0; i2 < in; ++i2) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i2);
                    logs.append(_bgFormStr[2]).append(" ");
                    logs.append(_bgFormStr[1]);
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgCourse_certificate", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgCourse_certificate");
            }
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBg_BgForm set FState = ?, FCertificateUserId = ?, FCertificateTime = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            in = bgFormIds.size();
            for (i2 = 0; i2 < in; ++i2) {
                _bgFormId = bgFormIds.get(i2).toString();
                pstmt.setInt(1, 41);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, _userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, _bgFormId);
                pstmt.setInt(7, 40);
                pstmt.addBatch();
                if (++batchIndex >= batchSize) {
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                utils.updateAudOrgUnit(BOSUuid.read((String)_bgFormId), audOrgUnitId, audUserId, 1, 3, null, null, new BgFormStateEnum[]{BgFormStateEnum.Edited, BgFormStateEnum.Back, BgFormStateEnum.Report});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            this.clearLockByAreaCertificate(ctx, bgFormIds);
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                SQLUtils.cleanup(pstQuy);
                SQLUtils.cleanup(pstdel);
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst);
        SQLUtils.cleanup(pstQuy);
        SQLUtils.cleanup(pstdel);
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        return _reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void clearLockByAreaCertificate(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        if (bgFormIds == null) {
            return;
        }
        StringBuffer querySql = new StringBuffer("select fid,fdata from T_MBg_bgform where fid in (");
        StringBuffer updateSql = new StringBuffer("update T_MBg_bgform set fdata = ? where fid = ? ");
        int index = 0;
        int batchSize = 100;
        int size = 0;
        int count = 0;
        int pos = 0;
        for (int i = 1; i < batchSize; ++i) {
            querySql.append("?,");
        }
        querySql.append("? )");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashMap<String, BgFormInfo> tmpMap = new HashMap<String, BgFormInfo>();
        BgFormInfo info = null;
        String key2222 = null;
        try {
            size = bgFormIds.size();
            count = (size - 1) / batchSize + 1;
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(querySql.toString());
            for (index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgFormIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, "#");
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    info = new BgFormInfo();
                    info.setZipData(MbgSqlHelper.getBytes((ResultSet)rst, (String)"fdata"));
                    this.clearCell(info);
                    tmpMap.put(rst.getString("fid"), info);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
            pstmt = conn.prepareStatement(updateSql.toString());
            for (String key2222 : tmpMap.keySet()) {
                info = (BgFormInfo)tmpMap.get(key2222);
                pstmt.setBytes(1, info.getZipData());
                pstmt.setString(2, key2222);
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
                catch (Exception e) {
                    throw new BOSException(e.getCause());
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                if (tmpMap == null) throw throwable;
                tmpMap.clear();
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        if (tmpMap == null) return;
        tmpMap.clear();
    }

    private void clearCell(BgFormInfo info) throws Exception {
        Book book = info.getBook();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        if (info == null || book == null) {
            return;
        }
        int sheetCount = book.getSheetCount();
        Sheet sheet = null;
        Cell cell = null;
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int rowCount = sheet.getMaxRowIndex() + 1;
            for (int rowIndex = 0; rowIndex < rowCount; ++rowIndex) {
                int colCount = sheet.getMaxColIndex() + 1;
                for (int colIndex = 0; colIndex < colCount; ++colIndex) {
                    cell = sheet.getCell(rowIndex, colIndex, false);
                    if (!BgNFSHelper.checkHasCertificate(cell)) continue;
                    BgNFSHelper.removeCellData(cell, "COURSE_CER");
                }
            }
        }
        info.setBook(book);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _antiApprove(Context ctx, List bgFormIds, BOSUuid audOrgUnitId, BOSUuid audUserId) throws BOSException, EASBizException {
        ArrayList<Object> _reList = new ArrayList<Object>();
        _reList.add(Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reList;
        }
        int batchSize = 200;
        int batchIndex = 0;
        Timestamp _Timestamp = new Timestamp(System.currentTimeMillis());
        String _bgFormId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        BgFormInfo bgFormInfo = new BgFormInfo();
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        ArrayList<String> _tmpList = new ArrayList<String>();
        HashMap<String, String> _bgFormIdsMap = new HashMap<String, String>();
        if (audUserId == null) {
            audUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId();
        }
        String _userId = audUserId.toString();
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Certificate, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsMap.put(_bgFormStr[0], _bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        ArrayList tmpBgFormIds = new ArrayList();
        if (!_bgFormIdsMap.isEmpty()) {
            for (int i = 0; i < bgFormIds.size(); ++i) {
                if (_bgFormIdsMap.containsKey(bgFormIds.get(i))) continue;
                tmpBgFormIds.add(bgFormIds.get(i));
            }
            bgFormIds = tmpBgFormIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        IObjectPK pk = null;
        try {
            if (!_pBgFormInfos.isEmpty()) {
                int in = _pBgFormInfos.size();
                for (int i = 0; i < in; ++i) {
                    _bgFormStr = (String[])_pBgFormInfos.get(i);
                    logs.append(_bgFormStr[2]).append(",");
                }
                if (logs.length() > 0) {
                    logs.delete(logs.length() - 1, logs.length());
                }
                pk = LogUtil.beginLog((Context)ctx, (String)"bgCourse_antiCertificate", (BOSObjectType)bgFormInfo.getBOSType(), null, (String)logs.toString(), (String)"bgCourse_antiCertificate");
            }
            bgFormIds.removeAll(_pBgFormInfos);
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBg_BgForm set FState = ?, FLastUpdateUserId = ?, FLastUpdateTime = ? where FID = ? and FState = ?");
            BizDataControlUtils utils = new BizDataControlUtils(ctx);
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = bgFormIds.get(i).toString();
                _tmpList.add(_bgFormId);
                pstmt.setInt(1, 40);
                pstmt.setString(2, _userId);
                pstmt.setTimestamp(3, _Timestamp);
                pstmt.setString(4, _bgFormId);
                pstmt.setInt(5, 41);
                pstmt.addBatch();
                if (++batchIndex >= batchSize) {
                    pstmt.executeBatch();
                    batchIndex = 0;
                }
                utils.recoverAudOrgUnit(BOSUuid.read((String)_bgFormId), audOrgUnitId, audUserId, 1, 3, true, null, new BgFormStateEnum[]{BgFormStateEnum.Certificate});
            }
            if (batchIndex != 0) {
                pstmt.executeBatch();
            }
            if (pk != null) {
                LogUtil.afterLog((Context)ctx, (IObjectPK)pk);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"budget error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
        _reList.set(0, Boolean.TRUE);
        _reList.add(_msg.toString());
        return _reList;
    }

    @Override
    protected Map _back(Context ctx, List bgFormIds, String userId, String orgUnitId) throws BOSException, EASBizException {
        HashMap<String, Object> _reMap = new HashMap<String, Object>();
        _reMap.put("back_result", Boolean.FALSE);
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return _reMap;
        }
        ArrayList successIds = new ArrayList();
        int batchSize = 200;
        boolean batchIndex = false;
        Object _bgFormId = null;
        String _userId = null;
        String[] _bgFormStr = null;
        StringBuffer _msg = new StringBuffer();
        StringBuffer logs = new StringBuffer();
        StringBuffer checkMsg = new StringBuffer();
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        BgFormInfo bgFormInfo = new BgFormInfo();
        List _bgFormInfos = null;
        ArrayList _pBgFormInfos = new ArrayList();
        HashSet<String> _bgFormIdsSet = new HashSet<String>();
        _userId = StringUtils.isEmpty((String)userId) ? ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString() : userId;
        BgSchemeInfo bgSchemeInfo = null;
        if (bgFormIds.get(0) instanceof String) {
            bgSchemeInfo = BgViewServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormIds.get(0).toString()), false).getBgScheme();
        } else if (bgFormIds.get(0) instanceof BOSUuid) {
            bgSchemeInfo = BgViewServerHelper.getBgFormInfo(ctx, (BOSUuid)bgFormIds.get(0), false).getBgScheme();
        }
        _bgFormInfos = this.queryBgFormIds(ctx, bgFormIds, _pBgFormInfos, BgFormStateEnum.Report, false);
        if (!_bgFormInfos.isEmpty()) {
            int in = _bgFormInfos.size();
            for (int i = 0; i < in; ++i) {
                _bgFormStr = (String[])_bgFormInfos.get(i);
                _bgFormIdsSet.add(_bgFormStr[0]);
                _msg.append(_bgFormStr[2]).append(",");
            }
            if (_msg.length() > 0) {
                _msg.delete(_msg.length() - 1, _msg.length());
            }
        }
        if (bgSchemeInfo == null) {
            return _reMap;
        }
        Map courseResult = BgFormAuditFacadeFactory.getLocalInstance(ctx).back(bgFormIds, this.getBackParams(bgSchemeInfo.getId().toString(), String.valueOf(userId), String.valueOf(orgUnitId), true));
        _reMap.put("back_result", Boolean.TRUE);
        _reMap.put("back_no_uproport", _msg.toString());
        _reMap.put("back_can_not", checkMsg.toString());
        return _reMap;
    }

    @Override
    protected Map _confirm(Context ctx, List bgFormIds, String userId, BOSUuid auditOrgId) throws BOSException, EASBizException {
        Map _reMap = new HashMap();
        if (bgFormIds == null || bgFormIds.isEmpty() || StringUtils.isEmpty((String)userId)) {
            return _reMap;
        }
        String _bgFormId2 = null;
        HashSet<String> _billIdSet = new HashSet<String>();
        List<String> resList = new ArrayList();
        ArrayList<String> _tmpBgFormIds = new ArrayList<String>();
        _tmpBgFormIds.addAll(bgFormIds);
        String[] _bgFormIds = new String[_tmpBgFormIds.size()];
        int in = _tmpBgFormIds.size();
        for (int i = 0; i < in; ++i) {
            _bgFormIds[i] = (String)_tmpBgFormIds.get(i);
        }
        _bgFormIds = EnactmentServiceFactory.createEnactService((Context)ctx).checkBizObjInWfProcess(_bgFormIds);
        if (_bgFormIds != null) {
            _billIdSet.clear();
            for (String _bgFormId2 : _bgFormIds) {
                _billIdSet.add(_bgFormId2);
            }
            resList.addAll(_tmpBgFormIds);
            _tmpBgFormIds.clear();
            for (String _bgFormId2 : resList) {
                if (_billIdSet.contains(_bgFormId2)) continue;
                _tmpBgFormIds.add(_bgFormId2);
            }
            resList.clear();
        }
        resList = BgNFormFacadeFactory.getLocalInstance(ctx).checkBatchAudit(_tmpBgFormIds);
        _tmpBgFormIds.clear();
        _tmpBgFormIds.addAll(resList);
        int _bgFormIdSize = _tmpBgFormIds.size();
        BOSUuid[] bgFormAuditIds = new BOSUuid[_bgFormIdSize];
        for (int index = 0; index < _bgFormIdSize; ++index) {
            bgFormAuditIds[index] = BOSUuid.read((String)_tmpBgFormIds.get(index).toString());
        }
        if (BgNSHelper.isCompulsionReportCheck(ctx)) {
            List nopass;
            boolean isExit = false;
            List check = BgFormFactory.getLocalInstance(ctx).reportCheck(bgFormAuditIds);
            if (check.size() >= 3 && check.get(3) != null) {
                isExit = true;
            }
            if (check.size() >= 3 && check.get(2) != null && (nopass = (List)check.get(2)).size() > 0) {
                isExit = true;
            }
            if (isExit) {
                return _reMap;
            }
        }
        _reMap = BgNFormFacadeFactory.getLocalInstance(ctx).batchAudit(bgFormIds, BOSUuid.read((String)userId), auditOrgId);
        return _reMap;
    }

    @Override
    protected Map _getReferBgFormList(Context ctx, Map params) throws BOSException, EASBizException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        HashMap<String, Object[]> returnMap = new HashMap<String, Object[]>();
        String orgunit_fNumber = null;
        String bgscheme_FNumber = null;
        String bgscenario_FNumber = null;
        String bgversion_FNumber = null;
        String bdcurrency_FNumber = null;
        String bgperiod_FNumber = null;
        String bgperiod1_FNumber = null;
        String bgperiod2_FNumber = null;
        String bgelement_FNumber = null;
        String bgdata_FFormula = null;
        String _bgFormId = null;
        String processStr = null;
        BgProcessEnum processTypeEnum = null;
        BOSUuid _tmpId = null;
        int processType = -1;
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        String expression = null;
        Object paramKey2 = null;
        Object[] param = null;
        Locale locale = ctx.getLocale();
        BgSchemeInfo root = null;
        HashMap<String, BgSchemeInfo> schemeMap = new HashMap<String, BgSchemeInfo>();
        StringBuffer sql = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().addObjectCollection((IObjectCollection)DimUtils.getDimSelector());
        Map<String, MbgDimInfo> dimInfoMap = DimUtils.getDimInfoMap(ctx);
        try {
            conn = this.getConnection(ctx);
            Object object = params.get("BGFORMINFO");
            IDimDataQuery bgFormInfo = null;
            if (object != null && object instanceof IDimDataQuery) {
                bgFormInfo = (IDimDataQuery)object;
                params.remove("BGFORMINFO");
            }
            HashSet<String> accNumbers = new HashSet<String>();
            for (Object paramKey2 : params.keySet()) {
                String itemNumber;
                param = (Object[])params.get(paramKey2);
                processType = 0;
                if (paramKey2.toString().toUpperCase(Locale.ENGLISH).startsWith("MBGAGGREGATE")) {
                    orgunit_fNumber = StringUtils.cnulls((Object)param[0]);
                    bgscheme_FNumber = StringUtils.cnulls((Object)param[1]);
                    bgscenario_FNumber = StringUtils.cnulls((Object)param[2]);
                    bgperiod1_FNumber = StringUtils.cnulls((Object)param[4]);
                    bgperiod2_FNumber = StringUtils.cnulls((Object)param[5]);
                    bgversion_FNumber = StringUtils.cnulls((Object)param[6]);
                    bdcurrency_FNumber = StringUtils.cnulls((Object)param[7]);
                    bgelement_FNumber = StringUtils.cnulls((Object)param[8]);
                    if (param.length >= 11 && !StringUtils.isEmpty((String)(processStr = StringUtils.cnulls((Object)param[11]).toUpperCase())) && BgProcessEnum.getEnum(processStr) != null) {
                        processType = BgProcessEnum.getEnum(processStr).getValue();
                    }
                } else {
                    orgunit_fNumber = StringUtils.cnulls((Object)param[0]);
                    bgscheme_FNumber = StringUtils.cnulls((Object)param[1]);
                    bgscenario_FNumber = StringUtils.cnulls((Object)param[2]);
                    bgperiod1_FNumber = StringUtils.cnulls((Object)param[4]);
                    bgperiod2_FNumber = StringUtils.cnulls((Object)param[5]);
                    bgversion_FNumber = StringUtils.cnulls((Object)param[6]);
                    bdcurrency_FNumber = StringUtils.cnulls((Object)param[7]);
                    bgelement_FNumber = StringUtils.cnulls((Object)param[8]);
                }
                if (!StringUtils.isEmpty((String)(itemNumber = StringUtils.cnulls((Object)param[3])))) {
                    accNumbers.add(DimensionFormulaHelper.splitCombinations(itemNumber)[0]);
                    param[3] = this.getBgDimNumber(dimInfoMap, itemNumber);
                }
                if (bgFormInfo != null) {
                    String string = orgunit_fNumber = "".equals(orgunit_fNumber.trim()) ? bgFormInfo.getBizOrgUnit().getNumber() : orgunit_fNumber;
                    if ("".equals(bgscheme_FNumber.trim())) {
                        bgscheme_FNumber = bgFormInfo.getBizBgScheme().getNumber();
                        param[1] = bgscheme_FNumber;
                    }
                    if ("".equals(bgperiod1_FNumber.trim())) {
                        bgperiod1_FNumber = bgFormInfo.getBizPeriod().getNumber();
                        param[4] = bgperiod1_FNumber;
                    }
                    if ("".equals(bgperiod2_FNumber.trim())) {
                        bgperiod2_FNumber = bgFormInfo.getBizPeriod().getNumber();
                        param[5] = bgperiod2_FNumber;
                    }
                    if ("".equals(bdcurrency_FNumber.trim())) {
                        bdcurrency_FNumber = bgFormInfo.getBizCurrency().getNumber();
                        param[7] = bdcurrency_FNumber;
                    }
                    if ("".equals(bgversion_FNumber.trim())) {
                        bgversion_FNumber = bgFormInfo.getBizVersion().getNumber();
                        param[6] = bgversion_FNumber;
                    }
                }
                if (schemeMap.containsKey(bgscheme_FNumber)) {
                    root = (BgSchemeInfo)schemeMap.get(bgscheme_FNumber);
                } else {
                    root = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgscheme_FNumber);
                    schemeMap.put(bgscheme_FNumber, root);
                }
                if (root == null) {
                    HashMap<String, Object[]> hashMap = returnMap;
                    return hashMap;
                }
                String orgViewId = root.getEditOrgViewId().toString();
                if (root == null) continue;
                if (processType <= 0 && bgFormInfo != null) {
                    processType = bgFormInfo.getProcessType().getValue();
                }
                if ((processTypeEnum = BgProcessEnum.getEnum(processType)) == null) continue;
                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, root.getId().toString(), BgCubeUtils.getCubeName(root.getRefCube(), DimensionCommonHelper.getDataType(processTypeEnum)));
                Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(accNumbers);
                for (String cube : cubeNames) {
                    sql = new StringBuffer();
                    String orgJoin = "join ( select FOrgUnitID FID, FNUMBER, FName_" + locale + ", FLongNumber from T_Mbg_BgOrgUnit where FViewId = ? AND (FLongNumber like ? or FLongNumber like ? or FLongNumber like ? or FLongNumber = ? )) orgunit on bgdata.FOrgUnitId = orgunit.FID ";
                    String periodJoin = "join T_MBG_BgPeriod bgperiod on bgdata.FBgPeriodId = bgperiod.FID and bgperiod.FNumber = ? ";
                    if (accIntHelper.isUseAccInt()) {
                        orgJoin = "join ( select FOrgUnitID FID, FIntId, FNUMBER, FName_" + locale + ", FLongNumber from T_Mbg_BgOrgUnit where FViewId = ? AND (FLongNumber like ? or FLongNumber like ? or FLongNumber like ? or FLongNumber = ? )) orgunit on bgdata.FOrgUnitId = orgunit.FIntID ";
                        periodJoin = "join T_MBG_BgPeriod bgperiod on bgdata.FBgPeriodId = bgperiod.FIntID and bgperiod.FNumber = ? ";
                    }
                    sql.append("select entry.FFormId, bgform.FName, orgunit.FName_" + locale + ", orgunit.FLongNumber, bgperiod.FName_" + locale + ", bgperiod.FLongNumber, bdcurrency.FName_" + locale + ", orgunit.FNUMBER, bgversion.FName_" + locale + ", bgform.FProcessType from " + cube + " bgdata join " + BgCubeUtils.getCubeEntryName(root.getRefCube(), DimensionCommonHelper.getDataType(processTypeEnum)) + " entry on bgdata.FID = entry.FDataID join T_MBG_BgForm bgform on entry.FFormId = bgform.FID " + orgJoin + "join ( select FID, FName_" + locale + " from T_BD_Currency where FNumber = ? ) bdcurrency on bgdata.FCurrencyId = bdcurrency.FID join T_MBG_BgScenario bgscenario on bgdata.FScenario = bgscenario.FscenarioID and bgscenario.FNumber = ? join T_MBG_BgVersion bgversion on bgdata.FVersion = bgversion.FversionID and bgversion.FNumber = ? " + periodJoin + "where bgdata.FFormula = ? and bgform.FProcessType = ?order by orgunit.FLongNumber ASC, bgperiod.FLongNumber ASC  ");
                    if (!bgperiod1_FNumber.equals(bgperiod2_FNumber)) {
                        java.sql.Date beginDate = null;
                        java.sql.Date endDate = null;
                        try {
                            ps = conn.prepareStatement("select FBeginDate from T_MBG_BgPeriod where FNumber = '" + bgperiod1_FNumber + "'  union select FEndDate from T_MBg_BgPeriod where FNumber = '" + bgperiod2_FNumber + "' ");
                            rs = ps.executeQuery();
                            if (rs.next()) {
                                beginDate = rs.getDate(1);
                            }
                            if (rs.next()) {
                                endDate = rs.getDate(1);
                            }
                        }
                        catch (Exception e) {
                            try {
                                logger.error((Object)e);
                                throw new BOSException((Throwable)e);
                            }
                            catch (Throwable throwable) {
                                SQLUtils.cleanup(rs, ps);
                                throw throwable;
                            }
                        }
                        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                        BgPeriodCollection bgc = BgPeriodHelper.getPeriodColInfo((Context)ctx, (Date)beginDate, (Date)endDate, (int)BgNPeriodHelper.parserBgPeriodType((String)bgperiod1_FNumber));
                        String str_period = null;
                        Iterator itPreiod = bgc.iterator();
                        while (itPreiod.hasNext()) {
                            bgperiod_FNumber = str_period = ((BgPeriodInfo)itPreiod.next()).getNumber();
                            bgdata_FFormula = paramKey2.toString().toUpperCase(Locale.ENGLISH).startsWith("MBGAGGREGATE") ? "=BgItem(\"" + param[3] + "\",\"" + str_period + "\",\"" + param[8] + "\",\"" + param[2] + "\",true,\"" + param[7] + "\")" : "=BgItem(\"" + param[3] + "\",\"" + str_period + "\",\"" + param[2] + "\",\"BgData\",true,\"" + param[4] + "\")";
                            try {
                                ps = conn.prepareStatement(sql.toString());
                                ps.setString(1, orgViewId);
                                if (processType != 1) {
                                    ps.setString(2, "%!" + orgunit_fNumber);
                                    ps.setString(3, orgunit_fNumber);
                                    ps.setString(4, orgunit_fNumber);
                                    ps.setString(5, orgunit_fNumber);
                                } else {
                                    ps.setString(2, "%!" + orgunit_fNumber + "!%");
                                    ps.setString(3, orgunit_fNumber + "!%");
                                    ps.setString(4, "%!" + orgunit_fNumber);
                                    ps.setString(5, orgunit_fNumber);
                                }
                                ps.setString(6, bdcurrency_FNumber);
                                ps.setString(7, bgscenario_FNumber);
                                ps.setString(8, bgversion_FNumber);
                                ps.setString(9, bgperiod_FNumber);
                                ps.setString(10, bgdata_FFormula);
                                ps.setInt(11, processType);
                                rs = ps.executeQuery();
                                while (rs.next()) {
                                    Object[] paramItem = new Object[9];
                                    _bgFormId = rs.getString(1);
                                    paramItem[0] = _bgFormId;
                                    _tmpId = BgViewServerHelper.getAdjustId(conn, BOSUuid.read((String)_bgFormId));
                                    if (!_bgFormId.equals(_tmpId.toString())) {
                                        paramItem[0] = _tmpId.toString();
                                    }
                                    paramItem[1] = rs.getString(2);
                                    paramItem[2] = rs.getString(3);
                                    paramItem[3] = rs.getString(5);
                                    paramItem[4] = rs.getString(7);
                                    paramItem[7] = rs.getString(9);
                                    paramItem[8] = BgProcessEnum.getEnum(rs.getInt(10));
                                    paramItem[5] = rs.getString(4);
                                    paramItem[6] = rs.getString(6);
                                    param[0] = rs.getString(8);
                                    expression = paramKey2.toString().toUpperCase(Locale.ENGLISH).startsWith("MBGAGGREGATE") ? "MBGAGGREGATE(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\",\"" + param[6] + "\",\"" + param[7] + "\",\"" + param[8] + "\",\"" + param[9] + "\",\"" + processTypeEnum.getName() + "\")" : "MBGFORMULA(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + param[4] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\")";
                                    returnMap.put(expression, paramItem);
                                }
                            }
                            catch (Exception e) {
                                logger.error((Object)e);
                                throw new BOSException((Throwable)e);
                            }
                            finally {
                                SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                            }
                        }
                        continue;
                    }
                    bgperiod_FNumber = bgperiod1_FNumber;
                    bgdata_FFormula = paramKey2.toString().toUpperCase(Locale.ENGLISH).startsWith("MBGAGGREGATE") ? "=BgItem(\"" + param[3] + "\",\"" + param[4] + "\",\"" + param[8] + "\",\"" + param[2] + "\",true,\"" + param[7] + "\")" : "=BgItem(\"" + param[3] + "\",\"" + param[4] + "\",\"" + param[8] + "\",\"" + param[2] + "\",true,\"" + param[7] + "\")";
                    try {
                        ps = conn.prepareStatement(sql.toString());
                        ps.setString(1, orgViewId);
                        if (processType != 1) {
                            ps.setString(2, "%!" + orgunit_fNumber);
                            ps.setString(3, orgunit_fNumber);
                            ps.setString(4, orgunit_fNumber);
                            ps.setString(5, orgunit_fNumber);
                        } else {
                            ps.setString(2, "%!" + orgunit_fNumber + "!%");
                            ps.setString(3, orgunit_fNumber + "!%");
                            ps.setString(4, "%!" + orgunit_fNumber);
                            ps.setString(5, orgunit_fNumber);
                        }
                        ps.setString(6, bdcurrency_FNumber);
                        ps.setString(7, bgscenario_FNumber);
                        ps.setString(8, bgversion_FNumber);
                        ps.setString(9, bgperiod_FNumber);
                        ps.setString(10, bgdata_FFormula);
                        ps.setInt(11, processType);
                        rs = ps.executeQuery();
                        while (rs.next()) {
                            Object[] paramItem = new Object[9];
                            _bgFormId = rs.getString(1);
                            paramItem[0] = _bgFormId;
                            _tmpId = BgViewServerHelper.getAdjustId(conn, BOSUuid.read((String)_bgFormId));
                            if (!_bgFormId.equals(_tmpId.toString())) {
                                paramItem[0] = _tmpId.toString();
                            }
                            paramItem[1] = rs.getString(2);
                            paramItem[2] = rs.getString(3);
                            paramItem[3] = rs.getString(5);
                            paramItem[4] = rs.getString(7);
                            paramItem[7] = rs.getString(9);
                            paramItem[8] = BgProcessEnum.getEnum(rs.getInt(10));
                            paramItem[5] = rs.getString(4);
                            paramItem[6] = rs.getString(6);
                            param[0] = rs.getString(8);
                            expression = paramKey2.toString().toUpperCase(Locale.ENGLISH).startsWith("MBGAGGREGATE") ? "MBGAGGREGATE(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\",\"" + param[6] + "\",\"" + param[7] + "\",\"" + param[8] + "\",\"" + param[9] + "\",\"" + processTypeEnum.getName() + "\")" : "MBGFORMULA(\"" + param[0] + "\",\"" + param[1] + "\",\"" + param[2] + "\",\"" + param[3] + "\",\"" + param[4] + "\",\"" + bgperiod_FNumber + "\",\"" + bgperiod_FNumber + "\")";
                            returnMap.put(expression, paramItem);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)e);
                        throw new BOSException((Throwable)e);
                    }
                    finally {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)ps);
                    }
                }
            }
        }
        catch (BOSException be) {
            logger.error((Object)be);
            throw be;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return returnMap;
    }

    @Override
    protected List _queryBgFormWorkFlowInfo(Context ctx, Map queryParam) throws BOSException, EASBizException {
        int i;
        ArrayList<BgFormWorkFlowInfo> reList = new ArrayList<BgFormWorkFlowInfo>();
        if (queryParam == null) {
            return reList;
        }
        String CURR_USER_ID = (String)queryParam.get("CURR_USER_ID");
        String CURR_CTRLORGUNIT_ID = (String)queryParam.get("CURR_CTRLORGUNIT_ID");
        String SEL_ORGUNIT_ID = (String)queryParam.get("SEL_ORGUNIT_ID");
        Integer SEL_ORGUNIT_TYPE = (Integer)queryParam.get("SEL_ORGUNIT_TYPE");
        String[] SEL_BGSCHEME_IDS = (String[])queryParam.get("SEL_BGSCHEME_IDS");
        String[] SEL_BGPERIOD_IDS = (String[])queryParam.get("SEL_BGPERIOD_IDS");
        String[] SEL_CURRENCY_IDS = (String[])queryParam.get("SEL_CURRENCY_IDS");
        String QUERY_INFO = (String)queryParam.get("QUERY_INFO");
        Boolean hasShowWorkFlow = (Boolean)queryParam.get("SHOW_INFO");
        if (hasShowWorkFlow == null) {
            hasShowWorkFlow = Boolean.FALSE;
        }
        String _key = null;
        ArrayList<String> idsList = new ArrayList<String>();
        Set<String> _queryOrgUnitIds = new HashSet<String>();
        HashSet<Integer> _state = new HashSet<Integer>();
        HashMap<String, BgFormWorkFlowInfo> _bgFormMap = new HashMap<String, BgFormWorkFlowInfo>();
        IBgForm ibgForm = null;
        BgFormInfo bgFormInfo = null;
        BgFormCollection bgFormColl = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("state");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("adjust.id");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        HashSet<String> bgSchemeIdsSet = new HashSet<String>();
        if (SEL_BGSCHEME_IDS != null) {
            int in = SEL_BGSCHEME_IDS.length;
            for (int i2 = 0; i2 < in; ++i2) {
                if (SEL_BGSCHEME_IDS[i2] == null) continue;
                bgSchemeIdsSet.add(SEL_BGSCHEME_IDS[i2].toString());
            }
        }
        HashSet<String> bgPeriodIdsSet = new HashSet<String>();
        if (SEL_BGPERIOD_IDS != null) {
            int in = SEL_BGPERIOD_IDS.length;
            for (int i3 = 0; i3 < in; ++i3) {
                if (SEL_BGPERIOD_IDS[i3] == null) continue;
                bgPeriodIdsSet.add(SEL_BGPERIOD_IDS[i3].toString());
            }
        }
        HashSet<String> currnecyIdsSet = new HashSet<String>();
        if (SEL_CURRENCY_IDS != null) {
            int in = SEL_CURRENCY_IDS.length;
            for (int i4 = 0; i4 < in; ++i4) {
                if (SEL_CURRENCY_IDS[i4] == null) continue;
                currnecyIdsSet.add(SEL_CURRENCY_IDS[i4].toString());
            }
        }
        _state.add(new Integer(15));
        _state.add(new Integer(5));
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", bgSchemeIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPeriod.id", bgPeriodIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("currency.id", currnecyIdsSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("state", _state, CompareType.NOTINCLUDE));
        if (SEL_ORGUNIT_TYPE == 1) {
            if (this.verifyPermission(ctx, CURR_USER_ID, SEL_ORGUNIT_ID)) {
                _queryOrgUnitIds.add(SEL_ORGUNIT_ID);
            }
        } else if (SEL_ORGUNIT_TYPE == 2) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, true);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        } else if (SEL_ORGUNIT_TYPE == 3) {
            _queryOrgUnitIds = this.queryImmOrgUnit(ctx, SEL_ORGUNIT_ID, false);
            _queryOrgUnitIds = this.verifyPermission(ctx, CURR_CTRLORGUNIT_ID, CURR_USER_ID, _queryOrgUnitIds);
        }
        if (_queryOrgUnitIds.isEmpty()) {
            return null;
        }
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", _queryOrgUnitIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", null));
        filter.getFilterItems().add(new FilterItemInfo("bgTemplate.bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.setMaskString("#0 and #1 and #2 and #3 and #4 and (#5 or #6)");
        view.setFilter(filter);
        BgFormWorkFlowInfo workFlowInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int index = 0;
        int batchSize = 200;
        int pos = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select f.FID, f.FNumber, f.FName, f.FState, t.FActDefName_" + ctx.getLocale() + ", t.fPersonUserName_" + ctx.getLocale() + ", sc.fname_" + ctx.getLocale() + ", cc.FName_" + ctx.getLocale() + ", f.FAdjustID from T_WFR_Assign t  join T_MBg_BgForm f on t.FBizObjId = f.FID  join T_MBg_BgScheme sc on f.FBgSchemeId = sc.FID  join T_ORG_CostCenter cc on f.FOrgUnitId = cc.fid  WHERE t.FBIZFUNCTION = 'MultiApproveUIFunction'  AND t.FBIZPACKAGE = 'com.kingdee.eas.base.multiapprove.client' and ");
        if (!StringUtils.isEmpty((String)QUERY_INFO)) {
            sql.append(" t.FActDefName_" + ctx.getLocale() + " like '%" + QUERY_INFO + "%' and ");
        }
        sql.append(" t.FBizObjId IN (");
        for (i = 1; i < batchSize; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        try {
            ibgForm = BgFormFactory.getLocalInstance(ctx);
            bgFormColl = ibgForm.getBgFormCollection(view);
            if (bgFormColl != null) {
                int in = bgFormColl.size();
                for (i = 0; i < in; ++i) {
                    bgFormInfo = bgFormColl.get(i);
                    idsList.add(bgFormInfo.getId().toString());
                    if (hasShowWorkFlow.booleanValue() || !StringUtils.isEmpty((String)QUERY_INFO)) continue;
                    workFlowInfo = new BgFormWorkFlowInfo();
                    workFlowInfo.setId(bgFormInfo.getId().toString());
                    workFlowInfo.setNumber(bgFormInfo.getNumber());
                    workFlowInfo.setName(bgFormInfo.getName());
                    workFlowInfo.setState(bgFormInfo.getState().getValue());
                    workFlowInfo.setBgSchemeName(bgFormInfo.getBgScheme().getName());
                    workFlowInfo.setOrgUnitName(bgFormInfo.getOrgUnit().getName());
                    workFlowInfo.setAdjustId(bgFormInfo.getAdjust().getId().toString());
                    _bgFormMap.put(bgFormInfo.getId().toString(), workFlowInfo);
                    reList.add(workFlowInfo);
                }
                if (!idsList.isEmpty()) {
                    int size = idsList.size();
                    int count = (size - 1) / batchSize + 1;
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql.toString());
                    for (index = 0; index < count; ++index) {
                        int x = 1;
                        while (x <= batchSize) {
                            if (pos < size) {
                                pstmt.setString(x, (String)idsList.get(pos));
                            } else {
                                pstmt.setString(x, "#");
                            }
                            ++x;
                            ++pos;
                        }
                        rst = pstmt.executeQuery();
                        while (rst.next()) {
                            _key = rst.getString(1);
                            if (_bgFormMap.containsKey(_key)) {
                                workFlowInfo = (BgFormWorkFlowInfo)_bgFormMap.get(_key);
                                workFlowInfo.addUserName(rst.getString(6));
                                if (workFlowInfo.getTask() != null) continue;
                                workFlowInfo.setTask(rst.getString(5));
                                continue;
                            }
                            workFlowInfo = new BgFormWorkFlowInfo();
                            workFlowInfo.setId(_key);
                            workFlowInfo.setNumber(rst.getString(2));
                            workFlowInfo.setName(rst.getString(3));
                            workFlowInfo.setState(rst.getInt(4));
                            workFlowInfo.setTask(rst.getString(5));
                            workFlowInfo.addUserName(rst.getString(6));
                            workFlowInfo.setBgSchemeName(rst.getString(7));
                            workFlowInfo.setOrgUnitName(rst.getString(8));
                            workFlowInfo.setAdjustId(rst.getString(9));
                            _bgFormMap.put(_key, workFlowInfo);
                            reList.add(workFlowInfo);
                        }
                        SQLUtils.cleanup((ResultSet)rst);
                    }
                }
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (SQLException ex) {
            logger.error((Object)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, conn);
        }
        return reList;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set queryImmOrgUnit(Context ctx, String currOrgUnitId, boolean isImmOrgUnit) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)currOrgUnitId)) {
            return new HashSet();
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        HashSet<String> orgUnitSet = new HashSet<String>();
        int _level = 0;
        String _number = null;
        String _longNumber = null;
        String _orgUnitId = null;
        String sql1 = "select FNumber, FLongNumber, FLevel from T_ORG_CostCenter where FID = ?";
        String sql2 = "select FID from T_ORG_CostCenter where FLongnumber like ? " + (isImmOrgUnit ? "and FLevel = ?" : "");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1);
            pstmt.setString(1, currOrgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitSet.add(currOrgUnitId);
                _number = rst.getString(1);
                _longNumber = rst.getString(2);
                _level = rst.getInt(3);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!StringUtils.isEmpty(_number) && !StringUtils.isEmpty(_longNumber)) {
                pstmt = conn.prepareStatement(sql2);
                pstmt.setString(1, _longNumber + "!%");
                if (isImmOrgUnit) {
                    pstmt.setInt(2, _level + 1);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    _orgUnitId = rst.getString(1);
                    orgUnitSet.add(_orgUnitId);
                }
            }
        }
        catch (BOSException ex) {
            try {
                logger.error((Object)ex);
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgFormException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitSet;
    }

    private IPermission getPermissionInterface(Context ctx) throws BOSException {
        return PermissionFactory.getLocalInstance((Context)ctx);
    }

    private boolean verifyPermission(Context ctx, String userId, String orgUnitId) throws BOSException, EASBizException {
        return this.getPermissionInterface(ctx).hasFunctionPermission((IObjectPK)new ObjectUuidPK(userId), (IObjectPK)new ObjectUuidPK(orgUnitId), PERMISSION_STR);
    }

    private Set verifyPermission(Context ctx, String ctrlUnitId, String userId, Set orgUnitIdSet) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId) || orgUnitIdSet == null) {
            return new HashSet();
        }
        String _orgUnitId = null;
        FullOrgUnitInfo _orgUnitInfo = null;
        FullOrgUnitCollection _orgUnitCol = null;
        HashSet<String> _orgUnitIdSet = new HashSet<String>();
        _orgUnitCol = this.getPermissionInterface(ctx).getAuthorizedOrgOfIncludeSubCU((IObjectPK)new ObjectUuidPK(ctrlUnitId), (IObjectPK)new ObjectUuidPK(userId), OrgType.CostCenter, null, PERMISSION_STR);
        if (_orgUnitCol != null && !_orgUnitCol.isEmpty()) {
            int in = _orgUnitCol.size();
            for (int i = 0; i < in; ++i) {
                _orgUnitInfo = _orgUnitCol.get(i);
                _orgUnitIdSet.add(_orgUnitInfo.getId().toString());
            }
            Iterator iter = orgUnitIdSet.iterator();
            while (iter.hasNext()) {
                _orgUnitId = (String)iter.next();
                if (_orgUnitIdSet.contains(_orgUnitId)) continue;
                iter.remove();
            }
            _orgUnitIdSet.clear();
        } else {
            orgUnitIdSet.clear();
        }
        return orgUnitIdSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateOperateInfo(Context ctx, List bgFormIds, String userId, int operate) throws BOSException, EASBizException {
        if (ctx == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds == null) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (bgFormIds.isEmpty()) throw new BgFormException(BgFormException.NOBGFORMINFO);
        if (userId == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        BgCourseCommentInfo info = new BgCourseCommentInfo();
        String _bgFormId = null;
        Timestamp _timestamp = new Timestamp(System.currentTimeMillis());
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MBg_BgCourseComment (FID, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FControlUnitID, FState, FBgFormId, FComment) values(?, ?, ?, ?, ?, ?, ?, ?, ?)");
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int in = bgFormIds.size();
            for (int i = 0; i < in; ++i) {
                _bgFormId = (String)bgFormIds.get(i);
                pstmt.setString(1, BOSUuid.create((BOSObjectType)info.getBOSType()).toString());
                pstmt.setString(2, userId);
                pstmt.setTimestamp(3, _timestamp);
                pstmt.setString(4, userId);
                pstmt.setTimestamp(5, _timestamp);
                pstmt.setString(6, null);
                pstmt.setInt(7, operate);
                pstmt.setString(8, _bgFormId);
                pstmt.setString(9, info.getComment());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _batchUnComfirm(Context ctx, List bgFormIds, BOSUuid auditOrgId, BOSUuid userID) throws BOSException, EASBizException {
        try {
            ctx.put((Object)"UN_CONFIRM", (Object)Boolean.TRUE);
            List resList = this._batchAntiAudit(ctx, bgFormIds, auditOrgId, userID);
            List successed = (List)resList.get(7);
            if (successed != null && successed.size() > 0) {
                BgCourseCommentInfo info = null;
                ArrayList<BgCourseCommentInfo> tmpList = new ArrayList<BgCourseCommentInfo>();
                UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
                int in = successed.size();
                for (int i = 0; i < in; ++i) {
                    if (!(successed.get(i) instanceof String[])) continue;
                    String[] obj = (String[])successed.get(i);
                    info = new BgCourseCommentInfo();
                    info.setBgFormId(obj[0]);
                    info.setCreator(user);
                    info.setState(BgCourseOperateEnum.UnConfirm);
                    tmpList.add(info);
                }
                BgCourseCommentFactory.getLocalInstance(ctx).batchAddnew(tmpList);
            }
            List list = resList;
            return list;
        }
        finally {
            ctx.remove((Object)"UN_CONFIRM");
        }
    }

    @Override
    protected List _getGatherFormList(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        List rootIds = this.getRootIds(ctx, bgFormIds);
        List returnList = this.getNotReportIds(ctx, rootIds);
        List valueList = null;
        for (int i = returnList.size() - 1; i >= 0; --i) {
            String value1 = String.valueOf(returnList.get(i));
            for (int j = 0; j < bgFormIds.size(); ++j) {
                String value2 = String.valueOf(bgFormIds.get(j));
                if (!value1.equals(value2)) continue;
                returnList.remove(i);
            }
        }
        if (returnList.size() != 0) {
            valueList = this.getNotReportForm(ctx, returnList);
        }
        return valueList;
    }

    private List getNotReportForm(Context ctx, List bgFormIds) throws BOSException {
        ArrayList<BgFormInfo> valueList = new ArrayList<BgFormInfo>();
        String ids = this.getIds(bgFormIds);
        BgFormCollection bgColl = BgFormFactory.getLocalInstance(ctx).getBgFormCollection("select number,name,state,orgUnit.displayName,orgUnit.number where id in (" + ids + ") and (state != 40 and state !=15) order by number");
        for (int i = 0; i < bgColl.size(); ++i) {
            BgFormInfo bgInfo = bgColl.get(i);
            valueList.add(bgInfo);
        }
        return valueList;
    }

    private String getIds(List bgFormIds) {
        int i = 0;
        StringBuffer ids = new StringBuffer();
        for (int j = 0; j < bgFormIds.size(); ++j) {
            String id = (String)bgFormIds.get(j);
            ids.append("'" + id + "'");
            if (++i >= bgFormIds.size()) continue;
            ids.append(",");
        }
        return ids.toString();
    }

    private List getNotReportIds(Context ctx, List bgFormIds) throws SQLDataException, BgException {
        ArrayList returnList = new ArrayList();
        return returnList;
    }

    private List getNotReportIds(Context ctx, List bgFormIds, Connection conn, StringBuffer sql) throws SQLDataException, BgException {
        ArrayList returnList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty() || conn == null || sql == null) {
            return returnList;
        }
        for (int i = 0; i < bgFormIds.size(); ++i) {
            if (returnList.contains(bgFormIds.get(i))) continue;
            returnList.add(bgFormIds.get(i));
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        String bgFormId = null;
        try {
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                ArrayList<String> tempList = new ArrayList<String>();
                while (rst.next()) {
                    bgFormId = rst.getString(1);
                    if (!returnList.contains(bgFormId)) {
                        returnList.add(bgFormId);
                    }
                    tempList.add(bgFormId);
                }
                SQLUtils.cleanup((ResultSet)rst);
                if (tempList.isEmpty()) continue;
                List tempList2 = this.getNotReportIds(ctx, tempList, conn, sql);
                for (int i = 0; i < tempList2.size(); ++i) {
                    bgFormId = (String)tempList2.get(i);
                    if (returnList.contains(bgFormId)) continue;
                    returnList.add(bgFormId);
                }
            }
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        return returnList;
    }

    private List getRootIds(Context ctx, List bgFormIds) throws SQLDataException, BgNFormException, BgException {
        ArrayList reList = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return reList;
        }
        int batchSize = 50;
        int size = bgFormIds.size();
        int count = (size - 1) / batchSize + 1;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        StringBuffer sql1 = new StringBuffer();
        sql1.append("select f.fid, f.fnumber, t.frootId,t.fid from T_MBg_bgForm f ");
        sql1.append("left join T_MBg_bgTemplate t on t.fid = f.FBgTemplateID ");
        sql1.append("left join T_MBg_bgScheme s on s.fid = f.FBgSchemeID ");
        sql1.append("where t.frootId = t.fid and f.fid in (");
        for (int index = 1; index < batchSize; ++index) {
            sql1.append("?,");
        }
        sql1.append("?)");
        ArrayList<String> rootIds = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql1.toString());
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batchSize) {
                    if (pos < size) {
                        pstmt.setString(x, bgFormIds.get(pos).toString());
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    rootIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return rootIds;
    }

    private IObjectPK _cloneCollect(Context ctx, BOSUuid id, BgFormDataSourceEnum dataSource, BgFormStateEnum state, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
        IObjectPK npk = null;
        BgFormInfo cloneInfo = null;
        cloneInfo = bgFormInfo.deepclone();
        if (dataSource != null) {
            cloneInfo.setDataSource(dataSource);
        }
        if (state != null) {
            cloneInfo.setState(state);
        }
        cloneInfo.setStartDate(bgFormInfo.getStartDate());
        cloneInfo.setEndDate(bgFormInfo.getEndDate());
        cloneInfo.setAdjust(bgFormInfo);
        cloneInfo.setAdjustMapData(null);
        cloneInfo.setVersionNo(bgFormInfo.getVersionNo());
        cloneInfo.setAuditTime(new Timestamp(System.currentTimeMillis()));
        npk = ibgForm.addnew((CoreBaseInfo)cloneInfo);
        return npk;
    }

    @Override
    protected Map _checkBackBgForm(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        HashMap<String, List> resMap = new HashMap<String, List>();
        resMap.put("back_can", bgFormIds);
        return resMap;
    }

    @Override
    protected Map _getAttachMentByBgFormIDS(Context ctx, List IDList) throws BOSException, EASBizException {
        if (IDList == null || IDList.isEmpty()) {
            return null;
        }
        HashMap<String, Boolean> attchMap = new HashMap<String, Boolean>();
        StringBuffer sql = new StringBuffer("select distinct FBoID from T_BAS_BoAttchAsso where FBoID in (");
        int batch_size = 250;
        for (int i = 1; i < batch_size; ++i) {
            sql.append("?,");
        }
        sql.append("?)");
        int size = 0;
        int count = 0;
        int pos = 0;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            pos = 0;
            size = IDList.size();
            count = (size - 1) / batch_size + 1;
            for (int index = 0; index < count; ++index) {
                int x = 1;
                while (x <= batch_size) {
                    if (pos < size) {
                        pstmt.setString(x, (String)IDList.get(pos));
                    } else {
                        pstmt.setString(x, "#");
                    }
                    ++x;
                    ++pos;
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    attchMap.put(rst.getString("FBoID"), Boolean.TRUE);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"budget error:", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return attchMap;
    }

    @Override
    protected List _getAccountBizCostCenterNumber(Context ctx, String sql) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)sql)) {
            return null;
        }
        ArrayList<String[]> list = new ArrayList<String[]>();
        String[] array = null;
        IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (result.next()) {
                array = new String[]{result.getString(1), result.getString(2)};
                list.add(array);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    @Override
    protected Object _checkBatchUnAudit(Context ctx, List formIDs, BOSUuid userID, BOSUuid orgID) throws BOSException, EASBizException {
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        return utils.checkBatchUnAudit(formIDs, userID, orgID);
    }

    @Override
    protected Object _checkUnAudit(Context ctx, BOSUuid formId, BOSUuid orgId, BOSUuid userId) throws BOSException, EASBizException {
        this._checkCanAntiAudit(ctx, formId);
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        return utils.checkCanUnAudit(formId, orgId, userId, 1);
    }

    @Override
    protected Set _checkBizPastData(Context ctx, BOSUuid bgSchemeId, List billIds) throws BOSException, EASBizException {
        BizMbgDataControlUtils utils = new BizMbgDataControlUtils();
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_PARAM", String.valueOf(1));
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId.toString());
        return utils.checkBizPastData(ctx, billIds, auditParams);
    }

    @Override
    protected boolean _checkBizPastData(Context ctx, BOSUuid bgSchemeId, String billId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)billId)) {
            return false;
        }
        ArrayList<String> billIds = new ArrayList<String>();
        billIds.add(billId);
        Set hasIds = this._checkBizPastData(ctx, bgSchemeId, billIds);
        return hasIds != null && !hasIds.isEmpty();
    }

    @Override
    protected Map _batchAuditMbgData(Context ctx, List billIds, Map auditParams) throws BOSException, EASBizException {
        Map<Object, Object> result = new HashMap();
        if (billIds == null || billIds.isEmpty() || auditParams == null) {
            return result;
        }
        BizMbgDataControlUtils utils = new BizMbgDataControlUtils();
        result = utils.audit(ctx, billIds, auditParams);
        return result;
    }

    @Override
    protected Map _batchAntiAuditMbgData(Context ctx, List billIds, Map auditParams) throws BOSException, EASBizException {
        Map<Object, Object> result = new HashMap();
        if (billIds == null || billIds.isEmpty() || auditParams == null) {
            return result;
        }
        BizMbgDataControlUtils utils = new BizMbgDataControlUtils();
        result = utils.unAudit(ctx, billIds, auditParams);
        return result;
    }

    @Override
    protected Map _batchUnionReport(Context ctx, List billIds, Map auditParams) throws BOSException, EASBizException {
        Map<Object, Object> result = new HashMap();
        if (billIds == null || billIds.isEmpty() || auditParams == null) {
            return result;
        }
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(11));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(50));
        BizMbgDataControlUtils utils = new BizMbgDataControlUtils();
        result = utils.unionReport(ctx, billIds, auditParams);
        return result;
    }

    @Override
    protected Map _batchUnUnionReport(Context ctx, List billIds, Map auditParams) throws BOSException, EASBizException {
        Map<Object, Object> result = new HashMap();
        if (billIds == null || billIds.isEmpty() || auditParams == null) {
            return result;
        }
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(9));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(2));
        BizMbgDataControlUtils utils = new BizMbgDataControlUtils();
        result = utils.unionUnReport(ctx, billIds, auditParams);
        return result;
    }

    @Override
    protected List _checkIsReadOnly(final Context ctx, List bgFormIds) throws BOSException {
        final ArrayList result = new ArrayList();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return bgFormIds;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select form.FID,unit.FNAME_" + ctx.getLocale() + ",form.FNumber from T_MBG_BgForm form  inner join  T_MBG_BgTemplate template on form.FBGTEMPLATEID  = template.FID inner join T_org_baseUnit unit on form.FORGUNITID = unit.FID where template.FISREADONLY = ? and form.FID in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{1}, (Object[])bgFormIds.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String BgFormId = res.getString("FID");
                String name = res.getString("FNAME_" + ctx.getLocale());
                String number = res.getString("FNUMBER");
                String[] array = new String[3];
                array[0] = BgFormId;
                array[2] = number == null ? " " : number;
                array[1] = name == null ? " " : name;
                result.add(array);
            }
        });
        return result;
    }

    protected Map<String, String> getCourseParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(3));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(40));
        auditParams.put("AUDIT_PARAM", String.valueOf(7));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        if (BgNSHelper.isVerifyOfCourse()) {
            auditParams.put("CHECK_REPORT", String.valueOf(true));
        } else {
            auditParams.put("CHECK_REPORT", String.valueOf(false));
        }
        auditParams.put("CHECK_EXAMINE", String.valueOf(true));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(false));
        auditParams.put("AUDIT_COURSE_COMMENT_STATE", BgCourseOperateEnum.Course.getName());
        return auditParams;
    }

    protected Map<String, String> getBackParams(String bgSchemeId, String userId, String auditOrgId, boolean isReqMutex) {
        HashMap<String, String> auditParams = new HashMap<String, String>();
        auditParams.put("AUDIT_SCHEME_ID", bgSchemeId);
        auditParams.put("AUDIT_ORGUNIT_ID", auditOrgId);
        auditParams.put("AUDIT_USER_ID", userId);
        auditParams.put("AUDIT_DATA_STATE", String.valueOf(1));
        auditParams.put("AUDIT_BILL_STATE", String.valueOf(42));
        auditParams.put("AUDIT_PARAM", String.valueOf(8));
        if (isReqMutex) {
            auditParams.put("CHECK_MUTEX", String.valueOf(isReqMutex));
        }
        auditParams.put("CHECK_REPORT", String.valueOf(false));
        auditParams.put("CHECK_EXAMINE", String.valueOf(false));
        auditParams.put("CHECK_WORKFLOW", String.valueOf(false));
        return auditParams;
    }

    @Override
    protected void _checkTmpDataForBgNForm(Context ctx, IObjectValue bgForm) throws BOSException, EASBizException {
        if (ctx == null || bgForm == null) {
            return;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)bgForm;
        this.checkTmpData(ctx, bgFormInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _exportBgForms(Context ctx, String bgSchemeNum, String bgOrgUnitNums, String bgTemplateNums, String bgVersionNum, String bgPeriodNum, String exportPath) throws BOSException, EASBizException {
        int i;
        int i2;
        long begin = System.currentTimeMillis();
        logger.error((Object)"\u9884\u7b97\u8868\u540e\u53f0\u4e8b\u52a1\u5bfc\u51fa\u5f00\u59cb*************");
        logger.error((Object)("bgSchemeNum : " + bgSchemeNum));
        logger.error((Object)("bgOrgUnitNums : " + bgOrgUnitNums));
        logger.error((Object)("bgTemplateNums : " + bgTemplateNums));
        logger.error((Object)("bgVersionNum : " + bgVersionNum));
        logger.error((Object)("bgPeriodNum : " + bgPeriodNum));
        logger.error((Object)("exportPath : " + exportPath));
        BgSchemeInfo bgSchemeInfo = null;
        String bgOrgViewId = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            Locale locale = ctx.getLocale();
            IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
            if (StringUtils.isEmpty((String)bgSchemeNum)) {
                throw new BgFormExportException(BgFormExportException.BGSCHEMENUMNULL);
            }
            if (bgSchemeNum.indexOf(",") >= 0) {
                throw new BgFormExportException(BgFormExportException.BGSCHEMENUMMUTIL);
            }
            if (!iBgScheme.exists("where number = '" + bgSchemeNum.trim() + "'")) {
                throw new BgFormExportException(BgFormExportException.BGSCHEMENUMNOTEXIST);
            }
            bgSchemeInfo = MbgDataHelper.getBgSchemeByNumber(conn, locale, bgSchemeNum.trim());
            if (bgSchemeInfo == null) {
                throw new BgFormExportException(BgFormExportException.BGSCHEMENUMNOTEXIST);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        String bgSchemeId = bgSchemeInfo.getId().toString();
        BgSchemeDimensionHelper bgSchemeDimensionHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        bgOrgViewId = bgSchemeDimensionHelper.getBgOrgViewId();
        Map defaultMember = bgSchemeDimensionHelper.getDefaultMember();
        BgOrgUnitCollection bgOrgColls = null;
        if (!StringUtils.isEmpty((String)bgOrgUnitNums)) {
            HashMap<String, BgOrgUnitInfo> checkMap = new HashMap<String, BgOrgUnitInfo>();
            String[] arr = bgOrgUnitNums.split(",");
            HashSet<String> numberSet = new HashSet<String>();
            for (int i3 = 0; i3 < arr.length; ++i3) {
                numberSet.add(arr[i3]);
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
            bgOrgColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
            if (bgOrgColls != null && !bgOrgColls.isEmpty()) {
                for (int i4 = 0; i4 < bgOrgColls.size(); ++i4) {
                    checkMap.put(bgOrgColls.get(i4).getNumber(), bgOrgColls.get(i4));
                }
            }
            String errorNum = "";
            for (i2 = 0; i2 < arr.length; ++i2) {
                if (checkMap.containsKey(arr[i2])) continue;
                errorNum = errorNum + arr[i2];
                errorNum = errorNum + ",";
            }
            if (errorNum.endsWith(",")) {
                errorNum = errorNum.substring(0, errorNum.length() - 1);
            }
            if (!StringUtils.isEmpty((String)errorNum)) {
                throw new BgFormExportException(BgFormExportException.BGORGNUMNOTEXIST, new Object[]{errorNum});
            }
        }
        BgTemplateCollection bgTemplateColls = null;
        if (!StringUtils.isEmpty((String)bgTemplateNums)) {
            HashMap<String, BgTemplateInfo> checkMap = new HashMap<String, BgTemplateInfo>();
            String[] arr = bgTemplateNums.split(",");
            HashSet<String> numberSet = new HashSet<String>();
            for (int i5 = 0; i5 < arr.length; ++i5) {
                numberSet.add(arr[i5]);
            }
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", numberSet, CompareType.INCLUDE));
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
            bgTemplateColls = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(view);
            if (bgTemplateColls != null && !bgTemplateColls.isEmpty()) {
                for (i2 = 0; i2 < bgTemplateColls.size(); ++i2) {
                    checkMap.put(bgTemplateColls.get(i2).getNumber(), bgTemplateColls.get(i2));
                }
            }
            String errorNum = "";
            for (i = 0; i < arr.length; ++i) {
                if (checkMap.containsKey(arr[i])) continue;
                errorNum = errorNum + arr[i];
                errorNum = errorNum + ",";
            }
            if (errorNum.endsWith(",")) {
                errorNum = errorNum.substring(0, errorNum.length() - 1);
            }
            if (!StringUtils.isEmpty((String)errorNum)) {
                throw new BgFormExportException(BgFormExportException.BGTEMPLATENUMNOTEXIST, new Object[]{errorNum});
            }
        }
        if (StringUtils.isEmpty((String)bgVersionNum)) {
            if (defaultMember != null && defaultMember.containsKey(DimensionConstants.DEF_VERSION_NUMBER) && defaultMember.get(DimensionConstants.DEF_VERSION_NUMBER) instanceof BgVersionInfo) {
                bgVersionNum = ((BgVersionInfo)defaultMember.get(DimensionConstants.DEF_VERSION_NUMBER)).getNumber();
            }
            if (StringUtils.isEmpty((String)bgVersionNum)) {
                throw new BgFormExportException(BgFormExportException.BGVERSIONNUMNULL);
            }
        } else {
            if (bgVersionNum.indexOf(",") >= 0) {
                throw new BgFormExportException(BgFormExportException.BGVERSIONNUMMUTIL);
            }
            if (!BgVersionFactory.getLocalInstance((Context)ctx).exists("where number = '" + bgVersionNum + "'")) {
                throw new BgFormExportException(BgFormExportException.BGVERSIONNUMNOTEXIST, new Object[]{bgVersionNum});
            }
        }
        if (StringUtils.isEmpty((String)bgPeriodNum)) {
            if (defaultMember != null && defaultMember.containsKey(DimensionConstants.DEF_PERIOD_NUMBER) && defaultMember.get(DimensionConstants.DEF_PERIOD_NUMBER) instanceof BgPeriodInfo) {
                bgPeriodNum = ((BgPeriodInfo)defaultMember.get(DimensionConstants.DEF_PERIOD_NUMBER)).getNumber();
            }
            if (StringUtils.isEmpty((String)bgPeriodNum)) {
                throw new BgFormExportException(BgFormExportException.BGPERIODNUMNULL);
            }
        } else {
            if (bgPeriodNum.indexOf(",") >= 0) {
                throw new BgFormExportException(BgFormExportException.BGPERIODNUMMUTIL);
            }
            if (!BgPeriodFactory.getLocalInstance((Context)ctx).exists("where number = '" + bgPeriodNum + "'")) {
                throw new BgFormExportException(BgFormExportException.BGPERIODNUMNOTEXIST, new Object[]{bgPeriodNum});
            }
        }
        if (StringUtils.isEmpty((String)exportPath)) {
            throw new BgFormExportException(BgFormExportException.EXPORTPATHNULL);
        }
        HashSet<String> orgIds = new HashSet<String>();
        BgOrgUnitInfo bgOrgUnitInfo = null;
        if (bgOrgColls != null && !bgOrgColls.isEmpty()) {
            for (int i6 = 0; i6 < bgOrgColls.size(); ++i6) {
                bgOrgUnitInfo = bgOrgColls.get(i6);
                orgIds.add(bgOrgUnitInfo.getOrgUnitID());
                BgOrgUnitCollection colls = MbgDataHelper.getBgOrgUnitChildren(ctx, bgOrgUnitInfo, bgOrgViewId);
                if (colls == null || colls.isEmpty()) continue;
                for (int j = 0; j < colls.size(); ++j) {
                    orgIds.add(colls.get(j).getOrgUnitID());
                }
            }
        } else {
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id, orgUnitID where viewId = '" + bgOrgViewId + "'");
            if (colls != null && !colls.isEmpty()) {
                for (int j = 0; j < colls.size(); ++j) {
                    orgIds.add(colls.get(j).getOrgUnitID());
                }
            }
        }
        HashSet<String> bgTemplateIds = new HashSet<String>();
        if (bgTemplateColls != null && !bgTemplateColls.isEmpty()) {
            for (int i7 = 0; i7 < bgTemplateColls.size(); ++i7) {
                bgTemplateIds.add(bgTemplateColls.get(i7).getId().toString());
            }
        } else {
            BgTemplateCollection colls = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection("select id where bgScheme.id = '" + bgSchemeId + "'");
            if (colls != null && !colls.isEmpty()) {
                for (i2 = 0; i2 < colls.size(); ++i2) {
                    bgTemplateIds.add(colls.get(i2).getId().toString());
                }
            }
        }
        HashSet<String> bgVersionIds = new HashSet<String>();
        BgVersionCollection bgVersionColls = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionCollection("where number = '" + bgVersionNum + "'");
        if (bgVersionColls != null && !bgVersionColls.isEmpty()) {
            for (i = 0; i < bgVersionColls.size(); ++i) {
                bgVersionIds.add(bgVersionColls.get(i).getId().toString());
            }
        }
        HashSet<String> bgPeriodIds = new HashSet<String>();
        BgPeriodCollection bgPeriodCollection = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection("where number = '" + bgPeriodNum + "'");
        if (bgPeriodCollection != null && !bgPeriodCollection.isEmpty()) {
            for (int i8 = 0; i8 < bgPeriodCollection.size(); ++i8) {
                bgPeriodIds.add(bgPeriodCollection.get(i8).getId().toString());
            }
        }
        Map<String, Set<String>> bgFormMap = this.queryExportBgForms(ctx, bgSchemeId, orgIds, bgVersionIds, bgPeriodIds, bgTemplateIds);
        BgFormExportServerThread bgFormExportServerThread = new BgFormExportServerThread(ctx, bgOrgViewId, bgFormMap, exportPath);
        Map<String, Boolean> result = bgFormExportServerThread.export();
        logger.error((Object)("\u9884\u7b97\u8868\u540e\u53f0\u4e8b\u52a1\u5bfc\u51fa \u7ed3\u675f ,\u8017\u65f6\u4e3a\uff1a" + (System.currentTimeMillis() - begin) + "ms"));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Map<String, Set<String>> queryExportBgForms(Context ctx, String bgSchemeId, Set<String> orgIds, Set<String> bgVersionIds, Set<String> bgPeriodIds, Set<String> bgTemplateIds) throws BOSException {
        HashMap<String, Set<String>> bgFormMap = new HashMap<String, Set<String>>();
        if (StringUtils.isEmpty((String)bgSchemeId)) return bgFormMap;
        if (this.isEmpty(orgIds)) return bgFormMap;
        if (this.isEmpty(bgVersionIds)) return bgFormMap;
        if (this.isEmpty(bgPeriodIds)) return bgFormMap;
        if (this.isEmpty(bgTemplateIds)) {
            return bgFormMap;
        }
        String tmpOrgUnitTable = null;
        String tmpBgPeriodTable = null;
        String tmpTemplateTable = null;
        String tmpVersionTable = null;
        Connection conn = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BgFormCollection bgFormList = new BgFormCollection();
        try {
            conn = this.getConnection(ctx);
            tmpOrgUnitTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgUnitTable + " (FID) values (?)"), orgIds);
            tmpVersionTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpVersionTable + " (FID) values (?)"), bgVersionIds);
            tmpBgPeriodTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpBgPeriodTable + " (FID) values (?)"), bgPeriodIds);
            tmpTemplateTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTemplateTable + " (FID) values (?)"), bgTemplateIds);
            StringBuffer queryBgFormSql = new StringBuffer();
            queryBgFormSql.append(" select t0.fid, t0.forgunitid from t_mbg_bgform t0 Left Join T_MBG_BgSpecialItems t1 ON t0.FID = t1.FBgFormId where t0.forgunitid in (select FID from " + tmpOrgUnitTable + ") and t0.fbgschemeid = ? ");
            queryBgFormSql.append(" and t0.fbgtemplateid in (select FID From " + tmpTemplateTable + ") and t0.fbgperiodid in (select FID from " + tmpBgPeriodTable + ") and t0.fbgversionId in (select FID from " + tmpVersionTable + ") and t0.fstate not in (").append(5).append(",").append(15).append(" )");
            queryBgFormSql.append(" and t0.fid not in (select fadjustId from t_mbg_bgform where fstate in (").append(4).append(",").append(35).append("))");
            pstmt = conn.prepareStatement(queryBgFormSql.toString());
            pstmt.setString(1, bgSchemeId);
            rs = pstmt.executeQuery();
            String orgId = null;
            String bgFormId = null;
            while (rs.next()) {
                orgId = rs.getString("forgunitid");
                bgFormId = rs.getString("fid");
                if (!bgFormMap.containsKey(orgId)) {
                    bgFormMap.put(orgId, new HashSet());
                }
                ((Set)bgFormMap.get(orgId)).add(bgFormId);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpOrgUnitTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpTemplateTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpBgPeriodTable);
                    BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, tmpVersionTable);
                }
                catch (Exception e2) {
                    logger.error((Object)"", (Throwable)e2);
                    throw new BOSException((Throwable)e2);
                }
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        try {
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpOrgUnitTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpTemplateTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpBgPeriodTable);
            BgDBUtils.releaseDBTmpTable((Connection)conn, (TempTablePool)pool, (String)tmpVersionTable);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return bgFormMap;
    }

    protected boolean isEmpty(Collection colls) {
        return colls == null || colls.isEmpty();
    }

    private String getBgDimNumber(Map<String, MbgDimInfo> mbgDimMap, String bgDimNumber) {
        if (StringUtils.isEmpty((String)bgDimNumber)) {
            return bgDimNumber;
        }
        TreeMap<String, String> dimMap = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                String str1 = o1.substring(1);
                String str2 = o2.substring(1);
                return Integer.valueOf(str1).compareTo(Integer.valueOf(str2));
            }
        });
        String[] tmpNums = bgDimNumber.split(",");
        int in = tmpNums.length;
        for (int i = 0; i < in; ++i) {
            String[] tmpStr = tmpNums[i].split(":");
            if (!mbgDimMap.containsKey(tmpStr[0])) {
                return bgDimNumber;
            }
            dimMap.put(mbgDimMap.get(tmpStr[0]).getRefField(), tmpNums[i]);
        }
        StringBuffer dimNumber = new StringBuffer();
        Iterator iter = dimMap.values().iterator();
        while (iter.hasNext()) {
            dimNumber.append((String)iter.next() + ",");
        }
        dimNumber = dimNumber.delete(dimNumber.length() - 1, dimNumber.length());
        return dimNumber.toString();
    }
}

