/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.IBgOrgView;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.ITemplateFacade;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgNFormFilterUIHandler;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class BgNFormFilterUIHandler
extends AbstractBgNFormFilterUIHandler {
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd 00:00:00");

    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        Date date;
        super._handleInit(request, response, context);
        String orgUnitId = (String)request.get(BgBaseConstants.ORGUNIT_ID);
        boolean isDisplayFiled = (Boolean)request.get("isDisplayFilled");
        boolean isOnlySelf = (Boolean)request.get("isOnlySelf");
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo _filter = new FilterInfo();
        Set bgSchemeIds = null;
        try {
            if (orgUnitId != null) {
                bgSchemeIds = this.getBgSchemeInterface(context).getCollection4SchemeList(orgUnitId, true);
            }
            if (bgSchemeIds != null && !bgSchemeIds.isEmpty()) {
                HashSet<String> colls = new HashSet<String>();
                for (Object object : bgSchemeIds) {
                    colls.add(object.toString());
                }
                _filter.getFilterItems().add(new FilterItemInfo("id", colls, CompareType.INCLUDE));
            } else {
                _filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
            }
        }
        catch (Exception ex) {
            _filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        if (isDisplayFiled) {
            _filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)0, CompareType.EQUALS));
        } else if (isOnlySelf) {
            _filter.getFilterItems().add(new FilterItemInfo("id", (Object)"Select FBgSchemeId FROM T_Mbg_BgTemplate Where FBgTypeId = 'bgMAAAAKIcA7rHKd'", CompareType.INNER));
        }
        try {
            date = this.sdf.parse(this.sdf.format(new Date()));
        }
        catch (ParseException e) {
            date = new Date();
        }
        view.setFilter(_filter);
        view.getFilter().getFilterItems().add(new FilterItemInfo("isFormal", (Object)Boolean.TRUE, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("dateFrom", (Object)date, CompareType.LESS_EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("dateTo", (Object)date, CompareType.GREATER_EQUALS));
        BgSchemeCollection coll = this.getBgSchemeInterface(context).getBgSchemeCollection(view);
    }

    public void handleGetQueryExecutor(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    protected IBgScheme getBgSchemeInterface(Context context) throws Exception {
        return BgSchemeFactory.getLocalInstance(context);
    }

    protected ITemplateFacade getTemplateFacadeInterface(Context context) throws Exception {
        return TemplateFacadeFactory.getLocalInstance(context);
    }

    protected IBgOrgView getBgOrgViewInterface(Context context) throws Exception {
        return BgOrgViewFactory.getLocalInstance(context);
    }

    protected IBgOrgUnit getBgOrgUnitInterface(Context context) throws Exception {
        return BgOrgUnitFactory.getLocalInstance(context);
    }
}

