/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ctrl.swing.tree.KingdeeTreeModel;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgF7InnerUtils;
import com.kingdee.eas.basedata.org.OrgStructureCollection;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.PropertyRefSourceFactory;
import com.kingdee.eas.ma.base.app.utils.BgIntIdHelper;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormEntryFactory;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewCollection;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgPeriodNameEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgFormEntry;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.app.AbstractBgOrgUnitControllerBean;
import com.kingdee.eas.ma.mbg.app.data.BgOrgMigrationUtils;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class BgOrgUnitControllerBean
extends AbstractBgOrgUnitControllerBean {
    private static final long serialVersionUID = 4314565990739438307L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgOrgUnitControllerBean");
    private static final String CHECK = "BGORGUNITCHECK";
    private static final String ENCODING = "UTF-8";
    private static final String NUMBER = "number";
    private static final String BG_Org = "BG_Organization";
    private static final String VALUE = "value";
    private static final String MEMBER = "selectMember";
    private static final String COMMA = ",";

    @Override
    protected IObjectValue _getValue(Context ctx, BOSUuid bgViewId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgViewId == null || orgUnitId == null) {
            return null;
        }
        BgOrgUnitInfo bgOrgUnit = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)"select FID from T_MBG_BgOrgUnit where FViewId = ? and FOrgUnitId = ?", (Object[])new Object[]{bgViewId.toString(), orgUnitId.toString()});
            if (rst.next()) {
                bgOrgUnit = (BgOrgUnitInfo)this._getValue(ctx, (IObjectPK)new ObjectStringPK(rst.getString("FID")));
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgOrgUnit;
    }

    @Override
    protected BOSUuid _getBuildTreeOrgUnitId(Context ctx, BOSUuid orgUnitId, BOSUuid orgViewId) throws BOSException, EASBizException {
        if (orgUnitId == null) {
            return null;
        }
        if (orgViewId == null) {
            return orgUnitId;
        }
        if (this._exists(ctx, "where orgUnitId = '" + orgUnitId + "' and viewId = '" + orgViewId + "'")) {
            return orgUnitId;
        }
        BgOrgUnitInfo orgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select orgUnitId where viewId = '" + orgViewId + "' and level = 1");
        return BOSUuid.read((String)orgUnit.getOrgUnitID());
    }

    @Override
    protected TreeModel _getFullOrgModel(Context ctx, String orgUnitId, String orgViewId) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgViewId)) {
            return null;
        }
        DefaultKingdeeTreeNode root = null;
        DefaultKingdeeTreeNode nodeOld = null;
        DefaultKingdeeTreeNode nodeNew = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        boolean hasOrgRange = false;
        String rootLongNumber = null;
        String parentId = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        PreparedStatement pstmt1 = null;
        ResultSet rst = null;
        String sql = null;
        String tmpTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            conn = this.getConnection(ctx);
            if (!StringUtils.isEmpty((String)orgUnitId)) {
                sql = "Select FLongNumber FROM T_MBg_BgOrgUnit Where FViewId = ? AND FOrgUnitId = ?";
                pstmt = conn.prepareStatement(sql);
                pstmt.setString(1, BOSUuid.read((String)orgViewId).toString());
                pstmt.setString(2, BOSUuid.read((String)orgUnitId).toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    rootLongNumber = rst.getString(1);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            sql = "Create Table T_MBg_TMPModel(FID Varchar(44) NOT NULL, FOrgUnitId Varchar(44) NOT NULL, FNumber NVarchar(80) NOT NULL, FName NVarchar(255), FLongNumber NVarchar(1024) NOT NULL, FIsOUSealUp INT Default 0 NOT NULL, FLevel INT Default 0 NOT NULL, FIsLeaf INT Default 0 NOT NULL, FHasOrgRange INT Default 0 NOT NULL, FParentID Varchar(44), FHasSub INT Default 0 NOT NULL)";
            tmpTable = pool.createTempTable(sql);
            sql = "Insert Into " + tmpTable + "(FID, FOrgUnitId, FNumber, FName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FParentID) Select FID, FOrgUnitId, FNumber, FName_" + ctx.getLocale() + ", FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FParentID FROM T_MBg_BgOrgUnit Where FViewId = ? and FisVirtual = 0";
            if (!StringUtils.isEmpty(rootLongNumber)) {
                sql = sql + " AND(FLongNumber = ? OR FLongNumber Like ?)";
            }
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, orgViewId);
            if (!StringUtils.isEmpty((String)rootLongNumber)) {
                pstmt.setString(2, rootLongNumber);
                pstmt.setString(3, rootLongNumber + "!%");
            }
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            sql = "Update " + tmpTable + " t1 Set FHasOrgRange = 1 Where exists (Select FID FROM " + BgDBUtils.getOrgRangeTable((Context)ctx) + " t2 Where t2.FUserID = ? AND t2.FOrgID = t1.FOrgUnitId)";
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
            pstmt.executeUpdate();
            SQLUtils.cleanup((Statement)pstmt);
            int maxLevel = 0;
            sql = "Select Max(FLevel) FROM " + tmpTable;
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                maxLevel = rst.getInt(1);
            }
            SQLUtils.cleanup((Statement)pstmt);
            sql = "Update " + tmpTable + " t1 Set FHasSub = 1 Where FLevel = ? AND exists (Select FID FROM " + tmpTable + " t2 Where t2.FParentID = t1.FID)";
            pstmt = conn.prepareStatement(sql);
            sql = "Delete FROM " + tmpTable + " Where FLevel = ? AND FHasSub = 0 AND (FIsOUSealUp = 1 OR FHasOrgRange = 0)";
            pstmt1 = conn.prepareStatement(sql);
            for (int level = maxLevel; level > 0; --level) {
                pstmt.setInt(1, level);
                pstmt.executeUpdate();
                pstmt1.setInt(1, level);
                pstmt1.executeUpdate();
            }
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((Statement)pstmt1);
            sql = "Select FID, FOrgUnitId, FNumber, FName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FHasOrgRange, FParentID FROM " + tmpTable + " Order By FLongNumber";
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgOrgUnitInfo = new BgOrgUnitInfo();
                bgOrgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgOrgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitId"));
                bgOrgUnitInfo.setNumber(rst.getString("FNumber"));
                bgOrgUnitInfo.setName(rst.getString("FName"));
                bgOrgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                bgOrgUnitInfo.setIsOUSealUp(rst.getBoolean("FIsOUSealUp"));
                bgOrgUnitInfo.setLevel(rst.getInt("FLevel"));
                bgOrgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                hasOrgRange = rst.getBoolean("FHasOrgRange");
                parentId = rst.getString("FParentID");
                if (!StringUtils.isEmpty((String)parentId)) {
                    bgOrgUnitInfo.setParent(new BgOrgUnitInfo());
                    bgOrgUnitInfo.getParent().setId(BOSUuid.read((String)parentId));
                }
                nodeNew = new DefaultKingdeeTreeNode((Object)bgOrgUnitInfo);
                if (bgOrgUnitInfo.isIsOUSealUp() || !hasOrgRange) {
                    OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)nodeNew);
                }
                if (nodeOld != null) {
                    nodeOld = this.findParentNode(nodeOld, parentId);
                    nodeOld.add((MutableTreeNode)nodeNew);
                }
                if (root == null) {
                    root = nodeNew;
                }
                nodeOld = nodeNew;
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                SQLUtils.cleanup(pstmt1, (Connection)conn);
                if (tmpTable != null) {
                    pool.releaseTable(tmpTable);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        SQLUtils.cleanup((Statement)pstmt1, (Connection)conn);
        if (tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
        if (root != null) {
            return new KingdeeTreeModel(root);
        }
        return null;
    }

    private DefaultKingdeeTreeNode findParentNode(DefaultKingdeeTreeNode node, String parentId) {
        if (StringUtils.isEmpty((String)parentId) || node == null) {
            return null;
        }
        if (((BgOrgUnitInfo)node.getUserObject()).getId().toString().equals(parentId)) {
            return node;
        }
        return this.findParentNode((DefaultKingdeeTreeNode)node.getParent(), parentId);
    }

    @Override
    protected Set _getHasBgDataOrgIds(Context ctx, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (bgOrgViewId == null) {
            return idSet;
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Set<String> refCubeTables = this.getRefCubeTableName(conn, bgOrgViewId);
            if (refCubeTables == null || refCubeTables.isEmpty()) {
                HashSet<String> hashSet = idSet;
                return hashSet;
            }
            for (String cubename : refCubeTables) {
                idSet.addAll(this.getHasBgDataOrgUnit(ctx, conn, cubename));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return idSet;
    }

    private Set<String> getHasBgDataOrgUnit(Context ctx, Connection conn, String refCubeName) throws BOSException, SQLException, EASBizException {
        HashSet<String> idSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)refCubeName)) {
            return idSet;
        }
        String[] cubeNames = new String[]{refCubeName};
        int length = cubeNames.length;
        for (int i = 0; i < length; ++i) {
            idSet.addAll(this.getHasBgDataOrgUnitFromCube(ctx, conn, cubeNames[i]));
            idSet.addAll(this.getHasDailyDataOrgUnitFromCube(conn, cubeNames[i]));
        }
        return idSet;
    }

    private Set<String> getHasBgDataOrgUnitFromCube(Context ctx, Connection conn, String cubeName) throws BOSException, EASBizException {
        BgSchemeAccIntHelper accIntHelper;
        IRowSet rowset;
        HashSet<String> idSet;
        block9: {
            idSet = new HashSet<String>();
            if (StringUtils.isEmpty((String)cubeName)) {
                return idSet;
            }
            rowset = null;
            String schemeSql = "Select FID FROM T_MBG_BgScheme Where FRefCube = ?";
            rowset = BgDBUtils.executeQuery((Connection)conn, (String)schemeSql, (Object[])new Object[]{cubeName});
            accIntHelper = null;
            if (rowset.next()) {
                accIntHelper = new BgSchemeAccIntHelper(ctx, rowset.getString(1), cubeName);
            }
            SQLUtils.cleanup((ResultSet)rowset);
            if (accIntHelper != null) break block9;
            HashSet<String> hashSet = idSet;
            SQLUtils.cleanup((ResultSet)rowset);
            return hashSet;
        }
        try {
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            for (String tableName : cubeNames) {
                String sql = "select FORGUNITID from " + tableName + " where FScenario in (select FScenarioId from T_MBG_BgScenario where FType = 0) group by FORGUNITID";
                rowset = BgDBUtils.executeQuery((Connection)conn, (String)sql);
                while (rowset.next()) {
                    idSet.add(rowset.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rowset);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return idSet;
    }

    private Set<String> getHasDailyDataOrgUnitFromCube(Connection conn, String cubeName) throws BOSException {
        HashSet<String> idSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)cubeName)) {
            return idSet;
        }
        String dailyCube = BgCubeUtils.getDailyActualCubeName(cubeName);
        IRowSet rowset = null;
        try {
            rowset = BgDBUtils.executeQuery((Connection)conn, (String)("select FORGUNITID from " + dailyCube + " group by FORGUNITID"));
            while (rowset.next()) {
                idSet.add(rowset.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return idSet;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Set<String> getRefCubeTableName(Connection conn, BOSUuid bgOrgViewID) throws BOSException {
        HashSet<String> refCubeTables = new HashSet<String>();
        if (conn == null) return refCubeTables;
        if (bgOrgViewID == null) {
            return refCubeTables;
        }
        IRowSet rowset = null;
        String sql = null;
        try {
            sql = "SELECT sc.FREFCUBE FROM t_mbg_bgScheme sc LEFT OUTER JOIN t_mbg_bgDimSettings st on st.fbgSchemeid = sc.fid   LEFT OUTER JOIN t_mbg_bgDimSettingsMember dm on dm.fbgDimSettingsid = st.fid  LEFT OUTER JOIN T_mbg_bgOrgView p on p.fid = dm.fmemberid  where  p.fid = ?";
            rowset = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{bgOrgViewID.toString()});
            while (rowset.next()) {
                refCubeTables.add(rowset.getString(1));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BOSException((Throwable)ex);
                catch (Exception ex2) {
                    logger.error((Object)ex2);
                    throw new BOSException((Throwable)ex2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return refCubeTables;
    }

    @Override
    protected Map _checkHasRelationOrTemplate(Context ctx, Set bgOrgIds) throws BOSException, EASBizException {
        List tempList;
        String bgSchemeIdTable;
        String checkTable;
        String orgRelationTable;
        TempTablePool pool;
        Connection conn;
        ArrayList<Object[]> insertChild;
        ArrayList<Object[]> insertThis;
        HashSet hasTemplate;
        HashSet hasRelation;
        HashMap result;
        block10: {
            result = new HashMap();
            hasRelation = new HashSet();
            hasTemplate = new HashSet();
            result.put("hasRelation", hasRelation);
            result.put("hasTemplate", hasTemplate);
            if (bgOrgIds == null || bgOrgIds.isEmpty()) {
                return result;
            }
            String orgViewId = null;
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("viewId");
            evi.getSelector().add("orgUnitId");
            evi.getSelector().add("longNumber");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgOrgIds, CompareType.INCLUDE));
            BgOrgUnitCollection col = this.getBgOrgUnitCollection(ctx, evi);
            if (col == null || col.isEmpty()) {
                return result;
            }
            insertThis = new ArrayList<Object[]>();
            insertChild = new ArrayList<Object[]>();
            BgOrgUnitInfo info = null;
            for (int i = 0; i < col.size(); ++i) {
                info = col.get(i);
                orgViewId = info.getViewID();
                insertThis.add(new Object[]{info.getId().toString(), info.getOrgUnitID()});
                insertChild.add(new Object[]{info.getId().toString(), orgViewId, info.getLongNumber() + "!%"});
            }
            conn = null;
            pool = TempTablePool.getInstance((Context)ctx);
            orgRelationTable = null;
            checkTable = null;
            bgSchemeIdTable = null;
            conn = this.getConnection(ctx);
            orgRelationTable = pool.createTempTable("Create Table T_MBG_OrgRelation(FBgOrgUnitId Varchar(44) NOT NULL, FChildOrgUnitId Varchar(44) NOT NULL)");
            checkTable = pool.createTempTable("Create Table T_MBG_CheckTab(FOrgUnitId Varchar(44) NOT NULL Primary KEY, FHasRelation INT DEFAULT(0) NOT NULL, FHasTemplate INT DEFAULT(0) NOT NULL)");
            bgSchemeIdTable = pool.createTempTable("Create Table T_MBG_BgSchemeId(FID Varchar(44) NOT NULL Primary KEY)");
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + bgSchemeIdTable + "(FID) Select FBgSchemeId FROM t_mbg_bgDimSettings Where FID IN(Select fbgDimSettingsid FROM t_mbg_bgDimSettingsMember Where fmemberid = ?)"), (Object)new Object[]{orgViewId});
            tempList = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select TOP 1 FID FROM " + bgSchemeIdTable), null);
            if (tempList != null && !tempList.isEmpty()) break block10;
            HashMap hashMap = result;
            pool.releaseTable(orgRelationTable);
            pool.releaseTable(checkTable);
            pool.releaseTable(bgSchemeIdTable);
            SQLUtils.cleanup((Connection)conn);
            return hashMap;
        }
        try {
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + orgRelationTable + "(FBgOrgUnitId, FChildOrgUnitId) Values(?, ?)"), insertThis);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + orgRelationTable + "(FBgOrgUnitId, FChildOrgUnitId) Select ?, FOrgUnitId FROM T_MBg_BgOrgUnit Where FViewId = ? AND FLongNumber LIKE ?"), insertChild);
            MbgSqlHelper.execute((Connection)conn, (String)("Insert Into " + checkTable + "(FOrgUnitId) Select Distinct FChildOrgUnitId FROM " + orgRelationTable));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + checkTable + " t0 Set FHasRelation = 1 Where Exists(Select FID FROM T_MBG_DimensionRelationship t1 Where t1.FCostUnitID = t0.FOrgUnitId AND FDimensionGroupID IN(Select FID FROM T_MBG_DimensionRelationGroup Where FBgSchemeId IN(Select FID FROM " + bgSchemeIdTable + ")))"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + checkTable + " t0 Set FHasTemplate = 1 Where Exists(Select FID FROM T_MBG_BgTemplate t1 Where t1.FOrgUnitID = t0.FOrgUnitId AND FBgSchemeId IN(Select FID FROM " + bgSchemeIdTable + "))"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + checkTable + " t0 Set FHasTemplate = 1 Where Exists(Select FID FROM T_MBG_BgTemplateNode t1 Where t1.FOrgUnitID = t0.FOrgUnitId AND FBgTemplateId IN(Select FID FROM T_MBg_BgTemplate Where FBgSchemeId IN(Select FID FROM " + bgSchemeIdTable + ")))"));
            tempList = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select FBgOrgUnitId FROM " + orgRelationTable + " Where FChildOrgUnitId IN(Select FOrgUnitId FROM " + checkTable + " Where FHasRelation = 1)"), null);
            if (tempList != null && !tempList.isEmpty()) {
                hasRelation.addAll(tempList);
            }
            if ((tempList = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)("Select FBgOrgUnitId FROM " + orgRelationTable + " Where FChildOrgUnitId IN(Select FOrgUnitId FROM " + checkTable + " Where FHasTemplate = 1)"), null)) != null && !tempList.isEmpty()) {
                hasTemplate.addAll(tempList);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                pool.releaseTable(orgRelationTable);
                pool.releaseTable(checkTable);
                pool.releaseTable(bgSchemeIdTable);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        pool.releaseTable(orgRelationTable);
        pool.releaseTable(checkTable);
        pool.releaseTable(bgSchemeIdTable);
        SQLUtils.cleanup((Connection)conn);
        return result;
    }

    @Override
    protected Map _ouSealUp(Context ctx, String bgOrgViewID, List ids) throws BOSException, EASBizException {
        Map<String, IObjectPK> logpkMap = this.printDoSealUpLog(ctx, bgOrgViewID, ids, false);
        Map resultMap = this.doSealUp(ctx, ids, false, bgOrgViewID);
        HashMap checkMap = new HashMap();
        if (resultMap != null && resultMap.containsKey("sealup_check_virtual")) {
            checkMap.putAll((Map)resultMap.get("sealup_check_virtual"));
        }
        for (Map.Entry<String, IObjectPK> entry : logpkMap.entrySet()) {
            if (checkMap.containsKey(entry.getKey())) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)entry.getValue());
        }
        return resultMap;
    }

    @Override
    protected Map _ouUnSealUp(Context ctx, String bgOrgViewID, List ids) throws BOSException, EASBizException {
        Map<String, IObjectPK> logpkMap = this.printDoSealUpLog(ctx, bgOrgViewID, ids, true);
        Map resultMap = this.doSealUp(ctx, ids, true, bgOrgViewID);
        HashMap checkMap = new HashMap();
        if (resultMap != null && resultMap.containsKey("sealup_check_number")) {
            checkMap.putAll((Map)resultMap.get("sealup_check_number"));
        }
        for (Map.Entry<String, IObjectPK> entry : logpkMap.entrySet()) {
            if (checkMap.containsKey(entry.getKey())) continue;
            LogUtil.afterLog((Context)ctx, (IObjectPK)entry.getValue());
        }
        return resultMap;
    }

    private Map<String, IObjectPK> printDoSealUpLog(Context ctx, String bgOrgViewID, List ids, boolean isSealUp) throws BOSException {
        HashMap<String, IObjectPK> logpkMap = new HashMap<String, IObjectPK>();
        if (ids == null || ids.isEmpty()) {
            return logpkMap;
        }
        BgOrgUnitCollection colls = this.getOrgUnitCollByIds(ctx, new HashSet(ids));
        if (colls == null || colls.isEmpty()) {
            return logpkMap;
        }
        ObjectUuidPK bgOrgViewPk = new ObjectUuidPK(bgOrgViewID);
        BOSObjectType bgOrgViewType = new BgOrgViewInfo().getBOSType();
        String methodName = isSealUp ? "ouUnSealUp" : "ouSealUp";
        String logItemName = isSealUp ? "mbg_bgorgview_ouunsealup" : "mbg_bgorgview_ousealup";
        for (int index = 0; index < colls.size(); ++index) {
            BgOrgUnitInfo info = colls.get(index);
            IObjectPK pk = LogUtil.beginLog((Context)ctx, (String)methodName, (BOSObjectType)bgOrgViewType, (IObjectPK)bgOrgViewPk, (String)(info.getNumber() + "_" + info.getName()), (String)logItemName);
            logpkMap.put(info.getId().toString(), pk);
        }
        return logpkMap;
    }

    private Map doSealUp(Context ctx, List ids, Boolean isSealUp, String viewId) throws EASBizException, BOSException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>();
        ArrayList<String> updateIds = null;
        if (isSealUp.booleanValue()) {
            Map<String, String> checkMap = this.checkSealUp(ctx, ids);
            if (!checkMap.isEmpty()) {
                updateIds = new ArrayList<String>();
                Set<String> checkSet = checkMap.keySet();
                for (int index = 0; index < ids.size(); ++index) {
                    if (checkSet.contains(ids.get(index))) continue;
                    updateIds.add((String)ids.get(index));
                }
                resultMap.put("sealup_check_number", checkMap);
            } else {
                updateIds = ids;
            }
        } else {
            updateIds = this.getSealUpIds(ctx, ids, viewId);
        }
        if (updateIds != null && !updateIds.isEmpty()) {
            HashMap<String, String> checkOrgMap = new HashMap<String, String>();
            BgOrgUnitCollection colls = this.getOrgUnitCollByIds(ctx, new HashSet(updateIds));
            BgOrgUnitInfo info = null;
            if (colls != null && !colls.isEmpty()) {
                for (int index = 0; index < colls.size(); ++index) {
                    info = colls.get(index);
                    if (info == null || !info.isIsVirtual()) continue;
                    checkOrgMap.put(info.getId().toString(), info.getNumber());
                    updateIds.remove(info.getId().toString());
                }
            }
            if (!checkOrgMap.isEmpty()) {
                resultMap.put("sealup_check_virtual", checkOrgMap);
            }
        }
        if (updateIds != null && !updateIds.isEmpty()) {
            this.updateSealUpState(ctx, updateIds, isSealUp, viewId);
        }
        return resultMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, String> checkSealUp(Context ctx, List ids) throws EASBizException, BOSException {
        IRowSet rst;
        Connection conn;
        LinkedHashMap<String, String> checkMap;
        block7: {
            checkMap = new LinkedHashMap<String, String>();
            if (ids == null) return checkMap;
            if (ids.isEmpty()) {
                return checkMap;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            rst = null;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), (Collection)ids);
                String sql = "Select a.FId, a.FNumber, a.FParentId, p.FISOUSEALUP From T_MBG_BGORGUNIT a  Join T_MBG_BGORGUNIT p on a.FPARENTID = p.FID Where a.FID in (Select FID from " + tmpTable + ") Order by a.FLongNumber";
                String id = null;
                String parentId = null;
                String number = null;
                boolean isSealUp = true;
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql);
                while (rst.next()) {
                    id = rst.getString("FID");
                    parentId = rst.getString("FParentId");
                    if (StringUtils.isEmpty((String)parentId)) continue;
                    number = rst.getString("FNumber");
                    isSealUp = rst.getBoolean("FISOUSEALUP");
                    if (!isSealUp || !checkMap.containsKey(parentId) && ids.contains(parentId)) continue;
                    checkMap.put(id, number);
                }
                if (tmpTable == null) break block7;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                    }
                    SQLUtils.cleanup(rst, null, (Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return checkMap;
    }

    private List<String> getSealUpIds(Context ctx, List ids, String orgViewId) throws BOSException, EASBizException {
        if (ids == null || ids.isEmpty()) {
            return null;
        }
        BgOrgUnitCollection colls = this.getOrgUnitCollByIds(ctx, new HashSet(ids));
        List<BgOrgUnitInfo> rootLst = this.getRootLst(colls);
        BgOrgUnitCollection OrgUnitCols = null;
        BgOrgUnitInfo info = null;
        ArrayList<String> sealUpIds = new ArrayList<String>();
        for (int i = 0; i < rootLst.size(); ++i) {
            sealUpIds.add(rootLst.get(i).getId().toString());
            OrgUnitCols = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id ,IsOUSealUp where longnumber like '" + rootLst.get(i).getLongNumber() + "!%' and viewId = '" + orgViewId + "'");
            if (OrgUnitCols == null || OrgUnitCols.isEmpty()) continue;
            for (int j = 0; j < OrgUnitCols.size(); ++j) {
                info = OrgUnitCols.get(j);
                if (info.isIsOUSealUp()) continue;
                sealUpIds.add(OrgUnitCols.get(j).getId().toString());
            }
        }
        return sealUpIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSealUpState(Context ctx, List ids, Boolean isSealUp, String bgOrgViewID) throws EASBizException, BOSException {
        Connection conn;
        block6: {
            if (ids == null) return;
            if (ids.isEmpty()) {
                return;
            }
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            Date lastUpdateTime = new Date(System.currentTimeMillis());
            String curUserID = ctx.getCaller().toString();
            int sealUp = isSealUp != false ? 0 : 1;
            try {
                conn = BgDBUtils.getConnection((Context)ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), (Collection)ids);
                StringBuffer sql = new StringBuffer("UPDATE T_MBG_BGORGUNIT SET FISOUSEALUP = ").append(sealUp).append(", FLASTUPDATETIME = now()").append(" ,FLASTUPDATEUSERID = '").append(curUserID).append("'").append(" WHERE ").append(" FOrgUnitID in(Select FOrgUnitId FROM T_MBG_BGORGUNIT Where FID IN(Select FID From " + tmpTable + ")) And FVIEWID = '").append(bgOrgViewID).append("'");
                DbUtil.execute((Context)ctx, (String)sql.toString());
                if (tmpTable == null) break block6;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private BgOrgUnitCollection getOrgUnitCollByIds(Context ctx, Set idSet) throws BOSException {
        IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(NUMBER);
        sic.add("name");
        sic.add("longNumber");
        sic.add("parent.id");
        sic.add("parent.number");
        sic.add("parent.name");
        sic.add("parent.longNumber");
        sic.add("parent.viewId");
        sic.add("viewId");
        sic.add("isVirtual");
        sic.add("isSystemDefault");
        sic.add("orgunit.id");
        sic.add("orgunit.number");
        sic.add("orgunit.name");
        sic.add("CU.id");
        sic.add("CU.number");
        sic.add("CU.name");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("longNumber"));
        return iBgOrgUnit.getBgOrgUnitCollection(view);
    }

    private List<BgOrgUnitInfo> getRootLst(BgOrgUnitCollection colls) {
        ArrayList<BgOrgUnitInfo> rootLst = new ArrayList<BgOrgUnitInfo>();
        if (colls == null || colls.isEmpty()) {
            return rootLst;
        }
        int size = colls.size();
        BgOrgUnitInfo info = null;
        BgOrgUnitInfo pInfo = null;
        String longNum = null;
        String pLongNum = null;
        for (int i = size - 1; i >= 0; --i) {
            boolean isRoot = true;
            pInfo = colls.get(i);
            pLongNum = pInfo.getLongNumber();
            for (int j = 0; j < size; ++j) {
                info = colls.get(j);
                longNum = info.getLongNumber();
                if (!pLongNum.startsWith(longNum + "!") || pLongNum.equals(longNum)) continue;
                isRoot = false;
                break;
            }
            if (!isRoot) continue;
            rootLst.add(pInfo);
        }
        return rootLst;
    }

    private List<String> getVirOrgLongNumberList(IBgOrgUnit iBgOrgUnit, String orgViewId, String orgUnitID) throws BOSException {
        ArrayList<String> result = null;
        BgOrgUnitCollection virOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection("select longnumber where orgunitid = '" + orgUnitID + "' and isVirtual = 1 and viewId = '" + orgViewId + "'");
        if (virOrgUnitCols.size() != 0) {
            result = new ArrayList<String>();
            for (int i = 0; i < virOrgUnitCols.size(); ++i) {
                result.add(virOrgUnitCols.get(i).getLongNumber());
            }
        }
        return result;
    }

    private void updateSealUpTagAndDate(Context ctx, String bgOrgViewID, BgOrgUnitInfo info, List<String> virOrgList, boolean isSealUp) throws BOSException {
        if (info == null || StringUtils.isEmpty((String)bgOrgViewID)) {
            return;
        }
        Date lastUpdateTime = new Date(System.currentTimeMillis());
        String curUserID = ctx.getCaller().toString();
        int sealUp = isSealUp ? 1 : 0;
        String tmpOrgUnitTable = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            tmpOrgUnitTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FOrgUnitId VARCHAR(44))");
            StringBuffer insertSql = new StringBuffer("Insert Into ").append(tmpOrgUnitTable).append(" (FID, FOrgUnitId) Select FID, FOrgUnitId From T_MBG_BGORGUNIT Where ").append("FISOUSEALUP = ").append(1 ^ sealUp).append(" AND FVIEWID = '").append(bgOrgViewID).append("'").append(this.getUpdateFilterSql(info, virOrgList, isSealUp));
            DbUtil.execute((Context)ctx, (String)insertSql.toString());
            StringBuffer sql = new StringBuffer("");
            sql.append("UPDATE T_MBG_BGORGUNIT SET FISOUSEALUP = ").append(sealUp).append(", FLASTUPDATETIME = {ts'").append(lastUpdateTime.toString()).append("'}").append(" ,FLASTUPDATEUSERID = '").append(curUserID).append("'").append(" WHERE ").append(" FOrgUnitId in( Select FOrgUnitId From " + tmpOrgUnitTable + ") And FVIEWID = '").append(bgOrgViewID).append("'");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (tmpOrgUnitTable != null) {
                try {
                    pool.releaseDBSystemTempTable(tmpOrgUnitTable, conn);
                }
                catch (Exception exception) {}
            }
            SQLUtils.cleanup(null, null, (Connection)conn);
        }
    }

    private StringBuffer getUpdateFilterSql(BgOrgUnitInfo info, List<String> virOrgList, boolean isSealUp) {
        StringBuffer subSql = new StringBuffer(" AND (FLONGNUMBER ");
        subSql.append(" = '").append(info.getLongNumber()).append("'");
        if (isSealUp) {
            subSql.append(" OR ( FLONGNUMBER LIKE '").append(info.getLongNumber()).append("!%'").append(" AND FISVIRTUAL = 0 )");
            if (virOrgList != null && virOrgList.size() != 0) {
                for (int i = 0; i < virOrgList.size(); ++i) {
                    subSql.append(" OR ( FLONGNUMBER LIKE '").append(virOrgList.get(i)).append("!%'").append(" AND FISVIRTUAL = 1 )");
                }
            }
        }
        subSql.append(" OR ( FORGUNITID = '").append(info.getOrgUnitID()).append("' AND FISVIRTUAL = 1 )");
        subSql.append(" )");
        return subSql;
    }

    @Override
    protected void _persistData(Context ctx, BOSUuid bgOrgViewId, List addNewInfoCol, List delInfoIDCol, List updateInfoCol) throws BOSException, EASBizException {
        if (addNewInfoCol == null || delInfoIDCol == null || updateInfoCol == null || addNewInfoCol.isEmpty() && delInfoIDCol.isEmpty() && updateInfoCol.isEmpty()) {
            return;
        }
        BgOrgUnitInfo _bgOrgUnit = null;
        CoreBaseCollection baseCollection = null;
        IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
        if (!delInfoIDCol.isEmpty()) {
            int count = 0;
            ObjectUuidPK[] pkArray = new ObjectUuidPK[delInfoIDCol.size()];
            for (Object pk : delInfoIDCol) {
                pkArray[count++] = new ObjectUuidPK((BOSUuid)pk);
            }
            iBgOrgUnit.deleteBatchData((IObjectPK[])pkArray);
        }
        if (!addNewInfoCol.isEmpty()) {
            baseCollection = new CoreBaseCollection();
            for (Object info : addNewInfoCol) {
                _bgOrgUnit = (BgOrgUnitInfo)info;
                baseCollection.add((CoreBaseInfo)_bgOrgUnit);
            }
            iBgOrgUnit.addnewBatchData(baseCollection);
        }
        if (!updateInfoCol.isEmpty()) {
            baseCollection = new CoreBaseCollection();
            for (Object info : updateInfoCol) {
                baseCollection.add((CoreBaseInfo)((BgOrgUnitInfo)info));
            }
            iBgOrgUnit.updateBatchData(baseCollection);
        }
        this.reSetLongNumber(ctx, iBgOrgUnit, bgOrgViewId);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgOrgUnit Set FShowLevel = (select count(*) from T_MBG_BgOrgUnit t where t.FViewId = T_MBG_BgOrgUnit.FViewId and t.FLongNumber <= T_MBG_BgOrgUnit.FLongNumber) where FViewId = ?", (Object[])new Object[]{bgOrgViewId.toString()});
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgOrgUnit Set FIsLeaf = 0 where FViewId = ? and FID IN (select FParentId from T_MBG_BgOrgUnit)", (Object[])new Object[]{bgOrgViewId.toString()});
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgOrgUnit Set FIsLeaf = 1 where FViewId = ? and FID NOT IN (select FParentId from T_MBG_BgOrgUnit)", (Object[])new Object[]{bgOrgViewId.toString()});
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        MbgVirtualView view = MbgVirtualView.getInstance((Context)ctx);
        view.checkBgOrgClosure(ctx, bgOrgViewId);
    }

    private void reSetLongNumber(Context ctx, IBgOrgUnit iBgOrgUnit, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        if (ctx == null || iBgOrgUnit == null || bgOrgViewId == null) {
            return;
        }
        HashMap<BOSUuid, BgOrgUnitInfo> bgOrgUnitMap = new HashMap<BOSUuid, BgOrgUnitInfo>();
        ArrayList<BgOrgUnitInfo> bgOrgUnits = new ArrayList<BgOrgUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId.toString(), CompareType.EQUALS));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add(NUMBER);
        sic.add("longnumber");
        sic.add("parent.id");
        sic.add("level");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        BgOrgUnitInfo _bgOrgUnit = null;
        BgOrgUnitCollection colls = this.getBgOrgUnitCollection(ctx, view);
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            _bgOrgUnit = colls.get(i);
            bgOrgUnits.add(_bgOrgUnit);
            bgOrgUnitMap.put(_bgOrgUnit.getId(), _bgOrgUnit);
        }
        for (BgOrgUnitInfo bgOrgUnit : bgOrgUnits) {
            this.reSetLongNumber(bgOrgUnit, bgOrgUnitMap);
        }
        CoreBaseCollection _colls = new CoreBaseCollection();
        for (BgOrgUnitInfo bgOrgUnit : bgOrgUnits) {
            bgOrgUnit.remove(NUMBER);
            bgOrgUnit.remove("parent.id");
            _colls.add((CoreBaseInfo)bgOrgUnit);
        }
        iBgOrgUnit.updateBatchData(_colls);
    }

    private void reSetLongNumber(BgOrgUnitInfo bgOrgUnit, Map<BOSUuid, BgOrgUnitInfo> bgOrgUnitMap) {
        if (bgOrgUnit == null || bgOrgUnitMap == null) {
            return;
        }
        if (bgOrgUnit.getBoolean(CHECK)) {
            return;
        }
        if (bgOrgUnit.getParent() == null || bgOrgUnit.getId().equals((Object)bgOrgUnit.getParent().getId())) {
            bgOrgUnit.setLongNumber(bgOrgUnit.getNumber());
            bgOrgUnit.setLevel(1);
            bgOrgUnit.setBoolean(CHECK, true);
        } else if (bgOrgUnitMap.containsKey(bgOrgUnit.getParent().getId())) {
            BgOrgUnitInfo parent = bgOrgUnitMap.get(bgOrgUnit.getParent().getId());
            this.reSetLongNumber(parent, bgOrgUnitMap);
            bgOrgUnit.setLongNumber(parent.getLongNumber() + "!" + bgOrgUnit.getNumber());
            bgOrgUnit.setLevel(parent.getLevel() + 1);
            bgOrgUnit.setBoolean(CHECK, true);
        }
    }

    @Override
    protected Set _getDetailOrgNum(Context ctx, String schemeID, boolean isOnlyDetail) throws BOSException, EASBizException {
        HashSet<String> numberSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)schemeID)) {
            return numberSet;
        }
        String number = null;
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, schemeID);
        if (schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId() == null) {
            return numberSet;
        }
        String orgViewID = schemeHelper.getDimension(DimensionConstants.DEF_ORGUNIT_NUMBER).getViewId();
        StringBuffer sql = new StringBuffer("SELECT FNUMBER FROM T_MBG_BGORGUNIT WHERE FVIEWID =?").append(" AND FISOUSEALUP = ?");
        sql.append(" AND FISLEAF = ?");
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            pmst = conn.prepareStatement(sql.toString());
            pmst.setString(1, orgViewID);
            pmst.setInt(2, 0);
            if (isOnlyDetail) {
                pmst.setInt(3, 1);
            } else {
                pmst.setInt(3, 0);
            }
            rs = pmst.executeQuery();
            while (rs.next()) {
                number = rs.getString(1);
                if (StringUtils.isEmpty((String)number)) continue;
                numberSet.add(number);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return numberSet;
    }

    @Override
    protected boolean _checkIsVirtual(Context ctx, String parentBgOrgUnitId, String currOrgUnitId) throws BOSException, EASBizException {
        HashSet<String> orgUnitIds = new HashSet<String>();
        orgUnitIds.add(currOrgUnitId);
        Map result = this._getOrgVirtualInfo(ctx, parentBgOrgUnitId, orgUnitIds);
        return (Boolean)result.get(currOrgUnitId);
    }

    @Override
    protected boolean _checkIsVirtual(Context ctx, String pBgOrgUnitId, List orgUnitIds) throws BOSException, EASBizException {
        boolean re = false;
        Map result = this._getOrgVirtualInfo(ctx, pBgOrgUnitId, orgUnitIds);
        if (orgUnitIds != null) {
            String orgUnitId = null;
            int in = orgUnitIds.size();
            for (int i = 0; !(i >= in || result.containsKey(orgUnitId = (String)orgUnitIds.get(i)) && (re = ((Boolean)result.get(orgUnitId)).booleanValue())); ++i) {
            }
        }
        return re;
    }

    @Override
    protected Map _getOrgVirtualInfo(Context ctx, String parentBgOrgUnitId, Collection orgUnitIds) throws BOSException, EASBizException {
        HashMap<Object, Boolean> result = new HashMap<Object, Boolean>();
        if (StringUtils.isEmpty((String)parentBgOrgUnitId) || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return result;
        }
        BgOrgUnitInfo bgOrgUnit = this.getBgOrgUnitInfo(ctx, "select id, longNumber, orgUnitID, viewID, isVirtual where id = '" + parentBgOrgUnitId + "'");
        if (bgOrgUnit.isIsVirtual()) {
            Iterator it = orgUnitIds.iterator();
            while (it.hasNext()) {
                result.put(it.next(), Boolean.TRUE);
            }
            return result;
        }
        if (orgUnitIds.contains(bgOrgUnit.getOrgUnitID())) {
            result.put(bgOrgUnit.getOrgUnitID(), bgOrgUnit.isIsVirtual());
            orgUnitIds.remove(bgOrgUnit.getOrgUnitID());
        }
        if (!orgUnitIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("isVirtual");
            evi.getSelector().add("orgUnitID");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgUnit.getViewID(), CompareType.EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", (Object)(bgOrgUnit.getLongNumber() + "!%"), CompareType.LIKE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitID", new HashSet(orgUnitIds), CompareType.INCLUDE));
            BgOrgUnitCollection col = this.getBgOrgUnitCollection(ctx, evi);
            for (int i = 0; i < col.size(); ++i) {
                if (col.get(i).isIsVirtual() && result.containsKey(col.get(i).getOrgUnitID())) continue;
                result.put(col.get(i).getOrgUnitID(), col.get(i).isIsVirtual());
            }
        }
        return result;
    }

    public IObjectPK[] saveBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.dealChangeAglWithSameOrg(ctx, colls);
        return super.saveBatchData(ctx, colls);
    }

    private void dealChangeAglWithSameOrg(Context ctx, CoreBaseCollection colls) throws BOSException {
        if (colls == null || colls.size() == 0) {
            return;
        }
        HashMap<String, Integer> aglMap = new HashMap<String, Integer>();
        HashMap tmpMap = new HashMap();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] obj = null;
        String orgId = null;
        String viewId = null;
        int agl = -1;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        for (int i = 0; i < colls.size(); ++i) {
            bgOrgUnitInfo = (BgOrgUnitInfo)colls.get(i);
            viewId = bgOrgUnitInfo.getViewID();
            aglMap.put(bgOrgUnitInfo.getId().toString(), bgOrgUnitInfo.getPolAlgorithm().getValue());
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnitID");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", aglMap.keySet(), CompareType.INCLUDE));
        BgOrgUnitCollection col = this.getBgOrgUnitCollection(ctx, evi);
        for (int i = 0; i < col.size(); ++i) {
            bgOrgUnitInfo = col.get(i);
            tmpMap.put(bgOrgUnitInfo.getOrgUnitID(), aglMap.get(bgOrgUnitInfo.getId().toString()));
        }
        Iterator it = tmpMap.keySet().iterator();
        while (it.hasNext()) {
            orgId = it.next().toString();
            agl = (Integer)tmpMap.get(orgId);
            obj = new Object[]{agl, orgId, viewId};
            params.add(obj);
        }
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)"UPDATE T_MBG_BGORGUNIT SET FPOLALGORITHM = ? WHERE FORGUNITID = ? and FViewid = ?", params);
        }
        catch (SQLException e) {
            logger.error((Object)"update bgorgunit error ", (Throwable)e);
        }
    }

    protected SelectorItemCollection getBgOrgUnitSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(NUMBER));
        sic.add(new SelectorItemInfo("name"));
        return sic;
    }

    @Override
    protected void _updatePeriodName(Context ctx, IObjectValue model, BgPeriodNameEnum periodName, int orgScope) throws BOSException, EASBizException {
        if (model == null || !(model instanceof BgOrgUnitInfo)) {
            return;
        }
        BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)model;
        IBgOrgUnit iBgOrg = BgOrgUnitFactory.getLocalInstance(ctx);
        if (model != null && model instanceof BgOrgUnitInfo) {
            bgOrgUnitInfo = (BgOrgUnitInfo)model;
            bgOrgUnitInfo = iBgOrg.getBgOrgUnitInfo("select * where id = '" + bgOrgUnitInfo.getId().toString() + "'");
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = user.getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        int periodNameValue = periodName.getValue();
        String orgViewId = bgOrgUnitInfo.getViewID();
        Set<Object> orgSet = new HashSet();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] obj = null;
        Object var15_15 = null;
        orgSet = this.getOrgSetByScope(iBgOrg, bgOrgUnitInfo, orgScope);
        for (String string : orgSet) {
            obj = new Object[]{userId, time, string, orgViewId};
            params.add(obj);
        }
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)("UPDATE T_MBG_BGORGUNIT SET FPERIODNAME = " + periodNameValue + ", FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ? WHERE FORGUNITID = ? And FViewId = ? "), params);
        }
        catch (Exception e) {
            logger.error((Object)"update bgorgunit error ", (Throwable)e);
        }
    }

    @Override
    protected void _importExcel(Context ctx, IObjectCollection sourceColls, IObjectCollection bgOrgUnitColls, List deleteProRefSource, Set showNames, Set showAliases, String bgOrgViewID) throws BOSException, EASBizException {
        if (!sourceColls.isEmpty()) {
            PropertyRefSourceFactory.getLocalInstance((Context)ctx).saveBatchData((CoreBaseCollection)sourceColls);
        }
        if (!bgOrgUnitColls.isEmpty()) {
            BgOrgUnitFactory.getLocalInstance(ctx).updateBatchData((CoreBaseCollection)bgOrgUnitColls);
        }
        if (!deleteProRefSource.isEmpty()) {
            PropertyRefSourceFactory.getLocalInstance((Context)ctx).deleteBatchBySourceIds(deleteProRefSource);
        }
        ArrayList paramList = new ArrayList();
        if (!showNames.isEmpty()) {
            paramList.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{0, bgOrgViewID}, (Object[])showNames.toArray(), (int)50));
        }
        if (!showAliases.isEmpty()) {
            paramList.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{1, bgOrgViewID}, (Object[])showAliases.toArray(), (int)50));
        }
        StringBuffer sql = new StringBuffer("UPDATE T_MBG_BGORGUNIT SET FPERIODNAME = ? WHERE FViewId = ? AND FNumber IN(");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        DbUtil.executeBatch((Context)ctx, (String)sql.toString(), paramList);
    }

    private Set<String> getOrgSetByScope(IBgOrgUnit iBgOrg, BgOrgUnitInfo bgOrgUnitInfo, int orgScope) throws BOSException {
        HashSet<String> orgSet;
        block4: {
            String parLongNumber;
            int level;
            String orgViewId;
            BgOrgUnitCollection bgOrgCols;
            block6: {
                String orgLongnumber;
                block5: {
                    orgSet = new HashSet<String>();
                    bgOrgCols = null;
                    orgViewId = bgOrgUnitInfo.getViewID();
                    orgLongnumber = bgOrgUnitInfo.getLongNumber();
                    String curOrgUnitId = bgOrgUnitInfo.getId().toString();
                    level = bgOrgUnitInfo.getLevel();
                    parLongNumber = null;
                    int index = orgLongnumber.lastIndexOf("!");
                    parLongNumber = index < 0 ? orgLongnumber : orgLongnumber.substring(0, index);
                    orgSet.add(bgOrgUnitInfo.getOrgUnitID());
                    if (orgScope == 0) break block4;
                    if (orgScope != 1) break block5;
                    bgOrgCols = iBgOrg.getBgOrgUnitCollection("select name,orgUnitId where ViewId = '" + orgViewId + "' AND parent.id = '" + curOrgUnitId + "' OR id = '" + curOrgUnitId + "' AND isVirtual = 0");
                    if (bgOrgCols == null || bgOrgCols.size() == 0) break block4;
                    for (int i = 0; i < bgOrgCols.size(); ++i) {
                        orgSet.add(bgOrgCols.get(i).getOrgUnitID());
                    }
                    break block4;
                }
                if (orgScope != 2) break block6;
                bgOrgCols = iBgOrg.getBgOrgUnitCollection("select name,orgUnitId where ViewId = '" + orgViewId + "' AND longnumber like '" + orgLongnumber + "!%' AND isVirtual = 0");
                if (bgOrgCols == null || bgOrgCols.size() == 0) break block4;
                for (int i = 0; i < bgOrgCols.size(); ++i) {
                    orgSet.add(bgOrgCols.get(i).getOrgUnitID());
                }
                break block4;
            }
            if (orgScope == 3 && (bgOrgCols = iBgOrg.getBgOrgUnitCollection("select name,orgUnitId where ViewId = '" + orgViewId + "' AND level = " + level + " AND longnumber like '" + parLongNumber + "!%' AND isVirtual = 0")) != null && bgOrgCols.size() != 0) {
                for (int i = 0; i < bgOrgCols.size(); ++i) {
                    orgSet.add(bgOrgCols.get(i).getOrgUnitID());
                }
            }
        }
        return orgSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getRootPermisionOrg(Context ctx, String bgOrgViewId, String bgOrgId, boolean isUserPerm, boolean isSealUp, String userPK, boolean isShowVirtualOrg, boolean isOnlyShowRootOrg) throws BOSException, EASBizException {
        BgOrgUnitCollection col;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block25: {
            if (StringUtils.isEmpty((String)bgOrgViewId)) {
                throw new BOSException("BgOrgViewId is null!");
            }
            conn = null;
            pstmt = null;
            PreparedStatement pstmt1 = null;
            rst = null;
            String tmpTable = null;
            String sql = null;
            col = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                sql = "Create Table T_MBg_TMPModel(FID Varchar(44) NOT NULL, FOrgUnitId Varchar(44) NOT NULL, FNumber NVarchar(80) NOT NULL, FName NVarchar(255), FDisplayName NVarchar(1024) , FLongNumber NVarchar(1024) NOT NULL, FIsOUSealUp INT Default 0 NOT NULL, FLevel INT Default 0 NOT NULL, FIsLeaf INT Default 0 NOT NULL, FIsVirtual INT Default 0 NOT NULL, FShowLevel INT Default 0 NOT NULL, FHasOrgRange INT Default 0 NOT NULL, FParentID Varchar(44), FHasSub INT Default 0 NOT NULL)";
                tmpTable = pool.createTempTable(sql);
                sql = "Insert Into " + tmpTable + "(FID, FOrgUnitId, FNumber, FName, FDisplayName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FIsVirtual, FShowLevel,FParentID) Select FID, FOrgUnitId, FNumber, FName_" + ctx.getLocale() + ", FDisplayName_" + ctx.getLocale() + ", FLongNumber, FIsOUSealUp, FLevel, FIsLeaf,FIsVirtual,FShowLevel,FParentID FROM T_MBg_BgOrgUnit Where FViewId = '" + bgOrgViewId + "' ";
                if (!isShowVirtualOrg) {
                    sql = sql.concat(" and FisVirtual = 0 ");
                }
                sql = sql + " ORDER BY FShowLevel ASC ";
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (isUserPerm) {
                    sql = "Update " + tmpTable + " t1 Set FHasOrgRange = 1 Where exists (Select FID FROM " + BgDBUtils.getOrgRangeTable((Context)ctx) + " t2 Where t2.FUserID = ? AND t2.FOrgID = t1.FOrgUnitId)";
                    try {
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                        pstmt.executeUpdate();
                    }
                    finally {
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                }
                sql = "Update " + tmpTable + " t1 Set FHasOrgRange = 1 ";
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                int maxLevel = 0;
                sql = "Select Max(FLevel) FROM " + tmpTable;
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    maxLevel = rst.getInt(1);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                sql = "Update " + tmpTable + " t1 Set FHasSub = 1 Where FLevel = ? AND exists (Select FID FROM " + tmpTable + " t2 Where t2.FParentID = t1.FID)";
                pstmt = conn.prepareStatement(sql);
                sql = isSealUp ? "Delete FROM " + tmpTable + " Where FLevel = ? AND FHasSub = 0 AND FHasOrgRange = 0" : "Delete FROM " + tmpTable + " Where FLevel = ? AND FHasSub = 0 AND (FIsOUSealUp = 1 OR FHasOrgRange = 0)";
                pstmt1 = conn.prepareStatement(sql);
                for (int level = maxLevel; level > 0; --level) {
                    pstmt.setInt(1, level);
                    pstmt.executeUpdate();
                    pstmt1.setInt(1, level);
                    pstmt1.executeUpdate();
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt1);
                sql = "Select FID, FOrgUnitId, FNumber, FName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FHasOrgRange, FParentID ,FShowLevel, FIsVirtual FROM " + tmpTable + " Where FLevel = 1  ORDER BY FShowLevel ASC ";
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                col = new BgOrgUnitCollection();
                while (rst.next()) {
                    BgOrgUnitInfo info = new BgOrgUnitInfo();
                    info.setId(BOSUuid.read((String)rst.getString("FID")));
                    info.setOrgUnitID(rst.getString("FOrgUnitId"));
                    info.setNumber(rst.getString("FNumber"));
                    info.setName(rst.getString("FName"));
                    info.setLevel(rst.getInt("Flevel"));
                    info.setIsLeaf(rst.getInt("FisLeaf") == 1);
                    info.setLongNumber(rst.getString("FlongNumber"));
                    info.setIsVirtual(rst.getBoolean("FIsVirtual"));
                    String parentId = rst.getString("FParentId");
                    if (StringUtils.isEmpty((String)parentId)) {
                        info.setParent(null);
                    } else {
                        BgOrgUnitInfo parentInfo = new BgOrgUnitInfo();
                        parentInfo.setId(BOSUuid.read((String)parentId));
                        info.setParent(parentInfo);
                    }
                    col.add(info);
                }
                if (tmpTable == null) break block25;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                    catch (Exception e2) {
                        logger.error((Object)"", (Throwable)e2);
                        throw new BOSException((Throwable)e2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return col;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TreeModel _getFullBgOrgModel(Context ctx, String bgOrgViewID, String bgOrgUnitID, boolean isOUSealUp, boolean isShowParentSelf, boolean isNeedAddOrgRange, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws BOSException, EASBizException {
        TempTablePool pool;
        HashMap<BOSUuid, DefaultKingdeeTreeNode> nodeMap;
        String childIdColTmpTable;
        String tmpTable;
        DefaultKingdeeTreeNode root;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block35: {
            if (StringUtils.isEmpty((String)bgOrgViewID)) {
                return null;
            }
            conn = null;
            pstmt = null;
            PreparedStatement pstmt1 = null;
            rst = null;
            root = null;
            DefaultKingdeeTreeNode node = null;
            DefaultKingdeeTreeNode parent = null;
            String sql = null;
            BgOrgUnitInfo bgOrgUnitInfo = null;
            boolean hasOrgRange = false;
            tmpTable = null;
            childIdColTmpTable = null;
            String parentId = null;
            Set<String> parentIds = null;
            HashSet<String> curIds = null;
            Set<String> childIds = null;
            nodeMap = new HashMap<BOSUuid, DefaultKingdeeTreeNode>();
            pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                sql = "Create Table T_MBg_TMPModel(FID Varchar(44) NOT NULL, FOrgUnitId Varchar(44) NOT NULL, FNumber NVarchar(80) NOT NULL, FName NVarchar(255), FLongNumber NVarchar(1024) NOT NULL, FIsOUSealUp INT Default 0 NOT NULL, FLevel INT Default 0 NOT NULL, FIsLeaf INT Default 0 NOT NULL, FIsVirtual INT Default 0 NOT NULL, FShowLevel INT Default 0 NOT NULL, FHasOrgRange INT Default 0 NOT NULL, FParentID Varchar(44), FHasSub INT Default 0 NOT NULL)";
                tmpTable = pool.createTempTable(sql);
                if (StringUtils.isEmpty((String)bgOrgUnitID)) {
                    childIds = this.getAllChildIdsByBgOrgViewId(conn, bgOrgViewID);
                } else {
                    curIds = new HashSet<String>();
                    curIds.add(bgOrgUnitID);
                    parentIds = this.getInnerNodesByBgOrgId(ctx, conn, curIds);
                    childIds = this.getAllChildIdsByParIds(ctx, conn, parentIds);
                    childIds.add(bgOrgUnitID);
                }
                BgOrgUnitInfo rootOrgUnit = new BgOrgUnitInfo();
                rootOrgUnit.setId(BOSUuid.create((BOSObjectType)rootOrgUnit.getBOSType()));
                rootOrgUnit.setIsLeaf(true);
                root = new DefaultKingdeeTreeNode((Object)rootOrgUnit);
                if (childIds.isEmpty()) break block35;
                childIdColTmpTable = pool.createTempTable("Create Table T_MBg_TMPModel(FID Varchar(44) NOT NULL)");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + childIdColTmpTable + " (FID) values (?)"), childIds);
                sql = "Insert Into " + tmpTable + "(FID, FOrgUnitId, FNumber, FName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FIsVirtual, FShowLevel,FParentID) Select FID, FOrgUnitId, FNumber, FName_" + ctx.getLocale() + ", FLongNumber, FIsOUSealUp, FLevel, FIsLeaf,FIsVirtual,FShowLevel,FParentID FROM T_MBg_BgOrgUnit Where FId in ( select fid from " + childIdColTmpTable + ")";
                if (!isShowVirtualOrg) {
                    sql = sql.concat(" and FisVirtual = 0");
                }
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                if (isNeedAddOrgRange) {
                    sql = "Update " + tmpTable + " t1 Set FHasOrgRange = 1 Where exists (Select FID FROM " + BgDBUtils.getOrgRangeTable((Context)ctx) + " t2 Where t2.FUserID = ? AND t2.FOrgID = t1.FOrgUnitId)";
                    try {
                        pstmt = conn.prepareStatement(sql);
                        pstmt.setString(1, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString());
                        pstmt.executeUpdate();
                    }
                    finally {
                        SQLUtils.cleanup((Statement)pstmt);
                    }
                }
                sql = "Update " + tmpTable + " t1 Set FHasOrgRange = 1";
                try {
                    pstmt = conn.prepareStatement(sql);
                    pstmt.executeUpdate();
                }
                finally {
                    SQLUtils.cleanup((Statement)pstmt);
                }
                int maxLevel = 0;
                sql = "Select Max(FLevel) FROM " + tmpTable;
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    maxLevel = rst.getInt(1);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                sql = "Update " + tmpTable + " t1 Set FHasSub = 1 Where FLevel = ? AND exists (Select FID FROM " + tmpTable + " t2 Where t2.FParentID = t1.FID)";
                pstmt = conn.prepareStatement(sql);
                sql = isOUSealUp ? "Delete FROM " + tmpTable + " Where FLevel = ? AND FHasSub = 0 AND FHasOrgRange = 0" : "Delete FROM " + tmpTable + " Where FLevel = ? AND FHasSub = 0 AND (FIsOUSealUp = 1 OR FHasOrgRange = 0)";
                pstmt1 = conn.prepareStatement(sql);
                for (int level = maxLevel; level > 0; --level) {
                    pstmt.setInt(1, level);
                    pstmt.executeUpdate();
                    pstmt1.setInt(1, level);
                    pstmt1.executeUpdate();
                }
                SQLUtils.cleanup((Statement)pstmt);
                SQLUtils.cleanup((Statement)pstmt1);
                sql = "Select FID, FOrgUnitId, FNumber, FName, FLongNumber, FIsOUSealUp, FLevel, FIsLeaf, FIsVirtual, FHasOrgRange, FParentID FROM " + tmpTable + " Order By FShowLevel";
                try {
                    pstmt = conn.prepareStatement(sql);
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgOrgUnitInfo = new BgOrgUnitInfo();
                        bgOrgUnitInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                        bgOrgUnitInfo.setOrgUnitID(rst.getString("FOrgUnitId"));
                        bgOrgUnitInfo.setNumber(rst.getString("FNumber"));
                        bgOrgUnitInfo.setName(rst.getString("FName"));
                        bgOrgUnitInfo.setLongNumber(rst.getString("FLongNumber"));
                        bgOrgUnitInfo.setIsOUSealUp(rst.getBoolean("FIsOUSealUp"));
                        bgOrgUnitInfo.setLevel(rst.getInt("FLevel"));
                        bgOrgUnitInfo.setIsLeaf(rst.getBoolean("FIsLeaf"));
                        bgOrgUnitInfo.setIsVirtual(rst.getBoolean("FIsVirtual"));
                        hasOrgRange = rst.getBoolean("FHasOrgRange");
                        parentId = rst.getString("FParentID");
                        if (!StringUtils.isEmpty((String)parentId)) {
                            bgOrgUnitInfo.setParent(new BgOrgUnitInfo());
                            bgOrgUnitInfo.getParent().setId(BOSUuid.read((String)parentId));
                        }
                        if (isOnlyNoLeaf && bgOrgUnitInfo.isIsLeaf()) continue;
                        node = new DefaultKingdeeTreeNode((Object)bgOrgUnitInfo);
                        if (bgOrgUnitInfo.isIsVirtual()) {
                            node.setText(bgOrgUnitInfo.getName() + "(s)");
                        }
                        if (!isOUSealUp && bgOrgUnitInfo.isIsOUSealUp() || !hasOrgRange) {
                            OrgF7InnerUtils.disableTreeNode((DefaultKingdeeTreeNode)node);
                        }
                        nodeMap.put(bgOrgUnitInfo.getId(), node);
                        if (bgOrgUnitInfo.getParent() == null) {
                            root.add((MutableTreeNode)node);
                            continue;
                        }
                        parent = (DefaultKingdeeTreeNode)nodeMap.get(bgOrgUnitInfo.getParent().getId());
                        if (parent != null) {
                            parent.add((MutableTreeNode)node);
                            continue;
                        }
                        root.add((MutableTreeNode)node);
                    }
                }
                finally {
                    SQLUtils.cleanup((ResultSet)rst);
                }
            }
            catch (Exception ex) {
                try {
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    if (childIdColTmpTable != null) {
                        pool.releaseTable(childIdColTmpTable);
                    }
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        if (tmpTable != null) {
            pool.releaseTable(tmpTable);
        }
        if (childIdColTmpTable != null) {
            pool.releaseTable(childIdColTmpTable);
        }
        if (!(!isOnlyNoLeaf && isShowVirtualOrg || nodeMap.isEmpty())) {
            for (DefaultKingdeeTreeNode node : nodeMap.values()) {
                if (node.getChildCount() != 0) continue;
                ((BgOrgUnitInfo)node.getUserObject()).setIsLeaf(true);
            }
        }
        this.setShowLevel(root, 1);
        return root != null ? new KingdeeTreeModel((TreeNode)root) : null;
    }

    private int setShowLevel(DefaultKingdeeTreeNode root, int showLevel) {
        if (root == null) {
            return showLevel;
        }
        DefaultKingdeeTreeNode node = null;
        BgOrgUnitInfo bgOrgUnit = null;
        if (root.getUserObject() instanceof BgOrgUnitInfo && (bgOrgUnit = (BgOrgUnitInfo)root.getUserObject()).getOrgUnitID() != null) {
            bgOrgUnit.setShowLevel(showLevel);
        }
        int childCounts = root.getChildCount();
        for (int i = 0; i < childCounts; ++i) {
            node = (DefaultKingdeeTreeNode)root.getChildAt(i);
            if (node == null || !(node.getUserObject() instanceof BgOrgUnitInfo) || (bgOrgUnit = (BgOrgUnitInfo)node.getUserObject()).getOrgUnitID() == null) continue;
            bgOrgUnit.setShowLevel(showLevel++);
            showLevel = this.setShowLevel(node, showLevel);
        }
        return showLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAllChildIdsByBgOrgViewId(Connection conn, String bgOrgViewID) {
        HashSet<String> result = new HashSet<String>();
        if (conn == null || StringUtils.isEmpty((String)bgOrgViewID)) {
            return result;
        }
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            String sql = "Select FId FROM T_MBg_BgOrgUnit Where FViewId = '" + bgOrgViewID + "'";
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                result.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        }
        catch (Exception e) {
            logger.error((Object)"get bgorg error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAllChildIdsByParIds(Context ctx, Connection conn, Set<String> parentIds) {
        HashSet<String> result;
        block7: {
            result = new HashSet<String>();
            if (conn == null || parentIds.isEmpty()) {
                return result;
            }
            StringBuffer sql = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            TempTablePool pool = null;
            String tempTable = null;
            try {
                pool = TempTablePool.getInstance((Context)ctx);
                tempTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (Fid VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempTable + " (Fid) values (?)"), parentIds);
                sql = new StringBuffer();
                sql.append("Select FId FROM T_MBg_BgOrgUnit Where FParentId IN ( select FID from " + tempTable + " )");
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    result.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            catch (Exception e) {
                logger.error((Object)"get bgorg error", (Throwable)e);
                break block7;
            }
            finally {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        }
        return result;
    }

    private Set<String> getInnerNodesByBgOrgId(Context ctx, Connection conn, Set<String> rootSets) {
        HashSet<String> result = new HashSet<String>();
        if (conn == null || rootSets.isEmpty()) {
            return result;
        }
        Set<String> curInnerNodes = new HashSet<String>();
        curInnerNodes.addAll(rootSets);
        result.addAll(rootSets);
        do {
            curInnerNodes = this.getDirectSubNoLeafOrg(ctx, conn, curInnerNodes);
            result.addAll(curInnerNodes);
        } while (!curInnerNodes.isEmpty());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getDirectSubNoLeafOrg(Context ctx, Connection conn, Set<String> rootSets) {
        HashSet<String> curOrgIds;
        block7: {
            curOrgIds = new HashSet<String>();
            if (conn == null || rootSets.isEmpty()) {
                return curOrgIds;
            }
            StringBuffer sql = null;
            PreparedStatement pstmt = null;
            ResultSet rst = null;
            TempTablePool pool = null;
            String tempTable = null;
            try {
                pool = TempTablePool.getInstance((Context)ctx);
                tempTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (Fid VARCHAR(44))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempTable + " (Fid) values (?)"), rootSets);
                sql = new StringBuffer();
                sql.append("Select FId FROM T_MBg_BgOrgUnit Where FIsLeaf = 0 and FParentId IN ( select FID from " + tempTable + ")");
                pstmt = conn.prepareStatement(sql.toString());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    curOrgIds.add(rst.getString(1));
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            catch (Exception e) {
                logger.error((Object)"get bgorg error", (Throwable)e);
                break block7;
            }
            finally {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        }
        return curOrgIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set _getParentAndChildrenOrgUnitIds(Context ctx, String bgOrgUnitId, String bgOrgViewId) throws BOSException, EASBizException {
        logger.info((Object)("begin execute method getParentAndChildrenOrgUnitIds bgOrgUnitId :" + bgOrgUnitId + " , bgOrgViewId : " + bgOrgViewId));
        HashSet<String> orgUnitIds = new HashSet<String>();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("longnumber");
        if (BOSUuid.read((String)bgOrgUnitId).getType().equals((Object)new BgOrgUnitInfo().getBOSType())) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)bgOrgUnitId, CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)bgOrgUnitId, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        evi.setFilter(filter);
        evi.setSelector(sic);
        BgOrgUnitCollection costCenterColls = null;
        BgOrgUnitInfo orgUnitInfo = null;
        String longNumber = null;
        try {
            costCenterColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (costCenterColls == null || costCenterColls.isEmpty()) {
            orgUnitIds.add("findNoOne");
            return orgUnitIds;
        }
        orgUnitInfo = costCenterColls.get(0);
        longNumber = orgUnitInfo.getLongNumber();
        orgUnitIds.add(bgOrgUnitId);
        evi = new EntityViewInfo();
        filter = new FilterInfo();
        String[] parentNumbers = longNumber != null ? longNumber.split("!") : null;
        filter.getFilterItems().add(new FilterItemInfo(NUMBER, new HashSet<String>(Arrays.asList(parentNumbers)), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("longnumber", (Object)(longNumber + "!%"), CompareType.LIKE));
        filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
        filter.setMaskString("(#0 or (#1 and #2)) and #3");
        evi.setFilter(filter);
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("orgUnitId");
        try {
            costCenterColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
        }
        catch (BOSException e) {
            logger.error((Object)"getParentAndChildrenOrgUnitIds error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (costCenterColls == null) {
            return new HashSet();
        }
        for (int i = 0; i < costCenterColls.size(); ++i) {
            orgUnitIds.add(costCenterColls.get(i).getOrgUnitID());
        }
        HashSet<String> orgUnitIdsNumber = new HashSet<String>();
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            this.getHighestShareOrg(conn, orgUnitInfo.getLongNumber(), bgOrgViewId, orgUnitIdsNumber);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        orgUnitIds.addAll(this.getParentAndChildrenOfNOrgUnitIds(ctx, orgUnitIdsNumber, bgOrgViewId));
        return orgUnitIds;
    }

    private Set<String> getHighestShareOrg(Connection conn, String longNumber, String bgOrgViewId, Set<String> orgUnitIdsNumber) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select Fid,Fname_l2 As FName,Fnumber,Flongnumber,ForgUnitId,FisVirtual,Flevel from T_MBG_BgOrgUnit where FViewID = '" + bgOrgViewId + "' and Flongnumber LIKE '" + longNumber + "!%' and Flevel = ( select min(Flevel)  FROM T_MBG_BgOrgUnit WHERE FViewID = '" + bgOrgViewId + "' and Flongnumber LIKE '" + longNumber + "!%' and FisVirtual = 1 )");
        IRowSet rst = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        ArrayList<BgOrgUnitInfo> result = new ArrayList<BgOrgUnitInfo>();
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                bgOrgUnitInfo = new BgOrgUnitInfo();
                bgOrgUnitInfo.setId(BOSUuid.read((String)rst.getString("Fid")));
                bgOrgUnitInfo.setName(rst.getString("FName"));
                bgOrgUnitInfo.setNumber(rst.getString("Fnumber"));
                bgOrgUnitInfo.setLongNumber(rst.getString("Flongnumber"));
                bgOrgUnitInfo.setOrgUnitID(rst.getString("ForgUnitId"));
                bgOrgUnitInfo.setIsVirtual(rst.getBoolean("FisVirtual"));
                bgOrgUnitInfo.setLevel(rst.getInt("Flevel"));
                result.add(bgOrgUnitInfo);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        if (result == null || result.size() == 0) {
            return orgUnitIdsNumber;
        }
        BgOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < result.size(); ++i) {
            orgUnitInfo = (BgOrgUnitInfo)result.get(i);
            if (orgUnitInfo.isIsVirtual()) {
                orgUnitIdsNumber.add(orgUnitInfo.getNumber());
                continue;
            }
            this.getHighestShareOrg(conn, orgUnitInfo.getLongNumber(), bgOrgViewId, orgUnitIdsNumber);
        }
        return orgUnitIdsNumber;
    }

    private Set<String> getParentAndChildrenOfNOrgUnitIds(Context ctx, Set<String> number, String bgOrgViewId) throws EASBizException, BOSException {
        String tmpTableChild;
        TempTablePool pool;
        Connection conn;
        ResultSet rst;
        PreparedStatement pstmt;
        HashSet<String> orgUnitIds;
        block13: {
            logger.info((Object)"begin to execute method getParentAndChildrenOfNOrgUnitIds......");
            orgUnitIds = new HashSet<String>();
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add(NUMBER);
            sic.add("longnumber");
            sic.add("orgUnitId");
            sic.add("isVirtual");
            filter.getFilterItems().add(new FilterItemInfo(NUMBER, number, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewId, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            evi.setFilter(filter);
            evi.setSelector(sic);
            BgOrgUnitCollection costCenterColls = null;
            BgOrgUnitInfo orgUnitInfo = null;
            String longNumber = null;
            try {
                costCenterColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            }
            catch (BOSException e) {
                logger.error((Object)"getParentAndChildrenOrgUnitIds error", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            if (costCenterColls == null || costCenterColls.isEmpty()) {
                logger.info((Object)"getParentAndChildrenOfNOrgUnitIds costCenterColls is null!!");
                return orgUnitIds;
            }
            evi = new EntityViewInfo();
            filter = new FilterInfo();
            String[] parentNumbers = null;
            HashSet<String> parentNumbersSet = new HashSet<String>();
            HashSet<String> longNumbersSet = new HashSet<String>();
            for (int i = 0; i < costCenterColls.size(); ++i) {
                orgUnitInfo = costCenterColls.get(i);
                longNumber = orgUnitInfo.getLongNumber();
                String[] stringArray = parentNumbers = longNumber != null ? longNumber.split("!") : null;
                if (parentNumbers != null) {
                    parentNumbersSet.addAll(Arrays.asList(parentNumbers));
                }
                if (longNumber == null) continue;
                longNumbersSet.add(longNumber);
            }
            pstmt = null;
            rst = null;
            conn = null;
            pool = null;
            String tmpTableParent = null;
            tmpTableChild = null;
            try {
                conn = this.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTableParent = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FNUMBER NVARCHAR(80))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableParent + " (FNUMBER) values (?)"), parentNumbersSet);
                tmpTableChild = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FLONGNUMBER NVARCHAR(1024))");
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTableChild + " (FLONGNUMBER) values (?)"), longNumbersSet);
                String sql = "Select u.FOrgUnitId FROM T_MBg_BgOrgUnit u Where u.FViewId = '" + bgOrgViewId + "' and (exists(select FNUMBER from " + tmpTableParent + " where  u.fnumber=FNUMBER ) or (u.FIsVirtual = 0 and exists(select FLONGNUMBER from " + tmpTableChild + " where  u.FLONGNUMBER like concat(FLONGNUMBER,'!%') )))";
                pstmt = conn.prepareStatement(sql);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    if (rst.getString("FOrgUnitId") == null) continue;
                    orgUnitIds.add(rst.getString("FOrgUnitId"));
                }
                if (tmpTableParent == null) break block13;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"getParentAndChildrenOfNOrgUnitIds error", (Throwable)ex);
                    throw new BOSException((Throwable)ex);
                }
                catch (Throwable throwable) {
                    if (tmpTableParent != null) {
                        pool.releaseTable(tmpTableParent);
                    }
                    if (tmpTableChild != null) {
                        pool.releaseTable(tmpTableChild);
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTableParent);
        }
        if (tmpTableChild != null) {
            pool.releaseTable(tmpTableChild);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitIds;
    }

    @Override
    protected Map _getMbgDimOrgIds(Context ctx, String bgSchemeId, String orgUnitId, String bgOrgViewId, String unitGroupId) throws BOSException, EASBizException {
        HashMap<String, Set> mbgDimOrgIds = new HashMap<String, Set>();
        if (bgSchemeId == null || orgUnitId == null || bgOrgViewId == null) {
            return mbgDimOrgIds;
        }
        Object viewId = null;
        HashSet<String> viewIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select v.FID from T_MBG_MbgView v join T_MBG_BgDimSettingsMember m on v.FID = m.FMemberId join T_MBG_BgDimSettings s on s.FID = m.FBgDimSettingsId where s.FBgSchemeId = ? and m.FType = ? and v.FSegregationrule = ?");
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId, 1, 0});
            while (rst.next()) {
                viewIds.add(rst.getString("FID"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        ArrayList<Set> tmpList = new ArrayList<Set>();
        Set tmpIds = null;
        Set selIds = null;
        for (String _viewId : viewIds) {
            Set orgIds = this._getMbgDimOrgIds(ctx, _viewId, bgSchemeId, orgUnitId, bgOrgViewId, unitGroupId);
            if (orgIds == null || orgIds.isEmpty()) continue;
            selIds = null;
            int in = tmpList.size();
            for (int i = 0; i < in; ++i) {
                tmpIds = (Set)tmpList.get(i);
                if (tmpIds.size() != orgIds.size() || !tmpIds.containsAll(orgIds)) continue;
                selIds = tmpIds;
                break;
            }
            if (selIds != null) {
                mbgDimOrgIds.put(_viewId, selIds);
                continue;
            }
            mbgDimOrgIds.put(_viewId, orgIds);
            tmpList.add(orgIds);
        }
        return mbgDimOrgIds;
    }

    @Override
    protected Set _getMbgDimOrgIds(Context ctx, String viewId, String bgSchemeId, String[] orgUnitIds, String bgOrgViewId, String unitGroupId) throws BOSException, EASBizException {
        if (unitGroupId != null && OrgStructureFactory.getLocalInstance((Context)ctx).exists("where unit.id = '" + unitGroupId + "'")) {
            return this.getParentAndChildrenOrgUnitByUnitGroup(ctx, unitGroupId);
        }
        if (bgOrgViewId == null && bgSchemeId != null) {
            BgDimSettingsMemberInfo settMember = BgDimSettingsMemberFactory.getLocalInstance(ctx).getBgDimSettingsMemberInfo("select memberID where bgDimsettings.bgScheme.id = '" + bgSchemeId.toString() + "'  and bgDimsettings.dimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'");
            bgOrgViewId = settMember.getMemberID().toString();
        }
        HashSet result = new HashSet();
        Set _set = null;
        for (int i = 0; i < orgUnitIds.length; ++i) {
            _set = this._getMbgDimOrgIds(ctx, viewId, bgSchemeId, orgUnitIds[i], bgOrgViewId, unitGroupId);
            if (_set == null) continue;
            result.addAll(_set);
        }
        return result;
    }

    @Override
    protected Set _getMbgDimOrgIds(Context ctx, String viewId, String bgSchemeId, String orgUnitId, String bgOrgViewId, String unitGroupId) throws BOSException, EASBizException {
        logger.info((Object)("begin to execute method getMbgDimOrgIds viewId : " + viewId + " ,bgSchemeId :" + bgSchemeId));
        if (bgOrgViewId == null && bgSchemeId != null) {
            BgDimSettingsMemberInfo settMember = BgDimSettingsMemberFactory.getLocalInstance(ctx).getBgDimSettingsMemberInfo("select memberID where bgDimsettings.bgScheme.id = '" + bgSchemeId.toString() + "'  and bgDimsettings.dimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'");
            bgOrgViewId = settMember.getMemberID().toString();
        }
        if (unitGroupId != null && OrgStructureFactory.getLocalInstance((Context)ctx).exists("where unit.id = '" + unitGroupId + "'")) {
            return this.getParentAndChildrenOrgUnitByUnitGroup(ctx, unitGroupId);
        }
        HashSet<String> orgUnitIds = this._getParentAndChildrenOrgUnitIds(ctx, orgUnitId, bgOrgViewId);
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<String>();
        }
        if (bgSchemeId == null) {
            return orgUnitIds;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add(NUMBER);
        evi.getSelector().add("longNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("select forgunitid from t_mbg_bgscheme where fid = '" + bgSchemeId + "'"), CompareType.INNER));
        CostCenterOrgUnitInfo schemeOrg = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi).get(0);
        if (orgUnitIds.contains(schemeOrg.getId().toString())) {
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)("select forgunitid from t_mbg_mbgview where fid = '" + viewId + "')"), CompareType.INNER));
            CostCenterOrgUnitInfo viewOrg = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi).get(0);
            if (schemeOrg.getLongNumber().startsWith(viewOrg.getLongNumber() + "!")) {
                orgUnitIds.add(viewOrg.getId().toString());
                HashSet<String> numbers = new HashSet<String>(Arrays.asList(schemeOrg.getLongNumber().substring(viewOrg.getLongNumber().length() + 1).split("!")));
                numbers.remove(viewOrg.getNumber());
                if (!numbers.isEmpty()) {
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo(NUMBER, numbers, CompareType.INCLUDE));
                    CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
                    if (col != null && !col.isEmpty()) {
                        for (int i = 0; i < col.size(); ++i) {
                            orgUnitIds.add(col.get(0).getId().toString());
                        }
                    }
                }
            }
        }
        return orgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set getParentAndChildrenOrgUnitByUnitGroup(Context ctx, String unitGroupId) throws BOSException, EASBizException {
        HashSet<String> costCenterIds = new HashSet<String>();
        OrgStructureInfo structInfo = null;
        OrgStructureCollection structColls = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select tree.id, longNumber where unit.id = '" + unitGroupId + "'");
        if (structColls != null && !structColls.isEmpty()) {
            structInfo = structColls.get(0);
        }
        if (structInfo != null) {
            OrgStructureCollection col = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select unit.id, unit.longNumber, unit.isCostOrgUnit where tree.id = '" + structInfo.getTree().getId() + "' and longNumber like '" + structInfo.getLongNumber() + "!%'");
            for (int i = 0; i < col.size(); ++i) {
                if (!col.get(i).getUnit().isIsCostOrgUnit()) continue;
                costCenterIds.add(col.get(i).getUnit().getId().toString());
            }
        }
        if (costCenterIds.isEmpty()) {
            return costCenterIds;
        }
        Connection conn = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("Select FLongNumber FROM T_Org_CostCenter Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FLongNumber");
            List longNumbers = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])costCenterIds.toArray(), (int)50));
            HashSet<String> parentNumbers = new HashSet<String>();
            HashSet<String> childLikLongNumbers = new HashSet<String>();
            HashSet<String> hasProcessNumber = new HashSet<String>();
            String longNumber = null;
            String[] ls = null;
            boolean isHasParent = false;
            for (i = 0; i < longNumbers.size(); ++i) {
                longNumber = (String)longNumbers.get(i);
                isHasParent = false;
                ls = longNumber.split("!");
                for (int l = 0; l < ls.length - 1; ++l) {
                    if (!isHasParent && hasProcessNumber.contains(ls[l])) {
                        isHasParent = true;
                    }
                    parentNumbers.add(ls[l]);
                }
                if (isHasParent) continue;
                hasProcessNumber.add(ls[ls.length - 1]);
                childLikLongNumbers.add(longNumber + "!%");
            }
            if (!parentNumbers.isEmpty()) {
                sql.setLength(0);
                sql.append("Select FID FROM T_Org_CostCenter Where FNumber IN(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                List temp = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])parentNumbers.toArray(), (int)50));
                if (temp != null) {
                    costCenterIds.addAll(temp);
                }
            }
            if (!childLikLongNumbers.isEmpty()) {
                sql.setLength(0);
                sql.append("Select FID FROM T_Org_CostCenter Where ");
                for (i = 0; i < 50; ++i) {
                    if (i > 0) {
                        sql.append(" OR ");
                    }
                    sql.append(" FLongNumber Like ?");
                }
                List temp = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])childLikLongNumbers.toArray(), (int)50));
                if (temp != null) {
                    costCenterIds.addAll(temp);
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return costCenterIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IObjectCollection _getChildrenUnit(Context ctx, BOSUuid bgOrgUnitId) throws BOSException, EASBizException {
        BgOrgUnitCollection colls = new BgOrgUnitCollection();
        if (ctx == null || bgOrgUnitId == null) {
            return colls;
        }
        Connection conn = null;
        BgOrgUnitInfo bgOrgUnit = null;
        try {
            conn = this.getConnection(ctx);
            bgOrgUnit = MbgDataHelper.getBgOrgUnitInfoById(conn, ctx.getLocale(), bgOrgUnitId);
            if (bgOrgUnit != null) {
                colls.add(bgOrgUnit);
                List<BgOrgUnitInfo> bgOrgUnits = MbgDataHelper.getBgOrgUnitChildren(ctx, conn, ctx.getLocale(), bgOrgUnit, ContextUtil.getCurrentUserInfo((Context)ctx).getId(), true);
                int in = bgOrgUnits.size();
                for (int i = 0; i < in; ++i) {
                    colls.add(bgOrgUnits.get(i));
                }
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return colls;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateByCostCenter(Context ctx) throws BOSException, EASBizException {
        if (ctx == null) {
            return;
        }
        logger.error((Object)"\u5f00\u59cb  \u6839\u636e\u6210\u672c\u4e2d\u5fc3\u66f4\u65b0\u9884\u7b97\u7ec4\u7ec7\u6811\u7f16\u7801\u53ca\u957f\u7f16\u7801\u3001\u540d\u79f0\u3001\u7b80\u79f0\u3001\u63cf\u8ff0 ");
        logger.error((Object)"BgOrgUnitControllerBean _updateByCostCenter begin");
        long st1 = System.currentTimeMillis();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = user.getId().toString();
        String time = new Date(System.currentTimeMillis()).toString();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.FID, t.FViewId, t.FNumber, t.FLongNumber, cc.FNumber AS CCNumber, cc.FName_" + ctx.getLocale() + " AS CCName from T_MBG_BgOrgUnit t join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID  where t.FNumber <> cc.FNumber  order by t.FViewId, t.FLongNumber");
        String update = "update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(),FNumber = ?, FLongNumber = ? where FID = ?";
        String id = null;
        String viewId = null;
        String number = null;
        String longNumber = null;
        String ccNumber = null;
        String ccName = null;
        HashSet<BOSUuid> bgViewIdSet = new HashSet<BOSUuid>();
        HashSet<String> orgNumberSet = new HashSet<String>();
        HashMap<String, String> orgNumMap = new HashMap<String, String>();
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                id = rst.getString("FID");
                viewId = rst.getString("FViewId");
                number = rst.getString("FNumber");
                longNumber = rst.getString("FLongNumber");
                ccNumber = rst.getString("CCNumber");
                ccName = rst.getString("CCName");
                bgViewIdSet.add(BOSUuid.read((String)viewId));
                BgDBUtils.executeUpdate((Connection)conn, (String)update, (Object[])new Object[]{ccNumber, this.convertLongNumber(longNumber, number, ccNumber), id});
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BIZscope set FBGMEMBERNUM = ? where FBGMEMBERTYPE = 207 and FBizDataType = 1 and FBGMEMBERNUM = ?", (Object[])new Object[]{ccNumber, number});
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgScope set FBGMEMBERNUM = ? where FBGMEMBERTYPE = 207 and FBizDataType = 1 and FBGMEMBERNUM = ?", (Object[])new Object[]{ccNumber, number});
                this.processFunction(conn, number, ccNumber);
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgSchemeIntegrationMap set FSourceMemberNumber = ?, FSourceMemberName = ? where FSourceMemberNumber = ? and FEntryId in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = ? and FMemberType = ?)", (Object[])new Object[]{ccNumber, ccName, number, DimensionBaseConstants.DEF_ORGUNIT_NUMBER, 1});
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgSchemeIntegrationMap set FTargetMemberNumber = ?, FTargetMemberName = ? where FTargetMemberNumber = ? and FEntryId in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = ? and FMemberType = ?)", (Object[])new Object[]{ccNumber, ccName, number, DimensionBaseConstants.DEF_ORGUNIT_NUMBER, 1});
                BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgSchemeIntegratMember set FNumber = ?, FName = ? where FNumber = ? and FEntryId in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = ? and FMemberType = ?)", (Object[])new Object[]{ccNumber, ccName, number, DimensionBaseConstants.DEF_ORGUNIT_NUMBER, 1});
                orgNumberSet.add(ccNumber);
                orgNumMap.put(ccNumber, number);
            }
            SQLUtils.cleanup((ResultSet)rst);
            List<String[]> orgUnits = this.checkLongNumber(conn);
            while (!orgUnits.isEmpty()) {
                for (String[] orgUnit : orgUnits) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(),FLongNumber = ? where FID = ?"), (Object[])new Object[]{orgUnit[2] + "!" + orgUnit[3], orgUnit[0]});
                }
                orgUnits = this.checkLongNumber(conn);
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(), FName_" + ctx.getLocale() + " = (select FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId and " + this.getNotEqualsColFilter("FName_" + ctx.getLocale(), "T_ORG_CostCenter", "T_MBG_BgOrgUnit") + ")"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(), FDescription_" + ctx.getLocale() + " = (select FDescription_" + ctx.getLocale() + " from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId and " + this.getNotEqualsColFilter("FDescription_" + ctx.getLocale(), "T_ORG_CostCenter", "T_MBG_BgOrgUnit") + ")"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(), FSimpleName = (select FSimpleName from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId and " + this.getNotEqualsColFilter("FSimpleName", "T_ORG_CostCenter", "T_MBG_BgOrgUnit") + ")"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgOrgUnit set FLASTUPDATEUSERID = '" + userId + "', FLASTUPDATETIME = now(), FCode = (select FCode from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgOrgUnit.FOrgUnitId and " + this.getNotEqualsColFilter("FCode", "T_ORG_CostCenter", "T_MBG_BgOrgUnit") + ")"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BIZscope set FBGMEMBERALIAS = (select distinct FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FNumber = T_MBG_BIZscope.FBGMEMBERNUM)  where exists (select FNumber from T_ORG_CostCenter where FNumber = T_MBG_BIZscope.FBGMEMBERNUM) and FBGMEMBERTYPE = 207 and FBizDataType = 1"));
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgScope set FBGMEMBERALIAS = (select distinct FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FNumber = T_MBG_BgScope.FBGMEMBERNUM)  where exists (select FNumber from T_ORG_CostCenter where FNumber = T_MBG_BgScope.FBGMEMBERNUM) and FBGMEMBERTYPE = 207 and FBizDataType = 1"));
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgVariate set FMemberNumber = (select FNumber from T_MBG_BgOrgUnit where FID = T_MBG_BgVariate.FMemberId) where FDimNumber = 'BG_Organization' and exists (select FID from T_MBG_BgOrgUnit where FID = T_MBG_BgVariate.FMemberId)");
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgVariate set FMemberName_" + ctx.getLocale() + " = (select FName_" + ctx.getLocale() + " from T_MBG_BgOrgUnit where FID = T_MBG_BgVariate.FMemberId) where FDimNumber = 'BG_Organization' and exists (select FID from T_MBG_BgOrgUnit where FID = T_MBG_BgVariate.FMemberId)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgSchemeIntegrationRpt set FOrgUnitNumber = (select FNumber from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FOrgUnitID) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FOrgUnitID)");
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgSchemeIntegrationRpt set FOrgUnitName = (select FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FOrgUnitID) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FOrgUnitID)"));
            BgDBUtils.executeUpdate((Connection)conn, (String)"update T_MBG_BgSchemeIntegrationRpt set FSourceOrgUnitNumber = (select FNumber from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FSourceOrgUnitID) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FSourceOrgUnitID)");
            BgDBUtils.executeUpdate((Connection)conn, (String)("update T_MBG_BgSchemeIntegrationRpt set FSourceOrgUnitName = (select FName_" + ctx.getLocale() + " from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FSourceOrgUnitID) where exists (select FID from T_ORG_CostCenter where FID = T_MBG_BgSchemeIntegrationRpt.FSourceOrgUnitID)"));
            if (!orgNumberSet.isEmpty()) {
                StringBuffer _sql = new StringBuffer();
                _sql.append("select fid,fnumber,fname_l2 from T_ORG_CostCenter where fnumber in (");
                Object[] numbers = new Object[orgNumberSet.size()];
                int i = 0;
                Iterator it = orgNumberSet.iterator();
                while (it.hasNext()) {
                    if (i == orgNumberSet.size() - 1) {
                        _sql.append("?)");
                    } else {
                        _sql.append("?,");
                    }
                    numbers[i] = it.next();
                    ++i;
                }
                IRowSet rs = BgDBUtils.executeQuery((Connection)conn, (String)_sql.toString(), (Object[])numbers);
                String orgID = null;
                BgFormEntryInfo entryInfo = null;
                byte[] b1 = null;
                IBgFormEntry bgFormEntry = BgFormEntryFactory.getLocalInstance(ctx);
                IBgForm bgForm = BgFormFactory.getLocalInstance(ctx);
                BgFormCollection coll = null;
                while (rs.next()) {
                    orgID = rs.getString("fid");
                    coll = bgForm.getBgFormCollection("select id, entries.id, entries.dimensionData where bgTemplate.formType in(2,4) and orgUnit.id = '" + orgID + "'");
                    for (int m = 0; m < coll.size(); ++m) {
                        entryInfo = coll.get(m).getEntries().get(0);
                        b1 = entryInfo.getDimensionData();
                        ReplaceOrgUnitInfo info = this.replaceOrgNumber(b1, orgNumMap);
                        if (!info.isReplace()) continue;
                        entryInfo.setDimensionData(info.getBytes());
                        bgFormEntry.save(entryInfo);
                    }
                }
            }
            if (!bgViewIdSet.isEmpty()) {
                MbgVirtualView view = MbgVirtualView.getInstance((Context)ctx);
                for (BOSUuid _viewId : bgViewIdSet) {
                    view.checkBgOrgClosure(ctx, _viewId);
                }
            }
            BgOrgViewCollection viewColl = BgOrgViewFactory.getLocalInstance(ctx).getBgOrgViewCollection();
            for (int k = 0; k < viewColl.size(); ++k) {
                BgOrgViewInfo viewInfo = viewColl.get(k);
                EntityViewInfo bgOrgEntityViewInfo = BgOrgUnitHelper.getBgOrgEntityViewInfo(viewInfo.getId().toString());
                BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(bgOrgEntityViewInfo);
                HashMap<String, BgOrgUnitInfo> orgUnitInfoMap = new HashMap<String, BgOrgUnitInfo>();
                for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                    BgOrgUnitInfo info = bgOrgUnitCollection.get(i);
                    if (info.getParent() != null) {
                        if (orgUnitInfoMap.containsKey(info.getParent().getId().toString())) {
                            BgOrgUnitInfo pinfo = (BgOrgUnitInfo)orgUnitInfoMap.get(info.getParent().getId().toString());
                            info.setDisplayName(pinfo.getDisplayName() + "_" + info.getName());
                            info.getParent().setDisplayName(pinfo.getDisplayName());
                            info.setLongNumber(pinfo.getLongNumber() + "!" + info.getNumber());
                            info.getParent().setLongNumber(pinfo.getLongNumber());
                            orgUnitInfoMap.put(info.getId().toString(), info);
                            continue;
                        }
                        orgUnitInfoMap.put(info.getParent().toString(), info.getParent());
                        continue;
                    }
                    orgUnitInfoMap.put(info.getId().toString(), info);
                    info.setDisplayName(info.getName());
                    info.setLongNumber(info.getNumber());
                }
                CoreBaseCollection baseColl = new CoreBaseCollection();
                baseColl.addObjectCollection((IObjectCollection)bgOrgUnitCollection);
                BgOrgUnitFactory.getLocalInstance(ctx).saveBatchData(baseColl);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        logger.error((Object)("BgOrgUnitControllerBean _updateByCostCenter end  ms:" + (System.currentTimeMillis() - st1)));
    }

    private ReplaceOrgUnitInfo replaceOrgNumber(byte[] bytes, Map<String, String> orgNumMap) throws BOSException {
        ReplaceOrgUnitInfo info = null;
        byte[] newBytes = null;
        try {
            info = new ReplaceOrgUnitInfo();
            SAXReader reader = new SAXReader();
            Document document = reader.read((InputStream)new ByteArrayInputStream(bytes));
            Element root = document.getRootElement();
            this.parseElement(orgNumMap, root, info);
            if (info.isReplace()) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding(ENCODING);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)bos, format);
                writer.write(document);
                writer.close();
                newBytes = bos.toByteArray();
                info.setBytes(newBytes);
            }
        }
        catch (DocumentException e) {
            throw new BOSException((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BOSException((Throwable)e);
        }
        catch (IOException e) {
            throw new BOSException((Throwable)e);
        }
        return info;
    }

    private void parseElement(Map<String, String> orgNumMap, Element element, ReplaceOrgUnitInfo info) {
        Iterator it = element.nodeIterator();
        Node node = null;
        while (it.hasNext()) {
            Element data = null;
            Element childNode = null;
            node = (Node)it.next();
            if (!(node instanceof Element)) continue;
            data = (Element)node;
            childNode = data.element(NUMBER);
            if (childNode != null && BG_Org.equals(childNode.getText())) {
                Element _childNode;
                String text;
                String oldOrgNum = null;
                String newOrgNum = null;
                String[] oldOrgStr = null;
                childNode = data.element(VALUE);
                if (childNode == null || StringUtils.isEmpty((String)(text = childNode.getText()))) continue;
                String newText = null;
                for (Map.Entry<String, String> entry : orgNumMap.entrySet()) {
                    oldOrgNum = entry.getValue();
                    newOrgNum = entry.getKey();
                    if (StringUtils.isEmpty((String)text) || (oldOrgStr = text.split(COMMA)).length <= 0 || !oldOrgStr[0].equals(oldOrgNum)) continue;
                    newText = text.replaceAll(oldOrgNum, newOrgNum);
                    childNode.setText(newText);
                    info.setReplace(true);
                }
                childNode = data.element(MEMBER);
                if (childNode == null || childNode.element(NUMBER) == null || StringUtils.isEmpty((String)(text = (_childNode = childNode.element(NUMBER)).getText()))) continue;
                newText = null;
                for (Map.Entry<String, String> entry : orgNumMap.entrySet()) {
                    oldOrgNum = entry.getValue();
                    newOrgNum = entry.getKey();
                    if (StringUtils.isEmpty((String)text) || (oldOrgStr = text.split(COMMA)).length <= 0 || !oldOrgStr[0].equals(oldOrgNum)) continue;
                    newText = text.replaceAll(oldOrgNum, newOrgNum);
                    _childNode.setText(newText);
                    info.setReplace(true);
                }
                continue;
            }
            this.parseElement(orgNumMap, data, info);
        }
    }

    protected void processFunction(Connection conn, String number, String ccNumber) throws BOSException {
        if (StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)ccNumber)) {
            return;
        }
        IRowSet rst = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        String id = null;
        String bgMemberNum = null;
        String bgMemberNumNew = null;
        String bgMemberAliasNew = null;
        String formula = null;
        BgOrgUnitInfo oldOrg = new BgOrgUnitInfo();
        BgOrgUnitInfo newOrg = new BgOrgUnitInfo();
        BgOrgUnitInfo[] arr = new BgOrgUnitInfo[2];
        oldOrg.setNumber(number);
        newOrg.setNumber(ccNumber);
        arr[0] = oldOrg;
        arr[1] = newOrg;
        ArrayList<BgOrgUnitInfo[]> migOrgUnits = new ArrayList<BgOrgUnitInfo[]>();
        migOrgUnits.add(arr);
        StringBuffer sql = new StringBuffer();
        StringBuffer updateSql = new StringBuffer();
        try {
            byte[] _bytes;
            String replaceStr;
            sql.setLength(0);
            updateSql.setLength(0);
            params.clear();
            sql.append("SELECT scope.FId, scope.FBgMemberNum FROM t_mbg_bizscope scope ").append("join T_MBG_BizCalcSubset sub on sub.FId = scope.FBizCalcSubsetID ").append("join T_MBG_BizCalc calc on calc.FId = sub.FBizCalcID ").append("where calc.FState = 2 and scope.FBGMEMBERTYPE = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + " and scope.FBIZDATATYPE  = " + 4 + " and scope.FBgMemberNum like '%" + number + "%'");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                id = rst.getString("FId");
                bgMemberNum = rst.getString("FBgMemberNum");
                bgMemberAliasNew = bgMemberNumNew = BgOrgMigrationUtils.dealBizCalcFunctionStr(bgMemberNum, migOrgUnits);
                param = new Object[]{bgMemberNumNew, bgMemberAliasNew, id};
                params.add(param);
            }
            if (!params.isEmpty()) {
                updateSql.append("update T_MBG_BizScope set FBgMemberNum = ?, FBgMemberAlias = ? where FId = ?");
                BgDBUtils.executeBatch((Connection)conn, (String)updateSql.toString(), params);
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.setLength(0);
            updateSql.setLength(0);
            params.clear();
            sql.append("SELECT sub.FId, sub.FFormula FROM T_MBG_BizCalcSubset sub ").append("join T_MBG_BizCalc calc on calc.FId = sub.FBizCalcID ").append("where calc.FState = 2");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                String tmpStr;
                id = rst.getString("FId");
                formula = (String)BgAnalyseHelper.getObject(BgDBUtils.getBytes((ResultSet)rst, (String)"FFormula"));
                if (StringUtils.isEmpty((String)formula) || formula.indexOf(number) <= 0 || formula.indexOf(tmpStr = "MbgRefBgTem(\"" + number + "\",") <= 0) continue;
                replaceStr = "MbgRefBgTem(\"" + ccNumber + "\",";
                _bytes = BgAnalyseHelper.getBytes(formula.replace(tmpStr, replaceStr));
                param = new Object[]{_bytes, id};
                params.add(param);
            }
            if (!params.isEmpty()) {
                updateSql.append("update T_MBG_BizCalcSubset set FFormula = ? where FId = ?");
                BgDBUtils.executeBatch((Connection)conn, (String)updateSql.toString(), params);
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.setLength(0);
            updateSql.setLength(0);
            params.clear();
            sql.append("SELECT scope.FId, scope.FBgMemberNum FROM t_mbg_bgscope scope ").append("join T_MBG_BgExamineSubset sub on sub.FId = scope.FBgExamineSubSetID ").append("join T_MBG_BgExamine examine on examine.FId = sub.FBgExamineID ").append("where examine.FState = 1 and scope.FBGMEMBERTYPE = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + " and scope.FBIZDATATYPE  = " + 4 + " and scope.FBgMemberNum like '%" + number + "%'");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                id = rst.getString("FId");
                bgMemberNum = rst.getString("FBgMemberNum");
                bgMemberAliasNew = bgMemberNumNew = BgOrgMigrationUtils.dealBizCalcFunctionStr(bgMemberNum, migOrgUnits);
                param = new Object[]{bgMemberNumNew, bgMemberAliasNew, id};
                params.add(param);
            }
            if (!params.isEmpty()) {
                updateSql.append("update t_mbg_bgscope set FBgMemberNum = ?, FBgMemberAlias = ? where FId = ?");
                BgDBUtils.executeBatch((Connection)conn, (String)updateSql.toString(), params);
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.setLength(0);
            updateSql.setLength(0);
            params.clear();
            sql.append("SELECT sub.FId, sub.FFormula FROM T_MBG_BgExamineSubset sub ").append("join T_MBG_BgExamine examine on examine.FId = sub.FBgExamineID ").append("where examine.FState = 1");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                id = rst.getString("FId");
                formula = (String)BgAnalyseHelper.getObject(BgDBUtils.getBytes((ResultSet)rst, (String)"FFormula"));
                if (StringUtils.isEmpty((String)formula) || formula.indexOf(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER) <= 0 || formula.indexOf(number) <= 0) continue;
                String str = "\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + number + "\"";
                replaceStr = "\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + ccNumber + "\"";
                _bytes = BgAnalyseHelper.getBytes(formula.replace(str, replaceStr));
                param = new Object[]{_bytes, id};
                params.add(param);
            }
            if (!params.isEmpty()) {
                updateSql.append("update T_MBG_BgExamineSubset set FFormula = ? where FID = ?");
                BgDBUtils.executeBatch((Connection)conn, (String)updateSql.toString(), params);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> checkLongNumber(Connection conn) throws SQLException {
        ArrayList<String[]> orgUnits = new ArrayList<String[]>();
        if (conn == null) {
            return orgUnits;
        }
        IRowSet rst = null;
        String[] result = null;
        String sql = "select t.FID, t.FLongNumber, p.FLONGNUMBER, t.FNumber from T_MBG_BgOrgUnit t left join T_MBG_BgOrgUnit p on t.FPARENTID = p.FID where t.flongnumber <> CONCAT(CONCAT(p.FLONGNUMBER, '!'), t.fnumber) and t.FPARENTID is not null";
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql);
            while (rst.next()) {
                result = new String[]{rst.getString(1), rst.getString(2), rst.getString(3), rst.getString(4)};
                orgUnits.add(result);
            }
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        return orgUnits;
    }

    private String convertLongNumber(String longNumber, String number, String converNumber) {
        if (StringUtils.isEmpty((String)longNumber) || StringUtils.isEmpty((String)number) || StringUtils.isEmpty((String)converNumber)) {
            return longNumber;
        }
        StringBuffer _longNumber = new StringBuffer();
        String[] tmpStrs = longNumber.split("!");
        int in = tmpStrs.length;
        for (int i = 0; i < in; ++i) {
            if (tmpStrs[i].equals(number)) {
                _longNumber.append(converNumber + "!");
                continue;
            }
            _longNumber.append(tmpStrs[i] + "!");
        }
        _longNumber.setLength(_longNumber.length() - 1);
        return _longNumber.toString();
    }

    @Override
    protected void _updateFact(Context ctx, BOSUuid bgViewId) throws BOSException, EASBizException {
        if (ctx == null || bgViewId == null) {
            return;
        }
        MbgVirtualView view = MbgVirtualView.getInstance((Context)ctx);
        view.checkBgOrgClosure(ctx, bgViewId);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _batchUpdate(Context ctx, BOSUuid bgOrgViewId, List orgUnits) throws BOSException, EASBizException {
        Connection conn;
        block16: {
            int i;
            if (ctx == null) return;
            if (bgOrgViewId == null) return;
            if (orgUnits == null) {
                return;
            }
            conn = null;
            UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
            BgOrgUnitInfo model = null;
            Object[] objs = null;
            ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            String tmpTable = null;
            StringBuffer sql = new StringBuffer();
            String viwId = bgOrgViewId.toString();
            String userId = user.getId().toString();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            List<BgOrgUnitInfo> allOrgUnits = BgOrgUnitUtils.getAllOrgUnits(orgUnits);
            Map orgUnitsMap = this.getOrgUnitsMap(ctx, bgOrgViewId.toString());
            ArrayList<String> updateOrgunitIds = new ArrayList<String>();
            BgOrgUnitCollection exists = this.getBgOrgUnitCollection(ctx, "select id, orgUnitId, intID where viewID = '" + bgOrgViewId + "' and isVirtual = 0");
            Map existsMap = BgCommHelper.transeToMap((IObjectCollection)exists, (String[])new String[]{"orgUnitId"});
            BgOrgUnitCollection addNewCol = new BgOrgUnitCollection();
            int in = allOrgUnits.size();
            for (i = 0; i < in; ++i) {
                model = allOrgUnits.get(i);
                if (!existsMap.containsKey(model.getOrgUnitID())) {
                    if (model.isIsVirtual()) continue;
                    addNewCol.add(model);
                    continue;
                }
                model.setIntID(((BgOrgUnitInfo)existsMap.get(model.getOrgUnitID())).getIntID());
            }
            if (!addNewCol.isEmpty()) {
                Map addNewMap = BgCommHelper.transeToMap((IObjectCollection)addNewCol, (String[])new String[]{"orgUnitId"});
                BgIntIdHelper.setIntIdOnlyAddNew((Context)ctx, (IObjectCollection)addNewCol, (String)bgOrgViewId.toString(), (boolean)false);
                int in2 = allOrgUnits.size();
                for (int i2 = 0; i2 < in2; ++i2) {
                    model = allOrgUnits.get(i2);
                    if (!addNewMap.containsKey(model.getOrgUnitID()) || !model.isIsVirtual()) continue;
                    model.setIntID(((BgOrgUnitInfo)addNewMap.get(model.getOrgUnitID())).getIntID());
                }
            }
            in = allOrgUnits.size();
            for (i = 0; i < in; ++i) {
                BgOrgUnitInfo bgOrgUnitInfo;
                model = allOrgUnits.get(i);
                if (orgUnitsMap.get(model.getId().toString()) != null && !(bgOrgUnitInfo = (BgOrgUnitInfo)orgUnitsMap.get(model.getId().toString())).getLongNumber().equals(model.getLongNumber())) {
                    updateOrgunitIds.add(bgOrgUnitInfo.getId().toString());
                }
                objs = new Object[]{model.getString(model.getPKField()), model.getName(), model.getNumber(), model.getLongNumber(), model.isIsLeaf(), model.getLevel(), model.isIsVirtual(), model.isIsOUSealUp(), model.getOrgUnitID(), model.getParent() != null ? model.getParent().getString(model.getPKField()) : null, i, model.getSimpleName(), model.getCode(), model.getDescription(), model.getDisplayName(), model.getIntID()};
                sqlParams.add(objs);
            }
            try {
                conn = this.getConnection(ctx);
                if (allOrgUnits.isEmpty()) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)"delete from T_MBG_BgOrgUnit where FVIEWID = ?", (Object[])new Object[]{viwId});
                } else {
                    tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FName NVARCHAR(80), FNumber NVARCHAR(80), FLongNumber NVARCHAR(1024), FIsLeaf INT, FLevel INT, FISVIRTUAL INT, FIsOUSealUp INT, FOrgUnitID VARCHAR(44), FParentID VARCHAR(44), FShowLevel INT,FSimpleName NVARCHAR(80),FCode VARCHAR(80),FDescription VARCHAR(1024),FDisplayName VARCHAR(1024), FIntID INT)");
                    pool.createIndex(tmpTable, "FID", false, false);
                    BgDBUtils.insertValue1((Connection)conn, (String)("Insert Into " + tmpTable + " (FID, FName, FNumber, FLongNumber, FIsLeaf, FLevel, FISVIRTUAL, FIsOUSealUp, FOrgUnitID, FParentID, FShowLevel,FSimpleName,FCode,FDescription,FDisplayName, FIntID) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)"), sqlParams);
                    sql.setLength(0);
                    sql.append("delete from T_MBG_BgOrgUnit where FVIEWID = ? and not exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FLongNumber = (select FLongNumber from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FIsLeaf = (select FIsLeaf from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FLevel = (select FLevel from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FParentID = (select FParentID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FShowLevel = (select FShowLevel from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FSimpleName = (select FSimpleName from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FCode = (select FCode from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FDescription_" + ctx.getLocale() + " = (select FDescription from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("update T_MBG_BgOrgUnit set FDisplayName_" + ctx.getLocale() + " = (select FDisplayName from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID) where FVIEWID = ? and exists (select FID from " + tmpTable + " where FID = T_MBG_BgOrgUnit.FID)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("Insert Into T_MBG_BgOrgUnit (FID, FVIEWID, FName_" + ctx.getLocale() + ", FNumber, FLongNumber, FIsLeaf, FLevel, FSimpleName, FCode, FDescription_" + ctx.getLocale() + ", FDisplayName_" + ctx.getLocale() + ",FISVIRTUAL, FIsOUSealUp, FOrgUnitID, FPARENTID, FShowLevel, FCREATORID, FCREATETIME, FLASTUPDATEUSERID, FLASTUPDATETIME, FIntID)  Select FID, ?, FName, FNumber, FLongNumber, FIsLeaf, FLevel,FSimpleName,FCode,FDescription,FDisplayName, FISVIRTUAL, FIsOUSealUp, FOrgUnitID, FPARENTID, FShowLevel, ?, ?, ?, ?, FIntId from " + tmpTable + " where not exists (select FID from T_MBG_BgOrgUnit where FID = " + tmpTable + ".FID and FVIEWID = ?)");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId, userId, time, userId, time, viwId});
                    String updateSql = "Update T_MBG_BgOrgUnit Set  FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ? Where FViewId = ? AND FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where FID = ?)";
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                    for (int i3 = 0; i3 < updateOrgunitIds.size(); ++i3) {
                        String orgUnitId = (String)updateOrgunitIds.get(i3);
                        paramList.add(new Object[]{userId, time, viwId, orgUnitId});
                    }
                    DbUtil.executeBatch((Context)ctx, (String)updateSql, paramList);
                    sql.setLength(0);
                    sql.append("UPDATE T_MBG_BgOrgUnit SET FISTRANSFERQINGANALYSE = (SELECT FISTRANSFERQINGANALYSE FROM T_MBG_BgOrgUnit t1 where t1.FViewId = T_MBG_BgOrgUnit.FViewId and t1.FORGUNITID = T_MBG_BgOrgUnit.FORGUNITID and t1.FISVIRTUAL  = 0 ) where FViewId = ? and FISVIRTUAL = 1");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                    sql.setLength(0);
                    sql.append("UPDATE T_MBG_BgOrgUnit SET FPERIODNAME = (SELECT FPERIODNAME FROM T_MBG_BgOrgUnit t1 where t1.FViewId = T_MBG_BgOrgUnit.FViewId and t1.FORGUNITID = T_MBG_BgOrgUnit.FORGUNITID and t1.FISVIRTUAL  = 0 ) where FViewId = ? and FISVIRTUAL = 1");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId});
                }
                MbgVirtualView.getInstance((Context)ctx).checkBgOrgClosure(ctx, bgOrgViewId);
                if (tmpTable == null) break block16;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"batch update bgOrgUnit error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (Exception ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected Set _getParentOrgIds(Context ctx, String bgSchemeId, String orgUnitId, boolean includeVirtual) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return null;
        }
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            String orgViewId = BgSchemeFactory.getLocalInstance(ctx).getOrgViewId(bgSchemeId);
            BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select longNumber where orgUnitId = '" + orgUnitId + "' and viewId = '" + orgViewId + "' order by isVirtual");
            if (col == null || col.isEmpty()) {
                return null;
            }
            HashSet<String> parents = new HashSet<String>();
            if (includeVirtual) {
                int in = col.size();
                for (int i = 0; i < in; ++i) {
                    this.addParentNumber(parents, col.get(i).getLongNumber());
                }
            } else {
                this.addParentNumber(parents, col.get(0).getLongNumber());
            }
            if (parents.isEmpty()) {
                return null;
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("orgUnitId");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", parents, CompareType.INCLUDE));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)orgViewId));
            col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            parents.clear();
            for (int i = 0; i < col.size(); ++i) {
                parents.add(col.get(i).getOrgUnitID());
            }
            return parents;
        }
        OrgStructureCollection col = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection("select longNumber, tree.id where unit.id = '" + orgUnitId + "' and (unit.isGrouping = 1 or tree.id = '" + "00000000-0000-0000-0000-0000000000054F2827FD" + "')");
        if (col == null || col.isEmpty()) {
            return null;
        }
        HashSet<String> parents = new HashSet<String>();
        this.addParentNumber(parents, col.get(0).getLongNumber());
        if (parents.isEmpty()) {
            return null;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("unit.id");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", parents, CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("tree.id", (Object)col.get(0).getTree().getId().toString()));
        col = OrgStructureFactory.getLocalInstance((Context)ctx).getOrgStructureCollection(evi);
        parents.clear();
        for (int i = 0; i < col.size(); ++i) {
            parents.add(col.get(i).getUnit().getId().toString());
        }
        return parents;
    }

    private void addParentNumber(Set<String> parents, String longNumber) {
        if (StringUtils.isEmpty((String)longNumber)) {
            return;
        }
        int lstIdx = longNumber.lastIndexOf("!");
        if (lstIdx < 0) {
            return;
        }
        longNumber = longNumber.substring(0, lstIdx);
        parents.add(longNumber);
        this.addParentNumber(parents, longNumber);
    }

    @Override
    protected void _batchUpdatePolAlgorithm(Context ctx, IObjectCollection infos) throws BOSException, EASBizException {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = user.getId().toString();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        String sql = "Update T_MBG_BgOrgUnit Set FpolAlgorithm = ?, FLASTUPDATEUSERID = ?, FLASTUPDATETIME = ? Where FViewId IN (Select FViewId FROM T_MBG_BgOrgUnit Where FID = ?) AND FOrgUnitId IN(Select FOrgUnitId FROM T_MBG_BgOrgUnit Where FID = ?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BgOrgUnitInfo info = null;
        for (int i = 0; i < infos.size(); ++i) {
            info = (BgOrgUnitInfo)infos.getObject(i);
            paramList.add(new Object[]{info.getPolAlgorithm().getValue(), userId, time, info.getId().toString(), info.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    @Override
    protected void _batchUpdateTransferQings(Context ctx, IObjectCollection infos) throws BOSException, EASBizException {
        if (infos == null || infos.isEmpty()) {
            return;
        }
        String sql = "Update T_MBG_BgOrgUnit Set FIsTransferQingAnalyse = ? Where FID = ?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        BgOrgUnitInfo info = null;
        for (int i = 0; i < infos.size(); ++i) {
            info = (BgOrgUnitInfo)infos.getObject(i);
            paramList.add(new Object[]{info.isIsTransferQingAnalyse(), info.getId().toString()});
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    @Override
    public void batchUpdateLastUdpateMsg(Context ctx, String viewId, List orgUnitIds) throws BOSException, EASBizException {
        super.batchUpdateLastUdpateMsg(ctx, viewId, orgUnitIds);
    }

    @Override
    protected void _batchUpdateLastUdpateMsg(Context ctx, String viewId, List orgUnitIds) throws BOSException, EASBizException {
        BgOrgUnitHelper.updateTimeAndUser(ctx, viewId, orgUnitIds);
    }

    private Map getOrgUnitsMap(Context ctx, String viewId) throws BOSException {
        EntityViewInfo bgOrgEntityViewInfo = BgOrgUnitHelper.getBgOrgEntityViewInfo(viewId);
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(bgOrgEntityViewInfo);
        HashMap<String, BgOrgUnitInfo> orgUnitInfoMap = new HashMap<String, BgOrgUnitInfo>();
        for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
            orgUnitInfoMap.put(bgOrgUnitCollection.get(i).getId().toString(), bgOrgUnitCollection.get(i));
        }
        return orgUnitInfoMap;
    }

    private String getNotEqualsColFilter(String colName, String table1, String table2) {
        return "((" + table1 + "." + colName + " is not null and " + table2 + "." + colName + " is null) or (" + table1 + "." + colName + " is  null and " + table2 + "." + colName + " is not null) or (" + table1 + "." + colName + " <> " + table2 + "." + colName + "))";
    }

    private class ReplaceOrgUnitInfo {
        private boolean isReplace = false;
        private byte[] bytes = null;

        private ReplaceOrgUnitInfo() {
        }

        public void setReplace(boolean isReplace) {
            this.isReplace = isReplace;
        }

        public void setBytes(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean isReplace() {
            return this.isReplace;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

