/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgOrgUnitFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.data.BgOrgMigrationUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgUnitFacadeControllerBean
extends AbstractBgOrgUnitFacadeControllerBean {
    private static final long serialVersionUID = -6834662959727618127L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgOrgUnitFacadeControllerBean");
    private static final int ALL_TYPE = 0;
    private static final int FIRST_TYPE = 1;
    private static final int LAST_TYPE = 2;
    private static final int CHILD_TYPE = 3;

    @Override
    protected List _getFirstOrgUnits(Context ctx, BOSUuid orgUnitId, OrgType orgType) throws BOSException, EASBizException {
        List<Object> orgUnits = new ArrayList();
        if (ctx == null || orgUnitId == null || orgType == null) {
            return orgUnits;
        }
        if (5 == orgType.getValue()) {
            orgUnits = this.queryCostOrgUnits(ctx, orgUnitId, 1);
        }
        return orgUnits;
    }

    @Override
    protected List _getLastOrgUnits(Context ctx, BOSUuid orgUnitId, OrgType orgType) throws BOSException, EASBizException {
        List<Object> orgUnits = new ArrayList();
        if (ctx == null || orgUnitId == null || orgType == null) {
            return orgUnits;
        }
        if (5 == orgType.getValue()) {
            orgUnits = this.queryCostOrgUnits(ctx, orgUnitId, 2);
        }
        return orgUnits;
    }

    @Override
    protected List _getChildOrgUnits(Context ctx, BOSUuid orgUnitId, OrgType orgType) throws BOSException, EASBizException {
        List<Object> orgUnits = new ArrayList();
        if (ctx == null || orgUnitId == null || orgType == null) {
            return orgUnits;
        }
        if (5 == orgType.getValue()) {
            orgUnits = this.queryCostOrgUnits(ctx, orgUnitId, 3);
        }
        return orgUnits;
    }

    @Override
    protected List _getOrgUnits(Context ctx, BOSUuid orgUnitId, OrgType orgType) throws BOSException, EASBizException {
        List<Object> orgUnits = new ArrayList();
        if (ctx == null || orgUnitId == null || orgType == null) {
            return orgUnits;
        }
        if (5 == orgType.getValue()) {
            orgUnits = this.queryCostOrgUnits(ctx, orgUnitId, 0);
        }
        return orgUnits;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List<Object[]> queryCostOrgUnits(Context ctx, BOSUuid orgUnitId, int type) throws BOSException, EASBizException {
        ArrayList<Object[]> orgUnits = new ArrayList<Object[]>();
        if (ctx == null) return orgUnits;
        if (orgUnitId == null) {
            return orgUnits;
        }
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        Object[] obj = null;
        OrgUnitInfo ccOrgUnit = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            ccOrgUnit = MbgDataHelper.getOrgUnitInfo(conn, ctx.getLocale(), orgUnitId);
            sql.append("select FID, FName_" + ctx.getLocale() + " AS FName, FNumber, FLongNumber, FLevel, FIsLeaf, FisSealup, FParentId,FSimpleName,FCode,FDescription_" + ctx.getLocale() + " AS FDescription from T_ORG_CostCenter ");
            if (0 != type) {
                if (1 == type) {
                    sql.append(" where (FID = ? or FLongNumber like ?) and FLevel < ? ");
                    sqlParams = new Object[]{orgUnitId.toString(), ccOrgUnit.getLongNumber() + "!%", ccOrgUnit.getLevel() + 3};
                } else if (2 == type) {
                    sql.append(" where (FID = ? or FLongNumber like ?) and FLevel >= ? ");
                    sqlParams = new Object[]{orgUnitId.toString(), ccOrgUnit.getLongNumber() + "!%", ccOrgUnit.getLevel() + 3};
                } else if (3 == type) {
                    sql.append(" where FLongNumber like ? and FLevel < ? ");
                    sqlParams = new Object[]{ccOrgUnit.getLongNumber() + "!%", ccOrgUnit.getLevel() + 3};
                }
            }
            sql.append(" order by FLongNumber");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), sqlParams);
            while (rst.next()) {
                obj = new Object[]{rst.getString("FID"), rst.getString("FName"), rst.getString("FNumber"), rst.getString("FLongNumber"), rst.getInt("FLevel"), rst.getBoolean("FIsLeaf"), rst.getBoolean("FisSealup"), rst.getString("FParentId"), rst.getString("FSimpleName"), rst.getString("FCode"), rst.getString("FDescription")};
                orgUnits.add(obj);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryCostOrgUnits sql error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new Object[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgUnits;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _getBgOrgUnits(Context ctx, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        ArrayList<Object[]> orgUnits = new ArrayList<Object[]>();
        if (ctx == null) return orgUnits;
        if (bgOrgViewId == null) {
            return orgUnits;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FID, FName_" + ctx.getLocale() + " AS FName, FNumber, FLongNumber, FLevel, FIsLeaf, FIsOUSealUp, FIsVirtual, FParentId, FOrgUnitId,FSimpleName,FCode, FDescription_" + ctx.getLocale() + " AS FDescription from T_MBG_BgOrgUnit where FViewID = ? order by FIsVirtual, FLongNumber");
        Object[] obj = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgOrgViewId.toString()});
            while (rst.next()) {
                obj = new Object[13];
                obj[0] = rst.getString("FID");
                obj[1] = rst.getString("FName");
                obj[2] = rst.getString("FNumber");
                obj[3] = rst.getString("FLongNumber");
                obj[4] = rst.getInt("FLevel");
                obj[5] = rst.getBoolean("FIsLeaf");
                obj[6] = rst.getBoolean("FIsOUSealUp");
                if (rst.getString("FParentId") != null) {
                    obj[7] = rst.getString("FParentId");
                }
                obj[8] = rst.getString("FSimpleName");
                obj[9] = rst.getString("FCode");
                obj[10] = rst.getString("FDescription");
                obj[11] = rst.getInt("FIsVirtual");
                obj[12] = rst.getString("FOrgUnitId");
                orgUnits.add(obj);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryCostOrgUnits sql error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new Object[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgUnits;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Set _getComapnyIds(Context ctx) throws BOSException, EASBizException {
        HashSet<String> companyIds = new HashSet<String>();
        if (ctx == null) {
            return companyIds;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FID from T_ORG_Company");
            while (rst.next()) {
                companyIds.add(rst.getString(1));
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"queryCompanyIds sql error:", (Throwable)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new Object[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return companyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _executeMigration(Context ctx, List migOrgUnits, String orgViewId, List updateOrgUnits) throws BOSException, EASBizException {
        if (migOrgUnits == null || migOrgUnits.isEmpty() || orgViewId == null) {
            return null;
        }
        Connection conn = null;
        LinkedHashMap<String, Boolean> result = new LinkedHashMap<String, Boolean>();
        try {
            conn = this.getConnection(ctx);
            BgOrgUnitFactory.getLocalInstance(ctx).batchUpdate(BOSUuid.read((String)orgViewId), updateOrgUnits);
            result.put("updateBgVariate", BgOrgMigrationUtils.updateBgVariate(ctx, migOrgUnits, orgViewId));
            result.put("updateDimensionRelation", BgOrgMigrationUtils.updateDimensionRelation(conn, migOrgUnits, orgViewId));
            result.put("updateBgTemplate", BgOrgMigrationUtils.updateBgTemplate(conn, migOrgUnits, orgViewId));
            result.put("updateBizCalc", BgOrgMigrationUtils.updateBizCalc(ctx, conn, migOrgUnits, orgViewId));
            result.put("updateBgExamine", BgOrgMigrationUtils.updateBgExamine(ctx, conn, migOrgUnits, orgViewId));
            result.put("updateBudgetAndActualForm", BgOrgMigrationUtils.updateBudgetAndActualForm(ctx, conn, migOrgUnits, orgViewId));
            result.put("updateBgAdjustBill", BgOrgMigrationUtils.updateBgAdjustBill(ctx, migOrgUnits, orgViewId));
            result.put("updateBgSchemeIntegration", BgOrgMigrationUtils.updateBgSchemeIntegration(ctx, migOrgUnits, orgViewId));
            result.put("updateBgControlSetting", BgOrgMigrationUtils.updateBgControlSetting(conn, migOrgUnits, orgViewId));
            result.put("updateBgControlRecord", BgOrgMigrationUtils.updateBgControlRecord(ctx, migOrgUnits, orgViewId));
            BgOrgMigrationUtils.updateBgRefDimMember(ctx, migOrgUnits, orgViewId);
            MbgVirtualView.getInstance((Context)ctx).checkBgOrgClosure(ctx, BOSUuid.read((String)orgViewId));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    @Override
    protected Map _checkBgFormOrgUnits(Context ctx, List orgUnits, String orgViewId) throws BOSException {
        final HashMap result = new HashMap();
        if (ctx == null || orgUnits == null || orgUnits.isEmpty() || orgViewId == null) {
            return result;
        }
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (Object obj : orgUnits) {
            orgUnitIds.add(((BgOrgUnitInfo)obj).getOrgUnitID());
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select distinct FOrgUnitId from T_MBG_BgForm where FBgSchemeId in ( select sett.FBGSCHEMEID  FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember  On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = ?  AND settMember.FMemberID = ? )").append("and ForgUnitId in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{DimensionConstants.DEF_ORGUNIT_NUMBER, orgViewId}, (Object[])orgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                String orgUnitId = res.getString("FOrgUnitId");
                result.put(orgUnitId, true);
            }
        });
        return result;
    }

    @Override
    protected List _getBgSchemesByOrgViewId(Context ctx, String orgViewId) throws BOSException, EASBizException {
        List<BgSchemeInfo> result = null;
        try {
            result = BgOrgMigrationUtils.getBgSchemesByViewId(ctx, orgViewId, DimensionConstants.DEF_ORGUNIT_NUMBER);
        }
        catch (SQLException e) {
            logger.error((Object)"_getBgSchemesByOrgViewId error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected Set _getCostCenterChildren(Context ctx, IObjectValue orgUnitInfo, IObjectValue userInfo) throws BOSException, EASBizException {
        HashSet<String> orgIds = new HashSet<String>();
        if (orgUnitInfo == null || userInfo == null) {
            return orgIds;
        }
        String longNumber = ((OrgUnitInfo)orgUnitInfo).getLongNumber();
        String userId = ((UserInfo)userInfo).getId().toString();
        Connection conn = null;
        IRowSet rst = null;
        String sql = "SELECT fid FROM t_org_costcenter where FLONGNUMBER LIKE '" + longNumber + "!%' and FID in (SELECT FORGID  FROM " + BgDBUtils.getOrgRangeTable((Context)ctx) + " where FUSERID  = '" + userId + "' and FTYPE  = " + 10 + ")";
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql);
            while (rst.next()) {
                orgIds.add(rst.getString(1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return orgIds;
    }
}

