/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.PropertyRefSourceInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewCollection;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.app.AbstractBgOrgViewControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgViewControllerBean
extends AbstractBgOrgViewControllerBean {
    private static final long serialVersionUID = 6144934172626876458L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgOrgViewControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        MbgVirtualView view = MbgVirtualView.getInstance((Context)ctx);
        BgOrgViewInfo bgOrgView = (BgOrgViewInfo)model;
        if (bgOrgView.getSnapShotVar() == null) {
            bgOrgView.setSnapShotVar("1000");
            view.checkBgOrgBaseClosure(ctx);
        }
        IObjectPK pk = super._addnew(ctx, model);
        view.checkBgOrgClosure(ctx, BOSUuid.read((String)pk.toString()));
        return pk;
    }

    @Override
    protected IObjectValue _getBgViewInfo(Context ctx, String orgLongNumber) throws BOSException, EASBizException {
        BgOrgViewInfo bgOrgViewInfo = null;
        if (StringUtils.isEmpty((String)orgLongNumber)) {
            return null;
        }
        ArrayList<String> numbers = new ArrayList<String>();
        String[] tmpStrs = orgLongNumber.split("!");
        if (tmpStrs != null) {
            int in = tmpStrs.length;
            for (int i = 0; i < in; ++i) {
                numbers.add(tmpStrs[i]);
            }
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        StringBuffer sql = new StringBuffer("select top 1 fid ").append("from t_mbg_bgorgview ").append("where forgUnitid in ( select Fid from t_org_costcenter where fNumber in ( ").append(MbgSqlHelper.getParamSizeString((int)numbers.size())).append(")) ").append("and fcreatetime is not null order by fcreatetime desc");
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)ps, numbers);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgOrgViewInfo = BgOrgViewFactory.getLocalInstance(ctx).getBgOrgViewInfo((IObjectPK)new ObjectUuidPK(rs.getString("fid")));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return bgOrgViewInfo;
    }

    @Override
    protected List<String> _getOrgUnitCollByViewId(Context ctx, BOSUuid bgOrgViewId) throws BOSException, EASBizException {
        ArrayList<String> orgUntiLst = new ArrayList<String>();
        if (bgOrgViewId == null) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        StringBuffer sql = new StringBuffer("select FId from T_MBG_BGORGUNIT where FViewID = ?");
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql.toString());
            ps.setString(1, bgOrgViewId.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                orgUntiLst.add(rs.getString("FId").toString());
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return orgUntiLst;
    }

    @Override
    protected boolean _isReferencedByScheme(Context ctx, String viewID) throws BOSException {
        String sql = "select count(Fid) from T_MBG_BgDimSettingsMember where FMemberID = ?";
        IRowSet rowset = null;
        boolean isReferenced = false;
        try {
            int count;
            rowset = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{viewID});
            if (rowset.next() && (count = Integer.valueOf(rowset.getString(1)).intValue()) >= 1) {
                isReferenced = true;
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rowset);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rowset);
        return isReferenced;
    }

    @Override
    protected boolean _checkHasOrg(Context ctx, BOSUuid orgViewId) throws BOSException, EASBizException {
        String sql = "select top 1 FID from T_MBG_BgOrgUnit where FVIEWID = '" + orgViewId + "'";
        IRowSet rowset = DbUtil.executeQuery((Context)ctx, (String)sql);
        boolean isHasOrg = false;
        try {
            if (rowset.next()) {
                isHasOrg = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return isHasOrg;
    }

    @Override
    protected Set _getCollection(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        HashSet<BOSUuid> bgOrgViewIds = new HashSet<BOSUuid>();
        if (orgUnitId == null) {
            return bgOrgViewIds;
        }
        String _orgUnitId = orgUnitId.toString();
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select FViewId from T_MBG_BgOrgUnit where FOrgUnitId = ?", (Object[])new String[]{_orgUnitId});
            while (rst.next()) {
                bgOrgViewIds.add(BOSUuid.read((String)rst.getString("FViewId")));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"bgOrgView Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return bgOrgViewIds;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getDirectOrgUnits(Context ctx, String bgOrgViewId, String parentId, boolean isOUSealUp, boolean isShowParentSelf, boolean isNeedAddOrgRange, boolean isOnlyNoLeaf) throws BOSException, EASBizException {
        IRowSet rs;
        Connection conn;
        BgOrgUnitCollection col;
        block22: {
            if (StringUtils.isEmpty((String)bgOrgViewId)) {
                throw new BOSException("BgOrgViewId is null!");
            }
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            col = new BgOrgUnitCollection();
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            conn = null;
            rs = null;
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<Object> longParams = new ArrayList<Object>();
            String tmpTable = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer longNumberSql = new StringBuffer();
            try {
                conn = this.getConnection(ctx);
                sql.append("Select FID, FOrgUnitId, FNumber, FName_").append(ctx.getLocale()).append(" FName, FLongNumber, FLevel, FIsLeaf ,FParentId, FIsVirtual, FSimpleName,FShowLevel, FDisplayName_").append(ctx.getLocale()).append(" FDisplayName FROM T_Mbg_BgOrgUnit Where FViewId = ? ");
                paramList.add(bgOrgViewId);
                if (isShowParentSelf) {
                    sql.append(" AND (FID = ? OR FParentId = ? ) ");
                    paramList.add(parentId);
                    paramList.add(parentId);
                } else {
                    sql.append(" AND FParentId = ? ");
                    paramList.add(parentId);
                }
                if (isNeedAddOrgRange || !isOUSealUp) {
                    BgOrgUnitCollection coll;
                    int startIndex = 0;
                    String longNumber = null;
                    if (!StringUtils.isEmpty((String)parentId) && (coll = iBgOrgUnit.getBgOrgUnitCollection("select longNumber where id = '" + parentId + "'")) != null && !coll.isEmpty()) {
                        startIndex = coll.get(0).getLongNumber().length() + 2;
                        longNumber = coll.get(0).getLongNumber();
                    }
                    sql.append(" AND FLongNumber IN (");
                    tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FVALIDLN NVARCHAR(1024))");
                    longNumberSql.append("insert into ").append(tmpTable);
                    longNumberSql.append(" (FVALIDLN) ");
                    longNumberSql.append("select distinct substring(org.FLongNumber, 0, CHARINDEX('!', org.FLongNumber||'!', " + startIndex + ")-1) AS FVALIDLN from T_MBg_BgOrgUnit org ");
                    longNumberSql.append("Where org.FViewId = ? ");
                    longParams.add(bgOrgViewId);
                    if (longNumber != null) {
                        longNumberSql.append(" AND org.FLongNumber like ? ");
                        longParams.add(longNumber + "!%");
                    }
                    if (isNeedAddOrgRange) {
                        longNumberSql.append(" AND FORGUNITID in (select FOrgId From " + BgDBUtils.getOrgRangeTable((Context)ctx) + " where FUserId = ? And FType = ? )");
                        longParams.add(userPK.toString());
                        longParams.add(10);
                    }
                    if (!isOUSealUp) {
                        longNumberSql.append(" AND org.FIsOUSealUp = 0 ");
                    }
                    if (isShowParentSelf) {
                        longNumberSql.append(" UNION Select FlongNumber FROM T_MBg_BgOrgUnit Where FID = ? ");
                        longParams.add(parentId);
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)longNumberSql.toString(), (Object[])longParams.toArray());
                    sql.append(" select FVALIDLN From " + tmpTable);
                    sql.append(")");
                }
                sql.append(" Order By FShowLevel");
                rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])paramList.toArray());
                BgOrgUnitInfo info = null;
                BgOrgUnitInfo parentInfo = null;
                while (rs.next()) {
                    info = new BgOrgUnitInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FID")));
                    info.setOrgUnitID(rs.getString("FOrgUnitId"));
                    info.setNumber(rs.getString("FNumber"));
                    info.setName(rs.getString("FName"));
                    info.setLongNumber(rs.getString("FLongNumber"));
                    info.setLevel(rs.getInt("FLevel"));
                    info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                    info.setIsVirtual(rs.getBoolean("FIsVirtual"));
                    info.setSimpleName(rs.getString("FSimpleName"));
                    info.setShowLevel(rs.getInt("FShowLevel"));
                    info.setDisplayName(rs.getString("FDisplayName"));
                    String parentTmpId = rs.getString("FParentId");
                    if (parentTmpId == null) {
                        info.setParent(null);
                    } else {
                        parentInfo = new BgOrgUnitInfo();
                        parentInfo.setId(BOSUuid.read((String)parentTmpId));
                        info.setParent(parentInfo);
                    }
                    col.add(info);
                }
                if (isOnlyNoLeaf && !col.isEmpty()) {
                    HashSet<String> orgIds = new HashSet<String>();
                    for (int i = 0; i < col.size(); ++i) {
                        orgIds.add(col.get(i).getId().toString());
                    }
                    sql.setLength(0);
                    sql.append("SELECT distinct FPARENTID FROM T_MBG_BgOrgUnit where FISLEAF = ? AND FPARENTID  in (");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    List orgUnitIds = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{Boolean.FALSE}, (Object[])orgIds.toArray(), (int)50));
                    for (int i = col.size() - 1; i >= 0; --i) {
                        info = col.get(i);
                        if (info.isIsLeaf()) {
                            col.remove(info);
                            continue;
                        }
                        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                            if (orgUnitIds.contains(info.getId().toString())) continue;
                            info.setIsLeaf(true);
                            continue;
                        }
                        info.setIsLeaf(true);
                    }
                }
                if (tmpTable == null) break block22;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rs, null, (Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        return col;
    }

    @Override
    protected IObjectCollection _getOrgViewByOrgUnit(Context ctx, String orgUnitID) throws BOSException {
        ArrayList orgViews = new ArrayList();
        BgOrgViewCollection coll = new BgOrgViewCollection();
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" select v.FID, v.FNumber, v.FName_").append(ctx.getLocale()).append(", v.FLongNumber, v.FLevel, v.FIsLeaf, v.FSnapShotVar from t_mbg_bgorgview v join t_mbg_bgorgUnit u  on u.FViewID = v.FID  where u.FOrgUnitID = ?  order by v.FNumber ");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{orgUnitID});
            while (rs.next()) {
                BgOrgViewInfo info = new BgOrgViewInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString("FName_" + ctx.getLocale()));
                info.setLongNumber(rs.getString("FLongNumber"));
                info.setLevel(rs.getInt("FLevel"));
                info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                info.setSnapShotVar(rs.getString("FSnapShotVar"));
                coll.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return coll;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IObjectCollection _getDirectOrgUnits(Context ctx, String bgOrgViewId, String parentId, boolean isOUSealUp, boolean isShowParentSelf, boolean isNeedAddOrgRange, boolean isVirtual, boolean isOnlyNoLeaf) throws BOSException, EASBizException {
        IRowSet rs;
        Connection conn;
        BgOrgUnitCollection col;
        block21: {
            if (StringUtils.isEmpty((String)bgOrgViewId)) {
                throw new BOSException("BgOrgViewId is null!");
            }
            ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            ArrayList<String> paramList = new ArrayList<String>();
            ArrayList<String> longParams = new ArrayList<String>();
            col = new BgOrgUnitCollection();
            BgOrgUnitInfo info = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            conn = null;
            rs = null;
            String tmpTable = null;
            StringBuffer sql = new StringBuffer();
            StringBuffer longNumberSql = new StringBuffer();
            try {
                conn = this.getConnection(ctx);
                sql.append("Select FID, FOrgUnitId, FNumber, FName_").append(ctx.getLocale()).append(" FName, FLongNumber, FLevel, FIsLeaf,FISVIRTUAL FROM T_Mbg_BgOrgUnit Where FViewId = ? ");
                paramList.add(bgOrgViewId);
                if (!isVirtual) {
                    sql.append(" AND FIsVirtual = 0 ");
                }
                if (isShowParentSelf) {
                    sql.append(" AND (FID = ? OR FParentId = ? ) ");
                    paramList.add(parentId);
                    paramList.add(parentId);
                } else {
                    sql.append(" AND FParentId = ? ");
                    paramList.add(parentId);
                }
                if (isNeedAddOrgRange || !isOUSealUp) {
                    BgOrgUnitCollection coll;
                    int startIndex = 0;
                    String longNumber = null;
                    if (parentId != null && (coll = iBgOrgUnit.getBgOrgUnitCollection("select longNumber where id = '" + parentId + "'")) != null && !coll.isEmpty()) {
                        startIndex = coll.get(0).getLongNumber().length() + 2;
                        longNumber = coll.get(0).getLongNumber();
                    }
                    sql.append(" AND FLongNumber IN (");
                    tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FVALIDLN NVARCHAR(1024))");
                    longNumberSql.append("insert into ").append(tmpTable);
                    longNumberSql.append(" (FVALIDLN) ");
                    longNumberSql.append("select distinct substring(org.FLongNumber, 0, CHARINDEX('!', org.FLongNumber||'!', " + startIndex + ")-1) AS FVALIDLN from T_MBg_BgOrgUnit org ");
                    longNumberSql.append("Where org.FViewId = ? ");
                    longParams.add(bgOrgViewId);
                    if (longNumber != null) {
                        longNumberSql.append(" AND org.FLongNumber like ? ");
                        longParams.add(longNumber + "!%");
                    }
                    if (isNeedAddOrgRange) {
                        longNumberSql.append(" AND FORGUNITID in (select FOrgId From " + BgDBUtils.getOrgRangeTable((Context)ctx) + " where FUserId = ? )");
                        longParams.add(userPK.toString());
                    }
                    if (!isOUSealUp) {
                        longNumberSql.append(" AND org.FIsOUSealUp = 0 ");
                    }
                    if (isShowParentSelf) {
                        longNumberSql.append(" UNION Select FlongNumber FROM T_MBg_BgOrgUnit Where FID = ? ");
                        longParams.add(parentId);
                    }
                    BgDBUtils.executeUpdate((Connection)conn, (String)longNumberSql.toString(), (Object[])longParams.toArray());
                    sql.append(" select FVALIDLN From " + tmpTable);
                    sql.append(")");
                }
                sql.append(" Order By FLongNumber");
                rs = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])paramList.toArray());
                while (rs.next()) {
                    info = new BgOrgUnitInfo();
                    info.setId(BOSUuid.read((String)rs.getString("FID")));
                    info.setOrgUnitID(rs.getString("FOrgUnitId"));
                    info.setNumber(rs.getString("FNumber"));
                    info.setName(rs.getString("FName"));
                    info.setLongNumber(rs.getString("FLongNumber"));
                    info.setLevel(rs.getInt("FLevel"));
                    info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                    info.setIsVirtual(rs.getBoolean("FISVIRTUAL"));
                    col.add(info);
                }
                if (isOnlyNoLeaf && !col.isEmpty()) {
                    HashSet<String> orgIds = new HashSet<String>();
                    for (int i = 0; i < col.size(); ++i) {
                        orgIds.add(col.get(i).getId().toString());
                    }
                    sql.setLength(0);
                    sql.append("SELECT distinct FPARENTID FROM T_MBG_BgOrgUnit where FISLEAF = ? AND FPARENTID  in (");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                    List orgUnitIds = MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{Boolean.FALSE}, (Object[])orgIds.toArray(), (int)50));
                    for (int i = col.size() - 1; i >= 0; --i) {
                        info = col.get(i);
                        if (info.isIsLeaf()) {
                            col.remove(info);
                            continue;
                        }
                        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
                            if (orgUnitIds.contains(info.getId().toString())) continue;
                            info.setIsLeaf(true);
                            continue;
                        }
                        info.setIsLeaf(true);
                    }
                }
                if (tmpTable == null) break block21;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup(rs, null, (Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rs, null, (Connection)conn);
        return col;
    }

    @Override
    protected Set _getOrgUnitCollByViewId(Context ctx, BOSUuid bgOrgViewId, boolean isNeedAddOrgRange) throws BOSException, EASBizException {
        HashSet<String> orgUntiSet = new HashSet<String>();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        if (bgOrgViewId == null) {
            return null;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        StringBuffer sql = new StringBuffer("select FID, ForgUnitID from T_MBG_BGORGUNIT where FViewID = ?");
        if (isNeedAddOrgRange) {
            sql = new StringBuffer("select org.FID, org.ForgUnitID from T_MBG_BGORGUNIT org INNER JOIN " + BgDBUtils.getOrgRangeTable((Context)ctx) + " orgRange ON orgRange.FOrgId = org.FORGUNITID  where orgRange.FUserId = ? AND org.FViewID = ?");
        }
        try {
            connection = this.getConnection(ctx);
            ps = connection.prepareStatement(sql.toString());
            ps.setString(1, userPK.toString());
            ps.setString(2, bgOrgViewId.toString());
            rs = ps.executeQuery();
            while (rs.next()) {
                orgUntiSet.add(rs.getString("ForgUnitID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return orgUntiSet;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filterInfo = super.getFilterForDefaultCU(ctx, model);
        if (model != null) {
            CostCenterOrgUnitInfo costUnitInfo = ((BgOrgViewInfo)model).getOrgUnit();
            if (filterInfo != null && costUnitInfo != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)costUnitInfo.getId().toString(), CompareType.EQUALS));
            }
        }
        return filterInfo;
    }

    @Override
    protected IObjectCollection _getMultiDirectOrgUnits(Context ctx, String bgOrgViewId, List parentIds, boolean isSealUp, boolean isShowParentSelf, boolean isUserPermissionFilter, boolean isShowVirtualOrg, boolean isOnlyNoLeaf) throws BOSException {
        BgOrgUnitCollection result = new BgOrgUnitCollection();
        IObjectCollection bgOrgUnitCols = null;
        for (int i = 0; i < parentIds.size(); ++i) {
            try {
                bgOrgUnitCols = this._getDirectOrgUnits(ctx, bgOrgViewId, parentIds.get(i).toString(), isSealUp, isShowParentSelf, isUserPermissionFilter, isOnlyNoLeaf);
                if (!isShowVirtualOrg) {
                    this.removeVirtualOrg(bgOrgUnitCols);
                }
                result.addObjectCollection(bgOrgUnitCols);
                continue;
            }
            catch (EASBizException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    @Override
    protected IObjectCollection _getAllOrgUnits(Context ctx, String bgOrgViewId, boolean isOUSealUp, String orgUnitId, boolean isNeedAddOrgRang) throws BOSException, EASBizException {
        BgOrgUnitCollection col;
        String longNumber = null;
        if (StringUtils.isEmpty((String)bgOrgViewId)) {
            throw new BOSException("BgOrgViewId is null!");
        }
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        IBgOrgUnit iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
        ArrayList<String> paramList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("Select org.FID AS FID, org.FOrgUnitId AS FOrgUnitId, org.FNumber AS FNumber, org.FName_").append(ctx.getLocale()).append(" AS FName, org.FLongNumber AS FLongNumber, org.FLevel AS FLevel, org.FIsLeaf AS FIsLeaf ,org.FParentId AS FParentId, org.FIsVirtual AS FIsVirtual, org.FSimpleName AS FSimpleName,org.FShowLevel AS FShowLevel FROM T_Mbg_BgOrgUnit org ");
        if (!isOUSealUp || isNeedAddOrgRang) {
            if (orgUnitId != null && (col = iBgOrgUnit.getBgOrgUnitCollection("select longNumber where id = '" + orgUnitId + "'")) != null && !col.isEmpty()) {
                longNumber = col.get(0).getLongNumber();
            }
            if (isNeedAddOrgRang) {
                sql.append(" INNER JOIN T_PM_ORGRANGE orgRange ON orgRange.FOrgId = org.FORGUNITID ").append(" AND orgRange.FUserId = ? ");
                paramList.add(userPK.toString());
            }
            sql.append(" Where org.FViewId = ? ");
            paramList.add(bgOrgViewId);
            if (longNumber != null) {
                sql.append(" AND ( org.FLongNumber like ? ");
                paramList.add(longNumber + "!%");
                sql.append(" or org.FlongNumber in (Select FlongNumber FROM T_MBg_BgOrgUnit Where FID = ? ))");
                paramList.add(orgUnitId);
            }
            if (!isOUSealUp) {
                sql.append(" AND org.FIsOUSealUp = 0 ");
            }
        }
        sql.append(" Order By FShowLevel");
        col = new BgOrgUnitCollection();
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])paramList.toArray());
            while (rs.next()) {
                BgOrgUnitInfo info = new BgOrgUnitInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setOrgUnitID(rs.getString("FOrgUnitId"));
                info.setNumber(rs.getString("FNumber"));
                info.setName(rs.getString("FName"));
                info.setLongNumber(rs.getString("FLongNumber"));
                info.setLevel(rs.getInt("FLevel"));
                info.setIsLeaf(rs.getBoolean("FIsLeaf"));
                info.setIsVirtual(rs.getBoolean("FIsVirtual"));
                info.setSimpleName(rs.getString("FSimpleName"));
                info.setShowLevel(rs.getInt("FShowLevel"));
                String parentTmpId = rs.getString("FParentId");
                if (parentTmpId == null) {
                    info.setParent(null);
                } else {
                    BgOrgUnitInfo parentInfo = new BgOrgUnitInfo();
                    parentInfo.setId(BOSUuid.read((String)parentTmpId));
                    info.setParent(parentInfo);
                }
                col.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        return col;
    }

    @Override
    protected IObjectPK _copyOrgView(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        Object _copyBgOrgViewInfoId = model.remove("COPY_ORG_VIEW_ID");
        BOSUuid copyBgOrgViewInfoId = null;
        if (_copyBgOrgViewInfoId != null) {
            copyBgOrgViewInfoId = BOSUuid.read((String)_copyBgOrgViewInfoId.toString());
        }
        IObjectPK pk = super._submit(ctx, model);
        this.copyOrgUnitByOrgView(ctx, model, pk, copyBgOrgViewInfoId);
        return pk;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyOrgUnitByOrgView(Context ctx, IObjectValue model, IObjectPK pk, BOSUuid copyBgOrgViewInfoId) throws BgException, BOSException {
        Connection conn;
        block6: {
            conn = null;
            TempTablePool pool = null;
            String tmpTable = null;
            StringBuffer sql = new StringBuffer();
            String viwId = pk.toString();
            String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            Timestamp time = new Timestamp(System.currentTimeMillis());
            try {
                conn = this.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                tmpTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44), FOldID VARCHAR(44), FName NVARCHAR(255), FNumber NVARCHAR(80), FLongNumber NVARCHAR(1024), FIsLeaf INT, FLevel INT, FIsVirtual INT, FIsOUSealUp INT, FOrgUnitID VARCHAR(44), FParentID VARCHAR(44), FShowLevel INT,FSimpleName NVARCHAR(80),FCode VARCHAR(80),FDescription VARCHAR(1024),FDisplayName VARCHAR(1024), FIntID INT, FpolAlgorithm INT, FIsTransferQingAnalyse INT, FperiodName INT)");
                sql.setLength(0);
                sql.append("Insert Into ").append(tmpTable).append(" (FID, FOldID, FName, FNumber, FLongNumber, FIsLeaf, FLevel, FIsVirtual, FIsOUSealUp, FOrgUnitID, FParentID, FShowLevel, FSimpleName, FCode, FDescription, FDisplayName, FIntID, FpolAlgorithm, FIsTransferQingAnalyse, FperiodName)").append(" Select newbosid('").append(new BgOrgUnitInfo().getBOSType()).append("'), FID, FName_").append(ctx.getLocale()).append(",  FNumber, FLongNumber, FIsLeaf, FLevel, FIsVirtual, FIsOUSealUp, FOrgUnitID, FParentID, FShowLevel, FSimpleName, FCode, FDescription_").append(ctx.getLocale()).append(", FDisplayName_").append(ctx.getLocale()).append(", FIntID, FpolAlgorithm, FIsTransferQingAnalyse, FperiodName").append(" From T_MBG_BgOrgUnit").append(" Where FViewID = ?");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{copyBgOrgViewInfoId.toString()});
                pool.createIndex(tmpTable, "FOldID", false, false);
                pool.createIndex(tmpTable, "FParentID", false, false);
                sql.setLength(0);
                sql.append("Update ").append(tmpTable).append(" t1 ").append(" set FParentID = (Select t2.FID From ").append(tmpTable).append(" t2 Where t1.FParentID = t2.FOldID) ").append(" where t1.FLevel != 1 and t1.FParentID is not null and exists (Select 1 From ").append(tmpTable).append(" t2 Where t1.FParentID = t2.FOldID)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
                sql.setLength(0);
                sql.append("Insert Into T_MBG_BgOrgUnit (FID, FViewID, FName_" + ctx.getLocale() + ", FNumber, FLongNumber, FIsLeaf, FLevel, FSimpleName, FCode, FDescription_" + ctx.getLocale() + ", FDisplayName_" + ctx.getLocale() + ",FIsVirtual, FIsOUSealUp, FOrgUnitID, FParentID, FShowLevel, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FIntID, FpolAlgorithm, FIsTransferQingAnalyse, FperiodName) ").append(" Select FID, ?, FName, FNumber, FLongNumber, FIsLeaf, FLevel, FSimpleName, FCode, FDescription, FDisplayName, FIsVirtual, FIsOUSealUp, FOrgUnitID, FParentID, FShowLevel, ?, ?, ?, ?, FIntId, FpolAlgorithm, FIsTransferQingAnalyse, FperiodName from " + tmpTable);
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{viwId, userId, time, userId, time});
                sql.setLength(0);
                sql.append("insert into T_MBG_PropertyRefSource (FID, FSourceID, FPropertyID)").append(" select newbosid('").append(new PropertyRefSourceInfo().getBOSType()).append("'), t1.FID, FPropertyID").append(" from T_MBG_PropertyRefSource inner join ").append(tmpTable).append(" t1 on t1.FOldID = FSourceID").append(" Where FSourceID in ( Select t2.FID from T_MBG_BgOrgUnit t2 where t2.FViewID = ?)");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{copyBgOrgViewInfoId.toString()});
                MbgVirtualView.getInstance((Context)ctx).checkBgOrgClosure(ctx, BOSUuid.read((String)pk.toString()));
                if (tmpTable == null) break block6;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"copyOrgUnitByOrgView error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                    catch (Exception ex2) {
                        throw new BOSException((Throwable)ex2);
                    }
                }
                catch (Throwable throwable) {
                    if (tmpTable != null) {
                        pool.releaseTable(tmpTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void removeVirtualOrg(IObjectCollection bgOrgUnitCols) {
        if (bgOrgUnitCols == null || bgOrgUnitCols.size() == 0) {
            return;
        }
        if (bgOrgUnitCols instanceof BgOrgUnitCollection) {
            for (int i = bgOrgUnitCols.size() - 1; i >= 0; --i) {
                BgOrgUnitInfo info = (BgOrgUnitInfo)bgOrgUnitCols.getObject(i);
                if (!info.isIsVirtual()) continue;
                ((BgOrgUnitCollection)bgOrgUnitCols).remove(info);
            }
        }
    }
}

