/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgPeriodDecomposeFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDecomposeError;
import com.kingdee.eas.ma.mbg.common.BgDecomposeParameter;
import com.kingdee.eas.ma.mbg.common.BgDecomposeResult;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgPeriodDecomposeUtils;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.SheetInfo;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgPeriodDecomposeFacadeControllerBean
extends AbstractBgPeriodDecomposeFacadeControllerBean {
    private static final long serialVersionUID = -5408472930242806489L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgPeriodDecomposeFacadeControllerBean");

    @Override
    protected Object _bgPeriodDec(Context ctx, BgDecomposeParameter bgDecParameter) throws BOSException, EASBizException {
        if (bgDecParameter == null) {
            return null;
        }
        Map<String, List<String>> sourceNumbers = bgDecParameter.getSourceNumber();
        Map sourceData = bgDecParameter.getSourceData();
        List<Map<String, Object>> scaleMap = bgDecParameter.getScaleMap();
        boolean isAvgDecompose = bgDecParameter.isAvgDecompose();
        BgFormInfo bgForm = bgDecParameter.getBgFormInfo();
        if (sourceNumbers.isEmpty() || scaleMap.isEmpty() || bgForm == null || bgForm.getId() == null) {
            return null;
        }
        if (BgFormFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(bgForm.getId().toString()))) {
            bgForm = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgForm.getId().toString()), BgNFSHelper.getFormBaseSelectors(true));
        }
        BgSchemeDimensionHelper bgSchemeHelper = new BgSchemeDimensionHelper(ctx, bgForm.getBizBgScheme().getId().toString());
        Map bgDataMap = this.queryBgData(ctx, bgDecParameter);
        this.mergeDecData(bgDataMap, sourceData, sourceNumbers);
        HashMap bgDecDataMap = new HashMap();
        HashMap<String, BgNViewDataInfo> subDataMap = null;
        BgNViewDataInfo data = null;
        String orgId2 = null;
        String versionNumber2 = null;
        String sourceFormula2 = null;
        String targeFormula = null;
        BigDecimal sourceValue = null;
        BigDecimal budgetValue = null;
        BigDecimal scaleSize = new BigDecimal(scaleMap.size());
        for (String orgId2 : sourceData.keySet()) {
            Map verMap = (Map)sourceData.get(orgId2);
            if (verMap.isEmpty()) continue;
            subDataMap = new HashMap<String, BgNViewDataInfo>();
            if (bgDecDataMap.containsKey(orgId2)) continue;
            bgDecDataMap.put(orgId2, subDataMap);
            for (String versionNumber2 : verMap.keySet()) {
                for (String sourceFormula2 : ((Map)verMap.get(versionNumber2)).keySet()) {
                    sourceValue = (BigDecimal)((Map)verMap.get(versionNumber2)).get(sourceFormula2);
                    String[] forParams = BgNFSHelper.parseFormulaPara(sourceFormula2);
                    for (int indx = 0; indx < scaleMap.size(); ++indx) {
                        Map<String, Object> tmpMap = scaleMap.get(indx);
                        if (tmpMap.containsKey(DimensionConstants.DEF_PERIOD_NUMBER)) {
                            forParams[1] = (String)tmpMap.get(DimensionConstants.DEF_PERIOD_NUMBER);
                        }
                        if (tmpMap.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER)) {
                            forParams[3] = (String)tmpMap.get(DimensionConstants.DEF_SCENARIO_NUMBER);
                        }
                        if (tmpMap.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER)) {
                            forParams[2] = (String)tmpMap.get(DimensionConstants.DEF_ELEMENT_NUMBER);
                        }
                        BigDecimal value = (BigDecimal)tmpMap.get(DimensionConstants.BGCOMPOSE_SCALE);
                        targeFormula = BgNFSHelper.getFormulaFromParam(forParams);
                        String key = DimUtils.getDimDataKey(targeFormula, versionNumber2);
                        data = new BgNViewDataInfo();
                        data.setFormula(targeFormula);
                        data.setBgVersion(versionNumber2);
                        data.splitFormula();
                        budgetValue = isAvgDecompose ? (sourceValue.divideAndRemainder(scaleSize)[1].equals(BgNConstants.ZERO) ? sourceValue.divideAndRemainder(scaleSize)[0] : sourceValue.multiply(value)) : sourceValue.multiply(value);
                        data.setBudgetValue(budgetValue);
                        subDataMap.put(key, data);
                    }
                }
            }
        }
        BgDecomposeResult result = new BgDecomposeResult();
        result.setBgDecParameter(bgDecParameter);
        result.setDataResult(bgDecDataMap);
        this.checkDataState(ctx, bgDataMap, bgDecDataMap, result);
        this.checkMemberExist(ctx, result, bgForm, bgSchemeHelper);
        this.processResultErrors(ctx, result);
        return result;
    }

    protected void processResultErrors(Context ctx, BgDecomposeResult result) throws EASBizException, BOSException {
        if (result == null || result.getErrors().isEmpty()) {
            return;
        }
        BgDecomposeParameter bgDecParameter = result.getBgDecParameter();
        BgFormInfo bgFormInfo = bgDecParameter.getBgFormInfo();
        if (bgFormInfo != null && bgFormInfo.getId() != null && BgFormFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(bgFormInfo.getId().toString()))) {
            bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId().toString()), BgNFSHelper.getSelectors());
        }
        BgSchemeDimensionHelper bgSchemeHelper = new BgSchemeDimensionHelper(ctx, bgFormInfo.getBizBgScheme().getId().toString());
        BgTemFormTypeEnum formType = bgFormInfo.getBgTemplate().getFormType();
        Map<String, Map<String, DataBaseInfo>> membersInfo = this.getMembersInfo(ctx, bgDecParameter.getTargeNumbers());
        Map<String, BgOrgUnitInfo> orgUnitMap = this.queryBgOrgUnit(ctx, result);
        Map<String, BgDimensionInfo> srcMap = bgSchemeHelper.getDimensionBySrcNumber();
        IMbgViewBase viewManager = bgDecParameter.getViewManager();
        if (viewManager == null || formType.equals((Object)BgTemFormTypeEnum.FIXEDFORM) || formType.equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
            viewManager = BgPeriodDecomposeUtils.getView(ctx, bgFormInfo);
        }
        Map<String, Map<String, BgDimensionMember>> membersMap = BgPeriodDecomposeUtils.getViewMembers(viewManager, bgFormInfo);
        List<BgDecomposeError> errors = result.getErrors();
        BgDecomposeError error = null;
        String formulaStr = null;
        int size = errors.size();
        for (int index = size - 1; index >= 0; --index) {
            error = errors.get(index);
            formulaStr = error.getFormula();
            boolean isLeaf = true;
            String[] params = BgNFSHelper.parseFormulaPara(formulaStr);
            String bgPeriodNumber = params[1];
            String bgScenarioNumber = params[3];
            String bgElementNumber = params[2];
            String currencyNumber = params[5];
            String itemNumber = params[0];
            String accountNumber = null;
            if (itemNumber.indexOf(",") > 0) {
                accountNumber = itemNumber.split(",")[0];
                StringBuffer dimMemberNumber = new StringBuffer();
                StringBuffer dimMemberName = new StringBuffer();
                String[] arr = itemNumber.split(",");
                for (int i = 1; i < arr.length; ++i) {
                    if (arr[i].indexOf(":") <= 0) continue;
                    dimMemberNumber.append(arr[i].split(":")[1]).append(",");
                    if (!srcMap.containsKey(arr[i].split(":")[0])) continue;
                    if (!membersMap.get(srcMap.get(arr[i].split(":")[0]).getNumber()).get(arr[i].split(":")[1]).isLeaf()) {
                        isLeaf = false;
                    }
                    dimMemberName.append(membersMap.get(srcMap.get(arr[i].split(":")[0]).getNumber()).get(arr[i].split(":")[1]).getName()).append(",");
                }
                if (dimMemberNumber.toString().endsWith(",")) {
                    error.setBgMemberNumber(dimMemberNumber.toString().substring(0, dimMemberNumber.toString().length() - 1));
                }
                if (dimMemberName.toString().endsWith(",")) {
                    error.setBgMemberName(dimMemberName.toString().substring(0, dimMemberName.toString().length() - 1));
                }
            } else {
                accountNumber = itemNumber;
            }
            if (!StringUtils.isEmpty((String)accountNumber)) {
                error.setBgAccountNumber(accountNumber.split(":")[1]);
                if (!membersMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER).get(accountNumber.split(":")[1]).isLeaf()) {
                    isLeaf = false;
                }
                error.setBgAccountName(membersMap.get(DimensionConstants.DEF_ACCOUNT_NUMBER).get(accountNumber.split(":")[1]).getName());
            }
            error.setBgElementNumber(bgElementNumber);
            if (membersMap.get(DimensionConstants.DEF_ELEMENT_NUMBER).containsKey(bgElementNumber)) {
                error.setBgElementName(membersMap.get(DimensionConstants.DEF_ELEMENT_NUMBER).get(bgElementNumber).getName());
            } else if (membersInfo.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && membersInfo.get(DimensionConstants.DEF_ELEMENT_NUMBER).containsKey(bgElementNumber)) {
                error.setBgElementName(membersInfo.get(DimensionConstants.DEF_ELEMENT_NUMBER).get(bgElementNumber).getName());
            }
            error.setBgPeriodNumber(bgPeriodNumber);
            if (membersInfo.containsKey(DimensionConstants.DEF_PERIOD_NUMBER) && membersInfo.get(DimensionConstants.DEF_PERIOD_NUMBER).containsKey(bgPeriodNumber)) {
                error.setBgPeriodName(membersInfo.get(DimensionConstants.DEF_PERIOD_NUMBER).get(bgPeriodNumber).getName());
            } else if (membersMap.get(DimensionConstants.DEF_PERIOD_NUMBER).containsKey(bgPeriodNumber)) {
                error.setBgPeriodName(membersMap.get(DimensionConstants.DEF_PERIOD_NUMBER).get(bgPeriodNumber).getName());
            }
            error.setBgScenarioNumber(bgScenarioNumber);
            if (membersMap.get(DimensionConstants.DEF_SCENARIO_NUMBER).containsKey(bgScenarioNumber)) {
                error.setBgScenarioName(membersMap.get(DimensionConstants.DEF_SCENARIO_NUMBER).get(bgScenarioNumber).getName());
            } else if (membersInfo.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && membersInfo.get(DimensionConstants.DEF_SCENARIO_NUMBER).containsKey(bgScenarioNumber)) {
                error.setBgScenarioName(membersInfo.get(DimensionConstants.DEF_SCENARIO_NUMBER).get(bgScenarioNumber).getName());
            }
            error.setCurrencyNumber(currencyNumber);
            error.setCurrencyName(membersMap.get(DimensionConstants.DEF_CURRENCY_NUMBER).get(currencyNumber).getName());
            if (!StringUtils.isEmpty((String)error.getOrgUnitId()) && orgUnitMap.containsKey(error.getOrgUnitId())) {
                error.setBgOrgUnitName(orgUnitMap.get(error.getOrgUnitId()).getName());
                error.setBgOrgUnitNumber(orgUnitMap.get(error.getOrgUnitId()).getNumber());
            }
            if (isLeaf) continue;
            errors.remove(index);
        }
        this.sort(errors);
    }

    protected void checkMemberExist(Context ctx, BgDecomposeResult result, BgFormInfo bgForm, BgSchemeDimensionHelper bgSchemeHelper) throws BOSException {
        if (ctx == null || result == null || bgForm == null) {
            return;
        }
        Map bgDecDataMap = result.getDataResult();
        BgTemFormTypeEnum formType = bgForm.getBgTemplate().getFormType();
        String formulaKey = null;
        String formulaStr = null;
        String versionNumber = null;
        BgDecomposeError error = null;
        HashSet<String> formulas = new HashSet<String>();
        try {
            IMbgViewBase manager = result.getBgDecParameter().getViewManager();
            if (formType.equals((Object)BgTemFormTypeEnum.FIXEDFORM) || formType.equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
                formulas.clear();
                formulas.addAll(BgPeriodDecomposeUtils.getFormulaSetOfBook(bgForm.getBook()));
            } else if (formType.equals((Object)BgTemFormTypeEnum.VIEWLIST)) {
                formulas.clear();
                for (int index = 0; index < manager.getSheetManagers().size(); ++index) {
                    formulas.addAll(MbgViewListFormServerHelper.buildFormula((MbgViewListSheetManager)manager.getSheetManagers().get(index), bgSchemeHelper, null));
                }
            } else if (formType.equals((Object)BgTemFormTypeEnum.VIEWFORM)) {
                formulas.clear();
                formulas.addAll(BgViewHelper.buildFormula((IMbgViewManager)manager, null, bgSchemeHelper));
            }
            String orgId2 = null;
            Map tmpMap = null;
            for (String orgId2 : bgDecDataMap.keySet()) {
                tmpMap = (Map)bgDecDataMap.get(orgId2);
                Iterator ite = tmpMap.keySet().iterator();
                while (ite.hasNext()) {
                    formulaKey = (String)ite.next();
                    formulaStr = formulaKey.split("_")[0];
                    versionNumber = formulaKey.split("_")[1];
                    if (formulas.contains(formulaStr)) continue;
                    error = new BgDecomposeError();
                    error.setOrgUnitId(orgId2);
                    error.setBgVersionNumber(versionNumber);
                    error.setFormula(formulaStr);
                    error.getErrors().add(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"memberNotExist", (Locale)ctx.getLocale()));
                    result.getErrors().add(error);
                    ite.remove();
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected void checkDataState(Context ctx, Map bgDataMap, Map decDataMap, BgDecomposeResult result) throws EASBizException, BOSException {
        if (bgDataMap.isEmpty() || decDataMap.isEmpty()) {
            return;
        }
        Locale local = ctx.getLocale();
        BgDecomposeError error = null;
        String orgUnitId2 = null;
        String formulaKey = null;
        BgNViewDataInfo dataInfo = null;
        BgNViewDataInfo decDataInfo = null;
        for (String orgUnitId2 : decDataMap.keySet()) {
            if (!bgDataMap.containsKey(orgUnitId2)) continue;
            Map formulaMap = (Map)decDataMap.get(orgUnitId2);
            Iterator ite = formulaMap.keySet().iterator();
            while (ite.hasNext()) {
                formulaKey = (String)ite.next();
                decDataInfo = (BgNViewDataInfo)decDataMap.get(formulaKey);
                if (!((Map)bgDataMap.get(orgUnitId2)).containsKey(formulaKey) || (dataInfo = (BgNViewDataInfo)((Map)bgDataMap.get(orgUnitId2)).get(formulaKey)) == null) continue;
                StringBuffer sb = new StringBuffer();
                if (dataInfo.getState() > 1) {
                    sb.append(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgPeriodDecomposeResource", (String)"checkState", (Locale)local, (Object[])new String[]{BgDataStateEnum.getEnum(dataInfo.getState()).getAlias(local)}));
                }
                if (sb.length() <= 0) continue;
                error = new BgDecomposeError();
                error.getErrors().add(sb.toString());
                error.setOrgUnitId(orgUnitId2);
                error.setFormula(formulaKey.split("_")[0]);
                error.setBgVersionNumber(formulaKey.split("_")[1]);
                result.getErrors().add(error);
                ite.remove();
            }
        }
    }

    protected Map queryBgData(Context ctx, BgDecomposeParameter bgDecParameter) throws BOSException, EASBizException {
        if (ctx == null || bgDecParameter.getBgFormInfo() == null) {
            return null;
        }
        BgSchemeInfo bgScheme = null;
        HashMap bgDataMap = new HashMap();
        HashSet<Integer> viewState = new HashSet<Integer>();
        viewState.add(1);
        viewState.add(9);
        viewState.add(3);
        viewState.add(5);
        viewState.add(13);
        viewState.add(11);
        try {
            BgFormInfo bgForm = bgDecParameter.getBgFormInfo();
            bgScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgForm.getBgScheme().getId());
            if (bgScheme == null) {
                return null;
            }
            BgSchemeDimensionHelper schemeHeleper = new BgSchemeDimensionHelper(ctx, bgScheme.getId().toString());
            BOSUuid bgOrgViewId = BOSUuid.read((String)schemeHeleper.getBgOrgViewId());
            IBgDimensionManagerBase manager = null;
            IMbgViewBase view = bgDecParameter.getViewManager();
            Set<String> sheetNames = this.getDecomposeSheetNames(bgDecParameter);
            if (view == null) {
                view = BgPeriodDecomposeUtils.getView(ctx, bgForm);
            }
            Map tmpMap = null;
            if (view != null && view.getSheetManagers() != null) {
                ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
                int in = view.getSheetManagers().size();
                for (int i = 0; i < in; ++i) {
                    manager = view.getSheetManagers().get(i).getDimensionManager().deepclone();
                    if (!sheetNames.isEmpty() && !sheetNames.contains(view.getSheetManagers().get(i).getSheetName())) continue;
                    this.movePageDim(bgForm, manager);
                    dimensionManager.add(manager);
                }
                tmpMap = !BgFormFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(bgForm.getId().toString())) ? BgFormFactory.getLocalInstance(ctx).getBgDataInfo(bgForm, viewState) : MBGFormFacadeFactory.getLocalInstance(ctx).queryBgData(null, (IObjectValue)bgForm, dimensionManager, bgForm.getDataType(), false, bgOrgViewId, false, viewState);
                if (tmpMap != null) {
                    bgDataMap.putAll(tmpMap);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"query Data error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        return bgDataMap;
    }

    protected void movePageDim(BgFormInfo bgFormInfo, IBgDimensionManagerBase manager) {
        if (manager == null) {
            return;
        }
        int formType = bgFormInfo.getBizTemplateType();
        if (formType == 4) {
            BgPeriodDecomposeUtils.movePageDimensionsToRow((IBgDimensionManager)manager);
        } else if (formType == 2) {
            BgPeriodDecomposeUtils.movePageDimensionsToRow((MbgViewListDimensionManager)manager);
        }
    }

    protected void mergeDecData(Map<String, Map<String, BgNViewDataInfo>> bgDataMap, Map<String, Map<String, Map<String, BigDecimal>>> bgDecDataMap, Map<String, List<String>> sourceNumbers) {
        String orgUnitId2 = null;
        for (String orgUnitId2 : bgDataMap.keySet()) {
            Map<String, BgNViewDataInfo> dataMap = bgDataMap.get(orgUnitId2);
            for (String formulakey : dataMap.keySet()) {
                BgNViewDataInfo dataInfo = dataMap.get(formulakey);
                if (dataInfo == null) continue;
                String formulaStr = formulakey.split("_")[0];
                String versionNumber = formulakey.split("_")[1];
                String[] params = BgNFSHelper.parseFormulaPara(formulaStr);
                String bgPeriodNumber = params[1];
                String bgScenarioNumber = params[3];
                String bgElementNumber = params[2];
                BigDecimal value = dataInfo.getBudgetValue();
                if (!sourceNumbers.get(DimensionConstants.DEF_PERIOD_NUMBER).contains(bgPeriodNumber) || value == null || sourceNumbers.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_SCENARIO_NUMBER).contains(bgScenarioNumber) || sourceNumbers.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER) && !sourceNumbers.get(DimensionConstants.DEF_ELEMENT_NUMBER).contains(bgElementNumber)) continue;
                if (bgDecDataMap == null) {
                    bgDecDataMap = new HashMap<String, Map<String, Map<String, BigDecimal>>>();
                }
                if (!bgDecDataMap.containsKey(orgUnitId2)) {
                    bgDecDataMap.put(orgUnitId2, new HashMap());
                }
                if (!bgDecDataMap.get(orgUnitId2).containsKey(versionNumber)) {
                    bgDecDataMap.get(orgUnitId2).put(versionNumber, new HashMap());
                }
                if (bgDecDataMap.get(orgUnitId2).get(versionNumber).containsKey(formulaStr)) continue;
                bgDecDataMap.get(orgUnitId2).get(versionNumber).put(formulaStr, value);
            }
        }
    }

    protected Map<String, Map<String, DataBaseInfo>> getMembersInfo(Context ctx, Map<String, List<String>> sourceNumbers) throws BOSException {
        int i;
        BgPeriodCollection colls;
        HashMap<String, Map<String, DataBaseInfo>> membersInfo = new HashMap<String, Map<String, DataBaseInfo>>();
        if (sourceNumbers.isEmpty()) {
            return membersInfo;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        view.getSorter().add(new SorterItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        if (sourceNumbers.containsKey(DimensionConstants.DEF_PERIOD_NUMBER)) {
            List<String> bePeriodNumbers = sourceNumbers.get(DimensionConstants.DEF_PERIOD_NUMBER);
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(bePeriodNumbers), CompareType.INCLUDE));
            colls = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(view);
            if (colls != null) {
                membersInfo.put(DimensionConstants.DEF_PERIOD_NUMBER, new HashMap());
                for (i = 0; i < colls.size(); ++i) {
                    ((Map)membersInfo.get(DimensionConstants.DEF_PERIOD_NUMBER)).put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        if (sourceNumbers.containsKey(DimensionConstants.DEF_SCENARIO_NUMBER)) {
            List<String> bgScenarioNumbers = sourceNumbers.get(DimensionConstants.DEF_SCENARIO_NUMBER);
            view.getFilter().getFilterItems().clear();
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(bgScenarioNumbers), CompareType.INCLUDE));
            colls = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection(view);
            if (colls != null) {
                membersInfo.put(DimensionConstants.DEF_SCENARIO_NUMBER, new HashMap());
                for (i = 0; i < colls.size(); ++i) {
                    ((Map)membersInfo.get(DimensionConstants.DEF_SCENARIO_NUMBER)).put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        if (sourceNumbers.containsKey(DimensionConstants.DEF_ELEMENT_NUMBER)) {
            List<String> bgElementNumbers = sourceNumbers.get(DimensionConstants.DEF_ELEMENT_NUMBER);
            view.getFilter().getFilterItems().clear();
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(bgElementNumbers), CompareType.INCLUDE));
            colls = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection(view);
            if (colls != null) {
                membersInfo.put(DimensionConstants.DEF_ELEMENT_NUMBER, new HashMap());
                for (i = 0; i < colls.size(); ++i) {
                    ((Map)membersInfo.get(DimensionConstants.DEF_ELEMENT_NUMBER)).put(colls.get(i).getNumber(), colls.get(i));
                }
            }
        }
        return membersInfo;
    }

    protected Map<String, BgOrgUnitInfo> queryBgOrgUnit(Context ctx, BgDecomposeResult result) throws BOSException {
        HashMap<String, BgOrgUnitInfo> mp = new HashMap<String, BgOrgUnitInfo>();
        if (result.getErrors().isEmpty()) {
            return mp;
        }
        HashSet<String> orgIds = new HashSet<String>();
        for (int index = 0; index < result.getErrors().size(); ++index) {
            if (StringUtils.isEmpty((String)result.getErrors().get(index).getOrgUnitId())) continue;
            orgIds.add(result.getErrors().get(index).getOrgUnitId());
        }
        if (!orgIds.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("orgUnitID");
            sic.add("isVirtual");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            view.getSorter().add(new SorterItemInfo("number"));
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("orgUnitID", orgIds, CompareType.INCLUDE));
            BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
            if (colls != null) {
                for (int index = 0; index < colls.size(); ++index) {
                    mp.put(colls.get(index).getOrgUnitID(), colls.get(index));
                }
            }
        }
        return mp;
    }

    protected void sort(List<BgDecomposeError> errors) {
        if (errors.isEmpty()) {
            return;
        }
        Collections.sort(errors, new Comparator<BgDecomposeError>(){

            @Override
            public int compare(BgDecomposeError m1, BgDecomposeError m2) {
                int g;
                int a = m1.getBgOrgUnitNumber().compareTo(m2.getBgOrgUnitNumber());
                int b = m1.getBgScenarioNumber().compareTo(m2.getBgScenarioNumber());
                int c = m1.getCurrencyNumber().compareTo(m2.getCurrencyNumber());
                int d = m1.getBgElementNumber().compareTo(m2.getBgElementNumber());
                int e = m1.getBgPeriodNumber().compareTo(m2.getBgPeriodNumber());
                int f = m1.getBgAccountNumber().compareTo(m2.getBgAccountNumber());
                int n = g = m1.getBgMemberNumber() == null ? 0 : m1.getBgMemberNumber().compareTo(m2.getBgMemberNumber());
                if (a == 0) {
                    if (b == 0) {
                        if (c == 0) {
                            if (d == 0) {
                                if (e == 0) {
                                    if (f == 0) {
                                        return g;
                                    }
                                    return f;
                                }
                                return e;
                            }
                            return d;
                        }
                        return c;
                    }
                    return b;
                }
                return a;
            }
        });
    }

    @Override
    protected BgDecomposeResult _processResult(Context ctx, BgDecomposeResult result) throws BOSException, EASBizException {
        this.processResultErrors(ctx, result);
        return result;
    }

    protected Set<String> getDecomposeSheetNames(BgDecomposeParameter bgDecParameter) {
        SheetInfo[] sheetInfos = bgDecParameter.getSheetInfos();
        HashSet<String> sheetNames = new HashSet<String>();
        if (sheetInfos != null && sheetInfos.length > 0) {
            for (int i = 0; i < sheetInfos.length; ++i) {
                sheetNames.add(sheetInfos[i].getSheetName());
            }
        }
        return sheetNames;
    }
}

