/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.ICostCenterOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgRelationDataFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.utils.BgCheckDimensionRelationDataUtils;
import com.kingdee.eas.ma.mbg.utils.BgData;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class BgRelationDataFacadeControllerBean
extends AbstractBgRelationDataFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgRelationDataFacadeControllerBean");

    @Override
    protected Object _queryNotRelationCreateData(Context ctx, List formIds, List orgs) throws BOSException, EASBizException {
        if (formIds == null || formIds.isEmpty()) {
            return null;
        }
        try {
            BgCheckDimensionRelationDataUtils utils = new BgCheckDimensionRelationDataUtils(ctx, BOSUuid.read((String)formIds.get(0).toString()), orgs);
            return utils.queryDataOfNotRelationCreate();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected Object _deleteData(Context ctx, List data, String cubeName) throws BOSException, EASBizException {
        if (data == null || data.isEmpty()) {
            return null;
        }
        String tableName = null;
        String tableEntryName = null;
        Connection conn = null;
        Statement pmst = null;
        Statement pmstEntry = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            int batch = 50;
            int count = 0;
            for (int index = 0; index < data.size(); ++index) {
                BgData info = (BgData)data.get(index);
                if (StringUtils.isEmpty(tableName)) {
                    tableName = info.getTableName();
                    pmst = conn.prepareStatement("DELETE FROM " + tableName + " WHERE FID=? ");
                }
                if (StringUtils.isEmpty(tableEntryName)) {
                    tableEntryName = BgCubeUtils.getBudgetEntryCubeName(tableName);
                    pmstEntry = conn.prepareStatement("DELETE FROM " + tableEntryName + " WHERE FDATAID=?");
                }
                if (pmst == null || pmstEntry == null) continue;
                pmst.setString(1, info.getFid());
                pmstEntry.setString(1, info.getFid());
                pmst.addBatch();
                pmstEntry.addBatch();
                if (++count < batch) continue;
                pmstEntry.executeBatch();
                pmst.executeBatch();
                count = 0;
            }
            if (count > 0 && pmst != null && pmstEntry != null) {
                pmstEntry.executeBatch();
                pmst.executeBatch();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(pmstEntry);
            SQLUtils.cleanup(pmst, (Connection)conn);
        }
        return null;
    }

    @Override
    protected Object _queryOrgColls(Context ctx, String formID) throws BOSException, EASBizException {
        CostCenterOrgUnitCollection costCenterOrgUnitCollection;
        HashSet<String> ids;
        PreparedStatement pmst;
        ResultSet rst;
        Connection conn;
        block7: {
            if (StringUtils.isEmpty((String)formID)) {
                return null;
            }
            BgFormInfo info = BgViewServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)formID), false);
            conn = BgDBUtils.getConnection((Context)ctx);
            StringBuffer sql = new StringBuffer();
            sql.append("select t.FID from T_ORG_CostCenter t join T_MBG_BgScheme s on t.FID = s.FOrgUnitID where s.FID = ? order by t.FLongNumber");
            rst = null;
            pmst = null;
            pmst = conn.prepareStatement(sql.toString());
            pmst.setString(1, info.getBgScheme().getId().toString());
            rst = pmst.executeQuery();
            ids = new HashSet<String>();
            while (rst.next()) {
                ids.add(rst.getString("FID"));
            }
            if (!ids.isEmpty()) break block7;
            Object var9_10 = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pmst, (Connection)conn);
            return var9_10;
        }
        try {
            ICostCenterOrgUnit iCostCenterOrgUnit = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx);
            EntityViewInfo view = new EntityViewInfo();
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("name");
            sic.add("number");
            sic.add("longNumber");
            sic.add("isLeaf");
            sic.add("level");
            view.setSelector(sic);
            SorterItemCollection so = new SorterItemCollection();
            SorterItemInfo sort = new SorterItemInfo("longNumber");
            sort.setSortType(SortType.ASCEND);
            so.add(sort);
            view.setSorter(so);
            costCenterOrgUnitCollection = iCostCenterOrgUnit.getCostCenterOrgUnitCollection(view);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pmst, (Connection)conn);
        return costCenterOrgUnitCollection;
    }

    @Override
    protected String _querySchemCube(Context ctx, String ID) throws BOSException, EASBizException {
        try {
            return BgCubeUtils.getBgDataTableNameByFormId(ctx, ID);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }
}

