/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.budget.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.BgRollRuleCollection;
import com.kingdee.eas.ma.mbg.BgRollRuleFactory;
import com.kingdee.eas.ma.mbg.BgRollRuleInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgRollRuleControllerBean;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgRollRuleControllerBean
extends AbstractBgRollRuleControllerBean {
    private static final long serialVersionUID = 7410286669460993865L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgRollRuleControllerBean");

    @Override
    public Map batchDelete(Context ctx, List ids) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        HashSet success = new HashSet();
        HashSet<String> refTemlate = new HashSet<String>();
        HashSet<String> mutex = new HashSet<String>();
        HashSet<String> orgDiff = new HashSet<String>();
        result.put("DELETE_OVER", success);
        result.put("DELETE_CANT", refTemlate);
        result.put("Mutex", mutex);
        result.put("orgDiff", orgDiff);
        try {
            String id;
            Set<String> lockSet = MBgCheckHelper.requestMutex(ctx, ids, true);
            Iterator it = ids.iterator();
            while (it.hasNext()) {
                id = (String)it.next();
                if (lockSet == null || !lockSet.contains(id)) continue;
                it.remove();
                mutex.add(id);
            }
            if (ids != null && !ids.isEmpty()) {
                try {
                    MBgCheckHelper.releaseMutex(ctx, ids);
                }
                catch (Exception e) {
                    logger.error((Object)("\u91ca\u653e\u4e92\u65a5\u9501   batchObjectUpdateLockService error : " + e.getMessage()));
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("orgUnit.id");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(ids), CompareType.INCLUDE));
            evi.setFilter(filter);
            HashMap<String, BgRollRuleInfo> data = new HashMap<String, BgRollRuleInfo>();
            BgRollRuleCollection col = BgRollRuleFactory.getLocalInstance(ctx).getBgRollRuleCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    data.put(col.get(i).getId().toString(), col.get(i));
                }
            }
            OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
            Iterator it2 = ids.iterator();
            while (it2.hasNext()) {
                id = (String)it2.next();
                if (currentOrgUnit.getId().equals((Object)((BgRollRuleInfo)data.get(id)).getOrgUnit().getId())) continue;
                it2.remove();
                orgDiff.add(id);
            }
            String sql = "select distinct FBgRollRuleID from T_MBG_BgTemplate where FBgRollRuleID is not null";
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                id = rs.getString(1);
                if (!ids.contains(id)) continue;
                ids.remove(id);
                refTemlate.add(id);
            }
            if (!ids.isEmpty()) {
                IObjectPK[] pkArray = new IObjectPK[ids.size()];
                for (int i = 0; i < pkArray.length; ++i) {
                    pkArray[i] = new ObjectUuidPK(ids.get(i).toString());
                }
                this.deleteBatchData(ctx, pkArray);
                success.addAll(ids);
            }
        }
        catch (Exception e) {
            logger.error((Object)"batchDelete", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (pk == null) {
            return;
        }
        MBgCheckHelper.releaseMutex(ctx, pk.toString());
        String sql = "select FID from T_MBG_BgTemplate where FBgRollRuleID = ?";
        try {
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            if (rs.next()) {
                throw new BgRollException(BgRollException.REFTEMPLATE);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)pk.toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)currentOrgUnit.getId().toString(), CompareType.EQUALS));
        if (!BgRollRuleFactory.getLocalInstance(ctx).exists(filter)) {
            throw new BgRollException(BgRollException.ORGDIFF);
        }
        super._delete(ctx, pk);
    }

    @Override
    protected boolean _checkExistsBgForm(Context ctx, String rollRuleId) throws BOSException, EASBizException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (rollRuleId == null) {
                return false;
            }
            String sql = "SELECT TOP 1 FORM.FID FROM T_MBG_BGFORM FORM INNER JOIN T_MBG_BGTEMPLATE TMPT ON FORM.FBGTEMPLATEID = TMPT.FID WHERE TMPT.FBGROLLRULEID = ?";
            rs = null;
            try {
                rs = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{rollRuleId});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"checkExistsBgForm :", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }
}

