/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortFactory;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberFactory;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.DimGroupFactory;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryCollection;
import com.kingdee.eas.ma.mbg.DimRelashipGroupEntryFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupFactory;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.MbgPermissionCollection;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MemberTypeEnum;
import com.kingdee.eas.ma.mbg.RefBgPropertySortFactory;
import com.kingdee.eas.ma.mbg.RefBgPropertySortInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.face.ICubeManager;
import com.kingdee.eas.ma.mbg.cube.impl.CubeManager;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.eas.ma.mbg.utils.BgOrgUnitUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSchemeControllerBean
extends AbstractBgSchemeControllerBean {
    private static final long serialVersionUID = 5045512922908780691L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeControllerBean");
    private static int DEF_MERGEDIM_SEQ = 99;

    @Override
    protected IObjectValue _getBaseValue(Context ctx, IObjectPK pk, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || pk == null) {
            return null;
        }
        BgSchemeInfo bgScheme = (BgSchemeInfo)this._getValue(ctx, pk, BgSchemeUtils.getBaseSelectors());
        return bgScheme;
    }

    @Override
    protected Set _getCollection(Context ctx, BOSUuid orgUnitID) throws BOSException, EASBizException {
        return this._getCollection(ctx, orgUnitID, true);
    }

    @Override
    protected Set _getCollection(Context ctx, BOSUuid orgUnitID, boolean hasFiling) throws BOSException, EASBizException {
        ArrayList<BOSUuid> orgUnitIds = new ArrayList<BOSUuid>();
        orgUnitIds.add(orgUnitID);
        return this._getCollection(ctx, orgUnitIds, hasFiling);
    }

    @Override
    protected Set _getCollection4SchemeList(Context ctx, String orgUnitId, boolean hasFiling) throws BOSException, EASBizException {
        return this.innerGetCollection4SchemeList(ctx, orgUnitId, hasFiling, true, null);
    }

    @Override
    protected Set _queryTargetBgSchemeIds(Context ctx, String orgUnitId, RptSrcTypeEnum bgSchemeType, boolean hasFilling) throws BOSException, EASBizException {
        return this.innerGetCollection4SchemeList(ctx, orgUnitId, hasFilling, true, bgSchemeType);
    }

    protected Set innerGetCollection4SchemeList(Context ctx, String orgUnitId, boolean hasFiling, boolean isContainSelf, RptSrcTypeEnum bgSchemeType) throws BOSException, EASBizException {
        HashSet<String> hashSet;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String viewId = null;
        try {
            conn = this.getConnection(ctx);
            HashMap thisAndParentOrgNumber = new HashMap();
            StringBuffer sql = new StringBuffer("Select FViewId, FNumber, FLongNumber FROM T_Mbg_BgOrgUnit Where ForgUnitId = ?");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                viewId = rst.getString("FViewId");
                if (!thisAndParentOrgNumber.containsKey(viewId)) {
                    thisAndParentOrgNumber.put(viewId, new HashSet());
                }
                ((Set)thisAndParentOrgNumber.get(viewId)).addAll(Arrays.asList((Object[])rst.getString("FLongNumber").split("!")));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            sql.setLength(0);
            HashSet<String> viewCreateOrgIds = new HashSet<String>();
            sql.append("SELECT FOrgUnitId FROM T_mbg_bgorgView where fid in (Select FViewId FROM T_Mbg_BgOrgUnit Where ForgUnitId = ?)");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                viewCreateOrgIds.add(rst.getString("FOrgUnitId"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            if (!isContainSelf) {
                sql.setLength(0);
                sql.append("Select FViewId, FNumber FROM T_MBg_BgOrgUnit Where FParentId IS NULL AND FViewId IN(");
                MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                List paramList = MbgSqlHelper.getBatchParams(null, (Object[])thisAndParentOrgNumber.keySet().toArray(), (int)50);
                pstmt = conn.prepareStatement(sql.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        viewId = rst.getString("FViewId");
                        ((Set)thisAndParentOrgNumber.get(viewId)).add(rst.getString("FNumber"));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            }
            HashSet<String> bgSchemeIds = new HashSet<String>();
            Set pNumbers = new HashSet();
            sql.setLength(0);
            sql.append("Select bgScheme.FID, settMember.FMemberId, org.FNumber , bgScheme.FOrgUnitId bgScheme_OrgUnitId FROM T_MBg_BgScheme bgScheme Inner Join T_Org_CostCenter org On bgScheme.FOrgUnitId = org.FID");
            sql.append(" Inner Join T_MBG_BgDimSettings sett On sett.FBgSchemeId = bgScheme.FID");
            sql.append(" Inner Join T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID");
            if (bgSchemeType != null) {
                sql.append(" Inner Join T_MBG_BgSchemeType ty on ty.FID = bgScheme.FBgSchemeTypeID ");
            }
            sql.append(" Where sett.FDimNumber = '").append(DimensionConstants.DEF_ORGUNIT_NUMBER).append("'");
            sql.append(" And settMember.FMemberId IN (Select FViewId FROM T_Mbg_BgOrgUnit Where FOrgUnitId = ?) ");
            if (!hasFiling) {
                sql.append(" AND FIsFiling = 0 ");
            }
            if (bgSchemeType != null) {
                sql.append(" AND ty.FSchemeType = " + bgSchemeType.getValue() + "");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, orgUnitId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String bgSchemeId = rst.getString("FID");
                String schemeOrgUnitId = rst.getString("bgScheme_OrgUnitId");
                if (!isContainSelf && orgUnitId.equals(schemeOrgUnitId)) continue;
                viewId = rst.getString("FMemberId");
                String orgNumber = rst.getString("FNumber");
                pNumbers = (Set)thisAndParentOrgNumber.get(viewId);
                if (!pNumbers.contains(orgNumber) && !viewCreateOrgIds.contains(schemeOrgUnitId)) continue;
                bgSchemeIds.add(bgSchemeId);
            }
            hashSet = bgSchemeIds;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hashSet;
    }

    @Override
    protected Set _getCollection4SchemeList0(Context ctx, Set orgUnitIds, boolean hasFiling) throws BOSException, EASBizException {
        if (ctx == null || orgUnitIds == null) {
            return new HashSet();
        }
        Set result = null;
        Set temp = null;
        for (String orgUnitId : orgUnitIds) {
            temp = this._getCollection4SchemeList(ctx, orgUnitId, hasFiling);
            if (result == null) {
                result = temp;
            } else {
                if (temp == null) {
                    return null;
                }
                if (!result.isEmpty()) {
                    result.retainAll(temp);
                }
            }
            if (!result.isEmpty()) continue;
            break;
        }
        return result;
    }

    private Set<String> getBgSchemeByCreateOrgUnit(Context ctx, boolean hasFiling, Set<String> orgUnitIds, String orgUnitId) throws BOSException {
        HashSet<String> viewIDs = new HashSet<String>();
        HashSet<String> settingsIDs = new HashSet<String>();
        HashSet<String> bgSchemeIDs = new HashSet<String>();
        EntityViewInfo orgView = new EntityViewInfo();
        FilterInfo orgFilter = new FilterInfo();
        orgView.setFilter(orgFilter);
        SelectorItemCollection orgSeletor = new SelectorItemCollection();
        orgSeletor.add(new SelectorItemInfo("viewid"));
        orgView.setSelector(orgSeletor);
        orgFilter.getFilterItems().add(new FilterItemInfo("orgUnitID", orgUnitIds, CompareType.INCLUDE));
        CoreBaseCollection ocoll = BgOrgUnitFactory.getLocalInstance(ctx).getCollection(orgView);
        for (int i = 0; i < ocoll.size(); ++i) {
            viewIDs.add(((BgOrgUnitInfo)ocoll.get(i)).getViewID());
        }
        EntityViewInfo memberView = new EntityViewInfo();
        FilterInfo memberFilter = new FilterInfo();
        memberView.setFilter(memberFilter);
        SelectorItemCollection memberSeletor = new SelectorItemCollection();
        memberSeletor.add(new SelectorItemInfo("bgDimSettings.id"));
        memberView.setSelector(memberSeletor);
        memberFilter.getFilterItems().add(new FilterItemInfo("memberID", viewIDs, CompareType.INCLUDE));
        CoreBaseCollection mcoll = BgDimSettingsMemberFactory.getLocalInstance(ctx).getCollection(memberView);
        for (int i = 0; i < mcoll.size(); ++i) {
            settingsIDs.add(((BgDimSettingsMemberInfo)mcoll.get(i)).getBgDimSettings().getId().toString());
        }
        EntityViewInfo settingsView = new EntityViewInfo();
        FilterInfo settingsFilter = new FilterInfo();
        settingsView.setFilter(settingsFilter);
        SelectorItemCollection settingsSeletor = new SelectorItemCollection();
        settingsSeletor.add(new SelectorItemInfo("bgScheme.id"));
        settingsView.setSelector(settingsSeletor);
        settingsFilter.getFilterItems().add(new FilterItemInfo("id", settingsIDs, CompareType.INCLUDE));
        CoreBaseCollection scoll = BgDimSettingsFactory.getLocalInstance(ctx).getCollection(settingsView);
        for (int i = 0; i < scoll.size(); ++i) {
            bgSchemeIDs.add(((BgDimSettingsInfo)scoll.get(i)).getBgScheme().getId().toString());
        }
        HashSet<String> billIds = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer maskString = new StringBuffer();
        if (orgUnitIds == null) {
            orgUnitIds = new HashSet<String>();
        }
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            orgUnitIds.add(orgUnitId);
        }
        int index = 0;
        if (orgUnitIds != null && !orgUnitIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgUnitIds, CompareType.INCLUDE));
            maskString.append("#" + index++);
        }
        if (!StringUtils.isEmpty((String)orgUnitId)) {
            filter.getFilterItems().add(new FilterItemInfo("id", bgSchemeIDs, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
            if (maskString.length() != 0) {
                maskString.append(" AND");
            }
            maskString.append(" (#" + index++ + " OR #" + index++ + ")");
        }
        if (!hasFiling) {
            filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)Boolean.FALSE, CompareType.EQUALS));
            if (maskString.length() != 0) {
                maskString.append(" AND");
            }
            maskString.append(" #" + index++);
        }
        filter.setMaskString(maskString.toString());
        if (filter.getFilterItems().isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"000000000000000000000000000=", CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        BgSchemeCollection schColls = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        if (schColls != null) {
            int in = schColls.size();
            for (int i = 0; i < in; ++i) {
                billIds.add(schColls.get(i).getId().toString());
            }
        }
        return billIds;
    }

    private Set<String> getParentBgOrgUnit(Context ctx, String orgUnitId, boolean isInBgScheme) throws BOSException {
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashMap<String, Set<String>> bgOrgUnitsView = new HashMap<String, Set<String>>();
        HashMap bgOrgUnitsViewTree = new HashMap();
        HashMap<String, BgOrgUnitInfo> viewBgOrgUnitInfo = new HashMap<String, BgOrgUnitInfo>();
        Set<String> orgViewIDs = this.getOrgViewIDs(ctx, orgUnitId, viewBgOrgUnitInfo, bgOrgUnitsView, isInBgScheme);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", orgViewIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (bgOrgUnitCollection != null && bgOrgUnitCollection.size() > 0) {
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
                String viewID = bgOrgUnitInfo.getViewID();
                if (bgOrgUnitsViewTree.containsKey(viewID)) {
                    ((List)bgOrgUnitsViewTree.get(viewID)).add(bgOrgUnitInfo);
                    continue;
                }
                ArrayList<BgOrgUnitInfo> list = new ArrayList<BgOrgUnitInfo>();
                list.add(bgOrgUnitInfo);
                bgOrgUnitsViewTree.put(viewID, list);
            }
        }
        for (Map.Entry entry : bgOrgUnitsViewTree.entrySet()) {
            List value = (List)entry.getValue();
            for (BgOrgUnitInfo bgOrgUnitInfo : value) {
                String number = bgOrgUnitInfo.getNumber();
                if (!((Set)bgOrgUnitsView.get(entry.getKey())).contains(number)) continue;
                orgUnitIds.add(bgOrgUnitInfo.getOrgUnitID().toString());
            }
        }
        return orgUnitIds;
    }

    private Set<String> getChildrenBgOrgUnit(Context ctx, String orgUnitId) throws BOSException {
        HashSet<String> orgUnitIds = new HashSet<String>();
        HashMap<String, BgOrgUnitInfo> viewBgOrgUnitInfo = new HashMap<String, BgOrgUnitInfo>();
        HashMap<String, Set<String>> bgOrgUnitsView = new HashMap<String, Set<String>>();
        HashMap bgOrgUnitsViewTree = new HashMap();
        Set<String> orgViewIDs = this.getOrgViewIDs(ctx, orgUnitId, viewBgOrgUnitInfo, bgOrgUnitsView, false);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("viewID", orgViewIDs, CompareType.INCLUDE));
        view.setFilter(filter);
        BgOrgUnitCollection bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (bgOrgUnitCollection != null && bgOrgUnitCollection.size() > 0) {
            for (int i = 0; i < bgOrgUnitCollection.size(); ++i) {
                BgOrgUnitInfo bgOrgUnitInfo = bgOrgUnitCollection.get(i);
                String viewID = bgOrgUnitInfo.getViewID();
                if (bgOrgUnitsViewTree.containsKey(viewID)) {
                    ((List)bgOrgUnitsViewTree.get(viewID)).add(bgOrgUnitInfo);
                    continue;
                }
                ArrayList<BgOrgUnitInfo> list = new ArrayList<BgOrgUnitInfo>();
                list.add(bgOrgUnitInfo);
                bgOrgUnitsViewTree.put(viewID, list);
            }
        }
        for (Map.Entry entry : bgOrgUnitsViewTree.entrySet()) {
            List value = (List)entry.getValue();
            for (BgOrgUnitInfo bgOrgUnitInfo : value) {
                String longNumber = bgOrgUnitInfo.getLongNumber();
                if (!longNumber.startsWith(((BgOrgUnitInfo)viewBgOrgUnitInfo.get(entry.getKey())).getLongNumber() + BgBaseConstants.SEP_ONE_STR)) continue;
                orgUnitIds.add(bgOrgUnitInfo.getOrgUnitID().toString());
            }
        }
        return orgUnitIds;
    }

    private Set<String> getImmediateFamilyBgOrgUnits(Context ctx, String orgUnitId) throws BOSException {
        Set<String> parentBgOrgUnits = this.getParentBgOrgUnit(ctx, orgUnitId, false);
        Set<String> childrenBgOrgUnits = this.getChildrenBgOrgUnit(ctx, orgUnitId);
        parentBgOrgUnits.addAll(childrenBgOrgUnits);
        return parentBgOrgUnits;
    }

    private Set<String> getOrgViewIDs(Context ctx, String orgUnitId, Map<String, BgOrgUnitInfo> viewBgOrgUnitInfo, Map<String, Set<String>> bgOrgUnitsView, boolean isInBgScheme) throws BOSException {
        HashSet<String> orgViewIDs = new HashSet<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("orgUnitID", (Object)orgUnitId, CompareType.EQUALS));
        if (isInBgScheme) {
            filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)"Select fmemberid  FROM t_mbg_bgdimsettingsmember", CompareType.INNER));
        }
        view.setFilter(filter);
        BgOrgUnitCollection _bgOrgUnitCollection = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (_bgOrgUnitCollection != null) {
            String[] numbers = null;
            HashSet<String> set = null;
            for (int i = 0; i < _bgOrgUnitCollection.size(); ++i) {
                BgOrgUnitInfo bgOrgUnitInfo = _bgOrgUnitCollection.get(i);
                String longNumber = bgOrgUnitInfo.getLongNumber();
                numbers = longNumber.split("!");
                set = new HashSet<String>();
                if (numbers != null) {
                    for (int j = 0; j < numbers.length; ++j) {
                        set.add(numbers[j]);
                    }
                    if (!bgOrgUnitsView.containsKey(bgOrgUnitInfo.getViewID())) {
                        bgOrgUnitsView.put(bgOrgUnitInfo.getViewID(), set);
                    } else {
                        bgOrgUnitsView.get(bgOrgUnitInfo.getViewID()).addAll(set);
                    }
                }
                orgViewIDs.add(bgOrgUnitInfo.getViewID());
                viewBgOrgUnitInfo.put(bgOrgUnitInfo.getViewID(), bgOrgUnitInfo);
            }
        }
        return orgViewIDs;
    }

    @Override
    protected Set _getCollection(Context ctx, List orgUnitIds, boolean hasFiling) throws BOSException, EASBizException {
        HashSet<BOSUuid> billIds = new HashSet<BOSUuid>();
        if (ctx == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            return billIds;
        }
        HashSet<String> bgOrgUnitIds = new HashSet<String>();
        for (int i = 0; i < orgUnitIds.size(); ++i) {
            bgOrgUnitIds.addAll(this.getParentBgOrgUnit(ctx, orgUnitIds.get(i).toString(), true));
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (!bgOrgUnitIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", bgOrgUnitIds, CompareType.INCLUDE));
        }
        if (!hasFiling) {
            filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("id"));
        BgSchemeCollection schColls = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        if (schColls != null) {
            int in = schColls.size();
            for (int i = 0; i < in; ++i) {
                billIds.add(schColls.get(i).getId());
            }
        }
        return billIds;
    }

    @Override
    protected Set _queryShowScheme(Context ctx, BOSUuid orgUnitId) throws BOSException, EASBizException {
        HashSet orgUnitIds = new HashSet();
        if (ctx == null || orgUnitId == null) {
            return orgUnitIds;
        }
        return this.getParentBgOrgUnit(ctx, orgUnitId.toString(), true);
    }

    @Override
    protected Set _queryShowScheme(Context ctx, BOSUuid[] orgUnitIds) throws BOSException, EASBizException {
        HashSet<String> returnSet = new HashSet<String>();
        HashSet allSet = new HashSet();
        if (ctx == null || orgUnitIds == null || orgUnitIds.length == 0) {
            return returnSet;
        }
        ArrayList<Set> list = new ArrayList<Set>();
        for (int i = 0; i < orgUnitIds.length; ++i) {
            Set showScheme = this._queryShowScheme(ctx, orgUnitIds[i]);
            allSet.addAll(showScheme);
            list.add(showScheme);
        }
        for (String string : allSet) {
            Set set2;
            int count = 0;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (set2 = (Set)iterator.next()).contains(string)) {
                ++count;
            }
            if (count != list.size()) continue;
            returnSet.add(string);
        }
        return returnSet;
    }

    @Override
    protected Set _queryCommonParentOrgUnit(Context ctx, BOSUuid[] orgUnitIds) throws BOSException, EASBizException {
        return this._queryShowScheme(ctx, orgUnitIds);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgSchemeInfo info = (BgSchemeInfo)model;
        boolean isSubmited = this._exists(ctx, (IObjectPK)new ObjectUuidPK(info.getId()));
        IObjectPK pk = super._submit(ctx, model);
        this.dealRefBgPropertySort(ctx, info, isSubmited);
        return pk;
    }

    private void dealRefBgPropertySort(Context ctx, BgSchemeInfo info, boolean isSubmited) throws EASBizException, BOSException {
        Map sortColl = (Map)info.get("REF_BGPROPERTYSORT");
        if (isSubmited) {
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("bgScheme", (Object)info.getId().toString(), CompareType.EQUALS));
            RefBgPropertySortFactory.getLocalInstance(ctx).delete(filterInfo);
        }
        if (sortColl == null || sortColl.isEmpty()) {
            return;
        }
        Collection values = sortColl.values();
        CoreBaseCollection result = new CoreBaseCollection();
        if (null != values) {
            for (BgPropertySortCollection col : values) {
                int jn = col.size();
                for (int j = 0; j < jn; ++j) {
                    BgPropertySortInfo sortInfo = col.get(j);
                    RefBgPropertySortInfo refInfo = new RefBgPropertySortInfo();
                    refInfo.setBgScheme(info);
                    boolean exists = BgPropertySortFactory.getLocalInstance((Context)ctx).exists((IObjectPK)new ObjectUuidPK(sortInfo.getId()));
                    if (exists) {
                        refInfo.setBgPropertySort(sortInfo);
                    }
                    result.add((CoreBaseInfo)refInfo);
                }
            }
        }
        if (!result.isEmpty()) {
            RefBgPropertySortFactory.getLocalInstance(ctx).addnew(result);
        }
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgCubeUtils.checkTable(ctx);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        this.checkBgSchemeInfo(ctx, bgSchemeInfo);
        CalendarHelper helper = new CalendarHelper();
        bgSchemeInfo.setDateFrom(helper.getStartDate(bgSchemeInfo.getDateFrom()));
        bgSchemeInfo.setDateTo(helper.getBeoverDate(bgSchemeInfo.getDateTo()));
        this.createSchemeRefDimInfo(ctx, bgSchemeInfo);
        super._addnew(ctx, pk, model);
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgCubeUtils.checkTable(ctx);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        if (StringUtils.isEmpty((String)bgSchemeInfo.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)bgSchemeInfo, (String)bgSchemeInfo.getOrgUnit().getId().toString());
            if (StringUtils.isEmpty((String)bgSchemeInfo.getNumber())) {
                bgSchemeInfo.setNumber("BgControlScheme-" + System.currentTimeMillis());
            }
        }
        this.checkBgSchemeInfo(ctx, bgSchemeInfo);
        CalendarHelper helper = new CalendarHelper();
        bgSchemeInfo.setDateFrom(helper.getStartDate(bgSchemeInfo.getDateFrom()));
        bgSchemeInfo.setDateTo(helper.getBeoverDate(bgSchemeInfo.getDateTo()));
        this.createSchemeRefDimInfo(ctx, bgSchemeInfo);
        IObjectPK pk = super._addnew(ctx, model);
        this.updateOrAddnewDimSettings(ctx, bgSchemeInfo);
        return pk;
    }

    private void createSchemeRefDimInfo(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null) {
            return;
        }
        List<String> dims = BgCubeUtils.getRefDims(ctx, bgSchemeInfo, true);
        try {
            bgSchemeInfo.setRefCube(CubeManager.getInstance().getCubeFacade().addnewCube(ctx, dims));
        }
        catch (Exception ex) {
            throw new BOSException((Throwable)ex);
        }
    }

    private void updateSchemeRefDimInfo(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null) {
            return;
        }
        BgSchemeInfo oldScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeInfo);
        if (oldScheme == null) {
            return;
        }
        List<String> newDims = null;
        List<String> oldDims = null;
        try {
            oldDims = BgCubeUtils.getRefDims(ctx, oldScheme, true);
            newDims = BgCubeUtils.getRefDims(ctx, bgSchemeInfo, true);
        }
        catch (Exception ex) {
            logger.error((Object)"updateSchemeRefDimInfo error", (Throwable)ex);
        }
        ICubeManager cubeManager = CubeManager.getInstance();
        try {
            cubeManager.getCubeFacade().updateCube(ctx, oldScheme.getRefCube(), newDims, oldDims);
            if (bgSchemeInfo.checkHasUnionDim()) {
                cubeManager.getCubeFacade().updateCFSCube(ctx, oldScheme.getRefCube(), bgSchemeInfo);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgCubeUtils.checkTable(ctx);
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)model;
        BgSchemeInfo tmpScheme = this.getBgSchemeInfo(ctx, "select id, refCube where id = '" + bgSchemeInfo.getId() + "'");
        boolean isCreated = false;
        if (StringUtils.isEmpty((String)tmpScheme.getRefCube())) {
            this.createSchemeRefDimInfo(ctx, bgSchemeInfo);
            isCreated = true;
        } else {
            this.updateSchemeRefDimInfo(ctx, bgSchemeInfo);
        }
        CalendarHelper helper = new CalendarHelper();
        bgSchemeInfo.setDateFrom(helper.getStartDate(bgSchemeInfo.getDateFrom()));
        bgSchemeInfo.setDateTo(helper.getBeoverDate(bgSchemeInfo.getDateTo()));
        if (!this.checkIsMergeScopeSettings(ctx, bgSchemeInfo)) {
            this.updateOrAddnewDimSettings(ctx, bgSchemeInfo);
        } else {
            this.updateOrAddMergeDim(ctx, bgSchemeInfo);
            this.updateOrAddMergeScope(ctx, bgSchemeInfo);
        }
        super._update(ctx, pk, model);
        if (isCreated && !StringUtils.isEmpty((String)tmpScheme.getRefCube())) {
            DbUtil.execute((Context)ctx, (String)"Update T_MBg_BgScheme Set FRefCube = ? Where FID = ?", (Object[])new Object[]{tmpScheme.getRefCube(), tmpScheme.getId().toString()});
        }
    }

    private void checkBgSchemeInfo(Context ctx, BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        String number = bgSchemeInfo.getNumber();
        if (!StringUtils.isEmpty((String)number)) {
            number = number.replaceAll(" ", "");
            bgSchemeInfo.setNumber(number);
        }
        String name = bgSchemeInfo.getName();
        String orgUnitId = bgSchemeInfo.getOrgUnit().getId().toString();
        if (this.checkDupNumber(ctx, number, "", orgUnitId)) {
            throw new BgSchemeException(BgSchemeException.NUMBERDUP);
        }
        if (this.checkDupName(ctx, name, "", orgUnitId)) {
            throw new EASBizException(EASBizException.CHECKNAMEDUP, (Object[])new String[]{name});
        }
    }

    private boolean checkDupName(Context ctx, String name, String id, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from T_MBG_BgScheme where fname_" + ctx.getLocale().toString() + " = ? and forgunitid = ? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, name);
                sm.setString(2, orgUnitId);
                if (!id.equals("")) {
                    sm.setString(3, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    private boolean checkDupNumber(Context ctx, String number, String id, String orgUnitId) throws BOSException, EASBizException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select fid from T_Mbg_bgscheme where fnumber=? ");
            if (!id.equals("")) {
                sql.append(" and fid!=?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                if (!id.equals("")) {
                    sm.setString(2, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    protected void _checkNameDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected boolean _checkReference(Context ctx, BOSUuid bgSchemeID) throws BOSException, EASBizException {
        boolean reference = false;
        if (ctx == null || bgSchemeID == null) {
            return reference;
        }
        String _bgSchemeId = bgSchemeID.toString();
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select count(t.FRootId) from T_MBG_BgTemplate t where t.FBgSchemeId = ? group by t.FRootId having count(t.FRootId) > 1", (Object[])new Object[]{_bgSchemeId});
            if (rst.next()) {
                reference = true;
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!reference) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"select top 1 FBgSchemeID from T_MBG_BgForm where FBgSchemeID = ?", (Object[])new Object[]{_bgSchemeId});
                if (rst.next()) {
                    reference = true;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return reference;
    }

    @Override
    protected boolean _checkTemplateAssignedInBgScheme(Context ctx, BOSUuid templateId, BOSUuid schemeId) throws BOSException, EASBizException {
        boolean assigned = false;
        if (schemeId == null || templateId == null) {
            return false;
        }
        Connection conn = null;
        IRowSet rst = null;
        String sql = "select count(fid) from T_MBG_BgTemplate where FBgSchemeID = ? AND FRootID = ?)";
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{schemeId.toString(), templateId.toString()});
            assigned = rst.next() ? rst.getInt(1) > 1 : false;
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return assigned;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BgSchemeInfo schemeInfo = this.getBgSchemeInfo(ctx, pk, this.getSelector());
        if (this.checkIsFormal(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYISFORMAL, new String[]{schemeInfo.getName()});
        }
        BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)schemeInfo, (String)schemeInfo.getOrgUnit().getId().toString(), (String)schemeInfo.getNumber());
        try {
            CubeManager.getInstance().getCubeFacade().dropCube(ctx, schemeInfo.getRefCube());
        }
        catch (EASBizException ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        super._delete(ctx, pk);
    }

    protected SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isFormal");
        sic.add("orgUnit.id");
        sic.add("refCube");
        return sic;
    }

    protected boolean checkIsFormal(Context ctx, BgSchemeInfo scheme) throws BOSException, EASBizException {
        return scheme.isIsFormal();
    }

    protected boolean checkIsFiling(Context ctx, BgSchemeInfo scheme) throws BOSException, EASBizException {
        return scheme.isIsFiling();
    }

    @Override
    protected void _checkFilling(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        if (this._exists(ctx, "where isFiling = 1 and id = '" + bgSchemeId + "'")) {
            throw new BgSchemeException(BgSchemeException.BGSCHEMEFILLED);
        }
    }

    protected boolean checkIsCreateOrg(Context ctx, BgSchemeInfo scheme, IObjectValue orgUnit) throws BOSException, EASBizException {
        return !scheme.getOrgUnit().getId().toString().equals(((FullOrgUnitInfo)orgUnit).getId().toString());
    }

    protected boolean checkDimRel(Context ctx, BgSchemeInfo scheme) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
        CoreBaseCollection coll = DimensionRelationshipGroupFactory.getLocalInstance(ctx).getCollection(view);
        return coll.size() > 0;
    }

    protected boolean checkBizCalc(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        if (bgScheme == null || bgScheme.getId() == null) {
            return false;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        return BizCalcFactory.getLocalInstance((Context)ctx).exists(filter);
    }

    protected boolean checkRefTemplate(Context ctx, BgSchemeInfo scheme) throws BOSException, EASBizException {
        if (scheme == null) {
            return true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
        CoreBaseCollection coll = BgTemplateFactory.getLocalInstance(ctx).getCollection(view);
        return coll.size() > 0;
    }

    protected boolean checkRefBgForm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean re = true;
        if (ctx == null || pk == null) {
            return re;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select top 1 FBgSchemeID from T_MBG_BgForm where FBgSchemeID = ?", (Object[])new Object[]{pk.toString()});
            re = rst.next();
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"checkBgScehemeRefBgForm Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return re;
    }

    protected boolean checkRefAssign(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        boolean re = true;
        if (ctx == null || pk == null) {
            return re;
        }
        Connection conn = null;
        IRowSet rst = null;
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)"select t.FOrgUnitID from T_MBG_BgTemplate t where t.FBgSchemeID = ? group by t.FOrgUnitID", (Object[])new Object[]{pk.toString()});
            while (rst.next()) {
                orgUnitIds.add(rst.getString("FOrgUnitID"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"checkBgScehemeRefBgForm Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        re = orgUnitIds.size() > 1;
        return re;
    }

    @Override
    protected IObjectCollection _getTemplateBySchemeToAddTem(Context ctx, String id) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("isAllowChange"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("rootId"));
        sic.add(new SelectorItemInfo("defaultMeasureUnit"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("creator.id"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.id"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("templateStatus"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        Vector<String> temId = new Vector<String>();
        BgTemplateInfo bgTemplateInfo = null;
        BgTemplateCollection templateColl = new BgTemplateCollection();
        IBgTemplate iBgTemplate = BgTemplateFactory.getLocalInstance(ctx);
        if (id == null) {
            return new BgTemplateCollection();
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select FID  from T_Mbg_BgTemplate where fbgschemeID= ?");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            strBuffer = null;
            while (rs.next()) {
                temId.add(rs.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        if (!temId.isEmpty()) {
            ArrayList<String> _tmpList = new ArrayList<String>();
            _tmpList.addAll(temId);
            try {
                connection = this.getConnection(ctx);
                StringBuffer strBuffer = new StringBuffer(1000);
                strBuffer.append("select fid  from T_Mbg_Bgtemplate where fID in (").append(MbgSqlHelper.getParamSizeString((int)temId.size())).append(")");
                strBuffer.append(" order by fnumber");
                ps = connection.prepareStatement(strBuffer.toString());
                MbgSqlHelper.setParams((PreparedStatement)ps, _tmpList);
                rs = ps.executeQuery();
                strBuffer = null;
                while (rs.next()) {
                    bgTemplateInfo = iBgTemplate.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(rs.getString("fid")), sic);
                    templateColl.add(bgTemplateInfo);
                }
            }
            catch (SQLException e) {
                throw new SQLDataException(e);
            }
            finally {
                SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
            }
        }
        return templateColl;
    }

    @Override
    protected IObjectCollection _getTemplate(Context ctx, String orgUnitID) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        BgTemplateInfo bgTemInfo = null;
        BgTemplateCollection coll = new BgTemplateCollection();
        try {
            String selectSql = "select a.fid fid,a.fname aname,a.fnumber number,b.fname_" + ctx.getLocale().getLanguage() + " fname, a.FBgTypeID bgType, c.FName_L2 bgTypeName, a.fcreateTime createtime, a.FFormType formType, a.FTemplateStatus from T_Mbg_bgtemplate a  , t_pm_user b , T_MBG_BgType c where ((c.fid = a.FBgTypeID) or a.FBgTypeID is null) and a.FTemplateStatus = ? and a.fcreatorid=b.fid and a.forgUnitid = ?";
            _tmpList.add(new Integer(0));
            _tmpList.add(orgUnitID);
            selectSql = selectSql + " order by a.fnumber";
            conn = super.getConnection(ctx);
            ps = conn.prepareStatement(selectSql);
            MbgSqlHelper.setParams((PreparedStatement)ps, _tmpList);
            rs = ps.executeQuery();
            while (rs.next()) {
                bgTemInfo = new BgTemplateInfo();
                bgTemInfo.setId(BOSUuid.read((String)rs.getString("fid")));
                bgTemInfo.setName(rs.getString("aname"));
                bgTemInfo.setNumber(rs.getString("number"));
                bgTemInfo.setFormType(BgTemFormTypeEnum.getEnum(rs.getInt("formType")));
                UserInfo creator = new UserInfo();
                creator.setName(rs.getString("fname"));
                bgTemInfo.setCreator(creator);
                bgTemInfo.setCreateTime(rs.getTimestamp("createTime"));
                if (rs.getString("bgType") != null) {
                    bgTemInfo.setBgType(new BgTypeInfo());
                    bgTemInfo.getBgType().setId(BOSUuid.read((String)rs.getString("bgType")));
                    bgTemInfo.getBgType().setName(rs.getString("bgTypeName"));
                }
                bgTemInfo.setTemplateStatus(BgTemplateStatusEnum.getEnum(rs.getInt("FTemplateStatus")));
                coll.add(bgTemInfo);
            }
        }
        catch (SQLException e) {
            try {
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
        return coll;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkIsUpdate(Context ctx, Map orgUnit) throws BOSException, EASBizException {
        if (orgUnit == null) return false;
        if (orgUnit.isEmpty()) {
            return false;
        }
        boolean re = false;
        Iterator iter = null;
        HashMap bgTemplateMap = new HashMap();
        Vector vct = null;
        String orgUnitId2222222 = null;
        String bgTemplateId2222222 = null;
        ArrayList<String> _tmpList1 = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select FID from T_Mbg_BgTemplate where FOrgUnitId in (");
        StringBuffer sqlFrootID = new StringBuffer("select FROOTID from T_Mbg_BgTemplate where ");
        boolean sqlFrootIDIsFirst = true;
        for (String orgUnitId2222222 : orgUnit.keySet()) {
            sql.append("?,");
            _tmpList1.add(orgUnitId2222222);
            vct = (Vector)orgUnit.get(orgUnitId2222222);
            int n = vct.size();
            for (int i = 0; i < n; ++i) {
                bgTemplateId2222222 = (String)vct.get(i);
                bgTemplateMap.put(bgTemplateId2222222, null);
            }
        }
        ArrayList<String> _tmpList = new ArrayList<String>();
        for (String bgTemplateId2222222 : bgTemplateMap.keySet()) {
            if (sqlFrootIDIsFirst) {
                sqlFrootID.append(" FID = ?");
                sqlFrootIDIsFirst = false;
            } else {
                sqlFrootID.append(" OR FID = ?");
            }
            sqlFrootID.append(" or FROOTID = ?");
            _tmpList.add(bgTemplateId2222222);
            _tmpList.add(bgTemplateId2222222);
        }
        bgTemplateMap = new HashMap();
        Connection conn1 = null;
        PreparedStatement pstmt1 = null;
        ResultSet rst1 = null;
        try {
            conn1 = this.getConnection(ctx);
            pstmt1 = conn1.prepareStatement(sqlFrootID.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt1, _tmpList);
            rst1 = pstmt1.executeQuery();
            while (rst1.next()) {
                bgTemplateMap.put(rst1.getString("FROOTID"), null);
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst1, pstmt1, (Connection)conn1);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst1, (Statement)pstmt1, (Connection)conn1);
        if (bgTemplateMap == null) return false;
        if (bgTemplateMap.isEmpty()) {
            return false;
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(") and FRootId in (");
        for (String bgTemplateId2222222 : bgTemplateMap.keySet()) {
            sql.append("?,");
            _tmpList1.add(bgTemplateId2222222);
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")");
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList1);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                re = true;
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex3) {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex3.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return re;
    }

    protected IObjectCollection _getSameSchemeByOrgNumbers(Context ctx, String[] orgNumbers) throws BOSException, EASBizException {
        if (orgNumbers == null || orgNumbers.length == 0) {
            return new BgSchemeCollection();
        }
        String sql = " select a.fid, a.fnumber, a.frootid from T_Mbg_bgscheme a , t_org_baseunit b  where a.forgunitid = b.fid and b.fnumber = ? ";
        sql = sql + " order by a.fnumber ";
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgNumbers[0].trim()});
        HashMap rootIdMap = new HashMap();
        HashMap numberMap = new HashMap();
        HashMap secondRootIdMap = new HashMap();
        HashMap secondNumberMap = new HashMap();
        HashMap tmpRootIdMap = new HashMap();
        HashMap tmpNumberMap = new HashMap();
        try {
            while (rs.next()) {
                numberMap.put(rs.getString(2), null);
                rootIdMap.put(rs.getString(3), null);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        for (int i = 1; i < orgNumbers.length; ++i) {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{orgNumbers[i].trim()});
            try {
                while (rs.next()) {
                    secondNumberMap.put(rs.getString(2), null);
                    secondRootIdMap.put(rs.getString(3), null);
                }
                for (String tmpNumger : secondNumberMap.keySet()) {
                    if (!numberMap.containsKey(tmpNumger)) continue;
                    tmpNumberMap.put(tmpNumger, null);
                }
                numberMap.clear();
                for (String tmpNumger : tmpNumberMap.keySet()) {
                    numberMap.put(tmpNumger, null);
                }
                secondNumberMap.clear();
                tmpNumberMap.clear();
                for (String tmpNumger : secondRootIdMap.keySet()) {
                    if (!rootIdMap.containsKey(tmpNumger)) continue;
                    tmpRootIdMap.put(tmpNumger, null);
                }
                rootIdMap.clear();
                for (String tmpNumger : tmpRootIdMap.keySet()) {
                    rootIdMap.put(tmpNumger, null);
                }
                secondRootIdMap.clear();
                tmpRootIdMap.clear();
                continue;
            }
            catch (SQLException e) {
                logger.error((Object)e);
                throw new BOSException((Throwable)e);
            }
        }
        String rootIds = "(''";
        Iterator it = rootIdMap.keySet().iterator();
        while (it.hasNext()) {
            rootIds = rootIds + ",'" + it.next() + "'";
        }
        rootIds = rootIds + " )";
        String numbers = "(''";
        Iterator it2 = numberMap.keySet().iterator();
        while (it2.hasNext()) {
            numbers = numbers + ",'" + it2.next() + "'";
        }
        numbers = numbers + " )";
        String orgStrs = "(''";
        for (int i = 0; i < orgNumbers.length; ++i) {
            orgStrs = orgStrs + ",'" + orgNumbers[i] + "'";
        }
        orgStrs = orgStrs + " )";
        String sql1 = "select aa.fid, aa.fnumber, aa.fname_" + ctx.getLocale() + ", aa.fisFormal, bb.FName_" + ctx.getLocale() + " from T_Mbg_bgscheme aa,t_org_baseunit bb  where aa.forgunitid = bb.fid  and aa.fnumber in  ( select distinct a.fnumber  \tfrom T_Mbg_bgscheme a , t_org_baseunit b  \twhere a.forgunitid = b.fid and b.fnumber in " + orgStrs + " \tand a.fnumber in " + numbers + "  \tand a.frootid in " + rootIds + " ) and bb.fnumber = ?";
        rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{orgNumbers[0].trim()});
        BgSchemeCollection bgSchemeCol = new BgSchemeCollection();
        try {
            while (rs.next()) {
                BgSchemeInfo bgScheme = new BgSchemeInfo();
                String id = rs.getString(1);
                String number = rs.getString(2);
                String name = rs.getString(3);
                int isFormal = rs.getInt(4);
                bgScheme.setId(BOSUuid.read((String)id));
                bgScheme.setNumber(number);
                bgScheme.setName(name);
                bgScheme.setIsFormal(isFormal == 1);
                bgScheme.setOrgUnit(new FullOrgUnitInfo());
                bgScheme.getOrgUnit().setName(rs.getString(5));
                bgSchemeCol.add(bgScheme);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return bgSchemeCol;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return null;
        }
        Connection conn = null;
        BgSchemeInfo bgSchemeInfo = null;
        try {
            conn = this.getConnection(ctx);
            bgSchemeInfo = BgSchemeControllerBean.getBgSchemeInfo(ctx, conn, bgSchemeId);
        }
        catch (BOSException ex) {
            throw ex;
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgSchemeInfo;
    }

    public static BgSchemeInfo getBgSchemeInfo(Context ctx, Connection conn, BOSUuid bgSchemeId) throws EASBizException, BOSException {
        ResultSet rst;
        PreparedStatement pstmt;
        BgSchemeInfo bgSchemeInfo;
        block6: {
            if (conn == null || bgSchemeId == null) {
                return null;
            }
            bgSchemeInfo = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FName_" + ctx.getLocale() + ", FOrgUnitID, FPeriod, FIsFormal, FDateFrom, FDateTo From T_Mbg_BgScheme where FID = ?");
            try {
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgSchemeId.toString());
                rst = pstmt.executeQuery();
                if (!rst.next()) break block6;
                bgSchemeInfo = new BgSchemeInfo();
                bgSchemeInfo.setId(BOSUuid.read((String)rst.getString("FID")));
                bgSchemeInfo.setNumber(rst.getString("FNumber"));
                bgSchemeInfo.setName(rst.getString("FName_" + ctx.getLocale()));
                bgSchemeInfo.setIsFormal(rst.getBoolean("FIsFormal"));
                bgSchemeInfo.setDateFrom(rst.getDate("FDateFrom"));
                bgSchemeInfo.setDateTo(rst.getDate("FDateTo"));
                if (rst.getString("FOrgUnitID") != null) {
                    bgSchemeInfo.setOrgUnit(new FullOrgUnitInfo());
                    bgSchemeInfo.getOrgUnit().setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                }
            }
            catch (SQLException ex) {
                try {
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, (Statement)pstmt);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeInfo;
    }

    @Override
    protected Set<String> _getRefOrgUnit(Context ctx, BOSUuid bgOrgViewId, boolean isLeaf) throws BOSException, EASBizException {
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (ctx == null || bgOrgViewId == null) {
            return orgUnitIds;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("Select FOrgUnitID From T_MBG_BgOrgUnit Where FViewID = ? and FIsLeaf = ?");
            pstmt.setString(1, bgOrgViewId.toString());
            pstmt.setInt(2, isLeaf ? 1 : 0);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                orgUnitIds.add(rst.getString("FOrgUnitID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return orgUnitIds;
    }

    @Override
    protected void _checkCanExecute(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        this._checkCanExecute(ctx, bgSchemeId, null);
    }

    protected void _checkCanExecute(Context ctx, BOSUuid bgSchemeId, Set<String> orgUnitIds) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("dateFrom");
        sic.add("dateTo");
        sic.add("bgSchemeType.id");
        BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)this._getValue(ctx, (IObjectPK)new ObjectUuidPK(bgSchemeId), sic);
        if (bgSchemeInfo == null) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        CalendarHelper helper = new CalendarHelper();
        String _schemeName = null;
        String _orgName = null;
        Date _begin = helper.getStartDate(bgSchemeInfo.getDateFrom());
        Date _end = helper.getBeoverDate(bgSchemeInfo.getDateTo());
        Date _tmpBegin = null;
        Date _tmpEnd = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            String sql = "select t.FName_" + ctx.getLocale() + ", t.FDateFrom, t.FDateTo, cc.FName_" + ctx.getLocale() + " from T_MBG_BgScheme t join T_ORG_CostCenter cc on t.FOrgUnitId = cc.FID where t.FIsFormal = 1 ";
            StringBuilder sb = new StringBuilder(sql);
            if (bgSchemeInfo.getBgSchemeType() == null || bgSchemeInfo.getBgSchemeType().getId() == null) {
                throw new BgSchemeException(BgSchemeException.NEEDBGSCHEMETYPE);
            }
            sb.append(" and t.fbgSchemeTypeid = '" + bgSchemeInfo.getBgSchemeType().getId().toString() + "'");
            sb.append(" and t.fid in( ");
            if (orgUnitIds != null) {
                orgUnitIds.add(BgBaseConstants.nullID);
            } else {
                orgUnitIds = new HashSet<String>();
                orgUnitIds.add(BgBaseConstants.nullID);
            }
            for (int i = 0; i < orgUnitIds.size(); ++i) {
                if (i == orgUnitIds.size() - 1) {
                    sb.append("? )");
                    continue;
                }
                sb.append("?,");
            }
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sb.toString(), (Object[])orgUnitIds.toArray());
            while (rst.next()) {
                _schemeName = rst.getString(1);
                _tmpBegin = helper.getStartDate((Date)rst.getDate("FDateFrom"));
                _tmpEnd = helper.getBeoverDate((Date)rst.getDate("FDateTo"));
                _orgName = rst.getString(4);
                if (!(_begin.compareTo(_tmpBegin) <= 0 && _end.compareTo(_tmpBegin) >= 0 || _begin.compareTo(_tmpEnd) <= 0 && _end.compareTo(_tmpEnd) >= 0 || _tmpBegin.compareTo(_begin) <= 0 && _tmpEnd.compareTo(_begin) >= 0) && (_tmpBegin.compareTo(_end) > 0 || _tmpEnd.compareTo(_end) < 0)) continue;
                throw new BgSchemeException(BgSchemeException.ACCROSSLIFECYCLE, new String[]{_orgName, _schemeName});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"checkCanExecute SQL Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    @Override
    protected void _execute(Context ctx, BOSUuid bgSchemeId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null || orgUnitId == null) {
            return;
        }
        Set<String> orgUnitIds = this.getImmediateFamilyBgOrgUnits(ctx, orgUnitId.toString());
        Set<String> bgSchemeIds = this.getBgSchemeByCreateOrgUnit(ctx, true, orgUnitIds, orgUnitId.toString());
        bgSchemeIds.remove(bgSchemeId.toString());
        this._checkCanExecute(ctx, bgSchemeId, bgSchemeIds);
        this.updateBgSchemeFormal(ctx, bgSchemeId, true);
    }

    @Override
    protected void _antiExecute(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return;
        }
        this.updateBgSchemeFormal(ctx, bgSchemeId, false);
    }

    private void updateBgSchemeFormal(Context ctx, BOSUuid bgSchemeId, boolean isExecute) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"Update T_MBG_BgScheme set FIsFormal = ? where FID = ?", (Object[])new Object[]{isExecute, bgSchemeId.toString()});
        }
        catch (SQLException ex) {
            logger.error((Object)"updateBgSchemeFormal SQL Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _checkCanFiling(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return;
        }
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FID, FName_" + ctx.getLocale() + " from T_MBG_BgScheme where FID = ? and FIsFiling = 1"), (Object[])new Object[]{bgSchemeId.toString()});
            if (rst.next()) {
                throw new BgSchemeException(BgSchemeException.CANTFILING, new String[]{rst.getString(2)});
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"checkCanFiling SQL Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
    }

    @Override
    protected boolean _filing(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return false;
        }
        this._checkCanFiling(ctx, bgSchemeId);
        this.updateBgSchemeFiling(ctx, bgSchemeId, true);
        return true;
    }

    @Override
    protected boolean _antiFiling(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return false;
        }
        this.updateBgSchemeFiling(ctx, bgSchemeId, false);
        return true;
    }

    private void updateBgSchemeFiling(Context ctx, BOSUuid bgSchemeId, boolean isFiling) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null) {
            return;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgDBUtils.executeUpdate((Connection)conn, (String)"Update T_MBG_BgScheme set FIsFiling = ? where FID = ?", (Object[])new Object[]{isFiling, bgSchemeId.toString()});
        }
        catch (SQLException ex) {
            logger.error((Object)"updateBgSchemeFiling SQL Error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected BgSchemeInfo _getDefaultSchemeByOrgUnit(Context ctx, BOSUuid orgUnitId, boolean isOnlySelf, String type) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null) {
            return null;
        }
        Set<String> bgOrgViewIds = BgOrgUnitUtils.getBgOrgViewIds(ctx, orgUnitId);
        if (bgOrgViewIds == null || bgOrgViewIds.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isFormal", (Object)Boolean.TRUE, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateFrom", (Object)new Date(), CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dateTo", (Object)new Date(), CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)Boolean.FALSE, CompareType.EQUALS));
        if (isOnlySelf) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)"Select FBgSchemeId FROM T_Mbg_BgTemplate Where FBgTypeId = 'bgMAAAAKIcA7rHKd'", CompareType.INNER));
        }
        if (!StringUtils.isEmpty((String)type)) {
            filter.getFilterItems().add(new FilterItemInfo("bgSchemeType.id", (Object)type, CompareType.EQUALS));
        }
        view.setFilter(filter);
        BgSchemeCollection colls = this.getBgSchemeCollection(ctx, view);
        if (colls != null && !colls.isEmpty()) {
            return colls.get(0);
        }
        return null;
    }

    @Override
    protected boolean _isExistControlRecord(Context ctx, String schemeId) throws BOSException, EASBizException {
        Connection connection;
        ResultSet rs;
        PreparedStatement ps;
        boolean isExist;
        block5: {
            isExist = false;
            ps = null;
            rs = null;
            connection = null;
            try {
                connection = this.getConnection(ctx);
                StringBuffer strBuffer = new StringBuffer(200);
                strBuffer.append("select Frefcube from T_MBG_BgScheme where FID=?");
                ps = connection.prepareStatement(strBuffer.toString());
                ps.setString(1, schemeId);
                rs = ps.executeQuery();
                boolean isexist = rs.next();
                String refcube = rs.getString("FRefcube");
                if (refcube.equals("") || refcube == null) break block5;
                String controlRecord = refcube.replace("BGDATA", "BGCONTROLRECORD");
                strBuffer.delete(0, strBuffer.length());
                strBuffer.append("select fid from ?");
                ps.setString(1, controlRecord);
                rs = ps.executeQuery();
                if (rs.next()) {
                    isExist = true;
                }
            }
            catch (SQLException e) {
                try {
                    throw new SQLDataException(e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, ps, (Connection)connection);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isExist;
    }

    protected boolean checkIsMergeScopeSettings(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        if (bgScheme == null) {
            return false;
        }
        BgDimSettingsCollection settingsColl = bgScheme.getBgDimSettings();
        BgDimSettingsInfo settings = null;
        BgDimSettingsMemberCollection memberColl = null;
        BgDimSettingsMemberInfo member = null;
        for (int i = 0; i < settingsColl.size(); ++i) {
            settings = settingsColl.get(i);
            if (!settings.getDimNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            memberColl = settings.getMembers();
            for (int j = 0; j < memberColl.size(); ++j) {
                member = memberColl.get(j);
                if (!member.getType().equals((Object)MemberTypeEnum.merge)) continue;
                return true;
            }
        }
        return false;
    }

    protected void filterOrgViewByType(BgDimSettingsCollection coll, MemberTypeEnum orgViewType) {
        if (coll == null || orgViewType == null) {
            return;
        }
        BgDimSettingsMemberCollection filterColl = new BgDimSettingsMemberCollection();
        for (int i = 0; i < coll.size(); ++i) {
            BgDimSettingsInfo dimSett = coll.get(i);
            if (!dimSett.getDimNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            BgDimSettingsMemberCollection members = dimSett.getMembers();
            for (int j = 0; j < members.size(); ++j) {
                if (!members.get(j).getType().equals((Object)orgViewType)) continue;
                filterColl.add(members.get(j));
            }
            dimSett.getMembers().clear();
            dimSett.getMembers().addCollection(filterColl);
            break;
        }
    }

    protected void updateOrAddMergeDim(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dimNumber", (Object)DimensionConstants.DEF_CSL_NUMBER, CompareType.EQUALS));
        BgDimSettingsCollection coll = BgDimSettingsFactory.getLocalInstance(ctx).getBgDimSettingsCollection(view);
        if (coll.size() == 0) {
            BgDimSettingsInfo mergeDim = null;
            coll = bgScheme.getBgDimSettings();
            for (int i = 0; i < coll.size(); ++i) {
                BgDimSettingsInfo dimSett = coll.get(i);
                if (!dimSett.getDimNumber().equals(DimensionConstants.DEF_CSL_NUMBER)) continue;
                mergeDim = dimSett;
                break;
            }
            if (mergeDim != null) {
                BgDimSettingsFactory.getLocalInstance(ctx).addnew(mergeDim);
                BgDimSettingsMemberFactory.getLocalInstance(ctx).addnew(mergeDim.getMembers().get(0));
            }
        }
    }

    protected void updateOrAddMergeScope(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        if (bgScheme == null) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("dimNumber", (Object)DimensionConstants.DEF_ORGUNIT_NUMBER, CompareType.EQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("members.*"));
        view.setSelector(selector);
        BgDimSettingsCollection coll = BgDimSettingsFactory.getLocalInstance(ctx).getBgDimSettingsCollection(view);
        BgMergeSchemeHelper.filterOrgViewByType(coll, MemberTypeEnum.merge);
        HashSet<String> delMergeIdSet = new HashSet<String>();
        BgDimSettingsInfo orgDimSett = null;
        if (coll.size() > 0) {
            orgDimSett = coll.get(0);
            BgDimSettingsMemberCollection memberColls = coll.get(0).getMembers();
            for (int j = 0; j < memberColls.size(); ++j) {
                if (!memberColls.get(j).getType().equals((Object)MemberTypeEnum.merge)) continue;
                delMergeIdSet.add(memberColls.get(j).getId().toString());
            }
        }
        if (delMergeIdSet.size() > 0) {
            FilterInfo delFilter = new FilterInfo();
            delFilter.getFilterItems().add(new FilterItemInfo("id", delMergeIdSet, CompareType.INCLUDE));
            BgDimSettingsMemberFactory.getLocalInstance(ctx).delete(delFilter);
        }
        BgDimSettingsCollection settingsColl = bgScheme.getBgDimSettings();
        BgDimSettingsInfo settings = null;
        BgDimSettingsMemberCollection memberColl = null;
        BgDimSettingsMemberInfo member = null;
        CoreBaseCollection addMergeColl = new CoreBaseCollection();
        for (int i = 0; i < settingsColl.size(); ++i) {
            settings = settingsColl.get(i);
            if (!settings.getDimNumber().equals(DimensionConstants.DEF_ORGUNIT_NUMBER)) continue;
            memberColl = settings.getMembers();
            for (int j = 0; j < memberColl.size(); ++j) {
                member = memberColl.get(j);
                if (orgDimSett == null || !member.getType().equals((Object)MemberTypeEnum.merge)) continue;
                orgDimSett.getMembers().clear();
                member.setBgDimSettings(orgDimSett);
                addMergeColl.add((CoreBaseInfo)member);
            }
            break;
        }
        BgDimSettingsMemberFactory.getLocalInstance(ctx).addnew(addMergeColl);
    }

    protected void updateOrAddDimGroup(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        if (bgScheme == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        DimGroupFactory.getLocalInstance(ctx).delete(filter);
        CoreBaseCollection coll = new CoreBaseCollection();
        for (int i = 0; i < bgScheme.getDimGroup().size(); ++i) {
            coll.add((CoreBaseInfo)bgScheme.getDimGroup().get(i));
        }
        DimGroupFactory.getLocalInstance(ctx).addnewBatchData(coll);
    }

    protected void updateOrAddnewDimSettings(Context ctx, BgSchemeInfo bgScheme) throws BOSException, EASBizException {
        int i;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("bgDimSettings.*"));
        selector.add(new SelectorItemInfo("bgDimSettings.members.*"));
        BgSchemeInfo oldScheme = null;
        if (BgSchemeFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(bgScheme.getId()))) {
            oldScheme = (BgSchemeInfo)BgSchemeFactory.getLocalInstance(ctx).getValue((IObjectPK)new ObjectUuidPK(bgScheme.getId()), selector);
        }
        CoreBaseCollection addSettingsColl = new CoreBaseCollection();
        CoreBaseCollection updateSettingsColl = new CoreBaseCollection();
        CoreBaseCollection removeSettingsColl = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> removeSettingsPk = new ArrayList<ObjectUuidPK>();
        CoreBaseCollection addMemberColl = new CoreBaseCollection();
        CoreBaseCollection updateMemberColl = new CoreBaseCollection();
        CoreBaseCollection removeMemberColl = new CoreBaseCollection();
        ArrayList<ObjectUuidPK> removeMemberPk = new ArrayList<ObjectUuidPK>();
        BgDimSettingsInfo settings = null;
        BgDimSettingsInfo oldSettings = null;
        BgDimSettingsCollection settingsColl = null;
        BgDimSettingsCollection oldSettingsColl = null;
        BgDimSettingsMemberInfo member = null;
        BgDimSettingsMemberInfo oldMember = null;
        BgDimSettingsMemberCollection memberColl = null;
        BgDimSettingsMemberCollection oldMemberColl = null;
        HashMap<String, BgDimSettingsMemberInfo> oldMemberMap = null;
        HashMap<String, BgDimSettingsInfo> oldSettingsMap = null;
        if (oldScheme != null) {
            oldSettingsColl = oldScheme.getBgDimSettings();
            BgMergeSchemeHelper.filterOrgViewByType(oldSettingsColl, MemberTypeEnum.budget);
            oldSettingsMap = new HashMap<String, BgDimSettingsInfo>();
            for (i = 0; i < oldSettingsColl.size(); ++i) {
                oldSettings = oldSettingsColl.get(i);
                oldSettingsMap.put(oldSettings.getDimNumber(), oldSettings);
            }
        }
        settingsColl = bgScheme.getBgDimSettings();
        for (i = 0; i < settingsColl.size(); ++i) {
            settings = settingsColl.get(i);
            memberColl = settings.getMembers();
            if (oldScheme != null && oldSettingsMap != null && oldSettingsMap.keySet().contains(settings.getDimNumber())) {
                int j;
                oldSettings = (BgDimSettingsInfo)oldSettingsMap.get(settings.getDimNumber());
                oldMemberColl = oldSettings.getMembers();
                if (settings.getId() == null) {
                    if (oldSettings.getId() != null) {
                        settings.setId(oldSettings.getId());
                    } else {
                        settings.setId(BOSUuid.create((BOSObjectType)settings.getBOSType()));
                    }
                }
                oldSettingsMap.remove(settings.getDimNumber());
                oldSettings.setSeq(settings.getSeq());
                oldSettings.setAudit(settings.isAudit());
                oldSettings.setDimName(settings.getDimName());
                updateSettingsColl.add((CoreBaseInfo)oldSettings);
                oldMemberColl = oldSettings.getMembers();
                oldMemberMap = new HashMap<String, BgDimSettingsMemberInfo>();
                for (j = 0; j < oldMemberColl.size(); ++j) {
                    oldMember = oldMemberColl.get(j);
                    oldMemberMap.put(oldMember.getNumber(), oldMember);
                }
                if (memberColl == null) continue;
                for (j = 0; j < memberColl.size(); ++j) {
                    member = memberColl.get(j);
                    if (oldMemberMap.containsKey(member.getNumber())) {
                        oldMember = (BgDimSettingsMemberInfo)oldMemberMap.get(member.getNumber());
                        oldMemberMap.remove(oldMember.getNumber());
                        oldMember.setSeq(member.getSeq());
                        oldMember.setName(member.getName());
                        if (member.getType() != null) {
                            oldMember.setType(member.getType());
                        }
                        updateMemberColl.add((CoreBaseInfo)oldMember);
                        continue;
                    }
                    member.setId(BOSUuid.create((BOSObjectType)member.getBOSType()));
                    addMemberColl.add((CoreBaseInfo)member);
                }
                if (oldMemberMap == null) continue;
                for (Map.Entry entry : oldMemberMap.entrySet()) {
                    removeMemberColl.add((CoreBaseInfo)entry.getValue());
                    removeMemberPk.add(new ObjectUuidPK(((BgDimSettingsMemberInfo)entry.getValue()).getId()));
                }
                continue;
            }
            if (settings.getId() == null) {
                settings.setId(BOSUuid.create((BOSObjectType)settings.getBOSType()));
            }
            addSettingsColl.add((CoreBaseInfo)settings);
            memberColl = settings.getMembers();
            for (int j = 0; j < memberColl.size(); ++j) {
                member = memberColl.get(j);
                member.setId(BOSUuid.create((BOSObjectType)member.getBOSType()));
                member = memberColl.get(j);
                addMemberColl.add((CoreBaseInfo)member);
            }
        }
        if (oldSettingsMap != null && !oldSettingsMap.isEmpty()) {
            if (bgScheme.getId() != null) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("dimNumber");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("DimRelashipGroup.bgScheme.id", (Object)bgScheme.getId().toString()));
                evi.getFilter().getFilterItems().add(new FilterItemInfo("dimNumber", new HashSet(oldSettingsMap.keySet()), CompareType.INCLUDE));
                DimRelashipGroupEntryCollection entryCol = DimRelashipGroupEntryFactory.getLocalInstance(ctx).getDimRelashipGroupEntryCollection(evi);
                if (entryCol != null && !entryCol.isEmpty()) {
                    StringBuffer number = new StringBuffer();
                    for (int e = 0; e < entryCol.size(); ++e) {
                        if (number.length() > 0) {
                            number.append(", ");
                        }
                        number.append(entryCol.get(e).getDimNumber());
                    }
                    throw new BgSchemeException(BgSchemeException.CANTREMOVEDIMBYRELATION, new Object[]{number});
                }
            }
            for (Map.Entry entry : oldSettingsMap.entrySet()) {
                removeSettingsColl.add((CoreBaseInfo)entry.getValue());
                removeSettingsPk.add(new ObjectUuidPK(((BgDimSettingsInfo)entry.getValue()).getId()));
                BgDimSettingsMemberCollection memColls = ((BgDimSettingsInfo)entry.getValue()).getMembers();
                for (int i2 = 0; i2 < memColls.size(); ++i2) {
                    removeMemberPk.add(new ObjectUuidPK(memColls.get(i2).getId()));
                }
            }
        }
        if (updateSettingsColl.size() != 0) {
            BgDimSettingsFactory.getLocalInstance(ctx).updateBatchData(updateSettingsColl);
        }
        if (addSettingsColl.size() != 0) {
            IObjectPK[] iObjectPKArray = BgDimSettingsFactory.getLocalInstance(ctx).addnewBatchData(addSettingsColl);
        }
        if (removeSettingsPk.size() != 0) {
            BgDimSettingsFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])removeSettingsPk.toArray(new ObjectUuidPK[removeSettingsPk.size()]));
        }
        if (updateMemberColl.size() != 0) {
            BgDimSettingsMemberFactory.getLocalInstance(ctx).update(updateMemberColl);
        }
        if (addMemberColl.size() != 0) {
            IObjectPK[] iObjectPKArray = BgDimSettingsMemberFactory.getLocalInstance(ctx).addnewBatchData(addMemberColl);
        }
        if (removeMemberPk.size() != 0) {
            BgDimSettingsMemberFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])removeMemberPk.toArray(new ObjectUuidPK[removeMemberPk.size()]));
        }
    }

    protected void deleteBgDimSettingsMember(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        for (int j = 0; j < pkArray.length; ++j) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)pkArray[j].toString(), CompareType.EQUALS));
            EntityViewInfo veiw = new EntityViewInfo();
            veiw.setFilter(filter);
            veiw.setSelector(selector);
            CoreBaseCollection coll = BgDimSettingsFactory.getLocalInstance(ctx).getCollection(veiw);
            HashSet<String> dimSettingsIDs = new HashSet<String>();
            for (int i = 0; i < coll.size(); ++i) {
                dimSettingsIDs.add(((BgDimSettingsInfo)coll.get(i)).getId().toString());
            }
            FilterInfo filter2 = new FilterInfo();
            filter2.getFilterItems().add(new FilterItemInfo("bgDimSettings.id", dimSettingsIDs, CompareType.INCLUDE));
            BgDimSettingsMemberFactory.getLocalInstance(ctx).delete(filter2);
            BgDimSettingsFactory.getLocalInstance(ctx).delete(filter);
        }
    }

    @Override
    protected BatchExecuteResult _deleteBatchData(Context ctx, IObjectPK[] pkArray, IObjectValue orgUnit) throws BOSException, EASBizException {
        ArrayList<IObjectPK> deletePk = new ArrayList<IObjectPK>();
        ArrayList<BgSchemeInfo> deleteScheme = new ArrayList<BgSchemeInfo>();
        ArrayList<Exception> exceps = new ArrayList<Exception>();
        for (int i = 0; i < pkArray.length; ++i) {
            BgSchemeInfo schemeInfo = this.getBgSchemeInfo(ctx, pkArray[i], this.getSelector());
            try {
                this.checkSchemeRef(ctx, schemeInfo, (FullOrgUnitInfo)orgUnit);
                deletePk.add(pkArray[i]);
                deleteScheme.add(schemeInfo);
            }
            catch (Exception e) {
                exceps.add(e);
                continue;
            }
            BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)schemeInfo, (String)schemeInfo.getOrgUnit().getId().toString(), (String)schemeInfo.getNumber());
        }
        this.deleteBgDimSettingsMember(ctx, deletePk.toArray(new IObjectPK[0]));
        super._deleteBatchData(ctx, deletePk.toArray(new IObjectPK[0]));
        BatchExecuteResult result = new BatchExecuteResult(exceps.size());
        for (int j = 0; j < exceps.size(); ++j) {
            result.setException(j, (Throwable)exceps.get(j));
        }
        return result;
    }

    public boolean checkRefDataPermission(Context ctx, BgSchemeInfo scheme) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)scheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("permissionType", (Object)1, CompareType.EQUALS));
        MbgPermissionCollection coll = MbgPermissionFactory.getLocalInstance(ctx).getMbgPermissionCollection(view);
        return coll.size() > 0;
    }

    protected void checkSchemeRef(Context ctx, BgSchemeInfo schemeInfo, FullOrgUnitInfo orgUnit) throws BOSException, EASBizException {
        if (this.checkIsFormal(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYISFORMAL, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkIsFiling(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYISFILING, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkIsCreateOrg(ctx, schemeInfo, (IObjectValue)orgUnit)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYCREATEORG, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkDimRel(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYREFDIMREL, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkBizCalc(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYREFBIZCALC, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkRefTemplate(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYREFTEMPLATE, new String[]{schemeInfo.getNumber()});
        }
        if (this.checkRefDataPermission(ctx, schemeInfo)) {
            throw new BgSchemeException(BgSchemeException.CANTDELETEBYMBGPERMISSION, new String[]{schemeInfo.getNumber()});
        }
    }

    @Override
    protected String _getOrgViewId(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        IRowSet rst;
        block5: {
            String string;
            if (StringUtils.isEmpty((String)bgSchemeId)) {
                return null;
            }
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Context)ctx, (String)"Select FMemberId FROM T_MBG_BgDimSettingsMember Where FType = ? AND FBgDimSettingsID IN (Select FID FROM T_MBG_BgDimSettings Where FBgSchemeID = ?)", (Object[])new Object[]{2, bgSchemeId});
                if (!rst.next()) break block5;
                string = rst.getString("FMemberId");
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"_getOrgViewId", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return string;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return null;
    }

    @Override
    protected Map _getDefaultMember(Context ctx, BgSchemeDimensionHelper helper, boolean isCheckLeaf, boolean isPeriodPutInColls) throws BOSException, EASBizException {
        if (ctx == null || helper == null) {
            return null;
        }
        CoreBaseCollection bgDimSettings = helper.getSettings();
        if (bgDimSettings == null) {
            return null;
        }
        BgDimSettingsInfo bgDimSettingsInfo = null;
        String dimNumber = null;
        String defMemberID = null;
        BgPeriodInfo periodInfo = null;
        BgVersionInfo bgVersionInfo = null;
        CurrencyInfo currencyInfo = null;
        BgElementInfo bgElementInfo = null;
        BgScenarioInfo bgScenarioInfo = null;
        HashMap<String, Object> returnMap = new HashMap<String, Object>();
        for (int i = 0; i < bgDimSettings.size() && !Boolean.FALSE.equals(bgDimSettings.get(i) instanceof BgDimSettingsInfo); ++i) {
            bgDimSettingsInfo = (BgDimSettingsInfo)bgDimSettings.get(i);
            if (bgDimSettingsInfo == null) continue;
            dimNumber = bgDimSettingsInfo.getDimNumber();
            defMemberID = bgDimSettingsInfo.getDefMemberID();
            if (StringUtils.isEmpty((String)defMemberID)) continue;
            if (DimensionConstants.DEF_PERIOD_NUMBER.equals(dimNumber)) {
                BgPeriodCollection colls;
                BgPeriodDispInfo bgPeriodDispInfo = null;
                BgDimSettingsMemberCollection setColls = bgDimSettingsInfo.getMembers();
                HashSet<BOSUuid> periodTypeIds = new HashSet<BOSUuid>();
                if (setColls != null) {
                    for (int j = 0; j < setColls.size(); ++j) {
                        periodTypeIds.add(setColls.get(j).getMemberID());
                    }
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("type.id", periodTypeIds, CompareType.INCLUDE));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)defMemberID, CompareType.EQUALS));
                    BgPeriodDispCollection periodDispColls = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi);
                    if (!periodDispColls.isEmpty()) {
                        bgPeriodDispInfo = periodDispColls.get(0);
                    }
                }
                if ((periodInfo = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(defMemberID))).getDisplayName() == null && bgPeriodDispInfo != null) {
                    periodInfo.setDisplayName(bgPeriodDispInfo.getAlias());
                }
                if (isCheckLeaf) {
                    if (periodInfo.isIsLeaf()) {
                        if (isPeriodPutInColls) {
                            colls = new BgPeriodCollection();
                            colls.add(periodInfo);
                            returnMap.put(DimensionConstants.DEF_PERIOD_NUMBER, colls);
                            continue;
                        }
                        returnMap.put(DimensionConstants.DEF_PERIOD_NUMBER, periodInfo);
                        continue;
                    }
                    returnMap.put(DimensionConstants.DEF_PERIOD_NUMBER, null);
                    continue;
                }
                if (isPeriodPutInColls) {
                    colls = new BgPeriodCollection();
                    colls.add(periodInfo);
                    returnMap.put(DimensionConstants.DEF_PERIOD_NUMBER, colls);
                    continue;
                }
                returnMap.put(DimensionConstants.DEF_PERIOD_NUMBER, periodInfo);
                continue;
            }
            if (DimensionConstants.DEF_VERSION_NUMBER.equals(dimNumber)) {
                bgVersionInfo = BgVersionFactory.getLocalInstance((Context)ctx).getBgVersionInfo((IObjectPK)new ObjectUuidPK(defMemberID));
                returnMap.put(DimensionConstants.DEF_VERSION_NUMBER, bgVersionInfo);
                continue;
            }
            if (DimensionConstants.DEF_CURRENCY_NUMBER.equals(dimNumber)) {
                currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(defMemberID));
                returnMap.put(DimensionConstants.DEF_CURRENCY_NUMBER, currencyInfo);
                continue;
            }
            if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(dimNumber)) {
                bgElementInfo = BgElementFactory.getLocalInstance((Context)ctx).getBgElementInfo((IObjectPK)new ObjectUuidPK(defMemberID));
                returnMap.put(DimensionConstants.DEF_ELEMENT_NUMBER, bgElementInfo);
                continue;
            }
            if (!DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimNumber)) continue;
            bgScenarioInfo = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioInfo((IObjectPK)new ObjectUuidPK(defMemberID));
            returnMap.put(DimensionConstants.DEF_SCENARIO_NUMBER, bgScenarioInfo);
        }
        return returnMap;
    }
}

