/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeDispatchFacadeControllerBean;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDispatchUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeDispatchFacadeControllerBean
extends AbstractBgSchemeDispatchFacadeControllerBean {
    private static final long serialVersionUID = -6009665423623869603L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeDispatchFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _dispatch(Context ctx, Map parameter) throws BOSException, EASBizException {
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        if (parameter == null || parameter.isEmpty()) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        String _bgSchemeId = (String)parameter.get(BgBaseConstants.BGSCHEME_ID);
        List _orgUnitIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
        List _bgTemplateIds = (List)parameter.get(BgBaseConstants.BGTEMPLATE_ID);
        if (StringUtils.isEmpty((String)_bgSchemeId) || _orgUnitIds == null || _orgUnitIds.isEmpty() || _bgTemplateIds == null || _bgTemplateIds.isEmpty()) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        if (!this.getBgSchemeInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgSchemeId))) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, "defeated.object.noexites"));
            return _reList;
        }
        IBgScheme iBgScheme = this.getBgSchemeInterface(ctx);
        IMutexServiceControl iMc = this.getMutexServicInterface(ctx);
        BgTemplateInfo templateInfo = null;
        List<String[]> tmpList = null;
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(_bgSchemeId), BgSchemeDispatchUtils.getBgSchemeSelector());
        Map<String, FullOrgUnitInfo> orgUnitMap = BgSchemeDispatchUtils.getOrgUnitInfo(ctx, _orgUnitIds);
        Map<String, BgTemplateInfo> bgTemplateMap = this.queryBgTemplateInfo(ctx, _bgTemplateIds);
        for (String _bgTemplateId : _bgTemplateIds) {
            templateInfo = bgTemplateMap.get(_bgTemplateId);
            try {
                boolean reqTemplate = iMc.requestBizObjIDForUpdate(_bgTemplateId);
                if (reqTemplate) {
                    tmpList = this.dispatchBgTemplate(ctx, schemeInfo, templateInfo, _orgUnitIds, orgUnitMap);
                    if (tmpList == null) continue;
                    _reList.addAll(tmpList);
                    continue;
                }
                _reList.add(BgSchemeDispatchUtils.getDispatchResult(templateInfo, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NETMUTEX));
            }
            finally {
                iMc.releaseObjIDForUpdate(_bgTemplateId);
            }
        }
        return _reList;
    }

    private IMutexServiceControl getMutexServicInterface(Context ctx) throws BOSException {
        return MutexServiceControlFactory.getLocalInstance((Context)ctx);
    }

    private IBgScheme getBgSchemeInterface(Context ctx) throws BOSException {
        return BgSchemeFactory.getLocalInstance(ctx);
    }

    private IBgTemplate getBgTemplateInterface(Context ctx) throws BOSException {
        return BgTemplateFactory.getLocalInstance(ctx);
    }

    protected List<String[]> dispatchBgTemplate(Context ctx, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        return BgSchemeDispatchUtils.dispatchTemplate(ctx, bgSchemeInfo, bgTemplateInfo, orgUnitIds, orgUnitMap);
    }

    @Override
    protected Map _queryDispatchInfo(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        HashMap dispatchMap = new HashMap();
        HashMap bgTemplateIdsMap = new HashMap();
        dispatchMap.put(BgSchemeDispatchConstants.SCHEME_DISPATCH, bgTemplateIdsMap);
        if (ctx == null || bgSchemeId == null) {
            return dispatchMap;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select t.FBgTemplateId, t.FOrgUnitId from T_MBG_BgTemplateNode t, T_Mbg_BgTemplate t1 where t.FBgTemplateId = t1.FID and t.FOrgUnitID <> t1.FOrgUnitId and t1.FBgSchemeId = ?");
        Object[] sqlParams = new Object[]{bgSchemeId.toString()};
        BOSUuid bgTemRootId = null;
        BOSUuid orgUnitId = null;
        Set<BOSUuid> orgUnitIds = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgTemRootId = BOSUuid.read((String)rst.getString("FBgTemplateId"));
                orgUnitId = BOSUuid.read((String)rst.getString("FOrgUnitId"));
                if (bgTemplateIdsMap.containsKey(bgTemRootId)) {
                    orgUnitIds = (Set)bgTemplateIdsMap.get(bgTemRootId);
                } else {
                    orgUnitIds = new HashSet();
                    bgTemplateIdsMap.put(bgTemRootId, orgUnitIds);
                }
                orgUnitIds.add(orgUnitId);
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"queryDispatchInfo Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return dispatchMap;
    }

    @Override
    protected Set _queryCompanyIds(Context ctx) throws BOSException, EASBizException {
        HashSet<BOSUuid> companyIds = new HashSet<BOSUuid>();
        CompanyOrgUnitCollection colls = BgSchemeDispatchUtils.getCompanyOrgUnit(ctx);
        if (colls != null) {
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                companyIds.add(colls.get(i).getId());
            }
        }
        return companyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _antiDispatch(Context ctx, Map parameter) throws BOSException, EASBizException {
        ArrayList<String[]> _reList = new ArrayList<String[]>();
        if (parameter == null || parameter.isEmpty()) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        String _bgSchemeId = (String)parameter.get(BgBaseConstants.BGSCHEME_ID);
        List _orgUnitIds = (List)parameter.get(BgBaseConstants.ORGUNIT_ID);
        List _bgTemplateIds = (List)parameter.get(BgBaseConstants.BGTEMPLATE_ID);
        if (StringUtils.isEmpty((String)_bgSchemeId) || _orgUnitIds == null || _orgUnitIds.isEmpty() || _bgTemplateIds == null || _bgTemplateIds.isEmpty()) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, BgSchemeDispatchConstants.DEFEATED_PARAMETER_ISNULL));
            return _reList;
        }
        if (!this.getBgSchemeInterface(ctx).exists((IObjectPK)new ObjectUuidPK(_bgSchemeId))) {
            _reList.add(BgSchemeDispatchUtils.getDispatchResult(false, "defeated.object.noexites"));
            return _reList;
        }
        IBgScheme iBgScheme = this.getBgSchemeInterface(ctx);
        IMutexServiceControl iMc = this.getMutexServicInterface(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(_bgSchemeId), BgSchemeDispatchUtils.getBgSchemeSelector());
        Map<String, FullOrgUnitInfo> orgUnitMap = BgSchemeDispatchUtils.getOrgUnitInfo(ctx, _orgUnitIds);
        Map<String, BgTemplateInfo> bgTemplateMap = this.queryBgTemplateInfo(ctx, _bgTemplateIds);
        List<String[]> tmpList = null;
        BgTemplateInfo templateInfo = null;
        for (String _bgTemplateId : _bgTemplateIds) {
            templateInfo = bgTemplateMap.get(_bgTemplateId);
            try {
                boolean reqTemplate = iMc.requestBizObjIDForUpdate(_bgTemplateId);
                if (reqTemplate) {
                    tmpList = this.antiDispatchBgTemplate(ctx, schemeInfo, templateInfo, _orgUnitIds, orgUnitMap);
                    if (tmpList == null) continue;
                    _reList.addAll(tmpList);
                    continue;
                }
                _reList.add(BgSchemeDispatchUtils.getDispatchResult(templateInfo, false, BgSchemeDispatchConstants.DISPATCH_FAIL_NETMUTEX));
            }
            finally {
                iMc.releaseObjIDForUpdate(_bgTemplateId);
            }
        }
        return _reList;
    }

    public Map<String, BgTemplateInfo> queryBgTemplateInfo(Context ctx, List<String> bgTemplateIds) throws BOSException, EASBizException {
        HashMap<String, BgTemplateInfo> bgTemplateMap = new HashMap<String, BgTemplateInfo>();
        if (bgTemplateIds != null && !bgTemplateIds.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(BgSchemeDispatchUtils.getBgTemplateSelector());
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet<String>(bgTemplateIds), CompareType.INCLUDE));
            BgTemplateCollection col = this.getBgTemplateInterface(ctx).getBgTemplateCollection(evi);
            if (col != null && !col.isEmpty()) {
                for (int i = 0; i < col.size(); ++i) {
                    bgTemplateMap.put(col.get(i).getId().toString(), col.get(i));
                }
            }
        }
        return bgTemplateMap;
    }

    protected List<String[]> antiDispatchBgTemplate(Context ctx, BgSchemeInfo bgSchemeInfo, BgTemplateInfo bgTemplateInfo, List<String> orgUnitIds, Map<String, FullOrgUnitInfo> orgUnitMap) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeInfo == null || bgTemplateInfo == null || orgUnitIds == null || orgUnitIds.isEmpty()) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        String _bgTemplateId = bgTemplateInfo.getId().toString();
        String _orgUnitId = null;
        Object entry = null;
        FullOrgUnitInfo orgUnit = null;
        ArrayList<String[]> result = new ArrayList<String[]>();
        Set<BOSUuid> refByBgFormMap = BgSchemeDispatchUtils.dispatchCheckRefBgForm(ctx, bgSchemeInfo.getId(), bgTemplateInfo.getId(), orgUnitIds);
        ArrayList<String[]> delOrgIds = new ArrayList<String[]>();
        for (int i = 0; i < orgUnitIds.size(); ++i) {
            _orgUnitId = orgUnitIds.get(i);
            orgUnit = orgUnitMap.get(_orgUnitId);
            if (orgUnit == null) continue;
            if (refByBgFormMap.contains(orgUnit.getId())) {
                result.add(BgSchemeDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, false, BgSchemeDispatchConstants.ANTIDISPATCH_FAIL_REFFORM));
                continue;
            }
            delOrgIds.add(new String[]{_bgTemplateId, _orgUnitId});
            result.add(BgSchemeDispatchUtils.getDispatchResult(bgTemplateInfo, (OrgUnitInfo)orgUnit, true, null));
        }
        DbUtil.executeBatch((Context)ctx, (String)"Delete From T_MBg_BgTemplateNode Where FBgTemplateId = ? AND FOrgUnitId = ?", delOrgIds);
        return result;
    }
}

