/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.service.ormrpc.EnactmentServiceFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgSchemeFacadeControllerBean
extends AbstractBgSchemeFacadeControllerBean {
    private static final long serialVersionUID = 5553350081147295953L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeFacadeControllerBean");
    public static final String SCHEME_SUBMIT_RESOURCE_PATH = "com.kingdee.eas.ma.mbg.BgSchemeResource";

    public SelectorItemCollection getBgFormInfo() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("creator.*"));
        sic.add(new SelectorItemInfo("bgType.*"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("data"));
        sic.add(new SelectorItemInfo("bgPeriod.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        sic.add(new SelectorItemInfo("bgScheme.*"));
        sic.add(new SelectorItemInfo("bgTemplate.*"));
        sic.add(new SelectorItemInfo("currency.*"));
        sic.add(new SelectorItemInfo("company.*"));
        sic.add(new SelectorItemInfo("auditedStatus"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("versionNo"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("adjust.id"));
        sic.add(new SelectorItemInfo("CU.id"));
        sic.add(new SelectorItemInfo("CU.name"));
        sic.add(new SelectorItemInfo("sheetParam.*"));
        sic.add(new SelectorItemInfo("postils.*"));
        sic.add(new SelectorItemInfo("postils.report.id"));
        sic.add(new SelectorItemInfo("postils.sheet.id"));
        sic.add(new SelectorItemInfo("postils.creator.id"));
        sic.add(new SelectorItemInfo("postils.creator.name"));
        sic.add(new SelectorItemInfo("sheetParam.id"));
        sic.add(new SelectorItemInfo("sheetParam.sheetName"));
        sic.add(new SelectorItemInfo("sheetParam.startYear"));
        sic.add(new SelectorItemInfo("sheetParam.endYear"));
        sic.add(new SelectorItemInfo("sheetParam.startPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.endPeriod"));
        sic.add(new SelectorItemInfo("sheetParam.startDate"));
        sic.add(new SelectorItemInfo("sheetParam.endDate"));
        sic.add(new SelectorItemInfo("sheetParam.isIncludingUnposted"));
        sic.add(new SelectorItemInfo("sheetParam.relaType"));
        sic.add(new SelectorItemInfo("sheetParam.sheetID"));
        sic.add(new SelectorItemInfo("sheetParam.reportClass"));
        sic.add(new SelectorItemInfo("sheetParam.cslSheetManner"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgType"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.id"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.type"));
        sic.add(new SelectorItemInfo("sheetParam.orgRela.orgUnit.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.id"));
        sic.add(new SelectorItemInfo("sheetParam.currency.number"));
        sic.add(new SelectorItemInfo("sheetParam.currency.name"));
        sic.add(new SelectorItemInfo("sheetParam.currency.precision"));
        sic.add(new SelectorItemInfo("sheetParam.postils.*"));
        sic.add(new SelectorItemInfo("sheetParam.postils.report.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.sheet.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.id"));
        sic.add(new SelectorItemInfo("sheetParam.postils.creator.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.*"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.bgElement.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.id"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.name"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.number"));
        sic.add(new SelectorItemInfo("bgMeasureUnit.measureUnit.coefficient"));
        sic.add(new SelectorItemInfo("measureUnit.*"));
        sic.add(new SelectorItemInfo("templateLastUpdateTime"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getErrorList(Context ctx, String orgUnitId, String bgSchemeId, String[] bgPeriodCollIds) throws BOSException, EASBizException {
        ResultSet rs = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        List finalList = new ArrayList();
        try {
            conn = this.getConnection(ctx);
            Vector<String> temCollVec = new Vector<String>();
            String getTemSQL = "select FID from T_MBg_BgTemplate where fbgschemeid = ?";
            pstmt = conn.prepareStatement(getTemSQL);
            pstmt.setString(1, bgSchemeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temCollVec.add(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            _tmpList.add(orgUnitId);
            _tmpList.add(bgSchemeId);
            _tmpList.addAll(temCollVec);
            if (bgPeriodCollIds != null) {
                int in = bgPeriodCollIds.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(bgPeriodCollIds[i]);
                }
            }
            Vector<String> temp = new Vector<String>();
            StringBuffer sb = new StringBuffer();
            sb.append("select FID from T_MBg_bgform where forgunitid = ? ");
            sb.append("and fbgschemeid = ? ");
            if (!temCollVec.isEmpty()) {
                sb.append(" and fbgtemplateid in (");
                sb.append(MbgSqlHelper.getParamSizeString(temCollVec)).append(")");
            }
            if (bgPeriodCollIds != null && bgPeriodCollIds.length > 0) {
                sb.append(" and fbgperiodid in (");
                sb.append(MbgSqlHelper.getParamSizeString((int)bgPeriodCollIds.length)).append(")");
            }
            pstmt = conn.prepareStatement(sb.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temp.add(rs.getString("fid"));
            }
            finalList = this.dealList(ctx, temp, temCollVec, bgPeriodCollIds);
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return finalList;
    }

    private List dealList(Context ctx, Vector bgformId, Vector temCollVec, String[] bgPeriodCollIds) throws Exception {
        Connection conn = null;
        conn = this.getConnection(ctx);
        ArrayList finalList = new ArrayList();
        try {
            IBgTemplate ibgtem = BgTemplateFactory.getLocalInstance(ctx);
            IBgPeriod ibgperiod = BgPeriodFactory.getLocalInstance((Context)ctx);
            IBgForm ibgForm = BgFormFactory.getLocalInstance(ctx);
            for (int i = 0; i < temCollVec.size(); ++i) {
                for (int j = 0; j < bgPeriodCollIds.length; ++j) {
                    String state;
                    if (bgformId.size() == 0) {
                        Vector<String> vec = new Vector<String>();
                        BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK((String)temCollVec.get(i)));
                        BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodCollIds[j]));
                        state = ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"notExist", (Locale)ContextUtils.getLocaleFromEnv());
                        vec.add(bgteminfo.getName());
                        vec.add(bgperiodinfo.getName());
                        vec.add(state);
                        finalList.add(vec);
                        continue;
                    }
                    int seq = this.inFormVec(ctx, bgformId, (String)temCollVec.get(i), bgPeriodCollIds[j]);
                    if (seq >= 0) {
                        String id = (String)bgformId.get(seq);
                        BgFormInfo bgFormInfo = ibgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
                        state = bgFormInfo.getState().getAlias();
                        if (state.equals(BgFormStateEnum.Edited.getAlias()) || state.equals(BgFormStateEnum.Approved.getAlias()) || state.equals(BgFormStateEnum.Approving.getAlias()) || state.equals(BgFormStateEnum.REFERRING.getAlias())) continue;
                        Vector<String> vec = new Vector<String>();
                        BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgTemplate().getId().toString()));
                        BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getBgPeriod().getId().toString()));
                        vec.add(bgteminfo.getName());
                        vec.add(bgperiodinfo.getName());
                        vec.add(state);
                        finalList.add(vec);
                        continue;
                    }
                    Vector<String> vec = new Vector<String>();
                    BgTemplateInfo bgteminfo = ibgtem.getBgTemplateInfo((IObjectPK)new ObjectUuidPK((String)temCollVec.get(i)));
                    BgPeriodInfo bgperiodinfo = ibgperiod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(bgPeriodCollIds[j]));
                    String state2 = ResourceBase.getString((String)SCHEME_SUBMIT_RESOURCE_PATH, (String)"notExist", (Locale)ContextUtils.getLocaleFromEnv());
                    vec.add(bgteminfo.getName());
                    vec.add(bgperiodinfo.getName());
                    vec.add(state2);
                    finalList.add(vec);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
            throw ex;
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int inFormVec(Context ctx, Vector bgFormIdVec, String bgTemplateId, String bgPeriodId) throws Exception {
        int seq = -1;
        BgFormInfo bgFormInfo = null;
        try {
            for (int k = 0; k < bgFormIdVec.size(); ++k) {
                String id = (String)bgFormIdVec.get(k);
                bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(id));
                if (!bgFormInfo.getBgTemplate().getId().toString().equalsIgnoreCase(bgTemplateId) || !bgFormInfo.getBgPeriod().getId().toString().equalsIgnoreCase(bgPeriodId)) continue;
                seq = k;
                break;
            }
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            if (bgFormInfo != null) {
                bgFormInfo.clear();
            }
        }
        return seq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getCorrectFormList(Context ctx, String orgUnitId, String bgSchemeId, String[] bgPeriodCollIds) throws BOSException, EASBizException {
        ArrayList list = new ArrayList();
        Vector<String> vec = new Vector<String>();
        Vector<String> vecs = new Vector<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        BgFormInfo bgforminfo = null;
        ArrayList<Object> _tmpList = new ArrayList<Object>();
        try {
            conn = this.getConnection(ctx);
            Vector<String> temCollVec = new Vector<String>();
            String getTemSQL = "select FID from T_MBg_BgTemplate where fbgschemeid = ?";
            pstmt = conn.prepareStatement(getTemSQL);
            pstmt.setString(1, bgSchemeId);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                temCollVec.add(rs.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            _tmpList.add(orgUnitId);
            _tmpList.add(bgSchemeId);
            _tmpList.addAll(temCollVec);
            if (bgPeriodCollIds != null) {
                int in = bgPeriodCollIds.length;
                for (int i = 0; i < in; ++i) {
                    _tmpList.add(bgPeriodCollIds[i]);
                }
            }
            _tmpList.add(new Integer(1));
            _tmpList.add(new Integer(25));
            StringBuffer sb = new StringBuffer();
            sb.append("select fid,fstate from T_MBg_bgform where forgunitid = ? and fbgschemeid = ? ");
            if (!temCollVec.isEmpty()) {
                sb.append(" and fbgtemplateid in (");
                sb.append(MbgSqlHelper.getParamSizeString((int)temCollVec.size())).append(")");
            }
            if (bgPeriodCollIds != null && bgPeriodCollIds.length > 0) {
                sb.append(" and fbgperiodid in (");
                sb.append(MbgSqlHelper.getParamSizeString((int)bgPeriodCollIds.length)).append(")");
            }
            sb.append(" and fstate in (?,?)");
            pstmt = conn.prepareStatement(sb.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                if (rs.getInt("fstate") == BgFormStateEnum.Edited.getValue()) {
                    vec.add(rs.getString("fid"));
                    continue;
                }
                vecs.add(rs.getString("fid"));
            }
            if (!vecs.isEmpty()) {
                int i;
                vec.addAll(vecs);
                String[] ids = new String[vecs.size()];
                for (i = 0; i < ids.length; ++i) {
                    ids[i] = (String)vecs.get(i);
                }
                ids = EnactmentServiceFactory.createEnactService((Context)ctx).checkBizObjInWfProcess(ids);
                if (ids != null && ids.length > 0) {
                    for (i = 0; i < ids.length; ++i) {
                        vec.remove(ids[i]);
                    }
                }
            }
            for (int i = 0; i < vec.size(); ++i) {
                IBgForm ibgform = BgFormFactory.getLocalInstance(ctx);
                bgforminfo = ibgform.getBgFormInfo((IObjectPK)new ObjectUuidPK((String)vec.get(i)));
                Vector<Object> temp = new Vector<Object>();
                temp.add(bgforminfo.getId().toString());
                temp.add(bgforminfo.getNumber());
                temp.add((Object)bgforminfo.getState());
                list.add(temp);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        }
        catch (Exception ex) {
            logger.error((Object)"", (Throwable)ex);
        }
        finally {
            SQLUtils.cleanup(rs, pstmt, (Connection)conn);
        }
        return list;
    }

    public static List tranVector2String(Vector idVector) {
        if (idVector == null || idVector.size() < 1) {
            return null;
        }
        StringBuffer sqlInner = new StringBuffer();
        ArrayList<Object[]> list = new ArrayList<Object[]>();
        Iterator iter = idVector.iterator();
        String[] param = new String[500];
        Object[] mapStrParam = new Object[2];
        int i = 0;
        while (iter.hasNext()) {
            if (i >= 500) {
                mapStrParam[0] = sqlInner;
                mapStrParam[1] = param;
                list.add(mapStrParam);
                mapStrParam = new Object[2];
                i = 0;
                param = new String[500];
            }
            if (i == 0) {
                sqlInner.append("?");
            } else {
                sqlInner.append(",?");
            }
            param[i] = (String)iter.next();
            ++i;
        }
        if (i > 0) {
            mapStrParam[0] = sqlInner;
            mapStrParam[1] = param;
            list.add(mapStrParam);
        }
        return list;
    }

    @Override
    protected Map _getEditedBgFormId_TemplateId_Map_ByBgTemplateIDArray(Context ctx, String[] templateIdArray) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer("select A.fid id,A.FTemplateLastUpdateTime,A.fname").append(" formName,A.frecord frecord,B.FLastUpdateTime,B.fname").append(" templateName,A.FBgTemplateID fbgtemplateid \n from T_MBg_bgform A inner join T_MBg_bgtemplate B ").append(" on a.FBgTemplateID = b.Fid ").append("\n\t where ( \r\n\t( B.FLastUpdateTime > A.FTemplateLastUpdateTime and A.FTemplateLastUpdateTime is not null) ").append(" \r\n\t or\t(B.FLastUpdateTime > A.fcreatetime  and A.FTemplateLastUpdateTime is null) \r\n ) and (");
        if (templateIdArray.length < 0) {
            return null;
        }
        int length = templateIdArray.length;
        for (int i = 0; i < length; ++i) {
            if (i == 0) {
                sql.append("\n\t\t A.FBgTemplateID = '" + templateIdArray[i] + "' ");
                continue;
            }
            sql.append("\n\t\t or A.FBgTemplateID = '" + templateIdArray[i] + "' ");
        }
        sql.append(" ) and A.FState=1");
        logger.debug((Object)("_getEditedBgFormId_TemplateId_Map_ByBgTemplateIDArray sql = " + sql));
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<BgFormInfo, BgTemplateInfo> mapReturn = new HashMap<BgFormInfo, BgTemplateInfo>();
        String formId = null;
        String bgtemplateId = null;
        BgFormInfo forminfo = null;
        BgTemplateInfo templateinfo = null;
        try {
            while (row.next()) {
                if (row.getInt("frecord") != 0) continue;
                formId = row.getString("id");
                bgtemplateId = row.getString("fbgtemplateid");
                forminfo = new BgFormInfo();
                forminfo.setId(BOSUuid.read((String)formId));
                forminfo.setName(row.getString("formName"));
                templateinfo = new BgTemplateInfo();
                templateinfo.setId(BOSUuid.read((String)bgtemplateId));
                templateinfo.setName(row.getString("templateName"));
                mapReturn.put(forminfo, templateinfo);
            }
        }
        catch (SQLException sqle) {
            logger.error((Object)"", (Throwable)sqle);
            throw new BOSException(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MBGAutoGenerateResource", (String)"52_BgSchemeFacadeControllerBean", (Locale)ctx.getLocale()));
        }
        return mapReturn;
    }

    @Override
    protected Map _getSchemeIdsChildOrgByIsInvoke(Context ctx, String schemeId, boolean isInvoke) throws BOSException, EASBizException {
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        BgSchemeInfo schemeInfo = iBgScheme.getBgSchemeInfo((IObjectPK)new ObjectUuidPK(schemeId));
        CostCenterOrgUnitInfo costcenter = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(schemeInfo.getOrgUnit().getId()));
        StringBuffer oql = new StringBuffer("select distinct a.fid fid,b.fid orgid,b.flongnumber longnumber,b.fname_" + ctx.getLocale() + " orgname from T_MBg_bgscheme A,t_org_costcenter B").append(" where A.FOrgUnitID = B.Fid ").append(" and B.FLongnumber like ? ").append(" and A.fid <> ? ").append(" and A.FROOTID = ? ");
        if (isInvoke) {
            oql.append(" and a.FIsFormal = 1");
        } else {
            oql.append(" and a.FIsFormal = 0");
        }
        Object[] obj = new Object[]{costcenter.getLongNumber() + "!%", schemeId, schemeInfo.getId().toString()};
        HashMap<String, CostCenterOrgUnitInfo> map = new HashMap<String, CostCenterOrgUnitInfo>();
        if (isInvoke) {
            map.put(schemeId, costcenter);
        }
        IRowSet row = DbUtil.executeQuery((Context)ctx, (String)oql.toString(), (Object[])obj);
        try {
            String childSchemeId = null;
            String childOrgId = null;
            String childOrgName = null;
            String longnumber = null;
            CostCenterOrgUnitInfo org = null;
            while (row.next()) {
                org = new CostCenterOrgUnitInfo();
                childSchemeId = row.getString("fid");
                childOrgId = row.getString("orgid");
                childOrgName = row.getString("orgname");
                longnumber = row.getString("longnumber");
                org.setId(BOSUuid.read((String)childOrgId));
                org.setName(childOrgName);
                org.setLongNumber(longnumber);
                map.put(childSchemeId, org);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return map;
    }
}

