/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.logger.MbgLoggerUtils;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.BizCalcCollection;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcMember;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.data.impl.MbgDataFacadeImpl;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgNotExecuteBizCalcInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegratDataStateEnum;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationCollection;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationEntryCollection;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationEntryInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationException;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFacadeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationFactory;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMapInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationReportInfo;
import com.kingdee.eas.ma.mbg.BgSchemeIntegrationSourceEnum;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeIntegrationFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.BgSchemeIntegerParameter;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.face.IMember;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeIntegrationHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MBgPeriodVariable;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.RefFieldComparator;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSchemeIntegrationFacadeControllerBean
extends AbstractBgSchemeIntegrationFacadeControllerBean {
    private static final long serialVersionUID = -2135668765084646306L;
    private static final String INTEGRATION_ID = "INTEGRATION_ID";
    private static final int INTEGRATIONID_INDEX = 0;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeIntegrationFacadeControllerBean");

    @Override
    protected IObjectCollection _getInitBgSchemeInteratioinEntry(Context ctx, BOSUuid sourceBgSchemeId, BOSUuid targetBgSchemeId) throws BOSException, EASBizException {
        if (sourceBgSchemeId == null || targetBgSchemeId == null) {
            return new BgSchemeIntegrationEntryCollection();
        }
        BgSchemeDimensionHelper sourceHelper = new BgSchemeDimensionHelper(ctx, sourceBgSchemeId.toString());
        BgSchemeDimensionHelper targetHelper = new BgSchemeDimensionHelper(ctx, targetBgSchemeId.toString());
        LinkedHashMap<String, BgSchemeIntegrationEntryInfo> entryMap = new LinkedHashMap<String, BgSchemeIntegrationEntryInfo>();
        List<String> sourceDimNumbers = sourceHelper.getAllDim();
        List<String> targetDimNumbers = targetHelper.getAllDim();
        List<BgDimensionInfo> sourceDimensions = sourceHelper.getAllDimensions();
        List<BgDimensionInfo> targetDimensions = targetHelper.getAllDimensions();
        this.processEntry(targetDimensions, sourceDimNumbers, entryMap, BgSchemeIntegrationSourceEnum.target);
        this.processEntry(sourceDimensions, targetDimNumbers, entryMap, BgSchemeIntegrationSourceEnum.source);
        this.processDefaultMember(ctx, entryMap, sourceHelper, targetHelper);
        return this.processEntryCol(entryMap);
    }

    private IObjectCollection processEntryCol(Map<String, BgSchemeIntegrationEntryInfo> entryMap) {
        BgSchemeIntegrationEntryCollection col = new BgSchemeIntegrationEntryCollection();
        Iterator<BgSchemeIntegrationEntryInfo> it = entryMap.values().iterator();
        while (it.hasNext()) {
            col.add(it.next());
        }
        col.sort("sourceType");
        return col;
    }

    private void processDefaultMember(Context ctx, Map<String, BgSchemeIntegrationEntryInfo> entryMap, BgSchemeDimensionHelper sourceHelper, BgSchemeDimensionHelper targetHelper) throws BOSException {
        BgSchemeIntegrationEntryInfo entry2 = null;
        HashMap<String, BgSchemeIntegrationEntryInfo> mbgDimViewIds = new HashMap<String, BgSchemeIntegrationEntryInfo>();
        for (BgSchemeIntegrationEntryInfo entry2 : entryMap.values()) {
            if (BgSchemeIntegrationSourceEnum.common.equals((Object)entry2.getSourceType())) continue;
            if (sourceHelper.getDimension(entry2.getDimNumber()) != null) {
                mbgDimViewIds.put(sourceHelper.getDimension(entry2.getDimNumber()).getViewId(), entry2);
                continue;
            }
            mbgDimViewIds.put(targetHelper.getDimension(entry2.getDimNumber()).getViewId(), entry2);
        }
        if (mbgDimViewIds.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", new HashSet(mbgDimViewIds.keySet()), CompareType.INCLUDE));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("isSystemDefault", (Object)Boolean.TRUE));
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("parent.id");
        evi.getSelector().add("viewId");
        MbgMemberCollection mbgDimMemberCol = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(evi);
        MbgMemberInfo member = null;
        for (int i = 0; i < mbgDimMemberCol.size(); ++i) {
            member = mbgDimMemberCol.get(i);
            entry2 = (BgSchemeIntegrationEntryInfo)mbgDimViewIds.get(member.getViewId().toString());
            if (member.getParent() == null || member.getId().equals((Object)member.getParent().getId())) {
                if (!BgSchemeIntegrationSourceEnum.source.equals((Object)entry2.getSourceType())) continue;
                entry2.getMembers().add(this.convertMemberInfo(entry2, member));
                continue;
            }
            if (!BgSchemeIntegrationSourceEnum.target.equals((Object)entry2.getSourceType())) continue;
            entry2.getMembers().add(this.convertMemberInfo(entry2, member));
        }
    }

    private BgSchemeIntegrationMemberInfo convertMemberInfo(BgSchemeIntegrationEntryInfo entry, MbgMemberInfo member) {
        BgSchemeIntegrationMemberInfo info = new BgSchemeIntegrationMemberInfo();
        info.setEntry(entry);
        info.setNumber(member.getNumber());
        info.setName(member.getName());
        return info;
    }

    private void processEntry(List<BgDimensionInfo> targetDimensions, List<String> sourceDimensions, Map<String, BgSchemeIntegrationEntryInfo> entryMap, BgSchemeIntegrationSourceEnum sourceType) {
        BgDimensionInfo dimension = null;
        BgSchemeIntegrationEntryInfo entryInfo = null;
        for (int d = 0; d < targetDimensions.size(); ++d) {
            dimension = targetDimensions.get(d);
            if (entryMap.containsKey(dimension.getNumber())) continue;
            entryInfo = new BgSchemeIntegrationEntryInfo();
            entryInfo.setMemberType(BgMemberSelectTypeEnum.Member);
            entryInfo.setDimName(dimension.getAlias());
            entryInfo.setDimNumber(dimension.getNumber());
            entryInfo.setSourceType(sourceType);
            if (sourceDimensions.contains(dimension.getNumber())) {
                entryInfo.setSourceType(BgSchemeIntegrationSourceEnum.common);
            }
            entryMap.put(entryInfo.getDimNumber(), entryInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _integrate(Context ctx, BOSUuid integrtionId, String bgPeriodNum, boolean confirmCleanData) throws BOSException, EASBizException {
        if (integrtionId == null) {
            return;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("sourceBgScheme.*");
        sic.add("targetBgScheme.*");
        sic.add("targetBgScheme.refCube");
        sic.add("notExecuteBizCalc.bgBizCalc.id");
        sic.add("orgUnit.id");
        sic.add("orgUnit.number");
        sic.add("orgUnit.name");
        sic.add("orgUnit.longNumber");
        sic.add("entries.*");
        sic.add("entries.members.*");
        sic.add("entries.memberMaps.*");
        BgSchemeIntegrationInfo integInfo = BgSchemeIntegrationFactory.getLocalInstance(ctx).getBgSchemeIntegrationInfo((IObjectPK)new ObjectUuidPK(integrtionId), sic);
        BgSchemeDimensionHelper sourceSchemeHelper = new BgSchemeDimensionHelper(ctx, integInfo.getSourceBgScheme().getId().toString());
        BgSchemeDimensionHelper targetSchemeHelper = new BgSchemeDimensionHelper(ctx, integInfo.getTargetBgScheme().getId().toString());
        HashMap<String, MbgViewListDimensionInfo> comDimmMap = new HashMap<String, MbgViewListDimensionInfo>();
        HashMap<String, MbgViewListDimensionInfo> sourceDimmMap = new HashMap<String, MbgViewListDimensionInfo>();
        HashMap<String, MbgViewListDimensionInfo> targetDimmMap = new HashMap<String, MbgViewListDimensionInfo>();
        this.buildDimension(integInfo, comDimmMap, sourceDimmMap, targetDimmMap, sourceSchemeHelper, targetSchemeHelper);
        List<BgDimensionInfo> allSourceDims = sourceSchemeHelper.getAllDimensions();
        for (int i = 0; i < allSourceDims.size(); ++i) {
            if (comDimmMap.containsKey(allSourceDims.get(i).getNumber()) || sourceDimmMap.containsKey(allSourceDims.get(i).getNumber())) continue;
            throw new BgSchemeIntegrationException(BgSchemeIntegrationException.DIMNOTEXISTSININTEGER, new Object[]{BgSchemeIntegrationSourceEnum.source, allSourceDims.get(i).getNumber()});
        }
        MbgViewListManager targetViewManager = this.buildDefaultViewListManager();
        MbgViewListDimensionManager targetDimensionManager = ((MbgViewListSheetManager)targetViewManager.getSheetManagers().get(0)).getDimensionManager();
        this.buildViewListManager(targetDimensionManager, comDimmMap, targetSchemeHelper);
        ViewListMemberParserServerHelper memberParser = new ViewListMemberParserServerHelper(ctx, targetSchemeHelper, integInfo.getOrgUnit().getId().toString());
        memberParser.parseMember(targetViewManager, true);
        this.removeActScenario(ctx, targetDimensionManager, targetSchemeHelper);
        this.removeCancel(ctx, targetDimensionManager, targetSchemeHelper, integInfo.getOrgUnit().getId().toString());
        HashMap<String, Map<String, Set<String>>> targetToSource = new HashMap<String, Map<String, Set<String>>>();
        HashMap<String, Map<String, Set<String>>> sourceToTarget = new HashMap<String, Map<String, Set<String>>>();
        MbgViewListDimensionManager sourceDimensionManager = null;
        if (!this.checkMemberEmpty(targetDimensionManager)) {
            MbgViewListManager sourceViewManager = DimensionCommonHelper.cloneViewManager(targetViewManager);
            sourceDimensionManager = ((MbgViewListSheetManager)sourceViewManager.getSheetManagers().get(0)).getDimensionManager();
            this.prepareMap(integInfo, targetToSource, sourceToTarget);
            this.convertMember(sourceDimensionManager, targetToSource);
            this.buildViewListManager(sourceDimensionManager, sourceDimmMap, sourceSchemeHelper);
            memberParser = new ViewListMemberParserServerHelper(ctx, sourceSchemeHelper, integInfo.getOrgUnit().getId().toString());
            memberParser.setReParsePeriod(true);
            memberParser.parseMember(sourceViewManager, false);
            DimensionFilterHelper filterHelper = DimensionFilterHelper.getLocaleIntance(ctx, sourceSchemeHelper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), integInfo.getOrgUnit().getId().toString(), sourceSchemeHelper.getBgSchemeId(), null, null);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.setFilter(filterHelper.getFilter());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)integInfo.getTargetBgScheme().getDateFrom(), CompareType.GREATER_EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)integInfo.getTargetBgScheme().getDateTo(), CompareType.LESS_EQUALS));
            BgPeriodDispCollection col = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi);
            HashSet<String> pNumbers = new HashSet<String>();
            for (int i = 0; i < col.size(); ++i) {
                pNumbers.add(col.get(i).getNumber());
            }
            MbgViewListDimensionInfo periodDim = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, sourceDimensionManager.getAllDimensions());
            for (int i = periodDim.getMember().size() - 1; i >= 0; --i) {
                if (pNumbers.contains(BgViewHelper.getNumber(periodDim.getMember().get(i)))) continue;
                periodDim.getMember().remove(i);
            }
            this.addIntegrationId4RefTable(ctx, integInfo.getTargetBgScheme().getRefCube());
            if (confirmCleanData) {
                BgSchemeIntegrationCollection colls = new BgSchemeIntegrationCollection();
                colls.add(integInfo);
                this.dealIntegrationData(ctx, colls);
            }
            List<BOSUuid> executeCalcList = this.getExecuteCalcList(ctx, integInfo, sourceSchemeHelper.getBgSchemeId());
            if (!this.checkMemberEmpty(sourceDimensionManager)) {
                IDimensionParameter parameter = this.transDimParameter(ctx, sourceViewManager, integInfo, bgPeriodNum);
                parameter.getControlManager().setHasQueryDataState(false);
                if (parameter.getDataManager().getMbgDims().isEmpty()) {
                    for (int i = 0; i < parameter.getDataManager().getDimensions().size(); ++i) {
                        parameter.getDataManager().getMbgDims().put(parameter.getDataManager().getDimensions().get(i).getRefField(), parameter.getDataManager().getDimensions().get(i));
                    }
                }
                if (executeCalcList != null && !executeCalcList.isEmpty()) {
                    parameter.setCalcIds(executeCalcList);
                } else {
                    parameter.getControlManager().setHasCalcBiz(false);
                }
                Map<String, Map<String, Set<String>>> bizCalcRelation = null;
                try {
                    bizCalcRelation = this.bizCalcRelation(ctx, parameter, sourceSchemeHelper);
                }
                catch (ParseException e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                Map<String, Map<String, Set<String>>> bizParentMap = null;
                if (bizCalcRelation != null && !bizCalcRelation.isEmpty()) {
                    bizParentMap = this.queryParent(ctx, parameter, sourceSchemeHelper, bizCalcRelation);
                }
                Connection conn = null;
                int poolSize = 1;
                try {
                    conn = this.getConnection(ctx);
                    int MAX_COUNT = this.loadMaxCount(conn);
                    DbUtil.execute((Context)ctx, (String)"Delete T_MBG_BgSchemeIntegrationRpt Where FIntegrationID = ?", (Object[])new Object[]{integrtionId.toString()});
                    BgSchemeIntegerParameter integrateParameter = new BgSchemeIntegerParameter();
                    integrateParameter.bizCalcRelation = bizCalcRelation;
                    integrateParameter.bizParentMap = bizParentMap;
                    integrateParameter.integrtionId = integrtionId;
                    integrateParameter.MAX_COUNT = MAX_COUNT;
                    integrateParameter.orgDimension = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, sourceDimensionManager);
                    integrateParameter.parameter = parameter;
                    integrateParameter.poolSize = poolSize;
                    integrateParameter.sourceDimensionManager = sourceDimensionManager;
                    integrateParameter.sourceSchemeHelper = sourceSchemeHelper;
                    integrateParameter.sourceToTarget = sourceToTarget;
                    integrateParameter.targetToSource = targetToSource;
                    integrateParameter.targetDimensionManager = targetDimensionManager;
                    integrateParameter.targetDimmMap = targetDimmMap;
                    integrateParameter.targetSchemeHelper = targetSchemeHelper;
                    this.queryBgData(ctx, conn, integrateParameter, parameter, integrateParameter.orgDimension, sourceSchemeHelper, poolSize, MAX_COUNT, bizCalcRelation, bizParentMap);
                    DbUtil.execute((Context)ctx, (String)"Update T_MBG_BgSchemeIntegration Set FState = ? Where FID = ?", (Object[])new Object[]{4, integrtionId.toString()});
                }
                finally {
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
    }

    private void removeActScenario(Context ctx, MbgViewListDimensionManager targetDimensionManager, BgSchemeDimensionHelper targetSchemeHelper) throws BOSException {
        Set bgScenarioSet = BgScenarioHelper.getBgScenNums((Context)ctx);
        List<MbgViewListDimensionInfo> dimensions = targetDimensionManager.getAllDimensions();
        MbgViewListDimensionInfo dimension = null;
        BgDimensionMember member = null;
        for (int d = 0; d < dimensions.size(); ++d) {
            if (!(dimensions.get(d) instanceof MbgViewListDimensionInfo) || !DimensionConstants.DEF_SCENARIO_NUMBER.equals((dimension = dimensions.get(d)).getNumber())) continue;
            Iterator it = dimension.getMember().iterator();
            while (it.hasNext()) {
                member = (BgDimensionMember)it.next();
                if (bgScenarioSet.contains(member.getNumber())) continue;
                it.remove();
            }
        }
    }

    private int loadMaxCount(Connection conn) throws BOSException {
        IRowSet rst;
        int MAX_COUNT;
        block6: {
            MAX_COUNT = 50000000;
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{"MAX_COUNT"});
                if (!rst.next()) break block6;
                try {
                    MAX_COUNT = Integer.parseInt(rst.getString("FVALUE"));
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        MbgLoggerUtils.logger((String)("Load Max Count = " + MAX_COUNT));
        return MAX_COUNT;
    }

    private Map<String, Map<String, Set<String>>> bizCalcRelation(Context ctx, IDimensionParameter parameter, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException, ParseException {
        return DimUtils.bizCalcRelation(ctx, parameter, schemeHelper);
    }

    private Map<String, Map<String, Set<String>>> queryParent(Context ctx, IDimensionParameter parameter, BgSchemeDimensionHelper sourceSchemeHelper, Map<String, Map<String, Set<String>>> bizCalcRelation) throws BOSException {
        return DimUtils.queryParent(ctx, parameter, sourceSchemeHelper, bizCalcRelation);
    }

    @Override
    protected List _getExecuteCalcList(Context ctx, String bgSchemeInteId) throws BOSException, EASBizException {
        BgSchemeIntegrationInfo info = BgSchemeIntegrationFactory.getLocalInstance(ctx).getBgSchemeIntegrationInfo("select sourceBgScheme.id, notExecuteBizCalc.bgBizCalc.id where id = '" + bgSchemeInteId + "'");
        return this._getExecuteCalcList(ctx, (IObjectValue)info);
    }

    @Override
    protected List _getExecuteCalcList(Context ctx, IObjectValue bgSchemeInteInfo) throws BOSException, EASBizException {
        BgSchemeIntegrationInfo info = (BgSchemeIntegrationInfo)bgSchemeInteInfo;
        ArrayList<String> result = new ArrayList<String>();
        List<BOSUuid> ids = this.getExecuteCalcList(ctx, info, info.getSourceBgScheme().getId().toString());
        if (ids != null && !ids.isEmpty()) {
            for (BOSUuid id : ids) {
                result.add(id.toString());
            }
        }
        return result;
    }

    private List<BOSUuid> getExecuteCalcList(Context ctx, BgSchemeIntegrationInfo integInfo, String bgSchemeId) throws BOSException, EASBizException {
        BgNotExecuteBizCalcInfo bgNotExecuteBizCalcInfo = null;
        BizCalcInfo bgBizCalc = null;
        ArrayList<BOSUuid> calcList = new ArrayList<BOSUuid>();
        int in = integInfo.getNotExecuteBizCalc().size();
        for (int i = 0; i < in; ++i) {
            bgNotExecuteBizCalcInfo = integInfo.getNotExecuteBizCalc().get(i);
            bgBizCalc = bgNotExecuteBizCalcInfo.getBgBizCalc();
            if (bgBizCalc == null) continue;
            calcList.add(bgBizCalc.getId());
        }
        List<BOSUuid> sourceSchemeBizCalc = this.getSourceSchemeBizCalc(ctx, bgSchemeId);
        sourceSchemeBizCalc.removeAll(calcList);
        return sourceSchemeBizCalc;
    }

    private List<BOSUuid> getSourceSchemeBizCalc(Context ctx, String bgSchemeId) throws EASBizException, BOSException {
        LinkedList<BOSUuid> list = new LinkedList<BOSUuid>();
        StringBuffer sql = new StringBuffer();
        sql.append("select BIZCALC.FID,BIZCALC.FNumber,BIZCALC.FName_").append(ctx.getLocale()).append(" from T_MBG_BizCalc BIZCALC inner join T_MBG_BgScheme scheme on BIZCALC.FBgSchemeID = scheme.FID").append(" where BIZCALC.FState = ").append(2).append(" and scheme.FID = '").append(bgSchemeId).append("'").append(" and FOrgTreeID is null");
        try {
            IRowSet result = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (result.next()) {
                list.add(BOSUuid.read((String)result.getString("FID")));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return list;
    }

    private void addIntegrationId4RefTable(Context ctx, String refCube) throws EASBizException, BOSException {
        StringBuffer DDl_Sql = new StringBuffer();
        DDl_Sql.append("IF NOT EXISTS(SELECT * from KSQL_USERCOLUMNS WHERE KSQL_COL_NAME ='FIntegrationId' and KSQL_COL_TABNAME='").append(refCube).append("')").append(" Alter Table ").append(refCube).append(" add FIntegrationId Varchar(44)");
        try {
            String splitCube = BgSchemeConvertToAccIntUtils.getSplitCube(refCube);
            if (BgDBUtils.existTable((Context)ctx, (String)splitCube) == BgDBUtils.YES) {
                return;
            }
            BgDBUtils.executeUpdate((Context)ctx, (String)DDl_Sql.toString());
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void removeCancel(Context ctx, MbgViewListDimensionManager dimensionManager, BgSchemeDimensionHelper targetSchemeHelper, String orgId) {
        List<MbgViewListDimensionInfo> dimensions = dimensionManager.getAllDimensions();
        MbgViewListDimensionInfo dimension = null;
        DimensionFilterHelper filterHelper = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            dimension = dimensions.get(i);
            filterHelper = DimensionFilterHelper.getLocaleIntance(ctx, targetSchemeHelper.getDimension(dimension.getNumber()), orgId, targetSchemeHelper.getBgSchemeId(), null, null);
            Iterator it = dimension.getMember().iterator();
            while (it.hasNext()) {
                if (!filterHelper.isCancel(((BgDimensionMember)it.next()).getNumber())) continue;
                it.remove();
            }
        }
    }

    private void saveReport(Context ctx, BOSUuid integrtionId, List<ReportData> reportList, BgSchemeDimensionHelper targetSchemeHelper, BgSchemeDimensionHelper sourceSchemeHelper, Map<String, Map<String, BgDimensionMember>> targetDimensionMemberMap, Map<String, Map<String, BgDimensionMember>> sourceDimensionMemberMap) throws BOSException {
        if (reportList == null || reportList.isEmpty()) {
            return;
        }
        HashMap<String, BgDimensionMember> orgMap = new HashMap<String, BgDimensionMember>();
        BgDimensionMember member2 = null;
        ArrayList<BgDimensionMember> orgMembers = new ArrayList<BgDimensionMember>();
        orgMembers.addAll(targetDimensionMemberMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER).values());
        orgMembers.addAll(sourceDimensionMemberMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER).values());
        for (BgDimensionMember member2 : orgMembers) {
            orgMap.put(member2.getAttribute(), member2);
        }
        String sql = "Insert Into T_MBG_BgSchemeIntegrationRpt(FID, FIntegrationID, FOrgUnitID, FOrgUnitNumber, FOrgUnitName, FFormula, FAccountNumber, FAccountName, FOtherNumber, FOtherName, FBgScenarioNumber, FBgScenarioName, FBgVersionNumber, FBgVersionName, FBgElementNumber, FBgElementName, FBgPeriodNumber, FBgPeriodName, FCurrencyNumber, FCurrecnyName, FSourceOrgUnitID, FSourceOrgUnitNumber, FSourceOrgUnitName, FSourceFormula, FSourceAccountNumber, FSourceAccountName, FSourceOtherNumber, FSourceOtherName, FSourceBgScenarioNumber, FSourceBgScenarioName, FSourceBgVersionNumber, FSourceBgVersionName, FSourceBgElementNumber, FSourceBgElementName, FSourceBgPeriodNumber, FSourceBgPeriodName, FSourceCurrencyNumber, FSourceCurrecnyName, FValue, FCreatorID, FCreateTime, FLastUpdateUserID, FLastUpdateTime, FSourceValue)  values(newbosid('" + new BgSchemeIntegrationReportInfo().getBOSType() + "'),?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        ReportData reportData = null;
        String userId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Map<String, BgDimensionInfo> targetSrcDims = targetSchemeHelper.getDimensionBySrcNumber();
        Map<String, BgDimensionInfo> sourceSrcDims = sourceSchemeHelper.getDimensionBySrcNumber();
        int index = 0;
        for (int i = 0; i < reportList.size(); ++i) {
            reportData = reportList.get(i);
            if (!reportData.targetData.isSaved()) continue;
            for (int s = 0; s < reportData.sourceDatas.size(); ++s) {
                index = 0;
                params = new Object[43];
                params[index++] = integrtionId.toString();
                index = this.setParams(params, index, reportData.targetData, orgMap, targetDimensionMemberMap, targetSrcDims);
                index = this.setParams(params, index, reportData.sourceDatas.get(s), orgMap, sourceDimensionMemberMap, sourceSrcDims);
                params[index++] = reportData.targetData.getValue() == null ? Integer.valueOf(0) : reportData.targetData.getValue();
                params[index++] = userId;
                params[index++] = now;
                params[index++] = userId;
                params[index++] = now;
                params[index++] = reportData.sourceDatas.get(s).getValue() == null ? Integer.valueOf(0) : reportData.sourceDatas.get(s).getValue();
                paramList.add(params);
            }
        }
        DbUtil.executeBatch((Context)ctx, (String)sql, paramList);
    }

    private int setParams(Object[] params, int index, ICalcData calcData, Map<String, BgDimensionMember> orgMap, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, Map<String, BgDimensionInfo> srcDims) {
        params[index++] = calcData.getOrgUnitId();
        params[index++] = orgMap.get(calcData.getOrgUnitId()).getNumber();
        params[index++] = orgMap.get(calcData.getOrgUnitId()).getName();
        params[index++] = calcData.getFormula();
        index = this.convertExtParam(params, calcData.getFormula(), dimensionMemberMap, srcDims, index);
        params[index++] = calcData.getBgScenarioNumber();
        params[index++] = this.getMemberName(dimensionMemberMap, DimensionConstants.DEF_SCENARIO_NUMBER, calcData.getBgScenarioNumber());
        params[index++] = calcData.getBgVersionNumber();
        params[index++] = this.getMemberName(dimensionMemberMap, DimensionConstants.DEF_VERSION_NUMBER, calcData.getBgVersionNumber());
        params[index++] = calcData.getBgElementNumber();
        params[index++] = this.getMemberName(dimensionMemberMap, DimensionConstants.DEF_ELEMENT_NUMBER, calcData.getBgElementNumber());
        params[index++] = calcData.getBgPeriodNumber();
        params[index++] = this.getMemberName(dimensionMemberMap, DimensionConstants.DEF_PERIOD_NUMBER, calcData.getBgPeriodNumber());
        params[index++] = calcData.getCurrencyNumber();
        params[index++] = this.getMemberName(dimensionMemberMap, DimensionConstants.DEF_CURRENCY_NUMBER, calcData.getCurrencyNumber());
        return index;
    }

    private String getMemberName(Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, String dimNumber, String number) {
        return dimensionMemberMap.get(dimNumber).get(number).getName();
    }

    private int convertExtParam(Object[] params, String formula, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, Map<String, BgDimensionInfo> srcDims, int index) {
        if (!StringUtils.isEmpty((String)formula)) {
            String[] itemNumbers = DimensionFormulaHelper.splitCombinations(BgNFSHelper.parseFormulaPara(formula)[0]);
            StringBuffer otherNumber = new StringBuffer();
            StringBuffer otherName = new StringBuffer();
            String srcNumber = null;
            String number = null;
            for (int i = 0; i < itemNumbers.length; ++i) {
                srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
                number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]);
                if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) {
                    params[index] = number;
                    params[index + 1] = this.getMemberName(dimensionMemberMap, srcDims.get(srcNumber).getNumber(), number);
                    continue;
                }
                if (otherNumber.length() > 0) {
                    otherNumber.append(",");
                    otherName.append(DimensionConstants.TICK_SEPARATOR);
                }
                otherNumber.append(number);
                otherName.append(this.getMemberName(dimensionMemberMap, srcDims.get(srcNumber).getNumber(), number));
            }
            if (otherNumber.length() > 0) {
                params[index + 2] = otherNumber.toString();
                params[index + 3] = otherName.toString();
            }
        }
        return index + 4;
    }

    private List<ReportData> saveData(Context ctx, Map<String, Map<String, BgNDataInfo>> sourceDataMap, BgSchemeDimensionHelper targetSchemeHelper, Map<String, Map<String, Set<String>>> sourceToTarget, Map<String, Map<String, Set<String>>> targetToSource, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, Map<Integer, String> refNumber, BOSUuid integrtionId) throws EASBizException, BOSException {
        ArrayList<ReportData> reportList = new ArrayList<ReportData>();
        Map<String, BgDimensionMember> orgMemberMap = dimensionMemberMap.get(DimensionConstants.DEF_ORGUNIT_NUMBER);
        FormulaProcessor processor = new FormulaProcessor();
        processor.scenarioMap = BgScenarioHelper.getScenariooObjMap((Context)ctx);
        processor.versionMap = BgVersionHelper.getVersionObjMap((Context)ctx);
        String sourceOrgNumber2 = null;
        BgDimensionMember targetOrgMember = null;
        HashSet<String> targetOrgMembers = new HashSet<String>();
        HashMap<Integer, Set<String>> targetMemberMap = new HashMap<Integer, Set<String>>();
        HashMap<Integer, String> fieldSrcNumbers = new HashMap<Integer, String>();
        String srcNumber2 = null;
        for (String srcNumber2 : targetSchemeHelper.getSrcNumbers()) {
            fieldSrcNumbers.put(DimensionCommonHelper.getField(targetSchemeHelper.getRefFieldBySrcNumber(srcNumber2)), srcNumber2);
        }
        for (String sourceOrgNumber2 : sourceDataMap.keySet()) {
            this.convertMapInfo(targetOrgMembers, DimensionConstants.DEF_ORGUNIT_NUMBER, sourceOrgNumber2, sourceToTarget, targetToSource);
            Iterator itTarget = targetOrgMembers.iterator();
            while (itTarget.hasNext()) {
                targetOrgMember = orgMemberMap.get(itTarget.next());
                if (targetOrgMember == null) continue;
                processor.orgId = targetOrgMember.getAttribute();
                Iterator<BgNDataInfo> itData = sourceDataMap.get(sourceOrgNumber2).values().iterator();
                while (itData.hasNext()) {
                    this.convertData(fieldSrcNumbers, targetOrgMember, itData.next(), sourceToTarget, targetToSource, targetSchemeHelper, targetMemberMap, refNumber, processor, dimensionMemberMap);
                }
            }
        }
        BgSchemeInfo bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, BOSUuid.read((String)targetSchemeHelper.getBgSchemeId()));
        String orgId2 = null;
        ReportData reportData2 = null;
        for (String orgId2 : processor.targetMap.keySet()) {
            if (processor.targetMap.get(orgId2).isEmpty()) continue;
            MbgDataFacadeImpl dataFacade = new MbgDataFacadeImpl();
            dataFacade.setCtx(ctx);
            dataFacade.setOrgUnitId(BOSUuid.read((String)orgId2));
            dataFacade.setBgScheme(bgSchemeInfo);
            dataFacade.setBgSchemeIntegrationId(integrtionId);
            dataFacade.setOnlyEditState(true);
            if (processor.targetMap.get(orgId2).isEmpty()) continue;
            for (ReportData reportData2 : processor.targetMap.get(orgId2).values()) {
                dataFacade.addMbgData(reportData2.targetData);
                reportList.add(reportData2);
            }
            dataFacade.save();
        }
        return reportList;
    }

    private void convertMapInfo(Collection<String> result, String dimNumber, String sourceNumber, Map<String, Map<String, Set<String>>> sourceToTarget, Map<String, Map<String, Set<String>>> targetToSource) {
        result.clear();
        if (sourceToTarget != null && sourceToTarget.containsKey(dimNumber) && sourceToTarget.get(dimNumber).containsKey(sourceNumber)) {
            result.addAll((Collection<String>)sourceToTarget.get(dimNumber).get(sourceNumber));
        } else if (targetToSource != null && targetToSource.containsKey(dimNumber) && targetToSource.get(dimNumber).containsKey(sourceNumber)) {
            result.add("000000000000000000000000000=");
        } else {
            result.add(sourceNumber);
        }
    }

    private void convertMapInfo(Map<Integer, Set<String>> targetMemberMap, String dimNumber, String sourceNumber, Map<String, Map<String, Set<String>>> sourceToTarget, Map<String, Map<String, Set<String>>> targetToSource, BgSchemeDimensionHelper targetSchemeHelper) {
        Integer field = DimensionCommonHelper.getField(targetSchemeHelper.getRefField(dimNumber));
        if (!targetMemberMap.containsKey(field)) {
            targetMemberMap.put(field, new HashSet());
        }
        this.convertMapInfo((Collection<String>)targetMemberMap.get(field), dimNumber, sourceNumber, sourceToTarget, targetToSource);
    }

    private void convertData(Map<Integer, String> fieldSrcNumbers, BgDimensionMember orgMember, BgNDataInfo sourceData, Map<String, Map<String, Set<String>>> sourceToTarget, Map<String, Map<String, Set<String>>> targetToSource, BgSchemeDimensionHelper targetSchemeHelper, Map<Integer, Set<String>> targetMemberMap, Map<Integer, String> refNumber, FormulaProcessor processor, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap) {
        processor.sourceData = sourceData;
        if (processor.sourceData.getBudgetValue() == null) {
            return;
        }
        sourceData.splitFormula();
        this.convertMapInfo(targetMemberMap, DimensionConstants.DEF_VERSION_NUMBER, sourceData.getBgVersion(), sourceToTarget, targetToSource, targetSchemeHelper);
        this.convertMapInfo(targetMemberMap, DimensionConstants.DEF_PERIOD_NUMBER, sourceData.getBgPeriodNumber(), sourceToTarget, targetToSource, targetSchemeHelper);
        this.convertMapInfo(targetMemberMap, DimensionConstants.DEF_ELEMENT_NUMBER, sourceData.getBgElementNumber(), sourceToTarget, targetToSource, targetSchemeHelper);
        this.convertMapInfo(targetMemberMap, DimensionConstants.DEF_CURRENCY_NUMBER, sourceData.getCurrencyNumber(), sourceToTarget, targetToSource, targetSchemeHelper);
        this.convertMapInfo(targetMemberMap, DimensionConstants.DEF_SCENARIO_NUMBER, sourceData.getBgScenario(), sourceToTarget, targetToSource, targetSchemeHelper);
        String[] items = DimensionFormulaHelper.splitCombinations(sourceData.getBgItemNumber());
        String srcNumber = null;
        String number = null;
        for (int i = 0; i < items.length; ++i) {
            srcNumber = DimensionFormulaHelper.getSrcNumber(items[i]);
            number = DimensionFormulaHelper.getMemberNumber(items[i]);
            if (!targetSchemeHelper.getSrcNumbers().contains(srcNumber)) continue;
            this.convertMapInfo(targetMemberMap, targetSchemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber(), number, sourceToTarget, targetToSource, targetSchemeHelper);
        }
        this.buildFormula(targetMemberMap.keySet().toArray(new Integer[0]), fieldSrcNumbers, 0, targetMemberMap, refNumber, processor, dimensionMemberMap, targetSchemeHelper);
    }

    private void buildFormula(Integer[] fields, Map<Integer, String> fieldSrcNumbers, int index, Map<Integer, Set<String>> targetMemberMap, Map<Integer, String> refNumber, BgViewHelper.IFormulaProcessor processor, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, BgSchemeDimensionHelper targetSchemeHelper) {
        if (index >= fields.length) {
            if (this.checkMember(refNumber, dimensionMemberMap, targetSchemeHelper, fieldSrcNumbers)) {
                BgViewHelper.buildFormula(refNumber, processor);
            }
            return;
        }
        Integer field = fields[index];
        String number2 = null;
        for (String number2 : targetMemberMap.get(field)) {
            refNumber.put(field, DimensionFormulaHelper.getCombination(fieldSrcNumbers.get(field), number2));
            this.buildFormula(fields, fieldSrcNumbers, index + 1, targetMemberMap, refNumber, processor, dimensionMemberMap, targetSchemeHelper);
        }
    }

    private boolean checkMember(Map<Integer, String> refNumber, Map<String, Map<String, BgDimensionMember>> dimensionMemberMap, BgSchemeDimensionHelper targetSchemeHelper, Map<Integer, String> fieldSrcNumbers) {
        Integer field2 = null;
        String number = null;
        for (Integer field2 : refNumber.keySet()) {
            number = DimensionFormulaHelper.getMemberNumber(refNumber.get(field2));
            if (dimensionMemberMap.get(targetSchemeHelper.getDimensionByRefField().get("F" + field2).getNumber()).containsKey(number)) continue;
            return false;
        }
        return true;
    }

    private Map<String, Map<String, BgDimensionMember>> convertToMemberMap(MbgViewListDimensionManager dimensionManager) {
        HashMap<String, Map<String, BgDimensionMember>> resultMap = new HashMap<String, Map<String, BgDimensionMember>>();
        Map tmpMap = null;
        BgDimensionMember member2 = null;
        MbgViewListDimensionInfo dimension = null;
        List<MbgViewListDimensionInfo> allDims = dimensionManager.getAllDimensions();
        for (int i = 0; i < allDims.size(); ++i) {
            dimension = allDims.get(i);
            if (!resultMap.containsKey(dimension.getNumber())) {
                resultMap.put(dimension.getNumber(), new HashMap());
            }
            tmpMap = (Map)resultMap.get(dimension.getNumber());
            for (BgDimensionMember member2 : dimension.getMember()) {
                tmpMap.put(member2.getNumber(), member2);
            }
        }
        return resultMap;
    }

    private Map queryBgData(Context ctx, Connection conn, BgSchemeIntegerParameter integrateParameter, IDimensionParameter parameter, MbgViewListDimensionInfo orgDimension, BgSchemeDimensionHelper sourceSchemeHelper, int poolSize, int MAX_COUNT, Map<String, Map<String, Set<String>>> bizCalcRelation, Map<String, Map<String, Set<String>>> bizParentMap) throws BOSException, EASBizException {
        HashMap dataMap = new HashMap();
        IDimension _orgDim = parameter.getDimensionMap().get(DimensionConstants.DEF_ORGUNIT_NUMBER);
        BgDimensionMember orgMember2 = null;
        IMember _orgMember = null;
        HashSet<String> orgNumbers = new HashSet<String>();
        HashSet<String> orgUnitIds = new HashSet<String>();
        for (BgDimensionMember orgMember2 : orgDimension.getMember()) {
            orgNumbers.add(orgMember2.getNumber());
            orgUnitIds.add(orgMember2.getAttribute());
        }
        Map<String, OrgUnitInfo> orgUnitMap = MbgDataHelper.getOrgUnitByNumber(ctx, orgNumbers);
        Map<String, BgOrgUnitInfo> bgOrgUnitMap = MbgDataHelper.getBgOrgUnitMap(ctx, parameter.getBgOrgViewId(), orgUnitIds);
        HashSet<String> hasQueryOrgNumbers = new HashSet<String>();
        boolean count = false;
        for (BgDimensionMember orgMember2 : orgDimension.getMember()) {
            _orgDim.clearMember();
            _orgMember = DimUtils.transDimMember(orgMember2);
            _orgMember.setMdxNumber((String)((Object)orgMember2.getSortValue()));
            _orgDim.addMember(_orgMember);
            parameter.setOrgUnitId(BOSUuid.read((String)orgMember2.getAttribute()));
            parameter.getDataManager().setOrgUnit(orgUnitMap.get(_orgMember.getNumber()));
            parameter.getDataManager().setBgOrgUnit(bgOrgUnitMap.get(parameter.getOrgUnitId().toString()));
            if (hasQueryOrgNumbers.contains(orgMember2.getNumber())) continue;
            hasQueryOrgNumbers.add(orgMember2.getNumber());
            Set<String> qeryOrgIds = this.getMultiQueryOrgIds(integrateParameter, orgMember2.getNumber(), hasQueryOrgNumbers, orgUnitMap);
            if (qeryOrgIds.size() > 1) {
                parameter.setQeryOrgIds(qeryOrgIds);
                for (BgDimensionMember member : orgDimension.getMember()) {
                    if (member.getAttribute().equals(orgMember2.getAttribute()) || !qeryOrgIds.contains(member.getAttribute())) continue;
                    IMember _member = DimUtils.transDimMember(member);
                    _member.setMdxNumber((String)((Object)orgMember2.getSortValue()));
                    _orgDim.addMember(_member);
                }
            } else {
                parameter.setQeryOrgIds(null);
            }
            MbgLoggerUtils.logger((String)("Start queryOnOrgData " + parameter.getOrgUnitId() + " " + (orgDimension.getMember().indexOf(orgMember2) + 1) + "/" + orgDimension.getMember().size()));
            BgSchemeIntegrationFacadeFactory.getLocalInstance(ctx).integrateOneOrg(integrateParameter);
        }
        return dataMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _integrateOneOrg(Context ctx, BgSchemeIntegerParameter integParameter) throws BOSException, EASBizException {
        Connection conn = null;
        HashMap<String, Map<String, BgNDataInfo>> dataMap = new HashMap<String, Map<String, BgNDataInfo>>();
        try {
            conn = this.getConnection(ctx);
            Map<String, BgNViewDataInfo> _tmpMap = null;
            Map _valueMap = null;
            long st = System.currentTimeMillis();
            _tmpMap = this.queryOnOrgData(ctx, conn, integParameter.parameter, integParameter.poolSize, integParameter.MAX_COUNT, integParameter.sourceSchemeHelper, integParameter.bizCalcRelation, integParameter.bizParentMap);
            int dataCount = 0;
            if (_tmpMap != null && _tmpMap.get(integParameter.parameter.getOrgUnitId().toString()) instanceof Map) {
                dataCount = ((Map)((Object)_tmpMap.get(integParameter.parameter.getOrgUnitId().toString()))).size();
            }
            MbgLoggerUtils.logger((String)("End queryOnOrgData " + integParameter.parameter.getOrgUnitId() + " (" + dataCount + ") " + (System.currentTimeMillis() - st) + " ms"));
            if (_tmpMap != null && !_tmpMap.isEmpty()) {
                for (String orgId : _tmpMap.keySet()) {
                    _valueMap = (Map)((Object)_tmpMap.get(orgId));
                    if (_valueMap.isEmpty()) continue;
                    Iterator it = _valueMap.values().iterator();
                    while (it.hasNext()) {
                        ((BgNDataInfo)it.next()).setOrgUnitId(orgId);
                    }
                    if (StringUtils.isEmpty((String)this.getOrgNumber(orgId, integParameter))) continue;
                    dataMap.put(this.getOrgNumber(orgId, integParameter), _valueMap);
                }
            }
            List<ReportData> reportList = null;
            if (dataMap != null && !dataMap.isEmpty()) {
                HashMap<Integer, String> refNumbers = new HashMap<Integer, String>();
                MbgViewListDimensionInfo dimension2 = null;
                Map<String, Map<String, BgDimensionMember>> targetDimensionMemberMap = this.convertToMemberMap(integParameter.targetDimensionManager);
                Map<String, Map<String, BgDimensionMember>> sourceDimensionMemberMap = this.convertToMemberMap(integParameter.sourceDimensionManager);
                for (MbgViewListDimensionInfo dimension2 : integParameter.targetDimmMap.values()) {
                    targetDimensionMemberMap.put(dimension2.getNumber(), new HashMap());
                    targetDimensionMemberMap.get(dimension2.getNumber()).put(((BgDimensionMember)dimension2.getSelectMembers().get(0)).getNumber(), (BgDimensionMember)dimension2.getSelectMembers().get(0));
                    refNumbers.put(DimensionCommonHelper.getField(integParameter.targetSchemeHelper.getRefField(dimension2.getNumber())), DimensionFormulaHelper.getCombination(integParameter.targetSchemeHelper.getSrcNumber(dimension2.getNumber()), ((BgDimensionMember)dimension2.getSelectMembers().get(0)).getNumber()));
                }
                reportList = this.saveData(ctx, dataMap, integParameter.targetSchemeHelper, integParameter.sourceToTarget, integParameter.targetToSource, targetDimensionMemberMap, refNumbers, integParameter.integrtionId);
                this.saveReport(ctx, integParameter.integrtionId, reportList, integParameter.targetSchemeHelper, integParameter.sourceSchemeHelper, targetDimensionMemberMap, sourceDimensionMemberMap);
            }
            MbgLoggerUtils.logger((String)("End SaveOnOrgData " + integParameter.parameter.getOrgUnitId() + " (" + dataCount + ") " + (System.currentTimeMillis() - st) + " ms"));
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<String, BgNViewDataInfo> queryOnOrgData(Context ctx, Connection conn, IDimensionParameter parameter, int poolSize, int MAX_COUNT, BgSchemeDimensionHelper sourceSchemeHelper, Map<String, Map<String, Set<String>>> bizCalcRelation, Map<String, Map<String, Set<String>>> bizParentMap) throws EASBizException, BOSException {
        Set<String> queryOrgIds = parameter.getQueryOrgIds();
        parameter = parameter.getClone(ctx);
        parameter.setQeryOrgIds(queryOrgIds);
        IDimension indexDim = parameter.getBgIndexDimension();
        Object dim = null;
        long otherCount = this.calDataSize(parameter);
        if (otherCount == 0L) {
            return new HashMap<String, BgNViewDataInfo>();
        }
        logger.error((Object)("queryOnOrgData total count:" + otherCount));
        IRowSet rst = null;
        try {
            String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)parameter.getBgOrgViewId());
            String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, sourceSchemeHelper, parameter.getDataManager().getBgScheme().getRefCube());
            Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
            boolean hasData = false;
            for (String string : cubeNames) {
                String idStr;
                if (accIntHelper.isUseAccInt()) {
                    if (queryOrgIds != null && queryOrgIds.size() > 1) {
                        idStr = "('" + StringUtils.arrayToString((Object[])queryOrgIds.toArray(), (String)"','") + "')";
                        rst = DbUtil.executeQuery((Context)ctx, (String)("Select Top 1 FID FROM " + string + " Where ForgUnitId IN(Select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FIsVirtual = 0 AND FOrgUnitId IN(select t.FChildID from " + mbgOrgClosure + " t where t.FID in " + idStr + "))"), (Object[])new Object[]{sourceSchemeHelper.getBgOrgViewId()});
                    } else {
                        rst = DbUtil.executeQuery((Context)ctx, (String)("Select Top 1 FID FROM " + string + " Where ForgUnitId IN(Select FIntId FROM T_MBG_BgOrgUnit Where FViewId = ? AND FIsVirtual = 0 AND FOrgUnitId IN(select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?))"), (Object[])new Object[]{sourceSchemeHelper.getBgOrgViewId(), parameter.getOrgUnitId().toString()});
                    }
                } else if (queryOrgIds != null && queryOrgIds.size() > 1) {
                    idStr = "('" + StringUtils.arrayToString((Object[])queryOrgIds.toArray(), (String)"','") + "')";
                    rst = DbUtil.executeQuery((Context)ctx, (String)("Select Top 1 FID FROM " + string + " Where ForgUnitId IN(select t.FChildID from " + mbgOrgClosure + " t where t.FID in " + idStr + ")"));
                } else {
                    rst = DbUtil.executeQuery((Context)ctx, (String)("Select Top 1 FID FROM " + string + " Where ForgUnitId IN(select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)"), (Object[])new Object[]{parameter.getOrgUnitId().toString()});
                }
                if (rst.next()) {
                    hasData = true;
                    break;
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            if (!hasData) {
                HashMap hashMap = new HashMap();
                return hashMap;
            }
            if (otherCount > (long)(MAX_COUNT * 2)) {
                Map<String, Set<String>> dataMembers = MbgQingAnalyseHelper.queryAllMemberofData(ctx, conn, parameter);
                if (dataMembers == null || dataMembers.isEmpty()) {
                    HashMap<String, BgNViewDataInfo> hashMap = new HashMap<String, BgNViewDataInfo>();
                    return hashMap;
                }
                if (bizCalcRelation != null && !bizCalcRelation.isEmpty()) {
                    Set<String> set = null;
                    HashSet numbers = new HashSet();
                    String[] subDatas = null;
                    Map<String, Set<String>> subBiz = null;
                    Map<String, Set<String>> subParent = null;
                    for (String field : bizCalcRelation.keySet()) {
                        if (dataMembers.get(field) == null) continue;
                        subDatas = dataMembers.get(field).toArray(new String[0]);
                        subBiz = bizCalcRelation.get(field);
                        subParent = bizCalcRelation.get(field);
                        for (String number : subDatas) {
                            this.buildTarget(number, subBiz, subParent, set);
                        }
                    }
                }
                Map<String, IDimension> map = parameter.getDimensionMap();
                Iterator dimNumber = null;
                Set<String> dataNumbers = null;
                IDimension dimenison = null;
                List<IMember> dimensionMember = null;
                for (Map.Entry<String, IDimension> entry : map.entrySet()) {
                    dimNumber = entry.getKey();
                    if (dataMembers == null || !dataMembers.containsKey(entry.getKey())) continue;
                    dataNumbers = dataMembers.get(dimNumber);
                    dimenison = entry.getValue();
                    dimensionMember = dimenison.getDimensionMember();
                    Iterator<IMember> memIter = dimensionMember.iterator();
                    while (memIter.hasNext()) {
                        if (dataNumbers.contains(memIter.next().getNumber())) continue;
                        memIter.remove();
                    }
                }
                otherCount = this.calDataSize(parameter);
                logger.error((Object)("queryOnOrgData total count new:" + otherCount));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst);
        }
        int batchIndexCount = (int)((otherCount - 1L) / (long)MAX_COUNT + 1L);
        ArrayList<IMember> oldIndexMembers = new ArrayList<IMember>(indexDim.getDimensionMember());
        if (batchIndexCount > oldIndexMembers.size()) {
            batchIndexCount = oldIndexMembers.size();
        }
        logger.error((Object)("queryOnOrgData batchIndexCount:" + batchIndexCount));
        int indexCount = MbgSqlHelper.getBatchCount((int)oldIndexMembers.size(), (int)batchIndexCount);
        HashMap<String, BgNViewDataInfo> dataMap = new HashMap<String, BgNViewDataInfo>();
        Object tmpMap = null;
        IDimension otherDim = null;
        if (otherCount > (long)(MAX_COUNT * indexCount * 1000)) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (IDimension _dim : parameter.getDimensionMap().values()) {
                arrayList.add(_dim.getField());
            }
            Collections.sort(arrayList, new RefFieldComparator());
            for (String field : arrayList) {
                if (DimUtils.checkBaseDimensionByField(field) || DimensionConstants.DEF_BGINDEX_FIELD.equals(field) || parameter.getDimension(field).getDimensionMember().size() <= 10) continue;
                otherDim = parameter.getDimension(field);
                break;
            }
        }
        Object var21_32 = null;
        ArrayList<IMember> newOtherMember = new ArrayList<IMember>();
        Map<String, Set<String>> detailRelation = null;
        Map indexChildMap = null;
        Map otherParentMap = null;
        Set<String> otherHasData = null;
        if (otherDim != null) {
            List<IMember> list = otherDim.getDimensionMember();
            detailRelation = this.queryDetailRelation(ctx, conn, parameter, otherDim.getField());
            indexChildMap = MbgVirtualView.querySubDataMap((Context)ctx, (Connection)conn, (BOSUuid)parameter.getDataManager().getBgScheme().getViewId(DimensionConstants.DEF_ACCOUNT_NUMBER), this.getMemberNumbers(oldIndexMembers), (boolean)false);
            otherParentMap = MbgVirtualView.querySubDataMap((Context)ctx, (Connection)conn, (BOSUuid)parameter.getDataManager().getBgScheme().getViewId(otherDim.getNumber()), this.getMemberNumbers(list), (boolean)true);
        }
        int startIndex1 = 0;
        int endIndex1 = 0;
        boolean startIndex2 = false;
        boolean endIndex2 = false;
        for (int i = 0; i < batchIndexCount; ++i) {
            void var21_34;
            startIndex1 = i * indexCount;
            endIndex1 = startIndex1 + indexCount;
            if (endIndex1 > oldIndexMembers.size()) {
                endIndex1 = oldIndexMembers.size();
            }
            if (startIndex1 >= oldIndexMembers.size()) break;
            indexDim.setDimensionMember(oldIndexMembers.subList(startIndex1, endIndex1));
            if (var21_34 != null) {
                otherHasData = this.queryOtherMembers(conn, parameter, indexDim, otherDim, detailRelation, indexChildMap, otherParentMap, bizCalcRelation, bizParentMap);
                newOtherMember.clear();
                for (IMember m : var21_34) {
                    if (!otherHasData.contains(m.getDimNumber())) continue;
                    newOtherMember.add(m);
                }
                if (newOtherMember.isEmpty()) continue;
                if (otherDim != null) {
                    otherDim.setDimensionMember(newOtherMember);
                }
            }
            this.runQueryData(ctx, conn, parameter, dataMap);
        }
        indexDim.setDimensionMember(oldIndexMembers);
        return dataMap;
    }

    protected long calDataSize(IDimensionParameter parameter) {
        long otherCount = 1L;
        List<IDimension> colDims = parameter.getDims();
        for (int i = 0; i < colDims.size(); ++i) {
            IDimension dim = colDims.get(i);
            otherCount *= (long)dim.getDimensionMember().size();
        }
        return otherCount;
    }

    /*
     * WARNING - void declaration
     */
    private Set<String> queryOtherMembers(Connection conn, IDimensionParameter parameter, IDimension indexDim, IDimension otherDim, Map<String, Set<String>> detailRelation, Map<String, Set<String>> indexChildMap, Map<String, Set<String>> otherParentMap, Map<String, Map<String, Set<String>>> bizCalcRelation, Map<String, Map<String, Set<String>>> bizParentMap) {
        HashSet<String> result = new HashSet<String>();
        Set<Object> child = null;
        for (IMember indexMember : indexDim.getDimensionMember()) {
            if (!indexChildMap.containsKey(indexMember.getDimNumber())) {
                child = new HashSet<String>();
                child.add(indexMember.getDimNumber());
            } else {
                child = indexChildMap.get(indexMember.getDimNumber());
            }
            for (String string : child) {
                if (!detailRelation.containsKey(string)) continue;
                for (String other : detailRelation.get(string)) {
                    if (!otherParentMap.containsKey(other)) continue;
                    result.addAll((Collection<String>)otherParentMap.get(other));
                }
            }
        }
        if (bizCalcRelation.containsKey(otherDim.getField())) {
            void var15_18;
            String[] numbers;
            String[] stringArray = numbers = result.toArray(new String[0]);
            int n = stringArray.length;
            boolean bl = false;
            while (var15_18 < n) {
                String number = stringArray[var15_18];
                this.buildTarget(number, bizCalcRelation.get(otherDim.getField()), bizParentMap.get(otherDim.getField()), result);
                ++var15_18;
            }
        }
        return result;
    }

    private Set<String> getMemberNumbers(List<IMember> membes) {
        HashSet<String> queryNums = new HashSet<String>();
        for (IMember m : membes) {
            queryNums.add(m.getDimNumber());
        }
        return queryNums;
    }

    private Map<String, Set<String>> queryDetailRelation(Context ctx, Connection conn, IDimensionParameter parameter, String field) throws BOSException, EASBizException {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        String mbgSnapVar = MbgVirtualView.getMbgOrgUnitSnap((Connection)conn, (BOSUuid)parameter.getBgOrgViewId());
        String mbgOrgClosure = MbgVirtualView.getBgOrgClosureTable((String)mbgSnapVar);
        IRowSet rst = null;
        String accNumber = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select distinct F2, " + field + " FROM " + parameter.getDataManager().getBgScheme().getRefCube() + " Where FOrgUnitId IN (select t.FChildID from " + mbgOrgClosure + " t where t.FID = ?)"), (Object[])new Object[]{parameter.getOrgUnitId().toString()});
            while (rst.next()) {
                accNumber = rst.getString("F2");
                if (!result.containsKey(accNumber)) {
                    result.put(accNumber, new HashSet());
                }
                ((Set)result.get(accNumber)).add(rst.getString(field));
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    private void buildTarget(String number, Map<String, Set<String>> subBiz, Map<String, Set<String>> subParent, Set<String> subData) {
        if (!subBiz.containsKey(number)) {
            return;
        }
        if (!subData.contains(number)) {
            subData.add(number);
        }
        for (String targetNumber : subBiz.get(number)) {
            if (subData.contains(targetNumber)) continue;
            subData.add(targetNumber);
            this.buildTarget(targetNumber, subBiz, subParent, subData);
            if (!subParent.containsKey(targetNumber)) continue;
            for (String pNumber : subParent.get(targetNumber)) {
                this.buildTarget(pNumber, subBiz, subParent, subData);
            }
        }
    }

    protected Map<String, Set<String>> fillDimensionMemberByBizCalc(Context ctx, IDimensionParameter parameter, Map<String, String> srcFieldMap, Map<String, Map<String, String>> numInnMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        if (ctx == null || parameter == null) {
            return null;
        }
        BizCalcMember member = null;
        Object numbers = null;
        Object viewIds = null;
        Object sql = null;
        ArrayList<BizCalcMember> members = new ArrayList<BizCalcMember>();
        HashMap mdxNumMap = new HashMap();
        BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
        List<BOSUuid> calcIds = parameter.getCalcIds();
        HashSet<String> bizCalcIds = new HashSet<String>();
        for (BOSUuid calcId : calcIds) {
            bizCalcIds.add(calcId.toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("bizCalcSubset.*");
        selector.add("bizCalcSubset.scope.*");
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", bizCalcIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BizCalcCollection calcs = BizCalcFactory.getLocalInstance((Context)ctx).getBizCalcCollection(view);
        String[] tmpStrs = null;
        String srcNumber = null;
        String field = null;
        HashMap<String, Set<String>> refNumMap = new HashMap<String, Set<String>>();
        Map<String, String> variateMap = parameter.getDataManager().getVariate();
        if (!calcs.isEmpty() && parameter.getPeriodStandardNumber() != null && !parameter.getPeriodStandardNumber().isEmpty()) {
            ArrayList<BizCalcInfo> _calcs = new ArrayList<BizCalcInfo>();
            for (int i = 0; i < calcs.size(); ++i) {
                _calcs.add(calcs.get(i));
            }
            MBgPeriodVariable variable = new MBgPeriodVariable(ctx.getLocale());
            variable.transPeirodVariale(ctx, _calcs, parameter.getPeriodStandardNumber(), null);
        }
        if (variateMap != null) {
            for (String dimNumber : variateMap.values()) {
                tmpStrs = dimNumber.split(":");
                if (tmpStrs == null || tmpStrs.length != 2 || !srcFieldMap.containsKey(srcNumber = tmpStrs[0])) continue;
                field = srcFieldMap.get(srcNumber);
                BizExprUtils.putDimNumber((String)field, (String)dimNumber, refNumMap);
            }
        }
        if (calcs != null && !calcs.isEmpty()) {
            int in = calcs.size();
            for (int i = 0; i < in; ++i) {
                member = new BizCalcMember();
                member.setMdxNumMap(mdxNumMap);
                member.setSrcFieldMap(srcFieldMap);
                member.setNumInnMap(numInnMap);
                member.setCalc(calcs.get(i));
                member.queryRefMbgMember(ctx, parameter, bgScheme.getId(), refNumMap);
                members.add(member);
            }
        }
        return refNumMap;
    }

    private void runQueryData(Context ctx, Connection conn, IDimensionParameter parameter, Map<String, BgNViewDataInfo> dataMap) throws BOSException, EASBizException {
        long st = System.currentTimeMillis();
        MbgLoggerUtils.logger((String)"Start runQueryData");
        Map tmpMap = (Map)BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(parameter);
        MbgLoggerUtils.logger((String)("End runQueryData " + (System.currentTimeMillis() - st) + "ms"));
        if (tmpMap != null && !tmpMap.isEmpty()) {
            MultiThreadQuery.mergeData(dataMap, tmpMap);
        }
    }

    private boolean checkMemberEmpty(MbgViewListDimensionManager dimensionManager) {
        List<MbgViewListDimensionInfo> allDims = dimensionManager.getAllDimensions();
        for (int i = 0; i < allDims.size(); ++i) {
            if (!allDims.get(i).getMember().isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void convertMember(MbgViewListDimensionManager dimensionManager, Map<String, Map<String, Set<String>>> targetToSource) {
        List<MbgViewListDimensionInfo> allDims = dimensionManager.getAllDimensions();
        HashMap<String, BgDimensionMember> memberMap = new HashMap<String, BgDimensionMember>();
        MbgViewListDimensionInfo dimension = null;
        Map<String, Set<String>> subMapInfo = null;
        BgDimensionMember member = null;
        String number2 = null;
        for (int i = 0; i < allDims.size(); ++i) {
            dimension = allDims.get(i);
            subMapInfo = targetToSource.get(dimension.getNumber());
            memberMap.clear();
            dimension.setMemberType(BgMemberSelectTypeEnum.Member);
            dimension.setMemberValueType(DimensionMemberValueModeEnum.SelectMember);
            dimension.getSelectMembers().clear();
            for (int m = 0; m < dimension.getMember().size(); ++m) {
                member = (BgDimensionMember)dimension.getMember().get(m);
                member.setFillType(0);
                if (subMapInfo != null && subMapInfo.containsKey(member.getNumber())) {
                    for (String number2 : subMapInfo.get(member.getNumber())) {
                        if (memberMap.containsKey(number2)) continue;
                        memberMap.put(number2, new BgDimensionMember(dimension.getNumber(), dimension.getRefField(), number2, number2));
                    }
                    continue;
                }
                memberMap.put(member.getNumber(), member);
            }
            dimension.getSelectMembers().addAll(memberMap.values());
        }
    }

    private void prepareMap(BgSchemeIntegrationInfo integInfo, Map<String, Map<String, Set<String>>> targetToSource, Map<String, Map<String, Set<String>>> sourceToTarget) {
        BgSchemeIntegrationEntryInfo entryInfo = null;
        BgSchemeIntegrationMapInfo mapInfo = null;
        String dimNumber = null;
        for (int i = 0; i < integInfo.getEntries().size(); ++i) {
            entryInfo = integInfo.getEntries().get(i);
            dimNumber = entryInfo.getDimNumber();
            for (int m = 0; m < entryInfo.getMemberMaps().size(); ++m) {
                mapInfo = entryInfo.getMemberMaps().get(m);
                this.addToMap(dimNumber, targetToSource, mapInfo.getTargetMemberNumber(), mapInfo.getSourceMemberNumber());
                this.addToMap(dimNumber, sourceToTarget, mapInfo.getSourceMemberNumber(), mapInfo.getTargetMemberNumber());
            }
        }
    }

    private void addToMap(String dimNumber, Map<String, Map<String, Set<String>>> memberMap, String keyNumber, String valueNumber) {
        Map<Object, Object> subMap = null;
        if (!memberMap.containsKey(dimNumber)) {
            subMap = new HashMap();
            memberMap.put(dimNumber, subMap);
        } else {
            subMap = memberMap.get(dimNumber);
        }
        Set<String> subSet = null;
        if (!subMap.containsKey(keyNumber)) {
            subSet = new HashSet();
            subMap.put(keyNumber, subSet);
        } else {
            subSet = (Set)subMap.get(keyNumber);
        }
        subSet.add(valueNumber);
    }

    protected IDimensionParameter transDimParameter(Context ctx, MbgViewListManager viewManager, BgSchemeIntegrationInfo integInfo, String bgPeriodNum) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setBgScheme(integInfo.getSourceBgScheme());
        bgFormInfo.setOrgUnit(integInfo.getOrgUnit().castToFullOrgUnitInfo());
        bgFormInfo.setBgTemplate(new BgTemplateInfo());
        bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.VIEWLIST);
        IDimensionParameter parameter = null;
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        dimensionManager.add(((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager());
        try {
            parameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, null);
            parameter.setBgTemplateId(null);
            if (BgSchemeIntegratDataStateEnum.Audited.equals((Object)integInfo.getDataState())) {
                parameter.setValueType(2);
            } else {
                parameter.setValueType(1);
            }
            if (!StringUtils.isEmpty((String)bgPeriodNum)) {
                parameter.addPeriodStandardNumber(bgPeriodNum);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return parameter;
    }

    private MbgViewListManager buildDefaultViewListManager() {
        MbgViewListManager viewManager = new MbgViewListManager();
        MbgViewListSheetManager sheetManager = new MbgViewListSheetManager(viewManager);
        viewManager.getSheetManagers().add(sheetManager);
        MbgViewListDimensionManager dimensionManager = new MbgViewListDimensionManager(sheetManager);
        sheetManager.setDimensionManager(dimensionManager);
        MbgViewListRowCol rowObject = new MbgViewListRowCol();
        MbgViewListRowCol colObject = new MbgViewListRowCol();
        dimensionManager.getRows().add(rowObject);
        dimensionManager.getColumns().add(colObject);
        return viewManager;
    }

    private void buildViewListManager(MbgViewListDimensionManager dimensionManager, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) {
        MbgViewListDimensionInfo dimension2 = null;
        List<String> addAndOtherDim = schemeHelper.getAccAndOtherDim(false);
        for (MbgViewListDimensionInfo dimension2 : dimMap.values()) {
            if (dimension2.getSelectMembers().isEmpty()) {
                dimension2.setMemberValueType(DimensionMemberValueModeEnum.All);
            }
            if (addAndOtherDim.contains(dimension2.getNumber())) {
                dimension2.setLayout("row");
                ((MbgViewListRowCol)dimensionManager.getRows().get(0)).getDimensions().add(dimension2);
            } else {
                dimension2.setLayout("col");
                ((MbgViewListRowCol)dimensionManager.getColumns().get(0)).getDimensions().add(dimension2);
            }
            dimensionManager.addDimensionInfo(dimension2);
        }
    }

    private void buildDimension(BgSchemeIntegrationInfo integInfo, Map<String, MbgViewListDimensionInfo> comDimmMap, Map<String, MbgViewListDimensionInfo> sourceDimmMap, Map<String, MbgViewListDimensionInfo> targetDimmMap, BgSchemeDimensionHelper sourceSchemeHelper, BgSchemeDimensionHelper targetSchemeHelper) throws BgSchemeIntegrationException {
        for (int i = 0; i < integInfo.getEntries().size(); ++i) {
            this.buildDimension(integInfo.getEntries().get(i), comDimmMap, sourceDimmMap, targetDimmMap, sourceSchemeHelper, targetSchemeHelper);
        }
    }

    private void buildDimension(BgSchemeIntegrationEntryInfo entryInfo, Map<String, MbgViewListDimensionInfo> comDimmMap, Map<String, MbgViewListDimensionInfo> sourceDimmMap, Map<String, MbgViewListDimensionInfo> targetDimmMap, BgSchemeDimensionHelper sourceSchemeHelper, BgSchemeDimensionHelper targetSchemeHelper) throws BgSchemeIntegrationException {
        BgDimensionInfo dimension;
        Map<String, MbgViewListDimensionInfo> dimMap = null;
        BgSchemeDimensionHelper schemeHelper = null;
        if (BgSchemeIntegrationSourceEnum.common.equals((Object)entryInfo.getSourceType())) {
            dimMap = comDimmMap;
            schemeHelper = targetSchemeHelper;
        } else if (BgSchemeIntegrationSourceEnum.source.equals((Object)entryInfo.getSourceType())) {
            dimMap = sourceDimmMap;
            schemeHelper = sourceSchemeHelper;
        } else if (BgSchemeIntegrationSourceEnum.target.equals((Object)entryInfo.getSourceType())) {
            dimMap = targetDimmMap;
            schemeHelper = targetSchemeHelper;
        }
        BgDimensionInfo bgDimensionInfo = dimension = schemeHelper != null ? schemeHelper.getDimension(entryInfo.getDimNumber()) : null;
        if (dimension == null) {
            throw new BgSchemeIntegrationException(BgSchemeIntegrationException.DIMENSIONNOEXISTS, new Object[]{entryInfo.getDimNumber(), BgSchemeIntegrationSourceEnum.source.equals((Object)entryInfo.getSourceType()) ? BgSchemeIntegrationSourceEnum.source : BgSchemeIntegrationSourceEnum.target});
        }
        if (BgSchemeIntegrationSourceEnum.common.equals((Object)entryInfo.getSourceType()) && sourceSchemeHelper.getDimension(entryInfo.getDimNumber()) == null) {
            throw new BgSchemeIntegrationException(BgSchemeIntegrationException.DIMENSIONNOEXISTS, new Object[]{entryInfo.getDimNumber(), BgSchemeIntegrationSourceEnum.source});
        }
        MbgViewListDimensionInfo viewListDim = new MbgViewListDimensionInfo(null);
        dimension.cloneValue(viewListDim);
        if (dimMap != null) {
            dimMap.put(dimension.getNumber(), viewListDim);
        }
        this.buildDimMember(viewListDim, entryInfo, schemeHelper);
    }

    private void buildDimMember(MbgViewListDimensionInfo viewListDim, BgSchemeIntegrationEntryInfo entryInfo, BgSchemeDimensionHelper schemeHelper) {
        if (entryInfo.getMembers().isEmpty()) {
            return;
        }
        viewListDim.setMemberType(entryInfo.getMemberType());
        Object member = null;
        Object propertyInfo = null;
        BgSchemeIntegrationMemberInfo memberInfo = null;
        for (int i = 0; i < entryInfo.getMembers().size(); ++i) {
            memberInfo = entryInfo.getMembers().get(i);
            viewListDim.getSelectMembers().add(BgSchemeIntegrationHelper.convertMember(entryInfo.getDimNumber(), entryInfo.getMemberType(), memberInfo, schemeHelper));
        }
    }

    @Override
    protected boolean _deleteDisIntegrationData(Context ctx, List integrationIds) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append("select id,targetBgScheme.refCube where id in (");
        int end = integrationIds.size();
        for (int index = 0; index < end; ++index) {
            if (index < end - 1) {
                sql.append("'").append(integrationIds.get(index)).append("'").append(",");
                continue;
            }
            sql.append("'").append(integrationIds.get(index)).append("'");
        }
        sql.append(")");
        BgSchemeIntegrationCollection colls = BgSchemeIntegrationFactory.getLocalInstance(ctx).getBgSchemeIntegrationCollection(sql.toString());
        return this.dealIntegrationData(ctx, colls);
    }

    private boolean dealIntegrationData(Context ctx, BgSchemeIntegrationCollection colls) throws EASBizException, BOSException, SQLDataException {
        boolean isSuccess = false;
        HashMap inteRefCubeMap = new HashMap();
        Iterator iter = colls.iterator();
        while (iter.hasNext()) {
            BgSchemeIntegrationInfo inteInfo = (BgSchemeIntegrationInfo)iter.next();
            BgSchemeInfo targetScheme = inteInfo.getTargetBgScheme();
            String refCube = targetScheme.getRefCube();
            Object[] obj = new Object[]{inteInfo.getId().toString()};
            if (inteRefCubeMap.containsKey(refCube)) {
                ((List)inteRefCubeMap.get(refCube)).add(obj);
                continue;
            }
            ArrayList<Object[]> inteRefCube = new ArrayList<Object[]>();
            inteRefCube.add(obj);
            inteRefCubeMap.put(refCube, inteRefCube);
        }
        for (Map.Entry entry : inteRefCubeMap.entrySet()) {
            this.addIntegrationId4RefTable(ctx, (String)entry.getKey());
            StringBuffer refSql = new StringBuffer();
            refSql.append("delete from ").append((String)entry.getKey()).append(" where FState = ").append(1).append(" and FIntegrationId = ?");
            try {
                BgDBUtils.executeBatch((Context)ctx, (String)refSql.toString(), (List)((List)entry.getValue()));
                isSuccess = true;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return isSuccess;
    }

    protected Set<String> getMultiQueryOrgIds(BgSchemeIntegerParameter integrateParameter, String curOrgNumber, Set<String> hasQueryOrgNumbers, Map<String, OrgUnitInfo> orgUnitMap) {
        HashSet<String> queryOrgIds = new HashSet<String>();
        if (integrateParameter.sourceToTarget.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER) && integrateParameter.sourceToTarget.get(DimensionConstants.DEF_ORGUNIT_NUMBER).containsKey(curOrgNumber)) {
            Set<String> targeOrgNums = integrateParameter.sourceToTarget.get(DimensionConstants.DEF_ORGUNIT_NUMBER).get(curOrgNumber);
            for (String targeOrgNum : targeOrgNums) {
                Set<String> sourceOrgNums;
                if (!integrateParameter.targetToSource.containsKey(DimensionConstants.DEF_ORGUNIT_NUMBER) || !integrateParameter.targetToSource.get(DimensionConstants.DEF_ORGUNIT_NUMBER).containsKey(targeOrgNum) || (sourceOrgNums = integrateParameter.targetToSource.get(DimensionConstants.DEF_ORGUNIT_NUMBER).get(targeOrgNum)).size() <= 1) continue;
                for (String sourceOrgNum : sourceOrgNums) {
                    if (!orgUnitMap.containsKey(sourceOrgNum)) continue;
                    queryOrgIds.add(orgUnitMap.get(sourceOrgNum).getId().toString());
                    hasQueryOrgNumbers.add(sourceOrgNum);
                }
            }
        }
        return queryOrgIds;
    }

    protected String getOrgNumber(String orgId, BgSchemeIntegerParameter integParameter) {
        MbgViewListDimensionInfo orgDimension = integParameter.orgDimension;
        BgDimensionMember orgMember2 = null;
        for (BgDimensionMember orgMember2 : orgDimension.getMember()) {
            if (!orgMember2.getAttribute().equals(orgId)) continue;
            return orgMember2.getNumber();
        }
        return null;
    }

    private static class ReportData {
        List<ICalcData> sourceDatas = new ArrayList<ICalcData>();
        ICalcData targetData = null;

        private ReportData() {
        }
    }

    private class FormulaProcessor
    implements BgViewHelper.IFormulaProcessor {
        Map<Integer, String> clone = new HashMap<Integer, String>();
        Map scenarioMap = null;
        Map versionMap = null;
        Map<String, Map<String, ReportData>> targetMap = new HashMap<String, Map<String, ReportData>>();
        BgNDataInfo sourceData = null;
        String orgId = null;

        private FormulaProcessor() {
        }

        @Override
        public void process(String formula, String versionNumber, String scenarioNumber) {
            if (!this.targetMap.containsKey(this.orgId)) {
                this.targetMap.put(this.orgId, new HashMap());
            }
            String key = formula + "_" + versionNumber;
            ReportData reportData = this.targetMap.get(this.orgId).get(key);
            ICalcData sData = this.sourceData.toCalcData(this.scenarioMap, this.versionMap, 1);
            if (reportData != null) {
                reportData.targetData.setValue(reportData.targetData.getValue().add(sData.getValue()));
                reportData.targetData.setBgDataSource(3);
            } else {
                reportData = new ReportData();
                BgNDataInfo targetData = new BgNDataInfo();
                targetData.copyValue(this.sourceData);
                targetData.setBgVersion(versionNumber);
                targetData.setOrgUnitId(this.orgId);
                targetData.setFormula(formula);
                reportData.targetData = targetData.toCalcData(this.scenarioMap, this.versionMap, 1);
                reportData.targetData.setBgDataSource(3);
                this.targetMap.get(this.orgId).put(key, reportData);
            }
            reportData.sourceDatas.add(sData);
        }

        @Override
        public Map<Integer, String> getCloneMap() {
            return this.clone;
        }
    }
}

