/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimCollection;
import com.kingdee.eas.ma.mbg.BgSchemeRefDimInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberInfo;
import com.kingdee.eas.ma.mbg.BgSchemeRefMemberTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeRefDimControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgSchemeRefDimControllerBean
extends AbstractBgSchemeRefDimControllerBean {
    private static final long serialVersionUID = -3439678120854534425L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeRefDimControllerBean");
    private static Map<String, String> bgElementSet = new HashMap<String, String>();

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _checkRefDim(Context ctx, String bgSchemeId, List bgTemplateIds) throws BOSException, EASBizException {
        HashSet selBgTemplateIds = new HashSet();
        if (bgTemplateIds != null) {
            selBgTemplateIds.addAll(bgTemplateIds);
        }
        HashMap<BgTemplateInfo, BgSchemeRefDimCollection> refDims = new HashMap<BgTemplateInfo, BgSchemeRefDimCollection>();
        if (selBgTemplateIds.isEmpty()) {
            return refDims;
        }
        DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
        BgSchemeRefDimInfo refDimInfo = null;
        StringBuffer numbers = new StringBuffer();
        StringBuffer names = new StringBuffer();
        ArrayList<String> indexSrcNumbers = new ArrayList<String>();
        Connection conn = null;
        HashSet srcItems = new HashSet();
        HashSet refDimStr = new HashSet();
        try {
            int i;
            conn = this.getConnection(ctx);
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("template.id");
            evi.getSelector().add("template.number");
            evi.getSelector().add("template.orgUnit.id");
            evi.getSelector().add("template.name");
            evi.getSelector().add("data");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("template.id", selBgTemplateIds, CompareType.INCLUDE));
            BgViewDimensionCollection viewDimens = BgViewDimensionFactory.getLocalInstance(ctx).getBgViewDimensionCollection(evi);
            if (viewDimens == null || viewDimens.isEmpty()) {
                HashMap<BgTemplateInfo, BgSchemeRefDimCollection> hashMap = refDims;
                return hashMap;
            }
            HashMap<String, MbgDimInfo> dimMap = new HashMap<String, MbgDimInfo>();
            MbgDimCollection colls = DimUtils.getDimensionColls(ctx);
            if (colls != null) {
                MbgDimInfo dimInfo = null;
                int in = colls.size();
                for (int i2 = 0; i2 < in; ++i2) {
                    dimInfo = colls.get(i2);
                    dimMap.put(dimInfo.getRefField(), dimInfo);
                }
            }
            Iterator iter = viewDimens.iterator();
            while (iter.hasNext()) {
                BgViewDimensionInfo viewDimen = (BgViewDimensionInfo)iter.next();
                BgTemplateInfo templateInfo = viewDimen.getTemplate();
                try {
                    IMbgViewManager viewManager = new MbgXMLParser(ctx).parse(viewDimen.getData(), null);
                    viewManager = TemplateFacadeFactory.getLocalInstance(ctx).loadViewManager(templateInfo.getOrgUnit().getId().toString(), templateInfo.getBgScheme().getId().toString(), viewManager);
                    if (viewManager == null || viewManager.getSheetManagers().isEmpty()) continue;
                    ArrayList<String> dimStr = new ArrayList<String>();
                    int in = viewManager.getSheetManagers().size();
                    for (i = 0; i < in; ++i) {
                        int m;
                        BgSchemeRefMemberInfo refMember;
                        BgDimensionMember member;
                        IMbgSheetManager sheetManager = viewManager.getSheetManagers().get(i);
                        IBgDimensionManager dimManager = sheetManager.getDimensionManager();
                        ArrayList dims = new ArrayList();
                        dims.addAll(dimManager.getRowDimension());
                        dims.addAll(dimManager.getColDimension());
                        dims.addAll(dimManager.getViewDimension());
                        dims.addAll(dimManager.getPageDimension());
                        dimStr.clear();
                        BgDimensionInfo indexDim = null;
                        BgDimensionInfo bgElementDim = null;
                        BgDimensionInfo bgScenarioDim = null;
                        int jn = dims.size();
                        for (int j = 0; j < jn; ++j) {
                            if (DimensionConstants.DEF_ELEMENT_NUMBER.equals(((BgDimensionInfo)dims.get(j)).getNumber())) {
                                bgElementDim = (BgDimensionInfo)dims.get(j);
                            } else if (DimensionConstants.DEF_INDEX_NUMBER.equals(((BgDimensionInfo)dims.get(j)).getNumber())) {
                                indexDim = (BgDimensionInfo)dims.get(j);
                            } else if (DimensionConstants.DEF_SCENARIO_NUMBER.equals(((BgDimensionInfo)dims.get(j)).getNumber())) {
                                bgScenarioDim = (BgDimensionInfo)dims.get(j);
                            }
                            if (DimUtils.checkBaseDimension(((BgDimensionInfo)dims.get(j)).getNumber())) continue;
                            dimStr.add(((BgDimensionInfo)dims.get(j)).getAttribute());
                        }
                        if (indexDim == null || bgElementDim == null || bgScenarioDim == null) continue;
                        DimUtils.sortFields(dimStr);
                        numbers.setLength(0);
                        names.setLength(0);
                        for (int d = 0; d < dimStr.size(); ++d) {
                            if (d > 0) {
                                numbers.append(";");
                                names.append(";");
                            }
                            numbers.append((String)dimStr.get(d));
                            names.append(((MbgDimInfo)dimMap.get(dimStr.get(d))).getName());
                        }
                        refDimInfo = new BgSchemeRefDimInfo();
                        refDimInfo.setBgDimNumber(numbers.toString());
                        refDimInfo.setBgDimName(names.toString());
                        HashMap<String, BgSchemeRefMemberInfo> loadElementMap = new HashMap<String, BgSchemeRefMemberInfo>();
                        bgElementDim.sortMember();
                        for (int m2 = 0; m2 < bgElementDim.getMember().size(); ++m2) {
                            member = (BgDimensionMember)bgElementDim.getMember().get(m2);
                            refMember = new BgSchemeRefMemberInfo();
                            refMember.setMemberType(BgSchemeRefMemberTypeEnum.BgElement);
                            refMember.setNumber(member.getNumber());
                            this.setRefMemberName(loadElementMap, member, refMember);
                            refDimInfo.getMembers().add(refMember);
                        }
                        this.loadBgElementMemberName(loadElementMap, ctx);
                        HashMap<String, BgSchemeRefMemberInfo> loadSencarioMap = new HashMap<String, BgSchemeRefMemberInfo>();
                        bgScenarioDim.sortMember();
                        for (m = 0; m < bgScenarioDim.getMember().size(); ++m) {
                            member = (BgDimensionMember)bgScenarioDim.getMember().get(m);
                            refMember = new BgSchemeRefMemberInfo();
                            refMember.setMemberType(BgSchemeRefMemberTypeEnum.BgScenario);
                            refMember.setNumber(member.getNumber());
                            this.setRefMemberName(loadSencarioMap, member, refMember);
                            refDimInfo.getMembers().add(refMember);
                        }
                        this.loadBgScenarioMemberName(loadSencarioMap, ctx);
                        indexSrcNumbers.clear();
                        if (indexDim != null && DimensionMemberValueModeEnum.SelectMember.equals((Object)indexDim.getMemberValueType())) {
                            for (m = 0; m < indexDim.getMember().size(); ++m) {
                                member = (BgDimensionMember)indexDim.getMember().get(m);
                                if (indexSrcNumbers.contains(member.getSrcNumber())) continue;
                                indexSrcNumbers.add(member.getSrcNumber());
                            }
                        } else if (indexDim != null && DimensionMemberValueModeEnum.RelationMapping.equals((Object)indexDim.getMemberValueType())) {
                            for (int r = 0; r < indexDim.getMappingList().size(); ++r) {
                                DimensionRelationshipGroupInfo group = cacheHelper.getRelationGroup(indexDim.getMappingList().get(r).getId().toString());
                                if (group == null) continue;
                                for (int e = 0; e < group.getEntries().size(); ++e) {
                                }
                            }
                        }
                        for (int s = 0; s < indexSrcNumbers.size(); ++s) {
                            refDimInfo = (BgSchemeRefDimInfo)refDimInfo.clone();
                            refDimInfo.setId(BOSUuid.create((BOSObjectType)refDimInfo.getBOSType()));
                            if (refDimInfo.getIndexSource() == null) continue;
                            for (int m3 = 0; m3 < refDimInfo.getMembers().size(); ++m3) {
                                refDimInfo.getMembers().get(m3).setRefDim(refDimInfo);
                            }
                            if (!refDims.containsKey(templateInfo)) {
                                refDims.put(templateInfo, new BgSchemeRefDimCollection());
                            }
                            ((BgSchemeRefDimCollection)((Object)refDims.get(templateInfo))).add(refDimInfo);
                        }
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)"load BgTemplate Info Error:", (Throwable)ex);
                }
            }
            DimensionSourceCollection sources = new DimensionSourceCollection();
            for (BgSchemeRefDimCollection col : refDims.values()) {
                for (i = 0; i < col.size(); ++i) {
                    if (sources.contains(col.get(i).getIndexSource())) continue;
                    sources.add(col.get(i).getIndexSource());
                }
            }
            DimensionCommonHelper.loadSourceNameInfo(ctx, sources);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return refDims;
    }

    private void loadBgElementMemberName(Map<String, BgSchemeRefMemberInfo> loadElementMap, Context ctx) throws BOSException {
        if (loadElementMap == null || loadElementMap.isEmpty()) {
            return;
        }
        BgElementCollection bgElementCollection = BgElementFactory.getLocalInstance((Context)ctx).getBgElementCollection();
        int count = bgElementCollection.size();
        for (int i = 0; i < count; ++i) {
            BgElementInfo bgElementInfo = bgElementCollection.get(i);
            String key = bgElementInfo.getNumber();
            String value = bgElementInfo.getName();
            if (!loadElementMap.keySet().contains(key)) continue;
            loadElementMap.get(key).setName(value);
        }
    }

    private void loadBgScenarioMemberName(Map<String, BgSchemeRefMemberInfo> loadElementMap, Context ctx) throws BOSException {
        if (loadElementMap == null || loadElementMap.isEmpty()) {
            return;
        }
        BgScenarioCollection bgElementCollection = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection();
        int count = bgElementCollection.size();
        for (int i = 0; i < count; ++i) {
            BgScenarioInfo bgScenarioInfo = bgElementCollection.get(i);
            String key = bgScenarioInfo.getNumber();
            String value = bgScenarioInfo.getName();
            if (!loadElementMap.keySet().contains(key)) continue;
            loadElementMap.get(key).setName(value);
        }
    }

    private void setRefMemberName(Map<String, BgSchemeRefMemberInfo> loadMap, BgDimensionMember member, BgSchemeRefMemberInfo refMember) {
        if (loadMap == null) {
            return;
        }
        if (member.getNumber().equals(member.getName()) || member.getName() == null || "".equals(member.getName().trim())) {
            loadMap.put(member.getNumber(), refMember);
        } else {
            refMember.setName(member.getName());
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> queryBgTemplateIds(Context ctx, String bgSchemeId) throws BOSException, EASBizException {
        ArrayList<String> bgTemplateIds = new ArrayList<String>();
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return bgTemplateIds;
        }
        ArrayList<String> bgSchemeIds = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select FID from T_MBG_BgScheme where FID = ?");
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIds.add(rst.getString("FID"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            int size = bgSchemeIds.size();
            int batchSize = 50;
            int count = (size - 1) / batchSize + 1;
            int pos = 0;
            StringBuffer sql = new StringBuffer(1024);
            sql.append("select distinct n.FBgTemplateID from T_MBG_BgSchemeNode n join T_MBG_BgTemplate t on n.FBgTemplateID = t.FID where t.FID = t.FROOTID and n.FBgSchemeID IN (");
            for (int i = 1; i < batchSize; ++i) {
                sql.append("?,");
            }
            sql.append("?)");
            pstmt = conn.prepareStatement(sql.toString());
            for (int index = 0; index < count; ++index) {
                for (int x = 1; x <= batchSize; ++x, ++pos) {
                    if (pos < size) {
                        pstmt.setString(x, (String)bgSchemeIds.get(pos));
                        continue;
                    }
                    pstmt.setString(x, BgBaseConstants.noFindStr);
                }
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateIds.add(rst.getString("FBgTemplateID"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    logger.error((Object)"queryBgTemplateIds SQL Error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgTemplateIds;
    }
}

