/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.CanNotDeleteException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.mbg.BgSchemeException;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeTypeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgSchemeTypeControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import java.sql.Connection;
import java.util.Locale;
import org.apache.log4j.Logger;

public class BgSchemeTypeControllerBean
extends AbstractBgSchemeTypeControllerBean {
    private static final long serialVersionUID = -3714872151750717338L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSchemeTypeControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    protected void _canDelete(Context ctx, IObjectPK pk, Connection cn) throws CanNotDeleteException {
        if (pk == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bgSchemeType.id", (Object)pk.toString());
        try {
            if (BgSchemeFactory.getLocalInstance(ctx).exists(filter)) {
                String desc = EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeTypeResource.cantDeleteRefNumber", (Locale)ContextUtils.getLocaleFromEnv());
                throw new CanNotDeleteException(desc);
            }
        }
        catch (EASBizException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
        catch (BOSException e) {
            throw new CanNotDeleteException((Throwable)e);
        }
    }

    @Override
    protected boolean _isQuotedByBgScheme(Context ctx, String schemetypeid) throws BOSException, EASBizException {
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("bgSchemeType.id", (Object)schemetypeid);
        return this.exists(ctx, filter);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkNameDump(ctx, model);
        return super._submit(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkNumberDup(ctx, (DataBaseInfo)model);
        super._update(ctx, pk, model);
    }

    private void checkNameDump(Context ctx, IObjectValue model) throws BgSchemeException, EASBizException, BOSException {
        if (model == null) {
            return;
        }
        BgSchemeTypeInfo curBgSchemeType = (BgSchemeTypeInfo)model;
        String schemeTypeName = curBgSchemeType.getName();
        String id = "000000000000000000000000000=";
        if (curBgSchemeType.getId() != null) {
            id = curBgSchemeType.getId().toString();
        }
        if (this._exists(ctx, "select name where name = '" + schemeTypeName + "' and id <> '" + id + "'")) {
            throw new BgSchemeException(BgSchemeException.SCHEMETYPEDUMP);
        }
    }
}

