/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.app.AbstractBgSpecialItemsControllerBean;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgSpecialItemsControllerBean
extends AbstractBgSpecialItemsControllerBean {
    private static final long serialVersionUID = -7417451830797595416L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgSpecialItemsControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkSpecialFormRepeat(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId, BOSUuid versionId, BgProcessEnum processType, String bgSpecialItemNumber) throws BOSException, EASBizException {
        boolean result = true;
        if (orgUnitId == null) return result;
        if (bgSchemeId == null) return result;
        if (bgTemplateId == null) return result;
        if (bgPeriodId == null) return result;
        if (currencyId == null) return result;
        if (StringUtils.isEmpty((String)bgSpecialItemNumber)) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select bgForm.FID from T_Mbg_BgForm bgForm left join T_MBG_BgSpecialItems special on special.FBgFormId = bgForm.FId  where bgForm.FOrgUnitId = ? and bgForm.FBgSchemeId = ? and bgForm.FBgTemplateId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? and bgForm.FBgVersionId = ? and special.FDimensionNumber = ? and bgForm.FProcessType = ? ");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            pstmt.setString(3, bgTemplateId.toString());
            pstmt.setString(4, bgPeriodId.toString());
            pstmt.setString(5, currencyId.toString());
            pstmt.setString(6, versionId.toString());
            pstmt.setString(7, bgSpecialItemNumber);
            pstmt.setInt(8, processType.getValue());
            rst = pstmt.executeQuery();
            result = rst.next();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _queryFormSpecials(Context ctx, BOSUuid orgUnitId, BOSUuid bgSchemeId, BOSUuid bgTemplateId, BOSUuid bgPeriodId, BOSUuid currencyId, BOSUuid versionId, BgProcessEnum processType) throws BOSException, EASBizException {
        HashMap result = new HashMap();
        if (orgUnitId == null) return result;
        if (bgSchemeId == null) return result;
        if (bgTemplateId == null) return result;
        if (bgPeriodId == null) return result;
        if (currencyId == null) {
            return result;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String dimensionNumber = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select bgForm.FID, special.FDimensionNumber from T_Mbg_BgForm bgForm left join T_MBG_BgSpecialItems special on special.FBgFormId = bgForm.FId  where bgForm.FOrgUnitId = ? and bgForm.FBgSchemeId = ? and bgForm.FBgTemplateId = ? and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId = ? and bgForm.FBgVersionId = ? and bgForm.FProcessType = ? ");
            pstmt.setString(1, orgUnitId.toString());
            pstmt.setString(2, bgSchemeId.toString());
            pstmt.setString(3, bgTemplateId.toString());
            pstmt.setString(4, bgPeriodId.toString());
            pstmt.setString(5, currencyId.toString());
            pstmt.setString(6, versionId.toString());
            pstmt.setInt(7, processType.getValue());
            rst = pstmt.executeQuery();
            while (rst.next()) {
                String[] dimNums;
                dimensionNumber = rst.getString("FDimensionNumber");
                if (StringUtils.isEmpty((String)dimensionNumber)) continue;
                for (String num : dimNums = dimensionNumber.split(",")) {
                    String src = num.split(":")[0];
                    String number = num.split(":")[1];
                    if (!result.containsKey(src)) {
                        result.put(src, new HashSet());
                    }
                    ((Set)result.get(src)).add(number);
                }
            }
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)ex2);
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return result;
    }
}

