/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.common.AttachmentServerManager;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.fi.rpt.IRptSheetParam;
import com.kingdee.eas.fi.rpt.PostilTypeEnum;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.RptSheetParamCollection;
import com.kingdee.eas.fi.rpt.RptSheetParamFactory;
import com.kingdee.eas.fi.rpt.RptSheetParamInfo;
import com.kingdee.eas.fi.rpt.VirtualSheetParamInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.util.IOHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementCollection;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.IBgElement;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPeriodNVariableHelper;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMeasureUnitInfo;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefCollection;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefFactory;
import com.kingdee.eas.ma.mbg.BgSpecialDimRelaGroupRefInfo;
import com.kingdee.eas.ma.mbg.BgSpecialItemsInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateCollection;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeFactory;
import com.kingdee.eas.ma.mbg.BgTemplatePostilCollection;
import com.kingdee.eas.ma.mbg.BgTemplatePostilFactory;
import com.kingdee.eas.ma.mbg.BgTemplatePostilInfo;
import com.kingdee.eas.ma.mbg.BgTemplateStatusEnum;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.IBgSpecialDimRelaGroupRef;
import com.kingdee.eas.ma.mbg.IBgTemplatePostil;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListEditNoteInfo;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.TemplateException;
import com.kingdee.eas.ma.mbg.app.AbstractBgTemplateControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgDimRelationRefServerHelper;
import com.kingdee.eas.ma.mbg.common.AbstractMbgViewBase;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgNTemplateHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgTemplateControllerBean
extends AbstractBgTemplateControllerBean {
    private static final long serialVersionUID = 1932690973363885138L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgTemplateControllerBean");

    @Override
    protected boolean _checkNumberDup(Context ctx, String bgSchemeId, String number, String id, String orgUnitId) throws BOSException {
        PreparedStatement sm;
        Connection connection;
        ResultSet rs;
        block6: {
            boolean bl;
            rs = null;
            connection = null;
            sm = null;
            StringBuffer sql = new StringBuffer(60);
            sql.append(" select t1.fid from T_MBg_bgtemplate t1, T_MBg_bgtemplateNode t2 where t1.FID = t2.FBgTemplateId AND t1.fnumber = ? and t2.forgunitid = ? and t1.FBgSchemeId = ?");
            if (!StringUtils.isEmpty((String)id)) {
                sql.append(" and t1.fid <> ?");
            }
            try {
                connection = this.getConnection(ctx);
                sm = connection.prepareStatement(sql.toString());
                sm.setString(1, number);
                sm.setString(2, orgUnitId);
                sm.setString(3, bgSchemeId);
                if (!StringUtils.isEmpty((String)id)) {
                    sm.setString(4, id);
                }
                if (!(rs = sm.executeQuery()).next()) break block6;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, sm, (Connection)connection);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return false;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)templateInfo, (String)templateInfo.getOrgUnit().getId().toString(), (String)"sourceType");
            if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                templateInfo.setNumber("BgTemplate-" + System.currentTimeMillis());
            }
        }
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (templateInfo.getRootId() == null) {
            if (templateInfo.getId() != null) {
                BOSUuid rootId = templateInfo.getId();
                templateInfo.setRootId(rootId);
            } else {
                BOSUuid id = BOSUuid.create((BOSObjectType)templateInfo.getBOSType());
                templateInfo.setId(id);
                templateInfo.setRootId(id);
            }
        }
        String number = templateInfo.getNumber();
        String orgUnitId = templateInfo.getOrgUnit().getId().toString();
        number = templateInfo.getNumber();
        if (this._checkNumberDup(ctx, templateInfo.getBgScheme().getId().toString(), number, "", orgUnitId)) {
            logger.error((Object)("BgTemplate._addnew [orgUnitId:" + orgUnitId + " number:" + number + "]"));
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        if (number.indexOf("(") >= 0 || number.indexOf(")") >= 0) {
            throw new BgNFormException(BgNFormException.NUMBERERROR);
        }
        String name = templateInfo.getName();
        if (name.indexOf("/") >= 0 || name.indexOf("\\") >= 0) {
            throw new BgNFormException(BgNFormException.NAMEERROR);
        }
        templateInfo.setNumber(number.trim());
        templateInfo.setName(name.trim());
        BgTemplateInfo coreInfo = templateInfo;
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgTemplateException(BgTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, templateInfo, book);
        boolean isEnum = false;
        BgNTemplateHelper.initAliasObjectTem(book, isEnum);
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName(ctx, conn, templateInfo.getId().toString(), book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        IObjectPK pk = super._addnew(ctx, (IObjectValue)coreInfo);
        this.addBGSheetParam(ctx, templateInfo);
        BgTemplateNodeFactory.getLocalInstance(ctx).addNew(templateInfo);
        return pk;
    }

    protected void _addnew(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)templateInfo, (String)templateInfo.getOrgUnit().getId().toString());
            if (StringUtils.isEmpty((String)templateInfo.getNumber())) {
                templateInfo.setNumber("BgTemplate-" + System.currentTimeMillis());
            }
        }
        if (templateInfo.getCU() == null) {
            templateInfo.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
        }
        if (templateInfo.getRootId() == null) {
            if (templateInfo.getId() != null) {
                BOSUuid rootId = templateInfo.getId();
                templateInfo.setRootId(rootId);
            } else {
                BOSUuid id = BOSUuid.create((BOSObjectType)templateInfo.getBOSType());
                templateInfo.setId(id);
                templateInfo.setRootId(id);
            }
        }
        String number = templateInfo.getNumber();
        String orgUnitId = templateInfo.getOrgUnit().getId().toString();
        if (this._checkNumberDup(ctx, templateInfo.getBgScheme().getId().toString(), number, "", orgUnitId)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        Book book = null;
        if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
            try {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            }
            catch (IOException e) {
                throw new BgTemplateException(BgTemplateException.OPENBOOKFAIL, e);
            }
        }
        try {
            book = templateInfo.getBook();
        }
        catch (Exception e) {
            // empty catch block
        }
        book = this.transAndCheckBook(ctx, templateInfo, book);
        boolean isEnum = false;
        BgNTemplateHelper.initAliasObjectTem(book, isEnum);
        try {
            templateInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName(ctx, conn, templateInfo.getId().toString(), book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._addnew(ctx, pk, model);
        this.addBGSheetParam(ctx, templateInfo);
        this.updatePostil(ctx, templateInfo);
        BgTemplateNodeFactory.getLocalInstance(ctx).addNew(templateInfo);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        BgTemplateInfo templateInfo = (BgTemplateInfo)model;
        String number = templateInfo.getNumber();
        String id = pk.toString();
        String orgUnitId = templateInfo.getOrgUnit().getId().toString();
        if (this._checkNumberDup(ctx, templateInfo.getBgScheme().getId().toString(), number, id, orgUnitId)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        Book book = null;
        try {
            if (templateInfo.getData() == null || templateInfo.getData().length == 0) {
                book = this.createNewBook(ctx);
                templateInfo.setBook(book);
            } else {
                book = templateInfo.getBook();
            }
        }
        catch (Exception e) {
            throw new BgTemplateException(BgTemplateException.OPENBOOKFAIL, e);
        }
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        book = this.transAndCheckBook(ctx, templateInfo, book);
        if (book != null) {
            boolean isEnum = false;
            BgNTemplateHelper.initAliasObjectTem(book, isEnum);
        }
        BgTemplateInfo _tmpInfo = new BgTemplateInfo();
        _tmpInfo.setId(templateInfo.getId());
        _tmpInfo.setName(templateInfo.getName().trim());
        _tmpInfo.setNumber(templateInfo.getNumber().trim());
        _tmpInfo.setDescription(templateInfo.getDescription());
        _tmpInfo.setBgType(templateInfo.getBgType());
        _tmpInfo.setDefaultMeasureUnit(templateInfo.getDefaultMeasureUnit());
        _tmpInfo.setReadonly(templateInfo.isReadonly());
        _tmpInfo.getBgMeasureUnit().addCollection(templateInfo.getBgMeasureUnit());
        _tmpInfo.setStyleSet(templateInfo.getStyleSet());
        _tmpInfo.setBgRollRule(templateInfo.getBgRollRule());
        _tmpInfo.setIsTransferQingAnalyse(templateInfo.isIsTransferQingAnalyse());
        _tmpInfo.getBgSpecialItems().addCollection(templateInfo.getBgSpecialItems());
        try {
            _tmpInfo.setBook(book);
        }
        catch (IOException ex) {
            logger.error((Object)"error:", (Throwable)ex);
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgNTemplateHelper.updateSheetName(ctx, conn, pk.toString(), book);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        super._update(ctx, pk, (IObjectValue)_tmpInfo);
        this.addBGSheetParam(ctx, templateInfo);
        this.updatePostil(ctx, templateInfo);
    }

    private Book createNewBook(Context ctx) {
        Book book = null;
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        book = Book.Manager.getNewBook(null, (int)1);
        Sheet sheet = null;
        int n = book.getSheetCount();
        for (int i = 0; i < n; ++i) {
            sheet = book.getSheet(i);
            sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
            BgNFSHelper.setSheetSign(sheet);
        }
        return book;
    }

    private void transAndCheckBookForNoView(Context ctx, BgTemplateInfo model, Book book, List formulaList, Set bgItemSet, Set bgElementSet, Set bgPeriodSet, Set currencySet) throws EASBizException, BOSException {
        boolean isAssignTemplate = Boolean.TRUE.equals(ctx.get((Object)BgNFSHelper.getTemplateKey(ctx, model)));
        Sheet sheet = null;
        Cell cell = null;
        String formulaStr = null;
        String expression = null;
        String _tmpStr = null;
        String[] formula = null;
        String[] _tmpStrs = null;
        String[] bgItemNums = null;
        ArrayList<String[]> checkList = new ArrayList<String[]>();
        ArrayList<String> bgItemNumList = new ArrayList<String>();
        HashSet<String> bgPeriodVariable = new HashSet<String>();
        String orgUnitId = model.getOrgUnit() == null ? ContextUtil.getCurrentOrgUnit((Context)ctx).getId().toString() : model.getOrgUnit().getId().toString();
        BgNFSHelper.disableCal(book);
        BgNFSHelper.disableUndo(book);
        boolean isAnalyseSheet = false;
        if (model.getBgType() != null && "bgMAAAAKIcA7rHKd".equals(model.getBgType().getId().toString())) {
            isAnalyseSheet = true;
        }
        HashSet<String> bgPeriodNumbers = new HashSet<String>();
        int sheetCount = book.getSheetCount();
        for (int sheetIndex = 0; sheetIndex < sheetCount; ++sheetIndex) {
            sheet = book.getSheet(sheetIndex);
            int maxRowCount = sheet.getMaxRowIndex();
            int maxColCount = sheet.getMaxColIndex();
            for (int i = 0; i <= maxRowCount; ++i) {
                for (int j = 0; j <= maxColCount; ++j) {
                    cell = sheet.getCell(i, j, false);
                    if (!BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                    formulaStr = BgNFSHelper.getFormulaOfCell(cell);
                    formulaList.add(formulaStr);
                    if (isAnalyseSheet) {
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                    formula = new String[]{sheet.getSheetName(), formulaStr, String.valueOf(i), String.valueOf(j)};
                    checkList.add(formula);
                    _tmpStrs = BgNFSHelper.parseFormulaPara(formulaStr);
                    if (_tmpStrs == null || _tmpStrs.length != 6) {
                        throw new BgException(BgException.BGITEMPARSEERROR, (Object[])new String[]{formulaStr});
                    }
                    _tmpStr = _tmpStrs[0];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"item.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                    }
                    bgItemSet.add(_tmpStr.replaceAll(",", "_"));
                    bgItemNums = _tmpStr.split(",");
                    for (int x = 0; x < bgItemNums.length; ++x) {
                        if (bgItemNumList.contains(bgItemNums[x])) continue;
                        bgItemNumList.add(bgItemNums[x]);
                    }
                    _tmpStr = _tmpStrs[2];
                    if (StringUtils.isEmpty((String)_tmpStr)) {
                        String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"element.formula.not.exit", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                    }
                    bgElementSet.add(_tmpStr);
                    _tmpStr = _tmpStrs[1];
                    if (!StringUtils.isEmpty((String)_tmpStr)) {
                        bgPeriodNumbers.add(_tmpStr);
                        if (!bgPeriodVariable.contains(_tmpStr)) {
                            boolean isRelativeBgPeriod = false;
                            int relativeValue = 0;
                            try {
                                relativeValue = Integer.parseInt(_tmpStr);
                                isRelativeBgPeriod = true;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (isRelativeBgPeriod) {
                                if (Math.abs(relativeValue) > 100) {
                                    String msg = sheet.getSheetName() + "," + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"itemformula.to.100.to100", (Locale)ctx.getLocale());
                                    throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                                }
                            } else if (BgPeriodNVariableHelper.checkCanConvert((String)_tmpStr)) {
                                bgPeriodVariable.add(_tmpStr);
                            } else {
                                bgPeriodSet.add(_tmpStr);
                            }
                        }
                    }
                    if (!StringUtils.isEmpty((String)(_tmpStr = _tmpStrs[5]))) {
                        currencySet.add(_tmpStr);
                    }
                    if (!StringUtils.isEmpty((String)(expression = BgNFSHelper.getExpression(cell))) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inDataFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                        }
                    }
                    expression = cell.getFormula();
                    if (cell.hasFormula() && !StringUtils.isEmpty((String)expression) && !isAssignTemplate) {
                        try {
                            ExcelFormulaPaserHelper.parse((String)expression);
                        }
                        catch (Exception e) {
                            String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inActualFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                            throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                        }
                    }
                    expression = cell.getFormula();
                    if (!cell.hasFormula() || StringUtils.isEmpty((String)expression) || isAssignTemplate) continue;
                    try {
                        ExcelFormulaPaserHelper.parse((String)expression);
                        continue;
                    }
                    catch (Exception e) {
                        String msg = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"inADDFormula", (Locale)ctx.getLocale()) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"sheet", (Locale)ctx.getLocale()) + sheet.getSheetName() + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (i + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"row", (Locale)ctx.getLocale()) + "\uff0c" + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"no", (Locale)ctx.getLocale()) + (j + 1) + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"col", (Locale)ctx.getLocale()) + ", " + ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateProcessUIResource", (String)"formulaError", (Locale)ctx.getLocale());
                        throw new BgFormException(BgFormException.SHOWEXCEPTION, new String[]{msg});
                    }
                }
            }
        }
        try {
            BgPeriodDispFactory.getLocalInstance((Context)ctx).checkPeriodType(bgPeriodNumbers, false);
            DimensionFormulaHelper.checkDimensionMemberExist(ctx, orgUnitId, bgItemNumList);
        }
        catch (EASBizException ex) {
            throw ex;
        }
        finally {
            checkList.clear();
        }
    }

    private Book transAndCheckBook(Context ctx, BgTemplateInfo model, Book book) throws BOSException, EASBizException {
        if (ctx == null || model == null || book == null) {
            return book;
        }
        HashSet bgItemSet = new HashSet();
        HashSet bgPeriodSet = new HashSet();
        HashSet bgElementSet = new HashSet();
        HashSet currencySet = new HashSet();
        ArrayList formulaList = new ArrayList();
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)model.getFormType())) {
            this.transAndCheckBookForView(ctx, model, book, formulaList, bgItemSet, bgElementSet, bgPeriodSet, currencySet);
        } else if (book != null && (BgTemFormTypeEnum.FIXEDFORM.equals((Object)model.getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)model.getFormType()))) {
            this.transAndCheckBookForNoView(ctx, model, book, formulaList, bgItemSet, bgElementSet, bgPeriodSet, currencySet);
            if (model.getRootId().toString().equals(model.getId().toString())) {
                BgViewDimensionFactory.getLocalInstance(ctx).saveFixedTemplateDimension(model.getId().toString(), formulaList);
            }
        }
        return book;
    }

    private void transAndCheckBookForView(Context ctx, BgTemplateInfo model, Book book, List formulaList, Set bgItemSet, Set bgElementSet, Set bgPeriodSet, Set currencySet) throws BOSException, EASBizException {
    }

    private void addBGSheetParam(Context ctx, VirtualSheetParamInfo virtualSheetParamInfo) throws BOSException, EASBizException {
        String sql1 = "DELETE FROM T_RPT_RptPostil WHERE FREPORTID=?";
        DbUtil.execute((Context)ctx, (String)sql1, (Object[])new Object[]{virtualSheetParamInfo.getId().toString()});
        IRptSheetParam isheet = RptSheetParamFactory.getLocalInstance((Context)ctx);
        RptSheetParamCollection rptSheetParamCollection = virtualSheetParamInfo.getSheetParam();
        ReportBaseInfo info = new ReportBaseInfo();
        info.setId(virtualSheetParamInfo.getId());
        if (rptSheetParamCollection != null && rptSheetParamCollection.size() > 0) {
            BOSUuid id = virtualSheetParamInfo.getId();
            if (id != null) {
                String sql = "DELETE FROM T_RPT_RptSheetPara WHERE FREPORTID=?";
                DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{id.toString()});
            }
            int rptSheetParamInfoSize = rptSheetParamCollection.size();
            for (int i = 0; i < rptSheetParamInfoSize; ++i) {
                BOSUuid spid;
                RptSheetParamInfo rptSheetParamInfo = rptSheetParamCollection.get(i);
                if (rptSheetParamInfo == null) continue;
                if (rptSheetParamInfo.getId() != null && (spid = rptSheetParamInfo.getId()) != null) {
                    String sql = "DELETE FROM T_RPT_RptPostil WHERE FSHEETID=?";
                    DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{spid.toString()});
                }
                rptSheetParamInfo.setId(null);
                rptSheetParamInfo.setReport((VirtualSheetParamInfo)info);
                isheet.addnew((CoreBaseInfo)rptSheetParamInfo);
            }
        }
    }

    private void updatePostil(Context ctx, BgTemplateInfo info) throws BOSException {
        if (info == null) {
            return;
        }
        String pk = info.getId().toString();
        try {
            String sql = "DELETE FROM T_MBg_BgTempaltePostil WHERE ftemplateid=?";
            DbUtil.execute((Context)ctx, (String)sql, (Object[])new Object[]{pk.toString()});
            BgTemplatePostilCollection postils = (BgTemplatePostilCollection)((Object)info.get("postils"));
            IBgTemplatePostil ip = BgTemplatePostilFactory.getLocalInstance(ctx);
            if (postils != null) {
                for (int i = 0; i < postils.size(); ++i) {
                    BgTemplatePostilInfo p = postils.get(i);
                    if (!p.getTemplate().getId().toString().equals(pk)) continue;
                    p.setId(null);
                    if (!p.getPostilType().equals((Object)PostilTypeEnum.REPORT)) {
                        ip.addnew((CoreBaseInfo)p);
                        continue;
                    }
                    ip.addnew((CoreBaseInfo)p);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    public SelectorItemCollection getSelectors() {
        return BgTemplateHelper.getSelector();
    }

    @Override
    protected void _clone(Context ctx, IObjectPK bgTemplatePK, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (orgUnitId == null || bgTemplatePK == null) {
            return;
        }
        SelectorItemCollection sic = this.getSelectors();
        BgTemplateInfo info = this.getBgTemplateInfo(ctx, bgTemplatePK, sic);
        if (info.getDefaultMeasureUnit() != null && info.getDefaultMeasureUnit().isIsDisabled()) {
            throw new BgTemplateException(BgTemplateException.IMPORTNOTFOUNDMEASUREUNIT, new Object[]{info.getDefaultMeasureUnit().getNumber()});
        }
        BgTemplateInfo cloneInfo = info.deepClone();
        OrgUnitInfo currentOrgUnit = ContextUtil.getCurrentOrgUnit((Context)ctx);
        cloneInfo.setOrgUnit(new FullOrgUnitInfo());
        cloneInfo.getOrgUnit().setId(orgUnitId);
        cloneInfo.setTemplateStatus(BgTemplateStatusEnum.CANCEL_CANCEL);
        if (ContextUtil.getCurrentUserInfo((Context)ctx) != null) {
            cloneInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
            cloneInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        cloneInfo.setNumber("clone_" + cloneInfo.getNumber());
        cloneInfo.setName(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgSchemeResource", (String)"clone", (Locale)ctx.getLocale()) + "_" + cloneInfo.getName());
        if (cloneInfo.getNumber().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NUMBERTOOLONG);
        }
        if (cloneInfo.getName().length() > 80) {
            throw new BgTemplateException(BgTemplateException.NAMETOOLONG);
        }
        if (this._checkNumberDup(ctx, cloneInfo.getBgScheme().getId().toString(), cloneInfo.getNumber(), "", cloneInfo.getOrgUnit().getId().toString())) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        Set<String> sheetIdList = null;
        ArrayList<Integer> index = new ArrayList<Integer>();
        try {
            UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
            sheetIdList = MbgPermissionHelper.getSheetPermissionByParam(ctx, RptSrcTypeEnum.PT_BUDGET_REPORT, userInfo.getId().toString(), info.getId().toString(), info.getBgScheme().getId().toString());
            Book book = cloneInfo.getBook();
            if (book != null) {
                book.setAutoCalculate(false);
            }
            Sheet sheet = null;
            if (info.getFormType().getValue() == 0 || info.getFormType().getValue() == 8) {
                int i;
                int n = book.getSheetCount();
                for (i = 0; i < n; ++i) {
                    sheet = book.getSheet(i);
                    sheet.setUserObject("SHEET_CREATER_ID", (Object)userInfo.getId().toString());
                    BgNFSHelper.setSheetSign(sheet);
                    this.replaceForceLock(sheet, currentOrgUnit);
                    if (sheetIdList == null || sheetIdList.isEmpty() || sheetIdList.contains(sheet.getID().toString())) continue;
                    index.add(i);
                }
                for (i = index.size() - 1; i >= 0; --i) {
                    book.removeSheet(((Integer)index.get(i)).intValue());
                }
            }
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
            }
            catch (Exception e) {
                throw new BOSException(e.toString());
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
            cloneInfo.setData(IOHelper.packBook((Book)book));
        }
        catch (IOException e) {
            throw new BgTemplateException(BgTemplateException.OPENBOOKFAIL, e);
        }
        catch (Exception e) {
            throw new BOSException(e.toString());
        }
        if (BgTemFormTypeEnum.SPECIALFORM.equals((Object)info.getFormType())) {
            cloneInfo.getBgSpecialItems().clear();
            cloneInfo.getBgSpecialItems().add(this.cloneBgSpecialItems(ctx, info));
        }
        AttachmentServerManager attachmentServerManager = AttachmentManagerFactory.getServerManager((Context)ctx);
        if (BgTemFormTypeEnum.VIEWFORM.equals((Object)info.getFormType()) || BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getFormType())) {
            BgViewDimensionInfo old = BgViewDimensionFactory.getLocalInstance(ctx).getBgViewDimensionInfo("where template.id = '" + bgTemplatePK + "'");
            old = (BgViewDimensionInfo)old.clone();
            old.setId(BOSUuid.create((BOSObjectType)old.getBOSType()));
            old.setTemplate(cloneInfo);
            try {
                int i;
                IMbgViewBase viewManager;
                Object paesers;
                if (info.getFormType().getValue() == 4) {
                    paesers = new MbgXMLParser(ctx);
                    viewManager = new MbgXMLParser(ctx).parse(old.getData());
                    if (viewManager != null) {
                        for (i = 0; i < viewManager.getSheetManagers().size(); ++i) {
                            IMbgSheetManager manager = viewManager.getSheetManagers().get(i);
                            if (sheetIdList == null || sheetIdList.isEmpty() || sheetIdList.contains(manager.getSheetID().toString())) continue;
                            index.add(i);
                        }
                        for (i = index.size() - 1; i >= 0; --i) {
                            viewManager.getSheetManagers().remove(i);
                        }
                        old.setData(MbgXMLParser.unParse((IMbgViewManager)viewManager));
                    }
                } else if (info.getFormType().getValue() == 2 && (viewManager = ((MbgViewListXMLParser)(paesers = new MbgViewListXMLParser(ctx))).parse(old.getData())) != null) {
                    for (int j = 0; j < ((AbstractMbgViewBase)viewManager).getSheetManagers().size(); ++j) {
                        MbgViewListSheetManager manager = (MbgViewListSheetManager)((AbstractMbgViewBase)viewManager).getSheetManagers().get(j);
                        if (sheetIdList == null || sheetIdList.isEmpty() || sheetIdList.contains(manager.getSheetID().toString())) continue;
                        index.add(j);
                    }
                    for (i = index.size() - 1; i >= 0; --i) {
                        ((AbstractMbgViewBase)viewManager).getSheetManagers().remove(i);
                    }
                    old.setData(((MbgViewListXMLParser)paesers).unParse((MbgViewListManager)viewManager));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            IObjectPK pk = BgViewDimensionFactory.getLocalInstance(ctx).addNewView((IObjectValue)old, (IObjectValue)cloneInfo);
            if (pk != null && BgTemFormTypeEnum.VIEWLIST.equals((Object)info.getFormType())) {
                MbgViewListDesCellFactory.getLocalInstance(ctx).cloneFormTemplate(bgTemplatePK.toString(), pk.toString());
                DbUtil.execute((Context)ctx, (String)("Insert into T_MBG_MbgViewListEditNote(FID, FBgTemplateID, FSheetIndex, FValue) Select newbosid('" + new MbgViewListEditNoteInfo().getBOSType() + "'), ?, FSheetIndex, FValue FROM T_MBG_MbgViewListEditNote Where FBgTemplateID = ?"), (Object[])new Object[]{pk.toString(), bgTemplatePK.toString()});
            }
            if (pk != null) {
                BgNFSHelper.copyBizAttachmentFiles(attachmentServerManager, null, bgTemplatePK.toString(), pk.toString());
            }
        } else {
            IObjectPK pk = super._save(ctx, (IObjectValue)cloneInfo);
            if (cloneInfo.getData() != null && cloneInfo.getData().length != 0) {
                try {
                    this.transAndCheckBook(ctx, cloneInfo, cloneInfo.getBook());
                }
                catch (Exception e) {
                    logger.error((Object)"error:", (Throwable)e);
                }
            }
            if (pk != null) {
                BgNFSHelper.copyBizAttachmentFiles(attachmentServerManager, null, bgTemplatePK.toString(), pk.toString());
            }
        }
    }

    protected void replaceForceLock(Sheet sheet, OrgUnitInfo currentOrgUnit) {
        if (sheet != null && currentOrgUnit != null && !StringUtils.isEmpty((String)currentOrgUnit.getLongNumber())) {
            Cell cell = null;
            for (int r = 0; r < sheet.getMaxRowIndex(); ++r) {
                for (int c = 0; c < sheet.getMaxColIndex(); ++c) {
                    cell = sheet.getCell(r, c, false);
                    if (cell == null || !BgNTemplateHelper.hasForceLock(cell)) continue;
                    cell.setUserObject("force_lock_org_longnumber", (Object)currentOrgUnit.getLongNumber());
                }
            }
        }
    }

    @Override
    protected void _saveSimpleInfo(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuilder sql = new StringBuilder(60);
        BgTemplateInfo bgTemInfo = (BgTemplateInfo)info;
        String id = bgTemInfo.getId().toString();
        String name = bgTemInfo.getName();
        String number = bgTemInfo.getNumber();
        String description = bgTemInfo.getDescription();
        String orgUnitId = bgTemInfo.getOrgUnit().getId().toString();
        String bgTypeId = bgTemInfo.getBgType() == null ? null : bgTemInfo.getBgType().getId().toString();
        String scenarioId = bgTemInfo.getBgScenario() == null ? null : bgTemInfo.getBgScenario().getId().toString();
        String bgRollRuleId = bgTemInfo.getBgRollRule() == null ? null : bgTemInfo.getBgRollRule().getId().toString();
        boolean isTransferQingAnalyse = bgTemInfo.isIsTransferQingAnalyse();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (bgTemInfo.getDefaultMeasureUnit() == null) {
            throw new BgTemplateException(BgTemplateException.HAVENOTSETDEFAULTMEASUREUNIT);
        }
        String measureId = bgTemInfo.getDefaultMeasureUnit().getId().toString();
        if (this._checkNumberDup(ctx, bgTemInfo.getBgScheme().getId().toString(), number, id, orgUnitId)) {
            throw new BgTemplateException(BgTemplateException.NUMBERDUP);
        }
        if (this.isSelfAny(bgTemInfo)) {
            this.checkBgFormStateIfSelf(ctx, id);
            bgTemInfo = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(bgTemInfo.getId()));
            Book book = null;
            try {
                book = bgTemInfo.getBook();
            }
            catch (Exception e) {
                throw new BgTemplateException(BgTemplateException.OPENBOOKFAIL);
            }
            int sheetCount = book.getSheetCount();
            for (int k = 0; k < sheetCount; ++k) {
                Sheet sheet = book.getSheet(k);
                int maxRowIndex = sheet.getMaxRowIndex();
                for (int i = 0; i <= maxRowIndex; ++i) {
                    int maxColIndex = sheet.getMaxColIndex();
                    for (int j = 0; j <= maxColIndex; ++j) {
                        Cell cell = sheet.getCell(i, j, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell)) continue;
                        throw new BgTemplateException(BgTemplateException.SELF_ANA_TEM_NOT_ALLOW_ITEMFORMUL);
                    }
                }
            }
        }
        sql.append(" update T_MBg_bgtemplate set fname = ? ,fnumber = ? ,fdescription = ? , fbgtypeid = ? ,fDefaultMeasureUnitId = ? ,FLastUpdateTime=? ,FBGSCENARIOID=? , FIsReadOnly = ? , FBgRollRuleID = ?,FIsTransferQingAnalyse = ? where fid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, name.trim());
            sm.setString(2, number.trim());
            sm.setString(3, description);
            sm.setString(4, bgTypeId);
            sm.setString(5, measureId);
            sm.setTimestamp(6, time);
            sm.setString(7, scenarioId);
            sm.setBoolean(8, bgTemInfo.isReadonly());
            sm.setString(9, bgRollRuleId);
            sm.setBoolean(10, isTransferQingAnalyse);
            sm.setString(11, id);
            sm.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        this.updateBgSpecialItem(ctx, (BgTemplateInfo)info);
    }

    private void checkBgFormStateIfSelf(Context ctx, String id) throws BOSException, BgTemplateException {
        BgFormCollection bgFormCollection = BgFormFactory.getLocalInstance(ctx).getBgFormCollection("select state,orgUnit.id,orgUnit.number,orgUnit.name where bgTemplate.id = '" + id + "'");
        for (int i = 0; i < bgFormCollection.size(); ++i) {
            BgFormInfo formInfo = bgFormCollection.get(i);
            if (BgFormStateEnum.Edited.equals((Object)formInfo.getState())) continue;
            throw new BgTemplateException(BgTemplateException.CHECKBGFORMIFSELF, new Object[]{formInfo.getOrgUnit().getNumber(), formInfo.getOrgUnit().getName()});
        }
    }

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgForm where FBgTemplateID = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)sm, (Connection)connection);
        return result;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("formType"));
        BgTemplateInfo info = this.getBgTemplateInfo(ctx, pk, sic);
        BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)info, (String)info.getOrgUnit().getId().toString(), (String)info.getNumber());
        super._delete(ctx, pk);
        BgViewDimensionFactory.getLocalInstance(ctx).deleteDimension(pk.toString());
        DbUtil.execute((Context)ctx, (String)" delete from T_MBG_BgTemSheet where FBgTemplateID = ? ", (Object[])new String[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)" delete from T_MBG_BgTemplateNode where FBgTemplateID = ? ", (Object[])new String[]{pk.toString()});
        MbgViewListDescriptionHelper.clearViewlistDesEntries(ctx, pk.toString());
    }

    @Override
    protected String[] _delete(Context ctx, String parentBgOrgUnitId, Map ids, Set orgPermIds) throws BOSException, EASBizException {
        String[] stringArray;
        String bgTemplateId2;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        Map<Object, Object> orgMap;
        LinkedHashMap<String, String> bgTemplateMap;
        HashMap permOrgMap;
        HashMap virtualOrgMap;
        HashMap<String, String> dispatchedMap;
        HashMap refMap;
        int totalCount;
        block26: {
            Iterator itOrg;
            Set orgUnitIds;
            if (ids == null || ids.isEmpty()) {
                return null;
            }
            Map _ids = ids;
            totalCount = 0;
            refMap = new HashMap();
            dispatchedMap = new HashMap<String, String>();
            virtualOrgMap = new HashMap();
            permOrgMap = new HashMap();
            bgTemplateMap = new LinkedHashMap<String, String>();
            orgMap = new LinkedHashMap();
            HashSet<IObjectPK> deletePks = new HashSet<IObjectPK>();
            conn = null;
            pstmt = null;
            rst = null;
            StringBuffer sql = new StringBuffer();
            Map<String, Boolean> virtualMap = this.getVirtualOrgMap(ctx, parentBgOrgUnitId, _ids);
            for (String bgTemplateId2 : _ids.keySet()) {
                orgUnitIds = (Set)_ids.get(bgTemplateId2);
                totalCount += orgUnitIds.size();
                itOrg = orgUnitIds.iterator();
                while (itOrg.hasNext()) {
                    String string = (String)itOrg.next();
                    if (!Boolean.TRUE.equals(virtualMap.get(string))) continue;
                    itOrg.remove();
                    if (!virtualOrgMap.containsKey(bgTemplateId2)) {
                        virtualOrgMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)virtualOrgMap.get(bgTemplateId2)).add(string);
                    orgMap.put(string, null);
                }
            }
            for (String bgTemplateId2 : _ids.keySet()) {
                orgUnitIds = (Set)_ids.get(bgTemplateId2);
                itOrg = orgUnitIds.iterator();
                while (itOrg.hasNext()) {
                    String string = (String)itOrg.next();
                    if (orgPermIds.contains(string)) continue;
                    itOrg.remove();
                    if (!permOrgMap.containsKey(bgTemplateId2)) {
                        permOrgMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)permOrgMap.get(bgTemplateId2)).add(string);
                    orgMap.put(string, null);
                }
            }
            conn = this.getConnection(ctx);
            List<Object[]> params = new ArrayList();
            for (Map.Entry entry : _ids.entrySet()) {
                if (((Set)entry.getValue()).isEmpty()) continue;
                params.addAll(MbgSqlHelper.getBatchParams((Object[])new Object[]{entry.getKey()}, (Object[])((Set)entry.getValue()).toArray(), (int)50));
            }
            sql.setLength(0);
            sql.append("Select FBgTemplateId, FOrgUnitId FROM T_MBg_BgForm Where FBgTemplateId = ? And FOrgUnitId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FBgTemplateId");
                    String string = rst.getString("FOrgUnitId");
                    orgMap.put(string, null);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    if (!refMap.containsKey(bgTemplateId2)) {
                        refMap.put(bgTemplateId2, new HashSet());
                    }
                    ((Set)refMap.get(bgTemplateId2)).add(string);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            sql.setLength(0);
            sql.append("Select bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId, Count(tempNode.FID) FTemplateCount FROM T_Mbg_BgTemplate bgTemplate Left Join T_MBg_BgTemplateNode tempNode On bgTemplate.FID = tempNode.FBgTemplateId Where bgTemplate.FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Group By bgTemplate.FNumber, bgTemplate.FID, bgTemplate.FOrgUnitId");
            params = MbgSqlHelper.getBatchParams(null, (Object[])_ids.keySet().toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateId2 = rst.getString("FID");
                    String string = rst.getString("FOrgUnitId");
                    int count = rst.getInt("FTemplateCount");
                    bgTemplateMap.put(bgTemplateId2, rst.getString("FNumber"));
                    if (!((Set)_ids.get(bgTemplateId2)).contains(string)) continue;
                    if (((Set)_ids.get(bgTemplateId2)).size() == count) {
                        deletePks.add((IObjectPK)new ObjectStringPK(bgTemplateId2));
                        continue;
                    }
                    dispatchedMap.put(bgTemplateId2, string);
                    ((Set)_ids.get(bgTemplateId2)).remove(string);
                    orgMap.put(string, null);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            params.clear();
            for (String bgTemplateId2 : _ids.keySet()) {
                for (String string : (Set)_ids.get(bgTemplateId2)) {
                    params.add(new Object[]{bgTemplateId2, string});
                }
            }
            if (!params.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete From T_MBg_BgTemplateNode Where FBgTemplateId = ? AND FOrgUnitId = ?", params);
            }
            if (!deletePks.isEmpty()) {
                this.beforeDeleteTemplate(ctx, deletePks);
                this._delete(ctx, deletePks.toArray(new IObjectPK[0]));
                this.afterDeleteTemplate(ctx, deletePks);
            }
            if (!orgMap.isEmpty()) break block26;
            Iterator it = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return it;
        }
        try {
            orgMap = this.getOrgMap(ctx, conn, orgMap.keySet());
            int failCount = 0;
            String msgRefForm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)"checkRefByForm", (Locale)ctx.getLocale());
            String msgDispatched = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)"checkDispatched", (Locale)ctx.getLocale());
            String msgPerm = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)"noDeletePermOrg", (Locale)ctx.getLocale());
            String msgVirtual = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)"checkVirtual", (Locale)ctx.getLocale());
            String msgFormat = null;
            StringBuffer msg = new StringBuffer();
            for (Map.Entry entry : bgTemplateMap.entrySet()) {
                bgTemplateId2 = (String)entry.getKey();
                for (String string : orgMap.keySet()) {
                    msgFormat = virtualOrgMap.containsKey(bgTemplateId2) && ((Set)virtualOrgMap.get(bgTemplateId2)).contains(string) ? msgVirtual : (permOrgMap.containsKey(bgTemplateId2) && ((Set)permOrgMap.get(bgTemplateId2)).contains(string) ? msgPerm : (refMap.containsKey(bgTemplateId2) && ((Set)refMap.get(bgTemplateId2)).contains(string) ? msgRefForm : (string.equals(dispatchedMap.get(bgTemplateId2)) ? msgDispatched : null)));
                    if (msgFormat == null) continue;
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgFormat, orgMap.get(string), entry.getValue()));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)"deleteMsg", (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }

    private Map<String, Boolean> getVirtualOrgMap(Context ctx, String parentBgOrgUnitId, Map<String, Set<String>> _ids) throws BOSException, EASBizException {
        HashSet orgUnitIds = new HashSet();
        Iterator<Set<String>> it = _ids.values().iterator();
        while (it.hasNext()) {
            orgUnitIds.addAll(it.next());
        }
        return BgOrgUnitFactory.getLocalInstance(ctx).getOrgVirtualInfo(parentBgOrgUnitId, orgUnitIds);
    }

    private void beforeDeleteTemplate(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("mapData"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("formType"));
        sic.add(new SelectorItemInfo("sourceType"));
        filter.getFilterItems().add(new FilterItemInfo("id", deletePks, CompareType.INCLUDE));
        evi.setFilter(filter);
        BgTemplateCollection bgTemColls = this.getBgTemplateCollection(ctx, evi);
        BgTemplateInfo bgTemplateInfo = null;
        for (int i = 0; i < bgTemColls.size(); ++i) {
            bgTemplateInfo = bgTemColls.get(i);
            BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)bgTemplateInfo, (String)bgTemplateInfo.getOrgUnit().getId().toString(), (String)bgTemplateInfo.getNumber(), (String)"sourceType");
        }
    }

    private void afterDeleteTemplate(Context ctx, Set<IObjectPK> deletePks) throws BOSException, EASBizException {
        if (deletePks.size() == 0 || deletePks == null) {
            return;
        }
        ArrayList<String> deleteIds = new ArrayList<String>();
        for (IObjectPK iPk : deletePks) {
            deleteIds.add(iPk.toString());
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBg_BgViewDimension  where FTemplateID = ?", deleteIds);
            BgFacadeHelper.deleteRef(ctx, deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgTemSheet where FBgTemplateID = ?", deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_MbgPermission where FBgTemplateID = ?", deleteIds);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"delete from T_MBG_BgSheetpermission where FBgTemplateID = ?", deleteIds);
            MbgDimRelationRefServerHelper.removeRelationRef(ctx, conn, deleteIds);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getOrgMap(Context ctx, Connection conn, Set<String> orgIds) throws SQLException {
        LinkedHashMap<String, String> orgMap = new LinkedHashMap<String, String>();
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FName_").append(ctx.getLocale()).append(" FName FROM T_Org_BaseUnit Where FID IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FNumber");
            List params = MbgSqlHelper.getBatchParams(null, (Object[])orgIds.toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            orgMap.clear();
            for (int i = 0; i < params.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])params.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    orgMap.put(rst.getString("FID"), rst.getString("FName"));
                }
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, pstmt);
            throw throwable;
        }
        SQLUtils.cleanup(rst, (Statement)pstmt);
        return orgMap;
    }

    @Override
    protected void _saveMeasure(Context ctx, IObjectValue info) throws BOSException, EASBizException {
        BgTemplateInfo bgTem = (BgTemplateInfo)info;
        String id = bgTem.getId().toString();
        PreparedStatement ps = null;
        Connection connection = null;
        BOSObjectType type = new BgMeasureUnitInfo().getBOSType();
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(80);
            strBuffer.append("delete T_MBg_bgtemmeasureunit where fbgtemplateid = ? ");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            ps.executeUpdate();
            if (bgTem.getBgMeasureUnit() != null && bgTem.getBgMeasureUnit().size() != 0) {
                strBuffer = new StringBuffer(80);
                strBuffer.append("insert into T_MBg_bgtemmeasureunit(fid,fbgtemplateid,fbgelementid,fmeasureunitid) values(?,?,?,?)");
                ps = connection.prepareStatement(strBuffer.toString());
                for (int i = 0; i < bgTem.getBgMeasureUnit().size(); ++i) {
                    ps.setString(1, BOSUuid.create((BOSObjectType)type).toString());
                    ps.setString(2, id);
                    ps.setString(3, bgTem.getBgMeasureUnit().get(i).getBgElement().getId().toString());
                    ps.setString(4, bgTem.getBgMeasureUnit().get(i).getMeasureUnit().getId().toString());
                    ps.addBatch();
                }
                ps.executeBatch();
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException(e.toString());
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)connection);
    }

    private boolean isSelfAny(BgTemplateInfo templateInfo) {
        boolean isSelAny = false;
        if (templateInfo.getBgType() != null && templateInfo.getBgType().getId().toString().equals("bgMAAAAKIcA7rHKd")) {
            isSelAny = true;
        }
        return isSelAny;
    }

    protected IObjectPK[] _addnewBatchData(Context arg0, IObjectCollection arg1) throws BOSException, EASBizException {
        for (int i = 0; i < arg1.size(); ++i) {
            BgTemplateInfo bgTemplateInfo = (BgTemplateInfo)arg1.getObject(i);
            this._addnew(arg0, (IObjectValue)bgTemplateInfo);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void _updateDataInfo(Context ctx, IObjectValue templateInfo) throws BOSException, EASBizException {
        if (templateInfo == null) return;
        if (templateInfo.getString("id") == null) {
            return;
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBg_BgTemplate set FData = ? where FID = ?");
            byte[] bytes = templateInfo.getBytes("data");
            if (bytes != null && bytes.length > 0) {
                pstmt.setBinaryStream(1, (InputStream)new ByteArrayInputStream(bytes), bytes.length);
            } else {
                pstmt.setBytes(1, null);
            }
            pstmt.setString(2, templateInfo.getString("id"));
            pstmt.executeUpdate();
        }
        catch (BOSException ex) {
            try {
                throw ex;
                catch (SQLException ex2) {
                    logger.error((Object)"error:", (Throwable)ex2);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
    }

    @Override
    protected String[] _cancel(Context ctx, String parentBgOrgUnitId, Map idList) throws BOSException, EASBizException {
        return this.doBatchCancelOrCancelCancel(ctx, parentBgOrgUnitId, idList, true);
    }

    @Override
    protected String[] _cancelCancel(Context ctx, String parentBgOrgUnitId, Map idList) throws BOSException, EASBizException {
        return this.doBatchCancelOrCancelCancel(ctx, parentBgOrgUnitId, idList, false);
    }

    private String[] doBatchCancelOrCancelCancel(Context ctx, String parentBgOrgUnitId, Map<String, Set<String>> idList, boolean isCancel) throws BOSException, EASBizException {
        String[] stringArray;
        HashSet<String> editIds;
        String orgUnitId2;
        HashSet<String> orgIds;
        HashSet<String> topTempIds;
        LinkedHashMap<String, String> templateNumber;
        HashMap<String, String> templateCreateOrg;
        int totalCount;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block21: {
            IMutexServiceControl iMC;
            if (idList == null || idList.isEmpty()) {
                return null;
            }
            conn = null;
            pstmt = null;
            rst = null;
            totalCount = 0;
            Map<String, Boolean> virtualOrgMap = this.getVirtualOrgMap(ctx, parentBgOrgUnitId, idList);
            conn = this.getConnection(ctx);
            templateCreateOrg = new HashMap<String, String>();
            templateNumber = new LinkedHashMap<String, String>();
            StringBuffer sql = new StringBuffer();
            sql.append("Select FID, FNumber, FOrgUnitId From T_MBg_BgTemplate Where FID IN (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(") Order By FNumber");
            List paramList = MbgSqlHelper.getBatchParams(null, (Object[])idList.keySet().toArray(), (int)50);
            pstmt = conn.prepareStatement(sql.toString());
            for (int i = 0; i < paramList.size(); ++i) {
                MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    templateCreateOrg.put(rst.getString("FID"), rst.getString("FOrgUnitId"));
                    templateNumber.put(rst.getString("FID"), rst.getString("FNumber"));
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup((Statement)pstmt);
            topTempIds = new HashSet<String>();
            orgIds = new HashSet<String>();
            for (String bgTemplateId : new HashSet<String>(idList.keySet())) {
                orgUnitId2 = (String)templateCreateOrg.get(bgTemplateId);
                if (idList.get(bgTemplateId).contains(orgUnitId2) && Boolean.FALSE.equals(virtualOrgMap.get(orgUnitId2))) {
                    topTempIds.add(bgTemplateId);
                }
                orgIds.addAll((Collection<String>)idList.get(bgTemplateId));
                totalCount += idList.get(bgTemplateId).size();
                if (Boolean.FALSE.equals(virtualOrgMap.get(orgUnitId2))) {
                    idList.get(bgTemplateId).remove(orgUnitId2);
                }
                if (!idList.get(bgTemplateId).isEmpty()) continue;
                idList.remove(bgTemplateId);
            }
            editIds = new HashSet<String>();
            if (!topTempIds.isEmpty()) {
                iMC = MutexServiceControlFactory.getLocalInstance((Context)ctx);
                Map mcIds = iMC.batchRequestObjIDForUpdate(new ArrayList(topTempIds));
                if (mcIds != null) {
                    for (String bgTemplateId : mcIds.keySet()) {
                        if (Boolean.TRUE.equals(mcIds.get(bgTemplateId))) continue;
                        topTempIds.remove(bgTemplateId);
                        editIds.add(bgTemplateId);
                    }
                }
                if (!topTempIds.isEmpty()) {
                    iMC.batchReleaseObjIDForUpdate(new ArrayList(topTempIds));
                }
            }
            if (!topTempIds.isEmpty()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBg_BgTemplate Set FTemplateStatus = " + (isCancel ? 10 : 0) + " Where FID = ?"), new ArrayList(topTempIds));
            }
            if (!editIds.isEmpty() || !idList.isEmpty()) break block21;
            iMC = null;
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            return iMC;
        }
        try {
            Map<String, String> orgMap = this.getOrgMap(ctx, conn, orgIds);
            int failCount = 0;
            String key = isCancel ? "cancel." : "cancelCancel.";
            String msgNoCreate = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "noCreateOrg"), (Locale)ctx.getLocale());
            String msgEditing = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "editing"), (Locale)ctx.getLocale());
            StringBuffer msg = new StringBuffer();
            for (String bgTemplateId : templateNumber.keySet()) {
                if (editIds.contains(bgTemplateId)) {
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    orgUnitId2 = (String)templateCreateOrg.get(bgTemplateId);
                    ++failCount;
                    msg.append(MessageFormat.format(msgEditing, orgMap.get(orgUnitId2), templateNumber.get(bgTemplateId)));
                }
                for (String orgUnitId2 : orgMap.keySet()) {
                    if (!idList.containsKey(bgTemplateId) || !idList.get(bgTemplateId).contains(orgUnitId2) || topTempIds.contains(bgTemplateId)) continue;
                    ++failCount;
                    if (msg.length() > 0) {
                        msg.append("\r\n");
                    }
                    msg.append(MessageFormat.format(msgNoCreate, orgMap.get(orgUnitId2), templateNumber.get(bgTemplateId)));
                }
            }
            String info = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.BgTemplateResource", (String)(key + "msg"), (Locale)ctx.getLocale()), totalCount, failCount, totalCount - failCount);
            stringArray = new String[]{info, msg.toString()};
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _getTemplateNumbers(Context ctx, String bgSchemeId, String orgId) throws BOSException {
        ArrayList<String> list = new ArrayList<String>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String sql = "select t1.FNumber from T_MBg_bgtemplate t1 Inner Join T_MBg_BgTemplateNode t2 ON t1.FID = t2.FBgTemplateId where t1.FBgSchemeId = ? AND t2.FOrgUnitID = ?";
        conn = this.getConnection(ctx);
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, bgSchemeId);
            pstmt.setString(2, orgId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                list.add(rst.getString(1));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        catch (SQLException e) {
            logger.error((Object)"getTemplateNumbers", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        }
        return list;
    }

    @Override
    protected Map _getRPCDataMap(Context ctx, Map paramMap) throws BOSException, EASBizException {
        HashMap<String, Boolean> rpcDataMap = new HashMap<String, Boolean>();
        BgTemplateInfo bgTemplateInfo = new BgTemplateInfo();
        ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        String CUID = (String)paramMap.get("CUID");
        boolean result = codingRuleManager.isExist((IObjectValue)bgTemplateInfo, CUID);
        rpcDataMap.put("hasCodingRule", result);
        String oprtState = (String)paramMap.get("oprtState");
        IMeasureUnit iM = MeasureUnitFactory.getLocalInstance((Context)ctx);
        EntityViewInfo muView = new EntityViewInfo();
        FilterInfo muFilter = new FilterInfo();
        muFilter.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        if (oprtState.equals(OprtState.ADDNEW)) {
            muFilter.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        }
        muView.setFilter(muFilter);
        muView.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol1 = iM.getMeasureUnitCollection(muView);
        rpcDataMap.put("muCol1", (Boolean)muCol1);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet<Integer> dataType = new HashSet<Integer>();
        dataType.add(new Integer(0));
        dataType.add(new Integer(1));
        dataType.add(new Integer(2));
        filter.getFilterItems().add(new FilterItemInfo("dataType", dataType, CompareType.INCLUDE));
        SorterItemInfo sorter = new SorterItemInfo("number");
        view.getSorter().add(sorter);
        view.setFilter(filter);
        String bgSchemeId = (String)paramMap.get("BGSCHEME_ID");
        if (!StringUtils.isEmpty((String)bgSchemeId)) {
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            filter.getFilterItems().add(new FilterItemInfo("id", schemeHelper.getMemberSet(DimensionConstants.DEF_ELEMENT_NUMBER, false), CompareType.INCLUDE));
        }
        IBgElement iElement = BgElementFactory.getLocalInstance((Context)ctx);
        BgElementCollection bgElementCol = iElement.getBgElementCollection(view);
        rpcDataMap.put("bgElementCol", (Boolean)bgElementCol);
        EntityViewInfo muView2 = new EntityViewInfo();
        FilterInfo muFilter2 = new FilterInfo();
        muFilter2.getFilterItems().add(new FilterItemInfo("measureUnitGroup.number", (Object)"BUDGET", CompareType.EQUALS));
        muFilter2.getFilterItems().add(new FilterItemInfo("isDisabled", (Object)Boolean.FALSE, CompareType.EQUALS));
        muView2.setFilter(muFilter2);
        muView2.getSorter().add(new SorterItemInfo("number"));
        MeasureUnitCollection muCol2 = iM.getMeasureUnitCollection(muView2);
        rpcDataMap.put("muCol2", (Boolean)muCol2);
        return rpcDataMap;
    }

    @Override
    protected int _forceChangeBgType(Context ctx, String orgId, Set templateIds) throws BOSException, EASBizException {
        return 0;
    }

    @Override
    protected void _checkBgTemplateDimension(Context ctx, List bgTemplateIds) throws BOSException, EASBizException {
        if (bgTemplateIds == null || bgTemplateIds.isEmpty()) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("template.id");
        evi.getSelector().add("template.number");
        evi.getSelector().add("template.name");
        evi.getSelector().add("template.bgScheme.id");
        evi.getSelector().add("id");
        evi.getSelector().add("data");
        evi.getSelector().add("template.formType");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("template.id", new HashSet(bgTemplateIds), CompareType.INCLUDE));
        BgViewDimensionCollection col = BgViewDimensionFactory.getLocalInstance(ctx).getBgViewDimensionCollection(evi);
        if (col == null || col.isEmpty()) {
            return;
        }
        HashMap<String, BgViewDimensionInfo> bgTemplateInfos = new HashMap<String, BgViewDimensionInfo>();
        for (int i = 0; i < col.size(); ++i) {
            bgTemplateInfos.put(col.get(i).getTemplate().getId().toString(), col.get(i));
        }
        HashMap bgTemplateList = new HashMap();
        HashMap bgTemplateSpecialList = new HashMap();
        evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("bgSpecialItems.dimensionNumber");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(bgTemplateIds), CompareType.INCLUDE));
        BgTemplateCollection col1 = BgTemplateFactory.getLocalInstance(ctx).getBgTemplateCollection(evi);
        HashSet<String> specialDims = null;
        for (int i = 0; i < col1.size(); ++i) {
            String bgSchemeId = col1.get(i).getBgScheme().getId().toString();
            specialDims = new HashSet();
            if (col1.get(i).getBgSpecialItems() != null) {
                for (int s = 0; s < col1.get(i).getBgSpecialItems().size(); ++s) {
                    String[] combins;
                    if (StringUtils.isEmpty((String)col1.get(i).getBgSpecialItems().get(s).getDimensionNumber())) continue;
                    for (String c : combins = DimensionFormulaHelper.splitCombinations(col1.get(i).getBgSpecialItems().get(s).getDimensionNumber())) {
                        specialDims.add(DimensionFormulaHelper.getSrcNumber(c));
                    }
                }
            }
            if (!bgTemplateList.containsKey(bgSchemeId)) {
                bgTemplateList.put(bgSchemeId, new ArrayList());
            }
            ((List)bgTemplateList.get(bgSchemeId)).add(bgTemplateInfos.get(col1.get(i).getId().toString()));
            if (!bgTemplateSpecialList.containsKey(bgSchemeId)) {
                bgTemplateSpecialList.put(bgSchemeId, new ArrayList());
            }
            ((List)bgTemplateSpecialList.get(bgSchemeId)).add(specialDims);
        }
        List<String> dimNumbers = null;
        specialDims = new HashSet<String>();
        for (String bgSchemeId : bgTemplateList.keySet()) {
            List list = (List)bgTemplateList.get(bgSchemeId);
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            dimNumbers = schemeHelper.getAllDim();
            for (int i = 0; i < list.size(); ++i) {
                specialDims.clear();
                for (String spNumber : (Set)((List)bgTemplateSpecialList.get(bgSchemeId)).get(i)) {
                    specialDims.add(schemeHelper.getDimensionBySrcNumber().get(DimensionFormulaHelper.getSrcNumber(spNumber)).getNumber());
                }
                this.verifyTemplate(ctx, dimNumbers, specialDims, (BgViewDimensionInfo)list.get(i));
            }
        }
    }

    private void verifyTemplate(Context ctx, List<String> dimNumbers, Set<String> specialDims, BgViewDimensionInfo bgViewDimensionInfo) throws BOSException, EASBizException {
        if (bgViewDimensionInfo == null) {
            return;
        }
        IMbgViewBase view = null;
        try {
            Object parser2;
            if (bgViewDimensionInfo.getTemplate().getFormType().equals((Object)BgTemFormTypeEnum.VIEWLIST)) {
                parser2 = new MbgViewListXMLParser(ctx);
                view = ((MbgViewListXMLParser)parser2).parse(bgViewDimensionInfo.getData());
            } else {
                parser2 = new MbgXMLParser(ctx);
                view = ((MbgXMLParser)parser2).parse(bgViewDimensionInfo.getData());
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        if (view == null) {
            return;
        }
        HashSet<String> backupDims = new HashSet<String>();
        for (int s = 0; s < view.getSheetManagers().size(); ++s) {
            IBgDimensionManagerBase dimManager = view.getSheetManagers().get(s).getDimensionManager();
            backupDims.clear();
            backupDims.addAll(dimNumbers);
            for (int d = 0; d < dimManager.getDimension().size(); ++d) {
                if (!(dimManager.getDimension().get(d) instanceof BgDimensionBaseInfo)) continue;
                BgDimensionBaseInfo dimension = (BgDimensionBaseInfo)dimManager.getDimension().get(d);
                if (!backupDims.contains(dimension.getNumber())) {
                    throw new TemplateException(TemplateException.CHECKTEMPLATEDIMENSION, new Object[]{bgViewDimensionInfo.getTemplate().getName()});
                }
                backupDims.remove(dimension.getNumber());
            }
            if (specialDims != null) {
                backupDims.removeAll(specialDims);
            }
            if (backupDims.isEmpty()) continue;
            throw new TemplateException(TemplateException.CHECKTEMPLATEDIMENSION, new Object[]{bgViewDimensionInfo.getTemplate().getName()});
        }
    }

    private BgSpecialItemsInfo cloneBgSpecialItems(Context ctx, BgTemplateInfo bgTemplateInfo) {
        if (bgTemplateInfo == null || bgTemplateInfo.getBgSpecialItems() == null || bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            return null;
        }
        BgSpecialItemsInfo oldInfo = bgTemplateInfo.getBgSpecialItems().get(0);
        BgSpecialItemsInfo newInfo = new BgSpecialItemsInfo();
        newInfo.setId(BOSUuid.create((BOSObjectType)newInfo.getBOSType()));
        newInfo.setBgTemplate(bgTemplateInfo);
        newInfo.setDimensionNumber(oldInfo.getDimensionNumber());
        newInfo.setDimensionName(oldInfo.getDimensionName());
        newInfo.setMemberName(oldInfo.getMemberName());
        newInfo.setCanAddMember(oldInfo.getCanAddMember());
        newInfo.setCreateTime(new Timestamp(System.currentTimeMillis()));
        newInfo.setLastUpdateTime(new Timestamp(System.currentTimeMillis()));
        newInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)ctx));
        newInfo.setLastUpdateUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        newInfo.setHide(oldInfo.getHide());
        newInfo.getDimRelaGroupRef().clear();
        newInfo.getDimRelaGroupRef().addCollection(this.cloneDimRelaGroupRef(oldInfo, newInfo));
        return newInfo;
    }

    private BgSpecialDimRelaGroupRefCollection cloneDimRelaGroupRef(BgSpecialItemsInfo oldInfo, BgSpecialItemsInfo newInfo) {
        if (oldInfo == null) {
            return null;
        }
        BgSpecialDimRelaGroupRefCollection newColl = new BgSpecialDimRelaGroupRefCollection();
        BgSpecialDimRelaGroupRefCollection coll = oldInfo.getDimRelaGroupRef();
        for (int i = 0; i < coll.size(); ++i) {
            BgSpecialDimRelaGroupRefInfo newRef = new BgSpecialDimRelaGroupRefInfo();
            newRef.setDimRelaGroup(coll.get(i).getDimRelaGroup());
            newRef.setBgSpecialItems(newInfo);
            newColl.add(newRef);
        }
        return newColl;
    }

    private void updateBgSpecialItem(Context ctx, BgTemplateInfo bgTemplateInfo) throws BOSException, EASBizException {
        if (bgTemplateInfo == null || bgTemplateInfo.getBgSpecialItems() == null || bgTemplateInfo.getBgSpecialItems().isEmpty()) {
            return;
        }
        BgSpecialItemsInfo item = bgTemplateInfo.getBgSpecialItems().get(0);
        String dimensionNumber = item.getDimensionNumber();
        String dimensionName = item.getDimensionName();
        String memberName = item.getMemberName();
        String hide = item.getHide();
        String userId = item.getLastUpdateUser().getId().toString();
        Timestamp time = item.getLastUpdateTime();
        String itemId = item.getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" update T_MBG_BgSpecialItems set FDimensionNumber = ? ,FDimensionName = ? ,FMemberName = ? , FHide = ?,   FLastUpdateUserID = ? ,FLastUpdateTime = ?, FCanAddMember = ?, FDimensionAlias = ? where fid = ? ");
        this.updateBgSpecialDimRelaGroupRef(ctx, item);
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql.toString(), (Object[])new Object[]{dimensionNumber, dimensionName, memberName, hide, userId, time, item.getCanAddMember(), item.getDimensionAlias(), itemId});
            DbUtil.execute((Context)ctx, (String)"Update T_MBG_BgSpecialItems Set FDimensionAlias = ? Where FBgFormId IS NOT NULL AND FBgFormId IN(Select FID FROM T_MBG_BgForm Where FBgTemplateId = ?)", (Object[])new Object[]{item.getDimensionAlias(), bgTemplateInfo.getId().toString()});
        }
        catch (SQLDataException e) {
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateBgSpecialDimRelaGroupRef(Context ctx, BgSpecialItemsInfo item) throws BOSException, EASBizException {
        if (item == null) {
            return;
        }
        BgSpecialDimRelaGroupRefCollection colls = item.getDimRelaGroupRef();
        FilterInfo filer = new FilterInfo();
        filer.getFilterItems().add(new FilterItemInfo("bgSpecialItems.id", (Object)item.getId().toString(), CompareType.EQUALS));
        IBgSpecialDimRelaGroupRef iBgSpecialDimRelaGroupRef = BgSpecialDimRelaGroupRefFactory.getLocalInstance(ctx);
        iBgSpecialDimRelaGroupRef.delete(filer);
        iBgSpecialDimRelaGroupRef.addBatch(colls);
    }

    @Override
    protected IObjectCollection _getDispatchOrgunitsByBgTemplateID(Context ctx, BOSUuid id) throws BOSException {
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        Connection conn = null;
        StringBuffer sql = new StringBuffer();
        BgOrgUnitCollection bgOrgUnitCollection = new BgOrgUnitCollection();
        try {
            conn = this.getConnection(ctx);
            sql.append("select FOrgUnitID from T_MBG_BgTemplateNode where FBgTemplateID = ?");
            Object[] params = new Object[]{id.toString()};
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])params);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                BgOrgUnitInfo bgOrgUnitInfo = new BgOrgUnitInfo();
                bgOrgUnitInfo.setId(BOSUuid.read((String)rst.getString("FOrgUnitID")));
                bgOrgUnitCollection.add(bgOrgUnitInfo);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return bgOrgUnitCollection;
    }
}

