/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeTableFactory;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.IExchangeTable;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.IFullOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgTransCurrencyFacadeFactory;
import com.kingdee.eas.ma.mbg.BgTransException;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IBgTransCurrencyFacade;
import com.kingdee.eas.ma.mbg.app.AbstractBgTransCurrencyFacadeControllerBean;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;

public class BgTransCurrencyFacadeControllerBean
extends AbstractBgTransCurrencyFacadeControllerBean {
    private static final long serialVersionUID = -419152855771590918L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgTransCurrencyFacadeControllerBean");

    protected IBgForm getBgFormInterface(Context ctx) throws BOSException {
        return BgFormFactory.getLocalInstance(ctx);
    }

    protected IBgScheme getBgSchemeInterface(Context ctx) throws BOSException {
        return BgSchemeFactory.getLocalInstance(ctx);
    }

    protected IBgPeriod getBgPeriodInterface(Context ctx) throws BOSException {
        return BgPeriodFactory.getLocalInstance((Context)ctx);
    }

    protected ICurrency getCurrencyInterface(Context ctx) throws BOSException {
        return CurrencyFactory.getLocalInstance((Context)ctx);
    }

    protected IFullOrgUnit getFullOrgUnitInterface(Context ctx) throws BOSException {
        return FullOrgUnitFactory.getLocalInstance((Context)ctx);
    }

    protected IBgTransCurrencyFacade getBgTransCurrencyFacadeInterface(Context ctx) throws Exception {
        return BgTransCurrencyFacadeFactory.getLocalInstance(ctx);
    }

    protected IExchangeTable getExchangeTableInterface(Context ctx) throws Exception {
        return ExchangeTableFactory.getLocalInstance((Context)ctx);
    }

    protected IExchangeRate getExchangeRateInterface(Context ctx) throws Exception {
        return ExchangeRateFactory.getLocalInstance((Context)ctx);
    }

    @Override
    protected List _transCurrencySingleToMul(Context ctx, List sourceInfoList, List targetInfoList) throws BOSException, EASBizException {
        this.checkParameter(sourceInfoList, targetInfoList, true);
        Object tmpVec = null;
        HashMap keyMap = new HashMap();
        HashMap bgFormMap = new HashMap();
        HashMap formulaMap = new HashMap();
        Object adjustMap = null;
        Object currencyMap = null;
        ArrayList result = new ArrayList();
        ArrayList mutexList = new ArrayList();
        ArrayList succeedList = new ArrayList();
        return result;
    }

    private Map getSourceCurrencyMapSingToMul(Context ctx, List sourceInfoList) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Vector vec = null;
        String bgFormID = null;
        String currencyID = null;
        BgFormInfo bgFormInfo = null;
        CurrencyInfo currencyInfo = null;
        Book book = null;
        Sheet sheet = null;
        Cell cell = null;
        int maxRow = 0;
        int maxCol = 0;
        for (int i = 0; i < sourceInfoList.size(); ++i) {
            vec = (Vector)sourceInfoList.get(i);
            bgFormID = vec.get(0).toString();
            currencyID = vec.get(1).toString();
            bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormID), this.getSelectors());
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
            book = bgFormInfo.getBook();
            if (book == null) continue;
            for (int j = 0; j < book.getSheetCount(); ++j) {
                sheet = book.getSheet(j);
                maxRow = sheet.getMaxRowIndex() + 1;
                maxCol = sheet.getMaxColIndex() + 1;
                for (int k = 0; k < maxRow; ++k) {
                    for (int m = 0; m < maxCol; ++m) {
                        String formulaString;
                        String[] params;
                        String currencyNumber;
                        cell = sheet.getCell(k, m, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || !(currencyNumber = (params = BgNFSHelper.parseFormulaPara(formulaString = BgNFSHelper.getFormulaOfCell(cell)))[4]).equals(currencyInfo.getNumber())) continue;
                        String key = params[0] + "_" + params[1] + "_" + params[2];
                        Variant value = cell.getValue();
                        if (value == null) continue;
                        map.put(key, value.getValue());
                    }
                }
            }
        }
        return map;
    }

    private Map getSourceCurrencyMapMulToSing(Context ctx, List sourceInfoList) throws Exception {
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        Vector vec = null;
        String bgFormID = null;
        String currencyID = null;
        BgFormInfo bgFormInfo = null;
        CurrencyInfo currencyInfo = null;
        BigDecimal exchangeAux = null;
        Boolean exchangeType = null;
        Book book = null;
        Sheet sheet = null;
        Cell cell = null;
        int maxRow = 0;
        int maxCol = 0;
        int decimal = 8;
        for (int i = 0; i < sourceInfoList.size(); ++i) {
            vec = (Vector)sourceInfoList.get(i);
            bgFormID = vec.get(0).toString();
            currencyID = vec.get(1).toString();
            exchangeAux = (BigDecimal)vec.get(2);
            exchangeType = (Boolean)vec.get(3);
            bgFormInfo = BgFormFactory.getLocalInstance(ctx).getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormID), this.getSelectors());
            currencyInfo = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyID));
            book = bgFormInfo.getBook();
            if (book == null) continue;
            for (int j = 0; j < book.getSheetCount(); ++j) {
                sheet = book.getSheet(j);
                maxRow = sheet.getMaxRowIndex() + 1;
                maxCol = sheet.getMaxColIndex() + 1;
                for (int k = 0; k < maxRow; ++k) {
                    for (int m = 0; m < maxCol; ++m) {
                        String formulaString;
                        String[] params;
                        String currencyNumber;
                        cell = sheet.getCell(k, m, false);
                        if (cell == null || !BgNFSHelper.checkHasFormulaOfCell(cell) || !(currencyNumber = (params = BgNFSHelper.parseFormulaPara(formulaString = BgNFSHelper.getFormulaOfCell(cell)))[4]).equals(currencyInfo.getNumber())) continue;
                        String key = params[0] + "_" + params[1] + "_" + params[2];
                        Variant var = cell.getValue();
                        BigDecimal value = null;
                        if (var == null) continue;
                        value = (BigDecimal)var.getValue();
                        value = exchangeType != false ? value.multiply(exchangeAux) : value.divide(exchangeAux, decimal, 4);
                        if (map.containsKey(key)) {
                            BigDecimal tmpValue = (BigDecimal)map.get(key);
                            value = value.add(tmpValue);
                        }
                        map.put(key, value);
                    }
                }
            }
        }
        return map;
    }

    protected Map loadDiversityInfo(BgFormInfo bgFormInfo) throws Exception {
        HashMap adjustMap = null;
        if (bgFormInfo != null) {
            byte[] data = bgFormInfo.getAdjustMapData();
            if (data == null || data.length == 0) {
                adjustMap = new HashMap();
            } else {
                InputStream is = null;
                ObjectInputStream ois = null;
                try {
                    is = ZipUtil.unpack((byte[])data);
                    ois = new ObjectInputStream(is);
                    adjustMap = (HashMap)ois.readObject();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                    throw ex;
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                    try {
                        if (ois != null) {
                            ois.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex);
                    }
                }
                if (adjustMap == null) {
                    throw new BgFormException(BgFormException.LOADDIVERSITYERROR);
                }
            }
        } else {
            throw new BgFormException(BgFormException.NOBGFORMINFO);
        }
        return adjustMap;
    }

    protected void storeDiversityInfo(BgFormInfo bgFormInfo, Map adjustMap) throws Exception {
        if (bgFormInfo != null && adjustMap != null) {
            ByteArrayOutputStream baos = null;
            ObjectOutputStream oos = null;
            try {
                baos = new ByteArrayOutputStream();
                oos = new ObjectOutputStream(baos);
                oos.writeObject(adjustMap);
                bgFormInfo.setAdjustMapData(ZipUtil.pack((ByteArrayOutputStream)baos));
            }
            catch (Exception ex) {
                logger.error((Object)ex);
                throw ex;
            }
            finally {
                try {
                    baos.close();
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
                try {
                    if (oos != null) {
                        oos.close();
                    }
                }
                catch (Exception ex) {
                    logger.error((Object)ex);
                }
            }
        }
    }

    @Override
    protected List _transCurrencyMulToSingle(Context ctx, List sourceInfoList, List targetInfoList) throws BOSException, EASBizException {
        this.checkParameter(sourceInfoList, targetInfoList, false);
        Object tmpVec = null;
        HashMap keyMap = new HashMap();
        HashMap bgFormMap = new HashMap();
        HashMap formulaMap = new HashMap();
        Object adjustMap = null;
        Object currencyMap = null;
        ArrayList result = new ArrayList();
        ArrayList mutexList = new ArrayList();
        ArrayList succeedList = new ArrayList();
        return result;
    }

    private void checkParameter(List sList, List tList, boolean isSingleToMultiple) throws EASBizException {
        int i;
        if (sList == null || sList.isEmpty() || sList == null || sList.isEmpty()) {
            throw new BgTransException(BgTransException.PARAMETERERROR);
        }
        Vector vec = null;
        int in = sList.size();
        for (i = 0; i < in; ++i) {
            vec = (Vector)sList.get(i);
            if (vec.get(0) == null || StringUtils.isEmpty((String)((String)vec.get(0)))) {
                throw new BgTransException(BgTransException.PARAMETERBGFORMIDERROR);
            }
            if (vec.get(1) == null || StringUtils.isEmpty((String)((String)vec.get(1)))) {
                throw new BgTransException(BgTransException.PARAMETERCURRENCYIDERROR);
            }
            if (isSingleToMultiple || vec.get(2) != null) continue;
            throw new BgTransException(BgTransException.PARAMETERRATEERROR);
        }
        in = tList.size();
        for (i = 0; i < in; ++i) {
            vec = (Vector)tList.get(i);
            if (vec.get(0) == null || StringUtils.isEmpty((String)((String)vec.get(0)))) {
                throw new BgTransException(BgTransException.PARAMETERBGFORMIDERROR);
            }
            if (vec.get(1) == null || StringUtils.isEmpty((String)((String)vec.get(1)))) {
                throw new BgTransException(BgTransException.PARAMETERCURRENCYIDERROR);
            }
            if (!isSingleToMultiple || vec.get(2) != null) continue;
            throw new BgTransException(BgTransException.PARAMETERRATEERROR);
        }
    }

    private void checkParameter(List list, boolean isSingleToMultiple) throws EASBizException {
        if (list == null || list.isEmpty()) {
            throw new BgTransException(BgTransException.PARAMETERERROR);
        }
        Vector vec = null;
        int in = list.size();
        for (int i = 0; i < in; ++i) {
            vec = (Vector)list.get(i);
            if (vec.get(0) == null || StringUtils.isEmpty((String)((String)vec.get(0)))) {
                throw new BgTransException(BgTransException.PARAMETERBGFORMIDERROR);
            }
            if (vec.get(1) == null || StringUtils.isEmpty((String)((String)vec.get(1)))) {
                throw new BgTransException(BgTransException.PARAMETERCURRENCYIDERROR);
            }
            if (isSingleToMultiple || vec.get(2) != null) continue;
            throw new BgTransException(BgTransException.PARAMETERRATEERROR);
        }
    }

    private Map getUseCurrency(Context ctx, Set currencySet) throws BOSException, EASBizException {
        if (currencySet == null || currencySet.isEmpty()) {
            return new HashMap();
        }
        HashMap<String, String> currencyMap = new HashMap<String, String>();
        CurrencyInfo currencyInfo2 = null;
        CurrencyCollection currencyCol = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)currencySet, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("precision"));
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        currencyCol = this.getCurrencyInterface(ctx).getCurrencyCollection(false);
        if (currencyCol != null && !currencyCol.isEmpty()) {
            for (CurrencyInfo currencyInfo2 : currencyCol) {
                currencyMap.put(currencyInfo2.getId().toString(), currencyInfo2.getNumber());
            }
        }
        return currencyMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _transCurrencySingleToMul(Context ctx, List sourceInfoList) throws BOSException, EASBizException {
        this.checkParameter(sourceInfoList, true);
        Vector tmpVec = null;
        HashMap<String, BigDecimal> keyMap = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        BigDecimal value = null;
        String bgFormId = null;
        String currencyId = null;
        String bgItemNumber = null;
        String bgPeriodNumber = null;
        String bgElementNumber = null;
        String key = null;
        ArrayList<String> _tmpList = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fformula, sum(t.FBgValue), i.FKey, p.FNumber, e.FNumber from T_MBg_BgData t left join T_MBg_BgItemCombination i on i.FID = t.FBgItemCombinId left join T_MBg_BgPeriod p on p.FID = t.FBgPeriodId left join T_MBg_BgElement e on e.FID = t.FBgElementId where t.Fid in (Select FBgDataId From T_MBg_BgDataEntry Where FBgFormId IN (");
        int in = sourceInfoList.size();
        for (int i = 0; i < in; ++i) {
            tmpVec = (Vector)sourceInfoList.get(i);
            bgFormId = tmpVec.get(0).toString();
            currencyId = tmpVec.get(1).toString();
            sql.append("?,");
            _tmpList.add(bgFormId);
        }
        sql.delete(sql.length() - 1, sql.length());
        sql.append(")) and FCurrencyId = ? group by t.FFormula, i.FKey, p.FNumber, e.FNumber");
        _tmpList.add(currencyId);
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            MbgSqlHelper.setParams((PreparedStatement)pstmt, _tmpList);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                value = rst.getBigDecimal(2);
                bgItemNumber = rst.getString(3).replaceAll("_", ",");
                bgPeriodNumber = rst.getString(4);
                bgElementNumber = rst.getString(5);
                key = bgItemNumber + "_" + bgPeriodNumber + "_" + bgElementNumber;
                keyMap.put(key, value);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return keyMap;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _transCurrencyMulToSingle(Context ctx, List sourceInfoList) throws BOSException, EASBizException {
        this.checkParameter(sourceInfoList, false);
        Vector tmpVec = null;
        HashMap<String, BigDecimal> keyMap = new HashMap<String, BigDecimal>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        int decimal = 8;
        Boolean exchangeType = null;
        BigDecimal value = null;
        BigDecimal exchangeAux = null;
        BigDecimal tmpValue = null;
        String bgFormId = null;
        String currencyId = null;
        String bgItemNumber = null;
        String bgPeriodNumber = null;
        String bgElementNumber = null;
        String key = null;
        StringBuffer sql = new StringBuffer();
        sql.append("select t.fformula, sum(t.FBgValue), i.FKey, p.FNumber, e.FNumber from T_MBg_BgData t left join T_MBg_BgItemCombination i on i.FID = t.FBgItemCombinId left join T_MBg_BgPeriod p on p.FID = t.FBgPeriodId left join T_MBg_BgElement e on e.FID = t.FBgElementId where t.Fid in (Select FBgDataId From T_MBg_BgDataEntry where FBgFormId = ?) and FCurrencyId = ? group by t.FFormula, i.FKey, p.FNumber, e.FNumber");
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement(sql.toString());
            int in = sourceInfoList.size();
            for (int i = 0; i < in; ++i) {
                tmpVec = (Vector)sourceInfoList.get(i);
                bgFormId = (String)tmpVec.get(0);
                currencyId = (String)tmpVec.get(1);
                exchangeAux = (BigDecimal)tmpVec.get(2);
                exchangeType = (Boolean)tmpVec.get(3);
                pstmt.setString(1, bgFormId);
                pstmt.setString(2, currencyId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    value = rst.getBigDecimal(2);
                    bgItemNumber = rst.getString(3).replaceAll("_", ",");
                    bgPeriodNumber = rst.getString(4);
                    bgElementNumber = rst.getString(5);
                    key = bgItemNumber + "_" + bgPeriodNumber + "_" + bgElementNumber;
                    value = exchangeType != false ? value.multiply(exchangeAux) : value.divide(exchangeAux, decimal, 4);
                    if (keyMap.containsKey(key)) {
                        tmpValue = (BigDecimal)keyMap.get(key);
                        value = value.add(tmpValue);
                    }
                    keyMap.put(key, value);
                }
                SQLUtils.cleanup((ResultSet)rst);
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                catch (BOSException ex2) {
                    throw ex2;
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(rst, (Statement)pstmt, (Connection)conn);
        return keyMap;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("startDate");
        sic.add("endDate");
        sic.add("creator.id");
        sic.add("creator.name");
        sic.add("lastUpdateUser.id");
        sic.add("lastUpdateUser.name");
        sic.add("bgType.id");
        sic.add("bgType.name");
        sic.add("bgType.number");
        sic.add("createTime");
        sic.add("lastUpdateTime");
        sic.add("data");
        sic.add("adjustMapData");
        sic.add("postils.*");
        sic.add("postils.report.id");
        sic.add("postils.sheet.id");
        sic.add("postils.creator.id");
        sic.add("postils.creator.name");
        sic.add("sheetParam.*");
        sic.add("sheetParam.orgRela.id");
        sic.add("sheetParam.orgRela.orgType");
        sic.add("sheetParam.orgRela.orgUnit.id");
        sic.add("sheetParam.orgRela.orgUnit.type");
        sic.add("sheetParam.orgRela.orgUnit.name");
        sic.add("sheetParam.currency.id");
        sic.add("sheetParam.currency.number");
        sic.add("sheetParam.currency.name");
        sic.add("sheetParam.currency.precision");
        sic.add("sheetParam.postils.*");
        sic.add("sheetParam.postils.report.id");
        sic.add("sheetParam.postils.sheet.id");
        sic.add("sheetParam.postils.creator.id");
        sic.add("sheetParam.postils.creator.name");
        sic.add("bgPeriod.id");
        sic.add("bgPeriod.name");
        sic.add("bgPeriod.number");
        sic.add("orgUnit.id");
        sic.add("orgUnit.name");
        sic.add("orgUnit.number");
        sic.add("orgUnit.longnumber");
        sic.add("bgScheme.id");
        sic.add("bgScheme.name");
        sic.add("bgScheme.number");
        sic.add("bgScheme.period");
        sic.add("bgTemplate.id");
        sic.add("bgTemplate.name");
        sic.add("bgTemplate.number");
        sic.add("bgTemplate.formType");
        sic.add("bgTemplate.parent.id");
        sic.add("bgTemplate.root.id");
        sic.add("measureUnit.id");
        sic.add("measureUnit.name");
        sic.add("measureUnit.number");
        sic.add("measureUnit.coefficient");
        sic.add("bgMeasureUnit.*");
        sic.add("bgMeasureUnit.bgElement.id");
        sic.add("bgMeasureUnit.bgElement.name");
        sic.add("bgMeasureUnit.bgElement.number");
        sic.add("bgMeasureUnit.measureUnit.id");
        sic.add("bgMeasureUnit.measureUnit.name");
        sic.add("bgMeasureUnit.measureUnit.number");
        sic.add("bgMeasureUnit.measureUnit.coefficient");
        sic.add("currency.id");
        sic.add("currency.name");
        sic.add("currency.number");
        sic.add("currency.isoCode");
        sic.add("currency.precision");
        sic.add("company.id");
        sic.add("company.name");
        sic.add("company.number");
        sic.add("auditedStatus");
        sic.add("dataSource");
        sic.add("state");
        sic.add("versionNo");
        sic.add("adjust.id");
        sic.add("CU.id");
        sic.add("CU.name");
        return sic;
    }
}

