/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementException;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.mbg.BgTypeFactory;
import com.kingdee.eas.ma.mbg.BgTypeInfo;
import com.kingdee.eas.ma.mbg.IBgType;
import com.kingdee.eas.ma.mbg.app.AbstractBgTypeControllerBean;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class BgTypeControllerBean
extends AbstractBgTypeControllerBean {
    private static final long serialVersionUID = -980908437124124694L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgTypeControllerBean");

    @Override
    protected boolean _checkRefByForm(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgForm where fbgtypeid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return result;
    }

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgTypeInfo info = (BgTypeInfo)model;
        if (StringUtils.isEmpty((String)info.getNumber())) {
            if (info.getCU() == null) {
                info.setCU(ContextUtil.getCurrentCtrlUnit((Context)ctx));
            }
            String companyId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
            BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)info, (String)companyId);
            if (StringUtils.isEmpty((String)info.getNumber())) {
                info.setNumber("BgType-" + System.currentTimeMillis());
            }
        } else {
            this.checkNumber(ctx, info);
        }
        IObjectPK pk = super._addnew(ctx, model);
        if (pk != null && info.getParent() != null && info.getParent().getId() != null) {
            this.updateLeaf(ctx, info.getParent().getId().toString());
        }
        return pk;
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        String oldPid = null;
        String newPid = null;
        BgTypeInfo info = (BgTypeInfo)model;
        oldPid = this.getParentId(info);
        this.checkNumber(ctx, info);
        super._update(ctx, pk, model);
        newPid = this.getParentId(info);
        if (oldPid != null && !oldPid.equals(newPid)) {
            this.updateLeaf(ctx, oldPid);
        }
        if (newPid != null && !newPid.equals(oldPid)) {
            this.updateLeaf(ctx, newPid);
        }
    }

    protected String getParentId(BgTypeInfo info) {
        if (info != null && info.getParent() != null && info.getParent().getId() != null) {
            return info.getParent().getId().toString();
        }
        return null;
    }

    protected void checkNumber(Context ctx, BgTypeInfo info) throws BOSException, EASBizException {
        block6: {
            block5: {
                String number = info.getNumber().trim();
                info.setNumber(number);
                this.checkNumberDup(ctx, info);
                int index = number.lastIndexOf(".");
                if (index <= 0) break block5;
                String pNumber = number.substring(0, index);
                String sql = "select fid,flevel from T_MBg_bgtype where fnumber = ?";
                Connection conn = null;
                PreparedStatement pstmt = null;
                ResultSet res = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, pNumber);
                    res = pstmt.executeQuery();
                    if (!res.next()) {
                        throw new BgElementException(BgElementException.NOPARENTTYPE, new Object[]{pNumber});
                    }
                    BgTypeInfo pInfo = new BgTypeInfo();
                    pInfo.setId(BOSUuid.read((String)res.getString("fid")));
                    info.setParent(pInfo);
                    info.setLevel(res.getInt("flevel") + 1);
                }
                catch (SQLException e) {
                    try {
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(res, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
                break block6;
            }
            info.setParent(null);
        }
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if ("bgMAAAAKIcA7rHKd".equals(pk.toString()) || "GjMAAAAAUgj/bNjg".equals(pk.toString()) || "lVIAAAA0y6A7rHKd".equals(pk.toString())) {
            throw new BgElementException(BgElementException.ISSYSTEMPLETETYPE);
        }
        IBgType ibgType = BgTypeFactory.getLocalInstance(ctx);
        BgTypeInfo info = ibgType.getBgTypeInfo(pk);
        String pId = this.getParentId(info);
        String companyId = ContextUtil.getCurrentCostUnit((Context)ctx).getId().toString();
        BgCodeNumberNHelper.recycleNumber((Context)ctx, (IObjectValue)info, (String)companyId, (String)info.getNumber());
        super._delete(ctx, pk);
        this.updateLeaf(ctx, pId);
    }

    @Override
    protected boolean _checkRefByTemplate(Context ctx, String id) throws BOSException, EASBizException {
        boolean result = false;
        Connection connection = null;
        PreparedStatement sm = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select count(fid) cnt from T_MBg_BgTemplate where fbgtypeid = ? ");
        try {
            connection = this.getConnection(ctx);
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, id);
            rs = sm.executeQuery();
            int cnt = 0;
            if (rs.next() && (cnt = rs.getInt(1)) > 0) {
                result = true;
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return result;
    }

    @Override
    protected int _checkRefAll(Context ctx, String id) throws BOSException, EASBizException {
        ResultSet rs;
        PreparedStatement sm;
        Connection conn;
        block4: {
            int n;
            String sql1 = "select has=case when exists(select fid from T_MBg_BgTemplate where fbgtypeid = ? ) then 2 when exists(select fid from T_MBg_BgType where FParentID= ? ) then 3 else 0 end";
            conn = null;
            sm = null;
            rs = null;
            conn = this.getConnection(ctx);
            try {
                sm = conn.prepareStatement(sql1);
                sm.setString(1, id);
                sm.setString(2, id);
                rs = sm.executeQuery();
                if (!rs.next()) break block4;
                n = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"_checkRefAll", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs, (Statement)sm, (Connection)conn);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)conn);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)conn);
        return 0;
    }

    protected void updateLeaf(Context ctx, String id) throws BOSException, EASBizException {
        if (ctx == null || id == null || id.trim().equals("")) {
            return;
        }
        String sql = "update T_MBg_BgType set FIsLeaf= case when (select count(fid) from T_MBg_BgType where FParentID=?) > 0  then 0 else 1 end where fid=?";
        Connection cn = null;
        PreparedStatement pmt = null;
        try {
            cn = this.getConnection(ctx);
            pmt = cn.prepareStatement(sql);
            pmt.setString(1, id);
            pmt.setString(2, id);
            pmt.executeUpdate();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"updateLeaf", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pmt, (Connection)cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pmt, (Connection)cn);
    }
}

