/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ContextUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.ma.mbg.BgVariateCollection;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.IBgVariate;
import com.kingdee.eas.ma.mbg.app.AbstractBgVariateControllerBean;
import com.kingdee.eas.util.EASCommonResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgVariateControllerBean
extends AbstractBgVariateControllerBean {
    private static final long serialVersionUID = -7959645564467411470L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgVariateControllerBean");
    private final String LOG_ADDNEW = "mbg_bgVariate_addNew";
    private final String LOG_UPDATE = "mbg_bgVariate_update";
    private final String LOG_DELETE = "mbg_bgVariate_delete";

    public IObjectPK[] saveBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.addLogsBeforeSave(ctx, colls);
        return super.saveBatchData(ctx, colls);
    }

    public void deleteBatchData(Context ctx, IObjectPK[] pkArray) throws BOSException, EASBizException {
        this.addLogsBeforeDelete(ctx, pkArray);
        super.deleteBatchData(ctx, pkArray);
    }

    private void addLogsBeforeDelete(Context ctx, IObjectPK[] pkArray) throws BOSException {
        if (pkArray != null && pkArray.length > 0) {
            HashSet<String> idSet = new HashSet<String>();
            int length = pkArray.length;
            for (int i = 0; i < length; ++i) {
                idSet.add(pkArray[i].toString());
            }
            BgVariateCollection colls = this.getCollsByIds(ctx, idSet);
            this.printLog(ctx, (IObjectCollection)colls, "mbg_bgVariate_delete");
        }
    }

    private void addLogsBeforeSave(Context ctx, CoreBaseCollection colls) throws BOSException {
        BgVariateCollection addNewColls = new BgVariateCollection();
        BgVariateCollection updateColls = new BgVariateCollection();
        BgVariateInfo info = null;
        ObjectUuidPK pk = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (BgVariateInfo)colls.get(i);
            pk = new ObjectUuidPK(info.getId());
            if (info.getId() != null && this.innerExists(ctx, (IObjectPK)pk)) {
                updateColls.add(info);
                continue;
            }
            addNewColls.add(info);
        }
        if (!addNewColls.isEmpty()) {
            this.printLog(ctx, (IObjectCollection)addNewColls, "mbg_bgVariate_addNew");
        }
        if (!updateColls.isEmpty()) {
            this.printUpdateLog(ctx, (IObjectCollection)updateColls, "mbg_bgVariate_update");
        }
    }

    private void printLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        BgVariateInfo info = null;
        String logDeatilMsg = null;
        IObjectPK tempPK = null;
        int in = colls.size();
        for (int i = 0; i < in; ++i) {
            info = (BgVariateInfo)colls.getObject(i);
            logDeatilMsg = info.getNumber() + " " + info.getName();
            tempPK = LogUtil.beginLog((Context)ctx, (String)"addNewInfo", (BOSObjectType)this.getBOSType(), null, (String)logDeatilMsg, (String)logItem);
            LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
        }
    }

    private void printUpdateLog(Context ctx, IObjectCollection updateColls, String logItem) throws BOSException {
        if (updateColls == null || updateColls.isEmpty()) {
            return;
        }
        BgVariateInfo bgVariateInfo = null;
        HashSet<String> ids = new HashSet<String>();
        BgVariateCollection newColls = new BgVariateCollection();
        int in = updateColls.size();
        for (int i = 0; i < in; ++i) {
            bgVariateInfo = (BgVariateInfo)updateColls.getObject(i);
            if (bgVariateInfo.getId() == null) continue;
            ids.add(bgVariateInfo.getId().toString());
            newColls.add(bgVariateInfo);
        }
        if (ids.isEmpty()) {
            return;
        }
        BgVariateCollection oldColls = this.getCollsByIds(ctx, ids);
        if (oldColls == null) {
            return;
        }
        HashMap<String, BgVariateInfo> tempMap = new HashMap<String, BgVariateInfo>();
        int in2 = oldColls.size();
        for (int i = 0; i < in2; ++i) {
            bgVariateInfo = oldColls.get(i);
            tempMap.put(bgVariateInfo.getId().toString(), bgVariateInfo);
        }
        StringBuffer logDeatilMsg = null;
        IObjectPK tempPK = null;
        BgVariateInfo newInfo = null;
        BgVariateInfo oldInfo = null;
        String infoID = null;
        Locale locale = ContextUtils.getLocaleFromEnv();
        int in3 = newColls.size();
        for (int i = 0; i < in3; ++i) {
            newInfo = newColls.get(i);
            infoID = newInfo.getId().toString();
            if (!tempMap.containsKey(infoID)) continue;
            oldInfo = (BgVariateInfo)tempMap.get(infoID);
            logDeatilMsg = new StringBuffer();
            logDeatilMsg.append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"edit_before", (Locale)locale)).append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariate_number", (Locale)locale) + "[" + oldInfo.getNumber() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariate_name", (Locale)locale) + "[" + oldInfo.getName() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"dim_name", (Locale)locale) + "[" + oldInfo.getDimName() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"member_number", (Locale)locale) + "[" + oldInfo.getMemberNumber() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"member_name", (Locale)locale) + "[" + oldInfo.getMemberName() + "];");
            logDeatilMsg.append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"edit_after", (Locale)locale)).append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariate_number", (Locale)locale) + "[" + newInfo.getNumber() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"bgVariate_name", (Locale)locale) + "[" + newInfo.getName() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"dim_name", (Locale)locale) + "[" + newInfo.getDimName() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"member_number", (Locale)locale) + "[" + newInfo.getMemberNumber() + "]").append(EASCommonResource.getString((String)"com.kingdee.eas.ma.base.BgAccountResource", (String)"member_name", (Locale)locale) + "[" + newInfo.getMemberName() + "];");
            tempPK = LogUtil.beginLog((Context)ctx, (String)"updateInfo", (BOSObjectType)this.getBOSType(), null, (String)logDeatilMsg.toString(), (String)logItem);
            LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
        }
    }

    private BgVariateCollection getCollsByIds(Context ctx, Set<String> idSet) throws BOSException {
        if (idSet == null || idSet.isEmpty()) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        sic.add("dimName");
        sic.add("dimNumber");
        sic.add("memberNumber");
        sic.add("memberName");
        view.getSelector().addObjectCollection((IObjectCollection)sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        IBgVariate iBgVariate = BgVariateFactory.getLocalInstance(ctx);
        return iBgVariate.getBgVariateCollection(view);
    }
}

