/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionCollection;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.IBgTemplate;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.ViewListFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgViewDimensionControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgFacadeHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgRelationMap;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgViewDimensionControllerBean
extends AbstractBgViewDimensionControllerBean {
    private static final long serialVersionUID = 3186067765724496734L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgViewDimensionControllerBean");

    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return super._addnew(ctx, model);
    }

    @Override
    protected IObjectPK _addNewView(Context ctx, IObjectValue bgDimensionInfo, IObjectValue bgTemplate) throws BOSException, EASBizException {
        IBgTemplate itemplate = BgTemplateFactory.getLocalInstance(ctx);
        BgTemplateInfo templateInfo = (BgTemplateInfo)bgTemplate;
        IObjectPK templateid = itemplate.save((CoreBaseInfo)templateInfo);
        templateInfo.setId(BOSUuid.read((String)templateid.toString()));
        BgViewDimensionInfo info = (BgViewDimensionInfo)bgDimensionInfo;
        BgViewDimensionCollection old = this.getBgViewDimensionCollection(ctx, "select id, template where template.id = '" + templateid + "'");
        if (old == null || old.isEmpty()) {
            info.setTemplate(templateInfo);
            info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
            this._addnew(ctx, (IObjectValue)info);
        } else {
            old.get(0).setData(info.getData());
            this._update(ctx, (IObjectPK)new ObjectUuidPK(old.get(0).getId()), (IObjectValue)old.get(0));
        }
        try {
            IMbgViewManager viewManager = new MbgXMLParser(ctx).parse(info.getData());
            if (viewManager != null) {
                ArrayList<String> ids = new ArrayList<String>();
                ArrayList<String> name = new ArrayList<String>();
                for (int i = 0; i < viewManager.getSheetManagers().size(); ++i) {
                    IMbgSheetManager manager = viewManager.getSheetManagers().get(i);
                    ids.add(manager.getSheetID());
                    name.add(manager.getSheetName());
                }
                if (!ids.isEmpty()) {
                    MbgPermissionFactory.getLocalInstance(ctx).updateSheetName(ids, name);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        try {
            IMbgViewBase view = null;
            if (BgTemFormTypeEnum.VIEWFORM.equals((Object)templateInfo.getFormType())) {
                view = new MbgXMLParser(ctx).parse(info.getData());
            } else if (BgTemFormTypeEnum.VIEWLIST.equals((Object)templateInfo.getFormType())) {
                view = new MbgViewListXMLParser(ctx).parse(info.getData());
            }
            if (view != null) {
                Map resultMap;
                if (BgTemFormTypeEnum.VIEWLIST.equals((Object)templateInfo.getFormType()) && (resultMap = ViewListFacadeFactory.getLocalInstance(ctx).initTemplateData(templateInfo, null, templateInfo.getOrgUnit().getId().toString(), false)) != null && resultMap.get("dimensino.member") instanceof IMbgViewBase) {
                    view = (IMbgViewBase)resultMap.get("dimensino.member");
                }
                BgFacadeHelper.saveBgTemplateRef(ctx, templateid.toString(), view);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return templateid;
    }

    @Override
    protected IObjectValue _getDimensionByTemplate(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        BgViewDimensionInfo bgViewDimensionInfo;
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return null;
        }
        ResultSet rs = null;
        Connection connection = null;
        PreparedStatement sm = null;
        StringBuffer sql = new StringBuffer(60);
        sql.append(" select dimen.fid, dimen.FData from T_MBg_BgViewDimension dimen  where dimen.FTemplateID =? ;");
        connection = this.getConnection(ctx);
        try {
            sm = connection.prepareStatement(sql.toString());
            sm.setString(1, bgTemplateId);
            rs = sm.executeQuery();
            BgViewDimensionInfo info = null;
            while (rs.next()) {
                if (info != null) continue;
                info = new BgViewDimensionInfo();
                info.setId(BOSUuid.read((String)rs.getString("fid")));
                info.setData(rs.getBytes("FData"));
            }
            bgViewDimensionInfo = info;
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)sm, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)sm, (Connection)connection);
        return bgViewDimensionInfo;
    }

    @Override
    protected void _deleteDimension(Context ctx, String id) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        Connection conn = this.getConnection(ctx);
        PreparedStatement ps = null;
        String sql = "delete from T_MBg_BgViewDimension  where FTemplateID = ? ;";
        try {
            ps = conn.prepareStatement(sql);
            ps.setString(1, id);
            ps.execute();
            BgFacadeHelper.deleteRef(ctx, id);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(null, (Statement)ps, (Connection)conn);
        }
    }

    @Override
    protected void _saveFixedTemplateDimension(Context ctx, String bgTemplateId, Collection formulas) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgTemplateId)) {
            return;
        }
        MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager(ctx, formulas, null);
        List list = view.getSheetManagers();
        for (IMbgSheetManager iMbgSheetManager : list) {
            IBgDimensionManager manager = iMbgSheetManager.getDimensionManager();
            if (this.checkDimensionManager(manager)) continue;
            throw new BgNFormException(BgNFormException.CHECKDIMENSIONMEMBER);
        }
        new MbgXMLParser(ctx);
        byte[] datas = MbgXMLParser.unParse(view);
        if (this._exists(ctx, "select id where template.id = '" + bgTemplateId + "'")) {
            DbUtil.execute((Context)ctx, (String)"update T_MBg_BgViewDimension Set FData = ? Where FTemplateID = ?", (Object[])new Object[]{datas, bgTemplateId});
        } else {
            String id = BOSUuid.create((BOSObjectType)new BgViewDimensionInfo().getBOSType()).toString();
            DbUtil.execute((Context)ctx, (String)"Insert into T_MBg_BgViewDimension(FID, FTemplateID, FData) Values(?, ?, ?)", (Object[])new Object[]{id, bgTemplateId, datas});
        }
        BgFacadeHelper.saveBgTemplateRef(ctx, bgTemplateId, view);
    }

    private boolean checkDimensionManager(IBgDimensionManager manager) {
        List entries = manager.getDimension();
        for (BgDimensionInfo entry : entries) {
            if (!DimensionConstants.DEF_INDEX_NUMBER.equals(entry.getType()) && !DimensionConstants.DEF_ACCOUNT_NUMBER.equals(entry.getType())) continue;
            return true;
        }
        return false;
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        BgViewDimensionInfo viewDim = (BgViewDimensionInfo)model;
        if (viewDim.getTemplate().getFormType().equals((Object)BgTemFormTypeEnum.VIEWFORM)) {
            try {
                IMbgViewManager view = new MbgXMLParser(ctx).parse(viewDim.getData());
                HashMap<String, List<MbgRelationMap>> relationMaps = new HashMap<String, List<MbgRelationMap>>();
                view.getRelationMaps();
                relationMaps.put(viewDim.getTemplate().getId().toString(), view.getRelationMaps());
                BgViewServerHelper.saveRelationByInfo(ctx, relationMaps);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return super._save(ctx, model);
    }
}

