/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgBaseConstants;
import com.kingdee.eas.ma.base.utils.BgCodeNumberHelper;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgActualRecordException;
import com.kingdee.eas.ma.mbg.BgActualRecordFactory;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgActualRecordStateEnum;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgNFormException;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.IBgActualRecord;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBgViewFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgAdjustHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBGLayoutConstants;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.MBgCheckHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgViewFacadeControllerBean
extends AbstractBgViewFacadeControllerBean {
    private static final long serialVersionUID = 6494815585958862499L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgViewFacadeControllerBean");

    @Override
    protected Map _addNewViewInfo(Context ctx, BgFormInfo bgForm, String bgOrgViewId, boolean isBatch, String addNewPermissionNumber) throws BOSException, EASBizException {
        if (bgForm == null || bgForm.getBgTemplate() == null || bgForm.getBgScheme() == null) {
            return null;
        }
        if (!BgTemFormTypeEnum.VIEWFORM.equals((Object)bgForm.getBgTemplate().getFormType())) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("result", "addViewOrgSucess");
        String currBgFormId = null;
        String bgTemplateId = bgForm.getBgTemplate().getId().toString();
        String bgSchemeId = bgForm.getBgScheme().getId().toString();
        String currencyId = bgForm.getCurrency().getId().toString();
        String bgPeriodId = bgForm.getBgPeriod().getId().toString();
        String bgVersionId = bgForm.getBgVersion().getId().toString();
        String orgUnitId = bgForm.getOrgUnit().getId().toString();
        TemplateFacadeFactory.getLocalInstance(ctx).verifyPeriodVariableForAddNewForm(bgTemplateId, bgForm);
        TemplateFacadeFactory.getLocalInstance(ctx).verifyMbgViewManagerForAddNewForm(bgTemplateId);
        Map<String, BgFormInfo> bgForms = new HashMap();
        HashSet<String> bgOrgIds = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            BgFormInfo b;
            conn = this.getConnection(ctx);
            bgForms = this.getBgFormMap(ctx, conn, bgForm, true);
            if (isBatch) {
                bgOrgIds = new HashSet<String>();
                pstmt = conn.prepareStatement("Select FOrgUnitID FROM T_MBg_BgOrgUnit Where FViewId = ? AND FIsOUSealUp = 0");
                pstmt.setString(1, bgOrgViewId);
                res = pstmt.executeQuery();
                while (res.next()) {
                    bgOrgIds.add(res.getString("FOrgUnitID"));
                }
            }
            ArrayList<BgFormInfo> newForms = new ArrayList<BgFormInfo>();
            if (isBatch) {
                TemplateFacadeFactory.getLocalInstance(ctx).checkParentBgFormState(result, bgForms, bgForm, null);
                HashMap<String, FullOrgUnitInfo> existsMap = new HashMap<String, FullOrgUnitInfo>();
                int totalCount = bgForms.size();
                Iterator it = bgForms.values().iterator();
                while (it.hasNext()) {
                    b = (BgFormInfo)it.next();
                    if (bgOrgIds != null && !bgOrgIds.contains(b.getOrgUnit().getId().toString())) {
                        it.remove();
                        --totalCount;
                        continue;
                    }
                    this.setBgFormInfo(bgForm, currencyId, bgPeriodId, bgVersionId, null, null, b);
                    if (b.getId() == null) {
                        newForms.add(b);
                        b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                    } else {
                        existsMap.put(b.getOrgUnit().getNumber(), b.getOrgUnit());
                        it.remove();
                    }
                    if (!orgUnitId.equals(b.getOrgUnit().getId().toString())) continue;
                    currBgFormId = String.valueOf(b.getId());
                }
                result.put("totalCount", totalCount);
                if (!existsMap.isEmpty()) {
                    result.put("addViewOrgExistsForm", existsMap);
                }
                this.checkAddNewPermission(ctx, addNewPermissionNumber, result, bgForms, "batchAddViewOrgNoPermission");
            } else {
                b = (BgFormInfo)bgForms.get(orgUnitId);
                this.setBgFormInfo(bgForm, currencyId, bgPeriodId, bgVersionId, null, null, b);
                if (b.getId() == null) {
                    newForms.add(b);
                    b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                }
                currBgFormId = String.valueOf(b.getId());
            }
            Iterator it = newForms.iterator();
            while (it.hasNext()) {
                b = (BgFormInfo)it.next();
                if (isBatch && !bgForms.containsValue(b)) {
                    it.remove();
                    continue;
                }
                b.setBgPeriod(bgForm.getBgPeriod());
                b.setBgTemplate(bgForm.getBgTemplate());
                b.setCurrency(bgForm.getCurrency());
                b.setBgVersion(bgForm.getBgVersion());
                if (StringUtils.isEmpty((String)bgForm.getNumber())) {
                    BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)b, (String)b.getOrgUnit().getId().toString(), (String)"sourceType", (String)"number", (boolean)false);
                } else {
                    b.setNumber(bgForm.getNumber());
                }
                if (isBatch) {
                    b.setName(null);
                }
                if (StringUtils.isEmpty((String)bgForm.getName())) {
                    BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)b, (String)b.getOrgUnit().getId().toString(), (String)"sourceType", (String)"name");
                } else {
                    b.setName(bgForm.getName());
                }
                if (StringUtils.isEmpty((String)b.getNumber())) {
                    throw new BgNFormException(BgNFormException.NUMBERNULL);
                }
                if (b.getNumber().indexOf("(") >= 0 || b.getNumber().indexOf(")") >= 0) {
                    throw new BgNFormException(BgNFormException.NUMBERERROR);
                }
                if (StringUtils.isEmpty((String)b.getName())) {
                    b.setName(BgViewHelper.getBgFormName(b.getCU(), b.getOrgUnit(), b.getBgTemplate(), b.getBgPeriod(), b.getBgVersion(), 80));
                }
                if (b.getNumber().length() > 80) {
                    b.setNumber(b.getNumber().substring(0, 80));
                }
                if (b.getName().length() <= 80) continue;
                b.setName(b.getName().substring(0, 80));
            }
            String logName = bgForm.getNumber() + " " + bgForm.getName();
            IObjectPK logPK = LogUtil.beginLog((Context)ctx, (String)"_addnew", (BOSObjectType)this.getBOSType(), null, (String)logName, (String)"bgForm_addNew");
            BgViewServerHelper.batchAddNewView(ctx, conn, newForms, true, bgSchemeId);
            LogUtil.afterLog((Context)ctx, (IObjectPK)logPK);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt, (Connection)conn);
        result.put(BgBaseConstants.ID, currBgFormId);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _addNewViewInfo(Context ctx, String bgFormId, Set orgUnitNumbers, String addNewPermissionNumber) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgFormId) || orgUnitNumbers == null || orgUnitNumbers.isEmpty()) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("result", "addViewOrgSucess");
        BgFormInfo bgForm = BgViewServerHelper.getBgFormInfo(ctx, BOSUuid.read((String)bgFormId), false);
        String bgTemplateId = bgForm.getBgTemplate().getId().toString();
        String bgSchemeId = bgForm.getBgScheme().getId().toString();
        String currencyId = bgForm.getCurrency().getId().toString();
        String bgPeriodId = bgForm.getBgPeriod().getId().toString();
        String bgVersionId = bgForm.getBgVersion().getId().toString();
        HashSet<String> oldOrgNumbers = orgUnitNumbers;
        Object var14_13 = null;
        BgDimensionMember memberInfo = null;
        orgUnitNumbers = new HashSet();
        HashSet<String> bgOrgLongNums = new HashSet<String>();
        for (Object e : oldOrgNumbers) {
            if (e instanceof String) {
                orgUnitNumbers.add((String)e);
                continue;
            }
            memberInfo = (BgDimensionMember)e;
            orgUnitNumbers.add(memberInfo.getNumber());
            bgOrgLongNums.add(memberInfo.getSortValue().toString());
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("name"));
        view.getSelector().add(new SelectorItemInfo("number"));
        view.getSelector().add(new SelectorItemInfo("longNumber"));
        view.getSelector().add(new SelectorItemInfo("orgUnitID"));
        view.getSelector().add(new SelectorItemInfo("viewID"));
        view.getSelector().add(new SelectorItemInfo("isVirtual"));
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgOrgViewId, CompareType.EQUALS));
        view.getFilter().getFilterItems().add(new FilterItemInfo("longNumber", bgOrgLongNums, CompareType.INCLUDE));
        BgOrgUnitCollection bgOrgUnitColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        HashMap<String, BgOrgUnitInfo> virtualMap = new HashMap<String, BgOrgUnitInfo>();
        if (bgOrgUnitColls != null && !bgOrgUnitColls.isEmpty()) {
            for (int index = 0; index < bgOrgUnitColls.size(); ++index) {
                virtualMap.put(bgOrgUnitColls.get(index).getOrgUnitID(), bgOrgUnitColls.get(index));
            }
        }
        Map<String, OrgUnitInfo> orgMap = BgAdjustHelper.getOrgMap(ctx, orgUnitNumbers);
        Map bgForms = new HashMap();
        HashMap<String, BgFormInfo> newFormMap = new HashMap<String, BgFormInfo>();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet res = null;
        try {
            conn = this.getConnection(ctx);
            bgForms = this.getBgFormMap(ctx, conn, bgForm, true);
            String orgUnitId = null;
            HashMap<String, BgOrgUnitInfo> virtualOrgs = new HashMap<String, BgOrgUnitInfo>();
            for (BgFormInfo b : bgForms.values()) {
                orgUnitId = b.getOrgUnit().getId().toString();
                if (b.getId() != null && orgUnitNumbers.contains(b.getOrgUnit().getNumber())) {
                    orgMap.remove(orgUnitId);
                    continue;
                }
                if (!orgMap.containsKey(orgUnitId) || BgFormStateEnum.History.equals((Object)b.getState())) continue;
                if (!virtualMap.isEmpty() && virtualMap.containsKey(orgUnitId) && Boolean.TRUE.booleanValue() == ((BgOrgUnitInfo)virtualMap.get(orgUnitId)).isIsVirtual()) {
                    virtualOrgs.put(((BgOrgUnitInfo)virtualMap.get(orgUnitId)).getNumber(), (BgOrgUnitInfo)virtualMap.get(orgUnitId));
                    orgMap.remove(orgUnitId);
                    continue;
                }
                this.setBgFormInfo(bgForm, currencyId, bgPeriodId, bgVersionId, null, null, b);
                b.setOrgUnit(orgMap.get(orgUnitId).castToFullOrgUnitInfo());
                if (b.getId() == null) {
                    newFormMap.put(orgUnitId, b);
                    b.setId(BOSUuid.create((BOSObjectType)b.getBOSType()));
                }
                orgMap.remove(orgUnitId);
            }
            if (!orgMap.isEmpty()) {
                HashMap<String, OrgUnitInfo> noTemplate = new HashMap<String, OrgUnitInfo>();
                for (OrgUnitInfo org : orgMap.values()) {
                    noTemplate.put(org.getNumber(), org);
                }
                result.put("addViewOrgNoTemplate", noTemplate);
            }
            this.checkAddNewPermission(ctx, addNewPermissionNumber, result, newFormMap, "addViewOrgNoPermission");
            ArrayList<BgFormInfo> newList = new ArrayList<BgFormInfo>();
            for (BgFormInfo b : newFormMap.values()) {
                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)b, (String)b.getOrgUnit().getId().toString(), (String)"sourceType", (String)"number", (boolean)false);
                if (b.getNumber() == null) {
                    b.setNumber(bgForm.getNumber());
                }
                if (b.getName() == null) {
                    b.setName(bgForm.getName());
                }
                newList.add(b);
            }
            BgViewServerHelper.batchAddNewView(ctx, conn, newList, true, bgSchemeId);
            if (newFormMap.size() != newList.size()) {
                HashMap<String, FullOrgUnitInfo> numberDep = new HashMap<String, FullOrgUnitInfo>();
                for (int i = 0; i < newList.size(); ++i) {
                    newFormMap.remove(((BgFormInfo)newList.get(i)).getOrgUnit().getId().toString());
                }
                for (BgFormInfo b : newFormMap.values()) {
                    numberDep.put(b.getOrgUnit().getNumber(), b.getOrgUnit());
                }
                result.put("addViewOrgNumberDep", numberDep);
            }
            if (!virtualOrgs.isEmpty()) {
                result.put("addViewOrgIsVirtual", virtualOrgs);
            }
        }
        finally {
            SQLUtils.cleanup(res, pstmt, (Connection)conn);
        }
        return result;
    }

    protected void checkAddNewPermission(Context ctx, String addNewPermissionNumber, Map result, Map<String, BgFormInfo> newFormMap, String permMsgKey) throws BOSException, EASBizException {
        if (newFormMap.isEmpty()) {
            return;
        }
        ArrayList<ObjectUuidPK> orgPks = new ArrayList<ObjectUuidPK>();
        for (BgFormInfo b : newFormMap.values()) {
            orgPks.add(new ObjectUuidPK(b.getOrgUnit().getId()));
        }
        Set hasPermOrgIds = null;
        if (!orgPks.isEmpty()) {
            hasPermOrgIds = PermissionFactory.getLocalInstance((Context)ctx).checkBatchPermission((IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId()), orgPks.toArray(new IObjectPK[1]), addNewPermissionNumber);
        }
        if (!(newFormMap.isEmpty() || hasPermOrgIds != null && hasPermOrgIds.size() == newFormMap.size())) {
            Object[] keys;
            HashMap<String, FullOrgUnitInfo> noPermission = new HashMap<String, FullOrgUnitInfo>();
            for (Object key : keys = newFormMap.keySet().toArray()) {
                BgFormInfo b;
                b = newFormMap.get(key);
                if (hasPermOrgIds != null && hasPermOrgIds.contains(b.getOrgUnit().getId().toString())) continue;
                newFormMap.remove(key);
                noPermission.put(b.getOrgUnit().getNumber(), b.getOrgUnit());
            }
            if (!noPermission.isEmpty()) {
                result.put(permMsgKey, noPermission);
            }
        }
    }

    private Map<String, OrgUnitInfo> getOrgMap(Context ctx, Set orgUnitNumbers) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("number", (Object)orgUnitNumbers, CompareType.INCLUDE));
        CostCenterOrgUnitCollection col = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(evi);
        HashMap<String, OrgUnitInfo> orgMap = new HashMap<String, OrgUnitInfo>();
        for (int i = 0; i < col.size(); ++i) {
            orgMap.put(col.get(i).getId().toString(), (OrgUnitInfo)col.get(i));
        }
        return orgMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _addNewViewInfo(Context ctx, BgActualRecordInfo actualRecordInfo, String permissionNumber) throws BOSException, EASBizException {
        if (ctx == null) return false;
        if (actualRecordInfo == null) {
            return false;
        }
        HashMap<String, BgCodeNumberHelper> codeHelpers = new HashMap<String, BgCodeNumberHelper>();
        if (actualRecordInfo.getBgForm().getBgTemplate().getFormType().getValue() != 4 && actualRecordInfo.getBgForm().getBgTemplate().getFormType().getValue() != 2) {
            return false;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = actualRecordInfo.getBgForm();
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId()), BgNFSHelper.getFormBaseSelectors(false));
        BgSchemeInfo schemeInfo = bgFormInfo.getBgScheme();
        BgTemplateInfo templateInfo = bgFormInfo.getBgTemplate();
        BgPeriodInfo bgPeriodInfo = bgFormInfo.getBgPeriod();
        CurrencyInfo currencyInfo = bgFormInfo.getCurrency();
        BgVersionInfo bgVersion = bgFormInfo.getBgVersion();
        BgPeriodInfo actualPeriod = actualRecordInfo.getBgPeriod();
        int processType = bgFormInfo.getProcessType().getValue();
        BgFormStateEnum state = bgFormInfo.getState();
        String bgSchemeId = schemeInfo.getId().toString();
        String rootTemplateId = templateInfo.getRootId().toString();
        String currencyId = currencyInfo.getId().toString();
        String bgPeriodId = bgPeriodInfo.getId().toString();
        String bgVersionId = bgVersion.getId().toString();
        String acPeriodId = actualPeriod.getId().toString();
        StringBuffer query = new StringBuffer();
        query.append("select f.FID, f.FOrgUnitId from T_MBG_BgForm f join T_MBG_BgTemplate t on f.FBgTemplateID = t.FID where f.FBgSchemeId = ? and t.FRootId = ? and f.FBgPeriodID = ? and f.FCurrencyID = ? and f.FBgVersionId = ? and f.FProcessType = ? ");
        if (this.getDefaultStates().contains(state.getValue())) {
            query.append(" and f.FState IN (2,50,51,6,12)");
        }
        StringBuffer check = new StringBuffer();
        check.append("select t.FID from T_MBG_BgActualRecord t join T_MBG_BgForm f on t.FBgFormID = f.FID join T_MBG_BgTemplate te on f.FBgTemplateID = te.FID where f.FOrgUnitID = ? and f.FBgSchemeId = ? and te.FRootID = ? and f.FCurrencyID = ? and f.FBgPeriodID = ? and t.FBgPeriodID = ? and f.FBgVersionId = ?");
        Connection conn = null;
        IRowSet rst = null;
        IRowSet qrst = null;
        String bgFormId = null;
        String orgUnitId = null;
        BgFormInfo tmpFormInfo = null;
        BgActualRecordInfo tmpRecordInfo = null;
        IBgActualRecord iBgActualRecord = null;
        IMutexServiceControl imc = null;
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        try {
            conn = this.getConnection(ctx);
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iBgActualRecord = BgActualRecordFactory.getLocalInstance(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString(), (Object[])new Object[]{bgSchemeId, rootTemplateId, bgPeriodId, currencyId, bgVersionId, processType});
            while (rst.next()) {
                bgFormId = rst.getString("FID");
                orgUnitId = rst.getString("FOrgUnitId");
                if (permissionNumber != null && !PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectStringPK(orgUnitId), permissionNumber) || !imc.requestObjIDForUpdate(bgFormId)) continue;
                tmpFormInfo = new BgFormInfo();
                tmpFormInfo.setId(BOSUuid.read((String)bgFormId));
                try {
                    qrst = BgDBUtils.executeQuery((Connection)conn, (String)check.toString(), (Object[])new Object[]{orgUnitId, bgSchemeId, rootTemplateId, currencyId, bgPeriodId, acPeriodId, bgVersionId});
                    if (qrst.next()) throw new BgActualRecordException(BgActualRecordException.EXISTACROSSBGPERIOD);
                    tmpRecordInfo = this.createNewRecordInfo(ctx, tmpFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(tmpFormInfo.getId()), BgNFSHelper.getViewBaseSelectors()), actualRecordInfo, codeHelpers);
                    if (tmpRecordInfo != null) {
                        iBgActualRecord.addNewInNewTx(tmpRecordInfo);
                    }
                }
                catch (Exception ex) {
                    try {
                        logger.error((Object)"batchAddnew ActualRecord Sql Error:", (Throwable)ex);
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(qrst);
                        MBgCheckHelper.releaseMutex(ctx, bgFormId);
                        throw throwable;
                    }
                }
                SQLUtils.cleanup((ResultSet)qrst);
                MBgCheckHelper.releaseMutex(ctx, bgFormId);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"batchAddnew ActualRecord Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return true;
    }

    private Set<Integer> getDefaultStates() {
        HashSet<Integer> states = new HashSet<Integer>();
        states.add(new Integer(2));
        states.add(new Integer(51));
        states.add(new Integer(50));
        states.add(new Integer(6));
        states.add(new Integer(12));
        return states;
    }

    private BgActualRecordInfo createNewRecordInfo(Context ctx, BgFormInfo bgFormInfo, BgActualRecordInfo model, Map<String, BgCodeNumberHelper> codeHelpers) throws BOSException, EASBizException {
        BgCodeNumberHelper codeHelper;
        if (ctx == null || bgFormInfo == null || model == null) {
            return null;
        }
        BgActualRecordInfo actualRecord = new BgActualRecordInfo();
        actualRecord.setId(BOSUuid.create((BOSObjectType)actualRecord.getBOSType()));
        actualRecord.setCreateTime(new Timestamp(System.currentTimeMillis()));
        actualRecord.setCreator(model.getCreator());
        actualRecord.setLastUpdateTime(actualRecord.getCreateTime());
        actualRecord.setLastUpdateUser(model.getCreator());
        actualRecord.setBgForm(bgFormInfo);
        actualRecord.setName(model.getName());
        actualRecord.setBgPeriod(model.getBgPeriod());
        actualRecord.setMeasureUnit(model.getMeasureUnit());
        actualRecord.setDescription(model.getDescription());
        actualRecord.setCompany(bgFormInfo.getCompany());
        actualRecord.setCU(model.getCU());
        actualRecord.setSourceType(model.getSourceType());
        actualRecord.setState(BgActualRecordStateEnum.Edited);
        actualRecord.setIsEditByPeriod(model.isIsEditByPeriod());
        actualRecord.setIsFormulaFromTem(model.isIsFormulaFromTem());
        if (!bgFormInfo.getEntries().isEmpty()) {
            actualRecord.setDimensionData(bgFormInfo.getEntries().get(0).getDimensionData());
            actualRecord.setDimensionStyle(bgFormInfo.getEntries().get(0).getDimensionStyle());
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                MbgViewListXMLParser parser2 = new MbgViewListXMLParser(ctx);
                MbgViewListManager view = null;
                try {
                    view = parser2.parse(bgFormInfo.getEntries().get(0).getDimensionData());
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
                view.setOrgAddType(0);
                actualRecord.setDimensionData(parser2.unParse(view));
            }
        }
        String orgId = bgFormInfo.getOrgUnit().getId().toString();
        if (codeHelpers == null) {
            codeHelpers = new HashMap<String, BgCodeNumberHelper>();
        }
        if ((codeHelper = codeHelpers.get(orgId)) == null) {
            codeHelper = new BgCodeNumberHelper(ctx, null, "sourceType");
            codeHelper.init((IObjectValue)actualRecord, orgId);
            codeHelpers.put(orgId, codeHelper);
        }
        codeHelper.applyNumber((IObjectValue)actualRecord, bgFormInfo.getOrgUnit().getId().toString(), null);
        if (StringUtils.isEmpty((String)actualRecord.getNumber()) && !StringUtils.isEmpty((String)model.getNumber())) {
            actualRecord.setNumber(model.getNumber());
        }
        return actualRecord;
    }

    private void setBgFormInfo(BgFormInfo bgForm, String currencyId, String bgPeriodId, String bgVersionId, String bgFormNumber, String bgFormName, BgFormInfo b) {
        b.setNumber(bgFormNumber);
        b.setName(bgFormName);
        b.setDescription(bgForm.getDescription());
        b.setSourceType(bgForm.getSourceType());
        b.setProcessType(bgForm.getProcessType());
        if (b.getId() == null) {
            b.setBgPeriod(new BgPeriodInfo());
            b.getBgPeriod().setId(BOSUuid.read((String)bgPeriodId));
            b.setCurrency(new CurrencyInfo());
            b.getCurrency().setId(BOSUuid.read((String)currencyId));
            b.setBgVersion(new BgVersionInfo());
            b.getBgVersion().setId(BOSUuid.read((String)bgVersionId));
        }
    }

    @Override
    protected List _checkNumber(Context ctx, BgFormInfo bgFormInfo, boolean isBatch) throws BOSException, EASBizException {
        if (bgFormInfo == null) {
            return null;
        }
        ArrayList<Boolean> orgs = new ArrayList<Boolean>();
        HashMap<String, FullOrgUnitInfo> orgMap = new HashMap<String, FullOrgUnitInfo>();
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            int i;
            conn = this.getConnection(ctx);
            HashSet<String> orgIds = new HashSet<String>();
            if (!isBatch) {
                orgIds.add(bgFormInfo.getOrgUnit().getId().toString());
            } else {
                Map bgForms = this.getBgFormMap(ctx, conn, bgFormInfo, true);
                if (bgForms != null) {
                    for (BgFormInfo b : bgForms.values()) {
                        if (b.getId() != null) continue;
                        orgIds.add(b.getOrgUnit().getId().toString());
                    }
                }
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select org.fid, org.fnumber, org.fname_").append(ctx.getLocale()).append(" fname from T_MBg_bgform bgForm, t_org_costcenter org ");
            sql.append(" where org.fid = bgForm.forgunitid and bgForm.fnumber = ? and bgForm.FBgSchemeId = ? and bgForm.forgunitid in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)50).append(")");
            pstmt = conn.prepareStatement(sql.toString());
            Object[] params = orgIds.toArray();
            int batchCount = (params.length - 1) / 50 + 1;
            for (i = 0; i < batchCount; ++i) {
                pstmt.setString(1, bgFormInfo.getNumber());
                pstmt.setString(2, bgFormInfo.getBgScheme().getId().toString());
                MbgSqlHelper.setParam4Batch((PreparedStatement)pstmt, (int)3, (int)i, (int)50, (Object[])params);
                res = pstmt.executeQuery();
                while (res.next()) {
                    FullOrgUnitInfo org = new FullOrgUnitInfo();
                    org.setId(BOSUuid.read((String)res.getString("fid")));
                    org.setNumber(res.getString("fnumber"));
                    org.setName(res.getString("fname"));
                    orgMap.put(org.getNumber(), org);
                }
                SQLUtils.cleanup((ResultSet)res);
            }
            if (!orgMap.isEmpty()) {
                orgs.add(orgMap.size() == orgIds.size());
                params = orgMap.keySet().toArray();
                Arrays.sort(params);
                for (i = 0; i < params.length; ++i) {
                    orgs.add((Boolean)orgMap.get(params[i]));
                }
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup(res, (Statement)pstmt, (Connection)conn);
        return orgs;
    }

    private Map getBgFormMap(Context ctx, Connection conn, BgFormInfo bgForm, boolean isContainNoForm) throws BOSException, EASBizException {
        if (bgForm == null) {
            return null;
        }
        HashMap<String, BgFormInfo> bgForms = new HashMap<String, BgFormInfo>();
        PreparedStatement pstmt = null;
        ResultSet res = null;
        try {
            String orgViewId = BgSchemeFactory.getLocalInstance(ctx).getOrgViewId(bgForm.getBgScheme().getId().toString());
            StringBuffer sql = BgViewServerHelper.getQuerySQL(ctx);
            sql.append(" and bgForm.FBgTemplateId = bgTemplate.FID and bgForm.FBgPeriodId = ? and bgForm.FCurrencyId =? and bgForm.FBgVersionId = ? and bgForm.FProcessType = ?");
            sql.append(" where bgScheme.FId = ? ");
            sql.append(" and bgTemplate.FID = ? ");
            sql.append(" and bgOrgUnit.FViewId = ? ");
            if (!isContainNoForm) {
                sql.append(" and bgForm.FID is not null ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, bgForm.getBgPeriod().getId().toString());
            pstmt.setString(2, bgForm.getCurrency().getId().toString());
            pstmt.setString(3, bgForm.getBgVersion().getId().toString());
            pstmt.setInt(4, bgForm.getProcessType().getValue());
            pstmt.setString(5, bgForm.getBgScheme().getId().toString());
            pstmt.setString(6, bgForm.getBgTemplate().getId().toString());
            pstmt.setString(7, orgViewId);
            res = pstmt.executeQuery();
            while (res.next()) {
                BgFormInfo b = BgViewServerHelper.buildBgFormInfo(res);
                bgForms.put(b.getOrgUnit().getId().toString(), b);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(res, pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)res, (Statement)pstmt);
        return bgForms;
    }

    @Override
    protected BgFormInfo _checkBgForm(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo == null || bgFormInfo.getBgScheme() == null || bgFormInfo.getBgTemplate() == null || bgFormInfo.getBgPeriod() == null || bgFormInfo.getCurrency() == null || bgFormInfo.getBgVersion() == null) {
            return null;
        }
        BgFormInfo formInfo = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select top 1 FID from T_MBG_BgForm where FBgSchemeId = ? and FBgTemplateId = ? and FBgPeriodId = ? and FCurrencyId = ? and FBgVersionId = ?");
            pstmt.setString(1, bgFormInfo.getBgScheme().getId().toString());
            pstmt.setString(2, bgFormInfo.getBgTemplate().getId().toString());
            pstmt.setString(3, bgFormInfo.getBgPeriod().getId().toString());
            pstmt.setString(4, bgFormInfo.getCurrency().getId().toString());
            pstmt.setString(5, bgFormInfo.getBgVersion().getId().toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                formInfo = BgViewServerHelper.getBgFormInfo(conn, BOSUuid.read((String)rst.getString("FID")), false);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return formInfo;
    }

    @Override
    protected IObjectPK _updateBgFormInfo(Context ctx, BgFormInfo bgFormInfo) throws BOSException, EASBizException {
        if (bgFormInfo != null && bgFormInfo.getId() != null) {
            ObjectUuidPK pk = new ObjectUuidPK(bgFormInfo.getId());
            Connection conn = null;
            PreparedStatement pstmt = null;
            try {
                conn = this.getConnection(ctx);
                Map bgFormMap = this.getBgFormMap(ctx, conn, bgFormInfo, false);
                if (bgFormMap == null || bgFormMap.isEmpty()) {
                    ObjectUuidPK objectUuidPK = pk;
                    return objectUuidPK;
                }
                pstmt = conn.prepareStatement("update T_MBg_bgform set FName = ?, FDescription = ? where fid = ?");
                int index = 0;
                for (BgFormInfo b : bgFormMap.values()) {
                    if (b == null || b.getId() == null) continue;
                    pstmt.setString(1, bgFormInfo.getName());
                    pstmt.setString(2, bgFormInfo.getDescription());
                    pstmt.setString(3, b.getId().toString());
                    pstmt.addBatch();
                    if (++index <= 50) continue;
                    index = 0;
                    pstmt.executeBatch();
                }
                if (index > 0) {
                    pstmt.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt, (Connection)conn);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup(pstmt, (Connection)conn);
            }
            return pk;
        }
        return null;
    }

    @Override
    protected Map _getInitBgViewDimensionInfo(Context ctx, IMbgViewManager iMbgViewManager, String bgViewId, String orgViewId, String currOrgId, boolean isOnlyCurrOrg, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (iMbgViewManager == null || StringUtils.isEmpty((String)bgViewId)) {
            return null;
        }
        HashMap<Integer, Map> res = new HashMap<Integer, Map>();
        Map subMap = null;
        IBgDimensionManager iBgDimensionManager = null;
        for (int sheetIndex = 0; sheetIndex < iMbgViewManager.getSheetManagers().size(); ++sheetIndex) {
            iBgDimensionManager = iMbgViewManager.getSheetManagers().get(sheetIndex).getDimensionManager();
            subMap = this.getInitViewDimensionInfo(ctx, iBgDimensionManager, bgViewId, orgViewId, false, isOnlyCurrOrg, currOrgId, isOnlyLeaf);
            if (subMap == null) continue;
            res.put(sheetIndex, subMap);
        }
        return res;
    }

    private Map getInitViewDimensionInfo(Context ctx, IBgDimensionManager bgDimensionManager, String bgViewId, String orgViewId, boolean isAdjust, boolean isOnlyCurrOrg, String currOrgId, boolean isOnlyLeaf) throws BOSException, EASBizException {
        if (bgDimensionManager == null || StringUtils.isEmpty((String)bgViewId)) {
            return null;
        }
        BgFormInfo bgForm = this.queryBgFormInfo(ctx, bgViewId);
        if (bgForm == null) {
            return null;
        }
        HashMap<String, Map> resMap = new HashMap<String, Map>();
        resMap.put("BGPERIOD", BgViewServerHelper.queryBgViewBgPeriod(ctx, bgDimensionManager, bgForm, null));
        resMap.put("ORGUNIT", BgViewServerHelper.queryBgViewOrgUnit(ctx, bgDimensionManager.getPermissionNumber(), bgForm, orgViewId, isAdjust, isOnlyCurrOrg, currOrgId, isOnlyLeaf, null));
        resMap.put("CURRENCY", this.queryBgViewCurrency(ctx, bgDimensionManager, bgForm));
        return resMap;
    }

    private Map queryBgViewCurrency(Context ctx, IBgDimensionManager bgDimensionManager, BgFormInfo bgFormInfo) throws BOSException {
        HashMap<String, CurrencyInfo> resMap = new HashMap<String, CurrencyInfo>();
        if (bgDimensionManager != null) {
            BgDimensionBaseInfo currency = null;
            for (int i = 0; i < bgDimensionManager.getDimension().size(); ++i) {
                if (!MBGLayoutConstants.BG_CURRENCY.equalsIgnoreCase(((BgDimensionInfo)bgDimensionManager.getDimension().get(i)).getNumber())) continue;
                currency = (BgDimensionInfo)bgDimensionManager.getDimension().get(i);
            }
            HashSet<String> currNums = new HashSet<String>();
            currNums.add(bgFormInfo.getCurrency().getNumber());
            if (currency != null && !currency.getMember().isEmpty()) {
                for (int i = 0; i < currency.getMember().size(); ++i) {
                    currNums.add(((BgDimensionMember)currency.getMember().get(i)).getNumber());
                }
            }
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("precision");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", currNums, CompareType.INCLUDE));
            CurrencyCollection col = CurrencyFactory.getLocalInstance((Context)ctx).getCurrencyCollection(evi);
            if (col != null) {
                for (int i = 0; i < col.size(); ++i) {
                    resMap.put(col.get(i).getNumber(), col.get(i));
                }
            }
        }
        return resMap;
    }

    private BgFormInfo queryBgFormInfo(Context ctx, String bgViewId) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("orgUnit.id");
        evi.getSelector().add("orgUnit.longNumber");
        evi.getSelector().add("bgTemplate.id");
        evi.getSelector().add("bgTemplate.root.id");
        evi.getSelector().add("bgScheme.id");
        evi.getSelector().add("bgPeriod.id");
        evi.getSelector().add("bgPeriod.number");
        evi.getSelector().add("bgPeriod.name");
        evi.getSelector().add("bgPeriod.periodType");
        evi.getSelector().add("bgPeriod.level");
        evi.getSelector().add("bgPeriod.longNumber");
        evi.getSelector().add("currency.id");
        evi.getSelector().add("currency.number");
        evi.getSelector().add("currency.name");
        evi.getSelector().add("state");
        evi.getSelector().add("bgVersion.id");
        evi.getSelector().add("bgVersion.number");
        evi.getSelector().add("bgVersion.name");
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgViewId));
        BgFormCollection col = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
        if (col != null && !col.isEmpty()) {
            return col.get(0);
        }
        return null;
    }

    @Override
    protected Map _initDimensionCache(Context ctx, IMbgViewManager view) throws BOSException, EASBizException {
        DimensionCacheHelper cacherHelper = new DimensionCacheHelper(ctx);
        if (view != null) {
            for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                IMbgSheetManager sheet = view.getSheetManagers().get(s);
                IBgDimensionManager dimensionManager = sheet.getDimensionManager();
                for (int d = 0; d < dimensionManager.getDimension().size(); ++d) {
                    BgDimensionInfo dimension = (BgDimensionInfo)dimensionManager.getDimension().get(d);
                    for (int m = 0; m < dimension.getMember().size(); ++m) {
                        BgDimensionMember member = (BgDimensionMember)dimension.getMember().get(m);
                    }
                    for (int r = 0; r < dimension.getMappingList().size(); ++r) {
                        cacherHelper.getRelationGroup(dimension.getMappingList().get(r).getId().toString());
                    }
                }
            }
        }
        HashMap<String, Map<String, DimensionRelationshipGroupInfo>> cacheMap = new HashMap<String, Map<String, DimensionRelationshipGroupInfo>>();
        cacheMap.put("RELATIONG_GROUP", cacherHelper.getGroups());
        return cacheMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected Map _addNewViewInfo(Context ctx, BgActualRecordInfo actualRecordInfo, Set orgUnitNumbers, String permissionNumber) throws BOSException, EASBizException {
        boolean isViewListForm;
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("result", "addViewOrgSucess");
        if (ctx == null) return result;
        if (actualRecordInfo == null) {
            return result;
        }
        HashMap<String, BgCodeNumberHelper> codeHelpers = new HashMap<String, BgCodeNumberHelper>();
        String currentOrgUnitId = actualRecordInfo.getBgForm().getOrgUnit().getId().toString();
        boolean bl = isViewListForm = actualRecordInfo.getBgForm().getBgTemplate().getFormType().getValue() == 2;
        if (actualRecordInfo.getBgForm().getBgTemplate().getFormType().getValue() != 4 && !isViewListForm) {
            return result;
        }
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        BgFormInfo bgFormInfo = actualRecordInfo.getBgForm();
        bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId()), BgNFSHelper.getFormBaseSelectors(false));
        BgSchemeInfo schemeInfo = bgFormInfo.getBgScheme();
        BgTemplateInfo templateInfo = bgFormInfo.getBgTemplate();
        BgPeriodInfo bgPeriodInfo = bgFormInfo.getBgPeriod();
        CurrencyInfo currencyInfo = bgFormInfo.getCurrency();
        BgVersionInfo bgVersion = bgFormInfo.getBgVersion();
        BgPeriodInfo actualPeriod = actualRecordInfo.getBgPeriod();
        String bgSchemeId = schemeInfo.getId().toString();
        String bgTemplateId = templateInfo.getId().toString();
        String currencyId = currencyInfo.getId().toString();
        String bgPeriodId = bgPeriodInfo.getId().toString();
        String bgVersionId = bgVersion.getId().toString();
        String acPeriodId = actualPeriod.getId().toString();
        Map<String, OrgUnitInfo> orgMap = this.getOrgMap(ctx, orgUnitNumbers);
        Set<String> orgIds = orgMap.keySet();
        HashSet<String> successAddFormIds = new HashSet<String>();
        Connection conn = null;
        IRowSet rst = null;
        IRowSet qrst = null;
        String bgFormId = null;
        String orgUnitId = null;
        BgFormInfo tmpFormInfo = null;
        BgActualRecordInfo tmpRecordInfo = null;
        IBgActualRecord iBgActualRecord = null;
        IMutexServiceControl imc = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tmpOrgTable = null;
        HashMap<String, OrgUnitInfo> successOrgs = new HashMap<String, OrgUnitInfo>();
        HashMap<String, OrgUnitInfo> noPermission = new HashMap<String, OrgUnitInfo>();
        HashMap<String, OrgUnitInfo> numberDep = new HashMap<String, OrgUnitInfo>();
        HashMap<String, OrgUnitInfo> noAuditForm = new HashMap<String, OrgUnitInfo>();
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        try {
            conn = this.getConnection(ctx);
            tmpOrgTable = pool.createTempTable("CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpOrgTable + " (FID) values (?)"), orgIds);
            StringBuffer query = new StringBuffer();
            query.append("select f.FID, f.FOrgUnitId,f.FState from T_MBG_BgForm f  where f.FBgSchemeId = ?  and f.FBgPeriodID = ? and f.FCurrencyID = ? and f.FBgVersionId = ? and f.FBgTemplateId = ? ");
            query.append(" and f.FOrgUnitId in (select Fid from " + tmpOrgTable + ")");
            StringBuffer check = new StringBuffer();
            check.append("select t.FID from T_MBG_BgActualRecord t join T_MBG_BgForm f on t.FBgFormID = f.FID join T_MBG_BgTemplate te on f.FBgTemplateID = te.FID where f.FOrgUnitID = ? and f.FBgSchemeId = ? and te.FRootID = ? and f.FCurrencyID = ? and f.FBgPeriodID = ? and t.FBgPeriodID = ? and f.FBgVersionId = ?");
            imc = MutexServiceControlFactory.getLocalInstance((Context)ctx);
            iBgActualRecord = BgActualRecordFactory.getLocalInstance(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)query.toString(), (Object[])new Object[]{bgSchemeId, bgPeriodId, currencyId, bgVersionId, bgTemplateId});
            while (rst.next()) {
                bgFormId = rst.getString("FID");
                orgUnitId = rst.getString("FOrgUnitId");
                int fState = rst.getInt("FState");
                if (permissionNumber != null && !PermissionFactory.getLocalInstance((Context)ctx).hasFunctionPermission((IObjectPK)userPK, (IObjectPK)new ObjectStringPK(orgUnitId), permissionNumber)) {
                    noPermission.put(orgMap.get(orgUnitId).getNumber(), orgMap.get(orgUnitId));
                    continue;
                }
                if (!imc.requestObjIDForUpdate(bgFormId)) continue;
                tmpFormInfo = new BgFormInfo();
                tmpFormInfo.setId(BOSUuid.read((String)bgFormId));
                try {
                    block28: {
                        block27: {
                            qrst = BgDBUtils.executeQuery((Connection)conn, (String)check.toString(), (Object[])new Object[]{orgUnitId, bgSchemeId, bgTemplateId, currencyId, bgPeriodId, acPeriodId, bgVersionId});
                            if (qrst.next()) break block27;
                            if (this.getDefaultStates().contains(fState)) {
                                tmpFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(tmpFormInfo.getId()), BgNFSHelper.getViewBaseSelectors());
                                tmpRecordInfo = this.createNewRecordInfo(ctx, tmpFormInfo, actualRecordInfo, codeHelpers);
                                tmpRecordInfo.setNumber(null);
                                BgCodeNumberNHelper.applyNumber((Context)ctx, (IObjectValue)tmpRecordInfo, (String)orgUnitId, (String)"sourceType", (String)"number", (boolean)false);
                                if (tmpRecordInfo.getNumber() == null) {
                                    tmpRecordInfo.setNumber(actualRecordInfo.getNumber());
                                }
                                if (tmpRecordInfo != null) {
                                    if (currentOrgUnitId.equals(orgUnitId) && isViewListForm && actualRecordInfo.getId() != null) {
                                        tmpRecordInfo.setId(actualRecordInfo.getId());
                                    }
                                    iBgActualRecord.addNewInNewTx(tmpRecordInfo);
                                    successOrgs.put(orgUnitId, orgMap.get(orgUnitId));
                                    successAddFormIds.add(tmpRecordInfo.getId().toString());
                                }
                            }
                            break block28;
                        }
                        if (orgUnitNumbers.contains(orgMap.get(orgUnitId).getNumber())) {
                            successOrgs.put(orgUnitId, orgMap.get(orgUnitId));
                            successAddFormIds.add(qrst.getString("FID"));
                        }
                    }
                    SQLUtils.cleanup((ResultSet)qrst);
                }
                catch (Exception ex) {
                    logger.error((Object)"batchAddnew ActualRecord Sql Error:", (Throwable)ex);
                    if (!ex.getClass().equals(EASBizException.class)) continue;
                    EASBizException exception = (EASBizException)((Object)ex);
                    if (!EASBizException.CHECKNUMDUP.getCode().equals(exception.getSubCode())) continue;
                    numberDep.put(orgMap.get(orgUnitId).getNumber(), orgMap.get(orgUnitId));
                    continue;
                }
                MBgCheckHelper.releaseMutex(ctx, bgFormId);
                continue;
                finally {
                    SQLUtils.cleanup(qrst);
                    MBgCheckHelper.releaseMutex(ctx, bgFormId);
                }
            }
        }
        catch (Exception ex) {
            try {
                logger.error((Object)"batchAddnew ActualRecord Sql Error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                try {
                    pool.releaseDBSystemTempTable(tmpOrgTable, conn);
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error((Object)"batchAddnew ActualRecord releaseDBSystemTempTable Error:", (Throwable)e);
                }
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        try {
            pool.releaseDBSystemTempTable(tmpOrgTable, conn);
        }
        catch (Exception e) {
            logger.error((Object)"batchAddnew ActualRecord releaseDBSystemTempTable Error:", (Throwable)e);
        }
        for (String keyStr : orgMap.keySet()) {
            if (successOrgs.containsKey(keyStr) || noPermission.containsKey(orgMap.get(keyStr).getNumber()) || numberDep.containsKey(orgMap.get(keyStr).getNumber())) continue;
            noAuditForm.put(orgMap.get(keyStr).getNumber(), orgMap.get(keyStr));
        }
        boolean hasFail = false;
        if (!noPermission.isEmpty()) {
            hasFail = true;
            result.put("addActualOrgNoPermission", noPermission);
        }
        if (!numberDep.isEmpty()) {
            hasFail = true;
            result.put("addActualOrgNumberDep", numberDep);
        }
        if (!noAuditForm.isEmpty()) {
            hasFail = true;
            result.put("addActualnoAuditForm", noAuditForm);
        }
        if (!successAddFormIds.isEmpty()) {
            result.put("successAddFormIds", successAddFormIds);
        }
        if (!hasFail) return result;
        result.put("result", "addViewOrgFail");
        return result;
    }
}

