/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.mbg.BgHideItemEnum;
import com.kingdee.eas.ma.mbg.BgViewHideSettingInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgViewHideSettingControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class BgViewHideSettingControllerBean
extends AbstractBgViewHideSettingControllerBean {
    private static final long serialVersionUID = 3889618655892811147L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgViewHideSettingControllerBean");

    @Override
    protected void _saveSetting(Context ctx, BOSUuid userID, BOSUuid bgFormID, BgHideItemEnum rowHideItem, BgHideItemEnum colHideItem) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select distinct * from T_MBG_BgViewHideSetting where FUserID = ? and FBgFormID = ? ");
            pstmt.setString(1, userID.toString());
            pstmt.setString(2, bgFormID.toString());
            ResultSet rs = pstmt.executeQuery();
            if (rs != null && rs.next()) {
                if (rowHideItem.equals((Object)BgHideItemEnum.UNHIDE) && colHideItem.equals((Object)BgHideItemEnum.UNHIDE)) {
                    pstmt = conn.prepareStatement("delete from T_MBG_BgViewHideSetting where FUserID = ? and FBgFormID = ?");
                    pstmt.setString(1, userID.toString());
                    pstmt.setString(2, bgFormID.toString());
                    pstmt.executeUpdate();
                } else {
                    pstmt = conn.prepareStatement("update T_MBG_BgViewHideSetting set FRowHideItem = ? , FColHideItem = ? where FUserID = ? and FBgFormID = ?");
                    pstmt.setInt(1, rowHideItem.getValue());
                    pstmt.setInt(2, colHideItem.getValue());
                    pstmt.setString(3, userID.toString());
                    pstmt.setString(4, bgFormID.toString());
                    pstmt.executeUpdate();
                }
            } else if (!rowHideItem.equals((Object)BgHideItemEnum.UNHIDE) || !colHideItem.equals((Object)BgHideItemEnum.UNHIDE)) {
                BOSUuid uuid = BOSUuid.create((BOSObjectType)new BgViewHideSettingInfo().getBOSType());
                pstmt = conn.prepareStatement("insert into T_MBG_BgViewHideSetting (FID,FUserID,FBgFormID,FRowHideItem,FColHideItem) values (?,?,?,?,?)");
                pstmt.setString(1, uuid.toString());
                pstmt.setString(2, userID.toString());
                pstmt.setString(3, bgFormID.toString());
                pstmt.setInt(4, rowHideItem.getValue());
                pstmt.setInt(5, colHideItem.getValue());
                pstmt.executeUpdate();
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected Map _loadSetting(Context ctx, BOSUuid userID, BOSUuid bgFormID) throws BOSException, EASBizException {
        HashMap<String, BgHideItemEnum> hashMap;
        Connection conn = null;
        PreparedStatement pstmt = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select distinct * from T_MBG_BgViewHideSetting where FUserID = ? and FBgFormID = ? ");
            pstmt.setString(1, userID.toString());
            pstmt.setString(2, bgFormID.toString());
            ResultSet rs = pstmt.executeQuery();
            HashMap<String, BgHideItemEnum> map = new HashMap<String, BgHideItemEnum>();
            map.put("rowHideItem", BgHideItemEnum.UNHIDE);
            map.put("colHideItem", BgHideItemEnum.UNHIDE);
            if (rs != null && rs.next()) {
                int rowHideItem = rs.getInt("FROWHIDEITEM");
                int colhideItem = rs.getInt("FCOLHIDEITEM");
                map.put("rowHideItem", BgHideItemEnum.getEnum(rowHideItem));
                map.put("colHideItem", BgHideItemEnum.getEnum(colhideItem));
            }
            hashMap = map;
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
        return hashMap;
    }
}

