/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.TreeBaseCollection;
import com.kingdee.eas.framework.TreeBaseInfo;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberCollection;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberFactory;
import com.kingdee.eas.ma.mbg.BgdimDisplayMemberInfo;
import com.kingdee.eas.ma.mbg.app.AbstractBgdimDisplayMemberControllerBean;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgdimDisplayMemberControllerBean
extends AbstractBgdimDisplayMemberControllerBean {
    private static final String dimension = null;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BgdimDisplayMemberControllerBean");
    private String bgDimViewTableName = "T_MBG_MbgView";
    private String bgAccountViewTableName = "T_MBG_BgAccountView";
    private Set parentFreezed = new HashSet();

    @Override
    protected Map _effectiveProp(Context ctx, String dimNumber, Set idSets, String bgSchemeId, boolean isFreezed) throws BOSException, EASBizException {
        HashMap propResult = new HashMap();
        BgdimDisplayMemberCollection disMemberCol = new BgdimDisplayMemberCollection();
        disMemberCol = this.getPolAlColByScheme(ctx, dimNumber, bgSchemeId);
        String viewId = this.getViewId(ctx, dimNumber, bgSchemeId);
        TreeBaseCollection col = this.allMemberByView(ctx, viewId, dimNumber);
        Map result = this.dealMember(col, idSets, isFreezed, disMemberCol);
        ArrayList<String> canceledIds = new ArrayList<String>();
        ArrayList<String> unCanceledIds = new ArrayList<String>();
        ArrayList<String> unCanceledParent = new ArrayList<String>();
        CoreBaseCollection deleteCol = new CoreBaseCollection();
        CoreBaseCollection saveCol = new CoreBaseCollection();
        HashMap<String, String> dimMemberIdMap = new HashMap<String, String>();
        HashMap<String, BgdimDisplayMemberInfo> dimMemberInfoMap = new HashMap<String, BgdimDisplayMemberInfo>();
        for (int i = 0; i < disMemberCol.size(); ++i) {
            BgdimDisplayMemberInfo disMemberInfo = disMemberCol.get(i);
            String disMemId = disMemberInfo.getMemberId().toString();
            dimMemberIdMap.put(disMemId, disMemberInfo.getId().toString());
            dimMemberInfoMap.put(disMemberInfo.getId().toString(), disMemberInfo);
        }
        if (isFreezed) {
            HashSet<String> AllChildSet = new HashSet<String>();
            for (String id : idSets) {
                Set childSet = (Set)result.get(id);
                if (dimMemberIdMap.keySet().contains(id)) {
                    if (!idSets.contains(id)) continue;
                    canceledIds.add(id);
                    continue;
                }
                if (AllChildSet.contains(id)) continue;
                BgdimDisplayMemberInfo newMember = new BgdimDisplayMemberInfo();
                newMember.setSchemeId(bgSchemeId);
                newMember.setDimNumber(dimNumber);
                newMember.setMemberId(id);
                newMember.setIsFreezed(true);
                saveCol.add((CoreBaseInfo)newMember);
                AllChildSet.add(id);
                if (childSet.size() <= 0) continue;
                for (String childId : childSet) {
                    if (AllChildSet.contains(childId)) continue;
                    BgdimDisplayMemberInfo childMember = new BgdimDisplayMemberInfo();
                    childMember.setSchemeId(bgSchemeId);
                    childMember.setDimNumber(dimNumber);
                    childMember.setMemberId(childId);
                    childMember.setIsFreezed(true);
                    AllChildSet.add(childId);
                    saveCol.add((CoreBaseInfo)childMember);
                }
            }
            if (saveCol != null && saveCol.size() != 0) {
                BgdimDisplayMemberFactory.getLocalInstance(ctx).saveBatchData(saveCol);
            }
            propResult.put("canceledIds", canceledIds);
            return propResult;
        }
        for (String id : idSets) {
            Set idParent = (Set)result.get(id);
            if (!dimMemberIdMap.keySet().contains(id)) {
                unCanceledIds.add(id);
            }
            if (dimMemberIdMap.keySet().contains(id)) {
                if (idParent.size() == 0) {
                    String disMemId = (String)dimMemberIdMap.get(id);
                    deleteCol.add((CoreBaseInfo)dimMemberInfoMap.get(disMemId));
                } else if (dimMemberIdMap.keySet().containsAll(idParent)) {
                    if (idSets.containsAll(idParent)) {
                        String disMemId = (String)dimMemberIdMap.get(id);
                        deleteCol.add((CoreBaseInfo)dimMemberInfoMap.get(disMemId));
                    } else {
                        unCanceledParent.add(id);
                    }
                } else {
                    String disMemId;
                    boolean freezed = this.haseFreezed(dimMemberIdMap, idParent);
                    if (!freezed) {
                        disMemId = (String)dimMemberIdMap.get(id);
                        deleteCol.add((CoreBaseInfo)dimMemberInfoMap.get(disMemId));
                    } else if (idSets.containsAll(this.parentFreezed)) {
                        disMemId = (String)dimMemberIdMap.get(id);
                        deleteCol.add((CoreBaseInfo)dimMemberInfoMap.get(disMemId));
                    } else {
                        unCanceledParent.add(id);
                    }
                }
            }
            idParent.clear();
            this.parentFreezed.clear();
        }
        if (deleteCol != null && deleteCol.size() != 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[deleteCol.size()];
            for (int i = 0; i < deleteCol.size(); ++i) {
                pks[i] = new ObjectUuidPK(deleteCol.get(i).getId());
            }
            BgdimDisplayMemberFactory.getLocalInstance(ctx).deleteBatchData((IObjectPK[])pks);
        }
        propResult.put("unCanceledParent", unCanceledParent);
        propResult.put("unCanceledIds", unCanceledIds);
        return propResult;
    }

    private Boolean haseFreezed(Map<String, String> dimMemberIdMap, Set idParent) {
        boolean freezed = false;
        for (String parentId : idParent) {
            if (!dimMemberIdMap.keySet().contains(parentId)) continue;
            freezed = true;
            this.parentFreezed.add(parentId);
        }
        return freezed;
    }

    protected Map dealMember(TreeBaseCollection col, Set idSets, boolean isFreezed, BgdimDisplayMemberCollection disMemberCol) {
        String longNumber;
        HashMap result = new HashMap();
        HashMap<String, String> numberMap = new HashMap<String, String>();
        HashMap<String, String> longNumberMap = new HashMap<String, String>();
        for (int i = 0; i < col.size(); ++i) {
            TreeBaseInfo dimension = col.get(i);
            String memberId = dimension.getId().toString();
            String number = dimension.getNumber().toString();
            longNumber = dimension.getLongNumber();
            numberMap.put(number, memberId);
            longNumberMap.put(memberId, longNumber);
        }
        if (isFreezed) {
            HashSet<String> freezeSet = new HashSet<String>();
            if (disMemberCol.size() > 0) {
                for (int i = 0; i < disMemberCol.size(); ++i) {
                    freezeSet.add(disMemberCol.get(i).getMemberId().toString());
                }
            }
            HashSet<String> childSet = new HashSet<String>();
            for (String id : idSets) {
                longNumber = (String)longNumberMap.get(id);
                if (childSet.contains(id)) continue;
                for (int j = 0; j < col.size(); ++j) {
                    TreeBaseInfo dimension = col.get(j);
                    String dimLongNumber = dimension.getLongNumber();
                    if (!dimLongNumber.startsWith(longNumber + "!") || freezeSet.contains(dimension.getId().toString())) continue;
                    childSet.add(dimension.getId().toString());
                }
                HashSet<String> clone = new HashSet<String>();
                clone.addAll(childSet);
                result.put(id, clone);
                childSet.clear();
            }
        } else {
            HashSet<String> parentSet = new HashSet<String>();
            for (String id : idSets) {
                String longNumber2 = (String)longNumberMap.get(id);
                int in = longNumber2.lastIndexOf("!");
                String parentLonNumber = null;
                if (in > 0) {
                    parentLonNumber = longNumber2.substring(0, in);
                }
                if (parentLonNumber != null) {
                    String[] ArrayLongNumber = parentLonNumber.split("!");
                    for (int index = 0; index < ArrayLongNumber.length; ++index) {
                        String number = ArrayLongNumber[index];
                        String memberId = (String)numberMap.get(number);
                        parentSet.add(memberId);
                    }
                }
                HashSet<String> clone = new HashSet<String>();
                clone.addAll(parentSet);
                result.put(id, clone);
                parentSet.clear();
            }
        }
        return result;
    }

    protected TreeBaseCollection allMemberByView(Context ctx, String viewId, String dimNumber) throws BOSException {
        TreeBaseCollection col = new TreeBaseCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic1 = new SelectorItemCollection();
        sic1.add("id");
        sic1.add("number");
        sic1.add("name");
        sic1.add("longNumber");
        sic1.add("level");
        sic1.add("parent.id");
        evi.getSelector().addObjectCollection((IObjectCollection)sic1);
        evi.setFilter(filter);
        try {
            if (dimNumber.equals("BG_Account")) {
                filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)viewId, CompareType.EQUALS));
                BgAccountCollection accCol = BgAccountFactory.getLocalInstance((Context)ctx).getBgAccountCollection(evi);
                for (int i = 0; i < accCol.size(); ++i) {
                    col.add((TreeBaseInfo)accCol.get(i));
                }
            } else {
                filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)viewId, CompareType.EQUALS));
                MbgMemberCollection dim = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(evi);
                for (int i = 0; i < dim.size(); ++i) {
                    col.add((TreeBaseInfo)dim.get(i));
                }
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return col;
    }

    private String getViewTableName(String dimNumber) {
        String tableName = null;
        tableName = dimNumber.equals("BG_Account") ? this.bgAccountViewTableName : this.bgDimViewTableName;
        return tableName;
    }

    private BgdimDisplayMemberCollection getPolAlColByScheme(Context ctx, String dimNumber, String schemeId) throws BOSException {
        BgdimDisplayMemberCollection memberCol = new BgdimDisplayMemberCollection();
        try {
            EntityViewInfo evi = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("polAlgorithm");
            sic.add("isFreezed");
            sic.add("dimNumber");
            sic.add("MemberId");
            sic.add("schemeId");
            evi.setSelector(sic);
            FilterInfo filter = new FilterInfo();
            FilterItemInfo item1 = new FilterItemInfo("dimNumber", (Object)dimNumber, CompareType.EQUALS);
            FilterItemInfo item2 = new FilterItemInfo("schemeId", (Object)schemeId, CompareType.EQUALS);
            filter.getFilterItems().add(item1);
            filter.getFilterItems().add(item2);
            filter.setMaskString(" #0 and #1 ");
            evi.setFilter(filter);
            memberCol = BgdimDisplayMemberFactory.getLocalInstance(ctx).getBgdimDisplayMemberCollection(evi);
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        return memberCol;
    }

    private String getViewId(Context ctx, String dimNumber, String schemeId) throws BOSException {
        String viewId = null;
        String viewTable = this.getViewTableName(dimNumber);
        String sql = "SELECT p.fid FROM t_mbg_bgScheme sc LEFT OUTER JOIN t_mbg_bgDimSettings st on st.fbgSchemeid = sc.fid   LEFT OUTER JOIN t_mbg_bgDimSettingsMember dm on dm.fbgDimSettingsid = st.fid  LEFT OUTER JOIN  " + viewTable + " p on p.fid = dm.fmemberid  where sc.fid = '" + schemeId + "' and st.fdimNumber = '" + dimNumber + "'";
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql);
        IRowSet rs = null;
        try {
            rs = iSql.executeSQL();
            try {
                while (rs.next()) {
                    viewId = rs.getString(1);
                }
            }
            catch (SQLException e) {
                logger.error((Object)"SQL Error:", (Throwable)e);
            }
        }
        catch (BOSException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return viewId;
    }

    @Override
    protected Set _getFreezedNums(Context ctx, String bgSchemeId, String dimNumber) throws BOSException, EASBizException {
        HashSet<String> freezedMemberNums = new HashSet<String>();
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)dimNumber)) {
            return freezedMemberNums;
        }
        String dimTable = null;
        if (dimNumber.equals(DimensionConstants.DEF_ACCOUNT_NUMBER)) {
            dimTable = "T_Mbg_BgAccount";
        } else if (!DimensionConstants.canNotCancel.contains(dimNumber)) {
            dimTable = "T_MBG_MbgMember";
        }
        if (dimTable == null) {
            return freezedMemberNums;
        }
        Object[] params = new Object[]{bgSchemeId, dimNumber};
        String sql = "Select FNumber From " + dimTable + " where FId in ( Select FMemberId From T_MBG_BgdimDisplayMember where FSchemeId = ? And FDimNumber = ? )";
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])params);
            while (rst.next()) {
                freezedMemberNums.add(rst.getString("FNumber"));
            }
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return freezedMemberNums;
    }
}

