/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Parameter;
import com.kingdee.bos.ctrl.excel.model.util.SortedParameterArray;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementFactory;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionFactory;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.BgCurrencyHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgElementHelper;
import com.kingdee.eas.ma.base.utils.BgScenarioHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.utils.BizPtoUtils;
import com.kingdee.eas.ma.mbg.BgDataSourceEnum;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.IMbgDetailDataQueryFacade;
import com.kingdee.eas.ma.mbg.MbgDataQueryTypeEnum;
import com.kingdee.eas.ma.mbg.MbgDetailDataQueryFacadeFactory;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractBizCalcTraceFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.formula.impl.aggregate.BgAggregateCalculator;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.app.utils.BgClosureMapUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceInfo;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceResult;
import com.kingdee.eas.ma.mbg.calctrace.BizCalcTraceUtils;
import com.kingdee.eas.ma.mbg.calctrace.ICalcTraceInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgDataDetailInfo;
import com.kingdee.eas.ma.mbg.common.MbgDataDetailMember;
import com.kingdee.eas.ma.mbg.common.MbgViewManagerImpl;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.MbgDataQueryFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgNExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgRptReportPropertyAdapter;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionMemberCheckHelper;
import com.kingdee.eas.ma.mbg.utils.FormulaUtils;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.eas.ma.mbg.utils.data.AuditParam;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BizCalcTraceFacadeControllerBean
extends AbstractBizCalcTraceFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.BizCalcTraceFacadeControllerBean");

    @Override
    protected Object _bizCalcTrace(Context ctx, String bgSchemeId, String orgId, String bgVersionNumber, String formula, IObjectValue model) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)orgId) || StringUtils.isEmpty((String)bgVersionNumber) || StringUtils.isEmpty((String)formula)) {
            return null;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        if (bgFormInfo.getId() == null) {
            return null;
        }
        boolean isAdjust = false;
        if (bgFormInfo != null && bgFormInfo.get("isAdjust") instanceof Boolean && ((Boolean)bgFormInfo.get("isAdjust")).booleanValue()) {
            isAdjust = true;
        }
        BizCalcTraceResult bizCalcTraceResult = new BizCalcTraceResult();
        bizCalcTraceResult.setFormula(formula);
        bizCalcTraceResult.setBgVersionNumber(bgVersionNumber);
        bizCalcTraceResult.setOrgUnitId(orgId);
        bizCalcTraceResult.setCalcTrace(true);
        bizCalcTraceResult.setCtx(ctx);
        IDimensionParameter parameter = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            bgFormInfo = this.queryBgForm(ctx, bgFormInfo.getId().toString(), orgId);
            bizCalcTraceResult.setBgProcess(bgFormInfo.getProcessType().getName());
            bgFormInfo.put("isAdjust", isAdjust);
            parameter = this.transParameter(ctx, conn, bizCalcTraceResult, bgSchemeId, orgId, bgVersionNumber, formula, bgFormInfo);
            bizCalcTraceResult.parse(ctx, parameter);
            Map[] data = this.getCMPDataMap(ctx, parameter, bizCalcTraceResult);
            bizCalcTraceResult.transResult(ctx, parameter, data);
            bizCalcTraceResult.reQueryDataForm(ctx, bgFormInfo);
            bizCalcTraceResult.after();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException("", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bizCalcTraceResult;
    }

    protected BgFormInfo queryBgForm(Context ctx, String bgFormId, String orgId) throws BOSException {
        BgFormInfo bgFormInfo = null;
        if (StringUtils.isEmpty((String)bgFormId) || StringUtils.isEmpty((String)orgId)) {
            return bgFormInfo;
        }
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgFormInfo info = MbgDataHelper.getBgFormInfo(conn, ctx.getLocale(), BOSUuid.read((String)bgFormId));
            if (info.getOrgUnit().getId().toString().equals(orgId)) {
                BgFormInfo bgFormInfo2 = info;
                return bgFormInfo2;
            }
            Object[] orgIds = new String[]{orgId};
            Map formMap = MbgViewListFormServerHelper.queryBgFormByOrgUnitId(ctx, info, orgIds);
            if (formMap != null && !formMap.isEmpty()) {
                bgFormInfo = (BgFormInfo)formMap.get(orgId);
                if (bgFormInfo.getBgVersion() == null || StringUtils.isEmpty((String)bgFormInfo.getBgVersion().getNumber())) {
                    bgFormInfo.setBgVersion(info.getBgVersion());
                }
                if (bgFormInfo.getBgPeriod() == null || StringUtils.isEmpty((String)bgFormInfo.getBgPeriod().getNumber())) {
                    bgFormInfo.setBgPeriod(info.getBgPeriod());
                }
                if (bgFormInfo.getCurrency() == null || StringUtils.isEmpty((String)bgFormInfo.getCurrency().getNumber())) {
                    bgFormInfo.setCurrency(info.getCurrency());
                }
            }
            if (bgFormInfo == null) {
                bgFormInfo = (BgFormInfo)info.clone();
                bgFormInfo.getOrgUnit().setId(BOSUuid.read((String)orgId));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgFormInfo;
    }

    protected IDimensionParameter transParameter(Context ctx, Connection conn, BizCalcTraceResult bizCalcTraceResult, String bgSchemeId, String orgId, String bgVersionNumber, String formula, BgFormInfo bgFormInfo) throws Exception {
        IDimensionParameter parameter = null;
        HashSet<String> formulas = new HashSet<String>();
        formulas.add(formula);
        HashSet<String> versions = new HashSet<String>();
        versions.add(bgVersionNumber);
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        BgSchemeInfo bgSchemeInfo = null;
        OrgUnitInfo orgUnitInfo = null;
        BOSUuid bgOrgViewId = null;
        BgSchemeDimensionHelper schemeHelper = null;
        Map<String, String> srcFieldMap = null;
        IMbgViewManager viewManager = null;
        bgSchemeInfo = BgViewServerHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)bgSchemeId));
        orgUnitInfo = MbgDataHelper.getOrgUnitInfo(ctx, BOSUuid.read((String)orgId));
        bgFormInfo.setBgScheme(bgSchemeInfo);
        bgOrgViewId = bgSchemeInfo.getEditOrgViewId();
        schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        srcFieldMap = this.getSrcFieldMap(ctx, schemeHelper);
        viewManager = DimensionFormulaHelper.buildViewMamager(ctx, formulas, versions);
        viewManager = TemplateFacadeFactory.getLocalInstance(ctx).loadViewManager(orgUnitInfo.getId().toString(), bgSchemeId, viewManager);
        IBgDimensionManager iBgDimensionManager = viewManager.getSheetManagers().get(0).getDimensionManager();
        if (iBgDimensionManager.getPageDisplayDimension().isEmpty() && !iBgDimensionManager.getPageDimension().isEmpty()) {
            iBgDimensionManager.getPageDisplayDimension().addAll(iBgDimensionManager.getPageDimension());
        }
        if (iBgDimensionManager.getRowDisplayDimension().isEmpty() && !iBgDimensionManager.getRowDimension().isEmpty()) {
            iBgDimensionManager.getRowDisplayDimension().addAll(iBgDimensionManager.getRowDimension());
        }
        if (iBgDimensionManager.getColDisplayDimension().isEmpty() && !iBgDimensionManager.getColDimension().isEmpty()) {
            iBgDimensionManager.getColDisplayDimension().addAll(iBgDimensionManager.getColDimension());
        }
        dimensionManager.add(viewManager.getSheetManagers().get(0).getDimensionManager());
        parameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        parameter.getDataManager().getSrcFieldMap().putAll(srcFieldMap);
        MbgDimCollection colls = null;
        MbgDimInfo mbgDim = null;
        if (parameter.getDataManager().getDimensions() != null && !parameter.getDataManager().getDimensions().isEmpty()) {
            colls = parameter.getDataManager().getDimensions();
            int in = colls.size();
            for (int i = 0; i < in; ++i) {
                mbgDim = colls.get(i);
                parameter.getDataManager().getMbgDims().put(mbgDim.getRefField(), mbgDim);
                parameter.getDataManager().getFieldSrcMap().put(mbgDim.getRefField(), mbgDim.getSrcNumber());
            }
        }
        parameter.getDataManager().getSrcFieldMap().put(DimensionConstants.DEF_PROCESS_SRCNUMBER, DimensionConstants.DEF_PROCESS_FIELD);
        parameter.getDataManager().getFieldSrcMap().put(DimensionConstants.DEF_PROCESS_FIELD, DimensionConstants.DEF_PROCESS_SRCNUMBER);
        if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C02)) {
            parameter.setValueType(256);
        } else if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C03)) {
            parameter.setValueType(512);
        } else if (bgFormInfo.getProcessType().equals((Object)BgProcessEnum.C04)) {
            parameter.setValueType(1024);
        }
        if (bgFormInfo.getState().equals((Object)BgFormStateEnum.Adjusted)) {
            parameter.setValueType(1);
        }
        if (bgFormInfo.getState().getValue() == 4 || bgFormInfo.getState().getValue() == 35 || bgFormInfo.getState().getValue() == 6 || bgFormInfo.get("isAdjust") instanceof Boolean && ((Boolean)bgFormInfo.get("isAdjust")).booleanValue()) {
            parameter.getControlManager().setAdjust(true);
        }
        parameter.setAllPeriodMap(BizPtoUtils.queryBgPeriodInfo((Connection)conn));
        BizCalcStrategy calcStrategy = new BizCalcStrategy();
        parameter.getDataManager().setCalcStrategy(calcStrategy);
        calcStrategy.setBizCalcTraceResult(bizCalcTraceResult);
        calcStrategy.queryCalc(ctx, parameter);
        calcStrategy.bizCalcMdx(ctx, parameter);
        return parameter;
    }

    protected Map[] getCMPDataMap(Context ctx, IDimensionParameter parameter, BizCalcTraceResult bizCalcTraceResult) throws BOSException, EASBizException {
        Map[] CMPDataMap = new Map[4];
        if (bizCalcTraceResult.getBizCalcTraces() == null || bizCalcTraceResult.getBizCalcTraces().isEmpty()) {
            return CMPDataMap;
        }
        Object cmpObj = null;
        IBgDimensionFacade facade = BgDimensionFacadeFactory.getLocalInstance(ctx);
        IDimensionParameter[] parameters = this.getCMPParameter(ctx, parameter, bizCalcTraceResult);
        if (parameters == null) {
            cmpObj = facade.dimensionQuery(parameter);
            int index = 0;
            if (parameter.getValueType() == 256) {
                index = 1;
            } else if (parameter.getValueType() == 512) {
                index = 2;
            } else if (parameter.getValueType() == 1024) {
                index = 3;
            }
            CMPDataMap[index] = (Map)cmpObj;
        } else {
            for (int index = 0; index < parameters.length; ++index) {
                parameter = parameters[index];
                if (parameter == null) continue;
                cmpObj = facade.dimensionQuery(parameter);
                CMPDataMap[index] = (Map)cmpObj;
            }
        }
        return CMPDataMap;
    }

    protected IDimensionParameter[] getCMPParameter(Context ctx, IDimensionParameter parameter, BizCalcTraceResult bizCalcTraceResult) {
        Map<String, Set<String>> cmps = this.getCMPNumber(bizCalcTraceResult);
        if (cmps.isEmpty()) {
            return null;
        }
        IDimensionParameter[] parameters = new IDimensionParameter[4];
        IDimensionParameter cloneParameter = null;
        if (cmps.containsKey(BgProcessEnum.C01.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(1);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            if (parameter.getQueryOrgIds() != null && parameter.getQueryOrgIds().size() > 1) {
                if (cmps.get(BgProcessEnum.C01.getName()).size() == 1) {
                    for (String o : cmps.get(BgProcessEnum.C01.getName())) {
                        cloneParameter.setOrgUnitId(BOSUuid.read((String)o));
                    }
                } else if (cmps.get(BgProcessEnum.C01.getName()).size() > 1) {
                    cloneParameter.setQeryOrgIds(cmps.get(BgProcessEnum.C01.getName()));
                }
            }
            parameters[0] = cloneParameter;
        }
        if (cmps.containsKey(BgProcessEnum.C02.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(256);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            if (parameter.getQueryOrgIds() != null && parameter.getQueryOrgIds().size() > 1) {
                if (cmps.get(BgProcessEnum.C02.getName()).size() == 1) {
                    for (String o : cmps.get(BgProcessEnum.C02.getName())) {
                        cloneParameter.setOrgUnitId(BOSUuid.read((String)o));
                    }
                } else if (cmps.get(BgProcessEnum.C02.getName()).size() > 1) {
                    cloneParameter.setQeryOrgIds(cmps.get(BgProcessEnum.C02.getName()));
                }
            }
            parameters[1] = cloneParameter;
        }
        if (cmps.containsKey(BgProcessEnum.C03.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(512);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            if (parameter.getQueryOrgIds() != null && parameter.getQueryOrgIds().size() > 1) {
                if (cmps.get(BgProcessEnum.C03.getName()).size() == 1) {
                    for (String o : cmps.get(BgProcessEnum.C03.getName())) {
                        cloneParameter.setOrgUnitId(BOSUuid.read((String)o));
                    }
                } else if (cmps.get(BgProcessEnum.C03.getName()).size() > 1) {
                    cloneParameter.setQeryOrgIds(cmps.get(BgProcessEnum.C03.getName()));
                }
            }
            parameters[2] = cloneParameter;
        }
        if (cmps.containsKey(BgProcessEnum.C04.getName())) {
            cloneParameter = parameter.getClone(ctx);
            cloneParameter.setValueType(1024);
            cloneParameter.getDimensionMap().putAll(parameter.getDimensionMap());
            if (parameter.getQueryOrgIds() != null && parameter.getQueryOrgIds().size() > 1) {
                if (cmps.get(BgProcessEnum.C04.getName()).size() == 1) {
                    for (String o : cmps.get(BgProcessEnum.C04.getName())) {
                        cloneParameter.setOrgUnitId(BOSUuid.read((String)o));
                    }
                } else if (cmps.get(BgProcessEnum.C04.getName()).size() > 1) {
                    cloneParameter.setQeryOrgIds(cmps.get(BgProcessEnum.C04.getName()));
                }
            }
            parameters[3] = cloneParameter;
        }
        return parameters;
    }

    protected Map<String, Set<String>> getCMPNumber(BizCalcTraceResult bizCalcTraceResult) {
        HashMap<String, Set<String>> processTypesAndOrgs = new HashMap<String, Set<String>>();
        if (bizCalcTraceResult.getBizCalcTraces() != null && !bizCalcTraceResult.getBizCalcTraces().isEmpty()) {
            this.getCMPNumber(bizCalcTraceResult.getRootInfo(bizCalcTraceResult.getBizCalcTraces()), processTypesAndOrgs);
        }
        return processTypesAndOrgs;
    }

    public void getCMPNumber(BizCalcTraceInfo info, Map<String, Set<String>> processTypes) {
        ICalcTraceInfo child = null;
        if (!processTypes.containsKey(info.getBgProcess())) {
            processTypes.put(info.getBgProcess(), new HashSet());
        }
        processTypes.get(info.getBgProcess()).add(info.getOrgUnitid());
        if (info.children != null) {
            for (int i = 0; i < info.getChildCount(); ++i) {
                child = info.getChildAt(i);
                if (!processTypes.containsKey(child.getBgProcess())) {
                    processTypes.put(child.getBgProcess(), new HashSet());
                }
                processTypes.get(child.getBgProcess()).add(child.getOrgUnitid());
                if (!(child instanceof BizCalcTraceInfo) || ((BizCalcTraceInfo)child).children == null) continue;
                this.getCMPNumber((BizCalcTraceInfo)child, processTypes);
            }
        }
    }

    public Map<String, String> getSrcFieldMap(Context ctx, BgSchemeDimensionHelper schemeHelper) throws EASBizException, BOSException {
        if (ctx == null || schemeHelper == null) {
            return null;
        }
        String dimNumber = null;
        HashMap<String, String> srcFieldMap = new HashMap<String, String>();
        Map<String, String> refFieldMap = schemeHelper.getRefFieldMap();
        Map<String, String> srcNumberMap = schemeHelper.getSrcNumberMap();
        for (Map.Entry<String, String> entry : srcNumberMap.entrySet()) {
            dimNumber = entry.getKey();
            if (refFieldMap == null || !refFieldMap.containsKey(dimNumber)) continue;
            srcFieldMap.put(entry.getValue(), refFieldMap.get(dimNumber));
        }
        return srcFieldMap;
    }

    @Override
    protected Object _queryMbgDataDetail(Context ctx, Object obj, IObjectValue model, IObjectValue bgOrgUnit) throws BOSException, EASBizException {
        if (!(obj instanceof MbgDataDetailInfo && model instanceof BgFormInfo && bgOrgUnit instanceof BgOrgUnitInfo)) {
            return obj;
        }
        MbgDataDetailInfo info = (MbgDataDetailInfo)obj;
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        BgOrgUnitInfo bgOrgUnitInfo = (BgOrgUnitInfo)bgOrgUnit;
        bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, number,name,viewid,longnumber, orgunitid, isLeaf where id = '" + bgOrgUnitInfo.getId().toString() + "'");
        String expression = info.getExpression();
        String formula = info.getFormula();
        this.queryDetail4Expression(ctx, info, bgFormInfo, bgOrgUnitInfo, expression);
        this.queryDetail4Formula(ctx, info, bgFormInfo, bgOrgUnitInfo, formula);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queryDetail4Expression(Context ctx, MbgDataDetailInfo info, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, String expression) throws BOSException {
        if (info == null || bgFormInfo == null || StringUtils.isEmpty((String)expression)) {
            return;
        }
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String bgVersionNumber = info.getBgVersionNumber();
        ArrayList<FunctionExpr> expressList = new ArrayList<FunctionExpr>();
        String filterFunction = "MbgAggregate";
        try {
            expressList.addAll(BgNExpressionHelper.getFuncionExpress(expression, filterFunction));
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        FunctionExpr express = null;
        Parameter param = null;
        Object[] args = null;
        SortedParameterArray parameters = new SortedParameterArray();
        HashMap<Parameter, String> parameterMap = new HashMap<Parameter, String>();
        if (expressList.isEmpty()) {
            return;
        }
        express = (FunctionExpr)expressList.get(0);
        BgNExpressionHelper.checkBgAggregateParam(express.parameters, (IObjectValue)bgFormInfo, bgFormInfo.getBizOrgUnit().getNumber(), null, true);
        args = new Object[express.parameters.size()];
        for (int i = 0; i < express.parameters.size(); ++i) {
            args[i] = new Variant((Object)BgNExpressionHelper.getStringValue(express.parameters.get(i)));
        }
        param = new Parameter(args, "Sheet1");
        param = new Parameter(FormulaUtils.updateParams(express.funcionName, param), "Sheet1");
        parameters.append((Object)param);
        parameterMap.put(param, express.toString());
        ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
        Book book = null;
        calcContext.setReportAdapter((IReportPropertyAdapter)new BgRptReportPropertyAdapter(bgFormInfo));
        try {
            book = bgFormInfo.getBook();
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        if (book == null) {
            book = Book.Manager.getNewBook(null, (int)0);
        }
        BookProperties p = BookProperties.loadFromBook((Book)book);
        calcContext.setErrorProvider((IErrorProvider)p.getErrorProvider());
        calcContext.setReportVariables(p.getVariables());
        BgAggregateCalculator calculator = null;
        if ("MbgAggregate".equalsIgnoreCase(filterFunction)) {
            calculator = new BgAggregateCalculator(ctx, (ICalculateContextProvider)calcContext);
        }
        BizCalcTraceResult result = null;
        try {
            result = new BizCalcTraceResult();
            result.setBgVersionNumber(bgVersionNumber);
            result.setOrgUnitId(orgUnitId);
            result.setCalcTrace(true);
            result.setCtx(ctx);
            if (!parameters.isEmpty() && calculator != null) {
                try {
                    ctx.put((Object)"BizCalcTraceResult", (Object)result);
                    calculator.setClearFormula(false);
                    calculator.execute(parameters);
                }
                catch (Exception e) {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
            }
            result = (BizCalcTraceResult)ctx.get((Object)"BizCalcTraceResult");
            result.after();
            if (result != null && result.getBizCalcTraces() != null && !result.getBizCalcTraces().isEmpty()) {
                List<BizCalcTraceInfo> bizCalcTraces = result.getBizCalcTraces();
                BizCalcTraceInfo traceInfo = null;
                BizCalcInfo bizCalc = null;
                HashSet<String> checkSet = new HashSet<String>();
                for (int i = 0; i < bizCalcTraces.size(); ++i) {
                    traceInfo = bizCalcTraces.get(i);
                    if (checkSet.contains(traceInfo.getBizCalcId())) continue;
                    bizCalc = new BizCalcInfo();
                    bizCalc.setId(BOSUuid.read((String)traceInfo.getBizCalcId()));
                    bizCalc.setNumber(traceInfo.getBizCalcNumber());
                    bizCalc.setName(traceInfo.getBizCalcName());
                    bizCalc.setBgScheme(bgFormInfo.getBgScheme());
                    info.getExpressionBizCals().add(bizCalc);
                    checkSet.add(traceInfo.getBizCalcId());
                }
            }
        }
        finally {
            if (result != null) {
                result.after();
                result = null;
            }
            if (ctx.get((Object)"BizCalcTraceResult") != null) {
                ctx.remove((Object)"BizCalcTraceResult");
            }
        }
    }

    protected void queryDetail4Formula(Context ctx, MbgDataDetailInfo info, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, String formula) throws EASBizException, BOSException {
        if (bgFormInfo == null || bgOrgUnitInfo == null || StringUtils.isEmpty((String)formula)) {
            return;
        }
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        String orgUnitId = bgOrgUnitInfo.getOrgUnitID();
        String bgVersionNumber = info.getBgVersionNumber();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        DimensionMemberCheckHelper checkHelper = null;
        this.processFormulaBizCalc(ctx, info, bgFormInfo, bgOrgUnitInfo, formula);
        this.detailDataQuery(ctx, info, bgFormInfo, bgOrgUnitInfo, schemeHelper, formula);
        checkHelper = this.getCheckHelper(ctx, formula, bgVersionNumber, orgUnitId, schemeHelper, bgFormInfo.isDecompose());
        try {
            Set acScenarioNumbers = BgScenarioHelper.getAcScenarioNumbers((Context)ctx);
            if (!checkHelper.canSave(formula, null, bgVersionNumber)) {
                info.setDetail(false);
            }
            if (acScenarioNumbers.contains(BgNFSHelper.parseFormulaPara(formula)[3])) {
                info.setDetail(false);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        info.getMembers().addAll(this.processDataMembers(ctx, info, bgFormInfo, bgOrgUnitInfo, schemeHelper, formula, checkHelper));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFormulaBizCalc(Context ctx, MbgDataDetailInfo info, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, String formula) throws EASBizException, BOSException {
        String bgSchemeId = bgFormInfo.getBgScheme().getId().toString();
        String orgUnitId = bgOrgUnitInfo.getOrgUnitID();
        String bgVersionNumber = info.getBgVersionNumber();
        BizCalcTraceResult result = null;
        IDimensionParameter parameter = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            result = new BizCalcTraceResult();
            result.setFormula(formula);
            result.setBgVersionNumber(bgVersionNumber);
            result.setOrgUnitId(orgUnitId);
            result.setCalcTrace(true);
            result.setCtx(ctx);
            bgFormInfo = this.queryBgForm(ctx, bgFormInfo.getId().toString(), orgUnitId);
            result.setBgProcess(bgFormInfo.getProcessType().getName());
            parameter = this.transParameter(ctx, conn, result, bgSchemeId, orgUnitId, bgVersionNumber, formula, bgFormInfo);
            result.parse(ctx, parameter);
            if (result != null && result.getBizCalcTraces() != null && !result.getBizCalcTraces().isEmpty()) {
                List<BizCalcTraceInfo> bizCalcTraces = result.getBizCalcTraces();
                BizCalcTraceInfo traceInfo = null;
                BizCalcInfo bizCalc = null;
                HashSet<String> checkSet = new HashSet<String>();
                for (int i = 0; i < bizCalcTraces.size(); ++i) {
                    traceInfo = bizCalcTraces.get(i);
                    if (checkSet.contains(traceInfo.getBizCalcId())) continue;
                    bizCalc = new BizCalcInfo();
                    bizCalc.setId(BOSUuid.read((String)traceInfo.getBizCalcId()));
                    bizCalc.setNumber(traceInfo.getBizCalcNumber());
                    bizCalc.setName(traceInfo.getBizCalcName());
                    bizCalc.setBgScheme(bgFormInfo.getBgScheme());
                    info.getFormulaBizCalcs().add(bizCalc);
                    checkSet.add(traceInfo.getBizCalcId());
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
            if (result != null) {
                result.after();
                result = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void detailDataQuery(Context ctx, MbgDataDetailInfo info, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, BgSchemeDimensionHelper schemeHelper, String formula) throws EASBizException, BOSException {
        BgDataStateEnum dataState = BgDataStateEnum.Edited;
        String auditDataOrgId = null;
        String auditDataOrgName = null;
        String reOrgId = null;
        String reOrgName = null;
        boolean isDetailOrgAudit = Boolean.TRUE;
        String refFormNumber = null;
        String auditFormNumber = null;
        String auditFormOrgId = null;
        String auditFormOrgNumber = null;
        String auditFormOrgName = null;
        BgDataSourceEnum bgDataSource = BgDataSourceEnum.common;
        boolean check = false;
        IMbgDetailDataQueryFacade dataQueryFacade = MbgDetailDataQueryFacadeFactory.getLocalInstance(ctx);
        Uuid queryId = dataQueryFacade.openQuery(this.createFilterParam(ctx, info.getBgVersionNumber(), bgFormInfo, bgOrgUnitInfo, schemeHelper, formula));
        IRowSet rowSet = null;
        try {
            rowSet = dataQueryFacade.executeQuery(queryId, 0, 1);
            if (rowSet != null && rowSet.next()) {
                check = true;
                dataState = BgDataStateEnum.getEnum(rowSet.getInt("FSTATE"));
                auditDataOrgId = rowSet.getString("FAUDORGUNITID");
                auditDataOrgName = rowSet.getString("FAUDORGNAME");
                reOrgId = rowSet.getString("FREPORTORGUNITID");
                reOrgName = rowSet.getString("FREPORTORGNAME");
                isDetailOrgAudit = rowSet.getBoolean("FDETAIL");
                refFormNumber = rowSet.getString("FREFFORMNUMBER");
                auditFormOrgId = rowSet.getString("FAUDFORMID");
                auditFormOrgNumber = rowSet.getString("FAUDFORMNUMBER");
                auditFormOrgName = rowSet.getString("FAUDFORMORGNAME");
                auditFormNumber = rowSet.getString("FAUDFORMNUMBER");
                bgDataSource = BgDataSourceEnum.getEnum(rowSet.getInt("FDATASOURCE"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)" ", (Throwable)e);
        }
        finally {
            if (rowSet != null) {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
        }
        if (!check) {
            return;
        }
        info.setDataState(dataState);
        if (!StringUtils.isEmpty(auditDataOrgId)) {
            OrgUnitInfo auditDataOrg = new OrgUnitInfo();
            auditDataOrg.setId(BOSUuid.read((String)auditDataOrgId));
            auditDataOrg.setName(auditDataOrgName);
            info.setAuditDataOrg(auditDataOrg);
        }
        if (!StringUtils.isEmpty(reOrgId)) {
            OrgUnitInfo reportOrg = new OrgUnitInfo();
            reportOrg.setId(BOSUuid.read(reOrgId));
            reportOrg.setName(reOrgName);
            info.setReportOrg(reportOrg);
        }
        info.setDetailOrgAudit(isDetailOrgAudit);
        if (!StringUtils.isEmpty(refFormNumber)) {
            info.setRefFormNumber(refFormNumber);
        }
        if (!StringUtils.isEmpty(auditFormOrgId)) {
            OrgUnitInfo auditFormOrg = new OrgUnitInfo();
            auditFormOrg.setId(BOSUuid.read(auditFormOrgId));
            auditFormOrg.setNumber(auditFormOrgNumber);
            auditFormOrg.setName(auditFormOrgName);
            info.setAuditFormOrg(auditFormOrg);
        }
        if (!StringUtils.isEmpty(auditFormNumber)) {
            info.setAuditFormNumber(auditFormNumber);
        }
        info.setBgDataSource(bgDataSource);
    }

    protected DimensionMemberCheckHelper getCheckHelper(Context ctx, String formula, String bgVersionNumber, String orgUnitId, BgSchemeDimensionHelper schemeHelper, boolean isDecompose) throws EASBizException, BOSException {
        ArrayList<String> formulas = new ArrayList<String>();
        formulas.add(formula);
        HashSet<String> versionNumber = new HashSet<String>();
        versionNumber.add(bgVersionNumber);
        MbgViewManagerImpl view = DimensionFormulaHelper.buildViewMamager(ctx, formulas, versionNumber);
        DimensionMemberCheckHelper checkHelper = DimensionMemberCheckHelper.getLocalIntance(ctx, new DimensionCacheHelper(ctx), orgUnitId.toString(), null, schemeHelper, view, isDecompose);
        return checkHelper;
    }

    protected List<MbgDataDetailMember> processDataMembers(Context ctx, MbgDataDetailInfo info, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, BgSchemeDimensionHelper schemeHelper, String formula, DimensionMemberCheckHelper checkHelper) throws EASBizException, BOSException {
        ArrayList<MbgDataDetailMember> detailMembers = new ArrayList<MbgDataDetailMember>();
        Locale locale = ctx.getLocale();
        String detail = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"detailMember", (Locale)ctx.getLocale());
        String unDetail = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"unDetailMember", (Locale)ctx.getLocale());
        String bgSchemeId = schemeHelper.getBgSchemeId();
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String bgVersionNumber = info.getBgVersionNumber();
        Map<String, String> srcFieldMap = this.getSrcFieldMap(ctx, schemeHelper);
        HashMap<String, Set<String>> allDimNumbers = new HashMap<String, Set<String>>();
        Map<String, String> fieldNumbers = BizCalcTraceUtils.getMemberNumByFormula(srcFieldMap, formula, bgVersionNumber, true);
        Object var18_18 = null;
        for (String string : fieldNumbers.keySet()) {
            if (!allDimNumbers.containsKey(string)) {
                allDimNumbers.put(string, new HashSet());
            }
            ((Set)allDimNumbers.get(string)).add(fieldNumbers.get(string));
        }
        HashMap allMembersMap = new HashMap();
        Map<Object, Object> membersMap = new HashMap();
        if (bgFormInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.FIXEDFORM) || bgFormInfo.getBgTemplate().getFormType().equals((Object)BgTemFormTypeEnum.SPECIALFORM)) {
            membersMap = BizCalcTraceUtils.queryMembersName(ctx, allDimNumbers, orgUnitId, bgSchemeId);
            allMembersMap.putAll(membersMap);
            Set parentOrgIds = BgOrgUnitFactory.getLocalInstance(ctx).getParentOrgIds(bgSchemeId, orgUnitId, false);
            if (parentOrgIds != null && !parentOrgIds.isEmpty()) {
                String parentOrgId22 = "";
                for (String parentOrgId22 : parentOrgIds) {
                    if (parentOrgId22.equals(orgUnitId)) continue;
                    Map<String, Map<String, BgDimensionMember>> tmpMembersMap = BizCalcTraceUtils.queryMembersName(ctx, allDimNumbers, parentOrgId22, bgSchemeId);
                    Iterator<Object> itr = allMembersMap.keySet().iterator();
                    while (itr.hasNext()) {
                        String string = (String)itr.next();
                        if (!((Map)allMembersMap.get(string)).isEmpty() || tmpMembersMap.get(string) == null || tmpMembersMap.get(string).isEmpty()) continue;
                        itr.remove();
                    }
                    for (String string : membersMap.keySet()) {
                        if (!((Map)membersMap.get(string)).isEmpty() || tmpMembersMap.get(string) == null || tmpMembersMap.get(string).isEmpty() || allMembersMap.containsKey(string)) continue;
                        allMembersMap.put(string, tmpMembersMap.get(string));
                    }
                }
            }
        } else {
            membersMap = BizCalcTraceUtils.queryMembersName(ctx, allDimNumbers, orgUnitId, bgSchemeId);
        }
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        HashMap queryMap = new HashMap();
        String[] itemNumbers = formulaParam[0].split(",");
        for (int i = 0; i < itemNumbers.length; ++i) {
            if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
            String srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
            String number = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]);
            if (!queryMap.containsKey(srcNumber)) {
                queryMap.put(srcNumber, new HashSet());
            }
            ((Set)queryMap.get(srcNumber)).add(number);
        }
        queryMap.put(DimensionConstants.DEF_PERIOD_SRCNUMBER, new HashSet());
        ((Set)queryMap.get(DimensionConstants.DEF_PERIOD_SRCNUMBER)).add(formulaParam[1]);
        queryMap.put(DimensionConstants.DEF_ELEMENT_SRCNUMBER, new HashSet());
        ((Set)queryMap.get(DimensionConstants.DEF_ELEMENT_SRCNUMBER)).add(formulaParam[2]);
        queryMap.put(DimensionConstants.DEF_SCENARIO_SRCNUMBER, new HashSet());
        ((Set)queryMap.get(DimensionConstants.DEF_SCENARIO_SRCNUMBER)).add(formulaParam[3]);
        queryMap.put(DimensionConstants.DEF_CURRENCY_SRCNUMBER, new HashSet());
        ((Set)queryMap.get(DimensionConstants.DEF_CURRENCY_SRCNUMBER)).add(formulaParam[5]);
        queryMap.put(DimensionConstants.DEF_VERSION_SRCNUMBER, new HashSet());
        ((Set)queryMap.get(DimensionConstants.DEF_VERSION_SRCNUMBER)).add(bgVersionNumber);
        Map leafMembers = DimensionFormulaFacadeFactory.getLocalInstance(ctx).getLeafMember(orgUnitId, bgSchemeId, queryMap);
        if (membersMap != null && !membersMap.isEmpty()) {
            Map tmpMap = null;
            String memberNumber22 = null;
            boolean isLeafMember = Boolean.TRUE;
            if (DimensionCommonHelper.isDecompose(bgFormInfo.getProcessType())) {
                detailMembers.add(this.createDetailMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.getDefOrgUnitName(locale), bgOrgUnitInfo.getNumber(), bgOrgUnitInfo.getName(), !bgOrgUnitInfo.isIsLeaf() ? detail : unDetail));
            } else {
                detailMembers.add(this.createDetailMember(DimensionConstants.DEF_ORGUNIT_NUMBER, DimensionConstants.getDefOrgUnitName(locale), bgOrgUnitInfo.getNumber(), bgOrgUnitInfo.getName(), bgOrgUnitInfo.isIsLeaf() ? detail : unDetail));
            }
            detailMembers.add(this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.getDefAccountName(locale), DimensionConstants.DEF_BGINDEX_FIELD, DimensionConstants.DEF_INDEX_SRCNUMBER));
            detailMembers.add(this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_PERIOD_NUMBER, DimensionConstants.getDefPeriodName(locale), DimensionConstants.DEF_PERIOD_FIELD, DimensionConstants.DEF_PERIOD_SRCNUMBER));
            detailMembers.add(this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_SCENARIO_NUMBER, DimensionConstants.getDefScenarioName(locale), DimensionConstants.DEF_SCENARIO_FIELD, DimensionConstants.DEF_SCENARIO_SRCNUMBER));
            detailMembers.add(this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_ELEMENT_NUMBER, DimensionConstants.getDefElementName(locale), DimensionConstants.DEF_ELEMENT_FIELD, DimensionConstants.DEF_ELEMENT_SRCNUMBER));
            MbgDataDetailMember versionMember = this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_VERSION_NUMBER, DimensionConstants.getDefVersionName(locale), DimensionConstants.DEF_VERSION_FIELD, DimensionConstants.DEF_VERSION_SRCNUMBER);
            if (bgVersionNumber.equals(bgFormInfo.getBgVersion().getNumber())) {
                versionMember.setDescription(BgNFSHelper.getHardCodeRes(ctx, "editVersion"));
            } else {
                versionMember.setDescription(BgNFSHelper.getHardCodeRes(ctx, "notEditVersion"));
            }
            detailMembers.add(versionMember);
            detailMembers.add(this.getDetailMember(ctx, leafMembers, membersMap, checkHelper, DimensionConstants.DEF_CURRENCY_NUMBER, DimensionConstants.getDefCurrencyName(locale), DimensionConstants.DEF_CURRENCY_FIELD, DimensionConstants.DEF_CURRENCY_SRCNUMBER));
            Map<String, BgDimensionInfo> allDimensions = schemeHelper.getDimensionByRefField();
            for (int i = 0; i < itemNumbers.length; ++i) {
                isLeafMember = Boolean.TRUE;
                if (StringUtils.isEmpty((String)itemNumbers[i])) continue;
                String srcNumber = DimensionFormulaHelper.getSrcNumber(itemNumbers[i]);
                memberNumber22 = DimensionFormulaHelper.getMemberNumber(itemNumbers[i]);
                String string = srcFieldMap.get(srcNumber);
                if (DimensionConstants.DEF_INDEX_SRCNUMBER.equals(srcNumber)) continue;
                if (leafMembers.containsKey(srcNumber) && (((Set)leafMembers.get(srcNumber)).isEmpty() || !((Set)leafMembers.get(srcNumber)).contains(memberNumber22))) {
                    isLeafMember = false;
                }
                if (!membersMap.containsKey(string)) continue;
                tmpMap = (Map)membersMap.get(string);
                if (!tmpMap.isEmpty()) {
                    for (String memberNumber22 : tmpMap.keySet()) {
                        detailMembers.add(this.createDetailMember(allDimensions.get(string).getNumber(), allDimensions.get(string).getName(), (BgDimensionMember)tmpMap.get(memberNumber22), isLeafMember ? detail : unDetail));
                    }
                    continue;
                }
                if (!allMembersMap.containsKey(string)) continue;
                Map mpMap = (Map)allMembersMap.get(string);
                for (String memberNumber22 : mpMap.keySet()) {
                    detailMembers.add(this.createDetailMember(allDimensions.get(string).getNumber(), allDimensions.get(string).getName(), (BgDimensionMember)mpMap.get(memberNumber22), BgNFSHelper.getHardCodeRes(ctx, "memberNotExist")));
                }
            }
            detailMembers.add(this.createDetailMember(DimensionConstants.DEF_PROCESSTYPE_NUMBER, BgNFSHelper.getHardCodeRes(ctx, "process"), bgFormInfo.getProcessType().getName(), bgFormInfo.getProcessType().getAlias(), null));
        }
        return detailMembers;
    }

    protected MbgDataDetailMember getDetailMember(Context ctx, Map<String, Set<String>> leafMembers, Map<String, Map<String, BgDimensionMember>> membersMap, DimensionMemberCheckHelper checkHelper, String dimNumber, String dimName, String field, String srcNumber) {
        Iterator<Object> ite;
        Map<Object, Object> tmpMap = new HashMap();
        String memberNumber = "";
        boolean isLeafMember = true;
        if (membersMap.containsKey(field) && (ite = (tmpMap = membersMap.get(field)).keySet().iterator()).hasNext()) {
            memberNumber = (String)ite.next();
            if (!leafMembers.containsKey(srcNumber) || !leafMembers.get(srcNumber).contains(memberNumber)) {
                isLeafMember = false;
            }
        }
        String detail = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"detailMember", (Locale)ctx.getLocale());
        String unDetail = EASResource.getString((String)"com.kingdee.eas.ma.mbg.BgFormMsgResource", (String)"unDetailMember", (Locale)ctx.getLocale());
        return this.createDetailMember(dimNumber, dimName, (BgDimensionMember)tmpMap.get(memberNumber), isLeafMember ? detail : unDetail);
    }

    protected MbgDataDetailMember createDetailMember(String dimNumber, String dimName, BgDimensionMember bgDimensionMember, String description) {
        return this.createDetailMember(dimNumber, dimName, bgDimensionMember.getNumber(), bgDimensionMember.getName(), description);
    }

    protected MbgDataDetailMember createDetailMember(String dimNumber, String dimName, String memberNumber, String memberName, String description) {
        MbgDataDetailMember detailMember = new MbgDataDetailMember();
        detailMember.setDimNumber(dimNumber);
        detailMember.setDimName(dimName);
        detailMember.setMemberNumber(memberNumber);
        detailMember.setMemberName(memberName);
        detailMember.setDescription(description);
        return detailMember;
    }

    protected FilterParam createFilterParam(Context ctx, String bgVersionNumber, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, BgSchemeDimensionHelper schemeHelper, String formula) throws BOSException {
        MbgDataQueryFilterParam filterParam = new MbgDataQueryFilterParam();
        String bgSchemeId = schemeHelper.getBgSchemeId();
        String orgUnitId = bgOrgUnitInfo.getOrgUnitID();
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        String periodNumber = formulaParam[1];
        String elementNumber = formulaParam[2];
        String scenarioNumber = formulaParam[3];
        String currencyNumber = formulaParam[5];
        ArrayList<String> bgVersionIds = new ArrayList<String>();
        ArrayList<String> periodsIds = new ArrayList<String>();
        ArrayList<String> elementIds = new ArrayList<String>();
        ArrayList<String> scenarioIds = new ArrayList<String>();
        ArrayList<String> currencyIds = new ArrayList<String>();
        CoreBaseCollection colls = BgPeriodFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + periodNumber + "'");
        if (colls != null && !colls.isEmpty()) {
            periodsIds.add(colls.get(0).getId().toString());
        }
        if ((colls = BgElementFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + elementNumber + "'")) != null && !colls.isEmpty()) {
            elementIds.add(colls.get(0).getId().toString());
        }
        if ((colls = BgScenarioFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + scenarioNumber + "'")) != null && !colls.isEmpty()) {
            scenarioIds.add(colls.get(0).getId().toString());
        }
        if ((colls = CurrencyFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + currencyNumber + "'")) != null && !colls.isEmpty()) {
            currencyIds.add(colls.get(0).getId().toString());
        }
        if ((colls = BgVersionFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + bgVersionNumber + "'")) != null && !colls.isEmpty()) {
            bgVersionIds.add(colls.get(0).getId().toString());
        }
        filterParam.setQueryType(MbgDataQueryTypeEnum.BgForm);
        filterParam.setProcessType(bgFormInfo.getProcessType());
        filterParam.setCostCenter((OrgUnitInfo)DimensionCommonHelper.createNewObject(CostCenterOrgUnitInfo.class, orgUnitId));
        filterParam.setBgScheme(DimensionCommonHelper.createNewObject(BgSchemeInfo.class, bgSchemeId));
        filterParam.setBgOrgUnit((CoreBaseInfo)DimensionCommonHelper.createNewObject(BgOrgUnitInfo.class, bgOrgUnitInfo.getId().toString()));
        filterParam.setBgForm((CoreBaseInfo)DimensionCommonHelper.createNewObject(BgFormInfo.class, bgFormInfo.getId().toString()));
        filterParam.getMembers().addAll(this.getAnalyseMembers(schemeHelper, formula));
        filterParam.setBgPeriods((BgPeriodInfo[])DimensionCommonHelper.createNewObjectArray(BgPeriodInfo.class, periodsIds));
        filterParam.setBgVersions((BgVersionInfo[])DimensionCommonHelper.createNewObjectArray(BgVersionInfo.class, bgVersionIds));
        filterParam.setBgElements((BgElementInfo[])DimensionCommonHelper.createNewObjectArray(BgElementInfo.class, elementIds));
        filterParam.setBgScenarios((BgScenarioInfo[])DimensionCommonHelper.createNewObjectArray(BgScenarioInfo.class, scenarioIds));
        filterParam.setCurrencies((CurrencyInfo[])DimensionCommonHelper.createNewObjectArray(CurrencyInfo.class, currencyIds));
        return filterParam;
    }

    protected List<AnalyseMember> getAnalyseMembers(BgSchemeDimensionHelper schemeHelper, String formula) {
        ArrayList<AnalyseMember> analyseMembers = new ArrayList<AnalyseMember>();
        String[] formulaParam = BgNFSHelper.parseFormulaPara(formula);
        String combin = formulaParam[0];
        BgDimensionMember[] otherMembers = null;
        String[] otherCombins = null;
        String indexNumber = null;
        String otherNumber = null;
        String srcNumber = null;
        String number = null;
        String type = null;
        String refField = null;
        AnalyseMember member = new AnalyseMember();
        if (combin.indexOf(",") > 0) {
            indexNumber = combin.substring(0, combin.indexOf(","));
            otherNumber = combin.substring(combin.indexOf(",") + 1);
        } else {
            indexNumber = combin;
            otherNumber = null;
        }
        BgDimensionMember bgIndex = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, DimensionFormulaHelper.getMemberNumber(indexNumber), DimensionFormulaHelper.getMemberNumber(indexNumber));
        bgIndex.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
        member.setBgIndex(bgIndex);
        if (otherNumber != null) {
            otherCombins = DimensionFormulaHelper.splitCombinations(otherNumber);
            otherMembers = new BgDimensionMember[otherCombins.length];
            for (int i = 0; i < otherCombins.length; ++i) {
                srcNumber = DimensionFormulaHelper.getSrcNumber(otherCombins[i]);
                number = DimensionFormulaHelper.getMemberNumber(otherCombins[i]);
                type = schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber();
                refField = schemeHelper.getDimensionBySrcNumber().get(srcNumber).getRefField();
                otherMembers[i] = new BgDimensionMember(type, refField, number, number);
                otherMembers[i].setSrcNumber(srcNumber);
            }
            member.setDimMember(ViewlistCombinHelper.getCombinMemberByDimMember(otherMembers));
        }
        analyseMembers.add(member);
        return analyseMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object _queryMbgDatas(Context ctx, List bgFormulas, IObjectValue model, int type) throws BOSException, EASBizException {
        if (model == null) {
            return null;
        }
        ArrayList result = new ArrayList();
        HashMap<String, Object> row = null;
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        BgSchemeInfo bgSchemeInfo = bgFormInfo.getBgScheme();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeInfo.getId().toString());
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        FullOrgUnitInfo orgUnitInfo = bgFormInfo.getOrgUnit();
        String bgVersionNumber = bgFormInfo.getBizVersion().getNumber();
        BgOrgUnitInfo bgOrgUnitInfo = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("where viewID = '" + bgOrgViewId + "' and orgUnitID = '" + orgUnitInfo.getId().toString() + "' and isVirtual = 0");
        switch (type) {
            case 1: {
                bgFormulas = this.getCurrentBgFormRefFormulas(ctx, bgFormInfo);
                break;
            }
            case 2: {
                bgFormulas = this.getCurrentBgFormAuditRangeFormulas(ctx, bgFormInfo);
                break;
            }
        }
        if (bgFormulas.isEmpty()) {
            return result;
        }
        IMbgDetailDataQueryFacade dataQueryFacade = MbgDetailDataQueryFacadeFactory.getLocalInstance(ctx);
        Uuid queryId = dataQueryFacade.openQuery(this.createFilterParam(ctx, bgVersionNumber, bgFormInfo, bgOrgUnitInfo, schemeHelper, bgFormulas, type));
        IRowSet rowSet = null;
        try {
            rowSet = dataQueryFacade.executeQuery(queryId, 0, 10000);
            if (rowSet != null) {
                while (rowSet.next()) {
                    if (!bgFormulas.contains(rowSet.getObject("FFormula"))) continue;
                    row = new HashMap<String, Object>();
                    row.put("FBgDataId", rowSet.getObject("FBgDataId"));
                    row.put("FOrgUnitID", rowSet.getObject("FOrgUnitID"));
                    row.put("FFormula", rowSet.getObject("FFormula"));
                    row.put("FBgIndexName", rowSet.getObject("FBgIndexName"));
                    row.put("FRefMemberName", rowSet.getObject("FRefMemberName"));
                    row.put("FBgPeriodName", rowSet.getObject("FBgPeriodName"));
                    row.put("FScenarioName", rowSet.getObject("FScenarioName"));
                    row.put("FBgElementName", rowSet.getObject("FBgElementName"));
                    row.put("FCurrencyName", rowSet.getObject("FCurrencyName"));
                    row.put("FVersionName", rowSet.getObject("FVersionName"));
                    row.put("FValue", rowSet.getObject("FValue"));
                    row.put("FTmpValue", rowSet.getObject("FTmpValue"));
                    row.put("FState", rowSet.getObject("FState"));
                    row.put("FIsAdjust", rowSet.getObject("FIsAdjust"));
                    row.put("FAudOrgUnitID", rowSet.getObject("FAudOrgUnitID"));
                    row.put("FAudOrgNumber", rowSet.getObject("FAudOrgNumber"));
                    row.put("FAudOrgName", rowSet.getObject("FAudOrgName"));
                    row.put("FReportOrgUnitID", rowSet.getObject("FReportOrgUnitID"));
                    row.put("FReportOrgNumber", rowSet.getObject("FReportOrgNumber"));
                    row.put("FReportOrgName", rowSet.getObject("FReportOrgName"));
                    row.put("FDetail", rowSet.getObject("FDetail"));
                    row.put("FRefFormNumber", rowSet.getObject("FRefFormNumber"));
                    row.put("FVersion", rowSet.getObject("FVersion"));
                    row.put("FAudFormOrgName", rowSet.getObject("FAudFormOrgName"));
                    row.put("FAudFormNumber", rowSet.getObject("FAudFormNumber"));
                    row.put("FDataSource", rowSet.getObject("FDataSource"));
                    result.add(row);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)" ", (Throwable)e);
        }
        finally {
            if (rowSet != null) {
                SQLUtils.cleanup((ResultSet)rowSet);
            }
        }
        return result;
    }

    protected List<String> getCurrentBgFormRefFormulas(Context ctx, BgFormInfo bgFormInfo) throws BOSException {
        ArrayList<String> bgformulas = new ArrayList<String>();
        if (ctx == null || bgFormInfo == null || bgFormInfo.getBgScheme() == null || bgFormInfo.getOrgUnit() == null) {
            return bgformulas;
        }
        BgSchemeInfo bgSchemeInfo = bgFormInfo.getBgScheme();
        String cubeName = "";
        String cubeEntry = "";
        if (DimensionCommonHelper.isDecompose(bgFormInfo.getProcessType())) {
            cubeName = BgCubeUtils.getCubeName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
            cubeEntry = BgCubeUtils.getCubeEntryName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
        } else {
            cubeName = bgSchemeInfo.getRefCube();
            cubeEntry = BgCubeUtils.getBudgetEntryCubeName(bgSchemeInfo.getRefCube());
        }
        Connection conn = null;
        IRowSet rst = null;
        StringBuffer sql = new StringBuffer();
        Object[] sqlParams = null;
        try {
            conn = this.getConnection(ctx);
            sql.append("select FID, FFormula from " + cubeName + " where FOrgUnitId = ? and exists (select FDataId from " + cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)");
            sqlParams = new Object[]{bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getId().toString()};
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgformulas.add(rst.getString("FFormula"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return bgformulas;
    }

    protected List<String> getCurrentBgFormAuditRangeFormulas(Context ctx, BgFormInfo bgFormInfo) throws EASBizException, BOSException {
        List<String> bgformulas = new ArrayList<String>();
        if (bgFormInfo == null || bgFormInfo.getBgScheme() == null) {
            return bgformulas;
        }
        Object bgOrgUnit = null;
        BgOrgUnitInfo curBgOrgUnit = null;
        Object cOrgUnitIds = null;
        List<String> pOrgUnitIds = null;
        List<String> orgUnitIds = null;
        HashMap curIdToOrgUnitId = new HashMap();
        HashMap curOrgUnitIdToParentId = new HashMap();
        ArrayList curOrgTreeOrgUnitIds = new ArrayList();
        BgSchemeInfo schemeInfo = bgFormInfo.getBgScheme();
        AuditParam param = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            param = new AuditParam(ctx);
            param.bgScheme = schemeInfo = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), BOSUuid.read((String)schemeInfo.getId().toString()));
            BgClosureMapUtils bgClosureMapUtils = new BgClosureMapUtils(param.bgScheme, conn);
            Map<String, Set<String>> closureMap = bgClosureMapUtils.getClosureMap();
            IMbgViewBase view = bgFormInfo.getView(ctx, schemeInfo);
            param.auditType = 0;
            param.audSchemeId = schemeInfo.getId().toString();
            param.audOrgUnitId = bgFormInfo.getOrgUnit().getId().toString();
            param.audUserId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
            param.audState = 9;
            param.audFormState = 2;
            param.currtBillId = bgFormInfo.getId().toString();
            MbgDimCollection colls = DimUtils.getDimensionColls(conn, ctx.getLocale());
            if (colls != null) {
                MbgDimInfo mbgDim = null;
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    mbgDim = colls.get(i);
                    param.mbgDims.put(mbgDim.getNumber(), mbgDim);
                    param.srcDims.put(mbgDim.getSrcNumber(), mbgDim);
                }
            }
            param.bgOrgViewId = param.bgScheme.getEditOrgViewId();
            param.auditMbgDims = param.bgScheme.getAuditMbgDim(param.unionId != null);
            param.initTmpTable();
            param.cubeName = param.bgScheme.getRefCube();
            param.cubeEntry = BgCubeUtils.getBudgetEntryCubeName(param.bgScheme.getRefCube());
            this.queryAudOrgUnit(ctx, conn, param);
            curBgOrgUnit = MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, bgFormInfo.getBizOrgUnit().getId(), false);
            orgUnitIds = this.getAudOrgUnitIds(ctx, conn, curBgOrgUnit, param);
            if (param.tmpAudOrgUnit == null) {
                param.tmpAudOrgUnit = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpAudOrgUnit, (String)"FID", (boolean)false, (boolean)false);
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + param.tmpAudOrgUnit));
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpAudOrgUnit + " (FID) values (?)"), orgUnitIds);
            boolean re = this.updateMemberTable(conn, bgFormInfo, view, param, closureMap);
            if (re) {
                bgformulas = this.queryViewDataFormulas(conn, bgFormInfo, curBgOrgUnit, orgUnitIds, pOrgUnitIds, param);
            }
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            param.release();
            SQLUtils.cleanup((Connection)conn);
        }
        return bgformulas;
    }

    protected List<String> queryViewDataFormulas(Connection conn, IDimDataQuery model, BgOrgUnitInfo bgOrgUnit, List<String> orgUnitIds, List<String> pOrgUnitIds, AuditParam param) throws Exception {
        ArrayList<String> bgformulas = new ArrayList<String>();
        if (conn == null || model == null || bgOrgUnit == null || orgUnitIds == null || param == null) {
            return bgformulas;
        }
        Object[] sqlParams = null;
        IRowSet rst = null;
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select FID, FFormula from " + param.cubeName + " where FOrgUnitId = ?  and exists (select FNumber from " + param.tmpBgIndex + " where FNumber = " + param.cubeName + ".F2) ");
            if (!param.tmpExtMap.isEmpty()) {
                String mbgDimNum = null;
                String tmpTable = null;
                String field = null;
                Map.Entry<String, String> entry2 = null;
                for (Map.Entry<String, String> entry2 : param.tmpExtMap.entrySet()) {
                    if (param.unionId == null && DimensionConstants.DEF_CSL_NUMBER.equals(entry2.getKey())) continue;
                    mbgDimNum = entry2.getKey();
                    tmpTable = entry2.getValue();
                    field = param.mbgDims.get(mbgDimNum).getRefField();
                    sql.append(" and exists (select FID from " + tmpTable + " where FNumber = " + param.cubeName + "." + field + ") ");
                }
            }
            sql.append(" and exists (select FID from " + param.tmpBgPeriod + " where FID = " + param.cubeName + ".FBgPeriodID)  and exists (select FID from " + param.tmpBgElement + " where FID = " + param.cubeName + ".FBgElementID)  and exists (select FID from " + param.tmpCurrency + " where FID = " + param.cubeName + ".FCurrencyID)  and exists (select FID from " + param.tmpScenario + " where FID = " + param.cubeName + ".FScenario)  and FVersion = ? ");
            sqlParams = new Object[]{bgOrgUnit.getOrgUnitID(), model.getBizVersion().getVersionId()};
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])sqlParams);
            while (rst.next()) {
                bgformulas.add(rst.getString("FFormula"));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"audit sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return bgformulas;
    }

    protected void queryAudOrgUnit(Context ctx, Connection conn, AuditParam param) throws Exception {
        if (param.audOrgUnitId == null) {
            return;
        }
        String bosType = BOSUuid.read((String)param.audOrgUnitId).getType().toString();
        param.audOrgUnit = "33F82845".equals(bosType) ? MbgDataHelper.getBgOrgUnitInfoById(conn, ctx.getLocale(), BOSUuid.read((String)param.audOrgUnitId)) : MbgDataHelper.getBgOrgUnitInfo(conn, ctx.getLocale(), param.bgOrgViewId, BOSUuid.read((String)param.audOrgUnitId), false);
        if (param.audOrgUnit != null) {
            param.bgOrgUnitMap.put(param.audOrgUnit.getNumber(), param.audOrgUnit);
        }
    }

    protected List<String> getAudOrgUnitIds(Context ctx, Connection conn, BgOrgUnitInfo bgOrgUnit, AuditParam param) throws Exception {
        int i;
        ArrayList<String> orgUnitIds = new ArrayList<String>();
        if (ctx == null || conn == null || bgOrgUnit == null || param == null || param.audOrgUnit == null) {
            return orgUnitIds;
        }
        HashSet<String> numbers = new HashSet<String>();
        String[] _numbers = bgOrgUnit.getLongNumber().split("!");
        int in = _numbers.length;
        for (i = 0; i < in; ++i) {
            numbers.add(_numbers[i]);
        }
        _numbers = param.audOrgUnit.getLongNumber().split("!");
        in = _numbers.length;
        for (i = 0; i < in; ++i) {
            numbers.remove(_numbers[i]);
        }
        numbers.add(param.audOrgUnit.getNumber());
        for (String number : numbers) {
            if (!param.bgOrgUnitMap.containsKey(number)) {
                param.bgOrgUnitMap.put(number, MbgDataHelper.getBgOrgUnitInfoByNumber(conn, ctx.getLocale(), BOSUuid.read((String)bgOrgUnit.getViewID()), number));
            }
            orgUnitIds.add(param.bgOrgUnitMap.get(number).getOrgUnitID());
        }
        return orgUnitIds;
    }

    protected boolean updateMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param, Map<String, Set<String>> closureMap) throws Exception {
        if (conn == null || model == null || view == null || param == null) {
            return false;
        }
        Map<String, Set<String>> mbgMemberMap = MbgDataHelper.parseMbgMember(view);
        if (mbgMemberMap.isEmpty()) {
            return false;
        }
        ArrayList<Object> tmpList = new ArrayList<Object>();
        try {
            if (param.tmpBgIndex == null) {
                param.tmpBgIndex = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpBgIndex, (String)"FNumber", (boolean)false, (boolean)false);
            }
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + param.tmpBgIndex + " (FNumber) values (?)"), (Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD));
            this.querySubMember(conn, param, DimensionBaseConstants.DEF_INDEX_NUMBER, mbgMemberMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD), param.tmpBgIndex);
            if (param.tmpBgPeriod == null) {
                param.tmpBgPeriod = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpBgPeriod, (String)"FID", (boolean)false, (boolean)false);
            }
            tmpList.clear();
            if (closureMap != null) {
                Set<String> periodNumberSet = mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD);
                for (String periodNumber : periodNumberSet) {
                    if (closureMap.get(periodNumber) == null) continue;
                    tmpList.addAll((Collection)closureMap.get(periodNumber));
                }
            } else {
                tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_PERIOD_FIELD));
            }
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.tmpBgPeriod + " (FID) select FID from T_MBG_BgPeriod where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (param.tmpBgElement == null) {
                param.tmpBgElement = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpBgElement, (String)"FID", (boolean)false, (boolean)false);
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_ELEMENT_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.tmpBgElement + " (FID) select FID from T_MBG_BgElement where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (param.tmpCurrency == null) {
                param.tmpCurrency = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpCurrency, (String)"FID", (boolean)false, (boolean)false);
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_CURRENCY_FIELD));
            BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.tmpCurrency + " (FID) select FID from T_BD_Currency where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ")"), tmpList);
            if (param.tmpScenario == null) {
                param.tmpScenario = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FID INT DEFAULT 0)");
                BgDBUtils.createIndex((TempTablePool)param.pool, (String)param.tmpScenario, (String)"FID", (boolean)false, (boolean)false);
            }
            tmpList.clear();
            tmpList.addAll((Collection)mbgMemberMap.get(DimensionBaseConstants.DEF_SCENARIO_FIELD));
            this.insertParamForScen(conn, param, tmpList);
            this.updateExtMemberTable(conn, model, view, param, mbgMemberMap);
        }
        catch (SQLException ex) {
            logger.error((Object)"audit sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        return true;
    }

    protected void updateExtMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param, Map<String, Set<String>> mbgMemberMap) throws Exception {
        this.innerUpdateExtMemberTable(conn, model, view, param, mbgMemberMap);
    }

    protected void innerUpdateExtMemberTable(Connection conn, IDimDataQuery model, IMbgViewBase view, AuditParam param, Map<String, Set<String>> mbgMemberMap) throws Exception {
        if (conn == null || model == null || view == null || param == null || mbgMemberMap == null) {
            return;
        }
        if (8 == model.getBizTemplateType()) {
            Object tmpNums;
            Object dimNumber2 = null;
            String srcNumber = null;
            String spItemNumber = model.getSpecialItemNumber();
            if (!StringUtils.isEmpty((String)spItemNumber) && (tmpNums = spItemNumber.split(",")) != null) {
                for (Object dimNumber2 : tmpNums) {
                    srcNumber = DimUtils.getSrcNumber((String)dimNumber2);
                    if (!param.srcDims.containsKey(srcNumber)) continue;
                    param.auditMbgDims.add(param.srcDims.get(srcNumber).getNumber());
                }
            }
        }
        if (param.auditMbgDims != null && param.auditMbgDims.size() > 1) {
            String tmpTable = null;
            String field = null;
            Set<String> memberSet = null;
            try {
                for (String mbgDimNumber : param.auditMbgDims) {
                    if (DimensionBaseConstants.DEF_INDEX_NUMBER.equals(mbgDimNumber) || param.unionId == null && DimensionBaseConstants.DEF_CSL_NUMBER.equals(mbgDimNumber)) continue;
                    if (param.tmpExtMap.containsKey(mbgDimNumber)) {
                        tmpTable = param.tmpExtMap.get(mbgDimNumber);
                    } else {
                        tmpTable = BgDBUtils.createTmpTable((TempTablePool)param.pool, (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84))");
                        BgDBUtils.createIndex((TempTablePool)param.pool, (String)tmpTable, (String)"FNumber", (boolean)false, (boolean)false);
                        param.tmpExtMap.put(mbgDimNumber, tmpTable);
                    }
                    field = param.mbgDims.get(mbgDimNumber).getRefField();
                    memberSet = mbgMemberMap.get(field);
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), memberSet);
                    this.querySubMember(conn, param, mbgDimNumber, memberSet, tmpTable);
                }
            }
            catch (SQLException ex) {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
        }
    }

    protected void insertParamForScen(Connection conn, AuditParam param, List<Object> tmpList) throws SQLException {
        BgDBUtils.executeBatchUpdate((Connection)conn, (String)("Insert Into " + param.tmpScenario + " (FID) select FScenarioId from T_MBG_BgScenario where FNumber IN (" + BgDBUtils.getSqlParam((int)50) + ") and FType = " + BgScenarioHelper.BUDGET_SCENARIO_VALUE), tmpList);
    }

    protected void querySubMember(Connection conn, AuditParam param, String mbgDimNumber, Set<String> dimNumbers, String tmpTable) throws EASBizException {
        if (conn == null || param == null || mbgDimNumber == null || dimNumbers == null || dimNumbers.isEmpty() || tmpTable == null) {
            return;
        }
        IRowSet rst = null;
        BOSUuid viewId = param.bgScheme.getViewId(mbgDimNumber);
        if (viewId == null) {
            return;
        }
        ArrayList<String> sqlParams = new ArrayList<String>();
        List rsts = null;
        Object[] objs = null;
        HashSet<String> factDataSet = new HashSet<String>();
        String longNumber = null;
        String[] numbers = null;
        StringBuffer sql = new StringBuffer();
        try {
            int i;
            String factTable = MbgVirtualView.getFactTable((Connection)conn, (BOSUuid)viewId);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FLongNumber from " + factTable + " where exists (select FNumber from " + tmpTable + " where FNumber = " + factTable + ".FDimNumber)"));
            while (rst.next()) {
                sqlParams.add(rst.getString(1) + "!%");
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.append("select FDimLongNumber from " + factTable + " where FLongNumber like ? ");
            for (i = 1; i < 100; ++i) {
                sql.append(" OR FLongNumber like ? ");
            }
            rsts = BgDBUtils.executeBatchQuery((Connection)conn, (String)sql.toString(), sqlParams, (int)100);
            int in = rsts.size();
            for (i = 0; i < in; ++i) {
                objs = (Object[])rsts.get(i);
                longNumber = (String)objs[0];
                if (longNumber == null || (numbers = longNumber.split("!")) == null) continue;
                for (int j = 0; j < numbers.length; ++j) {
                    if (dimNumbers.contains(numbers[j])) continue;
                    factDataSet.add(numbers[j]);
                }
            }
            if (!factDataSet.isEmpty()) {
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), factDataSet);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"querySubMember sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
    }

    protected FilterParam createFilterParam(Context ctx, String bgVersionNumber, BgFormInfo bgFormInfo, BgOrgUnitInfo bgOrgUnitInfo, BgSchemeDimensionHelper schemeHelper, List<String> bgformulas, int type) throws BOSException {
        CoreBaseCollection colls;
        MbgDataQueryFilterParam filterParam = new MbgDataQueryFilterParam();
        String bgSchemeId = schemeHelper.getBgSchemeId();
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        ArrayList<String> bgVersionIds = new ArrayList<String>();
        ArrayList<String> periodsIds = new ArrayList<String>();
        ArrayList<String> elementIds = new ArrayList<String>();
        ArrayList<String> scenarioIds = new ArrayList<String>();
        ArrayList<String> currencyIds = new ArrayList<String>();
        Map bgElementMap = BgElementHelper.getElementoObjMap((Context)ctx);
        HashMap<String, BgPeriodInfo> bgPeriodMap = new HashMap<String, BgPeriodInfo>();
        HashMap bgScenarioMap = new HashMap();
        Map bgCurrencyMap = BgCurrencyHelper.getCurrencyObjMap((Context)ctx);
        List bgScenarioLst = BgScenarioHelper.getBgScenario((Context)ctx);
        if (bgScenarioLst != null && !bgScenarioLst.isEmpty()) {
            for (int index = 0; index < bgScenarioLst.size(); ++index) {
                bgScenarioMap.put(((BgScenarioInfo)bgScenarioLst.get(index)).getNumber(), bgScenarioLst.get(index));
            }
        }
        if ((colls = BgPeriodFactory.getLocalInstance((Context)ctx).getCollection("select id, number")) != null && !colls.isEmpty()) {
            for (int index = 0; index < colls.size(); ++index) {
                bgPeriodMap.put(((BgPeriodInfo)colls.get(index)).getNumber(), (BgPeriodInfo)colls.get(index));
            }
        }
        String formula = null;
        String[] formulaParam = null;
        String periodNumber = null;
        String elementNumber = null;
        String scenarioNumber = null;
        String currencyNumber = null;
        for (int i = 0; i < bgformulas.size(); ++i) {
            formula = bgformulas.get(i);
            formulaParam = BgNFSHelper.parseFormulaPara(formula);
            periodNumber = formulaParam[1];
            elementNumber = formulaParam[2];
            scenarioNumber = formulaParam[3];
            currencyNumber = formulaParam[5];
            if (bgPeriodMap.containsKey(periodNumber)) {
                periodsIds.add(((BgPeriodInfo)bgPeriodMap.get(periodNumber)).getId().toString());
            }
            if (bgElementMap.containsKey(elementNumber)) {
                elementIds.add(((BgElementInfo)bgElementMap.get(elementNumber)).getId().toString());
            }
            if (bgScenarioMap.containsKey(scenarioNumber)) {
                scenarioIds.add(((BgScenarioInfo)bgScenarioMap.get(scenarioNumber)).getId().toString());
            }
            if (bgCurrencyMap.containsKey(currencyNumber)) {
                currencyIds.add(((CurrencyInfo)bgCurrencyMap.get(currencyNumber)).getId().toString());
            }
            filterParam.getMembers().addAll(this.getAnalyseMembers(schemeHelper, formula));
        }
        colls = BgVersionFactory.getLocalInstance((Context)ctx).getCollection("where number = '" + bgVersionNumber + "'");
        if (colls != null && !colls.isEmpty()) {
            bgVersionIds.add(colls.get(0).getId().toString());
        }
        filterParam.setQueryType(MbgDataQueryTypeEnum.BgForm);
        filterParam.setProcessType(bgFormInfo.getProcessType());
        filterParam.setCostCenter((OrgUnitInfo)DimensionCommonHelper.createNewObject(CostCenterOrgUnitInfo.class, orgUnitId));
        filterParam.setBgScheme(DimensionCommonHelper.createNewObject(BgSchemeInfo.class, bgSchemeId));
        filterParam.setBgOrgUnit((CoreBaseInfo)DimensionCommonHelper.createNewObject(BgOrgUnitInfo.class, bgOrgUnitInfo.getId().toString()));
        filterParam.setBgForm((CoreBaseInfo)(type == 2 ? null : DimensionCommonHelper.createNewObject(BgFormInfo.class, bgFormInfo.getId().toString())));
        filterParam.setBgPeriods((BgPeriodInfo[])DimensionCommonHelper.createNewObjectArray(BgPeriodInfo.class, periodsIds));
        filterParam.setBgVersions((BgVersionInfo[])DimensionCommonHelper.createNewObjectArray(BgVersionInfo.class, bgVersionIds));
        filterParam.setBgElements((BgElementInfo[])DimensionCommonHelper.createNewObjectArray(BgElementInfo.class, elementIds));
        filterParam.setBgScenarios((BgScenarioInfo[])DimensionCommonHelper.createNewObjectArray(BgScenarioInfo.class, scenarioIds));
        filterParam.setCurrencies((CurrencyInfo[])DimensionCommonHelper.createNewObjectArray(CurrencyInfo.class, currencyIds));
        return filterParam;
    }

    @Override
    protected void _updateMbgDateState(Context ctx, IObjectValue model, Map mbgDatas) throws BOSException, EASBizException {
        if (ctx == null || model == null || mbgDatas == null || mbgDatas.isEmpty()) {
            return;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        BgSchemeInfo bgSchemeInfo = bgFormInfo.getBgScheme();
        String orgUnitId = bgFormInfo.getOrgUnit().getId().toString();
        String cubeName = bgSchemeInfo.getRefCube();
        BgDataStateEnum bgDataState2 = null;
        Set bgDataIds = null;
        String tmpTable = null;
        TempTablePool pool = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.createIndex((TempTablePool)pool, (String)tmpTable, (String)"FID", (boolean)false, (boolean)false);
            for (BgDataStateEnum bgDataState2 : mbgDatas.keySet()) {
                bgDataIds = (Set)mbgDatas.get((Object)bgDataState2);
                BgDBUtils.executeUpdate((Connection)conn, (String)("Truncate table " + tmpTable));
                BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), (Collection)bgDataIds);
                if (BgDataStateEnum.Edited.equals((Object)bgDataState2)) {
                    BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FState = " + bgDataState2.getValue() + " , FAudOrgUnitID = null where exists (select FID from " + tmpTable + " where FID = " + cubeName + ".FID) "));
                    continue;
                }
                if (!BgDataStateEnum.Approved.equals((Object)bgDataState2)) continue;
                BgDBUtils.executeUpdate((Connection)conn, (String)("update " + cubeName + " set FState = " + bgDataState2.getValue() + " , FAudOrgUnitID = '" + orgUnitId + "', FDETAIL = 1 where exists (select FID from " + tmpTable + " where FID = " + cubeName + ".FID) "));
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException("", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tmpTable)) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                }
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tmpTable)) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected Object _queryDataForms(Context ctx, IObjectValue model, Set bgDataIds) throws BOSException, EASBizException {
        Object[] objs = new Object[3];
        if (model == null || bgDataIds == null || bgDataIds.isEmpty()) {
            return objs;
        }
        BgFormInfo bgFormInfo = (BgFormInfo)model;
        BgSchemeInfo bgSchemeInfo = bgFormInfo.getBgScheme();
        String cubeName = "";
        String cubeEntry = "";
        if (DimensionCommonHelper.isDecompose(bgFormInfo.getProcessType())) {
            cubeName = BgCubeUtils.getCubeName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
            cubeEntry = BgCubeUtils.getCubeEntryName(bgSchemeInfo.getRefCube(), DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
        } else {
            cubeName = bgSchemeInfo.getRefCube();
            cubeEntry = BgCubeUtils.getBudgetEntryCubeName(bgSchemeInfo.getRefCube());
        }
        HashMap<String, BgFormInfo> bgFormsMap = new HashMap<String, BgFormInfo>();
        HashMap bgdataRefFormsIds = new HashMap();
        HashMap bgdataAuditFormIds = new HashMap();
        objs[0] = bgFormsMap;
        objs[1] = bgdataRefFormsIds;
        objs[2] = bgdataAuditFormIds;
        BgFormInfo bgForm = null;
        String bgDataId = null;
        String bgFormId = null;
        BgFormStateEnum bgFormState = null;
        StringBuffer sql = new StringBuffer();
        String tmpTable = null;
        TempTablePool pool = null;
        Connection conn = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tmpTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (FID VARCHAR(44))");
            BgDBUtils.createIndex((TempTablePool)pool, (String)tmpTable, (String)"FID", (boolean)false, (boolean)false);
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FID) values (?)"), (Collection)bgDataIds);
            sql.setLength(0);
            sql.append("select t1.FDataId as dataID, t0.FID as formId, t0.FState from t_mbg_bgform t0 ").append(" inner join " + cubeEntry + " t1 on t1.FFormId = t0.FID ").append(" where t1.FDataId in (select FID from " + tmpTable + ")");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                bgDataId = rst.getString("dataID");
                bgFormId = rst.getString("formId");
                bgFormState = BgFormStateEnum.getEnum(rst.getInt("FState"));
                bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)bgFormId));
                bgForm.setState(bgFormState);
                bgFormsMap.put(bgFormId, bgForm);
                if (!bgdataRefFormsIds.containsKey(bgDataId)) {
                    bgdataRefFormsIds.put(bgDataId, new HashSet());
                }
                ((Set)bgdataRefFormsIds.get(bgDataId)).add(bgFormId);
            }
            SQLUtils.cleanup((ResultSet)rst);
            sql.setLength(0);
            sql.append("select t1.FID as dataID, t0.FID as formId, t0.FState from t_mbg_bgform t0 ").append(" inner join " + cubeName + " t1 on t1.FAUDFORMID = t0.FID ").append(" where t1.FID in (select FID From " + tmpTable + ")");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                bgDataId = rst.getString("dataID");
                bgFormId = rst.getString("formId");
                bgFormState = BgFormStateEnum.getEnum(rst.getInt("FState"));
                bgForm = new BgFormInfo();
                bgForm.setId(BOSUuid.read((String)bgFormId));
                bgForm.setState(bgFormState);
                bgFormsMap.put(bgFormId, bgForm);
                if (!bgdataAuditFormIds.containsKey(bgDataId)) {
                    bgdataAuditFormIds.put(bgDataId, new HashSet());
                }
                ((Set)bgdataAuditFormIds.get(bgDataId)).add(bgFormId);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException("", (Throwable)e);
            }
            catch (Throwable throwable) {
                if (!StringUtils.isEmpty(tmpTable)) {
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, tmpTable);
                }
                SQLUtils.cleanup(rst, null, (Connection)conn);
                throw throwable;
            }
        }
        if (!StringUtils.isEmpty((String)tmpTable)) {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tmpTable);
        }
        SQLUtils.cleanup((ResultSet)rst, null, (Connection)conn);
        return objs;
    }
}

