/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.MbgDimCollection;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.utils.MbgVirtualView;
import com.kingdee.eas.ma.biz.app.utils.BizCalcCheckServerHelper;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.app.olap.impl.BizCalcStrategy;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.cube.MultiThreadQuery;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseIntegUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public final class DimDataQueryUtils {
    private static Logger logger = Logger.getLogger(DimDataQueryUtils.class);

    public static Map<String, Map<String, IBgNData>> queryMuiltOrgData(Context ctx, BOSUuid bgOrgViewId, IDimDataQuery dimDataQuery, int dataType, Map dimensionManagers, boolean hasBackUpdate, Set viewStates) throws BOSException, EASBizException {
        Map<String, Map<String, IBgNData>> bgDataMap = new HashMap<String, Map<String, IBgNData>>();
        if (ctx == null || bgOrgViewId == null || dimDataQuery == null || dimensionManagers == null || dimensionManagers.isEmpty()) {
            return bgDataMap;
        }
        String orgUnitId = null;
        HashSet<String> orgUnitIds = new HashSet<String>();
        List subDimensionManagers = null;
        List tmpManagers = null;
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : dimensionManagers.entrySet()) {
            orgUnitId = (String)entry2.getKey();
            tmpManagers = (List)entry2.getValue();
            if (orgUnitId.equals(dimDataQuery.getBizOrgUnit().getId().toString())) {
                subDimensionManagers = tmpManagers;
            }
            orgUnitIds.addAll(DimDataQueryUtils.getAllOrgIdSet(tmpManagers));
        }
        orgUnitIds.add(dimDataQuery.getBizOrgUnit().getId().toString());
        dimDataQuery.put("ORGUNIT_ID", orgUnitIds);
        Object[] objs = DimDataQueryUtils.queryMBgData(ctx, dimDataQuery.getId(), dimDataQuery, subDimensionManagers, dataType, true, bgOrgViewId, viewStates, null);
        if (objs != null && objs.length > 0 && objs[0] instanceof Map) {
            bgDataMap = (Map)objs[0];
        }
        return bgDataMap;
    }

    private static Set<String> getAllOrgIdSet(List<IBgDimensionManagerBase> subDimensionManagers) {
        HashSet<String> orgUnitIds = new HashSet<String>();
        if (subDimensionManagers == null || subDimensionManagers.isEmpty()) {
            return orgUnitIds;
        }
        BgDimensionMember bgMember = null;
        MbgViewListDimensionInfo bgDimension = null;
        int in = subDimensionManagers.size();
        for (int i = 0; i < in; ++i) {
            IBgDimensionManagerBase dimManger = subDimensionManagers.get(i);
            List<MbgViewListDimensionInfo> dimensions = dimManger instanceof MbgViewListDimensionManager ? ((MbgViewListDimensionManager)dimManger).getAllDimensions() : dimManger.getDimension();
            int jn = dimensions.size();
            for (int j = 0; j < jn; ++j) {
                BgDimensionBaseInfo dimension;
                bgDimension = dimensions.get(j);
                if (!(bgDimension instanceof BgDimensionBaseInfo) || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals((dimension = (BgDimensionBaseInfo)bgDimension).getNumber())) continue;
                int xn = dimension.getMember().size();
                for (int x = 0; x < xn; ++x) {
                    bgMember = (BgDimensionMember)dimension.getMember().get(x);
                    orgUnitIds.add(bgMember.getAttribute());
                }
            }
        }
        return orgUnitIds;
    }

    public static Object[] queryMBgData(Context ctx, BOSUuid billId, IDimDataQuery dimDataQuery, List dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId, Set viewStates, Map<String, Set<String>> allFormulaMap, boolean isCalcBiz) throws BOSException, EASBizException {
        return DimDataQueryUtils.queryMBgData(ctx, billId, dimDataQuery, dimensionManagers, dataType, isSynch, bgOrgViewId, false, null, viewStates, allFormulaMap, isCalcBiz);
    }

    public static Object[] queryMBgData(Context ctx, BOSUuid billId, IDimDataQuery dimDataQuery, List dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId, Set viewStates, Map<String, Set<String>> allFormulaMap) throws BOSException, EASBizException {
        return DimDataQueryUtils.queryMBgData(ctx, billId, dimDataQuery, dimensionManagers, dataType, isSynch, bgOrgViewId, viewStates, allFormulaMap, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] queryMBgData(Context ctx, BOSUuid billId, IDimDataQuery dimDataQuery, List<IBgDimensionManagerBase> dimensionManagers, int dataType, boolean isSynch, BOSUuid bgOrgViewId, boolean isMuiltOrg, Map<String, String> orgUnitNumMap, Set viewStates, Map<String, Set<String>> allFormulaMap, boolean isCalcBiz) throws BOSException, EASBizException {
        Object[] objs;
        block52: {
            objs = new Object[2];
            Map bgDataMap = new HashMap();
            objs[0] = bgDataMap;
            if (ctx == null || dimDataQuery == null || dimensionManagers == null) {
                return objs;
            }
            IDimensionParameter parameter = null;
            long begin = System.currentTimeMillis();
            logger.debug((Object)"begin trans dimenson parameter!");
            try {
                List<String[]> relationData;
                boolean hasRelation;
                parameter = DimUtils.transDimParameter(ctx, dimensionManagers, dimDataQuery, bgOrgViewId);
                parameter.setCalcBiz(isCalcBiz);
                logger.debug((Object)("end trans dimenson parameter! use = " + (System.currentTimeMillis() - begin) + " ms."));
                if (parameter == null) break block52;
                if (parameter.getDimension(DimensionConstants.DEF_CSL_FIELD) != null) {
                    MbgVirtualView virt = MbgVirtualView.getInstance((Context)ctx);
                    virt.checkCslVirualView();
                }
                if (parameter.getDataManager().getMbgDims().isEmpty()) {
                    Connection conn = null;
                    try {
                        conn = EJBFactory.getConnection((Context)ctx);
                        MbgDimCollection colls = DimUtils.getDimensionColls(conn, ctx.getLocale());
                        MbgDimInfo mbgDim = null;
                        int in = colls.size();
                        for (int i = 0; i < in; ++i) {
                            mbgDim = colls.get(i);
                            parameter.getDataManager().getMbgDims().put(mbgDim.getRefField(), mbgDim);
                            parameter.getDataManager().getSrcFieldMap().put(mbgDim.getSrcNumber(), mbgDim.getRefField());
                            parameter.getDataManager().getFieldSrcMap().put(mbgDim.getRefField(), mbgDim.getSrcNumber());
                        }
                    }
                    finally {
                        SQLUtils.cleanup((Connection)conn);
                    }
                }
                objs[1] = parameter;
                parameter.setValueType(dataType);
                if (billId != null) {
                    parameter.setBillId(billId);
                }
                if (viewStates != null) {
                    parameter.getDataManager().getCustomState().addAll(viewStates);
                }
                ArrayList sortedDimNumbers = new ArrayList();
                IRowSet rst = null;
                try {
                    HashMap<String, String> viewId_dimNumber = new HashMap<String, String>();
                    rst = DbUtil.executeQuery((Context)ctx, (String)"Select t0.FDimNumber, t1.FMemberId FROM T_MBG_BgDimSettings t0, T_MBG_BgDimSettingsMember t1 Where t0.FID = t1.FBgDimSettingsId AND t0.FBgSchemeId = ?", (Object[])new Object[]{parameter.getBgSchemeId().toString()});
                    while (rst.next()) {
                        viewId_dimNumber.put(rst.getString("FMemberId"), rst.getString("FDimNumber"));
                    }
                    SQLUtils.cleanup((ResultSet)rst);
                    rst = DbUtil.executeQuery((Context)ctx, (String)"Select FViewId FROM T_MBG_MbgMember Where FViewId IN(Select FMemberId FROM T_MBG_BgDimSettingsMember Where FBgDimSettingsId IN(Select FID FROM T_MBG_BgDimSettings Where FBgSchemeId = ?)) Group By FViewId Having COUNT(FID) > 100 Order By Count(FID) Desc", (Object[])new Object[]{parameter.getBgSchemeId().toString()});
                    while (rst.next()) {
                        sortedDimNumbers.add(viewId_dimNumber.get(rst.getString("FViewId")));
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
                SQLUtils.cleanup((ResultSet)rst);
                String splitDimNumber = null;
                com.kingdee.eas.ma.mbg.dimension.face.IMember rootMember = null;
                com.kingdee.eas.ma.mbg.dimension.face.IMember distMember = null;
                if (!sortedDimNumbers.isEmpty()) {
                    Map<String, String> srcFieldMap = MbgQingAnalyseHelper.getSrcFieldMap(ctx, parameter);
                    if (parameter.getDataManager().getSrcFieldMap().isEmpty()) {
                        parameter.getDataManager().getSrcFieldMap().putAll(srcFieldMap);
                    }
                    Boolean isExpressionCalc = parameter.getControlManager().isExpressionCalc();
                    parameter.getControlManager().setExpressionCalc(true);
                    BizCalcStrategy bizStr = new BizCalcStrategy();
                    bizStr.queryCalc(ctx, parameter);
                    List noUseDims = BizCalcCheckServerHelper.getNoUseDim((BizCalcStrategy)bizStr, (IDimensionParameter)parameter, srcFieldMap);
                    parameter.getControlManager().setExpressionCalc(isExpressionCalc);
                    com.kingdee.eas.ma.mbg.dimension.face.IMember member2 = null;
                    if (!noUseDims.isEmpty()) {
                        Map<String, String> rootMemberMap = null;
                        Map<String, String> notDistMemberMap = null;
                        Connection conn = null;
                        try {
                            conn = EJBFactory.getConnection((Context)ctx);
                            rootMemberMap = parameter.getDataManager().getBgScheme().getExtRootMember(conn);
                            notDistMemberMap = parameter.getDataManager().getBgScheme().getNotDistMember(conn);
                        }
                        finally {
                            SQLUtils.cleanup((Connection)conn);
                        }
                        if (rootMemberMap != null) {
                            rootMember = null;
                            distMember = null;
                            for (String dimNumber : sortedDimNumbers) {
                                IDimension dim = parameter.getDimensionMap().get(dimNumber);
                                if (dim == null || dim.getDimensionMember().size() != 2 || !noUseDims.contains(srcFieldMap.get(dim.getSrcNumber()))) continue;
                                for (com.kingdee.eas.ma.mbg.dimension.face.IMember member2 : dim.getDimensionMember()) {
                                    if (member2 == null) continue;
                                    if (rootMemberMap.get(dim.getField()).equals(member2.getNumber())) {
                                        rootMember = member2;
                                    }
                                    if (!notDistMemberMap.get(dim.getField()).equals(member2.getDimNumber())) continue;
                                    distMember = member2;
                                }
                                if (rootMember == null || distMember == null) continue;
                                splitDimNumber = dimNumber;
                                break;
                            }
                        }
                    }
                }
                boolean bl = hasRelation = (relationData = parameter.getDataManager().getRelationData(parameter)) != null && !relationData.isEmpty();
                if (!hasRelation) {
                    List<String[]>[] relations = null;
                    block15: for (int i = 0; i < parameter.getQuerys().size(); ++i) {
                        relations = parameter.getQuerys().get(i).getFilters();
                        if (relations == null) continue;
                        for (int r = 0; r < relations.length; ++r) {
                            if (relations[r] == null || relations[r].isEmpty()) continue;
                            hasRelation = true;
                            continue block15;
                        }
                    }
                }
                HashSet<String> bgPeriodSet = new HashSet<String>();
                IDimension periodDim = parameter.getDimension(DimensionConstants.DEF_PERIOD_FIELD);
                bgPeriodSet.addAll(DimUtils.getDimMemberNumber(periodDim));
                if (parameter.getQuerys() != null) {
                    for (int q = 0; q < parameter.getQuerys().size(); ++q) {
                        for (int d = 0; d < parameter.getQuerys().get(q).getDims().size(); ++d) {
                            if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(parameter.getQuerys().get(q).getDims().get(d).getNumber())) continue;
                            bgPeriodSet.addAll(DimUtils.getDimMemberNumber(parameter.getQuerys().get(q).getDims().get(d).toMbgDim()));
                        }
                        for (String field : parameter.getQuerys().get(q).getMbgDimMap().keySet()) {
                            if (!DimensionConstants.DEF_PERIOD_FIELD.equals(field)) continue;
                            bgPeriodSet.addAll(DimUtils.getDimMemberNumber(parameter.getQuerys().get(q).getMbgDimMap().get(field).toMbgDim()));
                        }
                    }
                }
                HashSet<String> bgPeriodNumbers = new HashSet<String>();
                for (String number : bgPeriodSet) {
                    if (number.indexOf(":") > 0) {
                        bgPeriodNumbers.add(DimensionFormulaHelper.getMemberNumber(number));
                        continue;
                    }
                    bgPeriodNumbers.add(number);
                }
                EntityViewInfo view = new EntityViewInfo();
                view.setSelector(new SelectorItemCollection());
                view.getSelector().add("number");
                view.getSelector().add("name");
                view.getSelector().add("longNumber");
                view.getSelector().add("type.fiscalYear");
                view.getSelector().add("type.number");
                view.setFilter(new FilterInfo());
                view.getFilter().getFilterItems().add(new FilterItemInfo("number", bgPeriodNumbers, CompareType.INCLUDE));
                BgPeriodDispCollection periodCol = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(view);
                HashMap<String, BgPeriodDispInfo> standPeriodMap = new HashMap<String, BgPeriodDispInfo>();
                HashMap<String, BgPeriodDispInfo> stridPeriodMap = new HashMap<String, BgPeriodDispInfo>();
                List<String> bgSchemePeriodType = null;
                if (parameter.getDataManager().getBgScheme() != null) {
                    bgSchemePeriodType = parameter.getDataManager().getBgScheme().getMemberNumber(DimensionConstants.DEF_PERIOD_NUMBER);
                }
                BgPeriodDispInfo periodInfo = null;
                for (int i = 0; i < periodCol.size(); ++i) {
                    periodInfo = periodCol.get(i);
                    if (bgSchemePeriodType != null && !bgSchemePeriodType.contains(periodInfo.getType().getNumber())) continue;
                    if (FiscalYearEnum.STANDARDYEAR.equals((Object)periodInfo.getType().getFiscalYear())) {
                        standPeriodMap.put(periodInfo.getNumber(), periodInfo);
                        continue;
                    }
                    stridPeriodMap.put(periodInfo.getNumber(), periodInfo);
                }
                HashSet<String> stridPeriodSet = new HashSet<String>();
                HashSet<String> stridPeriodLongNumbers = new HashSet<String>();
                for (String number : stridPeriodMap.keySet()) {
                    if (standPeriodMap.containsKey(number)) continue;
                    stridPeriodSet.add(number);
                    stridPeriodLongNumbers.add(((BgPeriodDispInfo)stridPeriodMap.get(number)).getLongNumber());
                }
                for (String number : stridPeriodMap.keySet()) {
                    if (stridPeriodSet.contains(number)) continue;
                    periodInfo = (BgPeriodDispInfo)stridPeriodMap.get(number);
                    for (String lns : stridPeriodLongNumbers) {
                        if (!periodInfo.getLongNumber().startsWith(lns + "!")) continue;
                        stridPeriodSet.add(number);
                    }
                }
                HashSet<String> standPeriodSet = new HashSet<String>(bgPeriodNumbers);
                standPeriodSet.removeAll(stridPeriodSet);
                if (allFormulaMap != null) {
                    parameter.setQingAnalyse(false);
                }
                if (splitDimNumber == null || hasRelation) {
                    objs[0] = bgDataMap = (Map)DimDataQueryUtils.innerDimensionQuery(ctx, parameter, standPeriodSet, stridPeriodSet);
                } else {
                    IDimensionParameter _parameter = parameter.getClone(ctx);
                    _parameter.setQeryOrgIds(parameter.getQueryOrgIds());
                    _parameter.getDimensionMap().get(splitDimNumber).getDimensionMember().clear();
                    _parameter.getDimensionMap().get(splitDimNumber).getDimensionMember().add(distMember);
                    Object tmpMap = (Map)DimDataQueryUtils.innerDimensionQuery(ctx, _parameter, standPeriodSet, stridPeriodSet);
                    MultiThreadQuery.mergeData(bgDataMap, (Map)tmpMap);
                    _parameter = parameter.getClone(ctx);
                    _parameter.setQeryOrgIds(parameter.getQueryOrgIds());
                    _parameter.getDimensionMap().get(splitDimNumber).getDimensionMember().clear();
                    _parameter.getDimensionMap().get(splitDimNumber).getDimensionMember().add(rootMember);
                    tmpMap = (Map)DimDataQueryUtils.innerDimensionQuery(ctx, _parameter, standPeriodSet, stridPeriodSet);
                    MultiThreadQuery.mergeData(bgDataMap, (Map)tmpMap);
                }
                if (!bgPeriodSet.isEmpty()) {
                    DimDataQueryUtils.filterPeriod(bgDataMap, bgPeriodSet);
                }
                if (allFormulaMap != null) {
                    HashMap<String, Object> qingAnalyseSaveData = new HashMap<String, Object>();
                    for (Object key : bgDataMap.keySet()) {
                        if (bgDataMap.get(key) instanceof Map) {
                            qingAnalyseSaveData.put((String)key, new HashMap((Map)bgDataMap.get(key)));
                            continue;
                        }
                        if (bgDataMap.get(key) instanceof BgNViewDataInfo) {
                            if (!qingAnalyseSaveData.containsKey(parameter.getOrgUnitId().toString())) {
                                qingAnalyseSaveData.put(parameter.getOrgUnitId().toString(), new HashMap());
                            }
                            ((Map)qingAnalyseSaveData.get(parameter.getOrgUnitId().toString())).put((String)key, (BgNViewDataInfo)bgDataMap.get(key));
                            continue;
                        }
                        logger.error((Object)("DimDataQueryUtils bgDataMap error key:" + key + " value:" + bgDataMap.get(key)));
                    }
                    for (String orgId : allFormulaMap.keySet()) {
                        if (qingAnalyseSaveData.get(orgId) == null) {
                            logger.error((Object)("DimDataQueryUtils add remove data not found org:" + orgId));
                            continue;
                        }
                        for (String formula : allFormulaMap.get(orgId)) {
                            if (((Map)qingAnalyseSaveData.get(orgId)).containsKey(DimUtils.getDimDataKey(formula, dimDataQuery.getBizVersion().getNumber()))) continue;
                            ((Map)qingAnalyseSaveData.get(orgId)).put(DimUtils.getDimDataKey(formula, dimDataQuery.getBizVersion().getNumber()), null);
                        }
                    }
                    HashMap<String, Object> saveData = qingAnalyseSaveData;
                    MbgQingAnalyseIntegUtils utils = new MbgQingAnalyseIntegUtils(ctx, parameter, saveData);
                    utils.start();
                }
            }
            catch (Exception ex) {
                logger.error((Object)"", (Throwable)ex);
                throw new BOSException((Throwable)ex);
            }
        }
        return objs;
    }

    private static Object innerDimensionQuery(Context ctx, IDimensionParameter parameter, Set<String> standPeriodSet, Set<String> stridPeriodSet) throws EASBizException, BOSException {
        if (standPeriodSet.isEmpty() || stridPeriodSet.isEmpty()) {
            return BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(parameter);
        }
        HashMap bgDataMap = new HashMap();
        Map tmpMap = (Map)DimDataQueryUtils.innerDimensionQuery(ctx, parameter, standPeriodSet, false);
        MultiThreadQuery.mergeData(bgDataMap, tmpMap);
        tmpMap = (Map)DimDataQueryUtils.innerDimensionQuery(ctx, parameter, stridPeriodSet, true);
        MultiThreadQuery.mergeData(bgDataMap, tmpMap);
        return bgDataMap;
    }

    private static Object innerDimensionQuery(Context ctx, IDimensionParameter parameter, Set<String> periodSet, boolean isFiscal) throws EASBizException, BOSException {
        if (periodSet.isEmpty()) {
            return new HashMap();
        }
        IDimensionParameter _parameter = parameter.getClone(ctx);
        _parameter.getControlManager().setFiscalYear(isFiscal);
        _parameter.setQeryOrgIds(parameter.getQueryOrgIds());
        IDimension periodDim = _parameter.getDimension(DimensionConstants.DEF_PERIOD_FIELD);
        com.kingdee.eas.ma.mbg.dimension.face.IMember member = null;
        Iterator<com.kingdee.eas.ma.mbg.dimension.face.IMember> it = periodDim.getDimensionMember().iterator();
        while (it.hasNext()) {
            member = it.next();
            if (periodSet.contains(member.getNumber())) continue;
            it.remove();
        }
        if (_parameter.getQuerys() != null) {
            for (int q = 0; q < _parameter.getQuerys().size(); ++q) {
                for (int d = 0; d < _parameter.getQuerys().get(q).getDims().size(); ++d) {
                    if (!DimensionConstants.DEF_PERIOD_NUMBER.equals(_parameter.getQuerys().get(q).getDims().get(d).getNumber())) continue;
                    Iterator<IMember> it2 = _parameter.getQuerys().get(q).getDims().get(d).getMembers().iterator();
                    while (it2.hasNext()) {
                        IMember _member = it2.next();
                        if (periodSet.contains(_member.getNumber())) continue;
                        it2.remove();
                    }
                }
                for (String field : parameter.getQuerys().get(q).getMbgDimMap().keySet()) {
                    if (!DimensionConstants.DEF_PERIOD_FIELD.equals(field)) continue;
                    Iterator<IMember> it3 = parameter.getQuerys().get(q).getMbgDimMap().get(field).getMembers().iterator();
                    while (it3.hasNext()) {
                        IMember _member = it3.next();
                        if (periodSet.contains(_member.getNumber())) continue;
                        it3.remove();
                    }
                }
            }
        }
        return BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(_parameter);
    }

    private static void filterPeriod(Map bgDataMap, Set<String> bgPeriodSet) {
        Object[] keys;
        if (bgDataMap == null || bgDataMap.isEmpty() || bgPeriodSet == null || bgPeriodSet.isEmpty()) {
            return;
        }
        for (Object key : keys = bgDataMap.keySet().toArray()) {
            if (bgDataMap.get(key) instanceof Map) {
                DimDataQueryUtils.filterPeriod((Map)bgDataMap.get(key), bgPeriodSet);
                continue;
            }
            if (!(bgDataMap.get(key) instanceof IBgNData) || bgPeriodSet.contains(((IBgNData)bgDataMap.get(key)).getBgPeriodNumber()) || bgPeriodSet.contains(DimensionFormulaHelper.getCombination(DimensionConstants.DEF_PERIOD_SRCNUMBER, ((IBgNData)bgDataMap.get(key)).getBgPeriodNumber()))) continue;
            bgDataMap.remove(key);
        }
    }

    public static Map<String, Map<String, BgNViewDataInfo>> convertOrgData(Context ctx, String orgUnitId, String bgSchemeId, Map mbgDataMap, int dataType) throws BOSException {
        if (orgUnitId == null || bgSchemeId == null || mbgDataMap == null) {
            return null;
        }
        HashMap<String, Map<String, BgNViewDataInfo>> vMbgDataMap = new HashMap<String, Map<String, BgNViewDataInfo>>();
        HashSet orgUnitNums = new HashSet();
        HashMap<String, String> orgUnitMap = new HashMap<String, String>();
        Map.Entry entry2 = null;
        for (Map.Entry entry2 : mbgDataMap.entrySet()) {
            if (!(entry2.getValue() instanceof Map)) continue;
            orgUnitNums.add(entry2.getKey());
        }
        if (!orgUnitNums.isEmpty()) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", orgUnitNums, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id ");
            sic.add("number");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            FullOrgUnitCollection colls = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
            if (colls != null) {
                FullOrgUnitInfo orgUnit = null;
                int in = colls.size();
                for (int i = 0; i < in; ++i) {
                    orgUnit = colls.get(i);
                    orgUnitMap.put(orgUnit.getNumber(), orgUnit.getId().toString());
                }
            }
        }
        String _orgUnitId = null;
        Map vDataMap = null;
        Map tmpDataMap = null;
        Map.Entry _entry2 = null;
        BgNViewDataInfo viewData = null;
        for (Map.Entry entry2 : mbgDataMap.entrySet()) {
            if (entry2.getValue() instanceof Map) {
                tmpDataMap = (Map)entry2.getValue();
                _orgUnitId = (String)orgUnitMap.get(entry2.getKey());
                if (_orgUnitId == null) {
                    _orgUnitId = (String)entry2.getKey();
                }
                if (vMbgDataMap.containsKey(_orgUnitId)) {
                    vDataMap = (Map)vMbgDataMap.get(_orgUnitId);
                } else {
                    vDataMap = new HashMap();
                    vMbgDataMap.put(_orgUnitId, vDataMap);
                }
                for (Map.Entry _entry2 : tmpDataMap.entrySet()) {
                    viewData = new BgNViewDataInfo((BgNDataInfo)_entry2.getValue());
                    if (dataType == 16) {
                        viewData.setOldValue(viewData.getAddActualNoDef());
                    } else if (dataType == 1 && viewData.getOldValue() == null) {
                        viewData.setOldValue(viewData.getBudgetValueNoDef());
                    }
                    viewData.setOrgUnitId(_orgUnitId);
                    viewData.setBgSchemeId(bgSchemeId);
                    vDataMap.put(_entry2.getKey(), viewData);
                }
                continue;
            }
            if (!(entry2.getValue() instanceof BgNDataInfo)) continue;
            viewData = new BgNViewDataInfo((BgNDataInfo)entry2.getValue());
            if (dataType == 16) {
                viewData.setOldValue(viewData.getAddActualNoDef());
            } else if ((dataType == 128 || dataType == 64 || dataType == 1) && viewData.getOldValue() == null) {
                viewData.setOldValue(viewData.getBudgetValueNoDef());
            }
            viewData.setOrgUnitId(orgUnitId);
            viewData.setBgSchemeId(bgSchemeId);
            if (vMbgDataMap.containsKey(orgUnitId)) {
                vDataMap = (Map)vMbgDataMap.get(orgUnitId);
            } else {
                vDataMap = new HashMap();
                vMbgDataMap.put(orgUnitId, vDataMap);
            }
            vDataMap.put(entry2.getKey(), viewData);
        }
        return vMbgDataMap;
    }
}

