/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormException;
import com.kingdee.eas.ma.mbg.DimensionRelationshipFactory;
import com.kingdee.eas.ma.mbg.DimensionRelationshipGroupInfo;
import com.kingdee.eas.ma.mbg.app.AbstractDimensionRelationshipGroupControllerBean;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.log4j.Logger;

public class DimensionRelationshipGroupControllerBean
extends AbstractDimensionRelationshipGroupControllerBean {
    private static final long serialVersionUID = 3650286035675007476L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.DimensionRelationshipGroupControllerBean");

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _isGroupRef(Context ctx, BOSUuid groupID) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        boolean isGroupRef;
        block7: {
            isGroupRef = false;
            conn = null;
            pstmt = null;
            rst = null;
            try {
                conn = this.getConnection(ctx);
                pstmt = conn.prepareStatement("SELECT top 1 fid FROM T_MBG_DIMRELATIONGROUPREF WHERE FRELATIONGROUPID = ?");
                pstmt.setString(1, groupID.toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    isGroupRef = true;
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                if (isGroupRef) break block7;
                pstmt = conn.prepareStatement("SELECT top 1 fid FROM T_MBG_BgSpecialDimRelaGroupRef WHERE FDimRelaGroupID = ?");
                pstmt.setString(1, groupID.toString());
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    isGroupRef = true;
                }
            }
            catch (SQLDataException ex) {
                try {
                    throw new BOSException((Throwable)ex);
                    catch (SQLException ex2) {
                        throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                    }
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return isGroupRef;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        DimensionRelationshipGroupInfo info = (DimensionRelationshipGroupInfo)model;
        if (info != null && DimensionRelationshipFactory.getLocalInstance(ctx).exists("where dimensionGroup.id = '" + info.getId() + "'")) {
            ResultSet rst;
            PreparedStatement pstmt;
            Connection conn;
            block13: {
                ArrayList<String> newOrder = new ArrayList<String>();
                info.getEntries().sort("sortNo");
                for (int i = 0; i < info.getEntries().size(); ++i) {
                    newOrder.add(info.getEntries().get(i).getDimNumber());
                }
                conn = null;
                pstmt = null;
                rst = null;
                try {
                    conn = this.getConnection(ctx);
                    pstmt = conn.prepareStatement("Select FDimNumber FROM T_MBG_DimRelashipGroupEntry Where FDimRelashipGroupID = ? Order By FSortNo");
                    pstmt.setString(1, info.getId().toString());
                    rst = pstmt.executeQuery();
                    ArrayList<String> oldOrder = new ArrayList<String>();
                    while (rst.next()) {
                        oldOrder.add(rst.getString("FDimNumber"));
                    }
                    SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
                    if (oldOrder.equals(newOrder)) break block13;
                    BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, info.getBgScheme().getId().toString());
                    ArrayList<String> srcNumbers = new ArrayList<String>();
                    for (String dimNumber : newOrder) {
                        if (dimNumber.equals(DimensionConstants.DEF_CSL_Consolidation)) {
                            srcNumbers.add(DimensionConstants.DEF_CSL_SRCNUMBER);
                            continue;
                        }
                        srcNumbers.add(schemeHelper.getSrcNumber(dimNumber));
                    }
                    HashMap<String, String> srcNumber_number = new HashMap<String, String>();
                    HashMap<String, String> srcNumber_name = new HashMap<String, String>();
                    String[] numbers = null;
                    String[] names = null;
                    String srcNumber = null;
                    StringBuffer newNumber = new StringBuffer();
                    StringBuffer newName = new StringBuffer();
                    pstmt = conn.prepareStatement("Select FDimensionNumber, FDimensionName FROM T_MBG_DimensionRelationship Where FDimensionGroupID = ?", 1003, 1008);
                    pstmt.setString(1, info.getId().toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        numbers = rst.getString("FDimensionNumber").split(",");
                        names = rst.getString("FDimensionName").split(DimensionConstants.TICK_SEPARATOR);
                        srcNumber_number.clear();
                        srcNumber_name.clear();
                        newNumber.setLength(0);
                        newName.setLength(0);
                        for (int i = 0; i < numbers.length; ++i) {
                            srcNumber = DimensionFormulaHelper.getSrcNumber(numbers[i]);
                            srcNumber_number.put(srcNumber, numbers[i]);
                            srcNumber_name.put(srcNumber, names[i]);
                        }
                        for (int s = 0; s < srcNumbers.size(); ++s) {
                            if (s > 0) {
                                newNumber.append(",");
                                newName.append(DimensionConstants.TICK_SEPARATOR);
                            }
                            srcNumber = (String)srcNumbers.get(s);
                            newNumber.append((String)srcNumber_number.get(srcNumber));
                            newName.append((String)srcNumber_name.get(srcNumber));
                        }
                        rst.updateString("FDimensionNumber", newNumber.toString());
                        rst.updateString("FDimensionName", newName.toString());
                        rst.updateRow();
                    }
                }
                catch (SQLException e) {
                    try {
                        logger.error((Object)"", (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        }
        super._update(ctx, pk, model);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected boolean _checkHasEntries(Context ctx, BOSUuid groupID) throws BOSException, EASBizException {
        boolean hasEntries = false;
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("SELECT top 1 T_MBG_DimensionRelationship.fid FROM T_MBG_DimensionRelationship LEFT OUTER JOIN T_MBG_DimensionRelationGroup ON  T_MBG_DimensionRelationship.FDimensionGroupID = T_MBG_DimensionRelationGroup.FID where  T_MBG_DimensionRelationGroup.fid = ? ");
            pstmt.setString(1, groupID.toString());
            rst = pstmt.executeQuery();
            if (rst.next()) {
                hasEntries = true;
            }
        }
        catch (SQLDataException ex) {
            try {
                throw new BOSException((Throwable)ex);
                catch (SQLException ex2) {
                    throw new BgFormException(BgFormException.DATABASEERROR, new String[]{ex2.getMessage()});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return hasEntries;
    }

    protected void _checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        super._checkNumberDup(ctx, model);
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        FilterInfo filter = new FilterInfo();
        if (model == null) {
            filter.getFilterItems().add(new FilterItemInfo("bgScheme", (Object)"#", CompareType.EQUALS));
        } else {
            DimensionRelationshipGroupInfo info = (DimensionRelationshipGroupInfo)model;
            filter.getFilterItems().add(new FilterItemInfo("bgScheme", (Object)info.getBgScheme().getId().toString(), CompareType.EQUALS));
            if (info.getOrgTreeId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("orgTreeId", (Object)info.getOrgTreeId().toString(), CompareType.EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("isCsl", (Object)Boolean.FALSE, CompareType.EQUALS));
            }
        }
        return filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String _queryGroupBySchemeAndDims(Context ctx, String bgSchemeId, Set dimNumSet) throws BOSException, EASBizException {
        if (dimNumSet == null || bgSchemeId == null || dimNumSet != null && dimNumSet.size() < 2) {
            return null;
        }
        Connection conn = null;
        IRowSet rowSet = null;
        int dimCount = dimNumSet.size();
        StringBuffer dimStr = new StringBuffer();
        for (Object dimNum : dimNumSet) {
            dimStr.append("'").append(dimNum.toString()).append("'").append(",");
        }
        dimStr.delete(dimStr.length() - 1, dimStr.length());
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT Sub_Group.FDIMRELASHIPGROUPID from ").append(" ( ").append(" SELECT FDIMRELASHIPGROUPID  FROM T_MBG_DimRelashipGroupEntry relEntry join T_MBG_DIMENSIONRELATIONGROUP relGroup on relGroup.FID = relEntry.FDIMRELASHIPGROUPID ").append(" where relEntry.FDimNumber in (").append(dimStr.toString()).append(") and relGroup.FBgSchemeID = '").append(bgSchemeId).append("' ").append(" group by FDIMRELASHIPGROUPID having count('FDIMRELASHIPGROUPID') = ").append(dimCount).append(" AS Sub_Group) ").append(" where Sub_Group.FDIMRELASHIPGROUPID in ").append(" ( ").append(" SELECT FDIMRELASHIPGROUPID  FROM T_MBG_DimRelashipGroupEntry entry ").append(" group by FDIMRELASHIPGROUPID having count('FDIMRELASHIPGROUPID') = ").append(dimCount).append(" ) ");
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            rowSet = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            if (rowSet.next()) {
                Object dimNum;
                dimNum = rowSet.getString("FDIMRELASHIPGROUPID");
                return dimNum;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }
}

