/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodEnum;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.mbg.AnalyseDataFacade;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.AbstractMBgAnalyseFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class MBgAnalyseFacadeControllerBean
extends AbstractMBgAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 5302126898489499184L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MBgAnalyseFacadeControllerBean");

    @Override
    protected List _getCommRootScheme(Context ctx, List orgUnitIds) throws BOSException, EASBizException {
        ArrayList<String> mbgSchemeIds = new ArrayList<String>();
        if (orgUnitIds == null || orgUnitIds.isEmpty()) {
            return mbgSchemeIds;
        }
        Set bgSchemeIds = BgSchemeFactory.getLocalInstance(ctx).getCollection(orgUnitIds, true);
        if (bgSchemeIds != null) {
            for (BOSUuid bgSchemeId : bgSchemeIds) {
                mbgSchemeIds.add(bgSchemeId.toString());
            }
        }
        return mbgSchemeIds;
    }

    @Override
    protected Object _getSchemePeriod(Context ctx, BOSUuid bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return null;
        }
        BgSchemeInfo bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeId);
        if (bgSchemeInfo == null) {
            return null;
        }
        Timestamp begin = new Timestamp(BgNPeriodHelper.getDayBegin((Date)bgSchemeInfo.getDateFrom()).getTime());
        Timestamp end = new Timestamp(BgNPeriodHelper.getDayEnd((Date)bgSchemeInfo.getDateTo()).getTime());
        int periodType = bgSchemeInfo.getPeriod().getValue();
        BgPeriodInfo[] bgPeriods = new BgPeriodInfo[2];
        Connection conn = null;
        Statement pstmt = null;
        IRowSet rst = null;
        try {
            conn = this.getConnection(ctx);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FID, FNumber, FName_" + ctx.getLocale() + ", FBeginDate, FEndDate from T_MBG_BgPeriod where FBeginDate >= ? and FEndDate <= ? and FPeriodType = ? order by FNumber"), (Object[])new Object[]{begin, end, periodType});
            if (rst.next()) {
                bgPeriods[0] = new BgPeriodInfo();
                bgPeriods[0].setId(BOSUuid.read((String)rst.getString(1)));
                bgPeriods[0].setNumber(rst.getString(2));
                bgPeriods[0].setName(rst.getString(3));
                bgPeriods[0].setPeriodType(BgPeriodEnum.getEnum((int)periodType));
                bgPeriods[0].setBeginDate((Date)rst.getDate(4));
                bgPeriods[0].setEndDate((Date)rst.getDate(5));
            }
            SQLUtils.cleanup((ResultSet)rst);
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select top 1 FID, FNumber, FName_" + ctx.getLocale() + ", FBeginDate, FEndDate from T_MBG_BgPeriod where FBeginDate >= ? and FEndDate <= ? and FPeriodType = ? order by FNumber DESC"), (Object[])new Object[]{begin, end, periodType});
            if (rst.next()) {
                bgPeriods[1] = new BgPeriodInfo();
                bgPeriods[1].setId(BOSUuid.read((String)rst.getString(1)));
                bgPeriods[1].setNumber(rst.getString(2));
                bgPeriods[1].setName(rst.getString(3));
                bgPeriods[1].setPeriodType(BgPeriodEnum.getEnum((int)periodType));
                bgPeriods[1].setBeginDate((Date)rst.getDate(4));
                bgPeriods[1].setEndDate((Date)rst.getDate(5));
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, new Object[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, pstmt, (Connection)conn);
        return bgPeriods;
    }

    @Override
    protected Object _analyseData(Context ctx, String analyseId) throws BOSException {
        AnalyseDataFacade facade = new AnalyseDataFacade();
        return facade.getDataProvider(analyseId, ctx);
    }
}

