/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNumberHelper;
import com.kingdee.eas.ma.base.utils.ICopyDataProcessor;
import com.kingdee.eas.ma.mbg.DimSrcTypeEnum;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionPropSrcInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.Mbg820To850UpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgUpdateFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractMbg820To850UpdateFacadeControllerBean;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.CubeConstants;
import com.kingdee.eas.ma.mbg.cube.impl.CubeManager;
import com.kingdee.eas.ma.mbg.update.common.MbgUpdateHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820CacheHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.impl.MbgUpdate820ExecuteHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdate820CopyDataProcessor;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820ConfigInfo;
import com.kingdee.eas.ma.mbg.update820to850.common.MbgUpdate820MemberInfo;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class Mbg820To850UpdateFacadeControllerBean
extends AbstractMbg820To850UpdateFacadeControllerBean {
    private static final long serialVersionUID = 2886175670475277194L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.Mbg820To850UpdateFacadeControllerBean");

    @Override
    protected boolean _checkUpdated(Context ctx) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("select count(FID) FROM T_MBG_BgScheme");
            rst = pstmt.executeQuery();
            if (!rst.next() || rst.getInt(1) == 0) {
                boolean bl = true;
                return bl;
            }
            pstmt = conn.prepareStatement("select count(FID) FROM T_MBG_BgDimSettings");
            rst = pstmt.executeQuery();
            if (rst.next() && rst.getInt(1) > 0) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return false;
    }

    @Override
    protected MbgUpdate820ConfigInfo _initConfig(Context ctx) throws BOSException, EASBizException {
        MbgUpdate820ConfigInfo config = new MbgUpdate820ConfigInfo();
        this.initDimensionSource(ctx, config);
        return config;
    }

    private void initDimensionSource(Context ctx, MbgUpdate820ConfigInfo config) throws BOSException, EASBizException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            conn = this.getConnection(ctx);
            HashMap<String, DimensionInfo> dimensionMap = new HashMap<String, DimensionInfo>();
            HashMap<String, DimensionSourceInfo> sourceMap = new HashMap<String, DimensionSourceInfo>();
            DimensionInfo dimension = null;
            DimensionSourceInfo source = null;
            DimensionPropSrcInfo prop = null;
            String id = null;
            String pId = null;
            pstmt = conn.prepareStatement("Select FID, FNumber, FDimNumber, FName_l1, FName_l2, FName_l3, FRefField FROM T_MBG_Dim");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                dimension = new DimensionInfo();
                id = rst.getString("FID");
                dimension.setId(BOSUuid.read((String)id));
                dimension.setNumber(rst.getString("FNumber"));
                config.getDimensions().put(dimension.getNumber(), dimension);
                dimensionMap.put(id, dimension);
                dimension.setDimNumber(rst.getString("FDimNumber"));
                dimension.setName(rst.getString("FName_l1"), LocaleUtils.locale_L1);
                dimension.setName(rst.getString("FName_l2"), LocaleUtils.locale_L2);
                dimension.setName(rst.getString("FName_l3"), LocaleUtils.locale_L3);
                dimension.setRefField(rst.getString("FRefField"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("Select FID, FDimId, FSrcTyp, FSrcId, FSrcTable, FOrder, FLevelRange, FSrcNumber, FIsWebSelect FROM T_MBG_DimSrc Order By FOrder");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                source = new DimensionSourceInfo();
                id = rst.getString("FID");
                pId = rst.getString("FDimId");
                sourceMap.put(id, source);
                source.setId(BOSUuid.read((String)id));
                source.setDimension((DimensionInfo)dimensionMap.get(pId));
                source.getDimension().getSrcs().add(source);
                source.setSrcType(DimSrcTypeEnum.getEnum(rst.getInt("FSrcTyp")));
                source.setSrcID(rst.getString("FSrcId"));
                source.setSrcTable(rst.getString("FSrcTable"));
                source.setOrder(rst.getInt("FOrder"));
                source.setLevelRange(rst.getInt("FLevelRange"));
                source.setSrcNumber(rst.getString("FSrcNumber"));
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            pstmt = conn.prepareStatement("Select FID, FDimSrcId, FDimSrcPropName, FDimSrcFieldName, FDimPropName_L1, FDimPropName_L2, FDimPropName_L3, FDimSrcPropIsMultilang, FOrder FROM T_MBG_DimPropSrc");
            rst = pstmt.executeQuery();
            while (rst.next()) {
                prop = new DimensionPropSrcInfo();
                id = rst.getString("FID");
                pId = rst.getString("FDimSrcId");
                prop.setId(BOSUuid.read((String)id));
                prop.setSource((DimensionSourceInfo)sourceMap.get(pId));
                prop.getSource().getProperties().add(prop);
                prop.setDimSrcPropName(rst.getString("FDimSrcPropName"));
                prop.setDimSrcFieldName(rst.getString("FDimSrcFieldName"));
                prop.setDimPropName(rst.getString("FDimPropName_L1"), LocaleUtils.locale_L1);
                prop.setDimPropName(rst.getString("FDimPropName_L2"), LocaleUtils.locale_L2);
                prop.setDimPropName(rst.getString("FDimPropName_L3"), LocaleUtils.locale_L3);
                prop.setDimSrcPropIsMultiLang(rst.getBoolean("FDimSrcPropIsMultilang"));
                prop.setOrder(rst.getInt("FOrder"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List _loadMembers(Context ctx, IObjectCollection sources) throws BOSException, EASBizException {
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        ArrayList<MbgUpdate820MemberInfo> members;
        block13: {
            members = new ArrayList<MbgUpdate820MemberInfo>();
            if (sources == null) return members;
            if (sources.isEmpty()) {
                return members;
            }
            Map<String, DimensionSourceInfo> sourceMap = this.getSourceMap(sources);
            conn = null;
            pstmt = null;
            rst = null;
            String tempTable = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                tempTable = MbgUpdate820ExecuteHelper.createMembersTable(pool);
                MbgUpdate820ExecuteHelper.readMembers(conn, tempTable, sources, false);
                MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempTable + " Where FNumber <> FDimNumber AND FNumber <> (FDimNumber || '-01') AND (FDimNumber || '_' || FNumber) IN(Select FDimNumber || '_' || FNumber FROM " + tempTable + " Group By FNumber, FDimNumber Having Count(FNumber) = 1)"));
                MbgUpdate820MemberInfo member = null;
                pstmt = conn.prepareStatement("Select FNumber, FName_L1, FName_L2, FName_L3, FSourceId FROM " + tempTable + " Order By FNumber, FDimNumber, FSourceOrder");
                rst = pstmt.executeQuery();
                int index = 0;
                String lastNumber = null;
                while (rst.next()) {
                    member = new MbgUpdate820MemberInfo();
                    member.setNumber(rst.getString("FNumber"));
                    member.setName_l1(rst.getString("FName_L1"));
                    member.setName_l2(rst.getString("FName_L2"));
                    member.setName_l3(rst.getString("FName_L3"));
                    member.setNewName_l1(member.getName_l1());
                    member.setNewName_l2(member.getName_l2());
                    member.setNewName_l3(member.getName_l3());
                    member.setSource(sourceMap.get(rst.getString("FSourceId")));
                    if (!member.getNumber().equals(lastNumber)) {
                        member.setNewNumber(member.getNumber());
                        index = 0;
                    } else {
                        member.setNewNumber(member.getNumber() + index);
                    }
                    lastNumber = member.getNumber();
                    ++index;
                    members.add(member);
                }
                if (tempTable == null) break block13;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tempTable != null) {
                        try {
                            pool.releaseTable(tempTable);
                        }
                        catch (Exception e2) {
                            logger.error((Object)"", (Throwable)e2);
                        }
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseTable(tempTable);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return members;
    }

    private Map<String, DimensionSourceInfo> getSourceMap(IObjectCollection sources) {
        HashMap<String, DimensionSourceInfo> sourceMap = new HashMap<String, DimensionSourceInfo>();
        DimensionSourceInfo source = null;
        for (int i = 0; i < sources.size(); ++i) {
            source = (DimensionSourceInfo)sources.getObject(i);
            sourceMap.put(source.getId().toString(), source);
        }
        return sourceMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String _verifyMembers(Context ctx, IObjectCollection sources, List members, String type) throws BOSException, EASBizException {
        String string;
        ResultSet rst;
        PreparedStatement pstmt;
        Connection conn;
        block17: {
            if (sources == null || sources.isEmpty() || members == null || members.isEmpty()) {
                return null;
            }
            conn = null;
            pstmt = null;
            rst = null;
            String tempTable = null;
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            try {
                conn = this.getConnection(ctx);
                ArrayList<DimensionSourceInfo> alias = new ArrayList<DimensionSourceInfo>();
                MbgUpdate820MemberInfo member = null;
                for (int i = 0; i < members.size(); ++i) {
                    member = (MbgUpdate820MemberInfo)members.get(i);
                    alias.add(member.getSource());
                }
                DimensionCommonHelper.loadSourceNameInfo(ctx, alias);
                tempTable = MbgUpdate820ExecuteHelper.createMembersTable(pool);
                MbgUpdate820ExecuteHelper.readMembers(conn, tempTable, sources, false);
                MbgUpdate820ExecuteHelper.convertNumberName(conn, tempTable, members, false);
                String dimNumber = null;
                HashMap repeatNumber = new HashMap();
                pstmt = conn.prepareStatement("Select FNewNumber, FDimNumber FROM " + tempTable + " Group By FNewNumber, FDimNumber Having Count(FNewNumber) > 1");
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    dimNumber = rst.getString("FDimNumber");
                    if (!repeatNumber.containsKey(dimNumber)) {
                        repeatNumber.put(dimNumber, new HashSet());
                    }
                    ((Set)repeatNumber.get(dimNumber)).add(rst.getString("FNewNumber"));
                }
                StringBuffer detailMsg = new StringBuffer();
                String numberErrot = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)MbgUpdateHelper.getMsgKey("importNumberError", type), (Locale)ctx.getLocale());
                String numberRepeat = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)MbgUpdateHelper.getMsgKey("checkNumberRepeat", type), (Locale)ctx.getLocale());
                for (int i = 0; i < members.size(); ++i) {
                    member = (MbgUpdate820MemberInfo)members.get(i);
                    dimNumber = member.getSource().getDimension().getNumber();
                    if (!BgNumberHelper.checkNumber((String)member.getNewNumber())) {
                        if (detailMsg.length() > 0) {
                            detailMsg.append("\r\n");
                        }
                        detailMsg.append(MessageFormat.format(numberErrot, i + 1, member.getNewNumber(), member.getSource().getAlias()));
                        continue;
                    }
                    if (!repeatNumber.containsKey(MbgUpdate820CacheHelper.convertMbgDimNumber(dimNumber)) || !((Set)repeatNumber.get(MbgUpdate820CacheHelper.convertMbgDimNumber(dimNumber))).contains(member.getNewNumber())) continue;
                    if (detailMsg.length() > 0) {
                        detailMsg.append("\r\n");
                    }
                    detailMsg.append(MessageFormat.format(numberRepeat, i + 1, member.getNewNumber(), member.getSource().getAlias()));
                }
                string = detailMsg.toString();
                if (tempTable == null) break block17;
            }
            catch (Exception e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (tempTable != null) {
                        try {
                            pool.releaseTable(tempTable);
                        }
                        catch (Exception e2) {
                            logger.error((Object)"", (Throwable)e2);
                        }
                    }
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    throw throwable;
                }
            }
            try {
                pool.releaseTable(tempTable);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        return string;
    }

    @Override
    protected void _executeUpdate(Context ctx, MbgUpdate820ConfigInfo config) throws BOSException, EASBizException {
        MbgUpdateFacadeFactory.getLocalInstance(ctx).processClear();
        MbgUpdate820CacheHelper helper = new MbgUpdate820CacheHelper(ctx, config);
        helper.initCacheHelper();
        Mbg820To850UpdateFacadeFactory.getLocalInstance(ctx).innerUpdate(helper);
        MbgUpdate820ExecuteHelper.afterUpdate(ctx, helper);
    }

    @Override
    protected void _innerUpdate(Context ctx, Object cacheHelper) throws BOSException, EASBizException {
        MbgUpdate820ExecuteHelper._executeUpdate(ctx, (MbgUpdate820CacheHelper)cacheHelper);
    }

    @Override
    protected void _reSetData(Context ctx, String solution, String ais) throws BOSException {
        boolean is850 = false;
        try {
            is850 = this._checkUpdated(ctx);
        }
        catch (EASBizException e1) {
            e1.printStackTrace();
        }
        if (is850) {
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgTemplateNode");
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgDimSettings");
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgDimSettingsMember");
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BizCalcSubset");
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BizRefBgTemplate");
            DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgAccountSort");
        }
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_MbgDim");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_MbgView");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_MbgMember");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgAccountView");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgAccount");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgOrgView");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgOrgUnit");
        DbUtil.execute((Context)ctx, (String)"Delete FROM T_MBG_BgPeriodDisp");
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.add("T_MBG_Dim");
        tableNames.add("T_MBG_DimSrc");
        tableNames.add("T_MBG_DIMEXPRESSION");
        tableNames.add("T_MBG_DIMPROPSRC");
        tableNames.add("T_MBG_DIMPROP");
        tableNames.add("T_MBG_BGSCENARIO");
        tableNames.add("T_MBG_BGVERSION");
        tableNames.add("T_MBG_BgPastData");
        tableNames.add("T_MBG_BgPastRecord");
        tableNames.add("T_MBG_BgIndexSort");
        tableNames.add("T_MBG_BgControlOrgEntrust");
        tableNames.add("T_MBG_BgPeriod");
        tableNames.add("T_MBG_BgPeriodType");
        tableNames.add("T_MBG_BgPeriodDisp");
        tableNames.add("T_MBG_BgSchemeType");
        tableNames.add("T_MBG_BgScheme");
        tableNames.add("T_MBG_BgSchemeNode");
        tableNames.add("T_MBG_BGSCHEMEREFDIM");
        tableNames.add("T_MBG_BGSCHEMEREFMEMBER");
        tableNames.add("T_MBG_BgFormEntry");
        tableNames.add("T_MBG_BGControlScheme");
        tableNames.add("T_MBG_BgItem");
        tableNames.add("T_MBG_BgItemGroup");
        tableNames.add("T_MBG_BGELEMENT");
        tableNames.add("T_MBG_BizCalc");
        tableNames.add("T_MBG_BizCalcRule");
        tableNames.add("T_MBG_BizCalcSchemeRelation");
        tableNames.add("T_MBG_BizRefBgTemplate");
        tableNames.add("T_MBG_BizRely");
        tableNames.add("T_MBG_BizScope");
        tableNames.add("T_MBG_BizTmpRelation");
        tableNames.add("T_MBG_BizRelationDist");
        tableNames.add("T_MBG_BgOrgView");
        tableNames.add("T_MBG_BgOrgUnit");
        tableNames.add("T_MBG_DimensionRelationship");
        tableNames.add("T_MBG_DimensionRelationGroup");
        tableNames.add("T_MBG_DIMRELASHIPGROUPENTRY");
        tableNames.add("T_MBG_BgTemplate");
        tableNames.add("T_MBG_BgViewDimension");
        tableNames.add("T_MBG_BgForm");
        tableNames.add("T_MBG_BgAdjustBill");
        tableNames.add("T_MBG_BgAdjustBillEntry");
        tableNames.add("T_MBG_BGACTUALRECORD");
        tableNames.add("T_MBG_BGControlRule");
        tableNames.add("T_MBG_BGControlItemMapEntry");
        tableNames.add("T_MBG_BgControlItemMap");
        tableNames.add("T_MBG_BGCONTROLSETSCHEME");
        tableNames.add("T_MBG_BGCONTROLSETTING");
        tableNames.add("T_MBG_BgTmpData");
        tableNames.add("T_MBG_BGDATAASSIST");
        tableNames.add("T_MBG_BGDATAASSISTENTRY");
        Context sourceCtx = new Context(ctx.getCaller(), solution, ais, ctx.getLocale());
        IRowSet rst = null;
        String refCube2 = null;
        String bgDimNumber = null;
        HashMap refDims = new HashMap();
        try {
            rst = DbUtil.executeQuery((Context)sourceCtx, (String)"Select bgScheme.FRefCube, refDim.FBgDimNumber FROM T_MBG_BGSCHEMEREFDIM refDim Inner Join T_MBG_BgScheme bgScheme ON refDim.FBgSchemeId = bgScheme.FID");
            while (rst.next()) {
                refCube2 = rst.getString("FRefCube");
                if (!refDims.containsKey(refCube2)) {
                    refDims.put(refCube2, new HashSet());
                }
                bgDimNumber = rst.getString("FBgDimNumber");
                ((Set)refDims.get(refCube2)).addAll(Arrays.asList((Object[])bgDimNumber.split(";")));
            }
            SQLUtils.cleanup((ResultSet)rst);
            ArrayList<String> refields = new ArrayList<String>();
            for (String refCube2 : refDims.keySet()) {
                String actualCube;
                refields.clear();
                refields.addAll((Collection)refDims.get(refCube2));
                Collections.sort(refields);
                if (BgDBUtils.existTable((Context)ctx, (String)refCube2) == BgDBUtils.YES) {
                    CubeManager.getInstance().getCubeFacade().dropCube(ctx, refCube2);
                }
                if (BgDBUtils.existTable((Context)ctx, (String)(actualCube = refCube2.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL))) == BgDBUtils.YES) {
                    BgDBUtils.dropTable((Context)ctx, (String)actualCube);
                }
                CubeManager.getInstance().getCubeFacade().checkCubeHasActual(ctx, refCube2, refields);
                tableNames.add(refCube2);
                tableNames.add(BgCubeUtils.getBudgetEntryCubeName(refCube2));
                tableNames.add(BgCubeUtils.getControlCubeName(refCube2));
                tableNames.add(BgCubeUtils.getDailyActualCubeName(refCube2));
                tableNames.add(BgCubeUtils.getDailyActualEntryCubeName(refCube2));
                tableNames.add(refCube2.toUpperCase().replaceAll(CubeConstants.BASE_REPLACE_KEY, CubeConstants.BASE_ACTUAL));
                tableNames.add(BgCubeUtils.getActualEntryCubeName(refCube2));
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        MetaDataFacadeFactory.getLocalInstance((Context)ctx).copyData(solution, ais, tableNames, true, (ICopyDataProcessor)new MbgUpdate820CopyDataProcessor());
    }

    @Override
    protected List _checkHasAdjust(Context ctx) throws BOSException {
        ArrayList<String> result = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            this.check(ctx, conn, "Select adjBill.FNumber, orgUnit.FNumber, orgUnit.FName_" + ctx.getLocale() + ", bgScheme.FNumber FROM T_MBG_BGAdjustBill adjBill Inner Join T_ORG_BaseUnit orgUnit ON orgUnit.FID = adjBill.FOrgUnit Inner Join T_MBG_BgScheme bgScheme ON bgScheme.FID = adjBill.FBgScheme Where adjBill.FState <> 4 AND adjBill.FType IN(2,3) Order By orgUnit.FNumber, bgScheme.FNumber, adjBill.FNumber", "checkAdjustBill", result);
            this.check(ctx, conn, "Select adjBill.FNumber, orgUnit.FNumber, orgUnit.FName_" + ctx.getLocale() + ", bgScheme.FNumber FROM T_MBG_BGAdjustBill adjBill Inner Join T_ORG_BaseUnit orgUnit ON orgUnit.FID = adjBill.FOrgUnit Inner Join T_MBG_BgScheme bgScheme ON bgScheme.FID = adjBill.FBgScheme Where adjBill.FState <> 4 AND adjBill.FType IN(0,1) Order By orgUnit.FNumber, bgScheme.FNumber, adjBill.FNumber", "checkAdjustBill1", result);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check(Context ctx, Connection conn, String sql, String msgKey, List<String> result) throws SQLException {
        MessageFormat format = new MessageFormat(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgUpdate820Resource", (String)msgKey, (Locale)ctx.getLocale()));
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                result.add(format.format(new Object[]{rst.getString(1), rst.getString(2), rst.getString(3), rst.getString(4)}));
            }
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
    }

    @Override
    protected String _getPeriodType(Context ctx, String bgTemplateId) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _repairData(Context ctx, String bgTemplateId, boolean isRepairData, String sourceTypeNumber, String targetTypeNumber) throws BOSException, EASBizException {
        MbgUpdate820ExecuteHelper.repairData(ctx, bgTemplateId, isRepairData, sourceTypeNumber, targetTypeNumber);
    }
}

