/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.ZipUtil;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.ma.mbg.app.AbstractMbgConvertExcelFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.MbgVirtualCoreUI;
import com.kingdee.eas.ma.mbg.common.XSSFConvertHelper;
import com.kingdee.eas.ma.mbg.convertexcel.IConvertExcelProvider;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class MbgConvertExcelFacadeControllerBean
extends AbstractMbgConvertExcelFacadeControllerBean {
    private static final long serialVersionUID = 1480213286955932861L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgConvertExcelFacadeControllerBean");

    @Override
    public Object _convert(Context ctx, BOSUuid bgFormId) throws BOSException, EASBizException {
        logger.error((Object)("MbgConvertExcelFacadeControllerBean _convert Start bgFormId:" + bgFormId));
        if (bgFormId == null) {
            return null;
        }
        if (!"3BA5F027".equals(bgFormId.getType().toString()) && !"655ADD42".equals(bgFormId.getType().toString())) {
            return null;
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(bgFormId.toString());
        Map resultMap = this._convert(ctx, ids);
        if (resultMap != null && resultMap.containsKey(bgFormId.toString())) {
            Book book = (Book)resultMap.get(bgFormId.toString());
            XSSFConvertHelper helper = new XSSFConvertHelper();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                XSSFWorkbook xssfbook = helper.getXSSFBook(book);
                xssfbook.write((OutputStream)bos);
                logger.error((Object)("MbgConvertExcelFacadeControllerBean _convert End bgFormId:" + bgFormId));
                byte[] byArray = ZipUtil.pack((ByteArrayOutputStream)bos);
                return byArray;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public Map _convert(Context ctx, List bgFormIds) throws BOSException, EASBizException {
        HashMap<String, Book> bookMap = new HashMap<String, Book>();
        if (bgFormIds == null || bgFormIds.isEmpty()) {
            return bookMap;
        }
        MbgVirtualCoreUI ownerUI = new MbgVirtualCoreUI();
        LinkedHashMap<String, IDimDataQuery> bgFormInfoMap = MbgConvertExcelFacadeControllerBean.getDimDataQueryMap(ctx, bgFormIds);
        if (bgFormInfoMap.isEmpty()) {
            return bookMap;
        }
        for (IDimDataQuery info : bgFormInfoMap.values()) {
            bookMap.put(info.getId().toString(), this.convert(ctx, ownerUI, info));
        }
        return bookMap;
    }

    protected Book convert(Context ctx, CoreUIObject ownerUI, IDimDataQuery info) throws BOSException, EASBizException {
        try {
            info = info.getInfo(ctx, info.getId());
            logger.error((Object)("MbgConvertExcelFacadeControllerBean convert Start info:" + info + ", id:" + info.getId()));
            IConvertExcelProvider provider = info.getConvertProvider();
            provider.setOwner(ownerUI);
            Book book = provider.convert(ctx, info);
            logger.error((Object)("MbgConvertExcelFacadeControllerBean convert End info:" + info + ", id:" + info.getId()));
            return book;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static LinkedHashMap<String, IDimDataQuery> getDimDataQueryMap(Context ctx, List<String> formIds) {
        LinkedHashMap<String, IDimDataQuery> bgFormMap = new LinkedHashMap<String, IDimDataQuery>();
        HashMap bosTypeIds = new HashMap();
        for (String id : formIds) {
            String bosType = BOSUuid.read((String)id).getType().toString();
            if (!bosTypeIds.containsKey(bosType)) {
                bosTypeIds.put(bosType, new HashSet());
            }
            ((Set)bosTypeIds.get(bosType)).add(id);
        }
        for (String bosType : bosTypeIds.keySet()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", bosTypeIds.get(bosType), CompareType.INCLUDE));
            SorterItemCollection sort = new SorterItemCollection();
            sort.add(new SorterItemInfo("number"));
            evi.setSorter(sort);
            try {
                CoreBaseCollection colls = ((ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType))).getCollection(evi);
                for (int index = 0; index < colls.size(); ++index) {
                    bgFormMap.put(colls.get(index).getId().toString(), (IDimDataQuery)colls.get(index));
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return bgFormMap;
    }
}

