/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgDataStateEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultEnum;
import com.kingdee.eas.ma.mbg.BgFinalizedResultFactory;
import com.kingdee.eas.ma.mbg.BgFinalizedResultInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IBgFinalizedResult;
import com.kingdee.eas.ma.mbg.app.AbstractMbgDataStateSynFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.data.BizDataControlUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataStateSynFacadeControllerBean
extends AbstractMbgDataStateSynFacadeControllerBean {
    private static final long serialVersionUID = 8214185265922766997L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgDataStateSynFacadeControllerBean");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected IObjectCollection _queryBgForm(Context ctx, String bgSchemeId, Set bgOrgUnitIds, Set bgTemplateIds, Set bgPeriodIds, Set bgVersionIds, Set currencyIds, BgFormStateEnum bgFormState) throws BOSException, EASBizException {
        boolean orgIndex = false;
        boolean bgTemplateIndex = true;
        int bgPeriodIndex = 2;
        int bgVersionIndex = 3;
        int curencyIndex = 4;
        BgFormCollection result = new BgFormCollection();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String tmpTable = null;
        try {
            conn = this.getConnection(ctx);
            tmpTable = pool.createTempTable("Create Table T_MBG_IDIndex(FIndex INT NOT NULL, FID Varchar(44) NOT NULL, FSourceId Varchar(44) NOT NULL, FLongNumber NVarchar(200), FMinSourceID Varchar(44))");
            pool.createIndex(tmpTable, "FIndex,FID,FSourceId", true, true);
            ArrayList<Object> paramList = new ArrayList<Object>();
            paramList.clear();
            paramList.add(bgSchemeId);
            String orgViewId = MbgViewListFormServerHelper.getBgViewIdBySchemeId(ctx, BOSUuid.read((String)bgSchemeId)).toString();
            if (StringUtils.isEmpty((String)orgViewId)) {
                BgFormCollection bgFormCollection = result;
                return bgFormCollection;
            }
            this.insertIntoTmpTable(conn, tmpTable, bgOrgUnitIds, 0, paramList);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FID = (Select FOrgUnitId FROM T_MBG_BgOrgUnit t1 Where t0.FSourceId = t1.FID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FLongNumber = (Select FLongNumber FROM T_MBG_BgOrgUnit t1 Where t0.FSourceId = t1.FID)"));
            paramList.clear();
            pstmt = conn.prepareStatement("Select FSourceId, FLongNumber FROM " + tmpTable + " Order By FLongNumber");
            rst = pstmt.executeQuery();
            HashSet<String> numbers = new HashSet<String>();
            String[] lns = null;
            while (rst.next()) {
                lns = rst.getString("FLongNumber").split("!");
                if (lns.length >= 1) {
                    boolean exist = false;
                    for (int l = 0; l < lns.length - 1; ++l) {
                        if (!numbers.contains(lns[l])) continue;
                        exist = true;
                        break;
                    }
                    if (exist) continue;
                }
                numbers.add(lns[lns.length - 1]);
                paramList.add(new Object[]{0, rst.getString("FSourceId"), orgViewId, rst.getString("FLongNumber") + "!%"});
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpTable + "(FIndex, FID, FSourceId) Select ?, FOrgUnitId, ? FROM T_MBG_BgOrgUnit t0 Where t0.FViewId = ? AND t0.FLongNumber Like ?"), paramList);
            this.insertIntoTmpTable(conn, tmpTable, bgTemplateIds, 1, paramList);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FID = (Select FRootId FROM T_MBG_BgTemplate t1 Where t0.FSourceId = t1.FID) Where FIndex = " + 1));
            this.insertIntoTmpTable(conn, tmpTable, bgPeriodIds, 2, paramList);
            this.insertIntoTmpTable(conn, tmpTable, bgVersionIds, 3, paramList);
            this.insertIntoTmpTable(conn, tmpTable, currencyIds, 4, paramList);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tmpTable + " t0 Set FMinSourceID = (Select MIN(t1.FSourceID) FROM " + tmpTable + " t1 Where t0.FID = t1.FID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Delete " + tmpTable + " Where FSourceID <> FMinSourceID"));
            StringBuffer sql = new StringBuffer();
            sql.append("Select bgForm.FID bgForm_FID, bgForm.FNumber bgForm_FNumber, bgForm.FName bgForm_FName, bgForm.FState bgForm_FState, scheme.FID scheme_FID, scheme.FRefCube scheme_FRefCube, org.FOrgUnitID org_FOrgUnitID, org.FNumber org_FNumber, org.FName_").append(ctx.getLocale()).append(" org_FName, bgTemplate.FName bgTemplate_FName, ").append("bgPeriod.FName_").append(ctx.getLocale()).append(" bgPeriod_FName, bgVersion.FName_").append(ctx.getLocale()).append(" bgVersion_FName, bgCurrency.FName_").append(ctx.getLocale()).append(" bgCurrency_FName ").append(" FROM T_MBG_BgForm bgForm ").append(" Inner Join T_MBG_BgScheme scheme ON scheme.FID = bgForm.FBgSchemeId ").append(" Inner Join T_MBG_BgOrgUnit org ON org.FOrgUnitID = bgForm.FOrgUnitId ").append(" Inner Join T_MBG_BgTemplate bgTemplate ON bgTemplate.FID = bgForm.FBgTemplateId").append(" Inner Join T_MBg_BgPeriod bgPeriod ON bgPeriod.FID = bgForm.FBgPeriodId").append(" Inner Join T_MBg_BgVersion bgVersion ON bgVersion.FID = bgForm.FBgVersionId").append(" Inner Join T_BD_Currency bgCurrency ON bgCurrency.FID = bgForm.FCurrencyId");
            sql.append(" Where bgForm.FState = ?");
            sql.append(" AND bgForm.FBgSchemeId = ?");
            sql.append(" AND org.FViewId = ?");
            sql.append(" AND bgForm.FOrgUnitId IN(Select FID FROM ").append(tmpTable).append(" Where FIndex = ").append(0).append(")");
            if (bgTemplateIds != null && !bgTemplateIds.isEmpty()) {
                sql.append(" AND bgTemplate.FRootId IN(Select FID FROM ").append(tmpTable).append(" Where FIndex = ").append(1).append(")");
            }
            if (bgPeriodIds != null && !bgPeriodIds.isEmpty()) {
                sql.append(" AND bgForm.FBgPeriodId IN(Select FID FROM ").append(tmpTable).append(" Where FIndex = ").append(2).append(")");
            }
            if (bgVersionIds != null && !bgVersionIds.isEmpty()) {
                sql.append(" AND bgForm.FBgVersionId IN(Select FID FROM ").append(tmpTable).append(" Where FIndex = ").append(3).append(")");
            }
            if (currencyIds != null && !currencyIds.isEmpty()) {
                sql.append(" AND bgForm.FCurrencyId IN(Select FID FROM ").append(tmpTable).append(" Where FIndex = ").append(4).append(")");
            }
            sql.append(" AND bgVersion.FIsRollVersion <> 1 ");
            sql.append(" Order By org.FLongNumber, bgTemplate.FNumber, bgPeriod.FNumber, bgVersion.FNumber, bgCurrency.FNumber");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setInt(1, bgFormState.getValue());
            pstmt.setString(2, bgSchemeId);
            pstmt.setString(3, orgViewId);
            rst = pstmt.executeQuery();
            BgFormInfo info = null;
            HashSet<String> check = new HashSet<String>();
            while (rst.next()) {
                info = new BgFormInfo();
                info.setId(BOSUuid.read((String)rst.getString("bgForm_FID")));
                info.setNumber(rst.getString("bgForm_FNumber"));
                info.setName(rst.getString("bgForm_FName"));
                info.setState(BgFormStateEnum.getEnum(rst.getInt("bgForm_FState")));
                info.setBgScheme(new BgSchemeInfo());
                info.getBgScheme().setId(BOSUuid.read((String)rst.getString("scheme_FID")));
                info.getBgScheme().setRefCube(rst.getString("scheme_FRefCube"));
                info.setOrgUnit(new FullOrgUnitInfo());
                info.getOrgUnit().setId(BOSUuid.read((String)rst.getString("org_FOrgUnitID")));
                info.getOrgUnit().setName(rst.getString("org_FName"));
                info.getOrgUnit().setNumber(rst.getString("org_FNumber"));
                info.setBgTemplate(new BgTemplateInfo());
                info.getBgTemplate().setName(rst.getString("bgTemplate_FName"));
                info.setBgPeriod(new BgPeriodInfo());
                info.getBgPeriod().setName(rst.getString("bgPeriod_FName"));
                info.setBgVersion(new BgVersionInfo());
                info.getBgVersion().setName(rst.getString("bgVersion_FName"));
                info.setCurrency(new CurrencyInfo());
                info.getCurrency().setName(rst.getString("bgCurrency_FName"));
                if (check.contains(info.getId().toString()) || info.getBgVersion().isIsRollVersion()) continue;
                check.add(info.getId().toString());
                result.addObject((IObjectValue)info);
            }
            SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
            if (tmpTable == null) return result;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
            if (tmpTable != null) {
                pool.releaseTable(tmpTable);
            }
        }
        pool.releaseTable(tmpTable);
        return result;
    }

    private void insertIntoTmpTable(Connection conn, String tmpTable, Set ids, int index, List paramList) throws SQLException {
        if (ids == null || ids.isEmpty()) {
            return;
        }
        paramList.clear();
        for (Object id : ids) {
            paramList.add(new Object[]{index, id, id});
        }
        MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tmpTable + "(FIndex, FID, FSourceId) Values(?, ?, ?)"), (List)paramList);
    }

    @Override
    protected void _executeSyn(Context ctx, String bgFormId) throws BOSException, EASBizException {
        BizDataControlUtils utils = new BizDataControlUtils(ctx);
        utils.synDataState(ctx, bgFormId);
    }

    @Override
    protected Set _queryBgOrgIds(Context ctx, IObjectValue bgScheme, List bgOrgUnitMembers) throws BOSException, EASBizException {
        HashSet<String> ids = new HashSet<String>();
        try {
            if (bgScheme != null && bgOrgUnitMembers != null && !bgOrgUnitMembers.isEmpty()) {
                BgSchemeInfo bgSchemeInfo = (BgSchemeInfo)bgScheme;
                bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeInfo.getId());
                BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgSchemeInfo.getId().toString());
                query.setSchemeInfo(bgSchemeInfo);
                query.setMbgColls(DimUtils.getDimensionColls(ctx));
                HashSet<String> orgNums = new HashSet<String>();
                BgDimensionMember member = null;
                for (int i = 0; i < bgOrgUnitMembers.size(); ++i) {
                    if (!(bgOrgUnitMembers.get(i) instanceof BgDimensionMember)) continue;
                    member = (BgDimensionMember)bgOrgUnitMembers.get(i);
                    if (0 == member.getFillType()) {
                        orgNums.add(member.getNumber());
                        continue;
                    }
                    query.addQueryMember(DimensionConstants.DEF_ORGUNIT_FIELD, member.getNumber(), member.getFillType(), BizMemberQuery.QUERY_ALL);
                }
                Map membersMap = query.queryMember();
                if (membersMap != null && !membersMap.isEmpty()) {
                    String numKey2 = null;
                    List membersLst = null;
                    for (String numKey2 : membersMap.keySet()) {
                        membersLst = (List)membersMap.get(numKey2);
                        if (membersLst.isEmpty()) continue;
                        for (IMember im : membersLst) {
                            orgNums.add(im.getNumber());
                        }
                    }
                }
                if (!orgNums.isEmpty()) {
                    EntityViewInfo view = new EntityViewInfo();
                    view.setSelector(new SelectorItemCollection());
                    view.getSelector().add("id");
                    view.getSelector().add("number");
                    view.getSelector().add("name");
                    view.setFilter(new FilterInfo());
                    view.getFilter().getFilterItems().add(new FilterItemInfo("viewID", (Object)bgSchemeInfo.getEditOrgViewId().toString(), CompareType.EQUALS));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("number", orgNums, CompareType.INCLUDE));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
                    view.getFilter().getFilterItems().add(new FilterItemInfo("isLeaf", (Object)1, CompareType.EQUALS));
                    BgOrgUnitCollection bgOrgColls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
                    if (bgOrgColls != null && !bgOrgColls.isEmpty()) {
                        for (int i = 0; i < bgOrgColls.size(); ++i) {
                            ids.add(bgOrgColls.get(i).getId().toString());
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    @Override
    protected Object _executeSynNew(Context ctx, IObjectCollection bgFormColls, IObjectValue info) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (bgFormColls == null || bgFormColls.isEmpty() || info == null) {
            return result;
        }
        long ct1 = System.currentTimeMillis();
        String resClassName = "com.kingdee.eas.ma.mbg.MbgDataStateSynResource";
        Locale locale = ctx.getLocale();
        UserInfo user = ContextUtil.getCurrentUserInfo((Context)ctx);
        BgFinalizedResultInfo resultInfo = (BgFinalizedResultInfo)info;
        IBgFinalizedResult iBgFinalizedResult = BgFinalizedResultFactory.getLocalInstance(ctx);
        try {
            BgFormInfo bgFormInfo = null;
            BgSchemeInfo bgSchemeInfo = null;
            String cubeName = null;
            String cubeEntry = null;
            FullOrgUnitInfo orgInfo = null;
            int index = 1;
            for (int i = 0; i < bgFormColls.size(); ++i) {
                bgFormInfo = (BgFormInfo)bgFormColls.getObject(i);
                bgSchemeInfo = bgFormInfo.getBgScheme();
                orgInfo = bgFormInfo.getOrgUnit();
                BgDataStateEnum state = BgFormStateEnum.Approved.equals((Object)bgFormInfo.getState()) ? BgDataStateEnum.Approved : BgDataStateEnum.UnionReceive;
                int[] dataStates = this.getDataStates(state);
                cubeName = BgCubeUtils.getCubeName(bgSchemeInfo.getRefCube(), bgFormInfo.getProcessType());
                cubeEntry = BgCubeUtils.getEntryCubeName(cubeName, bgFormInfo.getProcessType());
                String sql = "update " + cubeName + " set FState = ?, FAudOrgUnitID = FORGUNITID, FAudUserID = ?, FAudFormId = ?, FDetail = ? where FState in " + BgDBUtils.getSqlParam((int[])dataStates) + " and exists (select FDataId from " + cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)";
                BgDBUtils.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{state.getValue(), user.getId().toString(), bgFormInfo.getId().toString(), 1, bgFormInfo.getId().toString()});
                BgDBUtils.executeUpdate((Context)ctx, (String)("update " + cubeName + " set FAudOrgUnitID = FORGUNITID where FAudOrgUnitID not IN (select FID from T_ORG_BaseUnit) "));
                if (BgDataStateEnum.UnionReceive.equals((Object)state)) {
                    BgDBUtils.executeUpdate((Context)ctx, (String)("update " + cubeName + " set FREPORTORGUNITID = FORGUNITID where FREPORTORGUNITID is null and  exists (select FDataId from " + cubeEntry + " where FFormId = ? and FDataId = " + cubeName + ".FID)"), (Object[])new Object[]{bgFormInfo.getId().toString()});
                }
                resultInfo.setState(BgFinalizedResultEnum.syn);
                resultInfo.setResult(ResourceBase.getString((String)resClassName, (String)"result1", (Locale)locale, (Object[])new Object[]{orgInfo.getName(), orgInfo.getNumber(), bgFormInfo.getName()}));
                resultInfo.setCurrentIndex(index);
                iBgFinalizedResult.save(resultInfo);
                ++index;
                result.add(this.getSynOneResult(ctx, resClassName, bgFormInfo));
            }
            resultInfo.setCurrentIndex(bgFormColls.size());
            resultInfo.setState(BgFinalizedResultEnum.success);
            resultInfo.setResult(ResourceBase.getString((String)resClassName, (String)"result2", (Locale)locale));
            iBgFinalizedResult.save(resultInfo);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            resultInfo.setResult("");
            resultInfo.setState(BgFinalizedResultEnum.exception);
        }
        long ct2 = System.currentTimeMillis();
        logger.info((Object)("MbgDataStateSynFacadeControllerBean _executeSynNew time:" + (ct2 - ct1) + "ms"));
        return result;
    }

    protected Map<String, Object> getSynOneResult(Context ctx, String resClassName, BgFormInfo bgFormInfo) {
        HashMap<String, Object> r = new HashMap<String, Object>();
        r.put("orgUnit", bgFormInfo.getOrgUnit().getName());
        r.put("bgTemplate", bgFormInfo.getBgTemplate().getName());
        r.put("bgPeriod", bgFormInfo.getBgPeriod().getName());
        r.put("bgVersion", bgFormInfo.getBgVersion().getName());
        r.put("currency", bgFormInfo.getCurrency().getName());
        r.put("bgForm", bgFormInfo.getName());
        r.put("result", ResourceBase.getString((String)resClassName, (String)"result3", (Locale)ctx.getLocale()));
        r.put("detail", "");
        return r;
    }

    protected int[] getDataStates(BgDataStateEnum state) {
        int[] states = null;
        if (BgDataStateEnum.Approved.equals((Object)state)) {
            states = new int[]{1, 3};
        } else if (BgDataStateEnum.UnionReceive.equals((Object)state)) {
            states = new int[]{1, 3, 9, 11};
        }
        return states;
    }
}

