/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.biz.execute.calc.face.ICalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcData;
import com.kingdee.eas.ma.biz.execute.calc.impl.BizCalcImpl;
import com.kingdee.eas.ma.biz.execute.face.IBizParameter;
import com.kingdee.eas.ma.biz.execute.impl.BizCalcParameter;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgDataSynException;
import com.kingdee.eas.ma.mbg.app.AbstractMbgDataSynFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDataSynFacadeControllerBean
extends AbstractMbgDataSynFacadeControllerBean {
    private static final long serialVersionUID = 3785104463930695178L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgDataSynFacadeControllerBean");

    @Override
    protected void _synBgData(Context ctx, String bgSchemeNumber, List bgDatas, String bgFormId, boolean isAuditData) throws BOSException, EASBizException {
        BgSchemeInfo bgSchemeInfo = BgViewServerHelper.getBgSchemeCubeInfo(ctx, bgSchemeNumber);
        if (bgSchemeInfo == null) {
            throw new MbgDataSynException(MbgDataSynException.BGSCHEMENOFOUND);
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeNumber, true);
        BgFormInfo bgFormInfo = null;
        if (!StringUtils.isEmpty((String)bgFormId)) {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(BgNFSHelper.getFormBaseSelectors(false));
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeInfo.getId().toString()));
            view.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)bgFormId));
            BgFormCollection bgFormCol = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
            if (bgFormCol == null || bgFormCol.isEmpty()) {
                throw new MbgDataSynException(MbgDataSynException.BGFORMNOFOND);
            }
            bgFormInfo = bgFormCol.get(0);
        }
        Map<String, Integer> srcFieldMap = this.querySrcFieldMap(ctx, schemeHelper);
        HashMap<String, HashMap<String, BizCalcData>> dataMap = new HashMap<String, HashMap<String, BizCalcData>>();
        HashMap<String, BizCalcData> subDataMap = null;
        ArrayList<Object[]> deleteParams = new ArrayList<Object[]>();
        Map versionMap = BgVersionHelper.getVersionObjMap((Context)ctx);
        HashMap<Integer, String> refNumber = new HashMap<Integer, String>();
        String period = null;
        String element = null;
        String currency = null;
        String scenario = null;
        String version = null;
        String orgNumber2 = null;
        String srcNumber = null;
        String number = null;
        String[] split = null;
        Object value = null;
        Object[] bgDataValues = null;
        BizCalcData calcData = null;
        Set<String> budgetScens = new DimensionCacheHelper(ctx).getBudgetScens();
        Integer indexField = DimensionCommonHelper.getField(DimensionConstants.DEF_BGINDEX_FIELD);
        Object _value = null;
        block2: for (int i = 0; i < bgDatas.size(); ++i) {
            period = null;
            element = null;
            currency = null;
            scenario = null;
            version = null;
            orgNumber2 = null;
            refNumber.clear();
            if (bgDatas.get(i) instanceof List) {
                bgDataValues = ((List)bgDatas.get(i)).toArray();
            } else if (bgDatas.get(i) instanceof Object[]) {
                bgDataValues = (Object[])bgDatas.get(i);
            }
            if (bgDataValues == null) continue;
            calcData = new BizCalcData();
            _value = bgDataValues[bgDataValues.length - 1];
            value = _value instanceof BigDecimal ? (BigDecimal)_value : (StringUtils.isEmpty((String)StringUtils.cnulls((Object)_value)) ? null : new BigDecimal(_value.toString()));
            calcData.setValue((BigDecimal)value);
            for (int d = 0; d < bgDataValues.length - 1; ++d) {
                split = ((String)bgDataValues[d]).split(":");
                srcNumber = split[0];
                number = split[1];
                if (DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(srcNumber)) {
                    orgNumber2 = number;
                    continue;
                }
                if (DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNumber)) {
                    period = number;
                    continue;
                }
                if (DimensionConstants.DEF_ELEMENT_SRCNUMBER.equals(srcNumber)) {
                    element = number;
                    continue;
                }
                if (DimensionConstants.DEF_CURRENCY_SRCNUMBER.equals(srcNumber)) {
                    currency = number;
                    continue;
                }
                if (DimensionConstants.DEF_SCENARIO_SRCNUMBER.equals(srcNumber)) {
                    scenario = number;
                    continue;
                }
                if (DimensionConstants.DEF_VERSION_SRCNUMBER.equals(srcNumber)) {
                    version = number;
                    continue;
                }
                if (!srcFieldMap.containsKey(srcNumber)) {
                    logger.error((Object)("MbgDataSynFacade SynData - Error SrcNumber:" + srcNumber + " values:" + Arrays.toString(bgDataValues)));
                    continue block2;
                }
                refNumber.put(srcFieldMap.get(srcNumber), (String)bgDataValues[d]);
            }
            if (bgFormInfo != null && !bgFormInfo.getBgVersion().getNumber().equals(version)) {
                logger.error((Object)("MbgDataSynFacade SynData - Skip Version:" + version + " values:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(orgNumber2)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error Org. number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(period)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error Period number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(element)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error element number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(currency)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error currency number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(scenario)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error scenario number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (StringUtils.isEmpty(version)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error Period number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            if (bgFormInfo != null && !bgFormInfo.getOrgUnit().getNumber().equals(orgNumber2)) {
                logger.error((Object)("MbgDataSynFacade SynData - Error Form Org Number:(" + bgFormInfo.getOrgUnit().getNumber() + ") " + Arrays.toString(bgDataValues)));
                continue;
            }
            if (!budgetScens.contains(scenario)) {
                logger.error((Object)("MbgDataSynFacade SynData - No Budget Scenario:(" + scenario + ") " + Arrays.toString(bgDataValues)));
                continue;
            }
            calcData.setBgIndexNumber((String)refNumber.get(indexField));
            if (calcData.getBgIndexNumber() == null) {
                logger.error((Object)("MbgDataSynFacade SynData - Error BgIndex number:" + Arrays.toString(bgDataValues)));
                continue;
            }
            calcData.setBgElementNumber(element);
            calcData.setBgFormId(bgFormId);
            calcData.setBgPeriodNumber(period);
            calcData.setBgScenarioNumber(scenario);
            calcData.setBgVersionNumber(version);
            calcData.setCurrencyNumber(currency);
            calcData.setFormula(BgViewHelper.parseItemFormula(element, currency, period, scenario, refNumber));
            calcData.setDimNumber(BgNFSHelper.parseFormulaPara(calcData.getFormula())[0]);
            subDataMap = (Map)dataMap.get(orgNumber2);
            if (subDataMap == null) {
                subDataMap = new HashMap<String, BizCalcData>();
                dataMap.put(orgNumber2, subDataMap);
            }
            subDataMap.put(DimUtils.getDimDataKey(calcData.getFormula(), version), calcData);
        }
        if (dataMap.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("number");
        view.getSelector().add("id");
        view.setFilter(new FilterInfo());
        view.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(dataMap.keySet()), CompareType.INCLUDE));
        FullOrgUnitCollection orgCol = FullOrgUnitFactory.getLocalInstance((Context)ctx).getFullOrgUnitCollection(view);
        HashMap<String, String> orgNumber_id = new HashMap<String, String>();
        for (int i = 0; i < orgCol.size(); ++i) {
            orgNumber_id.put(orgCol.get(i).getNumber(), orgCol.get(i).getId().toString());
        }
        BizCalcParameter bizParameter = new BizCalcParameter();
        bizParameter.setBgSchemeId(bgSchemeInfo.getId());
        bizParameter.getDataManager().setBgScheme(bgSchemeInfo);
        bizParameter.getControlManager().setBackCalc(false);
        bizParameter.getDataManager().setDimsMap(DimUtils.getDimInfoMap(ctx));
        ArrayList keys = new ArrayList();
        for (String orgNumber2 : dataMap.keySet()) {
            if (!orgNumber_id.containsKey(orgNumber2)) {
                logger.error((Object)("MbgDataSynFacade SynData - Org. No Found:" + orgNumber2));
                continue;
            }
            bizParameter.setOrgUnitId(BOSUuid.read((String)((String)orgNumber_id.get(orgNumber2))));
            subDataMap = (HashMap<String, BizCalcData>)dataMap.get(orgNumber2);
            keys.clear();
            keys.addAll(subDataMap.keySet());
            for (String key : keys) {
                if (((ICalcData)subDataMap.get(key)).getValue() != null) continue;
                deleteParams.add(new Object[]{bizParameter.getOrgUnitId().toString(), ((ICalcData)subDataMap.get(key)).getFormula(), ((BgVersionInfo)versionMap.get(((ICalcData)subDataMap.get(key)).getBgVersionNumber())).getVersionId()});
                subDataMap.remove(key);
            }
            BizCalcImpl bizCalc = new BizCalcImpl(ctx, (IBizParameter)bizParameter, isAuditData);
            if (!StringUtils.isEmpty((String)bgFormId)) {
                bizParameter.setBillId(BOSUuid.read((String)bgFormId));
            }
            HashMap<String, HashMap<String, BizCalcData>> _dataMap = new HashMap<String, HashMap<String, BizCalcData>>();
            _dataMap.put(bizParameter.getOrgUnitId().toString(), subDataMap);
            try {
                bizCalc.updateResult(_dataMap);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        if (!deleteParams.isEmpty()) {
            DbUtil.executeBatch((Context)ctx, (String)("Delete " + BgCubeUtils.getBudgetEntryCubeName(bgSchemeInfo.getRefCube()) + " Where FDataID IN(Select FID FROM " + bgSchemeInfo.getRefCube() + " Where FOrgUnitId = ? AND FFormula = ? AND FVersion = ?)"), deleteParams);
            DbUtil.executeBatch((Context)ctx, (String)("Delete " + bgSchemeInfo.getRefCube() + " Where FOrgUnitId = ? AND FFormula = ? AND FVersion = ?"), deleteParams);
        }
    }

    private Map<String, Integer> querySrcFieldMap(Context ctx, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        HashMap<String, Integer> srcFieldMap = new HashMap<String, Integer>();
        for (String dimNumber : schemeHelper.getAllDim()) {
            srcFieldMap.put(schemeHelper.getSrcNumber(dimNumber), DimensionCommonHelper.getField(schemeHelper.getRefField(dimNumber)));
        }
        return srcFieldMap;
    }

    @Override
    protected List _getBgScheme(Context ctx) throws BOSException {
        ArrayList result = new ArrayList();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add("number");
        view.getSelector().add("name");
        view.setSorter(new SorterItemCollection());
        view.getSorter().add(new SorterItemInfo("number"));
        BgSchemeCollection col = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view);
        HashMap<String, String> bgSchemeMap = null;
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                bgSchemeMap = new HashMap<String, String>();
                bgSchemeMap.put("number", col.get(i).getNumber());
                bgSchemeMap.put("name", col.get(i).getName());
                result.add(bgSchemeMap);
            }
        }
        return result;
    }

    @Override
    protected List _getBgSchemeDimension(Context ctx, String bgSchemeNumber) throws BOSException {
        ArrayList<ArrayList<Map<String, String>>> result = new ArrayList<ArrayList<Map<String, String>>>();
        BgSchemeDimensionHelper schemeHelper = null;
        try {
            schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeNumber, true);
        }
        catch (EASBizException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        ArrayList<Map<String, String>> subResultList = null;
        subResultList = new ArrayList<Map<String, String>>();
        for (String dimNumber : schemeHelper.getAllDim()) {
            this.addDimensionSrc(subResultList, dimNumber, schemeHelper);
        }
        result.add(subResultList);
        return result;
    }

    private void addDimensionSrc(List<Map<String, String>> subResultList, String dimNumber, BgSchemeDimensionHelper schemeHelper) {
        BgDimensionInfo srcInfo = schemeHelper.getDimension(dimNumber);
        HashMap<String, String> subMap = new HashMap<String, String>();
        subResultList.add(subMap);
        subMap.put("srcnumber", schemeHelper.getSrcNumber(srcInfo.getNumber()));
        subMap.put("srcname", srcInfo.getAlias());
        subMap.put("dimnumber", srcInfo.getNumber());
        subMap.put("dimname", srcInfo.getAlias());
    }
}

