/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.util.MetaDataLoader;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.FilterParam;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgScenarioType;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgParamNHelper;
import com.kingdee.eas.ma.base.utils.BgVersionHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgDataQueryTypeEnum;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.app.AbstractMbgDetailDataQueryFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewBase;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.cube.utils.MbgBaseDataUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.query.AnalyseMember;
import com.kingdee.eas.ma.mbg.query.MbgDataQueryFilterParam;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgDetailDataQueryFacadeControllerBean
extends AbstractMbgDetailDataQueryFacadeControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgDetailDataQueryFacadeControllerBean");
    public static final String TABLE_NAME = "T_MBG_BgDataQuery";

    protected void beforeOpenQuery(Context ctx) throws EASBizException, BOSException {
        this.createTable(ctx, TABLE_NAME, false);
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        DbUtil.execute((Context)ctx, (String)("Delete " + this.getTableName(ctx) + " Where FTime <= ?"), (Object[])new Object[]{new Timestamp(calendar.getTimeInMillis())});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTable(Context ctx, String TABLE_NAME, boolean isTmpTable) throws BOSException {
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            if (BgDBUtils.NO == BgDBUtils.existTable((Connection)conn, (String)TABLE_NAME)) {
                DbUtil.execute((Context)ctx, (String)("Create Table " + TABLE_NAME + "(" + (isTmpTable ? "" : "FQueryId Varchar(44) NOT NULL, ") + "FBgDataId Varchar(44) NOT NULL, FOrgUnitId Varchar(44) NOT NULL, FFormula NVarchar(" + 300 + ") NOT NULL, FVersion INT NOT NULL, FVersionName NVarchar(200), FValue Numeric(21, 8) NOT NULL, FState INT NOT NULL, FAudOrgUnitID Varchar(44), FAudOrgNumber NVarchar(200), FAudOrgName NVarchar(200), FIsRefForm INT Default(0) NOT NULL, FTime DateTime)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FReportOrgUnitID")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FReportOrgUnitID Varchar(44)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FReportOrgNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FReportOrgNumber NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FReportOrgName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FReportOrgName NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FDetail")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FDetail INT Default(0) NOT NULL"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FOrder")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FOrder INT Default(0) NOT NULL"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgIndexNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgIndexNumber NVarchar(80)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgIndexName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgIndexName NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FRefMemberNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FRefMemberNumber NVarchar(" + 300 + ")"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FRefMemberName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FRefMemberName NVarchar(" + 300 + ")"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgPeriodNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgPeriodNumber NVarchar(80)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgPeriodName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgPeriodName NVarchar(220)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FScenario")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FScenario INT"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FScenarioNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FScenarioNumber NVarchar(80)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FScenarioName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FScenarioName NVarchar(220)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgElementNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgElementNumber NVarchar(80)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FBgElementName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FBgElementName NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FCurrencyNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FCurrencyNumber NVarchar(80)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FCurrencyName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FCurrencyName NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FTmpValue")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FTmpValue Numeric(21, 8)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FRefFormNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FRefFormNumber NVarchar(2000)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FIsAdjust")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FIsAdjust INT Default 0 NOT NULL"));
            }
            if (BgDBUtils.YES == BgDBUtils.existIndexNew((Connection)conn, (String)TABLE_NAME, (String)"IX_MBG_BgDataQueryOD")) {
                DbUtil.execute((Context)ctx, (String)"DROP INDEX T_MBG_BGDATAQUERY.IX_MBG_BgDataQueryOD;");
            }
            if (BgDBUtils.NO == BgDBUtils.existIndexNew((Connection)conn, (String)TABLE_NAME, (String)"PK_MBG_BgDataQuery")) {
                DbUtil.execute((Context)ctx, (String)("ALTER TABLE " + TABLE_NAME + " ADD CONSTRAINT PK_MBG_BgDataQuery Primary Key (FQueryID, FBgDataId)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FAudFormId")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FAudFormId Varchar(44)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FAudFormOrgName")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FAudFormOrgName NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FAudFormNumber")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FAudFormNumber NVarchar(200)"));
            }
            if (BgDBUtils.NO == BgDBUtils.existColumn((Connection)conn, (String)TABLE_NAME, (String)"FDataSource")) {
                DbUtil.execute((Context)ctx, (String)("Alter Table " + TABLE_NAME + " Add FDataSource Numeric(21, 8)"));
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void analyse(Context ctx, Uuid queryId, FilterParam filterParam) throws BOSException, EASBizException {
        Connection conn;
        block43: {
            if (!(filterParam instanceof MbgDataQueryFilterParam)) {
                return;
            }
            MbgDataQueryFilterParam queryParam = (MbgDataQueryFilterParam)filterParam;
            if (queryParam.getBgScheme() == null) return;
            if (queryParam.getBgOrgUnit() == null) {
                return;
            }
            int dataType = queryParam.getDataType();
            boolean isCsl = MbgDataQueryFilterParam.isCsl(queryParam.getQueryType());
            BgSchemeInfo rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, queryParam.getBgScheme().getId());
            if (rootScheme == null) {
                return;
            }
            String cubeName = BgCubeUtils.getCubeName(rootScheme.getRefCube(), dataType);
            String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), dataType);
            String queryOrgUnitId = null;
            if (isCsl) {
                queryOrgUnitId = queryParam.getBgOrgUnit().getId().toString();
            } else {
                BgOrgUnitInfo bgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitInfo("select id, orgUnitId where id = '" + queryParam.getBgOrgUnit().getId().toString() + "'");
                queryOrgUnitId = bgOrgUnit.getOrgUnitID();
                Set bgOrgUnitPer = MbgPermissionFactory.getLocalInstance(ctx).getBgOrgUnitPermission(null, ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), queryParam.getBgScheme().getId().toString());
                if (!bgOrgUnitPer.isEmpty() && !bgOrgUnitPer.contains(queryOrgUnitId)) {
                    queryOrgUnitId = "000000000000000000000000000=";
                }
            }
            BgSchemeDimensionHelper schemehelper = null;
            schemehelper = isCsl ? BgSchemeDimensionHelper.getCslInstance(ctx, queryParam.getBgScheme().getId().toString(), queryParam.getOrgTree()) : new BgSchemeDimensionHelper(ctx, queryParam.getBgScheme().getId().toString());
            BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, schemehelper, cubeName);
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            conn = null;
            String tempBgDataIdsTable = null;
            String tempIdsTable = null;
            String tempF2Table = null;
            String tempItemCombinTable = null;
            String versionTable = null;
            try {
                conn = this.getConnection(ctx);
                BgCubeUtils.checkTable(conn);
                HashSet<String> cubes = new HashSet<String>();
                if (!accIntHelper.isUseAccInt()) {
                    cubes.add(cubeName);
                } else if (!queryParam.getMembers().isEmpty()) {
                    HashSet<String> accNumbers = new HashSet<String>();
                    for (int m = 0; m < queryParam.getMembers().size(); ++m) {
                        accNumbers.add(queryParam.getMembers().get(m).getBgIndex().getNumber());
                    }
                    cubes.addAll(accIntHelper.getSplitTablesByAcc(accNumbers));
                } else {
                    cubes.addAll(accIntHelper.getSplitMap().values());
                }
                List<String> refDims = schemehelper.getRefDims();
                DimensionCommonHelper.sortRefField(refDims);
                StringBuffer sql = new StringBuffer();
                sql.append("Create Table T_MBg_TempBgDataId(FID Varchar(44) NOT NULL Primary Key, FRefCube Varchar(30), FIsShow INT DEFAULT 0 NOT NULL, FScenarioType INT, FBgItemCombination NVARCHAR(300), FBgItemCombinationName NVARCHAR(300), FOrgUnitId Varchar(44) ");
                for (String r : refDims) {
                    sql.append(", ").append(r).append(" NVarchar(84), ").append(r).append("Name").append(" NVarchar(255)");
                }
                sql.append(")");
                tempBgDataIdsTable = pool.createTempTable(sql.toString());
                tempIdsTable = pool.createTempTable("Create Table T_MBG_TMPIDS(FID VARCHAR(44) NOT NULL)");
                tempF2Table = pool.createTempTable("Create Table T_MBG_TMPF2(FID NVARCHAR(84) NOT NULL)");
                tempItemCombinTable = pool.createTempTable("Create Table T_MBG_TMPITEMCOMB(FID NVARCHAR(300) NOT NULL)");
                versionTable = pool.createTempTable("Create Table T_MBG_TMPF2(FVersionID INT DEFAULT 0 NOT NULL )");
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + versionTable + "(FVersionID) Select FVersionID FROM T_MBG_BgVersion Where FIsRollVersion = ?"), (Object)new Object[]{0});
                boolean hasReportOrg = 1 == dataType;
                boolean hasDetail = 1 == dataType;
                boolean hasAudFormId = 128 != dataType;
                String indexDisplayStyle = BgParamNHelper.getMbgShowStyle((Context)ctx);
                for (String cube : cubes) {
                    List ids;
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempBgDataIdsTable));
                    if (queryParam.getBgForm() == null) {
                        if (accIntHelper.isUseAccInt()) {
                            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempBgDataIdsTable + "(FID) Select " + BgCubeUtils.getBgDataHint(cube, cube, "IX_MBG_BO", accIntHelper.isUseAccInt()) + " FID FROM " + cube + " Where FOrgUnitId = ? and FVersion in (Select FVersionID from " + versionTable + ")"), (Object)new Object[]{accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, queryOrgUnitId)});
                        } else {
                            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempBgDataIdsTable + "(FID) Select FID FROM " + cube + " Where FOrgUnitId = ? and FVersion in (Select FVersionID from " + versionTable + ")"), (Object)new Object[]{queryOrgUnitId});
                        }
                    } else {
                        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
                        if (queryParam.getMembers() != null) {
                            for (int m = 0; m < queryParam.getMembers().size(); ++m) {
                                this.addFilterMap(queryParam.getMembers().get(m), filterMap);
                            }
                        }
                        this.addFilterMap(DimensionConstants.DEF_SCENARIO_SRCNUMBER, (CoreBaseInfo[])queryParam.getBgScenarios(), filterMap);
                        this.addFilterMap(DimensionConstants.DEF_ELEMENT_SRCNUMBER, (CoreBaseInfo[])queryParam.getBgElements(), filterMap);
                        this.addFilterMap(DimensionConstants.DEF_VERSION_SRCNUMBER, (CoreBaseInfo[])queryParam.getBgVersions(), filterMap);
                        this.addFilterMap(DimensionConstants.DEF_CURRENCY_SRCNUMBER, (CoreBaseInfo[])queryParam.getCurrencies(), filterMap);
                        this.addFilterMap(DimensionConstants.DEF_PERIOD_SRCNUMBER, (CoreBaseInfo[])queryParam.getBgPeriods(), filterMap);
                        IDimDataQuery dimDataQuery = (IDimDataQuery)queryParam.getBgForm();
                        QueryDataIdUtils dataUtils = new QueryDataIdUtils(pool, filterMap, accIntHelper);
                        HashSet<String> _cubes = new HashSet<String>();
                        _cubes.add(cube);
                        dataUtils.queryBgDataIds(ctx, tempBgDataIdsTable, _cubes, conn, rootScheme, dimDataQuery, queryOrgUnitId, isCsl ? queryParam.getOrgTree() : null);
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + tempBgDataIdsTable + "(FID) Select FDataID FROM " + cubeEntryName + " t0 Where FFormId = ? and not exists(Select FID FROM " + tempBgDataIdsTable + " Where FID = t0.FDataId) and exists(Select FID FROM " + cube + " Where FID = t0.FDataId)"), (Object)new Object[]{queryParam.getBgForm().getId().toString()});
                    }
                    if ((ids = MbgSqlHelper.executeQuery((Connection)conn, (String)("Select Top 1 FID FROM " + tempBgDataIdsTable), null)) == null || ids.isEmpty()) continue;
                    if (MbgDataQueryTypeEnum.BgForm.equals((Object)queryParam.getQueryType())) {
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FScenarioType = (Select FType FROM T_MBg_BgScenario Where FScenarioId = (Select FScenario FROM " + cube + " Where FID = t0.FID))"));
                        MbgSqlHelper.execute((Connection)conn, (String)("Delete " + tempBgDataIdsTable + " Where FScenarioType = " + 1));
                    }
                    this.filter(conn, "Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where exists (Select FID FROM " + cube + " t1 Where t0.FID = t1.FID AND t1.FBgPeriodId IN(Select FID FROM " + tempIdsTable + "))", tempBgDataIdsTable, tempIdsTable, (CoreBaseInfo[])queryParam.getBgPeriods());
                    this.filter(conn, "Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where exists (Select FID FROM " + cube + " t1 Where t0.FID = t1.FID AND t1.FVersion IN(Select FVersionID FROM T_MBG_BgVersion Where FID IN(Select FID FROM " + tempIdsTable + ")))", tempBgDataIdsTable, tempIdsTable, (CoreBaseInfo[])queryParam.getBgVersions());
                    this.filter(conn, "Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where exists (Select FID FROM " + cube + " t1 Where t0.FID = t1.FID AND t1.FCurrencyId IN(Select FID FROM " + tempIdsTable + "))", tempBgDataIdsTable, tempIdsTable, (CoreBaseInfo[])queryParam.getCurrencies());
                    this.filter(conn, "Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where exists (Select FID FROM " + cube + " t1 Where t0.FID = t1.FID AND t1.FBgElementId IN(Select FID FROM " + tempIdsTable + "))", tempBgDataIdsTable, tempIdsTable, (CoreBaseInfo[])queryParam.getBgElements());
                    this.filter(conn, "Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where exists (Select FID FROM " + cube + " t1 Where t0.FID = t1.FID AND t1.FScenario IN(Select FScenarioID FROM T_MBG_BgScenario Where FID IN(Select FID FROM " + tempIdsTable + ")))", tempBgDataIdsTable, tempIdsTable, (CoreBaseInfo[])queryParam.getBgScenarios());
                    this.filter(conn, tempBgDataIdsTable, cube, tempF2Table, tempItemCombinTable, queryParam.getMembers(), accIntHelper);
                    if (accIntHelper.isUseAccInt()) {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set F2 = (Select FNumber FROM T_MBG_BgAccount Where FBgAccountViewId = ? AND FIntId = (Select F2 FROM " + cube + " t1 Where t0.FID = t1.FID))"), (Object)new Object[]{schemehelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()});
                    } else {
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set F2 = (Select SUBSTRING(F2, 5, 90) FROM " + cube + " t1 Where t0.FID = t1.FID)"));
                    }
                    String bgAccountViewId = schemehelper.getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId();
                    if ("2".equals(indexDisplayStyle)) {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t1 Set F2Name = (Select FDisplayName_" + ctx.getLocale() + " FROM T_Mbg_BgAccount Where FNumber = t1.F2 AND FBgAccountViewID = ?)"), (Object)bgAccountViewId);
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t1 Set F2Name = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgAccount Where FNumber = t1.F2 AND FBgAccountViewID = ?) Where F2Name IS NULL"), (Object)bgAccountViewId);
                    } else {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t1 Set F2Name = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgAccount Where FNumber = t1.F2 AND FBgAccountViewID = ?)"), (Object)bgAccountViewId);
                        if ("0".equals(indexDisplayStyle)) {
                            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t1 Set F2Name = F2 || '(' || F2Name || ')'"));
                        }
                    }
                    String mbgViewId = null;
                    StringBuffer fieldName = new StringBuffer();
                    StringBuffer field = new StringBuffer();
                    for (String refField : refDims) {
                        if (DimensionConstants.DEF_BGINDEX_FIELD.equals(refField)) continue;
                        if (fieldName.length() > 0) {
                            fieldName.append(" || ',' || ");
                            field.append(" || ',' || ");
                        }
                        mbgViewId = schemehelper.getDimensionByRefField().get(refField).getViewId();
                        field.append(refField);
                        fieldName.append(refField).append(" || '(' || ").append(refField).append("Name || ')'");
                        if (accIntHelper.isUseAccInt()) {
                            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set " + refField + " = (Select FNumber FROM T_MBG_MbgMember Where FViewId = ? AND FIntId = (Select " + refField + " FROM " + cube + " t1 Where t0.FID = t1.FID))"), (Object)new Object[]{mbgViewId});
                        } else {
                            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set " + refField + " = (Select SUBSTRING(" + refField + ", 5, 90) FROM " + cube + " t1 Where t0.FID = t1.FID)"));
                        }
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t1 Set " + refField + "Name = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_MbgMember Where FNumber = t1." + refField + " AND FViewID = ?)"), (Object)new Object[]{mbgViewId});
                    }
                    if (field.length() > 0) {
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FBgItemCombination = " + field));
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FBgItemCombinationName = " + fieldName));
                    }
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into T_MBG_BgDataQuery(FQueryId, FBgDataId, FOrgUnitId, FFormula, FVersion, FScenario, FValue, " + (MbgDataQueryTypeEnum.BgForm.equals((Object)queryParam.getQueryType()) ? "FTmpValue, " : "") + "FState, FAudOrgUnitID, FReportOrgUnitID, FDetail,FAudFormId, FDataSource ) Select ?, FID, FOrgUnitId, FFormula, FVersion, FScenario, FValue, " + (MbgDataQueryTypeEnum.BgForm.equals((Object)queryParam.getQueryType()) ? "FTmpValue, " : "") + "FState, FAudOrgUnitID, " + (hasReportOrg ? "FReportOrgUnitID" : "null") + ", " + (hasDetail ? "FDetail" : "0") + ", " + (hasAudFormId ? "FAudFormId" : "null") + ",FDataSource FROM " + cube + " Where FID IN (Select FID FROM " + tempBgDataIdsTable + ")"), (Object)queryId.toString());
                    if (accIntHelper.isUseAccInt()) {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgPeriodNumber = (Select FNumber FROM T_Mbg_BgPeriod Where FIntID = (Select FBgPeriodID FROM " + cube + " Where FID = t1.FBgDataId)) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t1.FBgDataId)"), (Object)queryId.toString());
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgElementNumber = (Select FNumber FROM T_Mbg_BgElement Where FIntID = (Select FBgElementID FROM " + cube + " Where FID = t1.FBgDataId)) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t1.FBgDataId) "), (Object)queryId.toString());
                    } else {
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgPeriodNumber = (Select FNumber FROM T_Mbg_BgPeriod Where FID = (Select FBgPeriodID FROM " + cube + " Where FID = t1.FBgDataId)) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t1.FBgDataId)"), (Object)queryId.toString());
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgElementNumber = (Select FNumber FROM T_Mbg_BgElement Where FID = (Select FBgElementID FROM " + cube + " Where FID = t1.FBgDataId)) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t1.FBgDataId) "), (Object)queryId.toString());
                    }
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FCurrencyNumber = (Select FNumber FROM T_BD_Currency Where FID = (Select FCurrencyID FROM " + cube + " Where FID = t1.FBgDataId)) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t1.FBgDataId) "), (Object)queryId.toString());
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t0 Set FBgIndexNumber = (Select F2 FROM " + tempBgDataIdsTable + " t1 Where t0.FBgDataId = t1.FID) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t0.FBgDataId) "), (Object)queryId.toString());
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t0 Set FBgIndexName = (Select F2Name FROM " + tempBgDataIdsTable + " t1 Where t0.FBgDataId = t1.FID) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t0.FBgDataId) "), (Object)queryId.toString());
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t0 Set FRefMemberNumber = (Select FBgItemCombination FROM " + tempBgDataIdsTable + " t1 Where t0.FBgDataId = t1.FID) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t0.FBgDataId) "), (Object)queryId.toString());
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t0 Set FRefMemberName = (Select FBgItemCombinationName FROM " + tempBgDataIdsTable + " t1 Where t0.FBgDataId = t1.FID) Where FQueryId = ? and exists (Select FID FROM " + cube + " Where FID = t0.FBgDataId) "), (Object)queryId.toString());
                }
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgPeriodName = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgPeriod Where FNumber = t1.FBgPeriodNumber) Where FQueryId = ? "), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t1 Set FBgPeriodName = FBgPeriodName || '(' || LEFT(FBgPeriodNumber, 4) || ')' Where FQueryId = ? ", (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t1 Set FScenarioNumber = (Select FNumber FROM T_Mbg_BgScenario Where FScenarioID = t1.FScenario) Where FQueryId = ? ", (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FScenarioName = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgScenario Where FScenarioID = t1.FScenario) Where FQueryId = ? "), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FBgElementName = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgElement Where FNumber = t1.FBgElementNumber) Where FQueryId = ? "), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FCurrencyName = (Select FName_" + ctx.getLocale() + " FROM T_BD_Currency Where FNumber = t1.FCurrencyNumber) Where FQueryId = ? "), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t1 Set FAudOrgNumber = (Select FNumber FROM T_Org_BaseUnit Where FID = t1.FAudOrgUnitID) Where FQueryId = ?", (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FAudOrgName = (Select FName_" + ctx.getLocale() + " FROM T_Org_BaseUnit Where FID = t1.FAudOrgUnitID) Where FQueryId = ?"), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t1 Set FReportOrgNumber = (Select FNumber FROM T_Org_BaseUnit Where FID = t1.FReportOrgUnitID) Where FQueryId = ?", (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FReportOrgName = (Select FName_" + ctx.getLocale() + " FROM T_Org_BaseUnit Where FID = t1.FReportOrgUnitID) Where FQueryId = ?"), (Object)queryId.toString());
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FVersionName = (Select FName_" + ctx.getLocale() + " FROM T_Mbg_BgVersion Where FVersionID = t1.FVersion) Where FQueryId = ? "), (Object)queryId.toString());
                if (queryParam.getBgForm() != null) {
                    MbgSqlHelper.executeBatch((Connection)conn, (String)("Update T_MBG_BgDataQuery t1 Set FIsRefForm = 1 Where Exists(Select FDataId FROM " + cubeEntryName + " t2 Where t1.FBgDataId = t2.FDataID AND t2.FFormId = ?)"), (Object)queryParam.getBgForm().getId().toString());
                }
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t0 Set FIsAdjust = 0 Where FQueryId = ?", (Object)queryId.toString());
                if (MbgDataQueryTypeEnum.BgForm.equals((Object)queryParam.getQueryType())) {
                    MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery t0 Set FIsAdjust = 1 Where FQueryId = ? AND exists(Select FID FROM T_MBG_BgTmpData Where FID = t0.FBgDataId)", (Object)queryId.toString());
                }
                this.updateRefFormNumber(ctx, conn, queryId, cubeEntryName, tempBgDataIdsTable, tempIdsTable);
                MbgSqlHelper.executeBatch((Connection)conn, (String)"Update T_MBG_BgDataQuery Set FTime = NOW() Where FQueryId = ?", (Object)queryId.toString());
                this.updateOrder(conn, queryId, queryParam);
                if (hasAudFormId) {
                    this.updateAudFormFields(ctx, conn, queryId.toString());
                }
                if (tempBgDataIdsTable == null) break block43;
            }
            catch (EASBizException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw e;
                    catch (BOSException e2) {
                        logger.error((Object)"", (Throwable)e2);
                        throw e2;
                    }
                    catch (Exception e3) {
                        logger.error((Object)"", (Throwable)e3);
                        throw new BOSException((Throwable)e3);
                    }
                }
                catch (Throwable throwable) {
                    if (tempBgDataIdsTable != null) {
                        pool.releaseTable(tempBgDataIdsTable);
                        pool.releaseTable(tempIdsTable);
                        pool.releaseTable(tempF2Table);
                        pool.releaseTable(tempItemCombinTable);
                        pool.releaseTable(versionTable);
                    }
                    SQLUtils.cleanup((Connection)conn);
                    throw throwable;
                }
            }
            pool.releaseTable(tempBgDataIdsTable);
            pool.releaseTable(tempIdsTable);
            pool.releaseTable(tempF2Table);
            pool.releaseTable(tempItemCombinTable);
            pool.releaseTable(versionTable);
        }
        SQLUtils.cleanup((Connection)conn);
    }

    private void updateAudFormFields(Context ctx, Connection conn, String queryId) throws SQLException {
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormOrgNameSql(ctx, "T_MBG_BgForm"), (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormNumSql("T_MBG_BgForm"), (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormOrgNameSql(ctx, "T_MBG_BgAdjustBill"), (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormNumSql("T_MBG_BgAdjustBill"), (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormOrgNameSql(ctx, "T_MBG_BgCslForm"), (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormNumSql("T_MBG_BgCslForm"), (Object)queryId);
        String sql = "update T_MBG_BgDataQuery t1 set FAudFormOrgName = (select FName_" + ctx.getLocale() + " from T_Org_BaseUnit where FID = (select b.FOrgUnitId from T_MBG_BgForm b inner join T_MBG_BgActualRecord r on b.FID = r.FBgFormId where r.FID = t1.FAudFormId)) where FqueryId = ? and exists (select FID from T_MBG_BgActualRecord where FID = t1.FAudFormId)";
        MbgSqlHelper.executeBatch((Connection)conn, (String)sql, (Object)queryId);
        MbgSqlHelper.executeBatch((Connection)conn, (String)this.updateAudFormNumSql("T_MBG_BgActualRecord"), (Object)queryId);
    }

    private String updateAudFormOrgNameSql(Context ctx, String refTableName) {
        if ("T_MBG_BgAdjustBill".equals(refTableName)) {
            return "update T_MBG_BgDataQuery t1 set FAudFormOrgName = (select FName_" + ctx.getLocale() + " from T_Org_BaseUnit where FID = (select FOrgUnit from " + refTableName + " where FID = t1.FAudFormId)) where FqueryId = ? and exists (select FID from " + refTableName + " where FID = t1.FAudFormId)";
        }
        return "update T_MBG_BgDataQuery t1 set FAudFormOrgName = (select FName_" + ctx.getLocale() + " from T_Org_BaseUnit where FID = (select FOrgUnitId from " + refTableName + " where FID = t1.FAudFormId)) where FqueryId = ? and exists (select FID from " + refTableName + " where FID = t1.FAudFormId)";
    }

    private String updateAudFormNumSql(String refTableName) {
        return "update T_MBG_BgDataQuery t1 set FAudFormNumber = (select FNumber from " + refTableName + " where FID = t1.FAudFormId) where FqueryId = ? and exists (select FID from " + refTableName + " where FID = t1.FAudFormId)";
    }

    private Map<String, String> updateRefFormNumber(Context ctx, Connection conn, Uuid queryId, String cubeEntryName, String tempBgDataIdsTable, String tempIdsTable) throws BOSException {
        HashMap bgDataRefFormIds = new HashMap();
        HashMap bgFormIds = new HashMap();
        HashMap<String, String> bgFormNumbers = new HashMap<String, String>();
        HashMap<String, String> result = new HashMap<String, String>();
        IRowSet rst = null;
        String bosType22 = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select dataEntry.FDataId, dataEntry.FFormId FROM " + cubeEntryName + " dataEntry Where exists(Select FID FROM " + tempBgDataIdsTable + " Where FID = dataEntry.FDataId)"));
            while (rst.next()) {
                String dataId = rst.getString("FDataId");
                String formId = rst.getString("FFormId");
                bosType22 = BOSUuid.read((String)formId).getType().toString();
                if (!bgDataRefFormIds.containsKey(dataId)) {
                    bgDataRefFormIds.put(dataId, new HashSet());
                }
                ((Set)bgDataRefFormIds.get(dataId)).add(formId);
                if (!bgFormIds.containsKey(bosType22)) {
                    bgFormIds.put(bosType22, new HashSet());
                }
                ((Set)bgFormIds.get(bosType22)).add(formId);
            }
            SQLUtils.cleanup((ResultSet)rst);
            if (!bgFormIds.isEmpty()) {
                for (String bosType22 : bgFormIds.keySet()) {
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempIdsTable));
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempIdsTable + "(FID) Values(?)"), (Collection)((Collection)bgFormIds.get(bosType22)));
                    EntityObjectInfo entity = MetaDataLoader.getEntity((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType22));
                    rst = BgDBUtils.executeQuery((Connection)conn, (String)("Select FID, FNumber FROM " + entity.getTable().getName() + " t0 Where FID IN (Select FID FROM " + tempIdsTable + ")"));
                    while (rst.next()) {
                        bgFormNumbers.put(rst.getString("FID"), rst.getString("FNumber"));
                    }
                }
            }
            HashMap formNumberIds = new HashMap();
            ArrayList<Object> formNumbers = new ArrayList<Object>();
            StringBuffer formString = new StringBuffer();
            String formNumberStr22 = null;
            Set formIds = null;
            for (String dataId : bgDataRefFormIds.keySet()) {
                formIds = (Set)bgDataRefFormIds.get(dataId);
                formNumbers.clear();
                for (String string : formIds) {
                    if (bgFormNumbers.get(string) != null) {
                        formNumbers.add(bgFormNumbers.get(string));
                        continue;
                    }
                    formNumbers.add(string);
                }
                Collections.sort(formNumbers);
                formString.setLength(0);
                for (String string : formNumbers) {
                    if (formString.length() > 0) {
                        formString.append(", ");
                    }
                    formString.append(string);
                }
                if (formString.length() > 2000) {
                    formString.setLength(2000);
                }
                if (!formNumberIds.containsKey(formNumberStr22 = formString.toString())) {
                    formNumberIds.put(formNumberStr22, new ArrayList());
                }
                ((List)formNumberIds.get(formNumberStr22)).add(dataId);
                result.put(dataId, formNumberStr22);
            }
            ArrayList paramList = new ArrayList();
            Object[] tmpIds = null;
            for (String formNumberStr22 : formNumberIds.keySet()) {
                tmpIds = ((List)formNumberIds.get(formNumberStr22)).toArray(new String[0]);
                paramList.addAll(MbgSqlHelper.getBatchParams((Object[])new String[]{formNumberStr22, queryId.toString()}, (Object[])tmpIds, (int)50));
            }
            StringBuffer sql1 = new StringBuffer("Update T_MBG_BgDataQuery Set FRefFormNumber = ? Where FQueryId = ? AND FBgDataId IN(");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql1).append(")");
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql1.toString(), paramList);
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return result;
    }

    private void addFilterMap(String srcNumber, CoreBaseInfo[] infos, Map<String, Set<String>> filterMap) {
        if (StringUtils.isEmpty((String)srcNumber) || infos == null || infos.length == 0) {
            return;
        }
        for (int i = 0; i < infos.length; ++i) {
            if (infos[i] == null) continue;
            this.addFilterMap(srcNumber, infos[i].getString("number"), filterMap);
        }
    }

    private void addFilterMap(AnalyseMember analyseMember, Map<String, Set<String>> filterMap) {
        if (analyseMember == null) {
            return;
        }
        this.addFilterMap(DimensionConstants.DEF_INDEX_SRCNUMBER, analyseMember.getBgIndex().getNumber(), filterMap);
    }

    private void addFilterMap(String srcNumber, String number, Map<String, Set<String>> filterMap) {
        if (StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)number) || filterMap == null) {
            return;
        }
        if (!filterMap.containsKey(srcNumber)) {
            filterMap.put(srcNumber, new HashSet());
        }
        filterMap.get(srcNumber).add(number);
    }

    private void filter(Connection conn, String tempBgDataIdsTable, String cubeName, String tempF2Table, String tempItemCombinTable, List<AnalyseMember> members, BgSchemeAccIntHelper accIntHelper) throws SQLException, BOSException, EASBizException {
        if (members == null || members.isEmpty()) {
            return;
        }
        HashSet<String> accountMembers = new HashSet<String>();
        HashSet<String> otherMembers = new HashSet<String>();
        for (AnalyseMember member : members) {
            if (member.getDimMember() == null) {
                accountMembers.add(member.getBgIndex().getCombNumber());
                continue;
            }
            otherMembers.add(member.getBgIndex().getCombNumber() + "," + member.getDimMember().getCombNumber());
        }
        this.resetShowFlag(conn, tempBgDataIdsTable);
        if (!accountMembers.isEmpty()) {
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempF2Table + "(FID) Values(?)"), accountMembers);
            if (accIntHelper.isUseAccInt()) {
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set F2 = (Select '" + DimensionConstants.DEF_INDEX_SRCNUMBER + ":" + "' || FNumber FROM T_MBG_BgAccount Where FBgAccountViewId = ? AND FIntId = (Select F2 FROM " + cubeName + " t1 Where t0.FID = t1.FID))"), (Object)new Object[]{accIntHelper.getSchemeHelper().getDimension(DimensionConstants.DEF_ACCOUNT_NUMBER).getViewId()});
            } else {
                MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set F2 = (Select F2 FROM " + cubeName + " t1 Where t0.FID = t1.FID)"));
            }
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where FIsShow = 0 AND exists(Select FID FROM " + tempF2Table + " t1 Where t0.F2 = t1.FID)"));
        }
        if (!otherMembers.isEmpty()) {
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempItemCombinTable + "(FID) Values(?)"), otherMembers);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FBgItemCombination = (Select FBgItemCombination FROM " + cubeName + " t1 Where t0.FID = t1.FID)"));
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FIsShow = 1 Where FIsShow = 0 AND exists(Select FID FROM " + tempItemCombinTable + " t1 Where t0.FBgItemCombination = t1.FID)"));
        }
        this.removeNoShow(conn, tempBgDataIdsTable);
    }

    private void filter(Connection conn, String sql, String tempBgDataIdsTable, String tempIdsTable, CoreBaseInfo[] infos) throws SQLException, BOSException {
        if (DimensionCommonHelper.isEmpty(infos)) {
            return;
        }
        Set<String> ids = DimensionCommonHelper.getIds(infos);
        MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempIdsTable));
        BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempIdsTable + "(FID) Values(?)"), ids);
        this.resetShowFlag(conn, tempBgDataIdsTable);
        MbgSqlHelper.execute((Connection)conn, (String)sql);
        this.removeNoShow(conn, tempBgDataIdsTable);
    }

    private void removeNoShow(Connection conn, String tempBgDataIdsTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempBgDataIdsTable + " Where FIsShow = 0"));
    }

    private void resetShowFlag(Connection conn, String tempBgDataIdsTable) throws BOSException {
        MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " Set FIsShow = 0"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOrder(Connection conn, Uuid queryId, MbgDataQueryFilterParam queryParam) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        int nullCount = this.getMaxCount(conn, "Select COUNT(FQueryId) FROM T_MBG_BgDataQuery Where FQueryId = ? AND " + queryParam.getSortField() + " IS NULL", new Object[]{queryId.toString()});
        int notNullCount = this.getMaxCount(conn, "Select COUNT(FQueryId) FROM T_MBG_BgDataQuery Where FQueryId = ? AND " + queryParam.getSortField() + " IS NOT NULL", new Object[]{queryId.toString()});
        String compareFlag = SortType.ASCEND.equals((Object)queryParam.getSortType()) ? "<" : ">";
        int notNullStart = SortType.ASCEND.equals((Object)queryParam.getSortType()) ? nullCount : 0;
        int nullStart = SortType.ASCEND.equals((Object)queryParam.getSortType()) ? 0 : notNullCount;
        IRowSet rst = null;
        String quSql = "select FBgDataId from T_MBG_BgDataQuery where FQueryId = ? And " + queryParam.getSortField() + "  IS NOT NULL order by " + queryParam.getSortField() + " " + queryParam.getSortType() + ", FBgDataId " + queryParam.getSortType();
        String upSql = "Update T_MBG_BgDataQuery Set FOrder = ? where FQueryId = ? And FBgDataId = ? ";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] params = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)quSql, (Object[])new Object[]{queryId.toString()});
            while (rst.next()) {
                params = new Object[]{notNullStart++, queryId.toString(), rst.getString("FBgDataId")};
                paramList.add(params);
            }
            MbgSqlHelper.executeBatch((Connection)conn, (String)upSql, paramList);
        }
        catch (Throwable throwable) {
            SQLUtils.cleanup(rst);
            throw throwable;
        }
        SQLUtils.cleanup((ResultSet)rst);
        sql.setLength(0);
        sql.append("Update ").append(TABLE_NAME).append(" t0 Set FOrder = (");
        sql.append("Select Count(FQueryId) + ? FROM ").append(TABLE_NAME).append(" t1 Where t1.FQueryId = ? AND t1.").append(queryParam.getSortField()).append(" IS NULL");
        sql.append(" AND t1.FBgDataId ").append(compareFlag).append(" t0.FBgDataId");
        sql.append(") Where FQueryId = ? AND ").append(queryParam.getSortField()).append(" IS NULL");
        MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (Object)new Object[]{nullStart, queryId.toString(), queryId.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMaxCount(Connection conn, String sql, Object[] params) throws SQLException, BOSException {
        IRowSet rst;
        block2: {
            int n;
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])params);
                if (!rst.next()) break block2;
                n = rst.getInt(1);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
            SQLUtils.cleanup((ResultSet)rst);
            return n;
        }
        SQLUtils.cleanup((ResultSet)rst);
        return 0;
    }

    protected String getQuerySql(Context ctx, Uuid queryId, int start, int length) throws BOSException, EASBizException {
        return "Select * FROM T_MBG_BgDataQuery Where FQueryId = '" + queryId + "' AND FOrder >= " + start + " AND FOrder < " + (start + length) + " Order By FOrder";
    }

    protected String getTableName(Context ctx) throws BOSException, EASBizException {
        return TABLE_NAME;
    }

    @Override
    protected Set _getCanRefBgForm(Context ctx, MbgDataQueryFilterParam filterParam, List bgDataIds) throws BOSException, EASBizException {
        if (filterParam == null || bgDataIds == null || bgDataIds.isEmpty() || filterParam.getBgForm() == null) {
            return null;
        }
        HashSet<String> canAddIds = new HashSet<String>();
        HashMap<String, Set<String>> filterMap = new HashMap<String, Set<String>>();
        Map versionMap = BgVersionHelper.getVersionInnIdMap((Context)ctx);
        String[] bgDataId = null;
        String[] formulaParams = null;
        String[] combins = null;
        for (int i = 0; i < bgDataIds.size(); ++i) {
            bgDataId = (String[])bgDataIds.get(i);
            formulaParams = BgNFSHelper.parseFormulaPara(bgDataId[1]);
            this.addFilterMap(DimensionConstants.DEF_VERSION_SRCNUMBER, (String)versionMap.get(Integer.parseInt(bgDataId[2])), filterMap);
            this.addFilterMap(DimensionConstants.DEF_PERIOD_SRCNUMBER, formulaParams[1], filterMap);
            this.addFilterMap(DimensionConstants.DEF_SCENARIO_SRCNUMBER, formulaParams[3], filterMap);
            this.addFilterMap(DimensionConstants.DEF_ELEMENT_SRCNUMBER, formulaParams[2], filterMap);
            this.addFilterMap(DimensionConstants.DEF_CURRENCY_SRCNUMBER, formulaParams[5], filterMap);
            combins = DimensionFormulaHelper.splitCombinations(formulaParams[0]);
            for (int c = 0; c < combins.length; ++c) {
                this.addFilterMap(DimensionFormulaHelper.getSrcNumber(combins[c]), DimensionFormulaHelper.getMemberNumber(combins[c]), filterMap);
            }
        }
        IDimDataQuery info = (IDimDataQuery)filterParam.getBgForm();
        BgSchemeDimensionHelper schemeHelper = null;
        schemeHelper = MbgDataQueryFilterParam.isCsl(filterParam.getQueryType()) ? BgSchemeDimensionHelper.getCslInstance(ctx, filterParam.getBgScheme().getId().toString(), filterParam.getOrgTree()) : new BgSchemeDimensionHelper(ctx, filterParam.getBgScheme().getId().toString());
        try {
            info = info.getInfo(ctx, info.getId());
            FormulaProcessor formulaProcessor = new FormulaProcessor();
            formulaProcessor.canVersions.add(info.getBizVersion().getNumber());
            DimensionCacheHelper cacheHelper = new DimensionCacheHelper(ctx);
            BgScenarioType scenarioType = BgScenarioType.BudgetData;
            if (MbgDataQueryTypeEnum.ActualForm.equals((Object)filterParam.getQueryType())) {
                scenarioType = BgScenarioType.ActualData;
            }
            if (info.getBizTemplateType() == 0 || info.getBizTemplateType() == 8) {
                formulaProcessor.canEditScenario = cacheHelper.getEditScenSet(null, scenarioType);
                List formulas = BgNFSHelper.getFormulaListOfBook(((ReportBaseInfo)info).getBook());
                for (int i = 0; i < formulas.size(); ++i) {
                    formulaProcessor.process((String)formulas.get(i), info.getBizVersion().getNumber(), BgNFSHelper.parseFormulaPara((String)formulas.get(i))[3]);
                }
            } else {
                IMbgViewBase view = info.getView(ctx, filterParam.getBgScheme());
                MbgBaseDataUtils.filterMember(view, filterMap);
                for (int s = 0; s < view.getSheetManagers().size(); ++s) {
                    formulaProcessor.canEditScenario = cacheHelper.getEditScenSet(view.getSheetManagers().get(s).getEditScenNumber(), scenarioType);
                    if (info.getBizTemplateType() == 4) {
                        BgViewHelper.buildFormula((IMbgSheetManager)view.getSheetManagers().get(s), (BgViewHelper.IFormulaProcessor)formulaProcessor, null, schemeHelper);
                        continue;
                    }
                    BgViewHelper.buildFormula((MbgViewListSheetManager)view.getSheetManagers().get(s), (BgViewHelper.IFormulaProcessor)formulaProcessor, schemeHelper, null);
                }
            }
            for (int i = 0; i < bgDataIds.size(); ++i) {
                bgDataId = (String[])bgDataIds.get(i);
                if (!formulaProcessor.canFormulas.contains(DimUtils.getDimDataKey(bgDataId[1], (String)versionMap.get(Integer.parseInt(bgDataId[2]))))) continue;
                canAddIds.add(bgDataId[0]);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return canAddIds;
    }

    @Override
    protected Map _addRefBgForm(Context ctx, String queryId, MbgDataQueryFilterParam filterParam, Set bgDataIds) throws BOSException {
        Map<String, String> map;
        BgSchemeInfo rootScheme;
        int dataType;
        Connection conn;
        String formId;
        String tempIdsTable;
        String tempBgDataIdsTable;
        TempTablePool pool;
        block6: {
            if (queryId == null || filterParam == null || bgDataIds == null || bgDataIds.isEmpty() || filterParam.getBgForm() == null) {
                return null;
            }
            pool = TempTablePool.getInstance((Context)ctx);
            tempBgDataIdsTable = null;
            tempIdsTable = null;
            formId = filterParam.getBgForm().getId().toString();
            conn = null;
            conn = this.getConnection(ctx);
            tempBgDataIdsTable = pool.createTempTable("Create Table T_MBG_TEMPIDSTABLE(FID Varchar(44) NOT NULL PRIMARY KEY, FHasData INT Default 0 NOT NULL)");
            tempIdsTable = pool.createTempTable("Create Table T_MBG_TEMPIDSTABLE(FID Varchar(44) NOT NULL PRIMARY KEY)");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempBgDataIdsTable + " (FID) Values(?)"), (Collection)bgDataIds);
            dataType = filterParam.getDataType();
            rootScheme = BgViewServerHelper.getBgSchemeCubeInfo(ctx, filterParam.getBgScheme().getId());
            if (rootScheme != null) break block6;
            Map map2 = null;
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIdsTable);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempBgDataIdsTable);
            SQLUtils.cleanup((Connection)conn);
            return map2;
        }
        try {
            String cubeEntryName = BgCubeUtils.getCubeEntryName(rootScheme.getRefCube(), dataType);
            MbgSqlHelper.execute((Connection)conn, (String)("Update " + tempBgDataIdsTable + " Set FHasData = 0"));
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + tempBgDataIdsTable + " t0 Set FHasData = 1 Where exists(Select FDataId FROM " + cubeEntryName + " t1 Where t0.FID = t1.FDataId AND t1.FFormId = ?)"), (Object)new Object[]{formId});
            MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into " + cubeEntryName + " (FDataId, FFormId) Select FID, ? FROM " + tempBgDataIdsTable + " Where FHasData <> 1"), (Object)new Object[]{formId});
            map = this.updateRefFormNumber(ctx, conn, Uuid.read((String)queryId), cubeEntryName, tempBgDataIdsTable, tempIdsTable);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempIdsTable);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempBgDataIdsTable);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempIdsTable);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempBgDataIdsTable);
        SQLUtils.cleanup((Connection)conn);
        return map;
    }

    class QueryDataIdUtils
    extends MbgBaseDataUtils {
        private Map<String, Set<String>> filterMap;
        private BgSchemeAccIntHelper accIntHelper;
        Map<String, String> otherMemberTables;

        public QueryDataIdUtils(TempTablePool pool, Map<String, Set<String>> filterMap, BgSchemeAccIntHelper accIntHelper) {
            super(pool);
            this.filterMap = null;
            this.accIntHelper = null;
            this.otherMemberTables = new HashMap<String, String>();
            this.filterMap = filterMap;
            this.accIntHelper = accIntHelper;
        }

        @Override
        protected void querySubMember(Connection conn, BgSchemeInfo schemeInfo, Set<String> dimNumbers) throws EASBizException {
        }

        @Override
        protected void updateOtherMemberTable(Context ctx, Connection conn, BgSchemeInfo schemeInfo, Map<String, Set<String>> mbgMemberMap) throws BOSException, EASBizException {
            if (conn == null || mbgMemberMap == null || mbgMemberMap.isEmpty()) {
                return;
            }
            String tmpTable = null;
            for (String field : mbgMemberMap.keySet()) {
                if (DimensionConstants.DEF_BGINDEX_FIELD.equals(field) || DimUtils.checkBaseDimensionByField(field)) continue;
                tmpTable = BgDBUtils.createTmpTable((TempTablePool)this.getPool(), (String)"CREATE TABLE TEML_KSQL_0 (FNumber NVARCHAR(84), FIntId INT)");
                this.otherMemberTables.put(field, tmpTable);
                try {
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tmpTable + " (FNumber) values (?)"), (Collection)mbgMemberMap.get(field));
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }

        public void queryBgDataIds(Context ctx, String tempBgDataIdsTable, Set<String> cubes, Connection conn, BgSchemeInfo schemeInfo, IDimDataQuery dimDataQuery, String orgUnitId, OrgTreeInfo orgTree) throws EASBizException, BOSException {
            Map<String, Set<String>> mbgMemberMap = null;
            try {
                mbgMemberMap = this.parseMember(ctx, conn, schemeInfo, dimDataQuery, this.filterMap);
                if (mbgMemberMap != null && !mbgMemberMap.isEmpty()) {
                    if (this.accIntHelper.isUseAccInt()) {
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + this.tmpBgPeriod + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgPeriod Where FID = t0.FID)"));
                        MbgSqlHelper.execute((Connection)conn, (String)("Update " + this.tmpBgElement + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgElement Where FID = t0.FID)"));
                        MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + this.tmpBgIndex + " t0 Set FIntId = (Select FIntId FROM T_MBG_BgAccount Where FBgAccountViewId = ? AND FNumber = SUBSTRING(t0.FNumber, 5, 90))"), (Object)new Object[]{this.accIntHelper.getSchemeHelper().getDimension(DimensionConstants.DEF_INDEX_NUMBER).getViewId()});
                        for (String field : this.otherMemberTables.keySet()) {
                            MbgSqlHelper.executeBatch((Connection)conn, (String)("Update " + this.otherMemberTables.get(field) + " t0 Set FIntId = (Select FIntId FROM T_MBG_MbgMember Where FViewId = ? AND FNumber = SUBSTRING(t0.FNumber, 5, 90))"), (Object)new Object[]{this.accIntHelper.getSchemeHelper().getDimensionByRefField().get(field).getViewId()});
                        }
                    }
                    for (String cube : cubes) {
                        StringBuffer sql = new StringBuffer();
                        if (this.accIntHelper.isUseAccInt()) {
                            sql.append("Insert Into " + tempBgDataIdsTable + "(FID) Select FID FROM " + cube + " where " + (orgTree == null ? "" : "FUnionId = ? and ") + "FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FIntId = " + cube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FIntID = " + cube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FIntID = " + cube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cube + ".FScenario) ");
                        } else {
                            sql.append("Insert Into " + tempBgDataIdsTable + "(FID) Select FID FROM " + cube + " where " + (orgTree == null ? "" : "FUnionId = ? and ") + "FOrgUnitId = ?  and exists (select FNumber from " + this.tmpBgIndex + " where FNumber = " + cube + ".F2)  and exists (select FID from " + this.tmpBgPeriod + " where FID = " + cube + ".FBgPeriodID)  and exists (select FID from " + this.tmpBgElement + " where FID = " + cube + ".FBgElementID)  and exists (select FID from " + this.tmpCurrency + " where FID = " + cube + ".FCurrencyID)  and exists (select FID from " + this.tmpScenario + " where FID = " + cube + ".FScenario) ");
                        }
                        Set<Object> versionNumbers = new HashSet<String>();
                        Map versionMap = BgVersionHelper.getVersionInnMap((Context)ctx);
                        if (mbgMemberMap.containsKey(DimensionConstants.DEF_VERSION_FIELD)) {
                            versionNumbers = mbgMemberMap.get(DimensionConstants.DEF_VERSION_FIELD);
                        } else {
                            versionNumbers.add(dimDataQuery.getBizVersion().getNumber());
                        }
                        if (versionNumbers.isEmpty()) {
                            return;
                        }
                        StringBuffer versionId = new StringBuffer();
                        for (String string : versionNumbers) {
                            if (versionId.length() > 0) {
                                versionId.append(",");
                            }
                            if (!versionMap.containsKey(string)) continue;
                            versionId.append((String)versionMap.get(string));
                        }
                        sql.append(" and FVersion IN(" + versionId + ")");
                        if (!this.otherMemberTables.isEmpty()) {
                            for (String string : this.otherMemberTables.keySet()) {
                                if (this.accIntHelper.isUseAccInt()) {
                                    sql.append(" and exists (select FNumber from " + this.otherMemberTables.get(string) + " Where FIntId = " + cube + "." + string + ")");
                                    continue;
                                }
                                sql.append(" and exists (select FNumber from " + this.otherMemberTables.get(string) + " Where FNumber = " + cube + "." + string + ")");
                            }
                        }
                        Object[] param = null;
                        param = orgTree != null ? new Object[]{orgTree.getId().toString(), orgUnitId} : (this.accIntHelper.isUseAccInt() ? new Object[]{this.accIntHelper.convertInt(DimensionConstants.DEF_ORGUNIT_FIELD, orgUnitId)} : new Object[]{orgUnitId});
                        MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (Object)param);
                    }
                }
            }
            catch (EASBizException ex) {
                throw ex;
            }
            catch (BOSException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new BOSException((Throwable)ex);
            }
            finally {
                this.clear();
            }
        }

        @Override
        public void clear() {
            super.clear();
            if (!this.otherMemberTables.isEmpty()) {
                BgDBUtils.releaseTmpTable((TempTablePool)this.getPool(), this.otherMemberTables.values());
            }
        }
    }

    class FormulaProcessor
    implements BgViewHelper.IFormulaProcessor {
        Set<String> canEditScenario = new HashSet<String>();
        Set<String> canVersions = new HashSet<String>();
        Map<Integer, String> cloneMap = new HashMap<Integer, String>();
        Set<String> canFormulas = new HashSet<String>();

        FormulaProcessor() {
        }

        @Override
        public Map<Integer, String> getCloneMap() {
            return this.cloneMap;
        }

        @Override
        public void process(String formula, String versionNumber, String scenarioNumber) {
            if (this.canEditScenario == null || !this.canEditScenario.contains(scenarioNumber) || !this.canVersions.contains(versionNumber)) {
                return;
            }
            this.canFormulas.add(DimUtils.getDimDataKey(formula, versionNumber));
        }
    }
}

