/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizScopeCollection;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.utils.BizExprUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgVariateFactory;
import com.kingdee.eas.ma.mbg.BgVariateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberTypeEnum;
import com.kingdee.eas.ma.mbg.IBgOrgUnit;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.app.AbstractMbgFunctionFacadeControllerBean;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgFunctionFacadeControllerBean
extends AbstractMbgFunctionFacadeControllerBean {
    private static final long serialVersionUID = 6011580652855387887L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgFunctionFacadeControllerBean");

    @Override
    protected Set _getOrgScopeByBizScope(Context ctx, IObjectCollection orgScopeColls, String bgOrgViewID, String bgSchemeId, BOSUuid unionId) throws BOSException, EASBizException {
        return this._getOrgScopeByBizScope(ctx, orgScopeColls, bgOrgViewID, bgSchemeId, unionId, false);
    }

    @Override
    protected Set _getOrgScopeByBizScope(Context ctx, IObjectCollection orgScopeColls, String bgOrgViewID, String bgSchemeId, BOSUuid unionId, boolean onlyCostCenterID) throws BOSException, EASBizException {
        int i;
        HashSet<Object> result = new HashSet<Object>();
        if (orgScopeColls == null || orgScopeColls.isEmpty()) {
            return result;
        }
        BizScopeCollection bizScopeColls = (BizScopeCollection)orgScopeColls;
        BizScopeInfo curScopeInfo = null;
        String curNum = null;
        Object funName = null;
        String isDetail = null;
        DimensionMemberTypeEnum fillType = null;
        Map<String, String> curMap = null;
        HashMap<String, String> bgOrgUnitId = new HashMap<String, String>();
        if (onlyCostCenterID && unionId == null) {
            for (int i2 = 0; i2 < bizScopeColls.size(); ++i2) {
                curScopeInfo = bizScopeColls.get(i2);
                curNum = curScopeInfo.getBgMemberNum();
                fillType = curScopeInfo.getFillType();
                if (BgMemberSelectTypeEnum.Member != curScopeInfo.getBizDataType()) continue;
                if (curNum.indexOf("@") != -1) {
                    isDetail = BizExprUtils.getIsDetailByScopeMemNum(isDetail);
                    curNum = BizExprUtils.getDimMemByScopeFunction((String)curNum);
                }
                if (DimensionMemberTypeEnum.Normal != fillType || !onlyCostCenterID || unionId != null) continue;
                bgOrgUnitId.put(curNum, null);
            }
        }
        if (!bgOrgUnitId.isEmpty()) {
            EntityViewInfo evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("number");
            evi.getSelector().add("orgUnitId");
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewID));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("number", new HashSet(bgOrgUnitId.keySet()), CompareType.INCLUDE));
            BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            bgOrgUnitId.clear();
            for (i = 0; i < col.size(); ++i) {
                bgOrgUnitId.put(col.get(i).getNumber(), col.get(i).getOrgUnitID());
            }
        }
        BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgSchemeId);
        boolean hasProp = false;
        for (i = 0; i < bizScopeColls.size(); ++i) {
            curScopeInfo = bizScopeColls.get(i);
            curNum = curScopeInfo.getBgMemberNum();
            fillType = curScopeInfo.getFillType();
            if (BgMemberSelectTypeEnum.Member == curScopeInfo.getBizDataType()) {
                if (curNum.indexOf("@") != -1) {
                    isDetail = BizExprUtils.getIsDetailByScopeMemNum((String)isDetail);
                    curNum = BizExprUtils.getDimMemByScopeFunction((String)curNum);
                }
                if (DimensionMemberTypeEnum.Normal == fillType) {
                    if (onlyCostCenterID && unionId == null) {
                        result.add(bgOrgUnitId.get(curNum));
                    } else {
                        result.add(curNum);
                    }
                } else if (DimensionMemberTypeEnum.DirectSubordinate == fillType) {
                    curMap = this.getBgOrgChildren(ctx, bgOrgViewID, curNum, false, isDetail);
                } else if (DimensionMemberTypeEnum.AllSubordinate == fillType) {
                    curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, curNum, false, isDetail);
                } else if (DimensionMemberTypeEnum.AllEqual == fillType) {
                    curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, curNum, false, isDetail);
                } else if (DimensionMemberTypeEnum.IncludeDirectSub == fillType) {
                    curMap = this.getBgOrgChildren(ctx, bgOrgViewID, curNum, true, isDetail);
                } else if (DimensionMemberTypeEnum.IncludeAddEqual == fillType) {
                    curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, curNum, true, isDetail);
                } else if (DimensionMemberTypeEnum.IncludeAddSub == fillType) {
                    curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, curNum, true, isDetail);
                }
                if (curMap == null) continue;
                if (onlyCostCenterID) {
                    result.addAll(curMap.values());
                    continue;
                }
                result.addAll(curMap.keySet());
                continue;
            }
            if (BgMemberSelectTypeEnum.Function == curScopeInfo.getBizDataType()) {
                curMap = this.getBgOrgFunction(ctx, bgOrgViewID, curNum);
                if (curMap == null) continue;
                if (onlyCostCenterID) {
                    result.addAll(curMap.values());
                    continue;
                }
                result.addAll(curMap.keySet());
                continue;
            }
            if (BgMemberSelectTypeEnum.Variate == curScopeInfo.getBizDataType()) {
                curMap = this.getBgOrgNumByVariate(ctx, bgSchemeId, curNum);
                if (curMap == null) continue;
                if (onlyCostCenterID) {
                    result.addAll(curMap.values());
                    continue;
                }
                result.addAll(curMap.keySet());
                continue;
            }
            if (BgMemberSelectTypeEnum.Property != curScopeInfo.getBizDataType()) continue;
            query.addQueryProp(DimensionConstants.DEF_ORGUNIT_FIELD, curScopeInfo.getBgMemberNum());
            hasProp = true;
        }
        if (hasProp) {
            try {
                HashSet<String> numbers = new HashSet<String>();
                Map members = query.queryMember();
                if (members != null) {
                    for (List mlst : members.values()) {
                        for (IMember m : mlst) {
                            numbers.add(m.getNumber());
                        }
                    }
                }
                if (onlyCostCenterID && !numbers.isEmpty()) {
                    EntityViewInfo evi = new EntityViewInfo();
                    evi.setSelector(new SelectorItemCollection());
                    evi.getSelector().add("orgUnitId");
                    evi.setFilter(new FilterInfo());
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewID));
                    evi.getFilter().getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                    BgOrgUnitCollection col = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
                    bgOrgUnitId.clear();
                    for (int i3 = 0; i3 < col.size(); ++i3) {
                        result.add(col.get(i3).getOrgUnitID());
                    }
                } else {
                    result.addAll(numbers);
                }
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private Map<String, String> getBgOrgFunction(Context ctx, String bgOrgViewID, String curNum) {
        Map<String, String> curMap = null;
        String funName = null;
        String isDetail = null;
        if (curNum.indexOf("@") != -1 && !(funName = BizExprUtils.getFunctionNameByScopeMemNum((String)curNum)).equals("Remove")) {
            isDetail = BizExprUtils.getIsDetailByScopeMemNum((String)curNum);
            curNum = BizExprUtils.getDimMemByScopeFunction((String)curNum);
        }
        if (funName != null && funName.equals("Descendants")) {
            curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, curNum, false, isDetail);
        } else if (funName != null && funName.equals("IDescendants")) {
            curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, curNum, true, isDetail);
        } else if (funName != null && funName.equals("Children")) {
            curMap = this.getBgOrgChildren(ctx, bgOrgViewID, curNum, false, isDetail);
        } else if (funName != null && funName.equals("IChildrens")) {
            curMap = this.getBgOrgChildren(ctx, bgOrgViewID, curNum, true, isDetail);
        } else if (funName != null && funName.equals("Siblings")) {
            curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, curNum, false, isDetail);
        } else if (funName != null && funName.equals("ISiblings")) {
            curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, curNum, true, isDetail);
        } else if (funName != null && funName.equals("Ancestors")) {
            curMap = this.getBgOrgAncestors(ctx, bgOrgViewID, curNum, false, isDetail);
        } else if (funName != null && funName.equals("IAncestors")) {
            curMap = this.getBgOrgAncestors(ctx, bgOrgViewID, curNum, true, isDetail);
        } else if (funName != null && funName.equals("Remove")) {
            curMap = this.getBgOrgReomve(ctx, bgOrgViewID, curNum);
        }
        return curMap;
    }

    private Map<String, String> getBgOrgReomve(Context ctx, String bgOrgViewID, String curNum) {
        HashMap<String, String> RemoveResultMap = new HashMap<String, String>();
        if (ctx == null || StringUtils.isEmpty((String)bgOrgViewID) || StringUtils.isEmpty((String)curNum)) {
            return RemoveResultMap;
        }
        String param = curNum.substring(curNum.indexOf("("), curNum.lastIndexOf(")"));
        String listOne = param.substring(param.indexOf("[") + 1, param.indexOf("L2") - 2);
        String listTwoTmp = param.substring(param.indexOf("L2"), param.lastIndexOf("]"));
        String listTwo = listTwoTmp.substring(listTwoTmp.indexOf("[") + 1);
        Set<String> setOne = this.getRemoveResultByFunStr(ctx, bgOrgViewID, listOne);
        Set<String> setTwo = this.getRemoveResultByFunStr(ctx, bgOrgViewID, listTwo);
        setTwo.removeAll(setOne);
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitCollection bgOrgUnitCols = null;
        try {
            iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            EntityViewInfo orgEvi = new EntityViewInfo();
            if (orgEvi.getFilter() == null) {
                orgEvi.setFilter(new FilterInfo());
            }
            orgEvi.getFilter().getFilterItems().add(new FilterItemInfo("number", setTwo, CompareType.INCLUDE));
            orgEvi.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            orgEvi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewID, CompareType.EQUALS));
            SelectorItemCollection sic = new SelectorItemCollection();
            orgEvi.setSelector(sic);
            orgEvi.getSelector().add(new SelectorItemInfo("number"));
            orgEvi.getSelector().add(new SelectorItemInfo("orgUnitID"));
            bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection(orgEvi);
            for (int i = 0; i < bgOrgUnitCols.size(); ++i) {
                RemoveResultMap.put(bgOrgUnitCols.get(i).getNumber(), bgOrgUnitCols.get(i).getOrgUnitID());
            }
        }
        catch (Exception e) {
            logger.error((Object)"get Descendants error", (Throwable)e);
        }
        return RemoveResultMap;
    }

    public Set<String> getRemoveResultByFunStr(Context ctx, String bgOrgViewID, String curNum) {
        HashSet<String> resultSet = new HashSet<String>();
        if (StringUtils.isEmpty((String)curNum)) {
            return resultSet;
        }
        boolean isContainFunction = curNum.indexOf("@") > -1;
        String[] tempStr = null;
        Object srcNumber = null;
        String orgNumStr = null;
        String[] orgNumbers = null;
        if (!isContainFunction) {
            tempStr = curNum.split(":");
            orgNumStr = tempStr.length == 1 ? tempStr[0] : tempStr[1];
            for (String number : orgNumbers = orgNumStr.split(",")) {
                Map<String, String> curMap = null;
                int fillType = MbgFunctionHelper.getFillType(number);
                number = MbgFunctionHelper.getMemberNumber(number);
                if (0 == fillType) {
                    resultSet.add(number);
                } else if (1 == fillType) {
                    curMap = this.getBgOrgChildren(ctx, bgOrgViewID, number, false, "");
                } else if (2 == fillType) {
                    curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, number, false, "");
                } else if (3 == fillType) {
                    curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, number, false, "");
                } else if (4 == fillType) {
                    curMap = this.getBgOrgChildren(ctx, bgOrgViewID, number, true, "");
                } else if (6 == fillType) {
                    curMap = this.getBgOrgSiblings(ctx, bgOrgViewID, number, true, "");
                } else if (5 == fillType) {
                    curMap = this.getBgOrgDescendants(ctx, bgOrgViewID, number, true, "");
                }
                if (curMap == null) continue;
                resultSet.addAll(curMap.keySet());
            }
        } else {
            Map<String, String> curMap = this.getBgOrgFunction(ctx, bgOrgViewID, curNum);
            if (curMap != null) {
                resultSet.addAll(curMap.keySet());
            }
        }
        return resultSet;
    }

    private Map<String, String> getBgOrgChildren(Context ctx, String bgOrgViewID, String number, boolean isConcludingSelf, String isDetail) {
        HashMap<String, String> childrenMap = new HashMap<String, String>();
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        BgOrgUnitCollection bgOrgUnitCols = null;
        String srcNum = null;
        if (number.split(":").length == 1) {
            srcNum = number.split(":")[0];
        } else if (number.split(":").length == 2) {
            srcNum = number.split(":")[1];
        }
        try {
            iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            bgOrgUnitInfo = iBgOrgUnit.getBgOrgUnitInfo("select name,longnumber,level,isleaf,orgUnitID where isVirtual = 0 and viewId = '" + bgOrgViewID + "' and number = '" + srcNum + "'");
            String longNumber = bgOrgUnitInfo.getLongNumber();
            int level = bgOrgUnitInfo.getLevel() + 1;
            boolean curIsLeaf = bgOrgUnitInfo.isIsLeaf();
            if (StringUtils.isEmpty((String)isDetail)) {
                if (isConcludingSelf) {
                    childrenMap.put(srcNum, bgOrgUnitInfo.getOrgUnitID());
                }
                bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection("select name,number,orgUnitID where isVirtual = 0 and viewID = '" + bgOrgViewID + "' and level = " + level + " and longnumber like '" + longNumber + "!%'");
            } else if (Boolean.parseBoolean(isDetail)) {
                if (curIsLeaf && isConcludingSelf) {
                    childrenMap.put(srcNum, bgOrgUnitInfo.getOrgUnitID());
                }
                bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection("select name,number,orgUnitID where isVirtual = 0 and isLeaf = 1 and viewID = '" + bgOrgViewID + "' and level = " + level + " and longnumber like '" + longNumber + "!%'");
            } else {
                if (!curIsLeaf && isConcludingSelf) {
                    childrenMap.put(srcNum, bgOrgUnitInfo.getOrgUnitID());
                }
                bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection("select name,number,orgUnitID where isVirtual = 0 and isLeaf = 0 and viewID = '" + bgOrgViewID + "' and level = " + level + " and longnumber like '" + longNumber + "!%'");
            }
            for (int i = 0; i < bgOrgUnitCols.size(); ++i) {
                childrenMap.put(bgOrgUnitCols.get(i).getNumber(), bgOrgUnitCols.get(i).getOrgUnitID());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get children error", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"get children error", (Throwable)e);
        }
        return childrenMap;
    }

    private Map<String, String> getBgOrgSiblings(Context ctx, String bgOrgViewID, String number, boolean isConcludingSelf, String isDetail) {
        HashMap<String, String> siblingsMap = new HashMap<String, String>();
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        BgOrgUnitCollection bgOrgUnitCols = null;
        String srcNum = null;
        srcNum = number.indexOf(":") >= 0 ? number.split(":")[1] : number;
        try {
            iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            bgOrgUnitInfo = iBgOrgUnit.getBgOrgUnitInfo("select name,longnumber,level,orgUnitID, isLeaf where isVirtual = 0 and viewId = '" + bgOrgViewID + "' and number = '" + srcNum + "'");
            String longNumber = bgOrgUnitInfo.getLongNumber();
            String parLongNumber = longNumber.substring(0, longNumber.lastIndexOf("!"));
            int level = bgOrgUnitInfo.getLevel();
            if (StringUtils.isEmpty((String)isDetail)) {
                bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection("select name,number,isleaf,orgUnitID where isVirtual = 0 and  viewID = '" + bgOrgViewID + "' and level = " + level + " and longnumber like '" + parLongNumber + "!%'");
            }
            if (bgOrgUnitCols != null && !bgOrgUnitCols.isEmpty()) {
                for (int i = 0; i < bgOrgUnitCols.size(); ++i) {
                    siblingsMap.put(bgOrgUnitCols.get(i).getNumber(), bgOrgUnitCols.get(i).getOrgUnitID());
                }
            }
            if (isConcludingSelf) {
                if (this.checkAddSelf(bgOrgUnitInfo, isDetail)) {
                    siblingsMap.put(srcNum, bgOrgUnitInfo.getOrgUnitID());
                }
            } else {
                siblingsMap.remove(srcNum);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get Siblings error", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"get Siblings error", (Throwable)e);
        }
        return siblingsMap;
    }

    private boolean checkAddSelf(BgOrgUnitInfo bgOrgUnitInfo, String isDetail) {
        if (StringUtils.isEmpty((String)isDetail)) {
            return true;
        }
        return Boolean.parseBoolean(isDetail) ? bgOrgUnitInfo.isIsLeaf() : !bgOrgUnitInfo.isIsLeaf();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getBgOrgDescendants(Context ctx, String bgOrgViewID, String number, boolean isConcludingSelf, String isDetail) {
        HashMap<String, String> bgOrgDescMap = new HashMap<String, String>();
        if (ctx == null || StringUtils.isEmpty((String)bgOrgViewID) || StringUtils.isEmpty((String)number)) {
            return bgOrgDescMap;
        }
        BgOrgUnitInfo bgOrgUnitInfo = null;
        List<BgOrgUnitInfo> bgOrgUnitCols = null;
        String srcNum = null;
        srcNum = number.indexOf(":") >= 0 ? number.split(":")[1] : number;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            bgOrgUnitInfo = MbgDataHelper.getBgOrgUnitInfoByNumber(conn, ctx.getLocale(), BOSUuid.read((String)bgOrgViewID), srcNum);
            bgOrgUnitCols = StringUtils.isEmpty((String)isDetail) ? MbgDataHelper.getBgOrgUnitChildren(ctx, conn, ctx.getLocale(), bgOrgUnitInfo, null, false) : MbgDataHelper.getBgOrgUnitChildren(ctx, conn, ctx.getLocale(), bgOrgUnitInfo, Boolean.parseBoolean(isDetail), null, false);
            for (int i = 0; i < bgOrgUnitCols.size(); ++i) {
                bgOrgDescMap.put(bgOrgUnitCols.get(i).getNumber(), bgOrgUnitCols.get(i).getOrgUnitID());
            }
            if (isConcludingSelf && this.checkAddSelf(bgOrgUnitInfo, isDetail)) {
                bgOrgDescMap.put(srcNum, bgOrgUnitInfo.getOrgUnitID());
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get Descendants error", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"get Descendants error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return bgOrgDescMap;
    }

    private Map<String, String> getBgOrgAncestors(Context ctx, String bgOrgViewID, String number, boolean isConcludingSelf, String isDetail) {
        HashMap<String, String> bgOrgAncestorMap = new HashMap<String, String>();
        IBgOrgUnit iBgOrgUnit = null;
        BgOrgUnitInfo bgOrgUnitInfo = null;
        BgOrgUnitCollection bgOrgUnitCols = null;
        String srcNum = null;
        srcNum = number.indexOf(":") >= 0 ? number.split(":")[1] : number;
        try {
            iBgOrgUnit = BgOrgUnitFactory.getLocalInstance(ctx);
            bgOrgUnitInfo = iBgOrgUnit.getBgOrgUnitInfo("select name,longnumber,level,orgUnitID where isVirtual = 0 and viewId = '" + bgOrgViewID + "' and number = '" + srcNum + "'");
            String longNumber = bgOrgUnitInfo.getLongNumber();
            HashSet numSet = new HashSet();
            numSet.addAll(Arrays.asList((Object[])longNumber.split("!")));
            EntityViewInfo viewInfo = new EntityViewInfo();
            SelectorItemCollection sic = new SelectorItemCollection();
            FilterInfo filterInfo = new FilterInfo();
            viewInfo.setSelector(sic);
            viewInfo.setFilter(filterInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("number", numSet, CompareType.INCLUDE));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isVirtual", (Object)0, CompareType.EQUALS));
            viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)bgOrgViewID, CompareType.EQUALS));
            if (!StringUtils.isEmpty((String)isDetail)) {
                if (Boolean.parseBoolean(isDetail)) {
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isleaf", (Object)1, CompareType.EQUALS));
                } else {
                    viewInfo.getFilter().getFilterItems().add(new FilterItemInfo("isleaf", (Object)0, CompareType.EQUALS));
                }
            }
            bgOrgUnitCols = iBgOrgUnit.getBgOrgUnitCollection(viewInfo);
            for (int i = 0; i < bgOrgUnitCols.size(); ++i) {
                bgOrgAncestorMap.put(bgOrgUnitCols.get(i).getNumber(), bgOrgUnitCols.get(i).getOrgUnitID());
            }
            if (!isConcludingSelf) {
                bgOrgAncestorMap.remove(srcNum);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get Descendants error", (Throwable)e);
        }
        catch (EASBizException e) {
            logger.error((Object)"get Descendants error", (Throwable)e);
        }
        return bgOrgAncestorMap;
    }

    private Map<String, String> getBgOrgNumByVariate(Context ctx, String bgSchemeId, String curNum) throws EASBizException, BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (ctx == null || StringUtils.isEmpty((String)bgSchemeId) || StringUtils.isEmpty((String)curNum)) {
            return result;
        }
        BgVariateInfo info = BgVariateFactory.getLocalInstance(ctx).getBgVariateInfo("select name, memberNumber,memberId where bgscheme.id ='" + bgSchemeId + "' and Number = '" + curNum + "' and dimNumber ='" + DimensionBaseConstants.DEF_ORGUNIT_NUMBER + "'");
        result.put(info.getMemberNumber(), info.getMemberId().toString());
        return result;
    }
}

