/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitCollection;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.BgVersionInfo;
import com.kingdee.eas.ma.base.MbgViewCollection;
import com.kingdee.eas.ma.base.MbgViewFactory;
import com.kingdee.eas.ma.base.MbgViewInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgNPeriodHelper;
import com.kingdee.eas.ma.base.utils.CalendarHelper;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgScheme;
import com.kingdee.eas.ma.mbg.IDimensionFormulaFacade;
import com.kingdee.eas.ma.mbg.app.AbstractMbgMemberFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgCslDimConstants;
import com.kingdee.eas.ma.mbg.utils.BgExpressionHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCacheHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgMemberFacadeControllerBean
extends AbstractMbgMemberFacadeControllerBean {
    private static final long serialVersionUID = -5562521128512665641L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgMemberFacadeControllerBean");

    @Override
    protected Map[] _getMember(Context ctx, BOSUuid bgSchemeId, boolean isSegregate) throws BOSException, EASBizException {
        Map[] mbgMemberMap = new Map[]{new HashMap(), new HashMap()};
        if (bgSchemeId == null) {
            return mbgMemberMap;
        }
        BgSchemeInfo schemeInfo = null;
        MbgViewInfo mbgView = null;
        HashSet<String> viewIds = new HashSet<String>();
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            schemeInfo = MbgDataHelper.getBgSchemeInfo(ctx, bgSchemeId);
            schemeInfo = MbgDataHelper.getBgSchemeInfo(ctx, bgSchemeId);
            BOSUuid bgAcctViewId = schemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_ACCOUNT_NUMBER, this.getAcctByView(conn, ctx.getLocale(), bgAcctViewId));
            List<BOSUuid> viewUUIds = schemeInfo.getViewIds(DimensionBaseConstants.DEF_PERIOD_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_PERIOD_NUMBER, this.getPeriodByView(conn, ctx.getLocale(), viewUUIds));
            List<String> numbers = schemeInfo.getMemberNumber(DimensionBaseConstants.DEF_SCENARIO_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_SCENARIO_NUMBER, this.getBgScenario(conn, ctx.getLocale(), numbers));
            numbers = schemeInfo.getMemberNumber(DimensionBaseConstants.DEF_VERSION_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_VERSION_NUMBER, this.getBgVersion(conn, ctx.getLocale(), numbers));
            numbers = schemeInfo.getMemberNumber(DimensionBaseConstants.DEF_CURRENCY_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_CURRENCY_NUMBER, this.getCurrency(conn, ctx.getLocale(), numbers));
            numbers = schemeInfo.getMemberNumber(DimensionBaseConstants.DEF_ELEMENT_NUMBER);
            mbgMemberMap[1].put(DimensionBaseConstants.DEF_ELEMENT_NUMBER, this.getBgElement(conn, ctx.getLocale(), numbers));
            List<BOSUuid> mbgViewIds = schemeInfo.getExtDimViewIds();
            int in = mbgViewIds.size();
            for (int i = 0; i < in; ++i) {
                viewIds.add(mbgViewIds.get(i).toString());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", viewIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add("id");
            sic.add("segregationRule");
            sic.add("orgUnit.id");
            sic.add("mbgDim.id");
            sic.add("mbgDim.number");
            view.getSelector().addObjectCollection((IObjectCollection)sic);
            MbgViewCollection colls = MbgViewFactory.getLocalInstance((Context)ctx).getMbgViewCollection(view);
            int in2 = colls.size();
            for (int i = 0; i < in2; ++i) {
                Map<String, Object> tmpMap;
                mbgView = colls.get(i);
                if (0 == mbgView.getSegregationRule().getValue()) {
                    tmpMap = this.getMemberByView(conn, ctx.getLocale(), mbgView.getId().toString(), true);
                    if (tmpMap == null || tmpMap.isEmpty()) continue;
                    mbgMemberMap[0].put(mbgView.getMbgDim().getNumber(), tmpMap);
                    continue;
                }
                if (isSegregate) continue;
                tmpMap = this.getMemberByView(conn, ctx.getLocale(), mbgView.getId().toString(), false);
                mbgMemberMap[1].put(mbgView.getMbgDim().getNumber(), tmpMap);
            }
        }
        catch (SQLException ex) {
            logger.error((Object)"sql error:", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return mbgMemberMap;
    }

    protected Map<String, String[]> getAcctByView(Connection conn, Locale locale, BOSUuid viewId) throws EASBizException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || viewId == null) {
            return members;
        }
        String[] member = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FNumber, FName_" + locale + " AS FName from T_MBG_BgAccount where FBgAccountViewId = ?"), (Object[])new Object[]{viewId.toString()});
            while (rst.next()) {
                member = new String[3];
                member[0] = rst.getString("FNumber");
                member[2] = rst.getString("FName");
                members.put(member[0], member);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return members;
    }

    protected Map<String, String[]> getPeriodByView(Connection conn, Locale locale, List<BOSUuid> viewIds) throws EASBizException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || viewIds == null || viewIds.isEmpty()) {
            return members;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FNumber, FName_" + locale + " AS FName from T_MBG_BgPeriodDisp where FTypeId IN (");
        for (BOSUuid uuid : viewIds) {
            sql.append("'" + uuid.toString() + "',");
        }
        sql.setLength(sql.length() - 1);
        sql.append(")");
        String[] member = null;
        IRowSet rst = null;
        try {
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString());
            while (rst.next()) {
                member = new String[3];
                member[0] = rst.getString("FNumber");
                member[2] = rst.getString("FName");
                members.put(member[0], member);
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return members;
    }

    protected Map<String, String[]> getBgScenario(Connection conn, Locale locale, List<String> numbers) throws SQLException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || numbers == null || numbers.isEmpty()) {
            return members;
        }
        BgScenarioInfo scenarioInfo = null;
        String[] member = null;
        Map<String, BgScenarioInfo> scenarioMap = MbgDataHelper.getBgScenarioMap(conn, locale);
        for (String number : numbers) {
            scenarioInfo = scenarioMap.get(number);
            member = new String[3];
            member[0] = scenarioInfo.getNumber();
            member[2] = scenarioInfo.getName();
            members.put(member[0], member);
        }
        return members;
    }

    protected Map<String, String[]> getBgVersion(Connection conn, Locale locale, List<String> numbers) throws SQLException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || numbers == null || numbers.isEmpty()) {
            return members;
        }
        BgVersionInfo versionInfo = null;
        String[] member = null;
        Map<String, BgVersionInfo> versionMap = MbgDataHelper.getBgVersionMap(conn, locale);
        for (String number : numbers) {
            if (!versionMap.containsKey(number)) continue;
            versionInfo = versionMap.get(number);
            member = new String[3];
            member[0] = versionInfo.getNumber();
            member[2] = versionInfo.getName();
            members.put(member[0], member);
        }
        return members;
    }

    protected Map<String, String[]> getCurrency(Connection conn, Locale locale, List<String> numbers) throws EASBizException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || numbers == null || numbers.isEmpty()) {
            return members;
        }
        CurrencyInfo currencyInfo = null;
        String[] member = null;
        Map<String, CurrencyInfo> currencyMap = MbgDataHelper.getCurrencyMap(conn, locale, numbers);
        if (currencyMap == null) {
            return members;
        }
        HashSet<String> numberSet = new HashSet<String>(numbers);
        if (numberSet.size() > currencyMap.keySet().size()) {
            numberSet.removeAll(currencyMap.keySet());
            throw new DimensionException(DimensionException.CURRENCYDELETEDBYOTHERS, new Object[]{((Object)numberSet).toString()});
        }
        for (String number : numbers) {
            currencyInfo = currencyMap.get(number);
            member = new String[3];
            member[0] = currencyInfo.getNumber();
            member[2] = currencyInfo.getName();
            members.put(member[0], member);
        }
        return members;
    }

    protected Map<String, String[]> getBgElement(Connection conn, Locale locale, List<String> numbers) throws EASBizException {
        HashMap<String, String[]> members = new HashMap<String, String[]>();
        if (conn == null || locale == null || numbers == null || numbers.isEmpty()) {
            return members;
        }
        BgElementInfo elementInfo = null;
        String[] member = null;
        Map<String, BgElementInfo> elementMap = MbgDataHelper.getBgElementMap(conn, locale, numbers);
        for (String number : numbers) {
            elementInfo = elementMap.get(number);
            member = new String[3];
            member[0] = elementInfo.getNumber();
            member[2] = elementInfo.getName();
            members.put(member[0], member);
        }
        return members;
    }

    protected Map<String, Object> getMemberByView(Connection conn, Locale locale, String viewId, boolean isSegregate) throws EASBizException {
        if (conn == null || locale == null || StringUtils.isEmpty((String)viewId)) {
            return null;
        }
        String orgUnitId = null;
        HashMap<String, Object> memberMap = new HashMap<String, Object>();
        Map<String, String[]> members = null;
        String[] member = null;
        IRowSet rst = null;
        try {
            if (isSegregate) {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FOrgUnitId, FNumber, FName_" + locale + " AS FName from T_MBG_MbgMember where FViewId = ?"), (Object[])new Object[]{viewId});
                while (rst.next()) {
                    orgUnitId = rst.getString("FOrgUnitId");
                    if (memberMap.containsKey(orgUnitId)) {
                        members = (Map)memberMap.get(orgUnitId);
                    } else {
                        members = new HashMap();
                        memberMap.put(orgUnitId, members);
                    }
                    member = new String[3];
                    member[0] = rst.getString("FNumber");
                    member[2] = rst.getString("FName");
                    members.put(member[0], member);
                }
            } else {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)("select FNumber, FName_" + locale + " AS FName from T_MBG_MbgMember where FViewId = ?"), (Object[])new Object[]{viewId});
                while (rst.next()) {
                    member = new String[3];
                    member[0] = rst.getString("FNumber");
                    member[2] = rst.getString("FName");
                    memberMap.put(member[0], member);
                }
            }
        }
        catch (SQLException ex) {
            try {
                logger.error((Object)"sql error:", (Throwable)ex);
                throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return memberMap;
    }

    @Override
    protected Object _checkMbgFormula(Context ctx, Map exprMap) throws BOSException, EASBizException {
        if (ctx == null || exprMap == null || exprMap.isEmpty()) {
            return null;
        }
        DimensionCacheHelper cacheHelper = null;
        String currentOrgNumber = ContextUtil.getCurrentCostUnit((Context)ctx).getNumber();
        Map exMap = exprMap;
        Map cellMap = null;
        Map checkObj = null;
        String srcNum2 = null;
        BgSchemeDimensionHelper schemeHelper = null;
        String orgNum2 = null;
        String bgSchemeId = null;
        String orgUnitId = null;
        String dimNumber = null;
        String funcName2 = null;
        String cellName2 = null;
        Map<Object, Object> bgSchemeMap = new HashMap();
        HashMap<String, Map<String, String>> schemeOrgUnitMap = new HashMap<String, Map<String, String>>();
        HashMap<String, Map<String, Map<String, String>>> errorMap = new HashMap<String, Map<String, Map<String, String>>>();
        Map memberSet = null;
        HashMap<String, BgSchemeDimensionHelper> schemeHelperMap = new HashMap<String, BgSchemeDimensionHelper>();
        HashMap<String, Map<String, Map<String, Set<String>>>> membersMap = new HashMap<String, Map<String, Map<String, Set<String>>>>();
        HashMap<String, Map<String, Map<String, Map<String, Object>>>> queryMembersMap = new HashMap<String, Map<String, Map<String, Map<String, Object>>>>();
        HashMap<String, Set<String>> orgTreeMap = new HashMap<String, Set<String>>();
        HashSet<String> costUnitNumbers = new HashSet<String>();
        IDimensionFormulaFacade iDimensionFormulaFacade = DimensionFormulaFacadeFactory.getLocalInstance(ctx);
        for (String funcName2 : exMap.keySet()) {
            cellMap = (Map)exMap.get(funcName2);
            for (String cellName2 : cellMap.keySet()) {
                String orgTreeNum;
                checkObj = (Map)cellMap.get(cellName2);
                if (funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAggregateStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAdjustStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAdjustDateStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgBgAvlBalStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgControlStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgRefBgTemplateStr)) {
                    this.mergeMap(checkObj, membersMap);
                    continue;
                }
                if (funcName2.equalsIgnoreCase(BgExpressionHelper.BgCslStr)) {
                    if (cacheHelper == null) {
                        cacheHelper = new DimensionCacheHelper(ctx);
                    }
                    if (!checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)) {
                        checkObj.put(DimensionConstants.DEF_ORGUNIT_SRCNUMBER, currentOrgNumber);
                    }
                    this.mergeMap(checkObj, membersMap);
                    if (!checkObj.containsKey(BgExpressionHelper.ORGTREE) || StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.ORGTREE)))) continue;
                    orgTreeNum = (String)checkObj.get(BgExpressionHelper.ORGTREE);
                    if (!orgTreeMap.containsKey(orgTreeNum)) {
                        orgTreeMap.put(orgTreeNum, new HashSet());
                    }
                    if (!checkObj.containsKey(BgExpressionHelper.GROUPORG) || StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.GROUPORG)))) continue;
                    ((Set)orgTreeMap.get(orgTreeNum)).add((String)checkObj.get(BgExpressionHelper.GROUPORG));
                    continue;
                }
                if (funcName2.equalsIgnoreCase(BgExpressionHelper.MbgRefBgFormStr)) {
                    this.mergeMap(checkObj, membersMap);
                    if (!checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER) || StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)))) continue;
                    costUnitNumbers.add((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER));
                    continue;
                }
                if (!funcName2.equalsIgnoreCase(BgExpressionHelper.MbgCorUnitStr)) continue;
                if (cacheHelper == null) {
                    cacheHelper = new DimensionCacheHelper(ctx);
                }
                this.mergeMap(checkObj, membersMap);
                if (!checkObj.containsKey(BgExpressionHelper.ORGTREE) || StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.ORGTREE)))) continue;
                orgTreeNum = (String)checkObj.get(BgExpressionHelper.ORGTREE);
                if (!orgTreeMap.containsKey(orgTreeNum)) {
                    orgTreeMap.put(orgTreeNum, new HashSet());
                }
                if (!checkObj.containsKey(BgExpressionHelper.GROUPORG) || StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.GROUPORG)))) continue;
                ((Set)orgTreeMap.get(orgTreeNum)).add((String)checkObj.get(BgExpressionHelper.GROUPORG));
            }
        }
        HashSet<String> schemeNumbers = new HashSet<String>(membersMap.keySet());
        if (!schemeNumbers.isEmpty()) {
            bgSchemeMap = this.queryBgScheme(ctx, schemeNumbers, membersMap);
        }
        HashSet<String> orgNumbers = new HashSet<String>();
        for (String schemeNum : membersMap.keySet()) {
            if (!bgSchemeMap.containsKey(schemeNum)) continue;
            bgSchemeId = (String)bgSchemeMap.get(schemeNum);
            schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
            schemeHelperMap.put(schemeNum, schemeHelper);
            Iterator iter = ((Map)membersMap.get(schemeNum)).keySet().iterator();
            while (iter.hasNext()) {
                orgNumbers.add((String)iter.next());
            }
            if (orgNumbers.isEmpty()) continue;
            schemeOrgUnitMap.put(schemeNum, this.queryOrgUnit(ctx, orgNumbers, schemeHelper));
        }
        for (String schemeNum : membersMap.keySet()) {
            if (!bgSchemeMap.containsKey(schemeNum) || !schemeOrgUnitMap.containsKey(schemeNum)) continue;
            bgSchemeId = (String)bgSchemeMap.get(schemeNum);
            queryMembersMap.put(schemeNum, new HashMap());
            for (String orgNum2 : ((Map)membersMap.get(schemeNum)).keySet()) {
                if (!((Map)schemeOrgUnitMap.get(schemeNum)).containsKey(orgNum2)) continue;
                memberSet = (Map)((Map)membersMap.get(schemeNum)).get(orgNum2);
                ((Map)queryMembersMap.get(schemeNum)).put(orgNum2, new HashMap());
                orgUnitId = (String)((Map)schemeOrgUnitMap.get(schemeNum)).get(orgNum2);
                for (String srcNum2 : memberSet.keySet()) {
                    if (!((BgSchemeDimensionHelper)schemeHelperMap.get(schemeNum)).getDimensionBySrcNumber().containsKey(srcNum2)) continue;
                    dimNumber = ((BgSchemeDimensionHelper)schemeHelperMap.get(schemeNum)).getDimensionBySrcNumber().get(srcNum2).getNumber();
                    Map queryMap = iDimensionFormulaFacade.queryMembers(orgUnitId, bgSchemeId, dimNumber, (Set)memberSet.get(srcNum2));
                    if (dimNumber.equals(DimensionConstants.DEF_PERIOD_NUMBER)) {
                        this.checkBgSchemePeriod(ctx, bgSchemeId, queryMap);
                    }
                    ((Map)((Map)queryMembersMap.get(schemeNum)).get(orgNum2)).put(srcNum2, queryMap);
                }
            }
        }
        Map<String, Set<String>> existOrgTreeMap = this.queryExistOrgTree(ctx, orgTreeMap, cacheHelper);
        Set<String> existCostUnitNumbers = this.queryExistCostUnitNumbers(ctx, costUnitNumbers);
        for (String funcName2 : exMap.keySet()) {
            cellMap = (Map)exMap.get(funcName2);
            for (String cellName2 : cellMap.keySet()) {
                checkObj = (Map)cellMap.get(cellName2);
                if (funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAggregateStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAdjustStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgAdjustDateStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgBgAvlBalStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgControlStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgRefBgTemplateStr)) {
                    this.checkMembers(ctx, errorMap, checkObj, bgSchemeMap, schemeOrgUnitMap, queryMembersMap, schemeHelperMap, false);
                    continue;
                }
                if (funcName2.equalsIgnoreCase(BgExpressionHelper.BgCslStr) || funcName2.equalsIgnoreCase(BgExpressionHelper.MbgCorUnitStr)) {
                    this.checkOrgTree(ctx, errorMap, checkObj, existOrgTreeMap);
                    this.checkMembers(ctx, errorMap, checkObj, bgSchemeMap, schemeOrgUnitMap, queryMembersMap, schemeHelperMap, true);
                    continue;
                }
                if (!funcName2.equalsIgnoreCase(BgExpressionHelper.MbgRefBgFormStr)) continue;
                this.checkMembers(ctx, errorMap, checkObj, bgSchemeMap, schemeOrgUnitMap, queryMembersMap, schemeHelperMap, false);
                this.checkCostUnit(ctx, errorMap, checkObj, existCostUnitNumbers);
            }
        }
        return errorMap;
    }

    private void checkCostUnit(Context ctx, Map<String, Map<String, Map<String, String>>> errorMap, Map<String, Object> checkObj, Set<String> existCostUnitNumbers) {
        String costUnitNumber;
        Locale locale = ctx.getLocale();
        String sheetName = (String)checkObj.get(BgExpressionHelper.SHEETNAME);
        String cellName = (String)checkObj.get(BgExpressionHelper.CELLNAME);
        String expression = (String)checkObj.get(BgExpressionHelper.EXPRESSION);
        if (checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER) && !StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER))) && !existCostUnitNumbers.contains(costUnitNumber = (String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER))) {
            this.addSheetCellKey(errorMap, sheetName, cellName);
            if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_costUnit", (Locale)locale, (Object[])new Object[]{costUnitNumber}));
            }
            return;
        }
    }

    private void checkOrgTree(Context ctx, Map<String, Map<String, Map<String, String>>> errorMap, Map<String, Object> checkObj, Map<String, Set<String>> existOrgTreeMap) {
        Locale locale = ctx.getLocale();
        String sheetName = (String)checkObj.get(BgExpressionHelper.SHEETNAME);
        String cellName = (String)checkObj.get(BgExpressionHelper.CELLNAME);
        String expression = (String)checkObj.get(BgExpressionHelper.EXPRESSION);
        if (checkObj.containsKey(BgExpressionHelper.ORGTREE) && !StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.ORGTREE)))) {
            String orgTreeNum = (String)checkObj.get(BgExpressionHelper.ORGTREE);
            if (!existOrgTreeMap.containsKey(orgTreeNum)) {
                this.addSheetCellKey(errorMap, sheetName, cellName);
                if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                    errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_orgTree", (Locale)locale, (Object[])new Object[]{orgTreeNum}));
                }
                return;
            }
            if (checkObj.containsKey(BgExpressionHelper.GROUPORG) && !StringUtils.isEmpty((String)((String)checkObj.get(BgExpressionHelper.GROUPORG)))) {
                String groupOrgNum = (String)checkObj.get(BgExpressionHelper.GROUPORG);
                if (!existOrgTreeMap.get(orgTreeNum).contains(groupOrgNum)) {
                    this.addSheetCellKey(errorMap, sheetName, cellName);
                    if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                        errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_groupOrg", (Locale)locale, (Object[])new Object[]{groupOrgNum}));
                    }
                    return;
                }
            }
        }
    }

    private Map<String, Set<String>> queryExistOrgTree(Context ctx, Map<String, Set<String>> orgTreeMap, DimensionCacheHelper cacheHelper) throws BOSException {
        HashMap<String, Set<String>> existMap = new HashMap<String, Set<String>>();
        if (orgTreeMap == null || orgTreeMap.isEmpty() || cacheHelper == null) {
            return existMap;
        }
        OrgTreeInfo orgTreeInfo = null;
        String orgTreeNum2 = null;
        Set<String> groupOrgNums = null;
        try {
            for (String orgTreeNum2 : orgTreeMap.keySet()) {
                groupOrgNums = orgTreeMap.get(orgTreeNum2);
                orgTreeInfo = cacheHelper.getOrgTreeInfoByNumber(ctx, orgTreeNum2);
                if (orgTreeInfo == null) continue;
                existMap.put(orgTreeNum2, this.queryGroupOrgNumbers(ctx, orgTreeInfo.getNumber(), groupOrgNums));
            }
        }
        catch (ParseException e) {
            throw new BOSException(" ", (Throwable)e);
        }
        return existMap;
    }

    private void addSheetCellKey(Map<String, Map<String, Map<String, String>>> errorMap, String sheetName, String cellName) {
        if (!errorMap.containsKey(sheetName)) {
            errorMap.put(sheetName, new HashMap());
        }
        if (!errorMap.get(sheetName).containsKey(cellName)) {
            errorMap.get(sheetName).put(cellName, new HashMap());
        }
    }

    private void checkMembers(Context ctx, Map<String, Map<String, Map<String, String>>> errorMap, Map<String, Object> checkObj, Map<String, String> bgSchemeMap, Map<String, Map<String, String>> schemeOrgUnitMap, Map<String, Map<String, Map<String, Map<String, Object>>>> queryMembersMap, Map<String, BgSchemeDimensionHelper> schemeHelperMap, Boolean isCsl) {
        Locale locale = ctx.getLocale();
        String sheetName = (String)checkObj.get(BgExpressionHelper.SHEETNAME);
        String cellName = (String)checkObj.get(BgExpressionHelper.CELLNAME);
        String expression = (String)checkObj.get(BgExpressionHelper.EXPRESSION);
        if (checkObj.containsKey(DimensionConstants.DEF_SCHEME_SRCNUMBER) && checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)) {
            String schemeNum = null;
            if (checkObj.containsKey(DimensionConstants.DEF_SCHEME_SRCNUMBER) && !StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_SCHEME_SRCNUMBER)))) {
                schemeNum = (String)checkObj.get(DimensionConstants.DEF_SCHEME_SRCNUMBER);
            }
            if (!bgSchemeMap.containsKey(schemeNum) || !queryMembersMap.containsKey(schemeNum)) {
                this.addSheetCellKey(errorMap, sheetName, cellName);
                if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                    errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_scheme", (Locale)locale, (Object[])new Object[]{schemeNum}));
                }
                return;
            }
            String orgNum = null;
            if (checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER) && !StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)))) {
                orgNum = ((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)).trim();
                if (orgNum.indexOf(";") > 0) {
                    String[] orgArr = orgNum.split(";");
                    for (int x = 0; x < orgArr.length; ++x) {
                        String org = orgArr[x].trim();
                        if (!schemeOrgUnitMap.get(schemeNum).containsKey(org) || !queryMembersMap.get(schemeNum).containsKey(org)) {
                            this.addSheetCellKey(errorMap, sheetName, cellName);
                            if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                                errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_org", (Locale)locale, (Object[])new Object[]{org}));
                            }
                            return;
                        }
                        if (!schemeHelperMap.containsKey(schemeNum)) continue;
                        this.checkMemberMap(ctx, errorMap, checkObj, bgSchemeMap, schemeOrgUnitMap.get(schemeNum), queryMembersMap, schemeHelperMap.get(schemeNum), schemeNum, org, isCsl);
                    }
                } else {
                    if (!schemeOrgUnitMap.get(schemeNum).containsKey(orgNum) || !queryMembersMap.get(schemeNum).containsKey(orgNum)) {
                        this.addSheetCellKey(errorMap, sheetName, cellName);
                        if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                            errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_org", (Locale)locale, (Object[])new Object[]{orgNum}));
                        }
                        return;
                    }
                    if (schemeHelperMap.containsKey(schemeNum)) {
                        this.checkMemberMap(ctx, errorMap, checkObj, bgSchemeMap, schemeOrgUnitMap.get(schemeNum), queryMembersMap, schemeHelperMap.get(schemeNum), schemeNum, orgNum, isCsl);
                    }
                }
            }
        }
    }

    private void checkMemberMap(Context ctx, Map<String, Map<String, Map<String, String>>> errorMap, Map<String, Object> checkObj, Map<String, String> bgSchemeMap, Map<String, String> orgUnitMap, Map<String, Map<String, Map<String, Map<String, Object>>>> queryMembersMap, BgSchemeDimensionHelper schemeHelper, String schemeNumber, String orgNumber, Boolean isCsl) {
        Locale locale = ctx.getLocale();
        String sheetName = (String)checkObj.get(BgExpressionHelper.SHEETNAME);
        String cellName = (String)checkObj.get(BgExpressionHelper.CELLNAME);
        String expression = (String)checkObj.get(BgExpressionHelper.EXPRESSION);
        Map<String, BgDimensionInfo> dimensionMap = schemeHelper.getDimensionBySrcNumber();
        Map<String, Object> membrsMap = null;
        for (String srcNum : checkObj.keySet()) {
            String memberNumber;
            Object obj = checkObj.get(srcNum);
            if (!this.isDimMember(srcNum)) continue;
            if (!(dimensionMap.containsKey(srcNum) || isCsl.booleanValue() && DimensionConstants.DEF_CSL_SRCNUMBER.equals(srcNum))) {
                this.addSheetCellKey(errorMap, sheetName, cellName);
                if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                    errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_dimSrc", (Locale)locale, (Object[])new Object[]{srcNum}));
                }
                return;
            }
            if (queryMembersMap.get(schemeNumber).get(orgNumber).containsKey(srcNum)) {
                int endType;
                String[] pNumbers;
                membrsMap = queryMembersMap.get(schemeNumber).get(orgNumber).get(srcNum);
                if (obj instanceof String) {
                    memberNumber = (String)obj;
                    if (membrsMap.containsKey(memberNumber)) continue;
                    this.addSheetCellKey(errorMap, sheetName, cellName);
                    if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                        errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_dimensionMember", (Locale)locale, (Object[])new Object[]{memberNumber, this.getDimNameBySrcNum(srcNum, dimensionMap)}));
                    }
                    return;
                }
                if (!(obj instanceof Set)) continue;
                Set numbers = (Set)obj;
                for (String memberNumber2 : numbers) {
                    if (membrsMap.containsKey(memberNumber2)) continue;
                    this.addSheetCellKey(errorMap, sheetName, cellName);
                    if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                        errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_dimensionMember", (Locale)locale, (Object[])new Object[]{memberNumber2, this.getDimNameBySrcNum(srcNum, dimensionMap)}));
                    }
                    return;
                }
                if (numbers.size() <= 1 || !DimensionConstants.DEF_PERIOD_SRCNUMBER.equals(srcNum) || StringUtils.isEmpty((String)(pNumbers = numbers.toArray(new String[0]))[0]) || StringUtils.isEmpty((String)pNumbers[1])) continue;
                boolean isSameBgPeriodGroup = BgNPeriodHelper.isSameBgPeriodGroup((String)pNumbers[0], (String)pNumbers[1]);
                if (!isSameBgPeriodGroup) {
                    this.addSheetCellKey(errorMap, sheetName, cellName);
                    if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                        errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_periodGroup", (Locale)locale));
                    }
                    return;
                }
                int beginType = BgNPeriodHelper.parserBgPeriodType((String)pNumbers[0]);
                if (beginType == (endType = BgNPeriodHelper.parserBgPeriodType((String)pNumbers[1]))) continue;
                this.addSheetCellKey(errorMap, sheetName, cellName);
                if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                    errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_periodType", (Locale)locale));
                }
                return;
            }
            if (!isCsl.booleanValue() || !DimensionConstants.DEF_CSL_SRCNUMBER.equals(srcNum) || !(obj instanceof String) || BgCslDimConstants.canEditCslAjdNumberSet.contains(memberNumber = (String)obj)) continue;
            this.addSheetCellKey(errorMap, sheetName, cellName);
            if (!errorMap.get(sheetName).get(cellName).containsKey(expression)) {
                errorMap.get(sheetName).get(cellName).put(expression, ResourceBase.getString((String)BgExpressionHelper.BgFormMsgResource, (String)"formulaCheck_dimensionMember", (Locale)locale, (Object[])new Object[]{memberNumber, DimensionConstants.getDefCslName(locale)}));
            }
            return;
        }
    }

    private String getDimNameBySrcNum(String srcNum, Map<String, BgDimensionInfo> dimensionMap) {
        if (!StringUtils.isEmpty((String)srcNum) && !dimensionMap.isEmpty() && dimensionMap.containsKey(srcNum)) {
            return dimensionMap.get(srcNum).getName();
        }
        return null;
    }

    private boolean isDimMember(String key) {
        return !DimensionConstants.DEF_SCHEME_SRCNUMBER.equals(key) && !DimensionConstants.DEF_ORGUNIT_SRCNUMBER.equals(key) && !BgExpressionHelper.FUNCIONNAME.equals(key) && !BgExpressionHelper.EXPRESSION.equals(key) && !BgExpressionHelper.SHEETNAME.equals(key) && !BgExpressionHelper.CELLNAME.equals(key) && !BgExpressionHelper.ERROR_MSG.equals(key) && !BgExpressionHelper.PARAMS_COUNT.equals(key) && !BgExpressionHelper.ORGTREE.equals(key) && !BgExpressionHelper.GROUPORG.equals(key);
    }

    private Map<String, String> queryBgScheme(Context ctx, Set<String> schemeNumbers, Map<String, Map<String, Map<String, Set<String>>>> membersMap) throws BOSException, EASBizException {
        BgSchemeCollection colls;
        if (schemeNumbers == null || schemeNumbers.isEmpty()) {
            return null;
        }
        HashSet schemeIds = new HashSet();
        IBgScheme iBgScheme = BgSchemeFactory.getLocalInstance(ctx);
        HashSet<String> orgNumbers = new HashSet<String>();
        String schemeNum2 = null;
        Map<String, Map<String, Set<String>>> values = null;
        for (String schemeNum2 : membersMap.keySet()) {
            values = membersMap.get(schemeNum2);
            orgNumbers.addAll(new HashSet<String>(values.keySet()));
        }
        EntityViewInfo view1 = new EntityViewInfo();
        FilterInfo filter1 = new FilterInfo();
        view1.setFilter(filter1);
        SelectorItemCollection selector1 = new SelectorItemCollection();
        selector1.add(new SelectorItemInfo("id"));
        selector1.add(new SelectorItemInfo("number"));
        view1.setSelector(selector1);
        filter1.getFilterItems().add(new FilterItemInfo("number", orgNumbers, CompareType.INCLUDE));
        CostCenterOrgUnitCollection costs = CostCenterOrgUnitFactory.getLocalInstance((Context)ctx).getCostCenterOrgUnitCollection(view1);
        if (costs != null && !costs.isEmpty()) {
            for (int i = 0; i < costs.size(); ++i) {
                schemeIds.addAll(iBgScheme.getCollection4SchemeList(costs.get(i).getId().toString(), true));
            }
        }
        HashMap<String, String> schemeMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("number", schemeNumbers, CompareType.INCLUDE));
        if (!schemeIds.isEmpty()) {
            filter.getFilterItems().add(new FilterItemInfo("id", schemeIds, CompareType.INCLUDE));
        }
        if ((colls = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(view)) != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                schemeMap.put(colls.get(i).getNumber(), colls.get(i).getId().toString());
            }
        }
        return schemeMap;
    }

    private Map<String, String> queryOrgUnit(Context ctx, Set<String> costUnitNumbers, BgSchemeDimensionHelper schemeHelper) throws BOSException {
        HashMap<String, String> orgMap = new HashMap<String, String>();
        if (costUnitNumbers == null || costUnitNumbers.isEmpty()) {
            return orgMap;
        }
        String orgViewId = schemeHelper.getBgOrgViewId();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("orgUnitID"));
        view.setSelector(selector);
        filter.getFilterItems().add(new FilterItemInfo("number", costUnitNumbers, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("viewID", (Object)orgViewId, CompareType.EQUALS));
        BgOrgUnitCollection colls = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
        if (colls != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                orgMap.put(colls.get(i).getNumber(), colls.get(i).getOrgUnitID());
            }
        }
        return orgMap;
    }

    private void mergeMap(Map<String, Object> checkObj, Map<String, Map<String, Map<String, Set<String>>>> membersMap) {
        block13: {
            if (!checkObj.containsKey(DimensionConstants.DEF_SCHEME_SRCNUMBER) || !checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)) break block13;
            String schemeNum = null;
            if (checkObj.containsKey(DimensionConstants.DEF_SCHEME_SRCNUMBER) && !StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_SCHEME_SRCNUMBER))) && !membersMap.containsKey(schemeNum = (String)checkObj.get(DimensionConstants.DEF_SCHEME_SRCNUMBER))) {
                membersMap.put(schemeNum, new HashMap());
            }
            String orgNum = null;
            if (checkObj.containsKey(DimensionConstants.DEF_ORGUNIT_SRCNUMBER) && !StringUtils.isEmpty((String)((String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER)))) {
                orgNum = (String)checkObj.get(DimensionConstants.DEF_ORGUNIT_SRCNUMBER);
                if (orgNum.indexOf(";") > 0) {
                    String[] orgArr = orgNum.split(";");
                    for (int i = 0; i < orgArr.length; ++i) {
                        String org = orgArr[i].trim();
                        if (!membersMap.get(schemeNum).containsKey(org)) {
                            membersMap.get(schemeNum).put(org, new HashMap());
                        }
                        for (String key : checkObj.keySet()) {
                            Object obj = checkObj.get(key);
                            if (!this.isDimMember(key)) continue;
                            if (!membersMap.get(schemeNum).get(org).containsKey(key)) {
                                membersMap.get(schemeNum).get(org).put(key, new HashSet());
                            }
                            if (obj instanceof String) {
                                membersMap.get(schemeNum).get(org).get(key).add((String)obj);
                                continue;
                            }
                            if (!(obj instanceof Set)) continue;
                            membersMap.get(schemeNum).get(org).get(key).addAll((Set)obj);
                        }
                    }
                } else {
                    if (!membersMap.get(schemeNum).containsKey(orgNum)) {
                        membersMap.get(schemeNum).put(orgNum, new HashMap());
                    }
                    for (String key : checkObj.keySet()) {
                        Object obj = checkObj.get(key);
                        if (!this.isDimMember(key)) continue;
                        if (!membersMap.get(schemeNum).get(orgNum).containsKey(key)) {
                            membersMap.get(schemeNum).get(orgNum).put(key, new HashSet());
                        }
                        if (obj instanceof String) {
                            membersMap.get(schemeNum).get(orgNum).get(key).add((String)obj);
                            continue;
                        }
                        if (!(obj instanceof Set)) continue;
                        membersMap.get(schemeNum).get(orgNum).get(key).addAll((Set)obj);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryGroupOrgNumbers(Context ctx, String orgTreeNumber, Set<String> orgUnitNumbers) {
        if (StringUtils.isEmpty((String)orgTreeNumber) || orgUnitNumbers == null || orgUnitNumbers.isEmpty()) {
            return null;
        }
        HashSet<String> orgNumbers = new HashSet<String>();
        StringBuffer querySql = new StringBuffer();
        IRowSet rs = null;
        try {
            querySql.append("SELECT UNIT.FID,UNIT.FNUMBER,UNIT.FNAME_l2 FROM T_ORG_Structure AS ORGSTRUCTURE").append(" LEFT OUTER JOIN T_ORG_BaseUnit UNIT  ON ORGSTRUCTURE.FUnitId = UNIT.FID ").append(" LEFT OUTER JOIN T_ORG_Tree AS TREE ON ORGSTRUCTURE.FTreeId = TREE.FID").append(" WHERE TREE.FNUMBER  = '").append(orgTreeNumber).append("' AND UNIT.FNUMBER IN (");
            for (String number : orgUnitNumbers) {
                querySql.append(" '").append((Object)number).append("',");
            }
            querySql.deleteCharAt(querySql.length() - 1).append(" )");
            rs = BgDBUtils.executeQuery((Context)ctx, (String)querySql.toString());
            if (rs.next()) {
                orgNumbers.add(rs.getString("FNUMBER"));
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error((Object)"MbgMemberFacadeControllerBean  queryExistOrgTree error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return orgNumbers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> queryExistCostUnitNumbers(Context ctx, Set<String> costUnitNumbers) {
        HashSet<String> orgNumbers = new HashSet<String>();
        if (costUnitNumbers == null || costUnitNumbers.isEmpty()) {
            return orgNumbers;
        }
        StringBuffer querySql = new StringBuffer();
        IRowSet rs = null;
        try {
            querySql.append("SELECT FNUMBER FROM T_ORG_COSTCENTER WHERE FNUMBER IN ( ");
            for (String number : costUnitNumbers) {
                querySql.append(" '").append(number).append("',");
            }
            querySql.deleteCharAt(querySql.length() - 1).append(" )");
            rs = BgDBUtils.executeQuery((Context)ctx, (String)querySql.toString());
            if (rs.next()) {
                orgNumbers.add(rs.getString("FNUMBER"));
            }
            SQLUtils.cleanup((ResultSet)rs);
        }
        catch (Exception e) {
            logger.error((Object)"MbgMemberFacadeControllerBean queryExistCostUnitNumbers error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rs);
        }
        return orgNumbers;
    }

    private void checkBgSchemePeriod(Context ctx, String schemeId, Map<String, Object> periodMap) throws BOSException, EASBizException {
        BgPeriodDispCollection colls;
        if (StringUtils.isEmpty((String)schemeId) || periodMap.isEmpty()) {
            return;
        }
        BgSchemeInfo bgSchemeInfo = MbgDataHelper.getBgSchemeInfo(ctx, BOSUuid.read((String)schemeId));
        CalendarHelper calendar = new CalendarHelper();
        Date beginDate = bgSchemeInfo.getDateFrom();
        Date endDate = bgSchemeInfo.getDateTo();
        String periodNum = null;
        HashSet<String> periodNumbers = new HashSet<String>(bgSchemeInfo.getMemberNumber(DimensionConstants.DEF_PERIOD_NUMBER));
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(new FilterInfo());
        evi.setSelector(new SelectorItemCollection());
        evi.setSorter(new SorterItemCollection());
        evi.getSelector().add("id");
        evi.getSelector().add("bgPeriod.year");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("longNumber");
        evi.getSelector().add("periodType");
        SorterItemInfo sic = new SorterItemInfo("bgPeriod.year");
        sic.setSortType(SortType.ASCEND);
        evi.getSorter().add(sic);
        evi.getFilter().getFilterItems().add(new FilterItemInfo("type.number", periodNumbers, CompareType.INCLUDE));
        if (beginDate != null && endDate != null) {
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(beginDate)), CompareType.GREATER_EQUALS));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.year", (Object)new Integer(calendar.getCurrentlyYear(endDate)), CompareType.LESS_EQUALS));
        }
        if ((colls = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi)) != null && !colls.isEmpty()) {
            for (int i = 0; i < colls.size(); ++i) {
                periodNumbers.add(colls.get(i).getNumber());
            }
            Iterator<String> ite = periodMap.keySet().iterator();
            while (ite.hasNext()) {
                periodNum = ite.next();
                if (periodNumbers.contains(periodNum)) continue;
                ite.remove();
            }
        }
    }
}

