/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionCollection;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.MbgPermissionInfo;
import com.kingdee.eas.ma.mbg.MbgPermissionTypeEnum;
import com.kingdee.eas.ma.mbg.RptSrcTypeEnum;
import com.kingdee.eas.ma.mbg.app.AbstractMbgPermissionControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.MbgPermissionHelper;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MbgPermissionControllerBean
extends AbstractMbgPermissionControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgPermissionControllerBean");

    public IObjectPK[] saveBatchData(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        this.replaceExistUniqueKeyRecord(ctx, colls);
        this.addLog(ctx, (IObjectCollection)colls, "mbg_mbgPermission_addNew");
        IObjectPK[] pks = super.saveBatchData(ctx, colls);
        this.dealSheetTable(ctx, pks, colls);
        return pks;
    }

    private void printLog(Context ctx, MbgPermissionInfo info, String logItem) {
        String detail = info.getPermissionTarget().getAlias() + " : " + info.getPermissionType().getAlias();
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"saveBatchData", (BOSObjectType)this.getBOSType(), null, (String)detail, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    private void addLog(Context ctx, IObjectCollection colls, String logItem) {
        if (colls == null || colls.isEmpty()) {
            return;
        }
        String detail = ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgPermissionResource", (String)"dataPermissionBatchAddNew", (Locale)ctx.getLocale());
        IObjectPK tempPK = LogUtil.beginLog((Context)ctx, (String)"saveBatchData", (BOSObjectType)this.getBOSType(), null, (String)detail, (String)logItem);
        LogUtil.afterLog((Context)ctx, (IObjectPK)tempPK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceExistUniqueKeyRecord(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        block18: {
            if (colls == null || colls.isEmpty()) {
                return;
            }
            HashMap<String, MbgPermissionInfo> addColls = new HashMap<String, MbgPermissionInfo>();
            HashSet uniqueKeySet = new HashSet();
            MbgPermissionInfo mbgOldPermInfo = null;
            MbgPermissionInfo mbgNewPermInfo = null;
            MbgPermissionCollection existMbgPermColls = null;
            CoreBaseCollection updateColls = new CoreBaseCollection();
            String uniqueKey = null;
            RptSrcTypeEnum sourceType = null;
            int count = colls.size();
            for (int i = 0; i < count; ++i) {
                mbgNewPermInfo = (MbgPermissionInfo)colls.get(i);
                if (sourceType == null && mbgNewPermInfo.getSourceType() != null) {
                    sourceType = mbgNewPermInfo.getSourceType();
                }
                uniqueKey = mbgNewPermInfo.getUniqueKey();
                addColls.put(uniqueKey, mbgNewPermInfo);
            }
            uniqueKeySet.addAll(addColls.keySet());
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("uniqueKey", uniqueKeySet, CompareType.INCLUDE));
            if (sourceType != null) {
                filterInfo.getFilterItems().add(new FilterItemInfo("sourceType", (Object)sourceType.getValue(), CompareType.EQUALS));
            }
            evi.setFilter(filterInfo);
            existMbgPermColls = MbgPermissionFactory.getLocalInstance(ctx).getMbgPermissionCollection(evi);
            if (existMbgPermColls != null && !existMbgPermColls.isEmpty()) {
                Iterator it = existMbgPermColls.iterator();
                while (it.hasNext()) {
                    mbgOldPermInfo = (MbgPermissionInfo)it.next();
                    mbgNewPermInfo = (MbgPermissionInfo)addColls.get(mbgOldPermInfo.getUniqueKey());
                    mbgOldPermInfo.setCreateTime(mbgNewPermInfo.getCreateTime());
                    mbgOldPermInfo.setCreator(mbgNewPermInfo.getCreator());
                    mbgOldPermInfo.setOrgUnit(mbgNewPermInfo.getOrgUnit());
                    mbgOldPermInfo.put("sheetObj", mbgNewPermInfo.get("sheetObj"));
                    updateColls.add((CoreBaseInfo)mbgOldPermInfo);
                    colls.remove((CoreBaseInfo)mbgNewPermInfo);
                }
                if (!updateColls.isEmpty()) {
                    IObjectPK[] pks = this._saveBatchData(ctx, (IObjectCollection)updateColls);
                    PreparedStatement pstmt1 = null;
                    PreparedStatement pstmt2 = null;
                    PreparedStatement pstmt3 = null;
                    Connection conn = null;
                    ResultSet rst = null;
                    try {
                        boolean flag1 = false;
                        boolean flag2 = false;
                        conn = this.getConnection(ctx);
                        pstmt1 = conn.prepareStatement("Insert Into T_MBG_BgSheetpermission ( FBgSheetPermissionID, FBgTemplateID, FSheetIndex, FSheetID, FSheetName, FIsSelect) values (?, ?, ?, ?, ?, ?)");
                        pstmt2 = conn.prepareStatement("update T_MBG_BgSheetpermission set FIsSelect=? , FSheetName=?  where FBgTemplateID=? and FBgSheetPermissionID=? and FSheetID=? ");
                        pstmt3 = conn.prepareStatement("select FSheetID from T_MBG_BgSheetpermission where FBgTemplateID=? and FBgSheetPermissionID=? and FSheetID=? ");
                        for (int i = 0; i < pks.length; ++i) {
                            MbgPermissionInfo permissionInfo = (MbgPermissionInfo)updateColls.get(i);
                            Map map = (Map)permissionInfo.get("sheetObj");
                            if (map == null) continue;
                            String[] ids = ((String)map.get("ids")).toString().split(",");
                            String[] name = ((String)map.get("name")).toString().split(",");
                            String[] isNull = ((String)map.get("isNull")).toString().split(",");
                            String[] isSelect = ((String)map.get("isSelect")).toString().split(",");
                            String[] formType = ((String)map.get("formType")).toString().split(",");
                            for (int j = 0; j < ids.length; ++j) {
                                pstmt3.setString(1, permissionInfo.getBgTemplate().getId().toString());
                                pstmt3.setString(2, pks[i].toString());
                                pstmt3.setString(3, ids[j]);
                                rst = pstmt3.executeQuery();
                                int count2 = 0;
                                while (rst.next()) {
                                    ++count2;
                                }
                                if (count2 == 0) {
                                    pstmt1.setString(1, pks[i].toString());
                                    pstmt1.setString(2, permissionInfo.getBgTemplate().getId().toString());
                                    pstmt1.setInt(3, j);
                                    pstmt1.setString(4, ids[j]);
                                    pstmt1.setString(5, name[j]);
                                    pstmt1.setBoolean(6, Boolean.valueOf(isSelect[j]));
                                    pstmt1.addBatch();
                                    flag1 = true;
                                    continue;
                                }
                                pstmt2.setBoolean(1, Boolean.valueOf(isSelect[j]));
                                pstmt2.setString(2, name[j]);
                                pstmt2.setString(3, permissionInfo.getBgTemplate().getId().toString());
                                pstmt2.setString(4, pks[i].toString());
                                pstmt2.setString(5, ids[j]);
                                pstmt2.addBatch();
                                flag2 = true;
                            }
                        }
                        if (flag1) {
                            pstmt1.executeBatch();
                        }
                        if (flag2) {
                            pstmt2.executeBatch();
                        }
                        SQLUtils.cleanup((Statement)pstmt1);
                    }
                    catch (SQLException e) {
                        logger.error((Object)"", (Throwable)e);
                        break block18;
                    }
                    finally {
                        SQLUtils.cleanup(pstmt1);
                        SQLUtils.cleanup(pstmt2);
                        SQLUtils.cleanup(rst, pstmt3);
                        SQLUtils.cleanup((Connection)conn);
                    }
                    SQLUtils.cleanup((Statement)pstmt2);
                    SQLUtils.cleanup(rst, (Statement)pstmt3);
                    SQLUtils.cleanup((Connection)conn);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dealSheetTable(Context ctx, IObjectPK[] pks, CoreBaseCollection colls) throws BOSException, EASBizException {
        block12: {
            if (colls == null || colls.isEmpty()) {
                return;
            }
            PreparedStatement pstmt1 = null;
            PreparedStatement pstmt2 = null;
            PreparedStatement pstmt3 = null;
            Connection conn = null;
            ResultSet rst = null;
            try {
                boolean flag1 = false;
                boolean flag2 = false;
                conn = this.getConnection(ctx);
                pstmt1 = conn.prepareStatement("Insert Into T_MBG_BgSheetpermission ( FBgSheetPermissionID, FBgTemplateID, FSheetIndex, FSheetID, FSheetName, FIsSelect) values (?, ?, ?, ?, ?, ?)");
                pstmt2 = conn.prepareStatement("update T_MBG_BgSheetpermission set FIsSelect=? , FSheetName=?  where FBgTemplateID=? and FBgSheetPermissionID=? and FSheetID=? ");
                pstmt3 = conn.prepareStatement("select FSheetID from T_MBG_BgSheetpermission where FBgTemplateID=? and FBgSheetPermissionID=? and FSheetID=? ");
                for (int i = 0; i < pks.length; ++i) {
                    MbgPermissionInfo permissionInfo = (MbgPermissionInfo)colls.get(i);
                    Map map = (Map)permissionInfo.get("sheetObj");
                    if (map == null) continue;
                    String[] ids = ((String)map.get("ids")).toString().split(",");
                    String[] name = ((String)map.get("name")).toString().split(",");
                    String[] isNull = ((String)map.get("isNull")).toString().split(",");
                    String[] isSelect = ((String)map.get("isSelect")).toString().split(",");
                    String[] formType = ((String)map.get("formType")).toString().split(",");
                    for (int j = 0; j < ids.length; ++j) {
                        pstmt3.setString(1, permissionInfo.getBgTemplate().getId().toString());
                        pstmt3.setString(2, pks[i].toString());
                        pstmt3.setString(3, ids[j]);
                        rst = pstmt3.executeQuery();
                        int count = 0;
                        while (rst.next()) {
                            ++count;
                        }
                        if (count == 0) {
                            pstmt1.setString(1, pks[i].toString());
                            pstmt1.setString(2, permissionInfo.getBgTemplate().getId().toString());
                            pstmt1.setInt(3, j);
                            pstmt1.setString(4, ids[j]);
                            pstmt1.setString(5, name[j]);
                            pstmt1.setBoolean(6, Boolean.valueOf(isSelect[j]));
                            pstmt1.addBatch();
                            flag1 = true;
                            continue;
                        }
                        pstmt2.setBoolean(1, Boolean.valueOf(isSelect[j]));
                        pstmt2.setString(2, name[j]);
                        pstmt2.setString(3, permissionInfo.getBgTemplate().getId().toString());
                        pstmt2.setString(4, pks[i].toString());
                        pstmt2.setString(5, ids[j]);
                        pstmt2.addBatch();
                        flag2 = true;
                    }
                }
                if (flag1) {
                    pstmt1.executeBatch();
                }
                if (flag2) {
                    pstmt2.executeBatch();
                }
                SQLUtils.cleanup((Statement)pstmt1);
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                break block12;
            }
            finally {
                SQLUtils.cleanup(pstmt1);
                SQLUtils.cleanup(pstmt2);
                SQLUtils.cleanup(rst, pstmt3);
                SQLUtils.cleanup((Connection)conn);
            }
            SQLUtils.cleanup((Statement)pstmt2);
            SQLUtils.cleanup(rst, (Statement)pstmt3);
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected Set _getBgSchemePermission(Context ctx, RptSrcTypeEnum sourceType, String userId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        Set<String> bgSchemeIds = null;
        boolean isControlUse = false;
        bgSchemeIds = this.getPermitedCollectionByUserId(ctx, sourceType, userId, MbgPermissionTypeEnum.SCHEME, null);
        int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
        if (paramValue == 0) {
            bgSchemeIds.clear();
        } else if (paramValue == 2 && !(isControlUse = this._isControlByDataPermission(ctx, sourceType, userId, false))) {
            bgSchemeIds.clear();
        }
        return bgSchemeIds;
    }

    @Override
    protected Set _getBgTemplatePermission(Context ctx, RptSrcTypeEnum sourceType, String userId, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId) || StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        Set<String> bgTemlateIds = null;
        sourceType = this.replaceByBgScheme(ctx, sourceType, bgSchemeId);
        boolean isControlUse = false;
        bgTemlateIds = this.getPermitedCollectionByUserId(ctx, sourceType, userId, MbgPermissionTypeEnum.TEMPLATE, bgSchemeId);
        int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
        if (paramValue == 0) {
            bgTemlateIds.clear();
        } else if (paramValue == 2 && !(isControlUse = this._isControlByDataPermission(ctx, sourceType, userId, false))) {
            bgTemlateIds.clear();
        }
        return bgTemlateIds;
    }

    private RptSrcTypeEnum replaceByBgScheme(Context ctx, RptSrcTypeEnum sourceType, String bgSchemeId) throws BOSException {
        BgSchemeCollection col;
        if (!StringUtils.isEmpty((String)bgSchemeId) && (col = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection("select bgSchemeType.schemeType where id = '" + bgSchemeId + "'")) != null && !col.isEmpty()) {
            return col.get(0).getBgSchemeType().getSchemeType();
        }
        return sourceType;
    }

    @Override
    protected Set _getBgTemplateTypePermission(Context ctx, RptSrcTypeEnum sourceType, String userId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        Set<Object> bgBgTemplateTypeIds = new HashSet();
        ResultSet rst = null;
        Connection conn = null;
        Statement pstmt = null;
        boolean isControlUse = false;
        try {
            conn = this.getConnection(ctx);
            bgBgTemplateTypeIds = this.getPermitedCollectionByUserId(ctx, sourceType, userId, MbgPermissionTypeEnum.TEMPLATEGROUP, null);
            int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
            if (paramValue == 0) {
                bgBgTemplateTypeIds.clear();
            } else if (paramValue == 2 && !(isControlUse = this._isControlByDataPermission(ctx, sourceType, userId, false))) {
                bgBgTemplateTypeIds.clear();
            }
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
        return bgBgTemplateTypeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getPermitedCollectionByUserId(Context ctx, RptSrcTypeEnum sourceType, String userId, MbgPermissionTypeEnum mbgPermissionType, String bgSchemeId) {
        if (ctx == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        HashSet<String> permitedCollection = new HashSet<String>();
        Connection conn = null;
        Set<String> userGroupIds = null;
        Set<String> tmpSetOne = null;
        Set<String> tmpSetTwo = null;
        Set<String> tmpSetThree = null;
        Set<String> tmpSetFour = null;
        try {
            conn = this.getConnection(ctx);
            userGroupIds = this.getUserGroupIdsByUser(conn, userId);
            if (MbgPermissionTypeEnum.SCHEME.equals((Object)mbgPermissionType)) {
                tmpSetOne = this.getBgSchemeIdsByUserId(ctx, conn, userId, userGroupIds);
                tmpSetTwo = this.getBgSchemeIdsByRefTemplateAndOrgId(ctx, conn, userId, userGroupIds);
                tmpSetThree = this.getBgSchemeIdsByCreatorId(conn, userId);
                tmpSetOne.addAll(tmpSetTwo);
                tmpSetOne.addAll(tmpSetThree);
                permitedCollection.addAll(tmpSetOne);
            } else if (MbgPermissionTypeEnum.TEMPLATE.equals((Object)mbgPermissionType)) {
                tmpSetOne = this.getBgTemplateIdsByRefSchemeId(ctx, conn, userId, userGroupIds, bgSchemeId);
                tmpSetTwo = this.getBgTemplateIdsByRefGroupId(ctx, conn, userId, userGroupIds, bgSchemeId);
                tmpSetThree = this.getBgTemplateIdsByUserId(ctx, conn, userId, userGroupIds, bgSchemeId);
                if (tmpSetOne.size() > 0) {
                    if (tmpSetTwo.size() > 0) {
                        tmpSetOne.retainAll(tmpSetTwo);
                    }
                    if (tmpSetThree.size() > 0) {
                        tmpSetOne.retainAll(tmpSetThree);
                    }
                } else {
                    tmpSetOne = tmpSetThree;
                    if (tmpSetTwo.size() > 0) {
                        if (tmpSetOne.size() > 0) {
                            tmpSetOne.retainAll(tmpSetTwo);
                        } else {
                            tmpSetOne.addAll(tmpSetTwo);
                        }
                    }
                }
                tmpSetFour = this.getBgTemplateIdsByCreatorId(conn, userId, bgSchemeId);
                tmpSetOne.addAll(tmpSetFour);
                permitedCollection.addAll(tmpSetOne);
            } else if (MbgPermissionTypeEnum.TEMPLATEGROUP.equals((Object)mbgPermissionType)) {
                tmpSetOne = this.getTemplateTypeIdsByUserId(ctx, conn, userId, userGroupIds);
                permitedCollection.addAll(tmpSetOne);
            } else if (MbgPermissionTypeEnum.BGORG.equals((Object)mbgPermissionType)) {
                tmpSetOne = this.getBgOrgUnitIdsByRefSchemeId(ctx, conn, userId, userGroupIds, bgSchemeId);
                tmpSetTwo = this.getBgOrgUnitIdsByUserId(ctx, conn, userId, userGroupIds, bgSchemeId);
                if (tmpSetOne.size() > 0) {
                    if (tmpSetTwo.size() > 0) {
                        tmpSetOne.retainAll(tmpSetTwo);
                    }
                } else {
                    tmpSetOne = tmpSetTwo;
                }
                permitedCollection.addAll(tmpSetOne);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"get permited colls error ", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return permitedCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgTemplateIdsByRefSchemeId(Context ctx, Connection conn, String userId, Set<String> userGroupIds, String bgSchemeId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgTemplateIds = new HashSet<String>();
        Set<String> bgSchemeIds = null;
        StringBuffer sql = new StringBuffer();
        Object schemeAppendStr = null;
        try {
            bgSchemeIds = this.getBgSchemeIdsByUserId(ctx, conn, userId, userGroupIds);
            if (!bgSchemeIds.contains(bgSchemeId)) {
                HashSet<String> hashSet = bgTemplateIds;
                return hashSet;
            }
            if (!bgSchemeIds.isEmpty()) {
                sql.append("select fid from T_MBG_BGTEMPLATE where fbgschemeid = ? ");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, bgSchemeId);
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgTemplateIds.add(rst.getString("fid"));
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"get template error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return bgTemplateIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgTemplateIdsByRefGroupId(Context ctx, Connection conn, String userId, Set<String> userGroupIds, String bgSchemeId) {
        HashSet<String> bgTemplateIds;
        block8: {
            if (conn == null || StringUtils.isEmpty((String)userId)) {
                return null;
            }
            ResultSet rst = null;
            PreparedStatement pstmt = null;
            bgTemplateIds = new HashSet<String>();
            StringBuffer sql = new StringBuffer();
            String templateAppendStr = null;
            Set<String> bgTemplateTypeIds = null;
            Object bgSchemeIds = null;
            TempTablePool pool = null;
            try {
                pool = TempTablePool.getInstance((Context)ctx);
                bgTemplateTypeIds = this.getTemplateTypeIdsByUserId(ctx, conn, userId, userGroupIds);
                templateAppendStr = this.getAppendStrByColls(conn, pool, bgTemplateTypeIds);
                if (!bgTemplateTypeIds.isEmpty()) {
                    sql.append("select fid,fBgschemeid from T_MBG_BGTEMPLATE where fbgtypeid in ").append("(select FID from " + templateAppendStr + ")");
                    pstmt = conn.prepareStatement(sql.toString());
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        bgTemplateIds.add(rst.getString("fid"));
                    }
                    rst.close();
                    pstmt.close();
                }
                SQLUtils.cleanup(rst, pstmt);
            }
            catch (SQLException e) {
                logger.error((Object)"get template error", (Throwable)e);
                break block8;
            }
            finally {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, templateAppendStr);
            }
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)templateAppendStr);
        }
        return bgTemplateIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBgTemplateNotRefScheme(Context ctx, Connection conn, String userId, Set<String> userGroupIds, Set<String> bgTemplateIds) {
        if (conn == null || StringUtils.isEmpty((String)userId) || bgTemplateIds.isEmpty()) {
            return;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        String templateAppendStr = null;
        String userGroupAppendStr = null;
        StringBuffer sql = new StringBuffer();
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            templateAppendStr = this.getAppendStrByColls(conn, pool, bgTemplateIds);
            userGroupAppendStr = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select FBgTemplateID from T_MBG_MBGPERMISSION where ( FPersonID = ? and  FPermissionType = 3 ) AND FBgTemplateID IN ").append("(select FID from " + templateAppendStr + ")");
            } else {
                sql.append("select FBgTemplateID from T_MBG_MBGPERMISSION where ( FPersonID = ? OR fUserGroupId in ").append("(select FID from " + userGroupAppendStr + ")").append(" and  FPermissionType = 3 ) AND FBgTemplateID IN ").append(templateAppendStr);
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            bgTemplateIds.clear();
            while (rst.next()) {
                bgTemplateIds.add(rst.getString("FBgTemplateID"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"remove error", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, templateAppendStr);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, userGroupAppendStr);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)templateAppendStr);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)templateAppendStr);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgTemplateIdsByUserId(Context ctx, Connection conn, String userId, Set<String> userGroupIds, String bgSchemeId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgTemplateIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        TempTablePool pool = null;
        String tempTable = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select FBgTemplateID from T_MBG_MBGPERMISSION where ( FPersonID = ? and  FPermissionType = 3 )").append(" and FBgSchemeid = ? ");
            } else {
                sql.append("select FBgTemplateID from T_MBG_MBGPERMISSION where ( FPersonID = ? OR fUserGroupId in ").append("(select FID from " + tempTable + ")").append(" ) and  FPermissionType = 3").append(" and FBgSchemeid = ? ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateIds.add(rst.getString("FBgTemplateID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"get schemeid error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempTable);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        return bgTemplateIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgSchemeIdsByRefTemplateAndOrgId(Context ctx, Connection conn, String userId, Set<String> userGroupIds) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgSchemeIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String userGroupAppendStr = null;
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            userGroupAppendStr = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select FBgSchemeID from T_MBG_MBGPERMISSION where ( FPersonID = ? and  FPermissionType in(3,4) )");
            } else {
                sql.append("select FBgSchemeID from T_MBG_MBGPERMISSION where ( FPersonID = ? OR fUserGroupId in ").append("(select FID from " + userGroupAppendStr + ")").append(") and  FPermissionType in(3,4) ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIds.add(rst.getString("FBgSchemeID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"get schemeid error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, userGroupAppendStr);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
        return bgSchemeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgSchemeIdsByUserId(Context ctx, Connection conn, String userId, Set<String> userGroupIds) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgSchemeIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String userGroupAppendStr = null;
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            userGroupAppendStr = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select FBgSchemeID from T_MBG_MBGPERMISSION where FPersonID = ? and  FPermissionType = 1");
            } else {
                sql.append("select FBgSchemeID from T_MBG_MBGPERMISSION where ( FPersonID = ? OR  fUserGroupId in ").append("(select FID from " + userGroupAppendStr + ")").append(" ) and  FPermissionType = 1");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIds.add(rst.getString("FBgSchemeID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"get schemeid error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, userGroupAppendStr);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)userGroupAppendStr);
        return bgSchemeIds;
    }

    private String getAppendStrByColls(Connection conn, TempTablePool pool, Set<String> userGroupIds) {
        if (userGroupIds == null || userGroupIds.isEmpty()) {
            return null;
        }
        String tempTable = null;
        try {
            tempTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (Fid VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempTable + " (Fid) values (?)"), userGroupIds);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
        }
        return tempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Set<String> getUserGroupIdsByUser(Connection conn, String userId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> userGroupIds = new HashSet<String>();
        try {
            pstmt = conn.prepareStatement("select fUserGroupId from T_MBG_USERGROUPREF where FUserID= ? ");
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                userGroupIds.add(rst.getString("fUserGroupId"));
            }
        }
        catch (SQLException sQLException) {
            SQLUtils.cleanup(rst, (Statement)pstmt);
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, (Statement)pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return userGroupIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getTemplateTypeIdsByUserId(Context ctx, Connection conn, String userId, Set<String> userGroupIds) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgTypeIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String tempTable = null;
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select fBgTypeId from T_MBG_MBGPERMISSION where ( FPersonID = ? and  FPermissionType = 2 )");
            } else {
                sql.append("select fBgTypeId from T_MBG_MBGPERMISSION where ( FPersonID = ? OR fUserGroupId in ").append("(select FID from " + tempTable + ")").append(" ) and  FPermissionType = 2 ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTypeIds.add(rst.getString("fBgTypeId"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempTable);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        return bgTypeIds;
    }

    @Override
    protected boolean _isControlByDataPermission(Context ctx, RptSrcTypeEnum sourceType, String userId, boolean onlyOrgNotQuerytemp) throws BOSException, EASBizException {
        TempTablePool pool;
        String selectGroupStr;
        PreparedStatement pstmt;
        Connection conn;
        ResultSet rst;
        boolean isControl;
        block9: {
            if (ctx == null || StringUtils.isEmpty((String)userId)) {
                return false;
            }
            isControl = false;
            rst = null;
            conn = null;
            pstmt = null;
            StringBuffer selectSql = new StringBuffer();
            selectGroupStr = null;
            StringBuffer combineStr = new StringBuffer();
            Set<Object> userGroupIds = new HashSet();
            pool = null;
            try {
                conn = this.getConnection(ctx);
                pool = TempTablePool.getInstance((Context)ctx);
                selectSql.append("select top 1  fid from T_MBG_MBGPERMISSION where FPersonID= ? ");
                selectSql.append(sourceType != null ? "AND FSourceType = " + sourceType.getValue() : "");
                if (onlyOrgNotQuerytemp) {
                    selectSql.append(" and FPermissionType <> 4 ");
                }
                pstmt = conn.prepareStatement(selectSql.toString());
                pstmt.setString(1, userId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    isControl = true;
                }
                rst.close();
                pstmt.close();
                if (isControl || (userGroupIds = this.getUserGroupIdsByUser(conn, userId)).isEmpty()) break block9;
                selectGroupStr = this.getAppendStrByColls(conn, pool, userGroupIds);
                combineStr.append("select top 1 fid from T_MBG_MBGPERMISSION where fUserGroupId in ").append("(select FID from " + selectGroupStr + ")");
                combineStr.append(sourceType != null ? " AND FSourceType = " + sourceType.getValue() : "");
                if (onlyOrgNotQuerytemp) {
                    combineStr.append(" and FPermissionType <> 4 ");
                }
                if ((rst = (pstmt = conn.prepareStatement(combineStr.toString())).executeQuery()).next()) {
                    isControl = true;
                }
            }
            catch (SQLException e) {
                try {
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                    BgDBUtils.releaseTmpTable((TempTablePool)pool, selectGroupStr);
                    throw throwable;
                }
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, selectGroupStr);
        return isControl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgSchemeIdsByCreatorId(Connection conn, String userId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgSchemeIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select FID from T_MBG_BgScheme where FCreatorID = ? ");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgSchemeIds.add(rst.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"get schemeid error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgSchemeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgTemplateIdsByCreatorId(Connection conn, String userId, String bgSchemeId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgTemplateIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        try {
            sql.append("select FID from T_MBG_BgTemplate where FCreatorID = ? and FBgSchemeID = ? ");
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgTemplateIds.add(rst.getString("FID"));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"get schemeid error ", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        return bgTemplateIds;
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        ObjectBaseInfo info = (ObjectBaseInfo)super._getValue(ctx, pk);
        return info.getLogInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _getSheetName(Context ctx, List ids) throws BOSException, EASBizException {
        if (ids.isEmpty()) {
            return null;
        }
        PreparedStatement pstmt1 = null;
        Connection conn = null;
        ResultSet rst = null;
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            conn = this.getConnection(ctx);
            pstmt1 = conn.prepareStatement("select FSheetName from T_MBG_BgSheetpermission where  FBgSheetPermissionID=? and FIsSelect=1 ");
            for (int i = 0; i < ids.size(); ++i) {
                pstmt1.setString(1, ids.get(i).toString());
                rst = pstmt1.executeQuery();
                String name = "";
                while (rst.next()) {
                    name = name + rst.getString(1) + ",";
                }
                if ("".equals(name)) continue;
                map.put(ids.get(i).toString(), name.substring(0, name.length() - 1));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt1);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(rst, (Statement)pstmt1);
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup(rst, (Statement)pstmt1);
        SQLUtils.cleanup((Connection)conn);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateSheetName(Context ctx, List ids, List name) throws BOSException, EASBizException {
        if (ids.isEmpty()) {
            return;
        }
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("update T_MBG_BgSheetpermission set FSheetName=?  where  FSheetID=? ");
            for (int i = 0; i < ids.size(); ++i) {
                if (ids.get(i) == null || "".equals(ids.get(i))) continue;
                pstmt.setString(1, name.get(i).toString());
                pstmt.setString(2, ids.get(i).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(null, pstmt, (Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup(null, (Statement)pstmt, (Connection)conn);
        }
        SQLUtils.cleanup(null, (Statement)pstmt, (Connection)conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Set _getBgTemplateSheetPermission(Context ctx, RptSrcTypeEnum sourceType, String userId, String tempId, String bgSchemeId) throws BOSException, EASBizException {
        HashSet<String> bgTemlateSheetIds;
        block8: {
            if (ctx == null || StringUtils.isEmpty((String)tempId)) {
                return null;
            }
            Set bgTemlateIds = this._getBgTemplatePermission(ctx, sourceType, userId, bgSchemeId);
            bgTemlateSheetIds = new HashSet<String>();
            if (bgTemlateIds != null && bgTemlateIds.contains(tempId)) {
                PreparedStatement pstmt1 = null;
                Connection conn = null;
                ResultSet rst = null;
                TempTablePool pool = null;
                String tempTable = null;
                try {
                    conn = this.getConnection(ctx);
                    tempTable = this.createTempTableByUserIdSearchPer(ctx, pool, sourceType, userId, tempId, bgSchemeId);
                    pstmt1 = conn.prepareStatement("select FSheetID from T_MBG_BgSheetpermission s where  FIsSelect=1 and exists (select fid from " + tempTable + " where fid = s.FBgSheetPermissionID) ");
                    rst = pstmt1.executeQuery();
                    while (rst.next()) {
                        bgTemlateSheetIds.add(rst.getString(1));
                    }
                    BgDBUtils.releaseTmpTable(pool, (String)tempTable);
                }
                catch (SQLException e) {
                    logger.error((Object)"", (Throwable)e);
                    break block8;
                }
                finally {
                    BgDBUtils.releaseTmpTable(pool, tempTable);
                    SQLUtils.cleanup(rst, pstmt1);
                    SQLUtils.cleanup((Connection)conn);
                }
                SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt1);
                SQLUtils.cleanup((Connection)conn);
            }
        }
        return bgTemlateSheetIds;
    }

    protected String createTempTableByUserIdSearchPer(Context ctx, TempTablePool pool, RptSrcTypeEnum sourceType, String userId, String tempId, String bgSchemeId) throws BOSException, EASBizException {
        String tempTable = null;
        ResultSet rst = null;
        Connection conn = null;
        PreparedStatement pstmt = null;
        String selectSql = null;
        String selectGroupStr = null;
        StringBuffer combineStr = new StringBuffer();
        Set<Object> userGroupIds = new HashSet();
        HashSet<String> ids = new HashSet<String>();
        try {
            conn = this.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            selectSql = "select fid from T_MBG_MBGPERMISSION where FPersonID= ? AND FSourceType = ? and FBgTemplateId = ? and FBgSchemeId = ? ";
            pstmt = conn.prepareStatement(selectSql);
            pstmt.setString(1, userId);
            pstmt.setInt(2, sourceType.getValue());
            pstmt.setString(3, tempId);
            pstmt.setString(4, bgSchemeId);
            rst = pstmt.executeQuery();
            if (rst.next()) {
                ids.add(rst.getString(1));
            }
            rst.close();
            pstmt.close();
            userGroupIds = this.getUserGroupIdsByUser(conn, userId);
            if (!userGroupIds.isEmpty()) {
                selectGroupStr = this.getAppendStrByColls(conn, pool, userGroupIds);
                combineStr.append("select fid from T_MBG_MBGPERMISSION where FSourceType = ? and FBgTemplateId = ? and FBgSchemeId = ? and fUserGroupId in ").append("(select FID from " + selectGroupStr + ")");
                pstmt = conn.prepareStatement(combineStr.toString());
                pstmt.setInt(1, sourceType.getValue());
                pstmt.setString(2, tempId);
                pstmt.setString(3, bgSchemeId);
                rst = pstmt.executeQuery();
                if (rst.next()) {
                    ids.add(rst.getString(1));
                }
            }
            tempTable = BgDBUtils.createTmpTable((TempTablePool)pool, (String)"CREATE TABLE TEML_KSQL_0 (Fid VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempTable + " (Fid) values (?)"), ids);
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt, (Connection)conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, selectGroupStr);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt, (Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)selectGroupStr);
        return tempTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _deleteSheetPermission(Context ctx, List permissionIDs) throws BOSException, EASBizException {
        PreparedStatement pstmt = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            pstmt = conn.prepareStatement("delete from T_MBG_BgSheetpermission where FBgSheetPermissionID=? ");
            for (int i = 0; i < permissionIDs.size(); ++i) {
                pstmt.setString(1, permissionIDs.get(i).toString());
                pstmt.addBatch();
            }
            pstmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
            SQLUtils.cleanup((Statement)pstmt);
            SQLUtils.cleanup((Connection)conn);
        }
        SQLUtils.cleanup((Statement)pstmt);
        SQLUtils.cleanup((Connection)conn);
    }

    @Override
    protected Set _hasFunctionPermissions(Context ctx, Set orgIds, String permissionItem) throws BOSException, EASBizException {
        HashSet<String> passOrgIds = new HashSet<String>(orgIds.size());
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK userPK = new ObjectUuidPK(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
        for (String id : orgIds) {
            ObjectUuidPK orgIdPK = new ObjectUuidPK(id);
            try {
                iPermission.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgIdPK, permissionItem);
            }
            catch (Exception e) {
                continue;
            }
            passOrgIds.add(id);
        }
        return passOrgIds;
    }

    @Override
    protected Set _getBgOrgUnitPermission(Context ctx, RptSrcTypeEnum sourceType, String userId, String bgSchemeId) throws BOSException, EASBizException {
        if (ctx == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        Set<Object> bgBgOrgUnitIds = new HashSet();
        sourceType = this.replaceByBgScheme(ctx, sourceType, bgSchemeId);
        ResultSet rst = null;
        Statement pstmt = null;
        boolean isControlUse = false;
        try {
            int paramValue = MbgPermissionHelper.getDataPerimissionParam(ctx);
            if (paramValue == 0) {
                HashSet hashSet = bgBgOrgUnitIds;
                return hashSet;
            }
            if (paramValue == 2 && !(isControlUse = this._isControlByDataPermission(ctx, sourceType, userId, false))) {
                Set<Object> set = bgBgOrgUnitIds;
                return set;
            }
            bgBgOrgUnitIds = this.getPermitedCollectionByUserId(ctx, sourceType, userId, MbgPermissionTypeEnum.BGORG, bgSchemeId);
        }
        catch (BOSException ex) {
            throw ex;
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return bgBgOrgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgOrgUnitIdsByUserId(Context ctx, Connection conn, String userId, Set<String> userGroupIds, String bgSchemeId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgOrgUnitIds = new HashSet<String>();
        StringBuffer sql = new StringBuffer();
        String tempTable = null;
        TempTablePool pool = null;
        try {
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = this.getAppendStrByColls(conn, pool, userGroupIds);
            if (userGroupIds.isEmpty()) {
                sql.append("select m.FBgOrgUnitID,o.FORGUNITID from T_MBG_MBGPERMISSION  m left join T_MBG_BGORGUNIT o on o.FID = m.FBgOrgUnitID where ( m.FPersonID = ? and  m.FPermissionType = 4 )").append(" and m.FBgSchemeid = ? ");
            } else {
                sql.append("select m.FBgOrgUnitID,o.FORGUNITID from T_MBG_MBGPERMISSION  m left join T_MBG_BGORGUNIT o on o.FID = m.FBgOrgUnitID where ( m.FPersonID = ? OR m.fUserGroupId in ").append("(select FID from " + tempTable + ")").append(" ) and  m.FPermissionType = 4").append(" and m.FBgSchemeid = ? ");
            }
            pstmt = conn.prepareStatement(sql.toString());
            pstmt.setString(1, userId);
            pstmt.setString(2, bgSchemeId);
            rst = pstmt.executeQuery();
            while (rst.next()) {
                bgOrgUnitIds.add(rst.getString(2));
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"", (Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempTable);
                throw throwable;
            }
            SQLUtils.cleanup(rst, pstmt);
            BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        }
        SQLUtils.cleanup((ResultSet)rst, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        return bgOrgUnitIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getBgOrgUnitIdsByRefSchemeId(Context ctx, Connection conn, String userId, Set<String> userGroupIds, String bgSchemeId) {
        if (conn == null || StringUtils.isEmpty((String)userId)) {
            return null;
        }
        ResultSet rst = null;
        PreparedStatement pstmt = null;
        HashSet<String> bgOrgUnitIds = new HashSet<String>();
        Set<String> bgSchemeIds = null;
        StringBuffer sql = new StringBuffer();
        try {
            bgSchemeIds = this.getBgSchemeIdsByUserId(ctx, conn, userId, userGroupIds);
            if (!bgSchemeIds.contains(bgSchemeId)) {
                HashSet<String> hashSet = bgOrgUnitIds;
                return hashSet;
            }
            if (!bgSchemeIds.isEmpty()) {
                BgSchemeDimensionHelper c = new BgSchemeDimensionHelper(ctx, bgSchemeId);
                sql.append("select FORGUNITID from T_MBG_BgOrgUnit where FVIEWID = ? ");
                pstmt = conn.prepareStatement(sql.toString());
                pstmt.setString(1, c.getBgOrgViewId());
                rst = pstmt.executeQuery();
                while (rst.next()) {
                    bgOrgUnitIds.add(rst.getString("FORGUNITID"));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"get bgorg error", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt);
        }
        return bgOrgUnitIds;
    }

    @Override
    protected String _checkBgOrgPerbyForm(Context ctx, IObjectValue bgFormInfo, List orgMembers, String userID) throws BOSException, EASBizException {
        if (bgFormInfo == null || orgMembers == null || orgMembers.isEmpty()) {
            return null;
        }
        BgFormInfo info = (BgFormInfo)bgFormInfo;
        BgSchemeInfo bgSchemeInfo = info.getBgScheme();
        String bgSchemeId = bgSchemeInfo.getId().toString();
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId);
        String bgOrgViewId = schemeHelper.getBgOrgViewId();
        FullOrgUnitInfo orgUnitInfo = info.getOrgUnit();
        HashMap<String, BgDimensionMember> orgMembersMap = new HashMap<String, BgDimensionMember>();
        BgDimensionMember member = null;
        for (int i = 0; i < orgMembers.size(); ++i) {
            member = (BgDimensionMember)orgMembers.get(i);
            if (orgUnitInfo.getNumber().equals(member.getNumber())) continue;
            orgMembersMap.put(member.getNumber(), member);
        }
        Set bgOrgUnitPer = this._getBgOrgUnitPermission(ctx, null, userID, bgSchemeId);
        HashSet<String> bgOrgNumbers = new HashSet<String>();
        if (!bgOrgUnitPer.isEmpty()) {
            String sql = "SELECT FNumber, ForgunitId FROM  t_mbg_bgorgunit  where FVIEWID  = ? and FIsVirtual = 0 ";
            IRowSet rst = null;
            try {
                rst = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgOrgViewId});
                while (rst.next()) {
                    if (bgOrgUnitPer.contains(rst.getString("ForgunitId"))) continue;
                    bgOrgNumbers.add(rst.getString("FNumber"));
                }
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
        }
        String msg = null;
        if (!orgMembersMap.keySet().isEmpty() && !bgOrgNumbers.isEmpty()) {
            String orgNumber = null;
            String orgName = null;
            for (String orgNum : bgOrgNumbers) {
                if (!orgMembersMap.containsKey(orgNum)) continue;
                orgNumber = ((BgDimensionMember)orgMembersMap.get(orgNum)).getNumber();
                orgName = ((BgDimensionMember)orgMembersMap.get(orgNum)).getName();
                break;
            }
            if (orgNumber != null) {
                Object[] params = new String[]{orgNumber, orgName};
                msg = MessageFormat.format(ResourceBase.getString((String)"com.kingdee.eas.ma.mbg.MbgPermissionResource", (String)"checkBgOrgPerFormOrgAdd", (Locale)ctx.getLocale()), params);
            }
        }
        return msg;
    }
}

