/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.app.MbgQingAnalyseCalculateThread;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MbgQingAnalyseCalculateService {
    private static Logger logger = Logger.getLogger(MbgQingAnalyseCalculateService.class);
    public static final int PLAN_STATE_STOP = -1;
    public static final int PLAN_STATE_RUN = 0;
    public static final int PLAN_STATE_END = 9;
    public static final int PLAN_STATE_ERROR = 1;
    private static final int PLAN_PARAM_LENGTH = 8;
    private static final int ENTRY_PARAM_LENGTH = 5;
    private static final int POOL_SIZE = Runtime.getRuntime().availableProcessors();
    private ExecutorService service = Executors.newFixedThreadPool(POOL_SIZE / 2 >= 2 ? 2 : POOL_SIZE / 2);
    private static final String PLAN_ID = "98765432";
    private ServiceParam serviceParam = null;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private Context context = null;
    private List<BgOrgUnitInfo> bgOrgUnits = null;
    private Map<String, List<MbgQingAnalyseInfo>> analyseMap = null;
    private Map<String, String> variateMap = null;
    private BgSchemeInfo bgSchemeInfo = null;

    protected String currentTime() {
        return format.format(System.currentTimeMillis());
    }

    protected void setContext(Context context) {
        this.context = context;
    }

    protected Context getContext() {
        return this.context;
    }

    public List<BgOrgUnitInfo> getBgOrgUnits() {
        return this.bgOrgUnits;
    }

    public void setOrgUnitids(List<BgOrgUnitInfo> bgOrgUnits) {
        this.bgOrgUnits = bgOrgUnits;
    }

    public Map<String, List<MbgQingAnalyseInfo>> getAnalyseMap() {
        return this.analyseMap;
    }

    public void setAnalyseMap(Map<String, List<MbgQingAnalyseInfo>> analyseMap) {
        this.analyseMap = analyseMap;
    }

    public Map<String, String> getVariateMap() {
        return this.variateMap;
    }

    public void setVariateMap(Map<String, String> variateMap) {
        this.variateMap = variateMap;
    }

    public BgSchemeInfo getBgSchemeInfo() {
        return this.bgSchemeInfo;
    }

    public void setBgSchemeInfo(BgSchemeInfo bgSchemeInfo) {
        this.bgSchemeInfo = bgSchemeInfo;
    }

    public MbgQingAnalyseCalculateService(Context ctx, List<BgOrgUnitInfo> bgOrgUnits, BgSchemeInfo bgSchemeInfo, Map<String, List<MbgQingAnalyseInfo>> analyseMap, Map<String, String> variateMap) {
        this.context = ctx;
        this.bgOrgUnits = bgOrgUnits;
        this.bgSchemeInfo = bgSchemeInfo;
        this.analyseMap = analyseMap;
        this.variateMap = variateMap;
        this.initServiceParam();
    }

    private void initServiceParam() {
        this.serviceParam = new ServiceParam();
        this.serviceParam.AIS = this.getContext().getAIS();
    }

    public void execute() throws Exception {
        logger.debug((Object)("begin execute MbgQingAnalyseCalculateService:" + this.currentTime()));
        if (this.getContext() == null) {
            return;
        }
        List<MbgQingAnalyseCalculatePlan> qingAnalysePlans = null;
        Callable<Object> call = null;
        ArrayList<Future<Object>> futures = new ArrayList<Future<Object>>();
        this.createMbgQingAnalyseCalculatePlan();
        qingAnalysePlans = this.queryCalculatePlan();
        this.createMbgQingAnalyseCalculatePlanEntry(qingAnalysePlans);
        for (BgOrgUnitInfo bgOrgUnitinfo : this.bgOrgUnits) {
            call = this.getService(bgOrgUnitinfo);
            if (call == null) continue;
            futures.add(this.service.submit(call));
        }
        this.service.shutdown();
    }

    private Callable<Object> getService(BgOrgUnitInfo bgOrgUnitinfo) {
        MbgQingAnalyseCalculateThread call = new MbgQingAnalyseCalculateThread(this.getContext(), this.getBgSchemeInfo(), bgOrgUnitinfo, this.analyseMap, this.variateMap);
        return call;
    }

    private void createMbgQingAnalyseCalculatePlanEntry(List<MbgQingAnalyseCalculatePlan> qingAnalysePlans) throws BOSException {
        logger.debug((Object)("begin create createMbgQingAnalyseCalculatePlanEntry:" + this.currentTime()));
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        for (MbgQingAnalyseCalculatePlan plan : qingAnalysePlans) {
            List<MbgQingAnalyseInfo> analyseList = this.analyseMap.get(plan.orgUnitId);
            if (analyseList == null || analyseList.isEmpty()) continue;
            for (MbgQingAnalyseInfo info : analyseList) {
                param = new Object[]{plan.id, info.getId().toString(), -1, this.serviceParam.runTime, this.serviceParam.runTime};
                params.add(param);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("insert into T_MBG_MbgQingAnalyseCalcEntry(FPlanID,FAnalyseId,FState,FCreateTime,FLastRunTime) values(?,?,?,?,?)");
        try {
            BgDBUtils.executeBatch((Context)this.getContext(), (String)sql.toString(), params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"MbgQingAnalyseCalculateService createMbgQingAnalyseCalculatePlanEntry error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"MbgQingAnalyseCalculateService createMbgQingAnalyseCalculatePlanEntry error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private List<MbgQingAnalyseCalculatePlan> queryCalculatePlan() throws BOSException {
        logger.debug((Object)("begin query MbgQingAnalyseCalculatePlan:" + this.currentTime()));
        ArrayList<MbgQingAnalyseCalculatePlan> qingAnalysePlans = new ArrayList<MbgQingAnalyseCalculatePlan>();
        MbgQingAnalyseCalculatePlan plan = null;
        Connection conn = null;
        IRowSet result = null;
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            String sql = "select FID,FOrgUnitId from T_MBG_MbgQingAnalyseCalcPlan where FSchemeId = ? and FState = ? and FAIS = ?";
            result = BgDBUtils.executeQuery((Connection)conn, (String)sql, (Object[])new Object[]{this.bgSchemeInfo.getId().toString(), -1, this.serviceParam.AIS});
            while (result.next()) {
                plan = new MbgQingAnalyseCalculatePlan();
                plan.id = result.getString(1);
                plan.orgUnitId = result.getString(2);
                qingAnalysePlans.add(plan);
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)"MbgQingAnalyseCalculateService queryCalculatePlan error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"MbgQingAnalyseCalculateService queryCalculatePlan error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return qingAnalysePlans;
    }

    private void createMbgQingAnalyseCalculatePlan() throws BOSException, SQLException {
        logger.debug((Object)("begin create BizCalc Plan :" + this.currentTime()));
        Connection conn = null;
        Object[] param = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        try {
            conn = BgDBUtils.getConnection((Context)this.getContext());
            this.createPlanTable(conn);
            if (this.bgOrgUnits == null || this.bgOrgUnits.isEmpty()) {
                return;
            }
            for (BgOrgUnitInfo orgUnitInfo : this.bgOrgUnits) {
                param = new Object[]{BOSUuid.create((String)PLAN_ID).toString(), this.serviceParam.AIS, this.bgSchemeInfo.getId().toString(), orgUnitInfo.getOrgUnitID(), this.serviceParam.userName, -1, this.serviceParam.runTime, this.serviceParam.runTime};
                params.add(param);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("delete from T_MBG_MbgQingAnalyseCalcEntry where FPlanID in (select FID from T_MBG_MbgQingAnalyseCalcPlan where FAIS = ? and FSchemeId = ?)");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{this.serviceParam.AIS, this.bgSchemeInfo.getId().toString()});
            sql.setLength(0);
            sql.append("delete from T_MBG_MbgQingAnalyseCalcPlan where FAIS = ? and FSchemeId = ?");
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{this.serviceParam.AIS, this.bgSchemeInfo.getId().toString()});
            sql.setLength(0);
            sql.append("INSERT INTO  T_MBG_MbgQingAnalyseCalcPlan(FID,FAIS,FSchemeId,FOrgUnitId,FUserName,FState,FCreateTime,FLastRunTime) values(?,?,?,?,?,?,?,?)");
            BgDBUtils.executeBatch((Connection)conn, (String)sql.toString(), params);
        }
        catch (SQLDataException ex) {
            logger.error((Object)"MbgQingAnalyseCalculateService createMbgQingAnalyseCalculatePlan error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void createPlanTable(Connection conn) throws BOSException {
        logger.debug((Object)"begin create MbgQingAnalyseCalculate Plan Table.");
        if (conn == null) {
            return;
        }
        try {
            int re = BgDBUtils.existTable((Connection)conn, (String)"T_MBG_MbgQingAnalyseCalcPlan");
            StringBuffer sql = new StringBuffer();
            if (re == BgDBUtils.NO) {
                sql.append("Create Table T_MBG_MbgQingAnalyseCalcPlan (FID VARCHAR(44) DEFAULT '' NOT NULL, FAIS NVARCHAR(256) DEFAULT '' NOT NULL, FSchemeId VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitId VARCHAR(44) DEFAULT '' NOT NULL, FUserName VARCHAR(44), FState INT DEFAULT -1 NOT NULL, FCreateTime DateTime, FLastRunTime DateTime, CONSTRAINT PK_MBG_MbgQingAnalyseCalcPlan PRIMARY KEY (FID))");
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            }
            if ((re = BgDBUtils.existTable((Connection)conn, (String)"T_MBG_MbgQingAnalyseCalcEntry")) == BgDBUtils.NO) {
                sql.setLength(0);
                sql.append("Create Table T_MBG_MbgQingAnalyseCalcEntry (FPlanID VARCHAR(44) DEFAULT '' NOT NULL, FAnalyseId VARCHAR(44), FState INT DEFAULT 0 NOT NULL, FCreateTime DateTime, FLastRunTime DateTime)");
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
        }
        catch (SQLException ex) {
            logger.debug((Object)"MbgQingAnalyseCalculateService createPlanTable error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        logger.debug((Object)"end create MbgQingAnalyseCalculate Plan Table.");
    }

    private class MbgQingAnalyseCalculatePlan {
        public String id = null;
        public String orgUnitId = null;
        public int state = -1;

        private MbgQingAnalyseCalculatePlan() {
        }
    }

    private class ServiceParam {
        public String AIS = null;
        public Timestamp runTime = new Timestamp(System.currentTimeMillis());
        public String userName = ContextUtil.getCurrentUserInfo((Context)MbgQingAnalyseCalculateService.this.getContext()).getName(MbgQingAnalyseCalculateService.this.getContext().getLocale());
        public int beginHours = 0;
        public int endHours = 6;

        private ServiceParam() {
        }
    }
}

