/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.Context;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class MbgQingAnalyseCalculateThread
implements Callable<Object> {
    private static Logger logger = Logger.getLogger(MbgQingAnalyseCalculateThread.class);
    private Context ctx = null;
    private BgSchemeInfo bgScheme = null;
    private BgOrgUnitInfo bgOrgUnitinfo = null;
    private Map<String, String> variateMap = null;
    private Map<String, List<MbgQingAnalyseInfo>> analyseMap = null;

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public void setBgScheme(BgSchemeInfo bgScheme) {
        this.bgScheme = bgScheme;
    }

    public BgSchemeInfo getBgScheme() {
        return this.bgScheme;
    }

    public BgOrgUnitInfo getBgOrgUnitinfo() {
        return this.bgOrgUnitinfo;
    }

    public void setBgOrgUnitinfo(BgOrgUnitInfo bgOrgUnitinfo) {
        this.bgOrgUnitinfo = bgOrgUnitinfo;
    }

    public Map<String, String> getVariateMap() {
        return this.variateMap;
    }

    public void setVariateMap(Map<String, String> variateMap) {
        this.variateMap = variateMap;
    }

    public Map<String, List<MbgQingAnalyseInfo>> getAnalyseMap() {
        return this.analyseMap;
    }

    public void setAnalyseMap(Map<String, List<MbgQingAnalyseInfo>> analyseMap) {
        this.analyseMap = analyseMap;
    }

    public MbgQingAnalyseCalculateThread(Context ctx, BgSchemeInfo schemeInfo, BgOrgUnitInfo orgUnitInfo, Map<String, List<MbgQingAnalyseInfo>> analyseMap, Map<String, String> variateMap) {
        this.ctx = ctx;
        this.bgScheme = schemeInfo;
        this.bgOrgUnitinfo = orgUnitInfo;
        this.variateMap = variateMap;
        this.analyseMap = analyseMap;
    }

    @Override
    public Object call() throws Exception {
        logger.debug((Object)("begin run plan: bgSchemeId : " + this.getBgScheme().getId().toString() + " ; orgUnitId : " + this.getBgOrgUnitinfo().getOrgUnitID()));
        try {
            this.updateCalculatePlan(0);
            BizMemberQuery query = BizMemberQuery.getInstance((Context)this.ctx, (String)this.getBgScheme().getId().toString());
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(this.ctx, this.getBgScheme().getId().toString());
            MbgQingAnalyseFacadeFactory.getLocalInstance(this.ctx).calculate(this.bgScheme, this.getBgOrgUnitinfo(), query, this.variateMap, schemeHelper, this.analyseMap);
            this.updateCalculatePlan(9);
        }
        catch (Exception e) {
            logger.error((Object)("execute plan error: " + this.getBgScheme().getId().toString() + " ;orgUnitId :" + this.getBgOrgUnitinfo().getOrgUnitID()), (Throwable)e);
            this.updateCalculatePlan(1);
            throw new Exception(e);
        }
        return null;
    }

    private void updateCalculatePlan(int state) throws Exception {
        logger.debug((Object)"begin updateCalculatePlan.");
        StringBuffer sql = new StringBuffer();
        sql.append("update T_MBG_MbgQingAnalyseCalcPlan set Fstate = ?,FLastRunTime = ? where FSchemeId = ? and FOrgUnitId = ?");
        BgDBUtils.executeUpdate((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{state, new Timestamp(System.currentTimeMillis()), this.getBgScheme().getId().toString(), this.getBgOrgUnitinfo().getOrgUnitID()});
        sql.setLength(0);
        sql.append("update T_MBG_MbgQingAnalyseCalcEntry set Fstate = ?,FLastRunTime = ? where FPlanID in (select FID  from T_MBG_MbgQingAnalyseCalcPlan where FSchemeId = ? and FOrgUnitId = ?)");
        BgDBUtils.executeUpdate((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{state, new Timestamp(System.currentTimeMillis()), this.getBgScheme().getId().toString(), this.getBgOrgUnitinfo().getOrgUnitID()});
    }
}

