/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class MbgQingAnalyseDispatchThread
implements Callable<Object> {
    private static Logger logger = Logger.getLogger(MbgQingAnalyseDispatchThread.class);
    public static final int DISPATCH_STATE_STOP = -1;
    public static final int DISPATCH_STATE_END = 9;
    public static final int DISPATCH_STATE_ERROR = 1;
    private Context ctx = null;
    private List<BgScenarioInfo> bgScenarios = null;
    private BOSUuid bgOrgViewId = null;
    private Set<String> filterFormIds = null;
    private List<BgFormInfo> bgForms = null;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    protected void setCtx(Context ctx) {
        this.ctx = ctx;
    }

    protected Context getCtx() {
        return this.ctx;
    }

    public List<BgScenarioInfo> getBgScenarios() {
        return this.bgScenarios;
    }

    public void setBgScenarios(List<BgScenarioInfo> bgScenarios) {
        this.bgScenarios = bgScenarios;
    }

    public BOSUuid getBgOrgViewId() {
        return this.bgOrgViewId;
    }

    public void setBgOrgViewId(BOSUuid bgOrgViewId) {
        this.bgOrgViewId = bgOrgViewId;
    }

    public Set<String> getFilterFormIds() {
        return this.filterFormIds;
    }

    public void setFilterFormIds(Set<String> filterFormIds) {
        this.filterFormIds = filterFormIds;
    }

    public List<BgFormInfo> getBgForms() {
        return this.bgForms;
    }

    public void setBgForms(List<BgFormInfo> bgForms) {
        this.bgForms = bgForms;
    }

    public MbgQingAnalyseDispatchThread(Context ctx, List<BgFormInfo> bgForms, List<BgScenarioInfo> bgScenarios, BOSUuid bgOrgViewId, Set<String> filterFormIds) {
        this.bgOrgViewId = bgOrgViewId;
        this.bgForms = bgForms;
        this.ctx = ctx;
        this.bgScenarios = bgScenarios;
        this.filterFormIds = filterFormIds;
    }

    private Object executeDispatch() throws Exception {
        if (this.bgForms == null || this.bgForms.isEmpty()) {
            return null;
        }
        FullOrgUnitInfo orgUnit = this.bgForms.get(0).getOrgUnit();
        logger.debug((Object)(" actDataDispatch begin execute,bgOrgUnit: " + orgUnit + " ,bgFroms size = " + this.bgForms.size() + ",run time: " + this.outputTime()));
        int kn = this.bgForms.size();
        for (int k = 0; k < kn; ++k) {
            BgFormInfo bgFormInfo = this.bgForms.get(k);
            logger.debug((Object)(" bgFormInfo actDataDispatch begin execute, bgFormId : " + bgFormInfo.getId().toString() + "bgOrgUnit: " + orgUnit));
            if (bgFormInfo == null || this.filterFormIds.contains(bgFormInfo.getId().toString())) continue;
            if ((BgTemFormTypeEnum.FIXEDFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType()) || BgTemFormTypeEnum.SPECIALFORM.equals((Object)bgFormInfo.getBgTemplate().getFormType())) && !BgNFSHelper.checkBookHasFormula(bgFormInfo.getBook())) {
                MbgQingAnalyseFacadeFactory.getLocalInstance(this.ctx).updateDispatchData(bgFormInfo.getId().toString(), 9);
                continue;
            }
            try {
                if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                    this.ViewListFormDimensionQuery(this.ctx, this.bgOrgViewId, bgFormInfo, this.bgScenarios);
                    continue;
                }
                this.MbgFormDimensionQuery(this.ctx, bgFormInfo, this.bgOrgViewId, this.bgScenarios);
                continue;
            }
            catch (Exception e) {
                MbgQingAnalyseFacadeFactory.getLocalInstance(this.ctx).updateDispatchData(bgFormInfo.getId().toString(), 1);
                throw new Exception(e);
            }
        }
        logger.debug((Object)(" actDataDispatch end execute,bgOrgUnit: " + orgUnit + " ,run time: " + this.outputTime()));
        return null;
    }

    @Override
    public Object call() throws Exception {
        return this.executeDispatch();
    }

    private void ViewListFormDimensionQuery(Context ctx, BOSUuid bgOrgViewId, BgFormInfo bgFormInfo, List<BgScenarioInfo> bgScenarios) throws Exception, BOSException, EASBizException {
        BgFormEntryInfo obj;
        MbgViewListManager curMbgViewManager = null;
        MbgViewListXMLParser viewListXMLParser = new MbgViewListXMLParser(ctx);
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            curMbgViewManager = viewListXMLParser.parse(dataBytes);
        }
        MBGViewListFormFacadeFactory.getLocalInstance(ctx).loadViewListManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewManager, null, null, false, false);
        this.convertScenarioMember(ctx, bgOrgViewId, bgFormInfo, curMbgViewManager, dimensionManager, bgScenarios);
    }

    private void convertScenarioMember(Context ctx, BOSUuid bgOrgViewId, BgFormInfo bgFormInfo, MbgViewListManager curMbgViewManager, List<IBgDimensionManagerBase> dimensionManager, List<BgScenarioInfo> bgScenarios) throws Exception, BOSException, EASBizException {
        List sheetManagers = curMbgViewManager.getSheetManagers();
        BgViewHelper.movePageDimensionsToRow(curMbgViewManager, false);
        int in = sheetManagers.size();
        for (int i = 0; i < in; ++i) {
            MbgViewListSheetManager mbgViewListSheetManager = (MbgViewListSheetManager)sheetManagers.get(i);
            MbgViewListDimensionManager dimManager = mbgViewListSheetManager.getDimensionManager();
            List<MbgViewListDimensionInfo> allDimensions = dimManager.getAllDimensions();
            for (MbgViewListDimensionInfo dimensionInfo : allDimensions) {
                if (bgScenarios == null || bgScenarios.isEmpty() || !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
                dimensionInfo.getMember().clear();
                int jn = bgScenarios.size();
                for (int j = 0; j < jn; ++j) {
                    dimensionInfo.getMember().add(new BgDimensionMember(null, DimensionBaseConstants.DEF_SCENARIO_FIELD, bgScenarios.get(j).getName(), bgScenarios.get(j).getNumber()));
                }
            }
            dimensionManager.add(dimManager);
        }
        IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        dimParameter.setValueType(DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
        MbgQingAnalyseFacadeFactory.getLocalInstance(ctx).dimensionQuery(dimParameter);
    }

    private void MbgFormDimensionQuery(Context ctx, BgFormInfo bgFormInfo, BOSUuid bgOrgViewId, List<BgScenarioInfo> bgScenarios) throws Exception {
        BgFormEntryInfo obj;
        IMbgViewManager curMbgViewManager = null;
        MbgXMLParser mbgXMLParser = new MbgXMLParser(ctx);
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            byte[] styleBytes = obj.getDimensionStyle();
            curMbgViewManager = mbgXMLParser.parse(dataBytes, styleBytes);
        }
        MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewManager, null, bgFormInfo.getOrgUnit().getId().toString(), false, false);
        this.convertDimensionMember(ctx, bgFormInfo, bgOrgViewId, bgScenarios, curMbgViewManager);
    }

    private void convertDimensionMember(Context ctx, BgFormInfo bgFormInfo, BOSUuid bgOrgViewId, List<BgScenarioInfo> bgScenarios, IMbgViewManager curMbgViewManager) throws Exception, BOSException, EASBizException {
        List<IMbgSheetManager> sheetManagers = curMbgViewManager.getSheetManagers();
        BgViewHelper.movePageDimensionsToRow(curMbgViewManager, false);
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        int in = sheetManagers.size();
        for (int i = 0; i < in; ++i) {
            IMbgSheetManager sheetManager = sheetManagers.get(i);
            BgDimensionManagerImpl dimManager = (BgDimensionManagerImpl)sheetManager.getDimensionManager();
            List allDimensions = dimManager.getDimension();
            for (BgDimensionInfo dimensionInfo : allDimensions) {
                if (bgScenarios == null || bgScenarios.isEmpty() || !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
                dimensionInfo.getMember().clear();
                int jn = bgScenarios.size();
                for (int j = 0; j < jn; ++j) {
                    dimensionInfo.getMember().add(new BgDimensionMember(null, DimensionBaseConstants.DEF_SCENARIO_FIELD, bgScenarios.get(j).getName(), bgScenarios.get(j).getNumber()));
                }
            }
            dimensionManager.add(dimManager);
        }
        IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        dimParameter.setValueType(DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
        MbgQingAnalyseFacadeFactory.getLocalInstance(ctx).dimensionQuery(dimParameter);
    }

    protected String outputTime() {
        return format.format(System.currentTimeMillis());
    }
}

