/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgAccountCollection;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPeriodDispCollection;
import com.kingdee.eas.ma.base.BgPeriodDispFactory;
import com.kingdee.eas.ma.base.BgPeriodDispInfo;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.BgPeriodTypeInfo;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyFactory;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.base.FiscalYearEnum;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcFactory;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.utils.BizMemberQuery;
import com.kingdee.eas.ma.budget.BgPeriodEnum;
import com.kingdee.eas.ma.mbg.BgDimSettingsCollection;
import com.kingdee.eas.ma.mbg.BgDimSettingsInfo;
import com.kingdee.eas.ma.mbg.BgDimSettingsMemberCollection;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgMemberSelectTypeEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgOrgViewFactory;
import com.kingdee.eas.ma.mbg.BgOrgViewInfo;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionMemberValueModeEnum;
import com.kingdee.eas.ma.mbg.IMbgQingAnalyse;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseCalculateInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseCollection;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseDimSettingCollection;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseDimSettingInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseException;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseMemberCollection;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseMemberInfo;
import com.kingdee.eas.ma.mbg.QingAnalyseRefCollection;
import com.kingdee.eas.ma.mbg.app.AbstractMbgQingAnalyseFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.MbgQingAnalyseCalculateService;
import com.kingdee.eas.ma.mbg.app.MbgQingAnalyseDispatchThread;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimension;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgVariateUtils;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.ViewListMemberCacheHelper;
import com.kingdee.eas.ma.nbudget.BgNPeriodHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public class MbgQingAnalyseFacadeControllerBean
extends AbstractMbgQingAnalyseFacadeControllerBean {
    private static final long serialVersionUID = 2948437723276991152L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgQingAnalyseFacadeControllerBean");
    private static String PROPERTIESANALYSECLASS = "com.kingdee.eas.ma.mbg.PropertiesAnalyseDataFacade";
    private static final String DispatchPlanID = "14725869";
    private static final int availableProcessors = Runtime.getRuntime().availableProcessors() / 2;
    private static final SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    protected List _getParentOrgShareModer(Context ctx, BgSchemeInfo bgSchemeInfo, BgOrgViewInfo bgOrgViewInfo, String orgUnitId, String filter) throws BOSException, EASBizException {
        ArrayList<MbgQingAnalyseInfo> shareList = new ArrayList<MbgQingAnalyseInfo>();
        Connection conn = null;
        if (bgSchemeInfo == null || bgOrgViewInfo == null || orgUnitId == null) {
            return shareList;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select id,name,description,share,bgSchemeId,orgUnitId,lastUpdateTime,imgPath where bgSchemeId ='" + bgSchemeInfo.getId().toString() + "' and orgUnitId = '" + orgUnitId + "'");
        if (filter != null) {
            sql.append(" and ( name like '%" + filter + "%' or description like '%" + filter + "%' )");
        }
        MbgQingAnalyseCollection analyseColl = this.getBizInterface(ctx).getMbgQingAnalyseCollection(sql.toString());
        int kn = analyseColl.size();
        for (int k = 0; k < kn; ++k) {
            shareList.add(analyseColl.get(k));
        }
        this.sortAnalyseList(shareList);
        sql.setLength(0);
        sql.append("select FLONGNUMBER from T_MBG_BgOrgUnit where FViewID = ? and FOrgUnitId = ? and FIsVirtual = 0");
        try {
            MbgQingAnalyseCollection coll;
            IRowSet result = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bgOrgViewInfo.getId().toString(), orgUnitId});
            String longNumber = null;
            while (result.next()) {
                longNumber = result.getString("FLONGNUMBER");
            }
            if (longNumber == null || !longNumber.contains("!")) {
                ArrayList<MbgQingAnalyseInfo> arrayList = shareList;
                return arrayList;
            }
            String[] numbers = longNumber.split("!");
            ArrayList<String> param = new ArrayList<String>();
            int in = numbers.length - 1;
            for (int i = 0; i < in; ++i) {
                param.add(numbers[i]);
            }
            final ArrayList list = new ArrayList();
            conn = this.getConnection(ctx);
            sql.setLength(0);
            sql.append("select FOrgUnitId from T_MBG_BgOrgUnit where FViewID = ? and FNumber in ( ");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgOrgViewInfo.getId().toString()}, (Object[])param.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    list.add(res.getString("FOrgUnitId"));
                }
            });
            sql.setLength(0);
            sql.append("select id,name,description,share,bgSchemeId,orgUnitId,lastUpdateTime,imgPath where bgSchemeId = '" + bgSchemeInfo.getId().toString() + "' and share = 1 and orgUnitId in ( ");
            for (String id : list) {
                sql.append("'" + id + "'").append(",");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            if (filter != null) {
                sql.append(" and ( name like '%" + filter + "%' or description like '%" + filter + "%' )");
            }
            if ((coll = this.getBizInterface(ctx).getMbgQingAnalyseCollection(sql.toString())) != null && !coll.isEmpty()) {
                int jn = coll.size();
                for (int j = 0; j < jn; ++j) {
                    shareList.add(coll.get(j));
                }
            }
            this.sortAnalyseList(shareList);
            SQLUtils.cleanup((Connection)conn);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(conn);
        }
        return shareList;
    }

    private void sortAnalyseList(List<MbgQingAnalyseInfo> shareList) {
        Collections.sort(shareList, new Comparator<MbgQingAnalyseInfo>(){

            @Override
            public int compare(MbgQingAnalyseInfo info1, MbgQingAnalyseInfo info2) {
                long time2;
                long time1 = info1.getLastUpdateTime().getTime();
                int i = time1 > (time2 = info2.getLastUpdateTime().getTime()) ? -1 : (time1 - time2 == 0L ? 0 : 1);
                return i;
            }
        });
    }

    @Override
    protected Map _getQingAnalyseFilter(Context ctx, String qingAnalyseId, String bgSchemeId, String orgUnitId, boolean isOnlyQueryOrg) throws BOSException, EASBizException {
        if (qingAnalyseId == null) {
            return null;
        }
        HashMap<String, ArrayList<String>> filterMap = new HashMap<String, ArrayList<String>>();
        Object filters = null;
        Object evi = null;
        Connection conn = null;
        Map<String, String> variateMap = null;
        HashMap<String, ArrayList<String>> analyseMap = new HashMap<String, ArrayList<String>>();
        List numbers = null;
        MbgQingAnalyseInfo analyseInfo = this.getBizInterface(ctx).getMbgQingAnalyseInfo((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)qingAnalyseId)), this.getSelectors());
        MbgQingAnalyseDimSettingCollection coll = analyseInfo.getQingAnalyseDimSetting();
        HashMap<String, String> refFields = new HashMap<String, String>();
        BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgSchemeId.toString());
        try {
            conn = this.getConnection(ctx);
            variateMap = BgVariateUtils.queryVariate(conn, analyseInfo.getBgSchemeId());
            int in = coll.size();
            for (int i = 0; i < in; ++i) {
                MbgQingAnalyseDimSettingInfo settingInfo = coll.get(i);
                MbgQingAnalyseMemberCollection members = settingInfo.getMembers();
                if (members == null || members.isEmpty() || isOnlyQueryOrg && !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(settingInfo.getDimNumber())) continue;
                int jn = members.size();
                for (int j = 0; j < jn; ++j) {
                    MbgQingAnalyseMemberInfo memberInfo = members.get(j);
                    refFields.put(memberInfo.getRefField(), settingInfo.getDimNumber());
                    if (analyseMap.containsKey(memberInfo.getRefField())) {
                        numbers = (List)analyseMap.get(memberInfo.getRefField());
                    } else {
                        numbers = new ArrayList();
                        analyseMap.put(memberInfo.getRefField(), (ArrayList<String>)numbers);
                    }
                    MbgQingAnalyseHelper.getQueryMemers(query, variateMap, members.get(j), numbers);
                }
            }
            Map queryMap = query.queryMember();
            if (queryMap != null && !queryMap.isEmpty()) {
                List iMember = null;
                for (String refField : analyseMap.keySet()) {
                    if (!queryMap.containsKey(refField)) continue;
                    iMember = (List)queryMap.get(refField);
                    numbers = (List)analyseMap.get(refField);
                    if (DimUtils.checkBaseDimensionByField(refField)) {
                        for (IMember member : iMember) {
                            numbers.add((String)member.getNumber());
                        }
                        continue;
                    }
                    for (IMember member : iMember) {
                        numbers.add((String)member.getDimNumber());
                    }
                }
            }
            String dimNum = null;
            for (Map.Entry entry : analyseMap.entrySet()) {
                dimNum = (String)refFields.get(entry.getKey());
                numbers = (ArrayList)entry.getValue();
                if (numbers == null || numbers.isEmpty()) continue;
                filterMap.put(dimNum + "_" + "NUM", (ArrayList<String>)numbers);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return filterMap;
    }

    @Override
    protected boolean _checkIsLeap(Context ctx, String BgOrgViewId, Set selectedOrgUnitIds) throws BOSException {
        boolean isLeap = false;
        StringBuffer sql = new StringBuffer();
        final HashSet numberSet = new HashSet();
        final ArrayList orgList = new ArrayList();
        sql.append("select FID,FNUMBER,FLONGNUMBER,FLEVEL from T_MBG_BgOrgUnit where FVIEWID = ? and FNumber in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{BgOrgViewId}, (Object[])selectedOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                BgOrgUnitInfo orgInfo = new BgOrgUnitInfo();
                orgInfo.setId(BOSUuid.read((String)res.getString(1)));
                orgInfo.setNumber(res.getString(2));
                orgInfo.setLongNumber(res.getString(3));
                orgInfo.setLevel(res.getInt(4));
                numberSet.add(orgInfo.getNumber());
                orgList.add(orgInfo);
            }
        });
        for (BgOrgUnitInfo info : orgList) {
            String longNumber = info.getLongNumber();
            if (longNumber == null || StringUtils.isEmpty((String)longNumber)) continue;
            String[] numbers = longNumber.split("!");
            boolean flag = false;
            int in = numbers.length;
            for (int i = 0; i < in; ++i) {
                if (numberSet.contains(numbers[i])) {
                    flag = true;
                    continue;
                }
                if (!flag) continue;
                isLeap = true;
                return isLeap;
            }
        }
        return isLeap;
    }

    private IMbgQingAnalyse getBizInterface(Context ctx) throws BOSException {
        return MbgQingAnalyseFactory.getLocalInstance(ctx);
    }

    @Override
    protected Map _calculate(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        if (bgSchemeInfo == null) {
            return null;
        }
        Connection conn = null;
        HashMap<String, List<MbgQingAnalyseInfo>> analyseMap = new HashMap<String, List<MbgQingAnalyseInfo>>();
        try {
            conn = this.getConnection(ctx);
            BgOrgViewInfo orgViewInfo = MbgQingAnalyseHelper.getOrgViewInfo(ctx, bgSchemeInfo);
            Set orgUnitIds = BgOrgViewFactory.getLocalInstance(ctx).getOrgUnitCollByViewId(orgViewInfo.getId(), true);
            List<BgOrgUnitInfo> bgOrgUnits = MbgDataHelper.getBgOrgUnits(ctx, conn, orgViewInfo.getId(), orgUnitIds);
            BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgSchemeInfo.getId().toString());
            Map<String, String> variateMap = BgVariateUtils.queryVariate(conn, bgSchemeInfo.getId());
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeInfo.getId().toString());
            this.prepareAnalyseMap(ctx, bgSchemeInfo, analyseMap, bgOrgUnits);
            MbgQingAnalyseCalculateService service = new MbgQingAnalyseCalculateService(ctx, bgOrgUnits, bgSchemeInfo, analyseMap, variateMap);
            service.execute();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return null;
    }

    @Override
    protected void _checkCalculateState(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        if (bgSchemeInfo == null) {
            return;
        }
        int re = BgDBUtils.existTable((Context)ctx, (String)"T_MBG_MbgQingAnalyseCalcPlan");
        if (re == BgDBUtils.NO) {
            return;
        }
        String sql = "select TOP 1 FID from T_MBG_MbgQingAnalyseCalcPlan where FSchemeId =? and (FState = ? or FState = ?)";
        try {
            IRowSet query = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeInfo.getId().toString(), 0, -1});
            if (query.next()) {
                throw new MbgQingAnalyseException(MbgQingAnalyseException.CALCULATING);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected boolean _checkQingFileSize(Context ctx, String dimNumber) throws BOSException, EASBizException {
        if (dimNumber == null) {
            return false;
        }
        try {
            String sql = "select count(*) from T_MBG_BgScheme";
            int schemeCount = 0;
            int orgCount = 0;
            int dimCount = 0;
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                schemeCount = rs.getInt(1);
            }
            if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber)) {
                sql = "select count(distinct ForgUnitId) from T_MBG_bgOrgUnit";
                rs = BgDBUtils.executeQuery((Context)ctx, (String)sql);
                while (rs.next()) {
                    orgCount = rs.getInt(1);
                }
            }
            sql = DimensionBaseConstants.DEF_VERSION_NUMBER.equals(dimNumber) ? "select count(*) from T_MBG_bgVersion" : (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(dimNumber) ? "select count(*) from T_MBG_bgScenario" : (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimNumber) ? "select count(*) from T_MBG_bgPeriod" : (DimensionBaseConstants.DEF_ELEMENT_NUMBER.equals(dimNumber) ? "select count(*) from T_MBG_bgElement" : (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(dimNumber) ? "select count(*) from T_BD_Currency" : (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) ? "select count(distinct FNumber) from T_MBG_bgAccount" : "select count(distinct m.FNUMBER) from T_MBG_MbgMember m inner join T_MBG_MbgDim dim on m.FDIMID  =  dim.Fid where dim.FNUMBER  = '" + dimNumber + "'")))));
            rs = BgDBUtils.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                dimCount = rs.getInt(1);
            }
            if (schemeCount * orgCount * dimCount < 60000) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"check qingFileSize error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    protected void _calculate(Context ctx, BgSchemeInfo bgSchemeInfo, BgOrgUnitInfo bgOrgUnitInfo, BizMemberQuery query, Map variateMap, BgSchemeDimensionHelper schemeHelper, Map analyseMap) throws BOSException, EASBizException {
        logger.debug((Object)(" MbgQingAnalyseFacade calculate start,bgorgUnit Number:" + bgOrgUnitInfo.getNumber() + " , bgOrgUnit Name :" + bgOrgUnitInfo.getName()));
        this.checkBizParameter(ctx, bgSchemeInfo, bgOrgUnitInfo);
        if (analyseMap == null || analyseMap.isEmpty() || !analyseMap.containsKey(bgOrgUnitInfo.getOrgUnitID())) {
            return;
        }
        String periodNum = null;
        ArrayList<String> bizCalcIds = null;
        List analyseList = null;
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            analyseList = (List)analyseMap.get(bgOrgUnitInfo.getOrgUnitID());
            for (MbgQingAnalyseInfo analyseInfo : analyseList) {
                QingAnalyseRefCollection refBizCalc = analyseInfo.getRefBizCalc();
                if (refBizCalc == null || refBizCalc.isEmpty()) continue;
                bizCalcIds = new ArrayList<String>();
                int jn = refBizCalc.size();
                for (int j = 0; j < jn; ++j) {
                    BizCalcInfo bizCalcInfo = refBizCalc.get(j).getBizCalc();
                    if (bizCalcInfo.getState().getValue() != 2 || bizCalcIds == null || bizCalcIds.contains(bizCalcInfo.getId().toString())) continue;
                    bizCalcIds.add(bizCalcInfo.getId().toString());
                }
                boolean check = BizCalcFactory.getLocalInstance((Context)ctx).checkPeriodVariable(bgSchemeInfo.getId(), bizCalcIds, false);
                if (check) {
                    BgPeriodInfo bgPeriod = analyseInfo.getBgPeriod();
                    periodNum = bgPeriod == null ? "MONT." + BgNPeriodHelper.getPeriodNum((Date)new Date(), (BgPeriodEnum)BgPeriodEnum.MONTH) : bgPeriod.getNumber();
                }
                Map<String, List<BgPeriodDispInfo>> queryBgPeriodMember = null;
                MbgQingAnalyseDimSettingCollection dimSetColl = analyseInfo.getQingAnalyseDimSetting();
                int in = dimSetColl.size();
                for (int i = 0; i < in; ++i) {
                    MbgQingAnalyseDimSettingInfo dimSettingInfo = dimSetColl.get(i);
                    if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(dimSettingInfo.getDimNumber()) || !dimSettingInfo.getMembers().isEmpty()) continue;
                    queryBgPeriodMember = this.queryBgPeriodMember(ctx, bgSchemeInfo);
                }
                HashMap<String, MbgViewListDimensionInfo> dimMap = new HashMap<String, MbgViewListDimensionInfo>();
                this.buildDimension(query, (Map<String, String>)variateMap, analyseInfo, dimMap, schemeHelper);
                MbgViewListManager viewManager = this.buildDefaultViewListManager();
                MbgViewListDimensionManager dimensionManager = ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager();
                this.buildViewListManager(dimensionManager, dimMap, schemeHelper);
                ViewListMemberParserServerHelper memberParser = new ViewListMemberParserServerHelper(ctx, schemeHelper, analyseInfo.getOrgUnitId().toString());
                memberParser.parseMember(viewManager, false);
                List<BgPeriodDispInfo> bgPeriodMemberList2 = null;
                if (queryBgPeriodMember != null) {
                    for (List<BgPeriodDispInfo> bgPeriodMemberList2 : queryBgPeriodMember.values()) {
                        List<BgDimensionMember> convertPeriodMember = this.convertPeriodMember(bgPeriodMemberList2);
                        MbgViewListDimensionManager clone = dimensionManager.deepclone();
                        List<MbgViewListDimensionInfo> allDimensions = clone.getAllDimensions();
                        for (MbgViewListDimensionInfo viewListDimensionInfo : allDimensions) {
                            if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(viewListDimensionInfo.getNumber())) continue;
                            viewListDimensionInfo.getMember().clear();
                            viewListDimensionInfo.getMember().addAll(convertPeriodMember);
                        }
                        ((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).setDimensionManager(clone);
                        this.dimensionQuery(ctx, conn, bgSchemeInfo, bgOrgUnitInfo, schemeHelper, periodNum, bizCalcIds, analyseInfo, viewManager, clone, variateMap);
                    }
                    continue;
                }
                this.dimensionQuery(ctx, conn, bgSchemeInfo, bgOrgUnitInfo, schemeHelper, periodNum, bizCalcIds, analyseInfo, viewManager, dimensionManager, variateMap);
            }
        }
        catch (Exception e) {
            logger.error((Object)("qingAnalyse calculate error:" + e.getCause()));
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private IDimensionParameter dimensionQuery(Context ctx, Connection conn, BgSchemeInfo bgSchemeInfo, BgOrgUnitInfo bgOrgUnitInfo, BgSchemeDimensionHelper schemeHelper, String periodNum, List<String> bizCalcIds, MbgQingAnalyseInfo analyseInfo, MbgViewListManager viewManager, MbgViewListDimensionManager dimensionManager, Map variateMap) throws EASBizException, BOSException {
        IDimension iDimension = null;
        List<com.kingdee.eas.ma.mbg.dimension.face.IMember> dimensionMember = null;
        this.removeCancel(ctx, dimensionManager, schemeHelper, bgOrgUnitInfo.getId().toString());
        this.removePeriod(ctx, schemeHelper, bgSchemeInfo, dimensionManager, analyseInfo);
        IDimensionParameter parameter = this.transDimParameter(ctx, viewManager, bgSchemeInfo, bgOrgUnitInfo, periodNum);
        this.dealBizCalcIds(parameter, bizCalcIds);
        parameter.getDataManager().setVariate(variateMap);
        List<IDimension> dims = parameter.getDims();
        for (IDimension dim : dims) {
            if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
            iDimension = dim;
        }
        HashSet<String> orgUnitNums = new HashSet<String>();
        HashMap<String, BgOrgUnitInfo> orgUnitIds = new HashMap<String, BgOrgUnitInfo>();
        if (iDimension != null) {
            dimensionMember = iDimension.getDimensionMember();
        }
        logger.debug(" MbgQingAnalyseFacade calculate dimensionQuery ,bgorgUnit Number:" + bgOrgUnitInfo.getNumber() + " , bgOrgUnit Name :" + bgOrgUnitInfo.getName() + " ,dimensionMember size: " + dimensionMember == null ? null : Integer.valueOf(dimensionMember.size()));
        for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimensionMember) {
            orgUnitNums.add(member.getNumber());
        }
        BgOrgViewInfo orgViewInfo = MbgQingAnalyseHelper.getOrgViewInfo(ctx, bgSchemeInfo);
        List<BgOrgUnitInfo> bgOrgUnitInfos = null;
        bgOrgUnitInfos = orgUnitNums.isEmpty() ? MbgDataHelper.getBgOrgUnitChildren(ctx, conn, ctx.getLocale(), bgOrgUnitInfo, null, true, null, false) : MbgDataHelper.getBgOrgUnitsByNumber(ctx, conn, ctx.getLocale(), orgViewInfo.getId(), false, orgUnitNums);
        for (BgOrgUnitInfo info : bgOrgUnitInfos) {
            orgUnitIds.put(info.getNumber(), info);
        }
        parameter.getControlManager().setHasQueryDataState(false);
        IDimensionParameter clone = null;
        HashSet<String> orgId = null;
        for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimensionMember) {
            logger.debug((Object)("MbgQingAnalyseCalculate dimensionQuery, BgOrgUnitNumber: " + member.getNumber() + " , BgOrgUnitName: " + member.getName() + " ,time: " + this.outputTime()));
            clone = parameter.getClone(ctx);
            dims = clone.getDims();
            for (IDimension dim : dims) {
                if (!DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(dim.getNumber())) continue;
                dim.getDimensionMember().clear();
                dim.getDimensionMember().add(member);
            }
            orgId = new HashSet<String>();
            orgId.add(((BgOrgUnitInfo)orgUnitIds.get(member.getNumber())).getOrgUnitID());
            clone.setOrgUnitId(BOSUuid.read((String)((BgOrgUnitInfo)orgUnitIds.get(member.getNumber())).getOrgUnitID()));
            clone.getDataManager().setBgOrgUnit((BgOrgUnitInfo)orgUnitIds.get(member.getNumber()));
            clone.setQeryOrgIds(orgId);
            BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(clone);
        }
        return parameter;
    }

    @Override
    protected Object _dimensionQuery(Context ctx, IDimensionParameter parameter) throws BOSException, EASBizException {
        Object dimensionQuery = BgDimensionFacadeFactory.getLocalInstance(ctx).dimensionQuery(parameter);
        if (parameter.getBillId() != null) {
            MbgQingAnalyseFacadeFactory.getLocalInstance(ctx).updateDispatchData(parameter.getBillId().toString(), 9);
        }
        return dimensionQuery;
    }

    private List<BgDimensionMember> convertPeriodMember(List<BgPeriodDispInfo> bgPeriodMemberList) {
        ArrayList<BgDimensionMember> result = new ArrayList<BgDimensionMember>();
        BgDimensionMember member = null;
        for (BgPeriodDispInfo periodInfo : bgPeriodMemberList) {
            member = new BgDimensionMember(DimensionBaseConstants.DEF_PERIOD_NUMBER, DimensionBaseConstants.DEF_PERIOD_NUMBER, periodInfo.getName(), periodInfo.getNumber());
            member.setFillType(0);
            member.setSrcNumber(DimensionBaseConstants.DEF_PERIOD_SRCNUMBER);
            result.add(member);
        }
        return result;
    }

    private Map<String, List<BgPeriodDispInfo>> queryBgPeriodMember(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        HashSet<BOSUuid> periodTypeIds = new HashSet<BOSUuid>();
        SelectorItemCollection schemeSelector = new SelectorItemCollection();
        schemeSelector.add(new SelectorItemInfo("id"));
        schemeSelector.add(new SelectorItemInfo("number"));
        schemeSelector.add(new SelectorItemInfo("bgDimSettings.*"));
        schemeSelector.add(new SelectorItemInfo("bgDimSettings.Members.*"));
        BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeInfo.getId()), schemeSelector);
        BgDimSettingsCollection bgDimSettings = schemeInfo.getBgDimSettings();
        BgDimSettingsInfo bgDimSettingsInfo = null;
        BgDimSettingsMemberCollection members = null;
        int in = bgDimSettings.size();
        for (int i = 0; i < in; ++i) {
            bgDimSettingsInfo = bgDimSettings.get(i);
            if (!DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(bgDimSettingsInfo.getDimNumber())) continue;
            members = bgDimSettingsInfo.getMembers();
            int jn = members.size();
            for (int j = 0; j < jn; ++j) {
                periodTypeIds.add(members.get(j).getMemberID());
            }
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("*"));
        selector.add(new SelectorItemInfo("type.id"));
        selector.add(new SelectorItemInfo("type.number"));
        selector.add(new SelectorItemInfo("type.name"));
        selector.add(new SelectorItemInfo("type.fiscalYear"));
        selector.add(new SelectorItemInfo());
        view.setSelector(selector);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.id", periodTypeIds, CompareType.INCLUDE));
        view.setFilter(filter);
        BgPeriodDispCollection bgPeriodDisps = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(view);
        HashMap<String, List<BgPeriodDispInfo>> bgPeriodMemberMap = new HashMap<String, List<BgPeriodDispInfo>>();
        BgPeriodDispInfo bgPeriodDispInfo = null;
        BgPeriodTypeInfo bgPeriodTypeInfo = null;
        List<BgPeriodDispInfo> bgPeriodDispList = null;
        int in2 = bgPeriodDisps.size();
        for (int i = 0; i < in2; ++i) {
            bgPeriodDispInfo = bgPeriodDisps.get(i);
            bgPeriodTypeInfo = bgPeriodDispInfo.getType();
            if (bgPeriodTypeInfo != null && FiscalYearEnum.STRIDEYEAR.equals((Object)bgPeriodTypeInfo.getFiscalYear())) {
                if (bgPeriodMemberMap.containsKey(bgPeriodTypeInfo.getId().toString())) {
                    bgPeriodDispList = (List)bgPeriodMemberMap.get(bgPeriodTypeInfo.getId().toString());
                    bgPeriodDispList.add(bgPeriodDispInfo);
                    continue;
                }
                bgPeriodDispList = new ArrayList();
                bgPeriodDispList.add(bgPeriodDispInfo);
                bgPeriodMemberMap.put(bgPeriodTypeInfo.getId().toString(), bgPeriodDispList);
                continue;
            }
            if (bgPeriodMemberMap.containsKey("000000000000000000000000000=")) {
                bgPeriodDispList = (List)bgPeriodMemberMap.get("000000000000000000000000000=");
                bgPeriodDispList.add(bgPeriodDispInfo);
                continue;
            }
            bgPeriodDispList = new ArrayList();
            bgPeriodDispList.add(bgPeriodDispInfo);
            bgPeriodMemberMap.put("000000000000000000000000000=", bgPeriodDispList);
        }
        return bgPeriodMemberMap;
    }

    private void prepareAnalyseMap(Context ctx, BgSchemeInfo bgSchemeInfo, Map<String, List<MbgQingAnalyseInfo>> analyseMap, List<BgOrgUnitInfo> bgOrgUnits) throws BOSException {
        List<Object> analyseList = null;
        HashMap levelOrgMap = new HashMap();
        EntityViewInfo view = new EntityViewInfo();
        view.setSelector(this.getSelectors());
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgSchemeId", (Object)bgSchemeInfo.getId().toString(), CompareType.EQUALS));
        view.setFilter(filter);
        MbgQingAnalyseCollection coll = MbgQingAnalyseFactory.getLocalInstance(ctx).getMbgQingAnalyseCollection(view);
        if (coll == null || coll.isEmpty()) {
            return;
        }
        int in = coll.size();
        for (int i = 0; i < in; ++i) {
            MbgQingAnalyseInfo analyseInfo = coll.get(i);
            String orgUnitId = analyseInfo.getOrgUnitId().toString();
            if (analyseMap.containsKey(orgUnitId)) {
                analyseList = analyseMap.get(orgUnitId);
                analyseList.add(analyseInfo);
                continue;
            }
            analyseList = new ArrayList();
            analyseList.add(analyseInfo);
            analyseMap.put(orgUnitId, analyseList);
        }
    }

    private void removePeriod(Context ctx, BgSchemeDimensionHelper schemeHelper, BgSchemeInfo bgSchemeInfo, MbgViewListDimensionManager dimensionManager, MbgQingAnalyseInfo analyseInfo) throws EASBizException, BOSException {
        DimensionFilterHelper filterHelper = DimensionFilterHelper.getLocaleIntance(ctx, schemeHelper.getDimension(DimensionConstants.DEF_PERIOD_NUMBER), analyseInfo.getOrgUnitId().toString(), schemeHelper.getBgSchemeId(), null, null);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(new SelectorItemCollection());
        evi.getSelector().add("number");
        evi.setFilter(filterHelper.getFilter());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("beginDate", (Object)bgSchemeInfo.getDateFrom(), CompareType.GREATER_EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("endDate", (Object)bgSchemeInfo.getDateTo(), CompareType.LESS_EQUALS));
        BgPeriodDispCollection col = BgPeriodDispFactory.getLocalInstance((Context)ctx).getBgPeriodDispCollection(evi);
        HashSet<String> pNumbers = new HashSet<String>();
        for (int m = 0; m < col.size(); ++m) {
            pNumbers.add(col.get(m).getNumber());
        }
        MbgViewListDimensionInfo periodDim = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_PERIOD_NUMBER, dimensionManager.getAllDimensions());
        for (int n = periodDim.getMember().size() - 1; n >= 0; --n) {
            if (pNumbers.contains(BgViewHelper.getNumber(periodDim.getMember().get(n)))) continue;
            periodDim.getMember().remove(n);
        }
    }

    private void dealBizCalcIds(IDimensionParameter parameter, List<String> bizCalcIds) {
        ArrayList<BOSUuid> calcIds = new ArrayList<BOSUuid>();
        for (String bizCalcId : bizCalcIds) {
            calcIds.add(BOSUuid.read((String)bizCalcId));
        }
        parameter.setCalcIds(calcIds);
    }

    private IDimensionParameter transDimParameter(Context ctx, MbgViewListManager viewManager, BgSchemeInfo bgSchemeInfo, BgOrgUnitInfo bgOrgUnitInfo, String periodNum) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = new BgFormInfo();
        bgFormInfo.setState(BgFormStateEnum.Edited);
        bgFormInfo.setBgScheme(bgSchemeInfo);
        bgFormInfo.setOrgUnit(bgOrgUnitInfo.castToFullOrgUnitInfo());
        bgFormInfo.setBgTemplate(new BgTemplateInfo());
        bgFormInfo.getBgTemplate().setIsTransferQingAnalyse(true);
        bgFormInfo.getBgTemplate().setFormType(BgTemFormTypeEnum.VIEWLIST);
        IDimensionParameter parameter = null;
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        dimensionManager.add(((MbgViewListSheetManager)viewManager.getSheetManagers().get(0)).getDimensionManager());
        try {
            parameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, null);
            parameter.setBgTemplateId(null);
            if (!StringUtils.isEmpty((String)periodNum)) {
                parameter.addPeriodStandardNumber(periodNum);
            }
        }
        catch (EASBizException e) {
            throw e;
        }
        catch (BOSException e) {
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return parameter;
    }

    private void buildViewListManager(MbgViewListDimensionManager dimensionManager, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) {
        MbgViewListDimensionInfo dimension2 = null;
        List<String> addAndOtherDim = schemeHelper.getAccAndOtherDim(false);
        for (MbgViewListDimensionInfo dimension2 : dimMap.values()) {
            if (dimension2.getSelectMembers().isEmpty()) {
                dimension2.setMemberValueType(DimensionMemberValueModeEnum.All);
            }
            if (addAndOtherDim.contains(dimension2.getNumber())) {
                dimension2.setLayout("row");
                ((MbgViewListRowCol)dimensionManager.getRows().get(0)).getDimensions().add(dimension2);
            } else {
                dimension2.setLayout("col");
                ((MbgViewListRowCol)dimensionManager.getColumns().get(0)).getDimensions().add(dimension2);
            }
            dimensionManager.addDimensionInfo(dimension2);
        }
    }

    private void removeCancel(Context ctx, MbgViewListDimensionManager dimensionManager, BgSchemeDimensionHelper schemeHelper, String orgId) {
        List<MbgViewListDimensionInfo> dimensions = dimensionManager.getAllDimensions();
        MbgViewListDimensionInfo dimension = null;
        DimensionFilterHelper filterHelper = null;
        for (int i = 0; i < dimensions.size(); ++i) {
            dimension = dimensions.get(i);
            filterHelper = DimensionFilterHelper.getLocaleIntance(ctx, schemeHelper.getDimension(dimension.getNumber()), orgId, schemeHelper.getBgSchemeId(), null, null);
            Iterator it = dimension.getMember().iterator();
            while (it.hasNext()) {
                if (!filterHelper.isCancel(((BgDimensionMember)it.next()).getNumber())) continue;
                it.remove();
            }
        }
    }

    private void buildDimension(BizMemberQuery query, Map<String, String> variateMap, MbgQingAnalyseInfo analyseInfo, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        int in = analyseInfo.getQingAnalyseDimSetting().size();
        for (int i = 0; i < in; ++i) {
            if (DimensionBaseConstants.DEF_PROCESSTYPE_NUMBER.equals(analyseInfo.getQingAnalyseDimSetting().get(i).getDimNumber())) continue;
            this.buildDimension(query, variateMap, analyseInfo.getQingAnalyseDimSetting().get(i), dimMap, schemeHelper);
        }
    }

    private void buildDimension(BizMemberQuery query, Map<String, String> variateMap, MbgQingAnalyseDimSettingInfo dimSettingInfo, Map<String, MbgViewListDimensionInfo> dimMap, BgSchemeDimensionHelper schemeHelper) throws Exception {
        BgDimensionInfo dimension = schemeHelper.getDimension(dimSettingInfo.getDimNumber());
        MbgViewListDimensionInfo viewListDim = new MbgViewListDimensionInfo(null);
        dimension.cloneValue(viewListDim);
        dimMap.put(dimension.getNumber(), viewListDim);
        this.buildDimMember(query, variateMap, viewListDim, dimSettingInfo, schemeHelper);
    }

    private void buildDimMember(BizMemberQuery query, Map<String, String> variateMap, MbgViewListDimensionInfo viewListDim, MbgQingAnalyseDimSettingInfo dimSettingInfo, BgSchemeDimensionHelper schemeHelper) throws Exception {
        if (dimSettingInfo.getMembers().isEmpty()) {
            return;
        }
        ArrayList numbers = new ArrayList();
        int in = dimSettingInfo.getMembers().size();
        for (int i = 0; i < in; ++i) {
            MbgQingAnalyseMemberInfo memberInfo = dimSettingInfo.getMembers().get(i);
            BgMemberSelectTypeEnum memberSelectType = memberInfo.getMemberSelectType();
            if (BgMemberSelectTypeEnum.Member.equals((Object)memberSelectType) || BgMemberSelectTypeEnum.Variate.equals((Object)memberSelectType)) {
                viewListDim.getSelectMembers().add(MbgQingAnalyseHelper.convertMember(query, variateMap, dimSettingInfo, memberSelectType, memberInfo, schemeHelper));
            } else {
                viewListDim.getSelectMembers().addAll((List)MbgQingAnalyseHelper.convertMember(query, variateMap, dimSettingInfo, memberSelectType, memberInfo, schemeHelper));
            }
            viewListDim.setMemberType(BgMemberSelectTypeEnum.Member);
        }
    }

    private void checkBizParameter(Context ctx, BgSchemeInfo bgSchemeInfo, BgOrgUnitInfo bgOrgUnitInfo) throws MbgQingAnalyseException {
        if (ctx == null) {
            return;
        }
        if (bgSchemeInfo == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLBGSCHEME);
        }
        if (bgOrgUnitInfo == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLORGUNIT);
        }
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add(new SelectorItemInfo("bgSchemeId"));
        selectors.add(new SelectorItemInfo("orgUnitId"));
        selectors.add(new SelectorItemInfo("bgPeriod.*"));
        selectors.add(new SelectorItemInfo("refBizCalc.bizCalc.*"));
        selectors.add(new SelectorItemInfo("qingAnalyseDimSetting.*"));
        selectors.add(new SelectorItemInfo("qingAnalyseDimSetting.members.*"));
        return selectors;
    }

    public SelectorItemCollection getBgFormIdSelectors() {
        SelectorItemCollection selectors = new SelectorItemCollection();
        selectors.add("id");
        selectors.add("orgUnit.id");
        return selectors;
    }

    private MbgViewListManager buildDefaultViewListManager() {
        MbgViewListManager viewManager = new MbgViewListManager();
        MbgViewListSheetManager sheetManager = new MbgViewListSheetManager(viewManager);
        viewManager.getSheetManagers().add(sheetManager);
        MbgViewListDimensionManager dimensionManager = new MbgViewListDimensionManager(sheetManager);
        sheetManager.setDimensionManager(dimensionManager);
        MbgViewListRowCol rowObject = new MbgViewListRowCol();
        MbgViewListRowCol colObject = new MbgViewListRowCol();
        dimensionManager.getRows().add(rowObject);
        dimensionManager.getColumns().add(colObject);
        return viewManager;
    }

    @Override
    public List _getCalculateProcess(Context ctx, BgSchemeInfo bgSchemeInfo) throws BOSException, EASBizException {
        IRowSet query = null;
        ArrayList<MbgQingAnalyseCalculateInfo> result = null;
        MbgQingAnalyseCalculateInfo info = null;
        this.verifyCalculate(ctx, bgSchemeInfo);
        BgOrgViewInfo orgViewInfo = MbgQingAnalyseHelper.getOrgViewInfo(ctx, bgSchemeInfo);
        StringBuffer sql = new StringBuffer();
        sql.append("select orgUnit.FLongNumber,orgUnit.FNumber,orgUnit.FName_").append(ctx.getLocale()).append(",orgUnit.FLevel,orgUnit.FIsleaf,p.FUserName,p.FState,p.FLastRunTime,orgUnit.FShowLevel,orgUnit.FID,orgUnit.FIsVirtual from T_MBG_MbgQingAnalyseCalcPlan p left join T_MBG_BgOrgUnit orgUnit on orgUnit.FOrgUnitId = p.FOrgUnitId where p.FSchemeId = ? and orgUnit.FviewId = ? order by orgUnit.Fshowlevel ASC");
        try {
            query = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{bgSchemeInfo.getId().toString(), orgViewInfo.getId().toString()});
            if (query.size() == 0) {
                throw new MbgQingAnalyseException(MbgQingAnalyseException.OPERATECALCULATE);
            }
            result = new ArrayList<MbgQingAnalyseCalculateInfo>();
            while (query.next()) {
                info = new MbgQingAnalyseCalculateInfo();
                info.setLongNumber(query.getString(1));
                info.setNumber(query.getString(2));
                info.setName(query.getString(3));
                info.setLevel(query.getInt(4));
                info.setIsleaf(query.getBoolean(5));
                info.setUserName(query.getString(6));
                info.setState(query.getInt(7));
                info.setLastRunTime(query.getTimestamp(8));
                info.setShowLevel(query.getInt(9));
                info.setId(query.getString(10));
                info.setVirtual(query.getBoolean(11));
                result.add(info);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return result;
    }

    @Override
    protected void _checkCalculateState(Context ctx, BgSchemeInfo bgSchemeInfo, OrgUnitInfo orgUnitInfo) throws BOSException, EASBizException {
        if (bgSchemeInfo == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLBGSCHEME);
        }
        if (orgUnitInfo == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLORGUNIT);
        }
        int re = BgDBUtils.existTable((Context)ctx, (String)"T_MBG_MbgQingAnalyseCalcPlan");
        if (re == BgDBUtils.NO) {
            return;
        }
        try {
            IRowSet query = BgDBUtils.executeQuery((Context)ctx, (String)"select top 1 FID from T_MBG_MbgQingAnalyseCalcPlan where FSchemeId = ? and FOrgUnitId = ? and (FState = ? or FState = ?)", (Object[])new Object[]{bgSchemeInfo.getId().toString(), orgUnitInfo.getId().toString(), 0, -1});
            if (query.next()) {
                throw new MbgQingAnalyseException(MbgQingAnalyseException.ANALYSECALCULATING);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void verifyCalculate(Context ctx, BgSchemeInfo bgSchemeInfo) throws EASBizException, BOSException {
        if (bgSchemeInfo == null) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.ISNULLBGSCHEME);
        }
        int re = BgDBUtils.existTable((Context)ctx, (String)"T_MBG_MbgQingAnalyseCalcPlan");
        if (re == BgDBUtils.NO) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.OPERATECALCULATE);
        }
        try {
            IRowSet query = BgDBUtils.executeQuery((Context)ctx, (String)"select top 1 FID from T_MBG_MbgQingAnalyseCalcPlan where FSchemeId = ?", (Object[])new Object[]{bgSchemeInfo.getId().toString()});
            if (query.size() == 0) {
                throw new MbgQingAnalyseException(MbgQingAnalyseException.OPERATECALCULATE);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public int getPoolSize(Connection conn) throws EASBizException {
        IRowSet rst;
        int poolSize;
        block8: {
            poolSize = availableProcessors;
            if (conn == null) {
                return poolSize;
            }
            rst = null;
            try {
                rst = BgDBUtils.executeQuery((Connection)conn, (String)"SELECT FVALUE FROM T_MBG_PARAM where FNUMBER = ?", (Object[])new Object[]{"POOL_SIZE"});
                if (!rst.next()) break block8;
                try {
                    int _poolSize = Integer.parseInt(rst.getString("FVALUE"));
                    if (poolSize > _poolSize) {
                        poolSize = _poolSize;
                    }
                }
                catch (NumberFormatException ex) {
                    logger.error((Object)"poolSize param value trans error:", (Throwable)ex);
                }
                if (poolSize == 0) break block8;
                int ex = poolSize;
            }
            catch (SQLException ex) {
                try {
                    logger.error((Object)"sql error:", (Throwable)ex);
                    throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rst);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rst);
            return ex;
        }
        SQLUtils.cleanup((ResultSet)rst);
        poolSize = 1;
        return poolSize;
    }

    @Override
    protected void _actDataDispatch(Context ctx, String bgSchemeNums, String bgOrgUnitNums, String bgScenarioNums, String bgVersionNums) throws BOSException, EASBizException {
        logger.debug((Object)(" begin run MbgQingAnalyseFacade actDataDispatch, run time :" + this.outputTime()));
        if (StringUtils.isEmpty((String)bgSchemeNums)) {
            logger.error((Object)(" actDataDisPatch paramter error,bgSchemeNums: " + bgSchemeNums));
            return;
        }
        ExecutorService threadService = null;
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            this.createDispatchPlanTable(conn);
            threadService = Executors.newFixedThreadPool(this.getPoolSize(conn));
            String userName = ContextUtil.getCurrentUserInfo((Context)ctx).getName(ctx.getLocale());
            String[] bgScenarioNumArr = null;
            String[] bgOrgUnitNumArr = null;
            String[] bgVersionNumArr = null;
            BgScenarioCollection bgScenarioColl = null;
            ArrayList<BgScenarioInfo> bgScenarios = null;
            String[] bgSchemeNum = bgSchemeNums.split(",");
            if (bgScenarioNums != null && !bgScenarioNums.isEmpty()) {
                bgScenarioNumArr = bgScenarioNums.split(",");
            }
            if (bgOrgUnitNums != null && !bgOrgUnitNums.isEmpty()) {
                bgOrgUnitNumArr = bgOrgUnitNums.split(",");
            }
            if (bgVersionNums != null && !bgVersionNums.isEmpty()) {
                bgVersionNumArr = bgVersionNums.split(",");
            }
            BgSchemeCollection bgSchemeColl = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(this.getEntiryViewInfo(DimensionBaseConstants.DEF_SCHEME_NUMBER, bgSchemeNum));
            if (bgScenarioNumArr != null && bgScenarioNumArr.length > 0) {
                bgScenarioColl = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection(this.getEntiryViewInfo(DimensionBaseConstants.DEF_SCENARIO_NUMBER, bgScenarioNumArr));
                bgScenarios = new ArrayList<BgScenarioInfo>();
                int in = bgScenarioColl.size();
                for (int i = 0; i < in; ++i) {
                    bgScenarios.add(bgScenarioColl.get(i));
                }
            }
            ArrayList<Future<Object>> result = new ArrayList<Future<Object>>();
            int n = bgSchemeColl.size();
            for (int i = 0; i < n; ++i) {
                String bgSchemeId = bgSchemeColl.get(i).getId().toString();
                if (bgScenarios != null && !bgScenarios.isEmpty()) {
                    this.filterBgScenarioByScheme(ctx, bgScenarios, bgSchemeId);
                }
                Map<String, List<BgFormInfo>> bgForms = this.getAllFormsByScheme(ctx, bgSchemeId, bgOrgUnitNumArr, bgVersionNumArr);
                this.addDispatchData(ctx, bgSchemeId, bgForms, userName);
                HashSet<String> filterFormIds = new HashSet<String>();
                IRowSet executeQuery = BgDBUtils.executeQuery((Context)ctx, (String)"select FbgFormId from T_MBG_MbgQingDispatchPlan where FSchemeId = ? and FState = ? ", (Object[])new Object[]{bgSchemeId, 9});
                while (executeQuery.next()) {
                    filterFormIds.add(executeQuery.getString(1));
                }
                BOSUuid bgOrgViewId = BgViewServerHelper.getBgViewIdBySchemeId(ctx, BOSUuid.read((String)bgSchemeId));
                BgOrgUnitCollection bgOrgUnits = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection("select id,name,orgUnitID where viewID = '" + bgOrgViewId.toString() + "' and isVirtual = 0");
                int jn = bgOrgUnits.size();
                for (int j = 0; j < jn; ++j) {
                    result.add(threadService.submit(new MbgQingAnalyseDispatchThread(ctx, bgForms.get(bgOrgUnits.get(j).getOrgUnitID()), bgScenarios, bgOrgViewId, filterFormIds)));
                }
            }
            for (Future future : result) {
                future.get();
            }
            logger.debug((Object)"end ExecutorService shutdown");
            threadService.shutdown();
            logger.debug((Object)(" end run MbgQingAnalyseFacade actDataDispatch , run time: " + this.outputTime()));
        }
        catch (Exception e) {
            logger.error((Object)"actDataDispatch error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    public Map<String, List<BgFormInfo>> getAllFormsByScheme(Context ctx, String bgSchemeId, String[] bgOrgUnitNumArr, String[] bgVersionNumArr) throws BOSException {
        FilterItemInfo item;
        HashMap<String, List<BgFormInfo>> rst = new HashMap<String, List<BgFormInfo>>();
        BgFormInfo bgFormInfo = null;
        List<BgFormInfo> bgFormInfos = null;
        HashSet<Integer> state = new HashSet<Integer>();
        state.add(new Integer(15));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgSchemeId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.id", (Object)"bgMAAAAKIcA7rHKd", CompareType.NOTEQUALS));
        filter.getFilterItems().add(new FilterItemInfo("bgType.id", null));
        filter.getFilterItems().add(new FilterItemInfo("state".toLowerCase(), state, CompareType.NOTINCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        filter.setMaskString(" #0 AND ( #1 OR #2 ) AND #3 AND #4 ");
        if (bgOrgUnitNumArr != null && bgOrgUnitNumArr.length > 0) {
            item = new FilterItemInfo("orgUnit.number", new HashSet<String>(Arrays.asList(bgOrgUnitNumArr)), CompareType.INCLUDE);
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)item);
        }
        if (bgVersionNumArr != null && bgVersionNumArr.length > 0) {
            item = new FilterItemInfo("bgVersion.number", new HashSet<String>(Arrays.asList(bgVersionNumArr)), CompareType.INCLUDE);
            BgCommHelper.addFilterItem((FilterInfo)filter, (FilterItemInfo)item);
        }
        view.setFilter(filter);
        view.setSelector(BgFormInfo.getFormSelector2());
        BgFormCollection bgForms = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
        int in = bgForms.size();
        for (int i = 0; i < in; ++i) {
            bgFormInfo = bgForms.get(i);
            if (rst.containsKey(bgFormInfo.getOrgUnit().getId().toString())) {
                bgFormInfos = (List)rst.get(bgFormInfo.getOrgUnit().getId().toString());
                bgFormInfos.add(bgFormInfo);
                continue;
            }
            bgFormInfos = new ArrayList<BgFormInfo>();
            bgFormInfos.add(bgFormInfo);
            rst.put(bgFormInfo.getOrgUnit().getId().toString(), bgFormInfos);
        }
        return rst;
    }

    private void filterBgScenarioByScheme(Context ctx, List<BgScenarioInfo> bgScenarios, String bgSchemeId) throws EASBizException, BOSException {
        BgScenarioInfo bgScenarioInfo = null;
        BgSchemeDimensionHelper schemeHelper = null;
        ArrayList<String> numbers = new ArrayList<String>();
        schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeId.toString());
        BgDimensionInfo dimension = schemeHelper.getDimension(DimensionConstants.DEF_SCENARIO_NUMBER);
        List members = dimension.getMember();
        int in = members.size();
        for (int i = 0; i < in; ++i) {
            BgDimensionMember member = (BgDimensionMember)members.get(i);
            numbers.add(member.getNumber());
        }
        Iterator<BgScenarioInfo> iter = bgScenarios.iterator();
        while (iter.hasNext()) {
            bgScenarioInfo = iter.next();
            if (numbers == null || numbers.contains(bgScenarioInfo.getNumber())) continue;
            iter.remove();
        }
    }

    private EntityViewInfo getEntiryViewInfo(String type, String[] nums) {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", new HashSet<String>(Arrays.asList(nums)), CompareType.INCLUDE));
        if (DimensionBaseConstants.DEF_SCHEME_NUMBER.equals(type)) {
            filter.getFilterItems().add(new FilterItemInfo("isFiling", (Object)false, CompareType.EQUALS));
        }
        view.setFilter(filter);
        view.setSelector(sic);
        return view;
    }

    private void MbgFormDimensionQuery(Context ctx, BgFormInfo bgFormInfo, BOSUuid bgOrgViewId, List<BgScenarioInfo> bgScenarios) throws Exception {
        BgFormEntryInfo obj;
        IMbgViewManager curMbgViewManager = null;
        MbgXMLParser mbgXMLParser = new MbgXMLParser(ctx);
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            byte[] styleBytes = obj.getDimensionStyle();
            curMbgViewManager = mbgXMLParser.parse(dataBytes, styleBytes);
        }
        MBGFormFacadeFactory.getLocalInstance(ctx).loadViewManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewManager, null, bgFormInfo.getOrgUnit().getId().toString(), false, false);
        this.convertDimensionMember(ctx, bgFormInfo, bgOrgViewId, bgScenarios, curMbgViewManager);
    }

    private void convertDimensionMember(Context ctx, BgFormInfo bgFormInfo, BOSUuid bgOrgViewId, List<BgScenarioInfo> bgScenarios, IMbgViewManager curMbgViewManager) throws Exception, BOSException, EASBizException {
        List<IMbgSheetManager> sheetManagers = curMbgViewManager.getSheetManagers();
        BgViewHelper.movePageDimensionsToRow(curMbgViewManager, false);
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        int in = sheetManagers.size();
        for (int i = 0; i < in; ++i) {
            IMbgSheetManager sheetManager = sheetManagers.get(i);
            BgDimensionManagerImpl dimManager = (BgDimensionManagerImpl)sheetManager.getDimensionManager();
            List allDimensions = dimManager.getDimension();
            for (BgDimensionInfo dimensionInfo : allDimensions) {
                if (bgScenarios == null || bgScenarios.isEmpty() || !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
                dimensionInfo.getMember().clear();
                int jn = bgScenarios.size();
                for (int j = 0; j < jn; ++j) {
                    dimensionInfo.getMember().add(new BgDimensionMember(null, DimensionBaseConstants.DEF_SCENARIO_FIELD, bgScenarios.get(j).getName(), bgScenarios.get(j).getNumber()));
                }
            }
            dimensionManager.add(dimManager);
        }
        IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        MbgQingAnalyseFacadeFactory.getLocalInstance(ctx).dimensionQuery(dimParameter);
    }

    private void ViewListFormDimensionQuery(Context ctx, BOSUuid bgOrgViewId, BgFormInfo bgFormInfo, List<BgScenarioInfo> bgScenarios) throws Exception, BOSException, EASBizException {
        BgFormEntryInfo obj;
        MbgViewListManager curMbgViewManager = null;
        MbgViewListXMLParser viewListXMLParser = new MbgViewListXMLParser(ctx);
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            curMbgViewManager = viewListXMLParser.parse(dataBytes);
        }
        MBGViewListFormFacadeFactory.getLocalInstance(ctx).loadViewListManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewManager, null, null, false, false);
        this.convertScenarioMember(ctx, bgOrgViewId, bgFormInfo, curMbgViewManager, dimensionManager, bgScenarios);
    }

    private void convertScenarioMember(Context ctx, BOSUuid bgOrgViewId, BgFormInfo bgFormInfo, MbgViewListManager curMbgViewManager, List<IBgDimensionManagerBase> dimensionManager, List<BgScenarioInfo> bgScenarios) throws Exception, BOSException, EASBizException {
        List sheetManagers = curMbgViewManager.getSheetManagers();
        BgViewHelper.movePageDimensionsToRow(curMbgViewManager, false);
        int in = sheetManagers.size();
        for (int i = 0; i < in; ++i) {
            MbgViewListSheetManager mbgViewListSheetManager = (MbgViewListSheetManager)sheetManagers.get(i);
            MbgViewListDimensionManager dimManager = mbgViewListSheetManager.getDimensionManager();
            List<MbgViewListDimensionInfo> allDimensions = dimManager.getAllDimensions();
            for (MbgViewListDimensionInfo dimensionInfo : allDimensions) {
                if (bgScenarios == null || bgScenarios.isEmpty() || !DimensionConstants.DEF_SCENARIO_NUMBER.equals(dimensionInfo.getNumber())) continue;
                dimensionInfo.getMember().clear();
                int jn = bgScenarios.size();
                for (int j = 0; j < jn; ++j) {
                    dimensionInfo.getMember().add(new BgDimensionMember(null, DimensionBaseConstants.DEF_SCENARIO_FIELD, bgScenarios.get(j).getName(), bgScenarios.get(j).getNumber()));
                }
            }
            dimensionManager.add(dimManager);
        }
        IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
        MbgQingAnalyseFacadeFactory.getLocalInstance(ctx).dimensionQuery(dimParameter);
    }

    public SelectorItemCollection getBgFormSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        String selectorAll = System.getProperty("selector.all");
        if (StringUtils.isEmpty((String)selectorAll)) {
            selectorAll = "true";
        }
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("bgScheme.number"));
        sic.add(new SelectorItemInfo("bgScheme.name"));
        sic.add(new SelectorItemInfo("bgScheme.state"));
        sic.add(new SelectorItemInfo("bgTemplate.name"));
        sic.add(new SelectorItemInfo("bgPeriod.name"));
        sic.add(new SelectorItemInfo("bgPeriod.number"));
        sic.add(new SelectorItemInfo("bgPeriod.periodType"));
        sic.add(new SelectorItemInfo("currency.name"));
        sic.add(new SelectorItemInfo("creator.name"));
        sic.add(new SelectorItemInfo("createTime"));
        sic.add(new SelectorItemInfo("auditTime"));
        sic.add(new SelectorItemInfo("dataSource"));
        sic.add(new SelectorItemInfo("state"));
        sic.add(new SelectorItemInfo("lastUpdateTime"));
        sic.add(new SelectorItemInfo("lastUpdateUser.name"));
        sic.add(new SelectorItemInfo("adjust.id"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.longNumber"));
        sic.add(new SelectorItemInfo("measureUnit.id"));
        sic.add(new SelectorItemInfo("measureUnit.name"));
        sic.add(new SelectorItemInfo("bgType.name"));
        sic.add(new SelectorItemInfo("auditor.name"));
        sic.add(new SelectorItemInfo("bgScheme.id"));
        sic.add(new SelectorItemInfo("bgTemplate.formType"));
        sic.add(new SelectorItemInfo("hasAtt"));
        sic.add(new SelectorItemInfo("record"));
        sic.add(new SelectorItemInfo("bgVersion.name"));
        sic.add(new SelectorItemInfo("description"));
        return sic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _initPropertiesDimension(Context ctx, MbgViewListManager manager, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        if (manager == null) {
            return null;
        }
        Connection conn = null;
        ViewListMemberCacheHelper memberCacheHelper = null;
        HashMap queryProSortMember = new HashMap();
        try {
            Map<String, List<BgDimensionMember>> queryPropertyMember;
            conn = BgDBUtils.getConnection((Context)ctx);
            HashSet<String> selectAllDim = new HashSet<String>();
            HashMap<String, Map<Integer, Set<String>>> queryMap = new HashMap<String, Map<Integer, Set<String>>>();
            HashSet<String> variSet = new HashSet<String>();
            HashSet<String> propSet = new HashSet<String>();
            HashSet<String> otherSet = new HashSet<String>();
            ArrayList<MbgViewListDimensionInfo> periodAliasDims = new ArrayList<MbgViewListDimensionInfo>();
            ViewListMemberParserServerHelper viewListHelper = new ViewListMemberParserServerHelper(ctx, bgSchemeId, orgUnitId);
            memberCacheHelper = manager.getMemberCacheHelper() != null ? manager.getMemberCacheHelper() : viewListHelper.getMemberCacheHelper();
            memberCacheHelper.setCtx(ctx);
            viewListHelper.setMemberCacheHelper(memberCacheHelper);
            viewListHelper.prepareMember(manager, selectAllDim, queryMap, variSet, propSet, otherSet, periodAliasDims);
            HashSet<String> propSortSet = new HashSet<String>();
            ArrayList objects = new ArrayList();
            for (int s = 0; s < manager.getSheetManagers().size(); ++s) {
                objects.addAll(((MbgViewListSheetManager)manager.getSheetManagers().get(s)).getDimensionManager().getRowDimension());
                objects.addAll(((MbgViewListSheetManager)manager.getSheetManagers().get(s)).getDimensionManager().getColDimension());
            }
            for (int i = 0; i < objects.size(); ++i) {
                MbgViewListAtribute attribObject;
                Object object = objects.get(i);
                if (!(object instanceof MbgViewListAtribute) || (attribObject = (MbgViewListAtribute)object).getPropertySort().getId() == null) continue;
                propSortSet.add(attribObject.getPropertySort().getId().toString());
            }
            if (!propSortSet.isEmpty()) {
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("id");
                evi.setFilter(new FilterInfo());
                evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPropertySort.id", propSortSet, CompareType.INCLUDE));
                BgPropertyCollection coll = BgPropertyFactory.getLocalInstance((Context)ctx).getBgPropertyCollection(evi);
                int in = coll.size();
                for (int i = 0; i < in; ++i) {
                    propSet.add(coll.get(i).getId().toString());
                }
            }
            if ((queryPropertyMember = viewListHelper.queryPropertyMember(conn, orgUnitId, propSet)) != null && !queryPropertyMember.isEmpty()) {
                Set<String> proIds = queryPropertyMember.keySet();
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("bgPropertySort.id");
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", proIds, CompareType.INCLUDE));
                view.setFilter(filter);
                BgPropertyInfo info = null;
                BgPropertyCollection bgPropertyColl = BgPropertyFactory.getLocalInstance((Context)ctx).getBgPropertyCollection(view);
                if (bgPropertyColl != null && !bgPropertyColl.isEmpty()) {
                    int in = bgPropertyColl.size();
                    for (int i = 0; i < in; ++i) {
                        List<HashMap<String, List<BgDimensionMember>>> list;
                        info = bgPropertyColl.get(i);
                        String proSortId = info.getBgPropertySort().getId().toString();
                        String proId = info.getId().toString();
                        HashMap<String, List<BgDimensionMember>> propertyMap = new HashMap<String, List<BgDimensionMember>>();
                        propertyMap.put(proId, queryPropertyMember.get(proId));
                        if (queryProSortMember.containsKey(proSortId)) {
                            list = (List)queryProSortMember.get(proSortId);
                            list.add(propertyMap);
                            continue;
                        }
                        list = new ArrayList();
                        list.add(propertyMap);
                        queryProSortMember.put(proSortId, list);
                    }
                }
            }
            HashMap hashMap = queryProSortMember;
            return hashMap;
        }
        finally {
            if (conn != null) {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }

    @Override
    protected void _setPropertiesDataByCache(Context ctx, BgPropertySortInfo bgPropertySortInfo, Map propertiesDimension, Map dimensions, String billId) throws BOSException, EASBizException {
        try {
            Class<?> clss = Class.forName(PROPERTIESANALYSECLASS);
            Constructor<?> constructor = clss.getConstructor(Context.class, BgPropertySortInfo.class, Map.class, Map.class, String.class);
            constructor.newInstance(ctx, bgPropertySortInfo, propertiesDimension, dimensions, billId);
        }
        catch (Exception e) {
            logger.error((Object)(PROPERTIESANALYSECLASS + " ClassNotFoundException :"), (Throwable)e);
        }
    }

    @Override
    protected boolean _checkOrgPermission(Context ctx, String orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || orgUnitId == null) {
            return false;
        }
        String sql = "select FID from T_PM_OrgRange where FUserID  = ? and FOrgID = ?";
        String useId = ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString();
        try {
            IRowSet executeQuery = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{useId, orgUnitId});
            if (executeQuery.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"checkOrgPermission error", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    public void _addDispatchData(Context ctx, String bgSchemeId, Map orgRefBgForms, String userName) throws BOSException, EASBizException {
        if (orgRefBgForms == null || orgRefBgForms.isEmpty()) {
            return;
        }
        ArrayList bgForms = new ArrayList();
        String orgUnitId = null;
        for (Map.Entry entry : orgRefBgForms.entrySet()) {
            orgUnitId = (String)entry.getKey();
            if (this.isExistsDispatchData(ctx, bgSchemeId, orgUnitId)) continue;
            bgForms.addAll((Collection)entry.getValue());
        }
        logger.debug((Object)(" add dispatchData plan ,bgSchemeId: " + bgSchemeId + " ,bgForms size : " + bgForms.size()));
        BgFormInfo bgFormInfo = null;
        Timestamp runTime = new Timestamp(System.currentTimeMillis());
        String sql = "insert into T_MBG_MbgQingDispatchPlan(FID,FSchemeId,ForgUnitId,FbgFormId,FUserName,FState,FCreateTime,FEndTime) values(?,?,?,?,?,?,?,?)";
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        int in = bgForms.size();
        for (int i = 0; i < in; ++i) {
            bgFormInfo = (BgFormInfo)bgForms.get(i);
            Object[] param = new Object[]{BOSUuid.create((String)DispatchPlanID).toString(), bgSchemeId, bgFormInfo.getOrgUnit().getId().toString(), bgFormInfo.getId().toString(), userName, -1, runTime, runTime};
            params.add(param);
        }
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)sql, params);
        }
        catch (Exception e) {
            logger.debug((Object)" add Dispatch Plan data error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private boolean isExistsDispatchData(Context ctx, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        String sql = "select top 1 FID from T_MBG_MbgQingDispatchPlan where FSchemeId = ? and FOrgUnitId = ?";
        try {
            IRowSet rst = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeId, orgUnitId});
            if (rst.next()) {
                return true;
            }
        }
        catch (SQLException e) {
            logger.debug((Object)" isExistsDispatchData error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    @Override
    public void _updateDispatchData(Context ctx, String bgFormId, int state) throws BOSException, EASBizException {
        String sql = "update T_MBG_MbgQingDispatchPlan set FState = ?, FEndTime = ? where FbgFormId = ?";
        try {
            Timestamp runTime = new Timestamp(System.currentTimeMillis());
            BgDBUtils.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{state, runTime, bgFormId});
        }
        catch (SQLException e) {
            logger.debug((Object)" update Dispatch Plan data error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void clearDisPatchData(Connection conn, String bgSchemeId) throws BOSException {
        logger.debug((Object)("clear dispatchData plan,bgSchemeId :" + bgSchemeId));
        String sql = "delete from T_MBG_MbgQingDispatchPlan where FSchemeId = ? ";
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql, (Object[])new Object[]{bgSchemeId});
        }
        catch (SQLException e) {
            logger.debug((Object)" clear Dispatch Plan data error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void createDispatchPlanTable(Connection conn) throws BOSException {
        logger.debug((Object)"begin create Dispatch Plan Table.");
        if (conn == null) {
            return;
        }
        int re = BgDBUtils.existTable((Connection)conn, (String)"T_MBG_MbgQingDispatchPlan");
        StringBuffer sql = new StringBuffer();
        if (re == BgDBUtils.NO) {
            sql.append("Create Table T_MBG_MbgQingDispatchPlan (FID VARCHAR(44) DEFAULT '' NOT NULL, FSchemeId VARCHAR(44) DEFAULT '' NOT NULL, FOrgUnitId VARCHAR(44) DEFAULT '' NOT NULL, FbgFormId VARCHAR(44) DEFAULT '' NOT NULL, FUserName VARCHAR(44), FState INT DEFAULT -1 NOT NULL, FCreateTime DateTime, FEndTime DateTime )");
            try {
                BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString());
            }
            catch (SQLException e) {
                logger.debug((Object)" create Dispatch Plan Table error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    protected String outputTime() {
        return format.format(System.currentTimeMillis());
    }

    @Override
    public List _queryAccMember(Context ctx, String bgSchemeId, int memberType, List members) throws BOSException, EASBizException {
        ArrayList<BgDimensionMember> data = new ArrayList<BgDimensionMember>();
        if (members == null || bgSchemeId == null) {
            return null;
        }
        BizMemberQuery query = BizMemberQuery.getInstance((Context)ctx, (String)bgSchemeId);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            BgSchemeInfo bgSchemeInfo = MbgDataHelper.getBgSchemeInfo(conn, ctx.getLocale(), BOSUuid.read((String)bgSchemeId));
            String accViewId = bgSchemeInfo.getViewId(DimensionBaseConstants.DEF_ACCOUNT_NUMBER).toString();
            Map<String, String> variateMap = BgVariateUtils.queryVariate(conn, BOSUuid.read((String)bgSchemeId));
            for (Object obj : members) {
                BgDimensionMember member = (BgDimensionMember)obj;
                if (memberType == 1) {
                    if (0 == member.getFillType()) {
                        data.add(member);
                        continue;
                    }
                    if (StringUtils.isEmpty((String)member.getNumber())) continue;
                    query.addQueryMember(DimensionConstants.DEF_BGINDEX_FIELD, member.getNumber(), member.getFillType(), BizMemberQuery.QUERY_ALL);
                    continue;
                }
                if (memberType == 2) {
                    String number = variateMap.get(member.getNumber());
                    BgDimensionMember m = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, member.getName(), number);
                    m.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
                    data.add(m);
                    continue;
                }
                if (memberType != 4 || StringUtils.isEmpty((String)member.getNumber())) continue;
                query.addQueryFunction(DimensionConstants.DEF_BGINDEX_FIELD, member.getNumber(), variateMap);
            }
            Map queryMap = query.queryMember();
            if (queryMap != null && !queryMap.isEmpty()) {
                Iterator iterator = ((List)queryMap.get(DimensionConstants.DEF_BGINDEX_FIELD)).iterator();
                HashSet<String> numbers = new HashSet<String>();
                while (iterator.hasNext()) {
                    numbers.add(((IMember)iterator.next()).getNumber());
                }
                EntityViewInfo evi = new EntityViewInfo();
                evi.setSelector(new SelectorItemCollection());
                evi.getSelector().add("number");
                evi.getSelector().add("name");
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)accViewId, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("number", numbers, CompareType.INCLUDE));
                evi.setFilter(filter);
                BgAccountCollection coll = BgAccountFactory.getLocalInstance((Context)ctx).getBgAccountCollection(evi);
                int in = coll.size();
                for (int i = 0; i < in; ++i) {
                    BgAccountInfo bgAccountInfo = coll.get(i);
                    BgDimensionMember m = new BgDimensionMember(DimensionConstants.DEF_ACCOUNT_NUMBER, DimensionConstants.DEF_BGINDEX_FIELD, bgAccountInfo.getName(), bgAccountInfo.getNumber());
                    m.setSrcNumber(DimensionConstants.DEF_INDEX_SRCNUMBER);
                    data.add(m);
                }
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return data;
    }

    @Override
    protected void _checkQingFilesIsEmpty(Context ctx, BgSchemeInfo bgScheme, String orgUnitId) throws BOSException, EASBizException {
        if (bgScheme == null || StringUtils.isEmpty((String)orgUnitId)) {
            return;
        }
        final HashSet qsFields = new HashSet();
        BgOrgViewInfo orgViewInfo = MbgQingAnalyseHelper.getOrgViewInfo(ctx, bgScheme);
        Map<String, String> childrenOrgUnit = MbgQingAnalyseHelper.getChildrenOrgUnit(ctx, orgUnitId, orgViewInfo.getId().toString());
        StringBuffer sql = new StringBuffer();
        sql.append("select FQsId from T_MBG_MbgQingAnalyseInteg where FBgSchemeId = ? and FOrgUnitId in (");
        MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
        MbgSqlHelper.executeBatchQuery((Context)ctx, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams((Object[])new Object[]{bgScheme.getId().toString()}, (Object[])childrenOrgUnit.keySet().toArray(), (int)50), (IResultReader)new IResultReader(){

            public void read(ResultSet res) throws SQLException {
                if (!"000000000000000000000000000=".equals(res.getString(1))) {
                    qsFields.add(res.getString(1));
                }
            }
        });
        if (qsFields.isEmpty()) {
            throw new MbgQingAnalyseException(MbgQingAnalyseException.FILEISEMPTY);
        }
    }
}

