/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.qing.datasource.meta.DataType;
import com.kingdee.bos.qing.datasource.meta.MetaInfo;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceVisitor;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetDataSourceWriter;
import com.kingdee.bos.qing.preparedata.handler.budget.BudgetFacade;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.ma.base.BgException;
import com.kingdee.eas.ma.base.BgPropertyCollection;
import com.kingdee.eas.ma.base.BgPropertyInfo;
import com.kingdee.eas.ma.base.BgPropertySortCollection;
import com.kingdee.eas.ma.base.BgPropertySortInfo;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberCollection;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgDimCacheUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgDimensionFacadeFactory;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgDimensionFacade;
import com.kingdee.eas.ma.mbg.IMBGFormFacade;
import com.kingdee.eas.ma.mbg.IMBGViewListFormFacade;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseConvertMsgObj;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseFileInfo;
import com.kingdee.eas.ma.mbg.MbgQingAnalyseIntegrateFactory;
import com.kingdee.eas.ma.mbg.MbgQingDataParam;
import com.kingdee.eas.ma.mbg.RefBgPropertySortCollection;
import com.kingdee.eas.ma.mbg.RefBgPropertySortFactory;
import com.kingdee.eas.ma.mbg.RefBgPropertySortInfo;
import com.kingdee.eas.ma.mbg.app.AbstractMbgQingAnalyseIntegrateControllerBean;
import com.kingdee.eas.ma.mbg.app.data.BgOrgMigrationUtils;
import com.kingdee.eas.ma.mbg.app.qingstore.MbgQingStoreUtils;
import com.kingdee.eas.ma.mbg.app.utils.BgViewServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManagerBase;
import com.kingdee.eas.ma.mbg.common.IBgNData;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.dimension.IDimension;
import com.kingdee.eas.ma.mbg.cube.member.IMember;
import com.kingdee.eas.ma.mbg.cube.member.Member;
import com.kingdee.eas.ma.mbg.cube.query.IQueryData;
import com.kingdee.eas.ma.mbg.cube.utils.MbgDataHelper;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.face.IDimDataQuery;
import com.kingdee.eas.ma.mbg.dimension.face.IDimensionParameter;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.query.QingDataFilterParam;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.MbgQingAnalyseIntegUtils;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.Uuid;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

public class MbgQingAnalyseIntegrateControllerBean
extends AbstractMbgQingAnalyseIntegrateControllerBean {
    private static final long serialVersionUID = -5724089928516139148L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgQingAnalyseIntegationControllerBean");
    private SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    @Override
    protected void _lockQingAnalyse(Context ctx, Connection conn, BOSUuid bgSchemeId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null || orgUnitId == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update T_MBG_MbgQingAnalyseInteg set FCount = FCount + 1 where FBgSchemeId = ? and FOrgUnitId = ? ");
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString(), orgUnitId.toString()});
        }
        catch (SQLException ex) {
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _saveQingAnalyseData(Context ctx, IDimensionParameter parameter, Map bgDataMap) throws BOSException, EASBizException {
        if (ctx == null || parameter == null || bgDataMap == null || bgDataMap.isEmpty()) {
            return;
        }
        Connection conn = null;
        long beginTime = System.currentTimeMillis();
        try {
            BgFormInfo info;
            conn = BgDBUtils.getConnection((Context)ctx);
            if (!MbgQingAnalyseHelper.isSaveQingData(conn, "IS_START_QING_SAVE")) {
                logger.debug((Object)"Unable to save data to  qingAnalyse, cause: IS_START_QING_SAVE");
                return;
            }
            BgSchemeInfo bgScheme = parameter.getDataManager().getBgScheme();
            if (!bgScheme.isIsEnableAnalyse()) {
                logger.debug((Object)("Unable to save data to  qingAnalyse,cause: bgScheme.isIsEnableAnalyse ,scheme:" + bgScheme.getId().toString()));
                return;
            }
            IDimDataQuery dimDataQuery = parameter.getDataManager().getDimDataQuery();
            if (dimDataQuery != null && dimDataQuery instanceof BgFormInfo && !(info = (BgFormInfo)dimDataQuery).getBgTemplate().isIsTransferQingAnalyse()) {
                logger.debug((Object)"Unable to save data to  qingAnalyse,cause: isEnableAnalyse");
                return;
            }
            List<BgOrgUnitInfo> bgOrgUnits = null;
            logger.debug((Object)"begin save Qing Analyse Data!");
            logger.debug((Object)("MbgQingAnalyseIntegration save QingAnalyseData bgformId: " + parameter.getBillId()));
            boolean multiProcessType = parameter.getControlManager().isMultiProcessType();
            HashSet<String> nullKeys = new HashSet<String>();
            Map<String, Map<String, Map<String, IBgNData>>> convertBgDataMap = this.reConfigBgDataMap(bgDataMap, multiProcessType, parameter, nullKeys);
            if (convertBgDataMap == null || convertBgDataMap.isEmpty()) {
                logger.info((Object)"MbgQingAnalyseIntegration reConfigBgDataMap size is null,nullKey is null !!!");
                return;
            }
            HashMap<String, BgOrgUnitInfo> orgUnitMap = new HashMap<String, BgOrgUnitInfo>();
            bgOrgUnits = MbgDataHelper.getBgOrgUnits(ctx, conn, parameter.getBgOrgViewId(), convertBgDataMap.keySet());
            Iterator<BgOrgUnitInfo> iterator = bgOrgUnits.iterator();
            BgOrgUnitInfo bgOrgUnitInfo = null;
            while (iterator.hasNext()) {
                bgOrgUnitInfo = iterator.next();
                if (!bgOrgUnitInfo.isIsTransferQingAnalyse()) continue;
                orgUnitMap.put(bgOrgUnitInfo.getOrgUnitID(), bgOrgUnitInfo);
            }
            if (orgUnitMap.isEmpty()) {
                return;
            }
            BgPropertySortCollection bgPropertySorts = MbgQingAnalyseIntegUtils.getRefBgPropertyByScheme(bgScheme);
            Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers = this.queryPropertyMember(ctx, bgPropertySorts);
            Map<String, Map<String, BgDimensionMember>> queryMemberMap = this.queryMemberMapByParameter(ctx, parameter);
            logger.info((Object)(" bgOrgViewId: " + parameter.getBgOrgViewId() + " bgOrgUnits.size : " + bgOrgUnits.size()));
            boolean isUseQingPool = MbgQingAnalyseHelper.isSaveQingData(conn, "IS_USE_QING_POOL");
            for (Map.Entry<String, Map<String, Map<String, IBgNData>>> orgEntry : convertBgDataMap.entrySet()) {
                String orgUnitId = orgEntry.getKey();
                Map<String, Map<String, IBgNData>> processValue = orgEntry.getValue();
                if (!orgUnitMap.containsKey(orgUnitId)) continue;
                bgOrgUnitInfo = (BgOrgUnitInfo)orgUnitMap.get(orgUnitId);
                MbgQingDataParam param = this.getQingDataParam(parameter, bgOrgUnitInfo, nullKeys, bgPropertySorts, propMembers, queryMemberMap);
                if (isUseQingPool) {
                    MbgQingStoreUtils.getInstance(conn).writeData(ctx, param, processValue);
                    continue;
                }
                MbgQingAnalyseIntegrateFactory.getLocalInstance(ctx).saveSingleOrgData(param, processValue);
            }
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.debug((Object)("end save Qing Analyse Data! use = " + (System.currentTimeMillis() - beginTime) + "ms."));
    }

    private MbgQingDataParam getQingDataParam(IDimensionParameter parameter, BgOrgUnitInfo bgOrgUnitInfo, Set<String> nullKeys, BgPropertySortCollection bgPropertySorts, Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers, Map<String, Map<String, BgDimensionMember>> queryMemberMap) {
        MbgQingDataParam param = new MbgQingDataParam();
        param.setBgOrgUnitInfo(bgOrgUnitInfo);
        param.setDimenisonParameter(parameter);
        param.setNullKeys(nullKeys);
        param.setSorts(bgPropertySorts);
        param.setPropMembers(propMembers);
        param.setQueryMemberMap(queryMemberMap);
        return param;
    }

    private Map<String, Map<String, BgDimensionMember>> queryMemberMapByParameter(Context ctx, IDimensionParameter parameter) throws BOSException, EASBizException {
        List<MbgDimInfo> mbgDims = MbgQingAnalyseIntegUtils.getSchemeMbgDim(parameter.getDataManager().getDimensions(), parameter.getDataManager().getBgScheme());
        HashMap<String, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>> dimMemberMap = new HashMap<String, Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember>>();
        Map<String, com.kingdee.eas.ma.mbg.dimension.face.IMember> memberMap = null;
        List<com.kingdee.eas.ma.mbg.dimension.face.IDimension> dims = parameter.getDims();
        for (com.kingdee.eas.ma.mbg.dimension.face.IDimension dimension : dims) {
            if (dimMemberMap.containsKey(dimension.getField())) {
                memberMap = (Map)dimMemberMap.get(dimension.getField());
            } else {
                memberMap = new HashMap();
                dimMemberMap.put(dimension.getField(), memberMap);
            }
            for (com.kingdee.eas.ma.mbg.dimension.face.IMember member : dimension.getDimensionMember()) {
                memberMap.put(member.getNumber(), member);
            }
        }
        Map<String, Set<String>> standbyMap = parameter.getDataManager().getStandbyMap();
        if (standbyMap != null && !standbyMap.isEmpty()) {
            Set<IMember> members = null;
            for (Map.Entry<String, Set<String>> entry : standbyMap.entrySet()) {
                String field = entry.getKey();
                members = this.createDimensionMember(entry.getValue());
                if (dimMemberMap.containsKey(field)) {
                    memberMap = (Map)dimMemberMap.get(field);
                } else {
                    memberMap = new HashMap();
                    dimMemberMap.put(field, memberMap);
                }
                for (IMember member : members) {
                    memberMap.put(member.getNumber(), member.toMember());
                }
            }
        }
        if (!parameter.getQuerys().isEmpty()) {
            IQueryData query = null;
            IDimension mbgDim = null;
            IMember mbgMember = null;
            int in = parameter.getQuerys().size();
            for (int i = 0; i < in; ++i) {
                query = parameter.getQuerys().get(i);
                Map<String, IDimension> mbgDimMap = query.getMbgDimMap();
                for (Map.Entry<String, IDimension> entry : mbgDimMap.entrySet()) {
                    String mbgDimField = entry.getKey();
                    mbgDim = entry.getValue();
                    if (dimMemberMap.containsKey(mbgDim.getField())) {
                        memberMap = (Map)dimMemberMap.get(mbgDim.getField());
                    } else {
                        memberMap = new HashMap();
                        dimMemberMap.put(mbgDim.getField(), memberMap);
                    }
                    int xn = mbgDim.getMembers().size();
                    for (int x = 0; x < xn; ++x) {
                        mbgMember = mbgDim.getMembers().get(x);
                        memberMap.put(mbgMember.getNumber(), mbgMember.toMember());
                    }
                }
            }
        }
        if (memberMap != null) {
            logger.error((Object)("memberMap:" + memberMap));
        }
        HashMap<String, Map<String, BgDimensionMember>> queryMemberMap = new HashMap<String, Map<String, BgDimensionMember>>();
        for (MbgDimInfo mbgDim : mbgDims) {
            if (dimMemberMap == null || !dimMemberMap.containsKey(mbgDim.getRefField())) continue;
            memberMap = (Map)dimMemberMap.get(mbgDim.getRefField());
            Set numbers = memberMap.keySet();
            logger.error((Object)("orgUnitid:" + parameter.getOrgUnitId().toString() + " ,schemeid:" + parameter.getBgSchemeId().toString() + ", dimNumber:" + mbgDim.getNumber() + ", numbers:" + numbers));
            Map queryMembers = DimensionFormulaFacadeFactory.getLocalInstance(ctx).queryMembers(parameter.getOrgUnitId().toString(), parameter.getBgSchemeId().toString(), mbgDim.getNumber(), numbers);
            if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) {
                for (Map.Entry entry : queryMembers.entrySet()) {
                    String periodNum = (String)entry.getKey();
                    BgDimensionMember dimMember = (BgDimensionMember)entry.getValue();
                    com.kingdee.eas.ma.mbg.dimension.face.IMember iMember = (com.kingdee.eas.ma.mbg.dimension.face.IMember)memberMap.get(periodNum);
                    dimMember.setSortValue((Comparable)((Object)iMember.getMdxNumber()));
                }
            }
            logger.error((Object)(" mergerData queryMembers: " + queryMembers));
            queryMemberMap.put(mbgDim.getRefField(), queryMembers);
        }
        return queryMemberMap;
    }

    private Map<String, Map<String, Map<String, IBgNData>>> reConfigBgDataMap(Map bgProcessDataMap, boolean multiProcessType, IDimensionParameter parameter, Set<String> nullKeys) {
        if (bgProcessDataMap == null || bgProcessDataMap.isEmpty()) {
            return null;
        }
        HashMap<String, Map<String, Map<String, IBgNData>>> convertDataMap = new HashMap<String, Map<String, Map<String, IBgNData>>>();
        if (multiProcessType) {
            for (Map.Entry processEntry : bgProcessDataMap.entrySet()) {
                String processType = (String)processEntry.getKey();
                Map bgDataMap = (Map)processEntry.getValue();
                this.reConfigBgDataMap(processType, convertDataMap, bgDataMap, nullKeys);
            }
        } else {
            int valueType = parameter.getValueType();
            String processType = this.getProcessTypeByValueType(valueType);
            Set keySet = bgProcessDataMap.keySet();
            boolean isOrgUnit4Key = true;
            Iterator iter = keySet.iterator();
            while (iter.hasNext()) {
                if (!((String)iter.next()).contains("=BgItem")) continue;
                isOrgUnit4Key = false;
            }
            if (isOrgUnit4Key) {
                this.reConfigBgDataMap(processType, convertDataMap, bgProcessDataMap, nullKeys);
            } else {
                this.reConfigBgDataMap(processType, convertDataMap, parameter.getOrgUnitId().toString(), bgProcessDataMap, nullKeys);
            }
        }
        return convertDataMap;
    }

    private void reConfigBgDataMap(String processType, Map<String, Map<String, Map<String, IBgNData>>> convertDataMap, Map bgDataMap, Set<String> nullKeys) {
        for (Map.Entry orgEntry : bgDataMap.entrySet()) {
            String orgUnitId = (String)orgEntry.getKey();
            Object obj = orgEntry.getValue();
            if (!(obj instanceof Map)) continue;
            Map dataMap = (Map)obj;
            this.reConfigBgDataMap(processType, convertDataMap, orgUnitId, dataMap, nullKeys);
        }
    }

    private void reConfigBgDataMap(String processType, Map<String, Map<String, Map<String, IBgNData>>> convertDataMap, String orgUnitId, Map<String, IBgNData> bgDataMap, Set<String> nullKey) {
        for (Map.Entry<String, IBgNData> dataEntry : bgDataMap.entrySet()) {
            Map<String, IBgNData> dataMap;
            Map<Object, Object> processDataMap;
            String formulaKey = dataEntry.getKey();
            formulaKey = orgUnitId + "_" + formulaKey + "_" + processType;
            IBgNData value = dataEntry.getValue();
            if (value == null || value.getBudgetValueNoDef() == null && value.getActualValueNoDef() == null && value.getBizActualNoDef() == null || BigDecimal.ZERO.equals(value.getBudgetValueNoDef()) && BigDecimal.ZERO.equals(value.getActualValueNoDef()) && BigDecimal.ZERO.equals(value.getBizActualNoDef())) {
                nullKey.add(formulaKey);
                continue;
            }
            if (!convertDataMap.containsKey(orgUnitId)) {
                processDataMap = new HashMap();
                convertDataMap.put(orgUnitId, processDataMap);
            }
            if (!(processDataMap = convertDataMap.get(orgUnitId)).containsKey(processType)) {
                dataMap = new HashMap();
                processDataMap.put(processType, dataMap);
            }
            dataMap = (Map)processDataMap.get(processType);
            dataMap.put(dataEntry.getKey(), dataEntry.getValue());
        }
    }

    private String getMemberNum(IBgNData value, String splitFileType, Map<String, String> dimNum2SrcNums) {
        if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(splitFileType)) {
            return value.getBgVersion();
        }
        if (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(splitFileType)) {
            return value.getBgScenario();
        }
        if (DimensionBaseConstants.DEF_ELEMENT_NUMBER.equals(splitFileType)) {
            return value.getBgElementNumber();
        }
        if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(splitFileType)) {
            return value.getBgPeriodNumber();
        }
        if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(splitFileType)) {
            return value.getCurrencyNumber();
        }
        String dimNumber2 = null;
        String srcNum = dimNum2SrcNums.get(splitFileType);
        if (srcNum == null) {
            return dimNumber2;
        }
        for (String dimNumber2 : value.getBgItemNumber().split(",")) {
            if (dimNumber2.split(":")[0].equals(srcNum)) break;
        }
        return dimNumber2;
    }

    private String getProcessTypeByValueType(int valueType) {
        String result = BgProcessEnum.C01.getName();
        switch (valueType) {
            case 1: {
                result = BgProcessEnum.C01.getName();
                break;
            }
            case 256: {
                result = BgProcessEnum.C02.getName();
                break;
            }
            case 512: {
                result = BgProcessEnum.C03.getName();
                break;
            }
            case 1024: {
                result = BgProcessEnum.C04.getName();
                break;
            }
        }
        return result;
    }

    protected MetaInfo getMeta(Context ctx, List<MbgDimInfo> mbgDims, BgPropertySortCollection sorts) {
        MetaInfo metaInfo = new MetaInfo();
        if (ctx == null || mbgDims == null) {
            return metaInfo;
        }
        metaInfo.addField("key", "key", DataType.STRING, true);
        for (MbgDimInfo mbgDim : mbgDims) {
            metaInfo.addField(mbgDim.getNumber() + "_" + "NUM", mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING);
            metaInfo.addField(mbgDim.getNumber() + "_" + "PNUM", mbgDim.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING, true);
            metaInfo.addField(mbgDim.getNumber() + "_" + "ALIAS", mbgDim.getName(), DataType.STRING);
        }
        int in = sorts.size();
        for (int i = 0; i < in; ++i) {
            BgPropertySortInfo info = sorts.get(i);
            metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "NUM"), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING);
            metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "PNUM"), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING, true);
            metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "ALIAS"), info.getName(), DataType.STRING);
        }
        metaInfo.addField("value", EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysevalue", (Locale)ctx.getLocale()), DataType.NUMBER);
        return metaInfo;
    }

    protected List<Object[]> mergerData(Context ctx, List<MbgDimInfo> mbgDims, MetaInfo metaInfo, Map<String, Object> bgDataMap, IDimensionParameter parameter, BgOrgUnitInfo bgOrgUnitInfo, Set<String> nullKey, Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers, Map<String, Map<String, BgDimensionMember>> queryMemberMap) throws EASBizException, BOSException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        if (mbgDims == null || mbgDims.isEmpty() || metaInfo == null || bgDataMap == null || bgDataMap.isEmpty()) {
            return rows;
        }
        HashMap<String, MbgDimInfo> srcDimMap = new HashMap<String, MbgDimInfo>();
        for (MbgDimInfo mbgDim : mbgDims) {
            srcDimMap.put(mbgDim.getSrcNumber(), mbgDim);
        }
        Object[] row = null;
        Object[] tmpRow = null;
        HashMap<String, Object[]> valueMap = new HashMap<String, Object[]>();
        Object obj = null;
        Map dataMap = null;
        BgNDataInfo bgData2 = null;
        String formulaKey = null;
        String processType = null;
        for (Map.Entry<String, Object> entry : bgDataMap.entrySet()) {
            processType = entry.getKey();
            obj = entry.getValue();
            if (!(obj instanceof Map)) continue;
            dataMap = (Map)obj;
            for (BgNDataInfo bgData2 : dataMap.values()) {
                formulaKey = bgOrgUnitInfo.getOrgUnitID() + "_" + DimUtils.getDimDataKey(bgData2) + "_" + processType;
                if (bgData2 == null || nullKey.contains(formulaKey)) continue;
                tmpRow = this.updateAnalyseData(ctx, bgData2, mbgDims, parameter, srcDimMap, queryMemberMap, bgOrgUnitInfo, processType, metaInfo, propMembers);
                if (valueMap.containsKey(tmpRow[0])) {
                    row = (Object[])valueMap.get(tmpRow[0]);
                    int in = row.length;
                    for (int i = 0; i < in; ++i) {
                        row[i] = tmpRow[i];
                    }
                    continue;
                }
                valueMap.put((String)tmpRow[0], tmpRow);
                rows.add(tmpRow);
            }
        }
        return rows;
    }

    private Set<IMember> createDimensionMember(Set<String> values) {
        Member member = null;
        HashSet<IMember> members = new HashSet<IMember>();
        for (String value : values) {
            if (value.indexOf(":") <= 0) continue;
            member = new Member();
            member.setNumber(value.split(":")[1]);
            member.setDimNumber(value);
            member.setMdxNumber(value.split(":")[1]);
            member.setSrcNumber(value.split(":")[0]);
            members.add(member);
        }
        return members;
    }

    protected Object[] updateAnalyseData(Context ctx, BgNDataInfo mbgData, List<MbgDimInfo> mbgDims, IDimensionParameter parameter, Map<String, MbgDimInfo> srcMbgMap, Map<String, Map<String, BgDimensionMember>> queryMemberMap, BgOrgUnitInfo bgOrgUnitInfo, String processType, MetaInfo metaInfo, Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers) throws BOSException {
        if (mbgData == null || mbgDims == null || parameter == null || srcMbgMap == null || queryMemberMap == null) {
            return null;
        }
        Map currencyCache = BgDimCacheUtils.getCurrencyCache((Context)ctx);
        Map elementCache = BgDimCacheUtils.getElementCache((Context)ctx);
        Map scenarioCache = BgDimCacheUtils.getScenarioCache((Context)ctx);
        Map versionCache = BgDimCacheUtils.getVersionCache((Context)ctx);
        String srcNumber = null;
        String number = null;
        String dimNumber2 = null;
        String pNumber = null;
        String alias = null;
        Object sortNum = null;
        String[] tmpNums = null;
        Map<String, BgDimensionMember> memberMap = null;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        ArrayList<Object> values = new ArrayList<Object>();
        String key = bgOrgUnitInfo.getOrgUnitID() + "_" + DimUtils.getDimDataKey(mbgData) + "_" + processType;
        values.add(key);
        for (String dimNumber2 : mbgData.getBgItemNumber().split(",")) {
            tmpNums = dimNumber2.split(":");
            srcNumber = tmpNums[0];
            number = tmpNums[1];
            fieldMap.put(srcMbgMap.get(srcNumber).getRefField(), dimNumber2);
        }
        for (MbgDimInfo mbgDim : mbgDims) {
            String name;
            BgDimensionMember member = null;
            number = null;
            pNumber = null;
            alias = null;
            if (DimensionBaseConstants.DEF_ORGUNIT_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                String orgUnitNum = bgOrgUnitInfo.getNumber();
                if (memberMap != null && memberMap.containsKey(orgUnitNum)) {
                    member = memberMap.get(orgUnitNum);
                }
                if (member != null) {
                    number = member.getNumber();
                    pNumber = this.getParentNumber((String)((Object)member.getSortValue()));
                    alias = member.getName();
                } else {
                    number = orgUnitNum;
                    pNumber = this.getParentNumber(parameter.getDataManager().getBgOrgUnit().getLongNumber());
                    alias = parameter.getDataManager().getBgOrgUnit().getName();
                }
            } else if (DimensionBaseConstants.DEF_CURRENCY_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getCurrencyNumber())) {
                    member = memberMap.get(mbgData.getCurrencyNumber());
                }
                if (member != null) {
                    number = member.getNumber();
                    pNumber = null;
                    alias = member.getName();
                } else if (parameter.getDataManager().getDefCurrency() != null) {
                    number = mbgData.getCurrencyNumber();
                    pNumber = null;
                    name = parameter.getDataManager().getDefCurrency()[1];
                    alias = name != null ? name : ((IObjectValue)currencyCache.get(number)).get("name", ctx.getLocale()).toString();
                }
            } else if (DimensionBaseConstants.DEF_PERIOD_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgPeriodNumber())) {
                    member = memberMap.get(mbgData.getBgPeriodNumber());
                }
                if (member != null) {
                    number = member.getNumber();
                    pNumber = this.getParentNumber((String)((Object)member.getSortValue()));
                    alias = member.getName();
                }
            } else if (DimensionBaseConstants.DEF_ELEMENT_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgElementNumber())) {
                    member = memberMap.get(mbgData.getBgElementNumber());
                }
                if (member != null) {
                    number = member.getNumber();
                    pNumber = null;
                    alias = member.getName();
                } else if (parameter.getDataManager().getDefElement() != null) {
                    number = parameter.getDataManager().getDefElement()[0];
                    pNumber = null;
                    name = parameter.getDataManager().getDefElement()[1];
                    alias = name != null ? name : ((IObjectValue)elementCache.get(number)).get("name", ctx.getLocale()).toString();
                }
            } else if (DimensionBaseConstants.DEF_SCENARIO_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgScenario())) {
                    member = memberMap.get(mbgData.getBgScenario());
                }
                if (member != null) {
                    number = member.getNumber();
                    pNumber = null;
                    alias = member.getName();
                } else if (parameter.getDataManager().getDefScenario() != null) {
                    number = mbgData.getBgScenario();
                    pNumber = null;
                    name = parameter.getDataManager().getDefScenario()[1];
                    alias = name != null ? name : ((IObjectValue)scenarioCache.get(number)).get("name", ctx.getLocale()).toString();
                }
            } else if (DimensionBaseConstants.DEF_VERSION_NUMBER.equals(mbgDim.getNumber())) {
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (memberMap != null && memberMap.containsKey(mbgData.getBgVersion())) {
                    member = memberMap.get(mbgData.getBgVersion());
                }
                if (member != null) {
                    number = mbgData.getBgVersion();
                    pNumber = null;
                    alias = member.getName();
                } else if (parameter.getDataManager().getDefVersion() != null) {
                    number = mbgData.getBgVersion();
                    pNumber = null;
                    name = parameter.getDataManager().getDefVersion()[1];
                    alias = name != null ? name : ((IObjectValue)versionCache.get(number)).get("name", ctx.getLocale()).toString();
                }
            } else if (DimensionBaseConstants.DEF_PROCESSTYPE_NUMBER.equals(mbgDim.getNumber())) {
                number = processType;
                pNumber = null;
                alias = BgProcessEnum.getEnum(processType).getAlias();
            } else {
                number = ((String)fieldMap.get(mbgDim.getRefField())).split(":")[1];
                memberMap = queryMemberMap.get(mbgDim.getRefField());
                if (number != null && memberMap != null && memberMap.containsKey(number)) {
                    member = memberMap.get(number);
                }
                if (member != null) {
                    pNumber = this.getParentNumber((String)((Object)member.getSortValue()));
                    number = member.getCombNumber();
                    pNumber = pNumber == null ? null : member.getSrcNumber() + ":" + this.getParentNumber((String)((Object)member.getSortValue()));
                    alias = member.getName();
                }
            }
            this.addMemberData(number, pNumber, alias, values);
        }
        List fieldNames = metaInfo.getFieldNames();
        int in = fieldNames.size() - 1;
        for (int i = 1; i < in; ++i) {
            String fieldName = (String)fieldNames.get(i);
            if (this.verifyIsExists(parameter.getDataManager().getBgScheme().getExtDimNums(), fieldName)) continue;
            if ("NUM".equals(fieldName.substring(fieldName.lastIndexOf("_") + 1))) {
                values.add(i, "NONE");
            } else {
                values.add(i, null);
            }
            if (propMembers == null || propMembers.isEmpty()) continue;
            if (fieldName.startsWith("ORG_PROPERTYSORT_") && propMembers.containsKey("33F82845")) {
                this.setPropValuesToQing(propMembers, "33F82845", fieldName, bgOrgUnitInfo.getNumber(), values, i);
                continue;
            }
            if (fieldName.startsWith("ACC_PROPERTYSORT_") && propMembers.containsKey("E68E9293")) {
                String accNumber = (String)fieldMap.get(DimensionBaseConstants.DEF_BGINDEX_FIELD);
                this.setPropValuesToQing(propMembers, "E68E9293", fieldName, accNumber.substring(accNumber.indexOf(":") + 1), values, i);
                continue;
            }
            if (!fieldName.startsWith("MBGDIM_PROPERTYSORT_") || !propMembers.containsKey("D177852B")) continue;
            for (MbgDimInfo mbgDim : mbgDims) {
                if (DimensionBaseConstants.necessary.contains(mbgDim.getNumber())) continue;
                this.setPropValuesToQing(propMembers, "D177852B", fieldName, (String)fieldMap.get(mbgDim.getRefField()), values, i);
            }
        }
        BigDecimal value = BigDecimal.ZERO;
        if (mbgData.getBudgetValueNoDef() != null) {
            value = mbgData.getBudgetValueNoDef();
        } else if (mbgData.getBizActualNoDef() != null) {
            value = mbgData.getBizActualNoDef();
        }
        values.add(value.setScale(6, 4));
        return values.toArray();
    }

    public void setPropValuesToQing(Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers, String bosType, String fieldName, String memberNumber, List<Object> values, int i) {
        Map<String, Map<String, BgPropertyInfo>> stringMapMap = propMembers.get(bosType);
        if (stringMapMap.containsKey(memberNumber)) {
            Map<String, BgPropertyInfo> propertyInfoMap = stringMapMap.get(memberNumber);
            for (Map.Entry<String, BgPropertyInfo> entry : propertyInfoMap.entrySet()) {
                String sortNum = entry.getKey();
                if (MbgQingAnalyseIntegUtils.getPropFieldKey(bosType, sortNum, "NUM").equals(fieldName)) {
                    values.set(i, entry.getValue().getNumber());
                    continue;
                }
                if (MbgQingAnalyseIntegUtils.getPropFieldKey(bosType, sortNum, "PNUM").equals(fieldName)) {
                    BgPropertyInfo parent = entry.getValue().getParent();
                    if (parent == null) continue;
                    values.set(i, parent.getNumber());
                    continue;
                }
                if (!MbgQingAnalyseIntegUtils.getPropFieldKey(bosType, sortNum, "ALIAS").equals(fieldName)) continue;
                values.set(i, entry.getValue().getName());
            }
        }
    }

    protected void addMemberData(String number, String alias, List<Object> values) {
        this.addMemberData(number, null, alias, values);
    }

    protected void addMemberData(String number, String pNumber, String alias, List<Object> values) {
        values.add(number);
        values.add(pNumber);
        values.add(alias);
    }

    protected void addNullData(List<Object> values) {
        this.addMemberData(null, null, null, values);
    }

    private String getParentNumber(String longNumber) {
        if (longNumber == null) {
            return null;
        }
        String[] tmpNums = longNumber.split("!");
        if (tmpNums != null && tmpNums.length > 1) {
            return tmpNums[tmpNums.length - 2];
        }
        return null;
    }

    @Override
    protected void _loadQingAnalyseData(Context ctx, Connection conn, String bgSchemeId, String orgUnitId, String tempQsId) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("Insert Into T_MBG_MbgQingAnalyseInteg (FBgSchemeId, FOrgUnitId, FQsId, FCount) Select ?, ?, ?, 0 where ").append("not exists (select * from T_MBG_MbgQingAnalyseInteg where FBgSchemeId = ? and FOrgUnitId = ? ");
        sql.append(" )");
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId, orgUnitId, tempQsId, bgSchemeId, orgUnitId});
        }
        catch (Exception e) {
            logger.error((Object)"save qingAnalyse Data error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _clearQingAnalyseData(Context ctx, Connection conn, BOSUuid bgSchemeId, BOSUuid orgUnitId) throws BOSException, EASBizException {
        if (ctx == null || bgSchemeId == null || orgUnitId == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("delete from T_MBG_MbgQingAnalyseInteg  where FBgSchemeId = ? and FOrgUnitId = ? ");
        try {
            BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{bgSchemeId.toString(), orgUnitId.toString()});
        }
        catch (SQLException ex) {
            logger.error((Object)"clearQingAnalyseData error : ", (Throwable)ex);
            throw new BgException(BgException.DATABASEERROR, (Object[])new String[]{ex.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void _saveSingleOrgData(Context ctx, MbgQingDataParam param, Map bgDataMap) throws BOSException, EASBizException {
        BudgetDataSourceVisitor visitor = null;
        BudgetDataSourceWriter writer = null;
        IDimensionParameter parameter = param.getDimenisonParameter();
        BgOrgUnitInfo bgOrgUnitInfo = param.getBgOrgUnitInfo();
        HashSet<String> nullKeys = new HashSet<String>(param.getNullKeys());
        BgPropertySortCollection sorts = param.getSorts();
        Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers = param.getPropMembers();
        String bgSchemeId = parameter.getBgSchemeId().toString();
        String tempQsId = Uuid.create().toString();
        String orgUnitId = bgOrgUnitInfo.getOrgUnitID();
        Map<String, Map<String, BgDimensionMember>> queryMemberMap = param.getQueryMemberMap();
        Connection conn = null;
        String qsId = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            List<MbgDimInfo> mbgDims = null;
            Map rowMap = null;
            List<Object> rows = new ArrayList();
            Object[] row = null;
            mbgDims = MbgQingAnalyseIntegUtils.getSchemeMbgDim(parameter.getDataManager().getDimensions(), parameter.getDataManager().getBgScheme());
            MbgQingAnalyseIntegUtils.addBgProcessType(ctx, mbgDims);
            if (mbgDims == null || mbgDims.isEmpty()) {
                return;
            }
            MetaInfo metaInfo = this.getMeta(ctx, mbgDims, sorts);
            long time = System.currentTimeMillis();
            qsId = this.lockQingAnalyseFile(ctx, conn, bgSchemeId, orgUnitId);
            logger.info((Object)("get qingAnalyse Lock time: " + (System.currentTimeMillis() - time) + "ms."));
            logger.debug((Object)"begin write newData!");
            logger.info((Object)("create tempQsId :" + tempQsId));
            writer = BudgetFacade.createDataSourceWriter((String)tempQsId, (Context)ctx);
            writer.start(metaInfo);
            rows = this.mergerData(ctx, mbgDims, metaInfo, bgDataMap, parameter, bgOrgUnitInfo, nullKeys, propMembers, queryMemberMap);
            for (Object[] objectArray : rows) {
                writer.writeData(objectArray);
            }
            logger.info((Object)("end write newData! use = " + (System.currentTimeMillis() - time) + "ms."));
            logger.info((Object)("write newData! size = " + rows.size()));
            int n = rows.size();
            for (int i = 0; i < n; ++i) {
                row = (Object[])rows.get(i);
                nullKeys.add((String)row[0]);
            }
            rows.clear();
            logger.debug((Object)"begin load file !");
            visitor = BudgetFacade.createDataSourceVisitor((String)qsId, (Context)ctx);
            logger.info((Object)("begin write oldData ! use = " + (System.currentTimeMillis() - time) + "ms."));
            if (visitor != null && visitor.getMetaInfo() != null) {
                List list;
                boolean lessProcessType = false;
                if (visitor.getMetaInfo() != null && visitor.getMetaInfo().getSize() != metaInfo.getSize() && (list = visitor.getMetaInfo().getFieldNames()) != null && !list.contains(DimensionBaseConstants.DEF_PROCESSTYPE_NUMBER + "_" + "NUM")) {
                    if (visitor.getMetaInfo().getSize() + 3 != metaInfo.getSize()) {
                        logger.error((Object)"oldMetaInfo data error !!!!");
                        return;
                    }
                    lessProcessType = true;
                }
                List list2 = visitor.getMetaInfo().getFieldNames();
                while (visitor.getDataIteratorHasNextRow()) {
                    rowMap = visitor.getDataIteratorNextRow();
                    if (lessProcessType) {
                        ArrayList<Object> rowData = new ArrayList<Object>();
                        int in2 = list2.size();
                        for (int i = 0; i < in2; ++i) {
                            rowData.add(rowMap.get(visitor.getMetaInfo().getFieldName(i)));
                        }
                        rowData.add(rowData.size() - 1, BgProcessEnum.C01.getName());
                        rowData.add(rowData.size() - 1, null);
                        rowData.add(rowData.size() - 1, BgProcessEnum.C01.getAlias());
                        row = rowData.toArray();
                    } else {
                        row = new Object[list2.size()];
                        int in3 = list2.size();
                        for (int i = 0; i < in3; ++i) {
                            row[i] = rowMap.get(visitor.getMetaInfo().getFieldName(i));
                        }
                    }
                    if (nullKeys.contains(row[0])) continue;
                    writer.writeData(row);
                }
                logger.info((Object)("end write oldData ! use = " + (System.currentTimeMillis() - time) + "ms."));
            }
        }
        catch (Exception ex) {
            logger.error((Object)"save qingAnalyse Data error:", (Throwable)ex);
            throw new BOSException((Throwable)ex);
        }
        finally {
            if (writer != null) {
                writer.close(null);
            }
            if (visitor != null) {
                visitor.close();
            }
            SQLUtils.cleanup((Connection)conn);
        }
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            this.updateDBQsId(ctx, conn, bgSchemeId, tempQsId, orgUnitId, qsId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void updateDBQsId(Context ctx, Connection conn, String bgSchemeId, String tempQsId, String orgUnitId, String qsId) throws BOSException {
        logger.info((Object)("begin to execute method updateDBQsId, qsId : " + qsId + " ,tempQsId :" + tempQsId + " ,orgUnitId :" + orgUnitId));
        try {
            if (BudgetFacade.getQsFileStatus((String)tempQsId, (Context)ctx)) {
                if (!tempQsId.equals(qsId)) {
                    StringBuilder sql = new StringBuilder();
                    sql.append("update T_MBG_MbgQingAnalyseInteg set FQsId = ? where FBgSchemeId = ? and FOrgUnitId = ? ");
                    BgDBUtils.executeUpdate((Connection)conn, (String)sql.toString(), (Object[])new Object[]{tempQsId, bgSchemeId, orgUnitId});
                    if (!"000000000000000000000000000=".equals(qsId)) {
                        this.deleteFile(ctx, qsId);
                        logger.info((Object)("delete qing file success ! file name: " + qsId));
                    }
                }
            } else if ("000000000000000000000000000=".equals(qsId)) {
                this._clearQingAnalyseData(ctx, conn, BOSUuid.read((String)bgSchemeId), BOSUuid.read((String)orgUnitId));
            } else {
                this.deleteFile(ctx, tempQsId);
            }
        }
        catch (Exception e) {
            logger.error((Object)"delete qingData file error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            this.clearAnalyseFileOfDB(ctx);
        }
    }

    private void deleteFile(Context ctx, String qsId) throws BOSException {
        try {
            BudgetFacade.deleteFile((String)qsId, (Context)ctx);
        }
        catch (BOSException e) {
            logger.error((Object)("delete qing file failed!!!!!!!!!,fileName:" + qsId), (Throwable)e);
            this.insertAnalyseFileToDB(ctx, qsId);
        }
        logger.info((Object)("delete qing file success ! file name: " + qsId));
    }

    private void clearAnalyseFileOfDB(Context ctx) throws BOSException {
        logger.info((Object)"begin to clearAnalyseFileOfDB.");
        long time = System.currentTimeMillis();
        this.createAnalyseFileTable(ctx);
        String sql = "select FREMOVEQSID from T_MBG_MbgQingAnalyseRemoveFile";
        IRowSet rst = null;
        HashSet<String> success = new HashSet<String>();
        try {
            rst = BgDBUtils.executeQuery((Context)ctx, (String)sql);
            while (rst.next()) {
                String removeQsId = rst.getString("FREMOVEQSID");
                try {
                    BudgetFacade.deleteFile((String)removeQsId, (Context)ctx);
                    success.add(removeQsId);
                }
                catch (BOSException e) {
                    logger.error((Object)"", (Throwable)e);
                }
            }
            if (success.isEmpty()) {
                return;
            }
            ArrayList<Object[]> params = new ArrayList<Object[]>(success.size());
            for (String qsId : success) {
                params.add(new Object[]{qsId});
            }
            BgDBUtils.executeBatch((Context)ctx, (String)"delete from T_MBG_MbgQingAnalyseRemoveFile where FREMOVEQSID = ?", params);
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rst);
        }
        logger.info((Object)("end to clearAnalyseFileOfDB,cost time :" + (System.currentTimeMillis() - time) + ".ms"));
    }

    private void insertAnalyseFileToDB(Context ctx, String qsId) throws BOSException {
        String sql = "insert into T_MBG_MbgQingAnalyseRemoveFile(FREMOVEQSID) select ? where not exists (select * from T_MBG_MbgQingAnalyseRemoveFile where FREMOVEQSID = ? )";
        try {
            BgDBUtils.executeUpdate((Context)ctx, (String)sql, (Object[])new Object[]{qsId, qsId});
        }
        catch (Exception e) {
            logger.debug((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void createAnalyseFileTable(Context ctx) throws BOSException {
        if (ctx == null) {
            return;
        }
        int re = BgDBUtils.existTable((Context)ctx, (String)"T_MBG_MbgQingAnalyseRemoveFile");
        StringBuilder sql = new StringBuilder();
        if (re == BgDBUtils.NO) {
            sql.append("Create Table T_MBG_MbgQingAnalyseRemoveFile (FREMOVEQSID VARCHAR(44) DEFAULT '' NOT NULL,CONSTRAINT PK_QingAnalyseRemoveFile PRIMARY KEY (FREMOVEQSID))");
            try {
                BgDBUtils.executeUpdate((Context)ctx, (String)sql.toString());
            }
            catch (SQLException e) {
                logger.debug((Object)" create MbgQingAnalyseRemoveFile Table error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private String lockQingAnalyseFile(Context ctx, Connection conn, String bgSchemeId, String orgUnitId) throws BOSException {
        IRowSet rst = null;
        String qsId = null;
        try {
            MbgQingAnalyseIntegrateFactory.getLocalInstance(ctx).loadQingAnalyseData(conn, bgSchemeId, orgUnitId, "000000000000000000000000000=");
            MbgQingAnalyseIntegrateFactory.getLocalInstance(ctx).lockQingAnalyse(conn, BOSUuid.read((String)bgSchemeId), BOSUuid.read((String)orgUnitId));
            StringBuilder sql = new StringBuilder();
            sql.append("select FQsId from T_MBG_MbgQingAnalyseInteg where FBgSchemeId = ? and FOrgUnitId = ? ");
            rst = BgDBUtils.executeQuery((Connection)conn, (String)sql.toString(), (Object[])new String[]{bgSchemeId, orgUnitId});
            if (rst.next()) {
                qsId = rst.getString(1);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"save qingAnalyse Data error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rst);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rst);
        return qsId;
    }

    private void concatSql(String dimNum, StringBuilder sql) {
        if (dimNum == null) {
            sql.append(" and FDimNumber is null");
        } else {
            sql.append(" and FDimNumber = '" + dimNum + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List _splitQingAnalyseFile(Context ctx, String bgSchemeId, String targetDimNumber) throws BOSException, EASBizException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        logger.debug((Object)("begin split QingAnalyseFile! time:" + format.format(System.currentTimeMillis())));
        Connection conn = null;
        MbgQingAnalyseFileInfo qingFileInfo = null;
        ArrayList<MbgQingAnalyseFileInfo> list = new ArrayList<MbgQingAnalyseFileInfo>();
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            String sql = "select FOrgUnitId,FQsId,FDimNumber from T_Mbg_MbgQingAnalyseinteg where FbgSchemeId = ?";
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeId});
            while (rs.next()) {
                if ("000000000000000000000000000=".equals(rs.getString(2))) continue;
                qingFileInfo = new MbgQingAnalyseFileInfo();
                qingFileInfo.setBgSchemeId(bgSchemeId);
                qingFileInfo.setOrgUnitId(rs.getString(1));
                qingFileInfo.setQsId(rs.getString(2));
                qingFileInfo.setDimNumber(rs.getString(3));
                list.add(qingFileInfo);
            }
            logger.debug((Object)("end split QingAnalyseFile! time :" + format.format(System.currentTimeMillis())));
        }
        catch (SQLException e) {
            logger.error((Object)"split QingAnalyseFile error: ", (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        return list;
    }

    @Override
    protected Object _splitSingleQingAnalyseFile(Context ctx, String bgSchemeId, String orgUnitId, String qsId, String targetDimNumber, String sourceDimNumber) throws BOSException, EASBizException {
        return null;
    }

    private Map<MbgQingAnalyseConvertMsgObj, String> createReport(String orgUnitId, String dimNumber, String updateStatus) {
        HashMap<MbgQingAnalyseConvertMsgObj, String> map = new HashMap<MbgQingAnalyseConvertMsgObj, String>();
        MbgQingAnalyseConvertMsgObj msg = null;
        msg = new MbgQingAnalyseConvertMsgObj("orgUnitId", EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"orgUnitId"), 1);
        map.put(msg, orgUnitId == null ? "" : orgUnitId);
        msg = new MbgQingAnalyseConvertMsgObj("dimNumber", EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"dimNumber"), 2);
        map.put(msg, dimNumber == null ? "" : dimNumber);
        msg = new MbgQingAnalyseConvertMsgObj("orgUnitId", EASResource.getString((String)"com.kingdee.eas.ma.mbg.MbgQingAnalyseResource", (String)"convertStatus"), 3);
        map.put(msg, updateStatus);
        return map;
    }

    @Override
    protected void _updateOrgProp(Context ctx, Map waitUpdateData, String orgViewId) throws BOSException, EASBizException {
        if (waitUpdateData == null || orgViewId == null) {
            return;
        }
        logger.info((Object)("begin to execute method updateOrgProp,orgViewId: " + orgViewId + ", time : " + this.format.format(System.currentTimeMillis())));
        Set bgOrgUnitIds = waitUpdateData.keySet();
        TempTablePool pool = null;
        Connection conn = null;
        String tempTable = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMP_KSQL_0(FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("insert into " + tempTable + " (FID) values(?)"), bgOrgUnitIds);
            Map<String, Set<String>> orgPropSort = this.orgPropSort(waitUpdateData);
            Set<String> schemeIds = MbgQingAnalyseHelper.getObjectIds(BgOrgMigrationUtils.getBgSchemesByViewId(ctx, orgViewId, DimensionBaseConstants.DEF_ORGUNIT_NUMBER));
            Map<String, Set<String>> orgPropByScheme = this.getMemberPropByScheme(ctx, schemeIds, "33F82845");
            Map<String, Map<String, String>> qsFiles = this.getQsFile(ctx, schemeIds, tempTable);
            this.dealOrgProp4QsFile(ctx, conn, orgPropSort, orgPropByScheme, qsFiles, waitUpdateData);
        }
        catch (Exception e) {
            try {
                logger.error((Object)"updateOrgProp error : ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                BgDBUtils.releaseTmpTable(pool, tempTable);
                SQLUtils.cleanup((Connection)conn);
                throw throwable;
            }
        }
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempTable);
        SQLUtils.cleanup((Connection)conn);
        logger.info((Object)("end updateOrgProp,time : " + this.format.format(System.currentTimeMillis())));
    }

    @Override
    protected void _updateMbgMemberProp(Context ctx, Map updateData, String viewId, String dimNumber) throws BOSException, EASBizException {
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            Map<String, Set<String>> memberPropSorts = this.orgPropSort(updateData);
            Set<String> schemeIds = MbgQingAnalyseHelper.getObjectIds(BgOrgMigrationUtils.getBgSchemesByViewId(ctx, viewId, dimNumber));
            Map<String, Set<String>> memberPropByScheme = null;
            Map<String, Map<String, String>> qingPropData = null;
            if (DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber)) {
                memberPropByScheme = this.getMemberPropByScheme(ctx, schemeIds, "E68E9293");
                qingPropData = this.getQingFieldKeyByUpdateData(ctx, updateData, "ACC_PROPERTYSORT_");
            } else {
                memberPropByScheme = this.getMemberPropByScheme(ctx, schemeIds, "D177852B");
                qingPropData = this.getQingFieldKeyByUpdateData(ctx, updateData, "MBGDIM_PROPERTYSORT_");
            }
            Map<String, Map<String, String>> qsFiles = this.getQsFile(ctx, schemeIds);
            this.exec(ctx, conn, memberPropSorts, memberPropByScheme, qingPropData, qsFiles, dimNumber);
        }
        catch (SQLException var) {
            logger.error((Object)"", (Throwable)var);
            throw new BOSException((Throwable)var);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void exec(Context ctx, Connection conn, Map<String, Set<String>> memberPropSorts, Map<String, Set<String>> memberPropByScheme, Map<String, Map<String, String>> qingPropData, Map<String, Map<String, String>> qsFiles, String dimNumber) throws BOSException {
        MbgQingStoreUtils store = MbgQingStoreUtils.getInstance(conn);
        for (Map.Entry<String, Set<String>> memberPropSortEty : memberPropSorts.entrySet()) {
            String memberKey = memberPropSortEty.getKey();
            Set<String> oSorts = memberPropSortEty.getValue();
            HashSet<String> copySorts = new HashSet<String>(oSorts);
            for (Map.Entry<String, Set<String>> schemePropSortEty : memberPropByScheme.entrySet()) {
                String bgSchemeId = schemePropSortEty.getKey();
                Set<String> sSorts = schemePropSortEty.getValue();
                copySorts.retainAll(sSorts);
                if (!qsFiles.containsKey(bgSchemeId)) continue;
                if (!copySorts.isEmpty()) {
                    this.updateMemberPropDataToQingFile(ctx, conn, qingPropData, qsFiles, dimNumber, memberKey, bgSchemeId, store);
                    continue;
                }
                if (sSorts.isEmpty() || !oSorts.isEmpty()) continue;
                this.updateMemberPropDataToQingFile(ctx, conn, qingPropData, qsFiles, dimNumber, memberKey, bgSchemeId, store);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMemberPropDataToQingFile(Context ctx, Connection conn, Map<String, Map<String, String>> qingPropData, Map<String, Map<String, String>> qsFiles, String dimNumber, String memberKey, String bgSchemeId, MbgQingStoreUtils store) throws BOSException {
        Map<String, String> org_files = qsFiles.get(bgSchemeId);
        for (Map.Entry<String, String> fileEntry : org_files.entrySet()) {
            String orgUnitId = fileEntry.getKey();
            Map<String, Map<String, IBgNData>> map = store.getPool((String)store.getPoolKey((Context)ctx, (String)bgSchemeId, (String)orgUnitId)).bufferBgDataMap;
            synchronized (map) {
                this.updateMemberPropDataToQsFile(ctx, conn, org_files.get(orgUnitId), bgSchemeId, orgUnitId, qingPropData.get(memberKey), memberKey, dimNumber);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dealOrgProp4QsFile(Context ctx, Connection conn, Map<String, Set<String>> orgPropSort, Map<String, Set<String>> orgPropByScheme, Map<String, Map<String, String>> qsFiles, Map<String, BgPropertyCollection> waitUpdateData) throws BOSException {
        MbgQingStoreUtils store = MbgQingStoreUtils.getInstance(conn);
        Map<String, Map<String, String>> qingPropData = this.getQingFieldKeyByUpdateData(ctx, waitUpdateData, "ORG_PROPERTYSORT_");
        for (Map.Entry<String, Set<String>> oEntry : orgPropSort.entrySet()) {
            String orgUnitId = oEntry.getKey();
            Set<String> oSorts = oEntry.getValue();
            HashSet<String> copySorts = new HashSet<String>(oSorts);
            for (Map.Entry<String, Set<String>> sEntry : orgPropByScheme.entrySet()) {
                Map<String, Map<String, IBgNData>> map;
                String bgSchemeId = sEntry.getKey();
                Set<String> sSorts = sEntry.getValue();
                copySorts.retainAll(sSorts);
                if (!copySorts.isEmpty()) {
                    if (!qsFiles.containsKey(bgSchemeId) || !qsFiles.get(bgSchemeId).containsKey(orgUnitId)) continue;
                    map = store.getPool((String)store.getPoolKey((Context)ctx, (String)bgSchemeId, (String)orgUnitId)).bufferBgDataMap;
                    synchronized (map) {
                        this.convertQsFile(ctx, conn, qsFiles.get(bgSchemeId).get(orgUnitId), bgSchemeId, orgUnitId, qingPropData.get(orgUnitId));
                        continue;
                    }
                }
                if (sSorts.isEmpty() || !oSorts.isEmpty() || !qsFiles.containsKey(bgSchemeId) || !qsFiles.get(bgSchemeId).containsKey(orgUnitId)) continue;
                map = store.getPool((String)store.getPoolKey((Context)ctx, (String)bgSchemeId, (String)orgUnitId)).bufferBgDataMap;
                synchronized (map) {
                    this.convertQsFile(ctx, conn, qsFiles.get(bgSchemeId).get(orgUnitId), bgSchemeId, orgUnitId, qingPropData.get(orgUnitId));
                }
            }
        }
    }

    public Map<String, Map<String, String>> getQingFieldKeyByUpdateData(Context ctx, Map<String, BgPropertyCollection> waitUpdateData, String propFieldKey) {
        HashMap<String, Map<String, String>> qingPropData = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, BgPropertyCollection> entry : waitUpdateData.entrySet()) {
            String memberKey = entry.getKey();
            BgPropertyCollection data = entry.getValue();
            HashMap qd = new HashMap();
            if (data == null || data.isEmpty()) {
                qingPropData.put(memberKey, qd);
                continue;
            }
            for (BgPropertyInfo info : data) {
                String key = propFieldKey + info.getBgPropertySort().getNumber() + "_";
                if (!qingPropData.containsKey(memberKey)) {
                    qingPropData.put(memberKey, qd);
                }
                ((Map)qingPropData.get(memberKey)).put(key + "NUM", info.getNumber());
                ((Map)qingPropData.get(memberKey)).put(key + "PNUM", info.getParent() != null ? info.getParent().getNumber() : null);
                ((Map)qingPropData.get(memberKey)).put(key + "ALIAS", info.getName(ctx.getLocale()));
            }
        }
        return qingPropData;
    }

    private void updateMemberPropDataToQsFile(Context ctx, Connection conn, String qsId, String bgSchemeId, String orgUnitId, Map<String, String> qingPropData, String memberKey, String dimNumber) throws BOSException {
        BudgetDataSourceVisitor visitor = null;
        BudgetDataSourceWriter writer = null;
        String tempQsId = Uuid.create().toString();
        String propFieldKey = DimensionBaseConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber) ? "ACC_PROPERTYSORT_" : "MBGDIM_PROPERTYSORT_";
        logger.info((Object)("begin to execute method convertQsFile, qsId:" + qsId + " ,tempQsId :" + tempQsId + ",bgShemeId: " + bgSchemeId + " ,orgUnitId:" + orgUnitId + " ,time :" + this.format.format(System.currentTimeMillis())));
        try {
            visitor = BudgetFacade.createDataSourceVisitor((String)qsId, (Context)ctx);
            writer = BudgetFacade.createDataSourceWriter((String)tempQsId, (Context)ctx);
            writer.start(visitor.getMetaInfo());
            String dimKey = dimNumber + "_" + "NUM";
            List fieldNames = visitor.getMetaInfo().getFieldNames();
            while (visitor.getDataIteratorHasNextRow()) {
                Map dataMap = visitor.getDataIteratorNextRow();
                boolean containMember = dataMap.containsKey(dimKey) && memberKey.equals(dataMap.get(dimKey));
                Object[] row = new Object[fieldNames.size()];
                int in = fieldNames.size();
                for (int i = 0; i < in; ++i) {
                    String fieldName = (String)fieldNames.get(i);
                    if (containMember) {
                        if (fieldName.contains(propFieldKey)) {
                            if (qingPropData != null && qingPropData.containsKey(fieldName)) {
                                row[i] = qingPropData.get(fieldName);
                                continue;
                            }
                            if ("NUM".equals(fieldName.substring(fieldName.lastIndexOf("_") + 1))) {
                                row[i] = "NONE";
                                continue;
                            }
                            row[i] = null;
                            continue;
                        }
                        row[i] = dataMap.get(fieldName);
                        continue;
                    }
                    row[i] = dataMap.get(fieldName);
                }
                writer.writeData(row);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"couvertQsFile error : ", (Throwable)e);
            throw e;
        }
        finally {
            if (visitor != null) {
                visitor.close();
            }
            if (writer != null) {
                writer.close(null);
            }
        }
        this.updateDBQsId(ctx, conn, bgSchemeId, tempQsId, orgUnitId, qsId);
        logger.info((Object)("end convertQsFile, time : " + this.format.format(System.currentTimeMillis())));
    }

    private void convertQsFile(Context ctx, Connection conn, String qsId, String bgSchemeId, String orgUnitId, Map<String, String> qingPropData) throws BOSException {
        BudgetDataSourceVisitor visitor = null;
        BudgetDataSourceWriter writer = null;
        String tempQsId = Uuid.create().toString();
        logger.info((Object)("begin to execute method convertQsFile, qsId:" + qsId + " ,tempQsId :" + tempQsId + ",bgShemeId: " + bgSchemeId + " ,orgUnitId:" + orgUnitId + " ,time :" + this.format.format(System.currentTimeMillis())));
        try {
            visitor = BudgetFacade.createDataSourceVisitor((String)qsId, (Context)ctx);
            writer = BudgetFacade.createDataSourceWriter((String)tempQsId, (Context)ctx);
            writer.start(visitor.getMetaInfo());
            List fieldNames = visitor.getMetaInfo().getFieldNames();
            while (visitor.getDataIteratorHasNextRow()) {
                Map dataMap = visitor.getDataIteratorNextRow();
                Object[] row = new Object[fieldNames.size()];
                int in = fieldNames.size();
                for (int i = 0; i < in; ++i) {
                    String fieldName = (String)fieldNames.get(i);
                    if (fieldName.contains("ORG_PROPERTYSORT_")) {
                        if (qingPropData != null && qingPropData.containsKey(fieldName)) {
                            row[i] = qingPropData.get(fieldName);
                            continue;
                        }
                        if ("NUM".equals(fieldName.substring(fieldName.lastIndexOf("_") + 1))) {
                            row[i] = "NONE";
                            continue;
                        }
                        row[i] = null;
                        continue;
                    }
                    row[i] = dataMap.get(fieldName);
                }
                writer.writeData(row);
            }
        }
        catch (BOSException e) {
            logger.error((Object)"couvertQsFile error : ", (Throwable)e);
            throw e;
        }
        finally {
            if (visitor != null) {
                visitor.close();
            }
            if (writer != null) {
                writer.close(null);
            }
        }
        this.updateDBQsId(ctx, conn, bgSchemeId, tempQsId, orgUnitId, qsId);
        logger.info((Object)("end convertQsFile, time : " + this.format.format(System.currentTimeMillis())));
    }

    private Map<String, Set<String>> orgPropSort(Map<String, BgPropertyCollection> waitUpdateData) {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (Map.Entry<String, BgPropertyCollection> entry : waitUpdateData.entrySet()) {
            String memberKey = entry.getKey();
            BgPropertyCollection propertyCol = entry.getValue();
            HashSet<String> sortIds = new HashSet<String>();
            if (propertyCol != null) {
                Iterator it = propertyCol.iterator();
                while (it.hasNext()) {
                    sortIds.add(((BgPropertyInfo)it.next()).getBgPropertySort().getId().toString());
                }
            }
            result.put(memberKey, sortIds);
        }
        return result;
    }

    private Map<String, Set<String>> getMemberPropByScheme(Context ctx, Set<String> schemeIds, String bosType) throws BOSException {
        logger.info((Object)("begin to execute method getOrgPropByScheme,time : " + this.format.format(System.currentTimeMillis())));
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        if (schemeIds == null || schemeIds.isEmpty()) {
            return result;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add(new SelectorItemInfo("bgScheme.id"));
        evi.getSelector().add(new SelectorItemInfo("bgPropertySort.id"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", schemeIds, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("bgPropertySort.sourceType", (Object)bosType, CompareType.EQUALS));
        evi.setFilter(filter);
        RefBgPropertySortCollection col = RefBgPropertySortFactory.getLocalInstance(ctx).getRefBgPropertySortCollection(evi);
        if (col != null && !col.isEmpty()) {
            Iterator it = col.iterator();
            while (it.hasNext()) {
                RefBgPropertySortInfo info = (RefBgPropertySortInfo)it.next();
                String bgSchemeId = info.getBgScheme().getId().toString();
                if (!result.containsKey(bgSchemeId)) {
                    HashSet sortIds = new HashSet();
                    result.put(bgSchemeId, sortIds);
                }
                if (info.getBgPropertySort() == null) continue;
                String sortId = info.getBgPropertySort().getId().toString();
                ((Set)result.get(bgSchemeId)).add(sortId);
            }
        }
        logger.error((Object)("end getOrgPropByScheme, time :" + this.format.format(System.currentTimeMillis())));
        return result;
    }

    private Map<String, Map<String, String>> getQsFile(Context ctx, Set<String> bgSchemes) throws BOSException {
        return this.getQsFile(ctx, bgSchemes, null);
    }

    private Map<String, Map<String, String>> getQsFile(Context ctx, Set<String> bgSchemes, String tempTable) throws BOSException {
        logger.info((Object)("begin to execute method getQsFile,bgSchemeIds size :" + bgSchemes.size() + " ,time : " + this.format.format(System.currentTimeMillis())));
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        StringBuilder sql = new StringBuilder();
        sql.append("select FOrgUnitId,FbgSchemeId ,FQsId from T_MBG_MbgQingAnalyseinteg where FbgSchemeId in ( ");
        for (String id : bgSchemes) {
            sql.append("'").append(id).append("'").append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(" )");
        if (null != tempTable) {
            sql.append(" and FOrgUnitId in (select FID from " + tempTable + ")");
        }
        try {
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                String bgSchemeId = rs.getString("FbgSchemeId");
                String orgUnitId = rs.getString("FOrgUnitId");
                String qsId = rs.getString("FQsId");
                if (!result.containsKey(bgSchemeId)) {
                    HashMap qsIds = new HashMap();
                    result.put(bgSchemeId, qsIds);
                }
                ((Map)result.get(bgSchemeId)).put(orgUnitId, qsId);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"getQsFile error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("end getQsFile,time :" + this.format.format(System.currentTimeMillis())));
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _updateMemberPropByScheme(Context ctx, Map memPropertySorts, String bgSchemeId) throws BOSException, EASBizException {
        if (bgSchemeId == null) {
            return;
        }
        logger.info((Object)("begin to execute Method updateOrgPropByScheme,bgScheme id :" + bgSchemeId + ",time : " + this.format.format(System.currentTimeMillis())));
        Connection conn = null;
        BgSchemeInfo bgSchemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(bgSchemeId));
        Set<String> extDimNums = bgSchemeInfo.getExtDimNums();
        BgPropertySortCollection bgPropertySorts = new BgPropertySortCollection(){

            public void sort(final String propertyName) {
                if (!StringUtils.isEmpty((String)propertyName) && this.list != null && this.list.size() > 1) {
                    boolean TYPE = false;
                    boolean NUMBER = true;
                    Collections.sort(this.list, new Comparator<IObjectValue>(){

                        @Override
                        public int compare(IObjectValue o1, IObjectValue o2) {
                            String[] split = propertyName.split("!");
                            String k1 = ((String)o1.get(split[0])).concat((String)o1.get(split[1]));
                            String k2 = ((String)o2.get(split[0])).concat((String)o2.get(split[1]));
                            if (k1 != null && k2 != null) {
                                return k1 instanceof Comparable ? k1.compareTo(k2) : 0;
                            }
                            if (k1 == null && k2 == null) {
                                return 0;
                            }
                            return k1 == null ? -1 : 1;
                        }
                    });
                }
            }
        };
        Map memberPropertySorts = memPropertySorts;
        Iterator iterator = memberPropertySorts.values().iterator();
        while (iterator.hasNext()) {
            bgPropertySorts.addCollection((BgPropertySortCollection)iterator.next());
        }
        bgPropertySorts.sort(MbgQingAnalyseIntegUtils.SORT_KEY);
        Map<String, Map<String, Map<String, BgPropertyInfo>>> refProps = this.queryPropertyMember(ctx, bgPropertySorts);
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            MbgQingStoreUtils store = MbgQingStoreUtils.getInstance(conn);
            IRowSet rs = BgDBUtils.executeQuery((Context)ctx, (String)("select FQsId,FOrgUnitId from T_Mbg_MbgQingAnalyseInteg where FbgSchemeId = '" + bgSchemeId + "'"));
            while (rs.next()) {
                String qsId = rs.getString("FQsId");
                String orgUnitId = rs.getString("FOrgUnitId");
                Map<String, Map<String, IBgNData>> map = store.getPool((String)store.getPoolKey((Context)ctx, (String)bgSchemeId, (String)orgUnitId)).bufferBgDataMap;
                synchronized (map) {
                    this.reConfigQsFile(ctx, qsId, bgSchemeId, orgUnitId, extDimNums, bgPropertySorts, refProps);
                }
            }
            logger.info((Object)("end convert qingData from bgSheme, time :" + this.format.format(System.currentTimeMillis())));
        }
        catch (SQLException e) {
            logger.error((Object)"updateOrgPropByScheme error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    public Map<String, Map<String, Map<String, BgPropertyInfo>>> queryPropertyMember(Context ctx, BgPropertySortCollection bgPropertySorts) throws BOSException {
        return this.queryPropertyMember(ctx, bgPropertySorts, null);
    }

    public Map<String, Map<String, Map<String, BgPropertyInfo>>> queryPropertyMember(Context ctx, BgPropertySortCollection bgPropertySorts, String sourceType) throws BOSException {
        logger.info((Object)("start queryPropertyMember, time : " + this.format.format(System.currentTimeMillis())));
        Connection conn = null;
        TempTablePool pool = null;
        String tempTable = null;
        HashMap<String, Map<String, Map<String, BgPropertyInfo>>> result = new HashMap<String, Map<String, Map<String, BgPropertyInfo>>>();
        if (bgPropertySorts == null || bgPropertySorts.isEmpty()) {
            return result;
        }
        try {
            String dimType;
            conn = BgDBUtils.getConnection((Context)ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            HashSet<String> sortIds = new HashSet<String>(bgPropertySorts.size());
            Iterator it = bgPropertySorts.iterator();
            while (it.hasNext()) {
                sortIds.add(((BgPropertySortInfo)it.next()).getId().toString());
            }
            tempTable = BgDBUtils.createTmpTable((Context)ctx, (TempTablePool)pool, (String)"CREATE TABLE TEMP_KSQL_0(FID VARCHAR(44))");
            BgDBUtils.insertKey((Connection)conn, (String)("insert into " + tempTable + " (FID) values(?)"), sortIds);
            StringBuilder sql = new StringBuilder();
            sql.append(" select source.FSourceID, p.FID,p.FNumber,p.FName_" + ctx.getLocale() + ",parent.FID,parent.FNumber,sort.FNumber,sort.FSourceType    from  T_MBG_PropertyRefSource source  inner join T_MBG_BgProperty p on source.FPropertyID = p.FID  left join T_MBG_BgProperty parent on p.FparentID = parent.FID  inner join T_MBG_BgPropertySort sort on p.FbgPropertySortID = sort.FID where sort.FID in ( select FID from " + tempTable + " )");
            if (null != sourceType) {
                sql.append(" and sort.FSourceType = ?");
            }
            IRowSet rs = null == sourceType ? BgDBUtils.executeQuery((Context)ctx, (String)sql.toString()) : BgDBUtils.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{sourceType});
            while (rs.next()) {
                Map dimProp;
                dimType = rs.getString(8);
                if (!result.containsKey(dimType)) {
                    dimProp = new HashMap();
                    result.put(dimType, dimProp);
                }
                dimProp = (Map)result.get(dimType);
                String sourceId = rs.getString(1);
                String sortNumber = rs.getString(7);
                if (!dimProp.containsKey(sourceId)) {
                    HashMap refProp = new HashMap();
                    dimProp.put(sourceId, refProp);
                }
                BgPropertyInfo pInfo = new BgPropertyInfo();
                pInfo.setId(BOSUuid.read((String)rs.getString(2)));
                pInfo.setNumber(rs.getString(3));
                pInfo.setName(rs.getString(4));
                if (rs.getString(5) != null) {
                    BgPropertyInfo parent = new BgPropertyInfo();
                    parent.setId(BOSUuid.read((String)rs.getString(5)));
                    parent.setNumber(rs.getString(6));
                    pInfo.setParent(parent);
                }
                ((Map)dimProp.get(sourceId)).put(sortNumber, pInfo);
            }
            HashSet<String> orgIds = new HashSet<String>();
            HashSet<String> accIds = new HashSet<String>();
            HashSet<String> mbgDimIds = new HashSet<String>();
            for (Map.Entry entry : result.entrySet()) {
                dimType = (String)entry.getKey();
                if ("33F82845".equals(dimType)) {
                    orgIds.addAll(((Map)entry.getValue()).keySet());
                    continue;
                }
                if ("E68E9293".equals(dimType)) {
                    accIds.addAll(((Map)entry.getValue()).keySet());
                    continue;
                }
                mbgDimIds.addAll(((Map)entry.getValue()).keySet());
            }
            if (!orgIds.isEmpty()) {
                this.scanAndSwap(ctx, orgIds, "33F82845", result);
            }
            if (!accIds.isEmpty()) {
                this.scanAndSwap(ctx, accIds, "E68E9293", result);
            }
            if (!mbgDimIds.isEmpty()) {
                this.scanAndSwap4MbgDim(ctx, mbgDimIds, (Map)result.get("D177852B"));
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"queryOrgPropByScheme error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                pool.releaseTable(tempTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        pool.releaseTable(tempTable);
        logger.info((Object)("end queryPropertyMember, time : " + this.format.format(System.currentTimeMillis())));
        return result;
    }

    private void scanAndSwap4MbgDim(Context ctx, Set<String> baseIds, Map<String, Map<String, BgPropertyInfo>> result) throws BOSException {
        if (baseIds == null || baseIds.isEmpty() || result == null || result.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        view.getSelector().add("mbgDim.srcNumber");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", baseIds, CompareType.INCLUDE));
        view.setFilter(filter);
        MbgMemberCollection mbgMemberCol = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(view);
        int in = mbgMemberCol.size();
        for (int i = 0; i < in; ++i) {
            MbgMemberInfo mbgMemberInfo = mbgMemberCol.get(i);
            String number = mbgMemberInfo.getNumber();
            String srcNumber = mbgMemberInfo.getMbgDim().getSrcNumber();
            Map<String, BgPropertyInfo> tmpMap = result.get(mbgMemberInfo.getId().toString());
            result.put(number.concat(":").concat(srcNumber), new HashMap<String, BgPropertyInfo>(tmpMap));
            result.remove(mbgMemberInfo.getId().toString());
        }
    }

    private void scanAndSwap(Context ctx, Set<String> baseIds, String bosType, Map<String, Map<String, Map<String, BgPropertyInfo>>> result) throws BOSException {
        if (baseIds == null || baseIds.isEmpty()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add("id");
        view.getSelector().add("number");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", baseIds, CompareType.INCLUDE));
        view.setFilter(filter);
        IDataBase dataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)new BOSObjectType(bosType));
        DataBaseCollection col = dataBase.getDataBaseCollection(view);
        int in = col.size();
        for (int i = 0; i < in; ++i) {
            DataBaseInfo baseInfo = col.get(i);
            if (!result.containsKey(bosType)) continue;
            Map<String, Map<String, BgPropertyInfo>> stringMapMap = result.get(bosType);
            Map<String, BgPropertyInfo> tmpMap = stringMapMap.get(baseInfo.getId().toString());
            stringMapMap.put(baseInfo.getNumber(), new HashMap<String, BgPropertyInfo>(tmpMap));
            stringMapMap.remove(baseInfo.getId().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reConfigQsFile(Context ctx, String qsId, String bgSchemeId, String orgUnitId, Set<String> extDimNums, BgPropertySortCollection bgPropertySorts, Map<String, Map<String, Map<String, BgPropertyInfo>>> propMembers) throws BOSException {
        logger.info((Object)("begin to execute method: reConfigQsFile,qsId: " + qsId + " , orgUnitId: " + orgUnitId + ",time : " + this.format.format(System.currentTimeMillis())));
        BudgetDataSourceVisitor visitor = null;
        BudgetDataSourceWriter writer = null;
        String tempQsId = Uuid.create().toString();
        try {
            if ("000000000000000000000000000=".equals(qsId)) {
                return;
            }
            int dataSize = 0;
            visitor = BudgetFacade.createDataSourceVisitor((String)qsId, (Context)ctx);
            MetaInfo metaInfo = visitor.getMetaInfo();
            if (metaInfo == null) {
                return;
            }
            List fieldNames = metaInfo.getFieldNames();
            MetaInfo convertMetaInfo = this.convertMetaInfo(ctx, metaInfo, bgPropertySorts, extDimNums);
            writer = BudgetFacade.createDataSourceWriter((String)tempQsId, (Context)ctx);
            writer.start(convertMetaInfo);
            HashSet<String> loadPropDimNumber = new HashSet<String>(extDimNums);
            loadPropDimNumber.removeAll(DimensionBaseConstants.necessary);
            loadPropDimNumber.add(DimensionBaseConstants.DEF_ORGUNIT_NUMBER);
            loadPropDimNumber.add(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
            HashSet<String> loadKeys = new HashSet<String>(loadPropDimNumber.size());
            for (String dimNumber : loadPropDimNumber) {
                loadKeys.add(dimNumber + "_" + "NUM");
            }
            while (visitor.getDataIteratorHasNextRow()) {
                String fieldName;
                int index = 1;
                Map dataMap = visitor.getDataIteratorNextRow();
                Object[] row = new Object[convertMetaInfo.getFieldNames().size()];
                row[0] = dataMap.get("key");
                row[row.length - 1] = dataMap.get("value");
                HashMap<String, String> fieldMap = new HashMap<String, String>();
                int in = fieldNames.size() - 1;
                for (int i = 1; i < in; ++i) {
                    fieldName = (String)fieldNames.get(i);
                    if (!this.verifyIsExists(extDimNums, fieldName)) continue;
                    if (loadKeys.contains(fieldName)) {
                        fieldMap.put(fieldName.substring(0, fieldName.lastIndexOf("_")), (String)dataMap.get(fieldName));
                    }
                    row[i] = dataMap.get(fieldName);
                    ++index;
                }
                ++dataSize;
                List<Object> values = Arrays.asList(row);
                List cFieldNames = convertMetaInfo.getFieldNames();
                int in2 = cFieldNames.size() - 1;
                for (int i = index; i < in2; ++i) {
                    fieldName = (String)cFieldNames.get(i);
                    if ("NUM".equals(fieldName.substring(fieldName.lastIndexOf("_") + 1))) {
                        values.set(i, "NONE");
                    } else {
                        values.set(i, null);
                    }
                    if (propMembers == null || propMembers.isEmpty()) continue;
                    if (fieldName.startsWith("ORG_PROPERTYSORT_") && propMembers.containsKey("33F82845")) {
                        this.setPropValuesToQing(propMembers, "33F82845", fieldName, (String)fieldMap.get(DimensionBaseConstants.DEF_ORGUNIT_NUMBER), values, i);
                        continue;
                    }
                    if (fieldName.startsWith("ACC_PROPERTYSORT_") && propMembers.containsKey("E68E9293")) {
                        String accNumber = (String)fieldMap.get(DimensionBaseConstants.DEF_ACCOUNT_NUMBER);
                        if (accNumber == null) continue;
                        this.setPropValuesToQing(propMembers, "E68E9293", fieldName, accNumber.substring(accNumber.indexOf(":") + 1), values, i);
                        continue;
                    }
                    if (!fieldName.startsWith("MBGDIM_PROPERTYSORT_") || !propMembers.containsKey("D177852B")) continue;
                    for (String dimNumber : loadPropDimNumber) {
                        this.setPropValuesToQing(propMembers, "D177852B", fieldName, (String)fieldMap.get(dimNumber), values, i);
                    }
                }
                writer.writeData(values.toArray());
            }
            logger.info((Object)("qingFile data size : " + dataSize));
        }
        catch (Exception e) {
            logger.error((Object)"updateOrgPropByScheme error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            if (visitor != null) {
                visitor.close();
            }
            if (writer != null) {
                writer.close(null);
            }
        }
        Connection conn = null;
        try {
            conn = BgDBUtils.getConnection((Context)ctx);
            this.updateDBQsId(ctx, conn, bgSchemeId, tempQsId, orgUnitId, qsId);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
        logger.info((Object)("end reConfigQsFile, time : " + this.format.format(System.currentTimeMillis())));
    }

    private void batchUpdateDBQsId(Context ctx, Map<String, Object[]> params, Map<String, String> qsMaps) throws BOSException {
        logger.info((Object)("begin to batch Update QsId from DB,file size : " + params.size()));
        if (params.isEmpty()) {
            return;
        }
        long time = System.currentTimeMillis();
        for (String tempQsId : params.keySet()) {
            if (!BudgetFacade.getQsFileStatus((String)tempQsId, (Context)ctx)) {
                params.remove(tempQsId);
                logger.error((Object)("batch Update QsId from DB, QsId :" + tempQsId + " is invalid................"));
                continue;
            }
            String qsId = qsMaps.get(tempQsId);
            if (qsId.equals(tempQsId) || "000000000000000000000000000=".equals(qsId)) continue;
            BudgetFacade.deleteFile((String)qsId, (Context)ctx);
            logger.info((Object)("delete qing file success ! file name: " + qsId));
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update T_MBG_MbgQingAnalyseInteg set FQsId = ? where FBgSchemeId = ? and FOrgUnitId = ? ");
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)sql.toString(), new ArrayList<Object[]>(params.values()));
        }
        catch (SQLException e) {
            logger.error((Object)"batchUpdateDBQsId error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        logger.info((Object)("end to batch Update QsId from DB, valid file size :" + params.size() + " ,cost time :" + (System.currentTimeMillis() - time) / 1000L + ".ms"));
    }

    private MetaInfo convertMetaInfo(Context ctx, MetaInfo mInfo, BgPropertySortCollection sorts, Set<String> extDimNums) {
        int i;
        MetaInfo metaInfo = new MetaInfo();
        metaInfo.addField("key", "key", DataType.STRING, true);
        List fieldNames = mInfo.getFieldNames();
        List fieldDisplayNames = mInfo.getFieldDisplayNames();
        List fieldDataTypes = mInfo.getFieldDataTypes();
        List fieldIsHides = mInfo.getFieldIsHides();
        int in = fieldNames.size();
        for (i = 0; i < in; ++i) {
            if (!this.verifyIsExists(extDimNums, (String)fieldNames.get(i))) continue;
            metaInfo.addField((String)fieldNames.get(i), (String)fieldDisplayNames.get(i), (DataType)fieldDataTypes.get(i), ((Boolean)fieldIsHides.get(i)).booleanValue());
        }
        if (sorts != null) {
            logger.info((Object)("convert MetaInfo,propSorts size :" + sorts.size()));
            in = sorts.size();
            for (i = 0; i < in; ++i) {
                BgPropertySortInfo info = sorts.get(i);
                metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "NUM"), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING);
                metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "PNUM"), info.getName() + EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysenum", (Locale)ctx.getLocale()), DataType.STRING, true);
                metaInfo.addField(MbgQingAnalyseIntegUtils.getPropFieldKey(info.getSourceType(), info.getNumber(), "ALIAS"), info.getName(), DataType.STRING);
            }
        }
        metaInfo.addField("value", EASCommonResource.getString((String)"com.kingdee.eas.ma.mbg.DimensionCommonResource", (String)"analysevalue", (Locale)ctx.getLocale()), DataType.NUMBER);
        return metaInfo;
    }

    private boolean verifyIsExists(Set<String> extDimNums, String fieldName) {
        if ("key".equals(fieldName) || "value".equals(fieldName)) {
            return false;
        }
        if (DimensionBaseConstants.DEF_CSL_NUMBER.equals(fieldName = fieldName.substring(0, fieldName.lastIndexOf("_")))) {
            return false;
        }
        return DimUtils.checkBaseDimension(fieldName) || extDimNums.contains(fieldName) || DimensionConstants.DEF_INDEX_NUMBER.equals(fieldName);
    }

    @Override
    protected void _removeAnalyseDataByOrg(Context ctx, String bgSchemeId, Set orgUnitIds) throws BOSException, EASBizException {
        if (null == ctx || null == bgSchemeId || null == orgUnitIds || orgUnitIds.isEmpty()) {
            return;
        }
        TempTablePool pool = null;
        String tempTable = null;
        String qsId = null;
        Connection conn = null;
        IRowSet rs = null;
        try {
            conn = this.getConnection(ctx);
            pool = TempTablePool.getInstance((Context)ctx);
            tempTable = pool.createTempTable("CREATE TABLE T_TMP_KSQL1(FID VARCHAR(44))");
            BgDBUtils.insertKey1((Connection)conn, (String)("insert into " + tempTable + " values(?)"), (Collection)orgUnitIds);
            rs = BgDBUtils.executeQuery((Connection)conn, (String)("SELECT FQSID FROM T_MBG_MBGQINGANALYSEINTEG WHERE FBGSCHEMEID = ? AND FORGUNITID IN (SELECT FID FROM " + tempTable + ")"), (Object[])new Object[]{bgSchemeId});
            while (rs.next()) {
                qsId = rs.getString(1);
                this.deleteFile(ctx, qsId);
            }
            BgDBUtils.executeUpdate((Connection)conn, (String)("DELETE FROM T_MBG_MBGQINGANALYSEINTEG WHERE FBGSCHEMEID = ? AND FORGUNITID IN (SELECT FID FROM " + tempTable + ")"), (Object[])new Object[]{bgSchemeId});
        }
        catch (Exception e) {
            try {
                logger.error((Object)"removeAnalyseDataByOrg : ", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)conn);
                SQLUtils.cleanup(rs);
                pool.releaseTable(tempTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)conn);
        SQLUtils.cleanup((ResultSet)rs);
        pool.releaseTable(tempTable);
    }

    @Override
    protected void _createAnalyseDataByOrg(Context ctx, QingDataFilterParam param) throws BOSException, EASBizException {
        if (param == null || param.getBgScheme() == null || param.getBgOrgUnits() == null || param.getBgtemplateInfos() == null) {
            return;
        }
        Set<BgTemplateInfo> bgTemplateInfos = param.getBgtemplateInfos();
        BgOrgUnitInfo bgOrgUnitInfo = param.getBgOrgUnits()[0];
        BgSchemeInfo bgScheme = param.getBgScheme();
        BOSUuid bgOrgViewId = BgViewServerHelper.getBgViewIdBySchemeId(ctx, bgScheme.getId());
        BgFormCollection bgForms = this.getBgFormsByBgTemplate(ctx, bgScheme, bgOrgUnitInfo, bgTemplateInfos);
        IBgDimensionFacade iDimensionFacade = BgDimensionFacadeFactory.getLocalInstance(ctx);
        IMBGFormFacade imbgFormFacade = MBGFormFacadeFactory.getLocalInstance(ctx);
        IMBGViewListFormFacade imbgViewListFormFacade = MBGViewListFormFacadeFactory.getLocalInstance(ctx);
        int in = bgForms.size();
        for (int i = 0; i < in; ++i) {
            BgFormInfo bgFormInfo = bgForms.get(i);
            if (BgTemFormTypeEnum.VIEWLIST.equals((Object)bgFormInfo.getBgTemplate().getFormType())) {
                this.viewListFormProcess(ctx, bgOrgViewId, iDimensionFacade, imbgViewListFormFacade, bgFormInfo);
                continue;
            }
            this.mbgFormProcess(ctx, bgOrgViewId, iDimensionFacade, imbgFormFacade, bgFormInfo);
        }
    }

    private void mbgFormProcess(Context ctx, BOSUuid bgOrgViewId, IBgDimensionFacade dimensionFacade, IMBGFormFacade imbgFormFacade, BgFormInfo bgFormInfo) throws BOSException {
        BgFormEntryInfo obj;
        MbgXMLParser mbgXMLParser = new MbgXMLParser();
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            byte[] styleBytes = obj.getDimensionStyle();
            try {
                ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
                IMbgViewManager curMbgViewManager = mbgXMLParser.parse(dataBytes, styleBytes);
                imbgFormFacade.loadViewManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewManager, null, bgFormInfo.getOrgUnit().getId().toString(), false, false);
                List<IMbgSheetManager> sheetManagers = curMbgViewManager.getSheetManagers();
                for (IMbgSheetManager sheetManager : sheetManagers) {
                    dimensionManager.add(sheetManager.getDimensionManager());
                }
                IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
                dimParameter.setValueType(DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
                dimensionFacade.dimensionQuery(dimParameter);
            }
            catch (Exception var) {
                logger.error((Object)"mbgFormXML parse error :", (Throwable)var);
                throw new BOSException((Throwable)var);
            }
        }
    }

    private void viewListFormProcess(Context ctx, BOSUuid bgOrgViewId, IBgDimensionFacade dimensionFacade, IMBGViewListFormFacade imbgViewListFormFacade, BgFormInfo bgFormInfo) throws BOSException {
        BgFormEntryInfo obj;
        ArrayList<IBgDimensionManagerBase> dimensionManager = new ArrayList<IBgDimensionManagerBase>();
        MbgViewListXMLParser viewListXMLParser = new MbgViewListXMLParser();
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            byte[] dataBytes = obj.getDimensionData();
            try {
                MbgViewListManager curMbgViewListManager = viewListXMLParser.parse(dataBytes);
                imbgViewListFormFacade.loadViewListManager(bgFormInfo.getId().toString(), bgOrgViewId.toString(), curMbgViewListManager, null, null, false, false);
                List sheetManagers = curMbgViewListManager.getSheetManagers();
                for (MbgViewListSheetManager sheetManager : sheetManagers) {
                    dimensionManager.add(sheetManager.getDimensionManager());
                }
                IDimensionParameter dimParameter = DimUtils.transDimParameter(ctx, dimensionManager, bgFormInfo, bgOrgViewId);
                dimParameter.setValueType(DimensionCommonHelper.getDataType(bgFormInfo.getProcessType()));
                dimensionFacade.dimensionQuery(dimParameter);
            }
            catch (Exception var) {
                logger.error((Object)"viewlist XML parse error :", (Throwable)var);
                throw new BOSException((Throwable)var);
            }
        }
    }

    private BgFormCollection getBgFormsByBgTemplate(Context ctx, BgSchemeInfo bgScheme, BgOrgUnitInfo bgOrgUnitInfo, Set<BgTemplateInfo> bgTemplateInfos) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgScheme.getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)bgOrgUnitInfo.getOrgUnitID(), CompareType.EQUALS));
        if (!bgTemplateInfos.isEmpty()) {
            HashSet<String> templateIds = new HashSet<String>();
            for (BgTemplateInfo info : bgTemplateInfos) {
                templateIds.add(info.getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", templateIds, CompareType.INCLUDE));
        }
        view.setSelector(BgFormInfo.getFormSelector2());
        view.setFilter(filter);
        return BgFormFactory.getLocalInstance(ctx).getBgFormCollection(view);
    }

    private class SplitQingAnalyseFileThread
    implements Callable<Object> {
        private Context ctx = null;
        private String orgUnitId = null;
        private String qsId = null;
        private String bgSchemeId = null;
        private String targetDimNumber = null;
        private String sourceDimNumber = null;

        public SplitQingAnalyseFileThread(Context ctx, String orgUnitId, String qsId, String bgSchemeId, String targetDimNumber, String sourceDimNumber) {
            this.ctx = ctx;
            this.orgUnitId = orgUnitId;
            this.qsId = qsId;
            this.bgSchemeId = bgSchemeId;
            this.targetDimNumber = targetDimNumber;
            this.sourceDimNumber = sourceDimNumber;
        }

        @Override
        public Object call() throws Exception {
            MbgQingAnalyseIntegrateFactory.getLocalInstance(this.ctx).splitSingleQingAnalyseFile(this.bgSchemeId, this.orgUnitId, this.qsId, this.targetDimNumber, this.sourceDimNumber);
            return null;
        }
    }
}

