/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgCommHelper;
import com.kingdee.eas.ma.mbg.BgActualRecordInfo;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.IMbgViewListDesCell;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellEntryInfo;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellFactory;
import com.kingdee.eas.ma.mbg.MbgViewListDesCellInfo;
import com.kingdee.eas.ma.mbg.app.AbstractMbgViewListDesCellControllerBean;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.ma.mbg.utils.MbgViewListDescriptionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class MbgViewListDesCellControllerBean
extends AbstractMbgViewListDesCellControllerBean {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.MbgViewListDesCellControllerBean");
    private final String entryBosType = new MbgViewListDesCellEntryInfo().getBOSType().toString();
    private final String deleteEntrySql = "Delete From T_MBG_MbgViewListDesCellEntry Where FViewListDesId IN (Select Fid From T_MBG_MbgViewListDesCell Where FMemberNumber = ? AND FBgSchemeId = ? AND FBgTemplateId = ? and FOrgUnitId = ? And FVersionId = ? AND FBgPeriodId = ? and FCurrencyId = ?  And FSheetIndex = ? And FRowIndex = ? And FColIndex = ?)";

    private String getAddEntrySql(boolean isActual) {
        StringBuffer addEntrySql = new StringBuffer();
        addEntrySql.append("Insert into T_MBG_MbgViewListDesCellEntry(FID, FBgFormId, FViewListDesId) ").append("Select newbosid('" + this.entryBosType + "'), ?, viewlistCell.Fid From T_MBG_MbgViewListDesCell viewlistCell ").append("Where viewlistCell.FMemberNumber = ? AND viewlistCell.FBgSchemeId = ? and viewlistCell.FBgTemplateId = ? and viewlistCell.FOrgUnitId = ? ").append("and viewlistCell.FVersionId = ? AND viewlistCell.FBgPeriodId = ? and viewlistCell.FCurrencyId = ? and viewListCell.FSheetIndex = ? and viewlistCell.FRowIndex = ? and viewlistCell.FColIndex = ?  ").append("And not exists(Select de.fid From T_MBG_MbgViewListDesCellEntry de Where de.FBgFormId = ? and de.FViewListDesId = viewlistCell.FID) ");
        if (isActual) {
            addEntrySql.append(" and viewlistCell.FActualPeriodId = ?");
        } else {
            addEntrySql.append(" and viewlistCell.FActualPeriodId is null ");
        }
        return addEntrySql.toString();
    }

    @Override
    protected void _saveBatchColls(Context ctx, IObjectCollection desColls, IObjectValue objectValue) throws BOSException, EASBizException {
        String bgFormId = null;
        String actualPeriodId = null;
        if (objectValue instanceof BgFormInfo) {
            bgFormId = ((BgFormInfo)objectValue).getAdjust().getId().toString();
        } else if (objectValue instanceof BgActualRecordInfo) {
            bgFormId = ((BgActualRecordInfo)objectValue).getBgForm().getId().toString();
            actualPeriodId = ((BgActualRecordInfo)objectValue).getBgPeriod().getId().toString();
        } else if (objectValue instanceof BgTemplateInfo) {
            bgFormId = ((BgTemplateInfo)objectValue).getId().toString();
        } else if (objectValue instanceof CoreBaseInfo) {
            bgFormId = ((CoreBaseInfo)objectValue).getId().toString();
        }
        this._saveBatchColls(ctx, desColls, bgFormId, actualPeriodId);
    }

    @Override
    protected void _saveBatchColls(Context ctx, IObjectCollection desColls, String bgFormId, String actualPeriodId) throws BOSException, EASBizException {
        if (desColls == null || desColls.isEmpty()) {
            return;
        }
        BgFormCollection col = BgFormFactory.getLocalInstance(ctx).getBgFormCollection("select processType, bgScheme.id, bgTemplate.root.id, bgPeriod.id, currency.id, bgVersion.id where id = '" + bgFormId + "'");
        BgProcessEnum processType = BgProcessEnum.C01;
        if (col != null && !col.isEmpty()) {
            processType = col.get(0).getProcessType();
        }
        IMbgViewListDesCell iMbgViewListDesCell = MbgViewListDesCellFactory.getLocalInstance(ctx);
        CoreBaseCollection updateColls = new CoreBaseCollection();
        CoreBaseCollection deleteColls = new CoreBaseCollection();
        int size = desColls.size();
        for (int index = 0; index < size; ++index) {
            if (!(desColls.getObject(index) instanceof MbgViewListDesCellInfo)) continue;
            MbgViewListDesCellInfo info = (MbgViewListDesCellInfo)desColls.getObject(index);
            info.setProcessType(processType);
            if (StringUtils.isEmpty((String)info.getValue()) && info.getId() != null) {
                deleteColls.add((CoreBaseInfo)info);
                continue;
            }
            updateColls.add((CoreBaseInfo)info);
        }
        if (!updateColls.isEmpty()) {
            iMbgViewListDesCell.saveBatchData(updateColls);
            this.saveDesEntries(ctx, updateColls, col.get(0), bgFormId, actualPeriodId);
        }
        if (!deleteColls.isEmpty()) {
            ObjectUuidPK[] deleteArr = new ObjectUuidPK[deleteColls.size()];
            for (int index = 0; index < deleteColls.size(); ++index) {
                if (deleteColls.get(index).getId() == null) continue;
                deleteArr[index] = new ObjectUuidPK(deleteColls.get(index).getId());
            }
            if (deleteArr.length > 0) {
                this.deleteDesEntries(ctx, deleteColls);
                iMbgViewListDesCell.deleteBatchData((IObjectPK[])deleteArr);
            }
        }
    }

    private void saveDesEntries(Context ctx, CoreBaseCollection updateColls, BgFormInfo bgFormInfo, String bgFormId, String actualPeriodId) throws BOSException {
        if (updateColls == null || updateColls.isEmpty() || StringUtils.isEmpty((String)bgFormId)) {
            return;
        }
        boolean isActual = StringUtils.isEmpty((String)actualPeriodId) ? Boolean.FALSE : Boolean.TRUE;
        ArrayList<Object[]> addEntryParams = new ArrayList<Object[]>();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("orgUnit.id");
        sic.add("adjust.id");
        HashSet<String> orgUnitIds = new HashSet<String>();
        MbgViewListDesCellInfo info = null;
        int size = updateColls.size();
        for (int index = 0; index < size; ++index) {
            info = (MbgViewListDesCellInfo)updateColls.get(index);
            orgUnitIds.add(info.getOrgUnitId().toString());
        }
        BgFormCollection col = MbgViewListDescriptionHelper.getBgFormColls(ctx, bgFormInfo, orgUnitIds, sic, true);
        Map bgFormMap = BgCommHelper.transeToMap((IObjectCollection)col, (String[])new String[]{"orgUnit.id"});
        String _bgFormId = null;
        int size2 = updateColls.size();
        for (int index = 0; index < size2; ++index) {
            info = (MbgViewListDesCellInfo)updateColls.get(index);
            Object[] param = isActual ? new Object[13] : new Object[12];
            addEntryParams.add(param);
            if (bgFormInfo == null) {
                _bgFormId = bgFormId;
            } else {
                _bgFormId = bgFormInfo.getId().toString();
                if (bgFormMap.containsKey(info.getOrgUnitId().toString())) {
                    _bgFormId = ((BgFormInfo)bgFormMap.get(info.getOrgUnitId().toString())).getAdjust().getId().toString();
                }
            }
            param[0] = _bgFormId;
            param[1] = info.getMemberNumber();
            param[2] = info.getBgSchemeId().toString();
            param[3] = info.getBgTemplateId().toString();
            param[4] = info.getOrgUnitId().toString();
            param[5] = info.getVersionId().toString();
            param[6] = info.getBgPeriodId().toString();
            param[7] = info.getCurrencyId().toString();
            param[8] = info.getSheetIndex();
            param[9] = info.getRowIndex();
            param[10] = info.getColIndex();
            param[11] = _bgFormId;
            if (!isActual) continue;
            param[12] = actualPeriodId;
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)this.getAddEntrySql(isActual), addEntryParams);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    private void deleteDesEntries(Context ctx, CoreBaseCollection deleteColls) throws BOSException {
        if (deleteColls == null || deleteColls.isEmpty()) {
            return;
        }
        ArrayList<Object[]> deleteEntryParams = new ArrayList<Object[]>();
        MbgViewListDesCellInfo info = null;
        int size = deleteColls.size();
        for (int index = 0; index < size; ++index) {
            info = (MbgViewListDesCellInfo)deleteColls.get(index);
            Object[] param = new Object[10];
            deleteEntryParams.add(param);
            param[0] = info.getMemberNumber();
            param[1] = info.getBgSchemeId().toString();
            param[2] = info.getBgTemplateId().toString();
            param[3] = info.getOrgUnitId().toString();
            param[4] = info.getVersionId().toString();
            param[5] = info.getBgPeriodId().toString();
            param[6] = info.getCurrencyId().toString();
            param[7] = info.getSheetIndex();
            param[8] = info.getRowIndex();
            param[9] = info.getColIndex();
        }
        Connection conn = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)"Delete From T_MBG_MbgViewListDesCellEntry Where FViewListDesId IN (Select Fid From T_MBG_MbgViewListDesCell Where FMemberNumber = ? AND FBgSchemeId = ? AND FBgTemplateId = ? and FOrgUnitId = ? And FVersionId = ? AND FBgPeriodId = ? and FCurrencyId = ?  And FSheetIndex = ? And FRowIndex = ? And FColIndex = ?)", deleteEntryParams);
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((Connection)conn);
        }
    }

    @Override
    protected void _cloneFormTemplate(Context ctx, String sourceTemplateId, String targetTemplateId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((String)sourceTemplateId) && !StringUtils.isEmpty((String)targetTemplateId)) {
            ArrayList<MbgUpdateDataBaseCopyInfo> copyInfos = new ArrayList<MbgUpdateDataBaseCopyInfo>();
            String cellBosType = new MbgViewListDesCellInfo().getBOSType().toString();
            MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
            copyInfos.add(copyInfo);
            copyInfo.setWhere("FID IN(Select FViewListDesId FROM T_MBG_MbgViewListDesCellEntry Where FBgFormId = ?)");
            copyInfo.addWhereParam(sourceTemplateId);
            copyInfo.addReplace("FID", "newbosid('" + cellBosType + "')");
            copyInfo.addReplaceVar("FBgTemplateId", targetTemplateId);
            Connection conn = null;
            try {
                conn = this.getConnection(ctx);
                MbgUpdateDataBaseCopyHelper.copyDataBase(conn, "T_MBG_MbgViewListDesCell", copyInfos);
                MbgSqlHelper.executeBatch((Connection)conn, (String)("Insert Into T_MBG_MbgViewListDesCellEntry(FID, FViewListDesId, FBgFormId) Select newbosid('" + new MbgViewListDesCellEntryInfo().getBOSType() + "'), FID, FBgTemplateId FROM T_MBG_MbgViewListDesCell Where FBgTemplateId = ?"), (Object)new Object[]{targetTemplateId});
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            finally {
                SQLUtils.cleanup((Connection)conn);
            }
        }
    }
}

