/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.BgFormCollection;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgFormStateEnum;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgProcessEnum;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemFormTypeEnum;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.DimensionFormulaFacadeFactory;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.MBGViewListFormFacadeFactory;
import com.kingdee.eas.ma.mbg.app.AbstractReCalculateFacadeControllerBean;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.eas.ma.mbg.utils.BgViewHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionFormulaHelper;
import com.kingdee.eas.ma.mbg.utils.RecalculateObjInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReCalculateFacadeControllerBean
extends AbstractReCalculateFacadeControllerBean {
    private static final long serialVersionUID = -6940664857619727732L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.ReCalculateFacadeControllerBean");

    @Override
    protected List _getTemplateBySchemeID(Context ctx, String bgSchemeID, String orgUnitId) throws BOSException {
        if (StringUtils.isEmpty((String)orgUnitId)) {
            return new ArrayList();
        }
        HashSet<String> ids = new HashSet<String>();
        ids.add(orgUnitId);
        return this._getTemplateBySchemeId(ctx, bgSchemeID, ids);
    }

    @Override
    protected List _getTemplateBySchemeId(Context ctx, String bgSchemeID, Set orgUnitIds) throws BOSException {
        ArrayList<BgTemplateInfo> rtnList = new ArrayList<BgTemplateInfo>();
        if (StringUtils.isEmpty((String)bgSchemeID)) {
            return rtnList;
        }
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        String tempName = null;
        IRowSet rs = null;
        try {
            conn = this.getConnection(ctx);
            if (!orgUnitIds.isEmpty()) {
                tempName = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, (Collection)orgUnitIds);
            }
            String sql = "select fid, fname, fnumber, fformType from t_mbg_bgTemplate Where FID IN(select t1.fid from t_mbg_bgTemplate t1 inner join t_mbg_bgTemplatenode t2 on t1.FID = t2.FBgTemplateId  where t1.FBgSchemeId = ? " + (!orgUnitIds.isEmpty() ? "and t2.FOrgUnitId in(Select FID FROM " + tempName + ") " : "") + "and (t1.FBgTypeId <> '" + "bgMAAAAKIcA7rHKd" + "' or t1.FBgTypeId is NULL) and (t1.FFormType <> " + 4 + " or t1.FFormType is NULL))";
            rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{bgSchemeID});
            while (rs.next()) {
                String id = rs.getString("fid");
                String name = rs.getString("fname");
                String number = rs.getString("fnumber");
                int formtype = rs.getInt("fformType");
                BgTemplateInfo info = new BgTemplateInfo();
                info.setName(name);
                info.setNumber(number);
                info.setId(BOSUuid.read((String)id));
                info.setFormType(BgTemFormTypeEnum.getEnum(formtype));
                rtnList.add(info);
            }
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Connection)conn);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, tempName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Connection)conn);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)tempName);
        return rtnList;
    }

    @Override
    protected List _getBgForm(Context ctx, String schemeID, Set orgUnitId, List templateInfoList, BgPeriodInfo[] bgPeriodInfoAry, String currencyID, String bgVersionId, BgProcessEnum[] processTypes) throws BOSException {
        ArrayList<RecalculateObjInfo> rtnList = new ArrayList<RecalculateObjInfo>();
        if (ctx == null || schemeID == null || orgUnitId == null || templateInfoList == null || bgPeriodInfoAry == null || currencyID == null || bgVersionId == null) {
            return rtnList;
        }
        IBgPeriod period = BgPeriodFactory.getLocalInstance((Context)ctx);
        IBgForm iBgForm = BgFormFactory.getLocalInstance(ctx);
        HashMap<String, BgPeriodInfo> periodMap = new HashMap<String, BgPeriodInfo>();
        BgPeriodInfo periodInfo = null;
        BgTemplateInfo templateInfo = null;
        BgFormInfo bgFormInfo = null;
        Connection con = null;
        EntityViewInfo evi = new EntityViewInfo();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgTmpTable = null;
        String templTmpTable = null;
        String periodTmpTable = null;
        String bgFormKey = null;
        String orgId = null;
        String bgTemplateId = null;
        String bgPeriodId = null;
        HashSet<String> bgTemplateIds = new HashSet<String>();
        HashSet<String> processOrgIds = new HashSet<String>();
        HashMap<String, BgFormCollection> bgFormMap = new HashMap<String, BgFormCollection>();
        try {
            con = this.getConnection(ctx);
            int _num = templateInfoList.size();
            for (int j = 0; j < _num; ++j) {
                templateInfo = (BgTemplateInfo)templateInfoList.get(j);
                String templateID = templateInfo.getId().toString();
                bgTemplateIds.add(templateID);
            }
            int num = bgPeriodInfoAry.length;
            for (int i = 0; i < num; ++i) {
                String periodID = bgPeriodInfoAry[i].getId().toString();
                periodMap.put(periodID, null);
            }
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", new HashSet(periodMap.keySet()), CompareType.INCLUDE));
            BgPeriodCollection pCol = BgPeriodFactory.getLocalInstance((Context)ctx).getBgPeriodCollection(evi);
            periodMap.clear();
            for (int i = 0; i < pCol.size(); ++i) {
                periodMap.put(pCol.get(i).getId().toString(), pCol.get(i));
            }
            orgTmpTable = BgDBUtils.insertKey((TempTablePool)pool, (Connection)con, (Collection)orgUnitId);
            templTmpTable = BgDBUtils.insertKey((TempTablePool)pool, (Connection)con, bgTemplateIds);
            periodTmpTable = BgDBUtils.insertKey((TempTablePool)pool, (Connection)con, periodMap.keySet());
            HashSet<Integer> processTypeSet = new HashSet<Integer>();
            if (processTypes != null) {
                for (int i = 0; i < processTypes.length; ++i) {
                    processTypeSet.add(processTypes[i].getValue());
                }
            }
            evi = new EntityViewInfo();
            evi.setSelector(BgNFSHelper.getSelectors(false));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)schemeID));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgVersionId));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)currencyID));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)15, CompareType.NOTEQUALS));
            if (!processTypeSet.isEmpty()) {
                evi.getFilter().getFilterItems().add(new FilterItemInfo("processType", processTypeSet, CompareType.INCLUDE));
            }
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)("Select FID FROM " + orgTmpTable), CompareType.INNER));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)("Select FID FROM " + templTmpTable), CompareType.INNER));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)("Select FID FROM " + periodTmpTable), CompareType.INNER));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
            BgFormCollection fCol = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
            BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, schemeID);
            ReCalculateFacadeControllerBean.sortSpecial(ctx, schemeHelper, fCol);
            for (int i = 0; i < fCol.size(); ++i) {
                bgFormInfo = fCol.get(i);
                bgFormKey = this.getBgFormKey(bgFormInfo.getOrgUnit().getId(), bgFormInfo.getBgTemplate().getId(), bgFormInfo.getBgPeriod().getId(), bgFormInfo.getProcessType().getValue());
                if (!bgFormMap.containsKey(bgFormKey)) {
                    bgFormMap.put(bgFormKey, new BgFormCollection());
                }
                ((BgFormCollection)((Object)bgFormMap.get(bgFormKey))).add(bgFormInfo);
            }
            evi = new EntityViewInfo();
            evi.setSelector(new SelectorItemCollection());
            evi.getSelector().add("id");
            evi.getSelector().add("number");
            evi.getSelector().add("name");
            evi.getSelector().add("longNumber");
            evi.getSelector().add("orgUnitId");
            evi.getSelector().add("level");
            evi.setSorter(new SorterItemCollection());
            SorterItemInfo sort = new SorterItemInfo("level");
            sort.setSortType(SortType.DESCEND);
            evi.getSorter().add(sort);
            evi.getSorter().add(new SorterItemInfo("longNumber"));
            evi.setFilter(new FilterInfo());
            evi.getFilter().getFilterItems().add(new FilterItemInfo("viewId", (Object)schemeHelper.getBgOrgViewId()));
            evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnitId", (Object)("Select FID FROM " + orgTmpTable), CompareType.INNER));
            BgOrgUnitCollection oCol = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(evi);
            BgProcessEnum[] allProcessTypes = new BgProcessEnum[]{BgProcessEnum.C01, BgProcessEnum.C02, BgProcessEnum.C03, BgProcessEnum.C04};
            if (processTypes == null || processTypes.length == 0) {
                processTypes = allProcessTypes;
            }
            for (int o = 0; o < oCol.size(); ++o) {
                orgId = oCol.get(o).getOrgUnitID();
                if (processOrgIds.contains(orgId)) continue;
                processOrgIds.add(orgId);
                int num2 = bgPeriodInfoAry.length;
                for (int i = 0; i < num2; ++i) {
                    bgPeriodId = bgPeriodInfoAry[i].getId().toString();
                    if (!periodMap.containsKey(bgPeriodId)) continue;
                    periodInfo = (BgPeriodInfo)periodMap.get(bgPeriodId);
                    int _num2 = templateInfoList.size();
                    for (int j = 0; j < _num2; ++j) {
                        int p;
                        templateInfo = (BgTemplateInfo)templateInfoList.get(j);
                        bgTemplateId = templateInfo.getId().toString();
                        boolean hasAllNo = false;
                        if (processTypes.length == BgProcessEnum.getEnumList().size() - 1) {
                            hasAllNo = true;
                            for (p = 0; p < processTypes.length; ++p) {
                                bgFormKey = this.getBgFormKey(orgId, bgTemplateId, bgPeriodId, processTypes[p].getValue());
                                if (!bgFormMap.containsKey(bgFormKey)) continue;
                                hasAllNo = false;
                                break;
                            }
                        }
                        if (hasAllNo) {
                            rtnList.add(new RecalculateObjInfo(oCol.get(o), null, bgPeriodInfoAry[i], "noBgForm", templateInfo, null));
                            continue;
                        }
                        for (p = 0; p < processTypes.length; ++p) {
                            bgFormKey = this.getBgFormKey(orgId, bgTemplateId, bgPeriodId, processTypes[p].getValue());
                            if (bgFormMap.containsKey(bgFormKey)) {
                                fCol = (BgFormCollection)((Object)bgFormMap.get(bgFormKey));
                                for (int f = 0; f < fCol.size(); ++f) {
                                    bgFormInfo = fCol.get(f);
                                    bgFormInfo.setBgPeriod(periodInfo);
                                    BgFormInfo _bgFormInfo = iBgForm.getBgFormInfo((IObjectPK)new ObjectUuidPK(bgFormInfo.getId()), BgNFSHelper.getSelectors());
                                    String state = bgFormInfo.getState().getAlias();
                                    if (!(state.equals(BgFormStateEnum.Edited.getAlias()) || state.equals(BgFormStateEnum.Adjusted.getAlias()) || state.equals(BgFormStateEnum.Back.getAlias()))) {
                                        rtnList.add(new RecalculateObjInfo(oCol.get(o), processTypes[p], bgPeriodInfoAry[i], "stateError", templateInfo, bgFormInfo));
                                        continue;
                                    }
                                    rtnList.add(new RecalculateObjInfo(oCol.get(o), processTypes[p], bgPeriodInfoAry[i], "cancel", templateInfo, bgFormInfo));
                                }
                                continue;
                            }
                            rtnList.add(new RecalculateObjInfo(oCol.get(o), processTypes[p], bgPeriodInfoAry[i], "noBgForm", templateInfo, null));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)"budget error:", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup((Connection)con);
                pool.releaseTable(periodTmpTable);
                pool.releaseTable(templTmpTable);
                pool.releaseTable(orgTmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Connection)con);
        pool.releaseTable(periodTmpTable);
        pool.releaseTable(templTmpTable);
        pool.releaseTable(orgTmpTable);
        return rtnList;
    }

    public static void sortSpecial(Context ctx, BgSchemeDimensionHelper schemeHelper, BgFormCollection fCol) throws EASBizException, BOSException {
        BgFormInfo bgFormInfo = null;
        HashMap<String, Map<String, BgDimensionMember>> queryMap = new HashMap<String, Map<String, BgDimensionMember>>();
        String specialNumber = null;
        String srcNumber = null;
        String number = null;
        String[] combins = null;
        for (int i = 0; i < fCol.size(); ++i) {
            bgFormInfo = fCol.get(i);
            specialNumber = bgFormInfo.getSpecialItemNumber();
            if (StringUtils.isEmpty((String)specialNumber)) continue;
            combins = DimensionFormulaHelper.splitCombinations(specialNumber);
            for (int c = 0; c < combins.length; ++c) {
                srcNumber = DimensionFormulaHelper.getSrcNumber(combins[c]);
                number = DimensionFormulaHelper.getMemberNumber(combins[c]);
                BgViewHelper.getSubMap(queryMap, srcNumber, true).put(number, null);
            }
        }
        if (!queryMap.isEmpty()) {
            int i;
            BgSchemeInfo schemeInfo = BgSchemeFactory.getLocalInstance(ctx).getBgSchemeInfo("select orgUnit.id where id = '" + schemeHelper.getBgSchemeId() + "'");
            String[] srcNumbers = queryMap.keySet().toArray(new String[0]);
            for (int i2 = 0; i2 < srcNumbers.length; ++i2) {
                srcNumber = srcNumbers[i2];
                queryMap.put(srcNumber, DimensionFormulaFacadeFactory.getLocalInstance(ctx).queryMembers(schemeInfo.getOrgUnit().getId().toString(), schemeHelper, schemeHelper.getDimensionBySrcNumber().get(srcNumber).getNumber(), new HashSet(((Map)queryMap.get(srcNumber)).keySet()), false, null));
            }
            ArrayList<BgFormInfo> formList = new ArrayList<BgFormInfo>();
            for (i = 0; i < fCol.size(); ++i) {
                formList.add(fCol.get(i));
            }
            Collections.sort(formList, new BgFormSpecialCompartor(schemeHelper, queryMap));
            fCol = new BgFormCollection();
            for (i = 0; i < formList.size(); ++i) {
                fCol.add((BgFormInfo)formList.get(i));
            }
        }
    }

    protected String getBgFormKey(Object orgId, Object bgTemplateId, Object bgPeriodId, int processType) {
        return orgId + "_" + bgTemplateId + "_" + bgPeriodId + "_" + processType;
    }

    @Override
    protected void _reQueryBgData(Context ctx, BgFormInfo bgFormInfo, String orgUnitId, MbgViewListManager viewManager, Map pageMembers) throws BOSException, EASBizException {
        if (bgFormInfo == null || StringUtils.isEmpty((String)orgUnitId) || viewManager == null || pageMembers == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setSelector(BgNFSHelper.getSelectors(false));
        evi.setFilter(new FilterInfo());
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgScheme.id", (Object)bgFormInfo.getBgScheme().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgVersion.id", (Object)bgFormInfo.getBgVersion().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("currency.id", (Object)bgFormInfo.getCurrency().getId().toString()));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("state", (Object)15, CompareType.NOTEQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgUnitId, CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)bgFormInfo.getBgTemplate().getId().toString(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("bgPeriod.id", (Object)bgFormInfo.getBgPeriod().getId().toString(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("processType", (Object)bgFormInfo.getProcessType().getValue(), CompareType.EQUALS));
        evi.getFilter().getFilterItems().add(new FilterItemInfo("id", (Object)"select fadjustId from T_MBg_bgform where fstate in ( 4 , 35, 6, 101 ) and fid <> fadjustid", CompareType.NOTINNER));
        BgFormCollection fCol = BgFormFactory.getLocalInstance(ctx).getBgFormCollection(evi);
        if (fCol == null || fCol.isEmpty()) {
            return;
        }
        bgFormInfo = fCol.get(0);
        MbgViewListManager viewListManager = null;
        try {
            viewListManager = new MbgViewListXMLParser(ctx).parse(bgFormInfo.getEntries().get(0).getDimensionData());
        }
        catch (Exception e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        viewListManager = MBGViewListFormFacadeFactory.getLocalInstance(ctx).loadViewListManager(bgFormInfo.getId().toString(), null, viewListManager, null, orgUnitId, true, false);
        if (viewListManager == null) {
            return;
        }
        MbgViewListDimensionManager dimManager = null;
        BgDimensionBaseInfo dimension = null;
        Map subMap = null;
        String number = null;
        BgDimensionMember member = null;
        ArrayList<MbgViewListDimensionManager> dimensionManagers = new ArrayList<MbgViewListDimensionManager>();
        for (int s = 0; s < viewListManager.getSheetManagers().size(); ++s) {
            subMap = (Map)pageMembers.get(((MbgViewListSheetManager)viewListManager.getSheetManagers().get(s)).getSheetName());
            dimManager = ((MbgViewListSheetManager)viewListManager.getSheetManagers().get(s)).getDimensionManager();
            dimensionManagers.add(dimManager);
            for (Object dim : dimManager.getPageDimension()) {
                if (!(dim instanceof BgDimensionBaseInfo) || (dimension = (BgDimensionBaseInfo)dim).getMember().size() <= 1 || subMap == null || StringUtils.isEmpty((String)((String)subMap.get(dimension.getNumber())))) continue;
                number = (String)subMap.get(dimension.getNumber());
                Iterator it = dimension.getMember().iterator();
                while (it.hasNext()) {
                    member = (BgDimensionMember)it.next();
                    if (number.equals(member.getNumber())) continue;
                    it.remove();
                }
                if (!dimension.getMember().isEmpty()) continue;
                return;
            }
        }
        MBGFormFacadeFactory.getLocalInstance(ctx).queryBgData(bgFormInfo.getId(), (IObjectValue)bgFormInfo, dimensionManagers, 1, false, null, false, null);
    }

    static class BgFormSpecialCompartor
    implements Comparator<BgFormInfo> {
        private Map<String, Map<String, BgDimensionMember>> memberMap = null;
        private BgSchemeDimensionHelper schemeHelper = null;

        public BgFormSpecialCompartor(BgSchemeDimensionHelper schemeHelper, Map<String, Map<String, BgDimensionMember>> memberMap) {
            this.schemeHelper = schemeHelper;
            this.memberMap = memberMap;
        }

        @Override
        public int compare(BgFormInfo f1, BgFormInfo f2) {
            String special1 = f1.getSpecialItemNumber();
            String special2 = f2.getSpecialItemNumber();
            if (StringUtils.isEmpty((String)special1)) {
                if (StringUtils.isEmpty((String)special2)) {
                    return 0;
                }
                return 1;
            }
            if (StringUtils.isEmpty((String)special2)) {
                return -1;
            }
            String[] combins1 = DimensionFormulaHelper.splitCombinations(special1);
            String[] combins2 = DimensionFormulaHelper.splitCombinations(special2);
            String srcNumber1 = null;
            String srcNumber2 = null;
            String number1 = null;
            String number2 = null;
            for (int c = 0; c < combins1.length; ++c) {
                srcNumber1 = DimensionFormulaHelper.getSrcNumber(combins1[c]);
                number1 = DimensionFormulaHelper.getMemberNumber(combins1[c]);
                if (combins2.length < c + 1) {
                    return -1;
                }
                srcNumber2 = DimensionFormulaHelper.getSrcNumber(combins2[c]);
                number2 = DimensionFormulaHelper.getMemberNumber(combins2[c]);
                if (!srcNumber1.equals(srcNumber2)) {
                    return srcNumber1.compareTo(srcNumber2);
                }
                if (number1.equals(number2)) continue;
                if (!this.memberMap.containsKey(srcNumber1)) {
                    return 0;
                }
                BgDimensionMember m1 = this.memberMap.get(srcNumber1).get(number1);
                BgDimensionMember m2 = this.memberMap.get(srcNumber1).get(number2);
                if (m1 == null) {
                    if (m2 == null) {
                        return 0;
                    }
                    return 1;
                }
                if (m2 == null) {
                    return -1;
                }
                if (m1.getLevel() == m2.getLevel()) {
                    return m1.getSortValue().compareTo(m2.getSortValue());
                }
                return new Integer(m2.getLevel()).compareTo(m1.getLevel());
            }
            return 0;
        }
    }
}

