/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.ma.base.BgScenarioCollection;
import com.kingdee.eas.ma.base.BgScenarioFactory;
import com.kingdee.eas.ma.base.BgScenarioInfo;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgRollException;
import com.kingdee.eas.ma.mbg.RollTemplateInfo;
import com.kingdee.eas.ma.mbg.app.AbstractRollTemplateControllerBean;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.log4j.Logger;

public class RollTemplateControllerBean
extends AbstractRollTemplateControllerBean {
    private static final long serialVersionUID = -4323203778956273730L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.RollTemplateControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        return super._addnew(ctx, model);
    }

    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this.checkDup(ctx, model);
        super._update(ctx, pk, model);
    }

    private void checkDup(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        if (model instanceof RollTemplateInfo) {
            RollTemplateInfo roll = (RollTemplateInfo)model;
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("bgTemplate.id", (Object)((RollTemplateInfo)model).getBgTemplate().getId().toString(), CompareType.EQUALS));
            if (roll.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)roll.getId().toString(), CompareType.NOTEQUALS));
            }
            if (this._exists(ctx, filter)) {
                throw new BgRollException(BgRollException.TEMPLATEREPEAD);
            }
        }
    }

    @Override
    protected boolean _isQuotedByBgForm(Context ctx, String id) throws BOSException {
        boolean isQuoted = false;
        if (id == null) {
            isQuoted = false;
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        Connection connection = null;
        try {
            connection = this.getConnection(ctx);
            StringBuffer strBuffer = new StringBuffer(200);
            strBuffer.append("select * from  T_MBG_BgForm  where  FDataSource = ").append(13).append(" and FState = ").append(6).append(" and FBgTemplateID in(").append(" select FBgTemplateID from T_MBG_RollTemplate where FID=?)");
            ps = connection.prepareStatement(strBuffer.toString());
            ps.setString(1, id);
            rs = ps.executeQuery();
            isQuoted = rs.next();
        }
        catch (SQLException e) {
            try {
                logger.error((Object)"validate", (Throwable)e);
                throw new SQLDataException(e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)ps, (Connection)connection);
        return isQuoted;
    }

    @Override
    protected BgScenarioInfo _getBgScenarioNumberByBgForm(Context ctx, BgFormInfo bgForm) throws BOSException, EASBizException {
        if (bgForm != null && bgForm.getId() != null) {
            Statement ps = null;
            ResultSet rs = null;
            Connection connection = null;
            try {
                connection = this.getConnection(ctx);
                StringBuffer strBuffer = new StringBuffer(200);
                strBuffer.append(" select fbgscenarioid from T_MBG_RollTemplate where fbgTemplateid in (").append(" select frootid from T_MBG_bgTemplate where fid in (select fbgTemplateid from T_MBG_bgform where fid = '").append(bgForm.getId().toString()).append("')) ");
                EntityViewInfo view = new EntityViewInfo();
                SelectorItemCollection coll = new SelectorItemCollection();
                coll.add("id");
                coll.add("number");
                view.setSelector(coll);
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)strBuffer.toString(), CompareType.INNER));
                view.setFilter(filter);
                BgScenarioCollection bgScenarioCollection = BgScenarioFactory.getLocalInstance((Context)ctx).getBgScenarioCollection(view);
                if (bgScenarioCollection != null && bgScenarioCollection.size() == 1) {
                    BgScenarioInfo bgScenarioInfo = bgScenarioCollection.get(0);
                    return bgScenarioInfo;
                }
            }
            catch (BOSException ex) {
                logger.error((Object)"_getBgScenarioNumberByBgForm", (Throwable)ex);
                throw ex;
            }
            finally {
                SQLUtils.cleanup(rs, ps, (Connection)connection);
            }
        }
        return null;
    }
}

