/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgElementInfo;
import com.kingdee.eas.ma.mbg.BgTemplateException;
import com.kingdee.eas.ma.mbg.StyleSetCollection;
import com.kingdee.eas.ma.mbg.app.AbstractStyleSetControllerBean;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.log4j.Logger;

public class StyleSetControllerBean
extends AbstractStyleSetControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.StyleSetControllerBean");

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return new FilterInfo();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        if (this.isStyleSetUsedByTemplate(ctx, pk)) throw new BgTemplateException(BgTemplateException.ISUSE);
        if (this.isSysStyleSet(ctx, pk)) throw new BgTemplateException(BgTemplateException.ISSYSSET);
        if (!this.isCreateByThisOrg(ctx, pk)) {
            throw new BgTemplateException(BgTemplateException.ISCREATEBYORG);
        }
        super.delete(ctx, pk);
    }

    private boolean isCreateByThisOrg(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            CostCenterOrgUnitInfo ccoui = ContextUtil.getCurrentCostUnit((Context)ctx);
            String sql = "select fid from t_mbg_styleset where FID = ? and FOrgUnitID = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString(), ccoui.getId().toString()});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isSysStyleSet(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block5: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "select fid from t_mbg_styleset where FID = ? and FisSysdefault = 1";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
                if (!rs.next()) break block5;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        return false;
    }

    private boolean isStyleSetUsedByTemplate(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        IRowSet rs;
        block11: {
            boolean bl;
            if (pk == null) {
                return false;
            }
            String sql = "select top 1 * from t_mbg_bgtemplate where fstylesetid = ?";
            rs = null;
            try {
                rs = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new String[]{pk.toString()});
                if (!rs.next()) break block11;
                bl = true;
            }
            catch (SQLException e) {
                try {
                    logger.error((Object)"budget error:", (Throwable)e);
                    throw new BOSException((Throwable)e);
                }
                catch (Throwable throwable) {
                    SQLUtils.cleanup(rs);
                    throw throwable;
                }
            }
            SQLUtils.cleanup((ResultSet)rs);
            return bl;
        }
        SQLUtils.cleanup((ResultSet)rs);
        String sql1 = "select top 1 * from t_mbg_bgCsltemplate where fstylesetid = ?";
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql1, (Object[])new String[]{pk.toString()});
            if (rs.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            logger.error((Object)"budget error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    public void updateStyleSetElement(Context ctx, IObjectValue model) throws Exception {
        StyleSetCollection colls = this.getStyleSetCollection(ctx);
        BgElementInfo _model = (BgElementInfo)model;
        CoreBaseCollection coreColl = new CoreBaseCollection();
        for (int i = 0; i < colls.size(); ++i) {
            TemplateStyleInfo templateStyleInfo;
            if (colls.get(i).getData() == null || colls.get(i).getData().length <= 0 || (templateStyleInfo = MbgViewListXMLParser.parseStyle(colls.get(i).getData())).isDataTYpe()) continue;
            Map<String, Object[]> eleMap = templateStyleInfo.getEleMap();
            if (eleMap.containsKey(_model.getNumber())) {
                if (_model.getDataType().getValue() == 3) {
                    eleMap.get((Object)_model.getNumber())[3] = 1;
                }
            } else {
                Object[] object = new Object[5];
                object[0] = 2;
                object[1] = _model.getDataType().getValue() == 0 || _model.getDataType().getValue() == 2 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                object[2] = 4;
                if (_model.getDataType().getValue() == 3) {
                    object[3] = 1;
                    object[4] = true;
                } else {
                    object[3] = 0;
                    object[4] = false;
                }
                eleMap.put(_model.getNumber(), object);
            }
            colls.get(i).setData(MbgViewListXMLParser.unParseStyle(templateStyleInfo));
            coreColl.add((CoreBaseInfo)colls.get(i));
        }
        if (coreColl.size() > 0) {
            this.updateBatchData(ctx, coreColl);
        }
    }
}

