/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.ISQLExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.mbg.IUserGroupRef;
import com.kingdee.eas.ma.mbg.MbgPermissionCollection;
import com.kingdee.eas.ma.mbg.MbgPermissionFactory;
import com.kingdee.eas.ma.mbg.UserGroupInfo;
import com.kingdee.eas.ma.mbg.UserGroupRefFactory;
import com.kingdee.eas.ma.mbg.UserGroupRefInfo;
import com.kingdee.eas.ma.mbg.app.AbstractUserGroupControllerBean;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class UserGroupControllerBean
extends AbstractUserGroupControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.UserGroupControllerBean");

    @Override
    protected IObjectPK _addnew(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        IObjectPK pk = super._addnew(ctx, model);
        Set userIDs = (Set)model.get("userIDs");
        this.processUserGroupRef(ctx, pk, userIDs);
        return pk;
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        this._checkNumberDup(ctx, model);
        super._update(ctx, pk, model);
        IUserGroupRef iUserGroupRef = UserGroupRefFactory.getLocalInstance(ctx);
        FilterInfo delFilter = new FilterInfo();
        delFilter.getFilterItems().add(new FilterItemInfo("userGroup.id", (Object)pk.toString(), CompareType.EQUALS));
        iUserGroupRef.delete(delFilter);
        Set userIDs = (Set)model.get("userIDs");
        this.processUserGroupRef(ctx, pk, userIDs);
    }

    protected void processUserGroupRef(Context ctx, IObjectPK pk, Set<String> userIDs) throws BOSException, EASBizException {
        if (pk == null || userIDs == null) {
            return;
        }
        if (userIDs.size() == 0) {
            return;
        }
        IUserGroupRef iUserGroupRef = UserGroupRefFactory.getLocalInstance(ctx);
        CoreBaseCollection colls = new CoreBaseCollection();
        UserGroupRefInfo userRef = null;
        UserInfo user = null;
        UserGroupInfo userGroup = new UserGroupInfo();
        userGroup.setId(BOSUuid.read((String)pk.toString()));
        for (String id : userIDs) {
            userRef = new UserGroupRefInfo();
            user = new UserInfo();
            user.setId(BOSUuid.read((String)id));
            userRef.setUser(user);
            userRef.setUserGroup(userGroup);
            colls.add((CoreBaseInfo)userRef);
        }
        iUserGroupRef.submit(colls);
    }

    @Override
    protected Map _deleteBatch(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null) {
            return null;
        }
        HashMap<String, Set<UserGroupInfo>> returnMap = new HashMap<String, Set<UserGroupInfo>>();
        Set<UserGroupInfo> settingUserGroups = this.checkLightAppSettingUserGroupRef(ctx, idSet);
        returnMap.put("LA", settingUserGroups);
        HashSet<String> lightAppSettingRefIDs = new HashSet<String>();
        if (settingUserGroups != null) {
            for (CoreBaseInfo coreBaseInfo : settingUserGroups) {
                lightAppSettingRefIDs.add(coreBaseInfo.getId().toString());
            }
        }
        idSet.removeAll(lightAppSettingRefIDs);
        Set<UserGroupInfo> cantDelGroups = this.checkUserGroupRef(ctx, idSet);
        returnMap.put("PER", cantDelGroups);
        HashSet<String> hashSet = new HashSet<String>();
        if (cantDelGroups != null) {
            for (UserGroupInfo userGroup : cantDelGroups) {
                hashSet.add(userGroup.getId().toString());
            }
        }
        idSet.removeAll(hashSet);
        if (idSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("userGroup.id", (Object)idSet, CompareType.INCLUDE));
            UserGroupRefFactory.getLocalInstance(ctx).delete(filter);
            filter.getFilterItems().clear();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            this.delete(ctx, filter);
        }
        return returnMap;
    }

    private Set<UserGroupInfo> checkLightAppSettingUserGroupRef(Context ctx, Set idSet) throws BOSException {
        if (idSet == null) {
            return null;
        }
        HashSet<UserGroupInfo> ugSet = new HashSet<UserGroupInfo>();
        if (BgDBUtils.existTable((Context)ctx, (String)"T_MBG_BgUGLightAppSettingRef") != BgDBUtils.YES) {
            return ugSet;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("Select t.fid,t.fnumber from T_MBG_UserGroup t ,T_MBG_BgUGLightAppSettingRef h ");
        sql.append(" Where t.fid = h.FRefID and h.FRefId in (");
        for (Object refId : idSet) {
            sql.append("'" + refId.toString() + "',");
        }
        if (idSet.size() > 0) {
            sql.deleteCharAt(sql.length() - 1);
        }
        sql.append(")");
        ISQLExecutor iSql = SQLExecutorFactory.getLocalInstance((Context)ctx, (String)sql.toString());
        IRowSet rs = iSql.executeSQL();
        UserGroupInfo info = null;
        try {
            while (rs.next()) {
                info = new UserGroupInfo();
                info.setId(BOSUuid.read((String)rs.getString("FID")));
                info.setNumber(rs.getString("FNUMBER"));
                ugSet.add(info);
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return ugSet;
    }

    protected Set<UserGroupInfo> checkUserGroupRef(Context ctx, Set idSet) throws BOSException, EASBizException {
        if (idSet == null) {
            return null;
        }
        HashSet<UserGroupInfo> cantDelGroups = new HashSet<UserGroupInfo>();
        EntityViewInfo view = new EntityViewInfo();
        view.setSorter(new SorterItemCollection());
        view.getSelector().add("userGroup.number");
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("userGroup.id", (Object)idSet, CompareType.INCLUDE));
        view.setSelector(new SelectorItemCollection());
        view.getSelector().add(new SelectorItemInfo("userGroup.id"));
        view.getSelector().add(new SelectorItemInfo("userGroup.number"));
        view.getSelector().add(new SelectorItemInfo("userGroup.name"));
        MbgPermissionCollection coll = MbgPermissionFactory.getLocalInstance(ctx).getMbgPermissionCollection(view);
        for (int i = 0; i < coll.size(); ++i) {
            cantDelGroups.add(coll.get(i).getUserGroup());
        }
        return cantDelGroups;
    }

    protected FilterInfo getFilterForDefaultCU(Context ctx, IObjectValue model) {
        return null;
    }
}

