/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.batch.ChecFmlParamPermissionUtil;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.BgPropertyHelper;
import com.kingdee.eas.ma.mbg.BgOrgUnitCollection;
import com.kingdee.eas.ma.mbg.BgOrgUnitFactory;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.app.AbstractViewListFacadeControllerBean;
import com.kingdee.eas.ma.mbg.app.utils.MbgViewListFormServerHelper;
import com.kingdee.eas.ma.mbg.app.utils.ViewListMemberParserServerHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgViewListAtribute;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.TemplateStyleInfo;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgSchemeDimensionHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ViewListFacadeControllerBean
extends AbstractViewListFacadeControllerBean {
    private static final long serialVersionUID = 2503536166899035613L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.ViewListFacadeControllerBean");

    @Override
    protected Map _initTemplateData(Context ctx, BgTemplateInfo bgTemplateInfo, TemplateStyleInfo templateStyle, String orgId, boolean isQueryAllRelation) throws BOSException, EASBizException {
        IObjectValue obj = BgViewDimensionFactory.getLocalInstance(ctx).getDimensionByTemplate(bgTemplateInfo.getId().toString());
        if (obj instanceof BgViewDimensionInfo) {
            byte[] bytes = ((BgViewDimensionInfo)obj).getData();
            try {
                return this._initTemplateData(ctx, bgTemplateInfo, templateStyle, new MbgViewListXMLParser(ctx).parse(bytes), orgId, isQueryAllRelation);
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return new HashMap();
    }

    @Override
    protected Map _initTemplateData(Context ctx, BgTemplateInfo bgTemplate, TemplateStyleInfo templateStyle, MbgViewListManager viewManager, String orgId, boolean isQueryAllRelation) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        MBgTemplateHelper.logTime("Start BgSchemeDimensionHelper");
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgTemplate.getBgScheme().getId().toString());
        MBgTemplateHelper.logTime("End BgSchemeDimensionHelper");
        if (templateStyle != null) {
            resultMap.putAll(this.initBgTemplateStyle(ctx, templateStyle));
        }
        MBgTemplateHelper.logTime("End initBgTemplateStyle");
        if (orgId == null && bgTemplate != null && bgTemplate.getOrgUnit() != null) {
            orgId = bgTemplate.getOrgUnit().getId().toString();
        }
        viewManager = this.loadViewManager(ctx, schemeHelper, viewManager, orgId, isQueryAllRelation);
        resultMap.put("dimensino.member", viewManager);
        MBgTemplateHelper.logTime("End loadViewManager");
        resultMap.put("dimension.property", this.loadProperty(ctx, schemeHelper, viewManager));
        MBgTemplateHelper.logTime("End loadProperty");
        return resultMap;
    }

    private Map<String, Map<String, String>> loadProperty(Context ctx, BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager) throws BOSException, EASBizException {
        Object object;
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        HashMap<String, Set<String>> propSortIds = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> memberNumbers = new HashMap<String, Set<String>>();
        HashSet<String> allDimension = new HashSet<String>();
        ArrayList<IMbgViewListObject> objects = new ArrayList<IMbgViewListObject>();
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRowDimension());
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getColDimension());
        }
        for (int i = 0; i < objects.size(); ++i) {
            object = objects.get(i);
            if (!(object instanceof MbgViewListAtribute)) continue;
            MbgViewListAtribute attribObject = (MbgViewListAtribute)object;
            allDimension.add(attribObject.getDimNumber());
            if (attribObject.getPropertySort().getId() == null) continue;
            if (!propSortIds.containsKey(attribObject.getDimNumber())) {
                propSortIds.put(attribObject.getDimNumber(), new HashSet());
            }
            ((Set)propSortIds.get(attribObject.getDimNumber())).add(attribObject.getPropertySort().getId().toString());
        }
        if (propSortIds.isEmpty() && allDimension.isEmpty()) {
            return result;
        }
        objects.clear();
        for (int s = 0; s < viewManager.getSheetManagers().size(); ++s) {
            objects.addAll(((MbgViewListSheetManager)viewManager.getSheetManagers().get(s)).getDimensionManager().getRowCols());
        }
        for (int i = 0; i < objects.size(); ++i) {
            BgDimensionMember member;
            object = objects.get(i);
            if (!(object instanceof MbgViewListRowCol)) continue;
            MbgViewListRowCol rowObject = (MbgViewListRowCol)object;
            if (rowObject.isCombin()) {
                int mm;
                String[] numbers;
                String[] types;
                int m;
                for (m = 0; m < rowObject.getCombinMembers().size(); ++m) {
                    member = rowObject.getCombinMembers().get(m);
                    types = member.getType().split(",");
                    numbers = member.getNumber().split(",");
                    for (mm = 0; mm < numbers.length; ++mm) {
                        this.addMember(memberNumbers, types[mm], numbers[mm]);
                    }
                }
                for (m = 0; m < rowObject.getCombinSelectMembers().size(); ++m) {
                    member = rowObject.getCombinSelectMembers().get(m);
                    types = member.getType().split(",");
                    numbers = member.getNumber().split(",");
                    for (mm = 0; mm < numbers.length; ++mm) {
                        this.addMember(memberNumbers, types[mm], numbers[mm]);
                    }
                }
                continue;
            }
            for (int d = 0; d < rowObject.getDimensions().size(); ++d) {
                MbgViewListDimensionInfo dimension = rowObject.getDimensions().get(d);
                for (int m = 0; m < dimension.getMember().size(); ++m) {
                    member = (BgDimensionMember)dimension.getMember().get(m);
                    this.addMember(memberNumbers, member.getType(), member.getNumber());
                }
            }
        }
        if (!propSortIds.isEmpty()) {
            this.queryBgProperty(ctx, propSortIds, memberNumbers, schemeHelper, result);
        }
        this.appendSystenGemPropterty(ctx, schemeHelper, allDimension, memberNumbers, result);
        return result;
    }

    private void queryBgProperty(Context ctx, Map<String, Set<String>> propSortIds, Map<String, Set<String>> memberNumbers, BgSchemeDimensionHelper schemeHelper, Map<String, Map<String, String>> result) throws BOSException {
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rst = null;
        String dimNumber2 = null;
        Set<String> subSet = null;
        try {
            conn = this.getConnection(ctx);
            StringBuffer sql = new StringBuffer();
            List paramList = null;
            for (String dimNumber2 : propSortIds.keySet()) {
                subSet = memberNumbers.get(dimNumber2);
                if (subSet == null || subSet.isEmpty()) continue;
                paramList = null;
                sql.setLength(0);
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber2)) {
                    sql.append("Select orgUnit.FNumber memberNumber, prop.FName_" + ctx.getLocale() + " propName, prop.FBgPropertySortID propSortId ");
                    sql.append("FROM T_MBG_PropertyRefSource propRef INNER JOIN T_MBg_BgProperty prop ON prop.FID = propRef.FPropertyId INNER JOIN T_MBG_BgOrgUnit orgUnit ON orgUnit.FID = propRef.FSourceID Where orgUnit.FViewId = ? ");
                    sql.append("AND prop.FBgPropertySortID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)propSortIds.get(dimNumber2).size()).append(") ");
                    sql.append("AND orgUnit.FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                } else if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber2)) {
                    sql.append("Select acct.FNumber memberNumber, prop.FName_" + ctx.getLocale() + " propName, prop.FBgPropertySortID propSortId ");
                    sql.append("FROM T_MBG_PropertyRefSource propRef INNER JOIN T_MBg_BgProperty prop ON prop.FID = propRef.FPropertyId INNER JOIN T_MBG_BgAccount acct ON acct.FID = propRef.FSourceID Where acct.FBgAccountViewId = ? ");
                    sql.append("AND prop.FBgPropertySortID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)propSortIds.get(dimNumber2).size()).append(") ");
                    sql.append("AND acct.FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                } else {
                    sql.append("Select memb.FNumber memberNumber, prop.FName_" + ctx.getLocale() + " propName, prop.FBgPropertySortID propSortId ");
                    sql.append("FROM T_MBG_PropertyRefSource propRef INNER JOIN T_MBg_BgProperty prop ON prop.FID = propRef.FPropertyId INNER JOIN T_MBG_MbgMember memb ON memb.FID = propRef.FSourceID Where memb.FViewId = ? ");
                    sql.append("AND prop.FBgPropertySortID IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql, (int)propSortIds.get(dimNumber2).size()).append(") ");
                    sql.append("AND memb.FNumber IN(");
                    MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
                }
                Object[] commParam = new Object[propSortIds.get(dimNumber2).size() + 1];
                commParam[0] = schemeHelper.getDimension(dimNumber2).getViewId();
                System.arraycopy(propSortIds.get(dimNumber2).toArray(), 0, commParam, 1, commParam.length - 1);
                paramList = MbgSqlHelper.getBatchParams((Object[])commParam, (Object[])subSet.toArray(), (int)50);
                if (paramList == null || paramList.isEmpty()) continue;
                pstmt = conn.prepareStatement(sql.toString());
                for (int i = 0; i < paramList.size(); ++i) {
                    MbgSqlHelper.setParams((PreparedStatement)pstmt, (Object[])((Object[])paramList.get(i)));
                    rst = pstmt.executeQuery();
                    while (rst.next()) {
                        String propSortId = rst.getString("PropSortId");
                        String memberNumber = rst.getString("MemberNumber");
                        String propName = rst.getString("propName");
                        String key = dimNumber2 + "_" + propSortId;
                        if (!result.containsKey(key)) {
                            result.put(key, new HashMap());
                        }
                        result.get(key).put(memberNumber, propName);
                    }
                }
                SQLUtils.cleanup(rst, (Statement)pstmt);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            SQLUtils.cleanup(rst, pstmt, (Connection)conn);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private void appendSystenGemPropterty(Context ctx, BgSchemeDimensionHelper schemeHelper, Set<String> allDimension, Map<String, Set<String>> memberNumbers, Map<String, Map<String, String>> result) throws BOSException {
        MBgTemplateHelper.startLog("Start appendSystenGemPropterty");
        if (memberNumbers != null && !memberNumbers.isEmpty()) {
            logger.error((Object)("MemberNumbers SrcNumbers:" + memberNumbers.keySet()));
        }
        String dimNumber2 = null;
        Set<String> subSet = null;
        String tempIds = null;
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        Connection conn = null;
        try {
            conn = this.getConnection(ctx);
            for (String dimNumber2 : allDimension) {
                int i;
                BgOrgUnitCollection coll;
                subSet = memberNumbers.get(dimNumber2);
                if (subSet == null || subSet.isEmpty()) continue;
                if (tempIds == null) {
                    tempIds = BgDBUtils.insertKey((TempTablePool)pool, (Connection)conn, subSet, (String)"NVarchar(80)");
                } else {
                    MbgSqlHelper.execute((Connection)conn, (String)("Delete FROM " + tempIds));
                    BgDBUtils.insertKey((Connection)conn, (String)("Insert Into " + tempIds + "(FID) Values(?)"), subSet);
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                view.setFilter(filter);
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)("Select FID FROM " + tempIds), CompareType.INNER));
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("id");
                selector.add("number");
                selector.add("name");
                selector.add("description");
                ArrayList<BgOrgUnitInfo> memberList = new ArrayList<BgOrgUnitInfo>();
                if (DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimNumber2)) {
                    filter.getFilterItems().add(new FilterItemInfo("viewid", (Object)schemeHelper.getDimension(dimNumber2).getViewId(), CompareType.EQUALS));
                    coll = BgOrgUnitFactory.getLocalInstance(ctx).getBgOrgUnitCollection(view);
                    for (i = 0; i < coll.size(); ++i) {
                        memberList.add(coll.get(i));
                    }
                } else if (DimensionConstants.DEF_ACCOUNT_NUMBER.equals(dimNumber2)) {
                    filter.getFilterItems().add(new FilterItemInfo("bgAccountView.id", (Object)schemeHelper.getDimension(dimNumber2).getViewId(), CompareType.EQUALS));
                    coll = BgAccountFactory.getLocalInstance((Context)ctx).getBgAccountCollection(view);
                    for (i = 0; i < coll.size(); ++i) {
                        memberList.add((BgOrgUnitInfo)coll.get(i));
                    }
                } else {
                    if (DimensionConstants.DEF_CSL_Consolidation.equals(dimNumber2)) {
                        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)"M0NlAtvwTc+hRz1Td/e60V2BTmI=", CompareType.EQUALS));
                    } else {
                        filter.getFilterItems().add(new FilterItemInfo("viewId", (Object)schemeHelper.getDimension(dimNumber2).getViewId(), CompareType.EQUALS));
                    }
                    coll = MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberCollection(view);
                    for (i = 0; i < coll.size(); ++i) {
                        memberList.add((BgOrgUnitInfo)coll.get(i));
                    }
                }
                logger.error((Object)("Member List Size:" + memberList.size()));
                for (DataBaseInfo dataBase : memberList) {
                    Object propSortId = null;
                    String memberNumber = dataBase.getNumber();
                    String description = dataBase.getDescription();
                    String memberName = dataBase.getName();
                    String key = dimNumber2 + "_" + BgPropertyHelper.genDimNamePropertySortNumber((String)dimNumber2);
                    if (!result.containsKey(key)) {
                        result.put(key, new HashMap());
                    }
                    result.get(key).put(memberNumber, memberName);
                    key = dimNumber2 + "_" + BgPropertyHelper.genDimDescPropertySortNumber((String)dimNumber2);
                    if (!result.containsKey(key)) {
                        result.put(key, new HashMap());
                    }
                    result.get(key).put(memberNumber, description);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            BgDBUtils.releaseTmpTable((TempTablePool)pool, tempIds);
            SQLUtils.cleanup((Connection)conn);
        }
        MBgTemplateHelper.logTime("End appendSystenGemPropterty");
    }

    private void addMember(Map<String, Set<String>> memberNumbers, String dimNumber, String memberNumber) {
        if (memberNumbers == null || StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)memberNumber)) {
            return;
        }
        if (!memberNumbers.containsKey(dimNumber)) {
            memberNumbers.put(dimNumber, new HashSet());
        }
        memberNumbers.get(dimNumber).add(memberNumber);
    }

    private Map<String, String> initBgTemplateStyle(Context ctx, TemplateStyleInfo templateStyle) throws BOSException, EASBizException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (templateStyle != null) {
            if (!StringUtils.isEmpty((String)templateStyle.getUnitName())) {
                result.put("edit.orgunit", templateStyle.getUnitName());
            }
            if (!StringUtils.isEmpty((String)templateStyle.getDateName())) {
                result.put("edit.period", templateStyle.getDateName());
            }
        }
        return result;
    }

    private MbgViewListManager loadViewManager(Context ctx, BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager, String orgId, boolean isQueryAllRelation) throws BOSException, EASBizException {
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, schemeHelper, orgId);
        helper.setQueryAllRelation(isQueryAllRelation);
        helper.parseMember(viewManager);
        return viewManager;
    }

    private MbgViewListManager loadViewManager(Timestamp formCreateTime, Context ctx, BgSchemeDimensionHelper schemeHelper, MbgViewListManager viewManager, String orgId, boolean isQueryAllRelation) throws BOSException, EASBizException {
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, schemeHelper, orgId);
        helper.setFormCreateTime(formCreateTime);
        helper.setQueryAllRelation(isQueryAllRelation);
        helper.parseMember(viewManager);
        return viewManager;
    }

    @Override
    protected MbgViewListManager _parseMember(Context ctx, MbgViewListManager viewManager, String orgId, BgSchemeDimensionHelper schemeHelper) throws BOSException, EASBizException {
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, schemeHelper, orgId);
        helper.setQueryAllRelation(false);
        helper.parseMember(viewManager);
        helper.parseCanAddMember(viewManager, true, false);
        return viewManager;
    }

    @Override
    protected Map _checkMemberExists(Context ctx, String bgSchemeId, String orgId, Map queryMember) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)bgSchemeId)) {
            return null;
        }
        ViewListMemberParserServerHelper helper = new ViewListMemberParserServerHelper(ctx, bgSchemeId, orgId);
        return helper.checkMemberExists(queryMember, orgId);
    }

    @Override
    protected Map _queryProp(Context ctx, Map memberNumbers, Map propSortIds, String bgSchemeID, Set allDimension) throws BOSException, EASBizException {
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        if (memberNumbers == null || propSortIds == null || bgSchemeID == null || allDimension == null) {
            return result;
        }
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeID);
        this.queryBgProperty(ctx, propSortIds, memberNumbers, schemeHelper, result);
        this.appendSystenGemPropterty(ctx, schemeHelper, allDimension, memberNumbers, result);
        return result;
    }

    @Override
    protected Map _loadProperty(Context ctx, MbgViewListManager viewListManager, String bgSchemeID) throws BOSException, EASBizException {
        BgSchemeDimensionHelper schemeHelper = new BgSchemeDimensionHelper(ctx, bgSchemeID);
        return this.loadProperty(ctx, schemeHelper, viewListManager);
    }

    @Override
    protected Map _initTemplateData(Context ctx, Timestamp formCreateTime, BgTemplateInfo bgTemplateInfo, TemplateStyleInfo templateStyle, MbgViewListManager viewManager, String orgId, boolean isQueryAllRelation) throws BOSException, EASBizException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        BgSchemeDimensionHelper schemeHelper = null;
        schemeHelper = viewManager.getMemberCacheHelper() != null && viewManager.getMemberCacheHelper().getSchemeHelper() != null ? viewManager.getMemberCacheHelper().getSchemeHelper() : new BgSchemeDimensionHelper(ctx, bgTemplateInfo.getBgScheme().getId().toString());
        if (templateStyle != null) {
            resultMap.putAll(this.initBgTemplateStyle(ctx, templateStyle));
        }
        if (orgId == null && bgTemplateInfo != null && bgTemplateInfo.getOrgUnit() != null) {
            orgId = bgTemplateInfo.getOrgUnit().getId().toString();
        }
        viewManager = this.loadViewManager(formCreateTime, ctx, schemeHelper, viewManager, orgId, isQueryAllRelation);
        resultMap.put("dimensino.member", viewManager);
        if (viewManager.isParseProperty()) {
            resultMap.put("dimension.property", this.loadProperty(ctx, schemeHelper, viewManager));
        }
        return resultMap;
    }

    @Override
    protected MbgViewListManager _updateMember(Context ctx, MbgViewListManager viewManager, String bgSchemeId, String orgUnitId) throws BOSException, EASBizException {
        return MbgViewListFormServerHelper.updateMembers(ctx, viewManager, bgSchemeId, orgUnitId);
    }

    @Override
    protected Map<String, String> _initTemplateStyle(Context ctx, IReportPropertyAdapter adapter, TemplateStyleInfo templateStyle) throws BOSException {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!(templateStyle == null || StringUtils.isEmpty((String)templateStyle.getUnitName()) && StringUtils.isEmpty((String)templateStyle.getDateName()))) {
            Book book = Book.Manager.getNewBook((String)"Book", (int)1);
            ReportCalculateContext calcContext = new ReportCalculateContext(ctx);
            calcContext.setPermission(new ChecFmlParamPermissionUtil(ctx));
            calcContext.setReportAdapter(adapter);
            try {
                FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)calcContext);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            if (!StringUtils.isEmpty((String)templateStyle.getUnitName())) {
                book.getSheet(0).getCell(0, 0, true).setFormula(templateStyle.getUnitName());
            }
            if (!StringUtils.isEmpty((String)templateStyle.getDateName())) {
                book.getSheet(0).getCell(0, 1, true).setFormula(templateStyle.getDateName());
            }
            book.getUndoManager().enable(false);
            book.setCalculate(false);
            book.calc();
            book.getUndoManager().enable(false);
            if (!StringUtils.isEmpty((String)templateStyle.getUnitName())) {
                result.put("edit.orgunit", String.valueOf(book.getSheet(0).getCell(0, 0, false).getValue().getValue()));
            }
            if (!StringUtils.isEmpty((String)templateStyle.getDateName())) {
                result.put("edit.period", String.valueOf(book.getSheet(0).getCell(0, 1, false).getValue().getValue()));
            }
        }
        return result;
    }
}

