/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.base.BgAccountException;
import com.kingdee.eas.ma.base.BgAccountFactory;
import com.kingdee.eas.ma.base.BgAccountInfo;
import com.kingdee.eas.ma.base.BgAccountViewInfo;
import com.kingdee.eas.ma.base.MbgDimFactory;
import com.kingdee.eas.ma.base.MbgDimInfo;
import com.kingdee.eas.ma.base.MbgMemberFactory;
import com.kingdee.eas.ma.base.MbgMemberInfo;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.mbg.BgSchemeCollection;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeConvertToAccIntUtils;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.BgMergeSchemeHelper;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgMigrationUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.data.BgMigrationUtil");
    public static final String REF_CUBE = "refcube";
    public static final String ID = "id";
    private static final String REFFIELD = "refField";
    private static final String VIEWID = "viewId";
    private static final String SRCNUMBER = "srcNumber";
    private static final String NEWNUMBER = "newNumber";
    private static final String OLDNUMBER = "oldNumber";
    private static final String NEWID = "newId";
    private static final String OLDID = "oldId";
    private static final String NEWINTID = "newIntId";
    private static final String OLDINTID = "oldIntId";
    private static final String NEWNAME = "newName";
    private static final String OLDNAME = "oldName";
    private static final String FMEMBERCOMBINNUMBER = "FMemberCombinNumber";
    private static final String FMEMBERCOMBINNAME = "FMemberCombinName";
    private static final String FINDEXMEMBERNUMBER = "FIndexMemberNumber";
    private static final String FINDEXMEMBERNAME = "FIndexMemberName";
    private static final String FITEMFORMULA = "FItemFormula";
    private static final String DATAIDSET = "dataIDSet";
    private static final String ORGUNITINFOSET = "orgUnitInfoSet";

    public static void submitforDataMigration(Context ctx, Connection connection, IObjectValue model) throws Exception {
        if (connection == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"submitforDataMigration"});
        }
        Map<String, String> modelMap = BgMigrationUtil.handleModel(model, ctx);
        if (modelMap == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"submitforDataMigration"});
        }
        Map<String, List<String>> refCubeMap = BgMigrationUtil.getRefCubeMap(connection, modelMap.get(VIEWID));
        BgMigrationUtil.dataMigration(connection, modelMap, refCubeMap);
        BgMigrationUtil.alterRefDimMember(connection, modelMap);
        BgMigrationUtil.alterBgPastData(connection, model, modelMap);
        BgMigrationUtil.alterDimGroupData(ctx, connection, refCubeMap, modelMap, model);
        BgMigrationUtil.alterBgControlData(ctx, connection, modelMap, refCubeMap, model);
        BgMigrationUtil.alterEilmData(connection, modelMap, model);
        BgMigrationUtil.alterDailyActData(connection, modelMap, refCubeMap);
        BgMigrationUtil.recordHistory(modelMap, model, connection);
    }

    private static void alterDailyActData(Connection connection, Map<String, String> modelMap, Map<String, List<String>> refCubeMap) throws Exception {
        if (connection == null || modelMap == null || StringUtils.isEmpty((String)modelMap.get(SRCNUMBER)) || StringUtils.isEmpty((String)modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(NEWNUMBER)) || StringUtils.isEmpty((String)modelMap.get(REFFIELD)) || refCubeMap == null || refCubeMap.get(REF_CUBE) == null || refCubeMap.get(REF_CUBE).size() == 0) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterDailyActData"});
        }
        StringBuilder sql = null;
        List<String> refCubeList = refCubeMap.get(REF_CUBE);
        String itemComination = "FBgItemCombination";
        String formula = "FFormula";
        String srcNumber = modelMap.get(SRCNUMBER);
        String oldNumber = modelMap.get(OLDNUMBER);
        String newNumber = modelMap.get(NEWNUMBER);
        String refField = modelMap.get(REFFIELD);
        String oldDimString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        String replaceItemComination = BgMigrationUtil.getReplace(itemComination);
        String replaceFormula = BgMigrationUtil.getReplace(formula);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] objArray = new Object[]{oldDimString, newDimString, oldDimString, newDimString, newDimString, oldDimString};
        params.add(objArray);
        for (int i = 0; i < refCubeList.size(); ++i) {
            sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(BgMigrationUtil.toBgDailyActData(refCubeList.get(i)));
            sql.append(" SET ");
            sql.append(BgMigrationUtil.getEquation(itemComination, replaceItemComination));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(formula, replaceFormula));
            sql.append(",");
            sql.append(refField + "= ?");
            sql.append(" WHERE ");
            sql.append(refField + "= ?");
            try {
                MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), params);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    public static boolean checkTmpData(Context ctx, Connection connection, IObjectValue model) throws Exception {
        BgAccountInfo bgAccountInfo;
        MbgMemberInfo mbgMemberInfo;
        if (connection == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"checkTmpData"});
        }
        if (model instanceof MbgMemberInfo ? (mbgMemberInfo = (MbgMemberInfo)model).getParent() == null : model instanceof BgAccountInfo && (bgAccountInfo = (BgAccountInfo)model).getParent() == null) {
            return false;
        }
        Map<String, String> modelMap = BgMigrationUtil.handleModel(model, ctx);
        if (modelMap == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"checkTmpData"});
        }
        boolean existTmpData = BgMigrationUtil.isExistTmpData(connection, modelMap);
        return existTmpData;
    }

    private static void recordHistory(Map<String, String> modelMap, IObjectValue model, Connection connection) throws Exception {
        if (modelMap == null || model == null || StringUtils.isEmpty((String)modelMap.get(OLDID)) || StringUtils.isEmpty((String)modelMap.get(NEWID)) || StringUtils.isEmpty((String)modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(NEWNUMBER)) || connection == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"recordHistory"});
        }
        int memType = 0;
        if (model instanceof MbgMemberInfo) {
            memType = 2;
        } else if (model instanceof BgAccountInfo) {
            memType = 1;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("INSERT INTO ");
        sql.append("T_MBG_MEMBERMIGRATIONHISTORY ");
        sql.append("(FID,FOLDID,FNEWID,FOLDNUMBER,FNEWNUMBER,FMEMTYPE,FUPDATETIME) ");
        sql.append("VALUES ");
        sql.append("(?,?,?,?,?,?,?) ");
        PreparedStatement prepareStatement = null;
        try {
            prepareStatement = connection.prepareStatement(sql.toString());
            prepareStatement.setString(1, BOSUuid.create((BOSObjectType)new BOSObjectType("DF86B11E")).toString());
            prepareStatement.setString(2, modelMap.get(OLDID));
            prepareStatement.setString(3, modelMap.get(NEWID));
            prepareStatement.setString(4, modelMap.get(OLDNUMBER));
            prepareStatement.setString(5, modelMap.get(NEWNUMBER));
            prepareStatement.setInt(6, memType);
            prepareStatement.setTimestamp(7, new Timestamp(new Date().getTime()));
            prepareStatement.execute();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(prepareStatement);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)prepareStatement);
    }

    private static void alterBgControlData(Context ctx, Connection connection, Map<String, String> modelMap, Map<String, List<String>> refCubeMap, IObjectValue model) throws Exception {
        if (ctx == null || connection == null || modelMap == null || StringUtils.isEmpty((String)modelMap.get(SRCNUMBER)) || StringUtils.isEmpty((String)modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(NEWNUMBER)) || refCubeMap == null || refCubeMap.get(REF_CUBE) == null || refCubeMap.get(REF_CUBE).size() == 0 || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterBgControlData"});
        }
        List<String> refCubeList = refCubeMap.get(REF_CUBE);
        String itemExtNumber = "FItemExtNumber";
        String formula = "FFormula";
        String bgIndexNum = "FBgIndexNum";
        String srcNumber = modelMap.get(SRCNUMBER);
        String oldNumber = modelMap.get(OLDNUMBER);
        String newNumber = modelMap.get(NEWNUMBER);
        String oldDimString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        String replaceItemExtNumber = BgMigrationUtil.getReplace(itemExtNumber);
        String replaceFormula = BgMigrationUtil.getReplace(formula);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (model instanceof MbgMemberInfo) {
            Object[] objArray = new Object[]{oldDimString, newDimString, oldDimString, newDimString, oldDimString, newDimString, oldDimString, newDimString};
            params.add(objArray);
            BgMigrationUtil.updateControlDataForMbgDim(connection, refCubeList, itemExtNumber, formula, params);
        } else if (model instanceof BgAccountInfo) {
            Object[] objArray = new Object[]{oldDimString, newDimString, oldDimString, newDimString, newDimString, oldDimString};
            params.add(objArray);
            BgMigrationUtil.updateControlDataForAccount(connection, refCubeList, bgIndexNum, formula, replaceItemExtNumber, replaceFormula, itemExtNumber, params);
        }
    }

    private static void updateControlDataForMbgDim(Connection connection, List<String> refCubeList, String itemExtNumber, String formula, List params) throws Exception, SQLException {
        if (connection == null || refCubeList == null || refCubeList.size() == 0 || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)itemExtNumber) || params == null || params.size() == 0) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"updateControlDataForMbgDim"});
        }
        StringBuilder sql = null;
        for (int i = 0; i < refCubeList.size(); ++i) {
            sql = new StringBuilder();
            sql.append("UPDATE ");
            if (StringUtils.isEmpty((String)BgMigrationUtil.toControlTable(refCubeList.get(i)))) continue;
            sql.append(BgMigrationUtil.toControlTable(refCubeList.get(i)));
            sql.append(" SET ");
            sql.append(BgMigrationUtil.getEquation(itemExtNumber, BgMigrationUtil.itemExtNumberValueForUpdate(itemExtNumber)));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(formula, BgMigrationUtil.formulaValueForUpdate(formula)));
            try {
                MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), (List)params);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static String formulaValueForUpdate(String formula) throws Exception {
        if (StringUtils.isEmpty((String)formula)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"formulaValueForUpdate"});
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SUBSTRING(REPLACE(LEFT(" + formula + ",CHARINDEX('\",\"'," + formula + ")-1)||',',?||',',?||','),");
        sql.append("0,LEN(REPLACE(LEFT(" + formula + ",CHARINDEX('\",\"'," + formula + ")-1)||',',?||',',?||','))-1)");
        sql.append("|| RIGHT(" + formula + ",LEN(" + formula + ")-CHARINDEX('\",\"'," + formula + ")+1)");
        return sql.toString();
    }

    private static String itemExtNumberValueForUpdate(String itemExtNumber) throws Exception {
        if (StringUtils.isEmpty((String)itemExtNumber)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"itemExtNumberValueForUpdate"});
        }
        StringBuilder sql = new StringBuilder();
        sql.append("SUBSTRING(REPLACE(" + itemExtNumber + "||',',?||',',?||','),");
        sql.append("0,LEN(REPLACE(" + itemExtNumber + "||',',?||',',?||','))-1)");
        return sql.toString();
    }

    private static void updateControlDataForAccount(Connection connection, List<String> refCubeList, String bgIndexNum, String formula, String replaceItemExtNumber, String replaceFormula, String itemExtNumber, List params) throws Exception {
        if (connection == null || refCubeList == null || refCubeList.size() == 0 || StringUtils.isEmpty((String)bgIndexNum) || StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)replaceItemExtNumber) || StringUtils.isEmpty((String)replaceFormula) || StringUtils.isEmpty((String)itemExtNumber) || params == null || params.size() == 0) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"updateControlDataForAccount"});
        }
        StringBuilder sql = null;
        for (int i = 0; i < refCubeList.size(); ++i) {
            sql = new StringBuilder();
            sql.append("UPDATE ");
            if (StringUtils.isEmpty((String)BgMigrationUtil.toControlTable(refCubeList.get(i)))) continue;
            sql.append(BgMigrationUtil.toControlTable(refCubeList.get(i)));
            sql.append(" SET ");
            sql.append(BgMigrationUtil.getEquation(itemExtNumber, replaceItemExtNumber));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(formula, replaceFormula));
            sql.append(",");
            sql.append(bgIndexNum + "= ?");
            sql.append(" WHERE ");
            sql.append(bgIndexNum + "= ?");
            try {
                MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), (List)params);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static void alterEilmData(Connection connection, Map<String, String> modelMap, IObjectValue model) throws Exception {
        if (connection == null || modelMap == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterEilmData"});
        }
        if (model instanceof MbgMemberInfo) {
            BgMigrationUtil.executeUpdateBgCslElim(connection, modelMap);
        }
        BgMigrationUtil.executeUpdateBgCslElimEntry(connection, modelMap, model);
    }

    private static void executeUpdateBgCslElimEntry(Connection connection, Map<String, String> modelMap, IObjectValue model) throws Exception {
        Object[] objArray;
        if (modelMap == null || connection == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeUpdateBgCslElimEntry"});
        }
        String newNumber = modelMap.get(NEWNUMBER);
        String oldNumber = modelMap.get(OLDNUMBER);
        String newName = modelMap.get(NEWNAME);
        String oldName = modelMap.get(OLDNAME);
        String srcNumber = modelMap.get(SRCNUMBER);
        String fMemberCombinNumber = modelMap.get(FMEMBERCOMBINNUMBER);
        String fMemberCombinName = modelMap.get(FMEMBERCOMBINNAME);
        String findexMemberNumber = modelMap.get(FINDEXMEMBERNUMBER);
        String findexMemberName = modelMap.get(FINDEXMEMBERNAME);
        String fItemFormula = modelMap.get(FITEMFORMULA);
        if (StringUtils.isEmpty((String)newNumber) || StringUtils.isEmpty((String)oldNumber) || StringUtils.isEmpty((String)newName) || StringUtils.isEmpty((String)oldName) || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)fMemberCombinNumber) || StringUtils.isEmpty((String)fMemberCombinName) || StringUtils.isEmpty((String)findexMemberNumber) || StringUtils.isEmpty((String)findexMemberName) || StringUtils.isEmpty((String)fItemFormula)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeUpdateBgCslElim"});
        }
        StringBuilder sql = null;
        String oldDimNumberString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimNumberString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        String number = null;
        String name = null;
        String formula = null;
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        if (model instanceof MbgMemberInfo) {
            number = fMemberCombinNumber;
            name = fMemberCombinName;
            formula = fItemFormula;
            sql = new StringBuilder();
            sql.append("UPDATE T_MBG_BgCslElimEntry");
            sql.append(" SET ");
            sql.append(BgMigrationUtil.getEquation(number, BgMigrationUtil.itemExtNumberValueForUpdate(number)));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(name, BgMigrationUtil.itemExtNumberValueForUpdate(name)));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(formula, BgMigrationUtil.formulaValueForUpdate(formula)));
            objArray = new Object[]{oldDimNumberString, newDimNumberString, oldDimNumberString, newDimNumberString, oldName, newName, oldName, newName, oldDimNumberString, newDimNumberString, oldDimNumberString, newDimNumberString};
            params.add(objArray);
        } else if (model instanceof BgAccountInfo) {
            number = findexMemberNumber;
            name = findexMemberName;
            formula = fItemFormula;
            sql = new StringBuilder();
            sql.append("UPDATE T_MBG_BgCslElimEntry");
            sql.append(" SET ");
            sql.append(number + " = ?");
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(name, BgMigrationUtil.itemExtNumberValueForUpdate(name)));
            sql.append(",");
            sql.append(BgMigrationUtil.getEquation(formula, BgMigrationUtil.formulaValueForUpdate(formula)));
            sql.append(" WHERE " + number + "=?");
            objArray = new Object[]{newDimNumberString, oldName, newName, oldName, newName, oldDimNumberString, newDimNumberString, oldDimNumberString, newDimNumberString, oldDimNumberString};
            params.add(objArray);
        }
        try {
            if (sql != null) {
                MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), params);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void executeUpdateBgCslElim(Connection connection, Map<String, String> modelMap) throws Exception {
        if (modelMap == null || connection == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeUpdateBgCslElim"});
        }
        String newNumber = modelMap.get(NEWNUMBER);
        String oldNumber = modelMap.get(OLDNUMBER);
        String newName = modelMap.get(NEWNAME);
        String oldName = modelMap.get(OLDNAME);
        String srcNumber = modelMap.get(SRCNUMBER);
        String number = modelMap.get(FMEMBERCOMBINNUMBER);
        String name = modelMap.get(FMEMBERCOMBINNAME);
        if (StringUtils.isEmpty((String)newNumber) || StringUtils.isEmpty((String)oldNumber) || StringUtils.isEmpty((String)newName) || StringUtils.isEmpty((String)oldName) || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)name) || StringUtils.isEmpty((String)number)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeUpdateBgCslElim"});
        }
        StringBuilder sql = null;
        String oldDimNumberString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimNumberString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        sql = new StringBuilder();
        sql.append("UPDATE T_MBG_BgCslElim");
        sql.append(" SET ");
        sql.append(BgMigrationUtil.getEquation(name, BgMigrationUtil.itemExtNumberValueForUpdate(name)));
        sql.append(",");
        sql.append(BgMigrationUtil.getEquation(number, BgMigrationUtil.itemExtNumberValueForUpdate(number)));
        sql.append(" WHERE " + name + " is not null OR trim(" + name + ") <> '' ");
        sql.append(" OR " + number + " is not null OR trim(" + number + ") <> '' ");
        Object[] objArray = new Object[]{oldName, newName, oldName, newName, oldDimNumberString, newDimNumberString, oldDimNumberString, newDimNumberString};
        params.add(objArray);
        try {
            MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void alterDimGroupData(Context ctx, Connection connection, Map<String, List<String>> refCubeMap, Map<String, String> modelMap, IObjectValue model) throws Exception {
        if (connection == null || refCubeMap == null || refCubeMap.get(ID) == null || refCubeMap.get(ID).size() == 0 || modelMap == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterDimGroupData"});
        }
        List<String> idList = refCubeMap.get(ID);
        String schemeId = null;
        List<List<Object>> dimGroup = null;
        HashSet<String> bgSchemeIDs = new HashSet<String>();
        Map<String, List<List<Object>>> returnMap = null;
        for (int i = 0; i < idList.size(); ++i) {
            schemeId = idList.get(i);
            if (StringUtils.isEmpty((String)schemeId)) continue;
            bgSchemeIDs.add(schemeId);
        }
        returnMap = BgMergeSchemeHelper.initDimGroup(bgSchemeIDs, ctx);
        if (returnMap != null) {
            ArrayList<List<Object>> updateList = new ArrayList<List<Object>>();
            for (String bgschemeId : returnMap.keySet()) {
                dimGroup = returnMap.get(bgschemeId);
                updateList.addAll(BgMigrationUtil.handleNumber(dimGroup, modelMap, model));
            }
            BgMigrationUtil.saveNumber(updateList, connection);
        }
    }

    private static void saveNumber(List<List<Object>> updateList, Connection connection) throws Exception {
        if (connection == null || updateList == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"saveNumber"});
        }
        if (updateList.size() == 0) {
            return;
        }
        List<Object> dimGroupItem = null;
        String id = null;
        Object accMember = null;
        Object mbgMember = null;
        byte[] accNumberBytes = null;
        byte[] accNameBytes = null;
        byte[] memNumberBytes = null;
        byte[] memNameBytes = null;
        StringBuffer numberBuf = null;
        StringBuffer nameBuf = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param = null;
        for (int i = 0; i < updateList.size(); ++i) {
            BgDimensionMember acc;
            dimGroupItem = updateList.get(i);
            if (dimGroupItem == null) continue;
            id = dimGroupItem.get(3) != null && dimGroupItem.get(3) instanceof String ? dimGroupItem.get(3).toString() : null;
            accMember = dimGroupItem.get(0);
            mbgMember = dimGroupItem.get(2);
            numberBuf = new StringBuffer();
            nameBuf = new StringBuffer();
            if (accMember instanceof List) {
                for (Object obj : (List)accMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                if (numberBuf.length() > 0 && nameBuf.length() > 0) {
                    numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                    nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                }
                accNumberBytes = BgAnalyseHelper.getBytes(numberBuf.toString());
                accNameBytes = BgAnalyseHelper.getBytes(nameBuf.toString());
            }
            numberBuf.delete(0, numberBuf.length());
            nameBuf.delete(0, nameBuf.length());
            if (mbgMember instanceof List) {
                for (Object obj : (List)mbgMember) {
                    if (!(obj instanceof BgDimensionMember)) continue;
                    acc = (BgDimensionMember)obj;
                    numberBuf.append(acc.getNumber()).append(",");
                    nameBuf.append(acc.getName()).append(",");
                }
                if (numberBuf.length() > 0 && nameBuf.length() > 0) {
                    numberBuf.delete(numberBuf.length() - 1, numberBuf.length());
                    nameBuf.delete(nameBuf.length() - 1, nameBuf.length());
                }
                memNumberBytes = BgAnalyseHelper.getBytes(numberBuf.toString());
                memNameBytes = BgAnalyseHelper.getBytes(nameBuf.toString());
            }
            param = new Object[]{accNumberBytes, accNameBytes, memNumberBytes, memNameBytes, id};
            paramList.add(param);
        }
        if (paramList.size() > 0) {
            BgMigrationUtil.updateDimGroup(connection, paramList);
        }
    }

    private static void updateDimGroup(Connection connection, List paramList) throws Exception {
        if (paramList == null || connection == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"updateDimGroup"});
        }
        if (paramList.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_MBG_DimGroup SET FAccMemNumberData = ?,");
        sql.append("FAccMemNameData = ?,");
        sql.append("FMbgMemNumberData = ?,");
        sql.append("FMbgMemNameData = ?");
        sql.append("WHERE FID = ?");
        try {
            MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), (List)paramList);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static BgSchemeInfo findBgschemeInfo(BgSchemeCollection collBgScheme, String bgschemeId) throws Exception {
        if (collBgScheme == null || collBgScheme.size() == 0 || StringUtils.isEmpty((String)bgschemeId)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"findBgschemeInfo"});
        }
        for (int i = 0; i < collBgScheme.size(); ++i) {
            if (collBgScheme.get(i) == null || collBgScheme.get(i).getId() == null || !bgschemeId.equals(collBgScheme.get(i).getId().toString())) continue;
            return collBgScheme.get(i);
        }
        return null;
    }

    private static BgSchemeCollection getCollBgScheme(Map<String, List<List<Object>>> returnMap, Context ctx) throws Exception {
        if (returnMap == null || ctx == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"getCollBgScheme"});
        }
        Set<String> keySet = returnMap.keySet();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        viewInfo.getFilter().getFilterItems().add(new FilterItemInfo(ID, keySet, CompareType.INCLUDE));
        return BgSchemeFactory.getLocalInstance(ctx).getBgSchemeCollection(viewInfo);
    }

    private static List<List<Object>> handleNumber(List<List<Object>> dimGroup, Map<String, String> modelMap, IObjectValue model) throws Exception {
        if (dimGroup == null || dimGroup.size() == 0 || modelMap == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"handleNumber"});
        }
        List<Object> listItem = null;
        List accMembers = null;
        List mbgMember = null;
        BgDimensionMember bgDimensionMember = null;
        ArrayList<List<Object>> updateList = new ArrayList<List<Object>>();
        boolean flag = false;
        for (int j = 0; j < dimGroup.size(); ++j) {
            int k;
            listItem = dimGroup.get(j);
            flag = false;
            List list = accMembers = listItem.get(0) != null && listItem.get(0) instanceof List ? (List)listItem.get(0) : null;
            if (listItem != null && listItem.size() > 2 && listItem.get(2) != null && listItem.get(2) instanceof List) {
                mbgMember = (List)listItem.get(2);
            }
            if (mbgMember != null && model instanceof MbgMemberInfo) {
                for (k = 0; k < mbgMember.size(); ++k) {
                    if (mbgMember.get(k) == null || !(mbgMember.get(k) instanceof BgDimensionMember) || (bgDimensionMember = (BgDimensionMember)mbgMember.get(k)) == null || StringUtils.isEmpty((String)bgDimensionMember.getNumber()) || !bgDimensionMember.getNumber().equals(modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(NEWNUMBER))) continue;
                    bgDimensionMember.setNumber(modelMap.get(NEWNUMBER));
                    bgDimensionMember.setName(modelMap.get(NEWNAME));
                    flag = true;
                }
            } else if (accMembers != null && model instanceof BgAccountInfo) {
                for (k = 0; k < accMembers.size(); ++k) {
                    if (accMembers.get(k) == null || !(accMembers.get(k) instanceof BgDimensionMember) || (bgDimensionMember = (BgDimensionMember)accMembers.get(k)) == null || StringUtils.isEmpty((String)bgDimensionMember.getNumber()) || !bgDimensionMember.getNumber().equals(modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(NEWNUMBER))) continue;
                    bgDimensionMember.setNumber(modelMap.get(NEWNUMBER));
                    bgDimensionMember.setName(modelMap.get(NEWNAME));
                    flag = true;
                }
            }
            if (!flag) continue;
            updateList.add(listItem);
        }
        return updateList;
    }

    public static void dataMigration(Connection connection, Map<String, String> modelMap, Map<String, List<String>> refCubeMap) throws Exception {
        if (connection == null || modelMap == null || refCubeMap == null || refCubeMap.get(REF_CUBE) == null || refCubeMap.get(REF_CUBE).size() == 0) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"dataMigration"});
        }
        BgMigrationUtil.executeMigrationByViewAndRef(refCubeMap, modelMap.get(REFFIELD), modelMap.get(SRCNUMBER), modelMap.get(NEWNUMBER), modelMap.get(OLDNUMBER), modelMap.get(NEWINTID), modelMap.get(OLDINTID), connection);
    }

    private static Map<String, String> handleModel(IObjectValue model, Context ctx) throws Exception {
        if (model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"handleModel"});
        }
        String refField = null;
        String viewId = null;
        String srcNumber = null;
        String newNumber = null;
        String oldNumber = null;
        String newId = null;
        String oldId = null;
        String newName = null;
        String oldName = null;
        String newIntId = null;
        String oldIntId = null;
        String fMemberCombinNumber = FMEMBERCOMBINNUMBER;
        String fMemberCombinName = FMEMBERCOMBINNAME;
        String fIndexMemberNumber = FINDEXMEMBERNUMBER;
        String fIndexMemberName = FINDEXMEMBERNAME;
        String fItemFormula = FITEMFORMULA;
        if (model instanceof MbgMemberInfo) {
            MbgMemberInfo mbgMemberInfo = (MbgMemberInfo)model;
            MbgDimInfo mbgDim = BgMigrationUtil.handleMbgDimInfo(mbgMemberInfo.getMbgDim(), ctx);
            refField = mbgDim != null ? mbgDim.getRefField() : null;
            srcNumber = mbgDim != null ? mbgDim.getSrcNumber() : null;
            newNumber = mbgMemberInfo.getNumber();
            oldNumber = mbgMemberInfo.getParent() != null ? mbgMemberInfo.getParent().getNumber() : null;
            viewId = mbgMemberInfo.getViewId() != null ? mbgMemberInfo.getViewId().toString() : null;
            newId = mbgMemberInfo.getId() != null ? mbgMemberInfo.getId().toString() : null;
            oldId = mbgMemberInfo.getParent() != null && mbgMemberInfo.getParent().getId() != null ? mbgMemberInfo.getParent().getId().toString() : null;
            newName = mbgMemberInfo.getName();
            oldName = mbgMemberInfo.getParent() != null ? mbgMemberInfo.getParent().getName() : null;
            newIntId = String.valueOf(mbgMemberInfo.getIntID());
            oldIntId = String.valueOf(MbgMemberFactory.getLocalInstance((Context)ctx).getMbgMemberInfo("select intId where id = '" + mbgMemberInfo.getParent().getId() + "'").getIntID());
        } else if (model instanceof BgAccountInfo) {
            BgAccountInfo accountInfo = (BgAccountInfo)model;
            refField = DimensionBaseConstants.DEF_BGINDEX_FIELD;
            srcNumber = DimensionBaseConstants.DEF_INDEX_SRCNUMBER;
            BgAccountViewInfo bgAccountView = accountInfo.getBgAccountView();
            viewId = bgAccountView != null ? bgAccountView.getId().toString() : null;
            newNumber = accountInfo.getNumber();
            oldNumber = accountInfo.getParent() != null ? accountInfo.getParent().getNumber() : null;
            newId = accountInfo.getId() != null ? accountInfo.getId().toString() : null;
            oldId = accountInfo.getParent() != null && accountInfo.getParent().getId() != null ? accountInfo.getParent().getId().toString() : null;
            newName = accountInfo.getName();
            oldName = accountInfo.getParent() != null ? accountInfo.getParent().getName() : null;
            newIntId = String.valueOf(accountInfo.getIntID());
            oldIntId = String.valueOf(((BgAccountInfo)BgAccountFactory.getLocalInstance((Context)ctx).getDataBaseInfo("select intId where id = '" + accountInfo.getParent().getId() + "'")).getIntID());
        }
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put(REFFIELD, refField);
        returnMap.put(VIEWID, viewId);
        returnMap.put(SRCNUMBER, srcNumber);
        returnMap.put(NEWNUMBER, newNumber);
        returnMap.put(OLDNUMBER, oldNumber);
        returnMap.put(NEWID, newId);
        returnMap.put(OLDID, oldId);
        returnMap.put(NEWNAME, newName);
        returnMap.put(OLDNAME, oldName);
        returnMap.put(FMEMBERCOMBINNUMBER, fMemberCombinNumber);
        returnMap.put(FMEMBERCOMBINNAME, fMemberCombinName);
        returnMap.put(FINDEXMEMBERNUMBER, fIndexMemberNumber);
        returnMap.put(FINDEXMEMBERNAME, fIndexMemberName);
        returnMap.put(FITEMFORMULA, fItemFormula);
        returnMap.put(NEWINTID, newIntId);
        returnMap.put(OLDINTID, oldIntId);
        return returnMap;
    }

    private static MbgDimInfo handleMbgDimInfo(MbgDimInfo mbgDim, Context ctx) throws Exception {
        if (mbgDim == null || mbgDim.getId() == null || ctx == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"handleMbgDimInfo"});
        }
        MbgDimInfo mbgDimInfo = MbgDimFactory.getLocalInstance((Context)ctx).getMbgDimInfo((IObjectPK)new ObjectUuidPK(mbgDim.getId()));
        return mbgDimInfo;
    }

    private static void executeMigrationByViewAndRef(Map<String, List<String>> refCubeMap, String refField, String srcNumber, String newNumber, String oldNumber, String newIntId, String oldIntId, Connection connection) throws Exception {
        if (StringUtils.isEmpty((String)refField) || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)newNumber) || StringUtils.isEmpty((String)oldNumber) || connection == null || refCubeMap == null || refCubeMap.get(REF_CUBE) == null || refCubeMap.get(REF_CUBE).size() == 0 || newIntId == null || oldIntId == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeMigrationByViewAndRef"});
        }
        Object sql = null;
        List<String> refCubeList = refCubeMap.get(REF_CUBE);
        String itemComination = "FBgItemCombination";
        String formula = "FFormula";
        String oldDimString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        String replaceItemComination = BgMigrationUtil.getReplace(itemComination);
        String replaceFormula = BgMigrationUtil.getReplace(formula);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] objArray = new Object[]{oldDimString, newDimString, oldDimString, newDimString, newDimString, oldDimString};
        params.add(objArray);
        ArrayList<Object[]> intParams = new ArrayList<Object[]>();
        Integer newInt = Integer.parseInt(newIntId);
        Integer oldInt = Integer.parseInt(oldIntId);
        if (newInt <= 0 || oldInt <= 0) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeMigrationByViewAndRef"});
        }
        objArray = new Object[]{oldDimString, newDimString, oldDimString, newDimString, newInt, oldInt};
        intParams.add(objArray);
        String itemComEquation = BgMigrationUtil.getEquation(itemComination, replaceItemComination);
        String formulaEquation = BgMigrationUtil.getEquation(formula, replaceFormula);
        for (int i = 0; i < refCubeList.size(); ++i) {
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 1, itemComEquation, formulaEquation, refField, params, intParams);
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 128, itemComEquation, formulaEquation, refField, params, intParams);
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 64, itemComEquation, formulaEquation, refField, params, intParams);
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 256, itemComEquation, formulaEquation, refField, params, intParams);
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 512, itemComEquation, formulaEquation, refField, params, intParams);
            BgMigrationUtil.executeMigrationByViewAndRef(connection, refCubeList.get(i), 1024, itemComEquation, formulaEquation, refField, params, intParams);
        }
    }

    private static void executeMigrationByViewAndRef(Connection conn, String refCube, int valueType, String itmComEquation, String formulaEquation, String refField, List params, List intParams) throws BOSException {
        if (StringUtils.isEmpty((String)refCube)) {
            return;
        }
        if (StringUtils.isEmpty((String)(refCube = BgCubeUtils.getCubeName(refCube, valueType)))) {
            return;
        }
        boolean isUseInt = BgSchemeConvertToAccIntUtils.isUseAccIntByRefCube(conn, refCube);
        HashSet<String> cubeNames = new HashSet<String>();
        if (isUseInt) {
            try {
                cubeNames.addAll(BgSchemeConvertToAccIntUtils.querySplit(conn, refCube).values());
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        } else {
            cubeNames.add(refCube);
        }
        for (String cubeName : cubeNames) {
            if (BgDBUtils.existTable((Connection)conn, (String)cubeName) != BgDBUtils.YES) {
                return;
            }
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ");
            sql.append(cubeName);
            sql.append(" SET ");
            sql.append(itmComEquation);
            sql.append(",");
            sql.append(formulaEquation);
            sql.append(",");
            sql.append(refField + "= ?");
            sql.append(" WHERE ");
            sql.append(refField + "= ?");
            try {
                if (isUseInt) {
                    MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (List)intParams);
                    continue;
                }
                MbgSqlHelper.executeBatch((Connection)conn, (String)sql.toString(), (List)params);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
    }

    private static String toControlTable(String bgDataTableName) {
        return BgCubeUtils.getControlCubeName(bgDataTableName);
    }

    private static String toBgDailyActData(String bgDataTableName) {
        return BgCubeUtils.getDailyActualCubeName(bgDataTableName);
    }

    private static Map<String, List<String>> getRefCubeMap(Connection connection, String viewId) throws Exception {
        if (connection == null || StringUtils.isEmpty((String)viewId)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"getRefCubeList"});
        }
        ArrayList<String> RefCubeList = new ArrayList<String>();
        ArrayList<String> idList = new ArrayList<String>();
        ResultSet rs = null;
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT scheme.FRefCube refcube,scheme.FID id FROM ");
        sql.append("T_MBG_BGDIMSETTINGSMEMBER member,T_MBG_BGDIMSETTINGS se,T_MBG_BGSCHEME scheme ");
        sql.append("WHERE member.FBgDimSettingsID=se.FID AND se.FBgSchemeID=scheme.FID AND member.FMEMBERID = ? ");
        rs = MbgSqlHelper.batchExecuteQuery((Connection)connection, (String)sql.toString(), (Object[])new String[]{viewId});
        if (rs == null) {
            return null;
        }
        while (rs.next()) {
            if (rs != null && !StringUtils.isEmpty((String)rs.getString(REF_CUBE))) {
                RefCubeList.add(rs.getString(REF_CUBE));
            }
            if (rs == null || StringUtils.isEmpty((String)rs.getString(ID))) continue;
            idList.add(rs.getString(ID));
        }
        HashMap<String, List<String>> returnMap = new HashMap<String, List<String>>();
        returnMap.put(REF_CUBE, RefCubeList != null && RefCubeList.size() != 0 ? RefCubeList : null);
        returnMap.put(ID, idList != null && idList.size() != 0 ? idList : null);
        return returnMap;
    }

    private static String getEquation(String left, String right) throws Exception {
        if (StringUtils.isEmpty((String)left) || StringUtils.isEmpty((String)right)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"getEquation"});
        }
        return left + "=" + right;
    }

    private static String getReplace(String colunm) throws Exception {
        if (StringUtils.isEmpty((String)colunm)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"getReplace"});
        }
        StringBuilder replace = new StringBuilder();
        replace.append("replace(");
        replace.append(colunm);
        replace.append(",?,?)");
        return replace.toString();
    }

    private static String getDimNumberString(String colunm, String value) throws Exception {
        if (StringUtils.isEmpty((String)colunm) || StringUtils.isEmpty((String)value)) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"getDimString"});
        }
        return colunm + ":" + value;
    }

    public static void alterRefDimMember(Connection connection, Map<String, String> modelMap) throws Exception {
        if (connection == null || modelMap == null || StringUtils.isEmpty((String)modelMap.get(NEWID)) || StringUtils.isEmpty((String)modelMap.get(OLDID))) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterRefDimMember"});
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] objArray = new Object[]{modelMap.get(NEWID), modelMap.get(OLDID)};
        params.add(objArray);
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE T_MBG_BgRefDimMember SET FBaseDataID = ? ");
        sql.append("WHERE FBaseDataID = ?");
        try {
            MbgSqlHelper.executeBatch((Connection)connection, (String)sql.toString(), params);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    public static boolean isExistTmpData(Connection connection, Map<String, String> modelMap) throws Exception {
        if (connection == null || modelMap == null || StringUtils.isEmpty((String)modelMap.get(SRCNUMBER)) || StringUtils.isEmpty((String)modelMap.get(OLDNUMBER))) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"isExistTmpData"});
        }
        Map<String, List<String>> refCubeMap = BgMigrationUtil.getRefCubeMap(connection, modelMap.get(VIEWID));
        List<String> idList = refCubeMap.get(ID);
        if (idList == null || idList.size() == 0) {
            return false;
        }
        String dimString = BgMigrationUtil.getDimNumberString(modelMap.get(SRCNUMBER), modelMap.get(OLDNUMBER));
        boolean isExistTmpData = false;
        if (!StringUtils.isEmpty((String)dimString)) {
            PreparedStatement pstmt;
            ResultSet rs;
            block10: {
                rs = null;
                pstmt = null;
                try {
                    int i;
                    StringBuilder sql = new StringBuilder();
                    sql.append("SELECT TOP 1 FFORMULA FROM T_MBG_BGTMPDATA WHERE LEFT(FFORMULA,CHARINDEX('\",\"',FFORMULA)-1)||',' LIKE ?");
                    sql.append(" AND FBGSCHEMEROOTID IN (");
                    for (i = 0; i < idList.size(); ++i) {
                        if (i == 0) {
                            sql.append("?");
                            continue;
                        }
                        sql.append(",?");
                    }
                    sql.append(")");
                    pstmt = connection.prepareStatement(sql.toString());
                    pstmt.setString(1, "%" + dimString + ",%");
                    for (i = 2; i < idList.size() + 2; ++i) {
                        pstmt.setString(i, idList.get(i - 2));
                    }
                    rs = pstmt.executeQuery();
                    if (!rs.next()) break block10;
                    isExistTmpData = true;
                }
                catch (Exception e) {
                    try {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        throw new BOSException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, pstmt);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        }
        return isExistTmpData;
    }

    public static void alterBgPastData(Connection connection, IObjectValue model, Map<String, String> modelMap) throws Exception {
        if (connection == null || model == null || modelMap == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"alterBgPastData"});
        }
        BgMigrationUtil.executeUpdateBgPastData(connection, modelMap.get(REFFIELD), modelMap.get(VIEWID), modelMap.get(SRCNUMBER), modelMap.get(NEWNUMBER), modelMap.get(OLDNUMBER));
    }

    private static void executeUpdateBgPastData(Connection connection, String refField, String viewId, String srcNumber, String newNumber, String oldNumber) throws BgAccountException, Exception, SQLException {
        if (StringUtils.isEmpty((String)viewId) || StringUtils.isEmpty((String)refField) || StringUtils.isEmpty((String)srcNumber) || StringUtils.isEmpty((String)newNumber) || StringUtils.isEmpty((String)oldNumber) || connection == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"executeMigrationByViewAndRef"});
        }
        StringBuilder sql = null;
        String formula = "FFormula";
        String oldDimString = BgMigrationUtil.getDimNumberString(srcNumber, oldNumber);
        String newDimString = BgMigrationUtil.getDimNumberString(srcNumber, newNumber);
        sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append("T_MBG_BgPastData ");
        sql.append(" SET ");
        sql.append(BgMigrationUtil.getEquation(formula, BgMigrationUtil.formulaValueForUpdate(formula)));
        PreparedStatement pstmt = null;
        try {
            pstmt = connection.prepareStatement(sql.toString());
            pstmt.setString(1, oldDimString);
            pstmt.setString(2, newDimString);
            pstmt.setString(3, oldDimString);
            pstmt.setString(4, newDimString);
            pstmt.executeUpdate();
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(pstmt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)pstmt);
    }

    public static Map checkBgData(Context ctx, Connection connection, IObjectValue model, boolean isSelf) throws Exception {
        BgAccountInfo bgAccountInfo;
        MbgMemberInfo mbgMemberInfo;
        if (connection == null || model == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"checkBgData"});
        }
        if (model instanceof MbgMemberInfo ? (mbgMemberInfo = (MbgMemberInfo)model).getParent() == null : model instanceof BgAccountInfo && (bgAccountInfo = (BgAccountInfo)model).getParent() == null) {
            return null;
        }
        Map<String, String> modelMap = BgMigrationUtil.handleModel(model, ctx);
        if (modelMap == null) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"checkBgData"});
        }
        Map<String, List<String>> refCubeMap = BgMigrationUtil.getRefCubeMap(connection, modelMap.get(VIEWID));
        if (refCubeMap == null || refCubeMap.get(REF_CUBE) == null || refCubeMap.get(REF_CUBE).size() == 0) {
            return null;
        }
        Map refIds = null;
        refIds = BgMigrationUtil.queryBgData(ctx, connection, modelMap, refCubeMap.get(REF_CUBE), isSelf);
        return refIds;
    }

    private static Map queryBgData(Context ctx, Connection connection, Map<String, String> modelMap, List<String> tableList, boolean isSelf) throws Exception {
        BgCubeUtils.checkTable(connection);
        if (connection == null || modelMap == null || tableList == null || StringUtils.isEmpty((String)modelMap.get(OLDNUMBER)) || StringUtils.isEmpty((String)modelMap.get(REFFIELD)) || StringUtils.isEmpty((String)modelMap.get(SRCNUMBER))) {
            throw new BgAccountException(BgAccountException.ARGUMENTSISNULL, new Object[]{"queryBgData"});
        }
        if (tableList.size() == 0) {
            return null;
        }
        HashSet<String> refIds = null;
        HashSet<String> keys = null;
        StringBuilder sql = new StringBuilder();
        String refField = modelMap.get(REFFIELD);
        String dimString = null;
        String memberNumber = null;
        String viewId = modelMap.get(VIEWID);
        int intId = -1;
        if (isSelf) {
            memberNumber = modelMap.get(NEWNUMBER);
            dimString = BgMigrationUtil.getDimNumberString(modelMap.get(SRCNUMBER), memberNumber);
        } else {
            memberNumber = modelMap.get(OLDNUMBER);
            dimString = BgMigrationUtil.getDimNumberString(modelMap.get(SRCNUMBER), memberNumber);
        }
        if (StringUtils.isEmpty((String)dimString)) {
            return null;
        }
        int paramCount = 0;
        String tableName = null;
        ArrayList<String> tablNameList = new ArrayList<String>();
        ArrayList allTablNameList = new ArrayList();
        for (int i = 0; i < tableList.size(); ++i) {
            if (i != 0) {
                sql.append(" UNION ALL ");
            }
            tableName = tableList.get(i);
            BgMigrationUtil.dealTableNameList(connection, tableName, tablNameList);
            for (int j = 0; j < tablNameList.size(); ++j) {
                if (BgDBUtils.existTable((Connection)connection, (String)((String)tablNameList.get(j))) != BgDBUtils.YES) continue;
                if (j != 0) {
                    sql.append(" UNION ALL ");
                }
                allTablNameList.add(tablNameList.get(j));
                BgMigrationUtil.dealSql(ctx, connection, sql, refField, (String)tablNameList.get(j));
                ++paramCount;
            }
        }
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String id = null;
        String orgID = null;
        Object longNumber = null;
        Object number = null;
        Object name = null;
        FullOrgUnitInfo orgUnitInfo = null;
        HashSet<FullOrgUnitInfo> infos = null;
        HashSet orgIds = new HashSet();
        HashMap tableNameDataIdMap = new HashMap();
        HashMap<String, String> tableViewMap = new HashMap<String, String>();
        HashMap orgIntMap = new HashMap();
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String orgIdTmpTable = null;
        try {
            pstmt = refField.equals(DimensionConstants.DEF_BGINDEX_FIELD) ? connection.prepareStatement("select FIntId FROM T_MBG_BgAccount Where FBgAccountViewId = ? and FNumber = ?") : connection.prepareStatement("select FIntId FROM T_MBG_MbgMember Where FViewId = ? and FNumber = ?");
            pstmt.setString(1, viewId);
            pstmt.setString(2, memberNumber);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                intId = rs.getInt(1);
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            pstmt = connection.prepareStatement("Select bgScheme.FRefCube, dimMember.FMemberId FROM T_MBG_BgDimSettingsMember dimMember Inner Join T_MBG_BgDimSettings dimSettings ON dimMember.FbgDimSettingsId = dimSettings.FID Inner Join T_MBG_BgScheme bgScheme ON bgScheme.FID = dimSettings.FBgSchemeId Where dimMember.FType = 2 AND dimSettings.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "'");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                tableViewMap.put(rs.getString("FRefCube").toUpperCase(), rs.getString("FMemberId"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            pstmt = connection.prepareStatement("Select FViewId, FIntId, FOrgUnitId FROM T_MBG_BgOrgUnit Where FIsVirtual = 0 AND FViewId IN(Select FMemberId FROM T_MBG_BgDimSettingsMember Where FType = 2 AND FbgDimSettingsId IN(Select FID FROM T_MBG_BgDimSettings Where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' AND FBgSchemeId IN(Select FID FROM T_MBG_BGScheme Where FUseAccInt > 0)))");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String orgViewId = rs.getString("FViewId");
                if (!orgIntMap.containsKey(orgViewId)) {
                    orgIntMap.put(orgViewId, new HashMap());
                }
                ((Map)orgIntMap.get(orgViewId)).put(rs.getString("FIntId"), rs.getString("FOrgUnitId"));
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            pstmt = connection.prepareStatement(sql.toString());
            for (int i = 0; i < paramCount; ++i) {
                tableName = (String)allTablNameList.get(i);
                if (BgSchemeConvertToAccIntUtils.isAccIntTable(tableName)) {
                    pstmt.setInt(i + 1, intId);
                    continue;
                }
                pstmt.setString(i + 1, dimString);
            }
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String orgViewId;
                id = rs.getString("dataID");
                tableName = rs.getString("tableName");
                orgID = rs.getString("FOrgUnitId");
                if (BgSchemeConvertToAccIntUtils.isAccIntTable(tableName) && ((orgViewId = (String)tableViewMap.get(tableName = "T_MBG_BGDATA" + BgSchemeConvertToAccIntUtils.getCodeNumber(tableName))) == null || orgIntMap.get(orgViewId) == null || (orgID = (String)((Map)orgIntMap.get(orgViewId)).get(orgID)) == null)) continue;
                if (refIds == null) {
                    refIds = new HashSet<String>();
                }
                if (keys == null) {
                    keys = new HashSet<String>();
                }
                if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)tableName)) continue;
                refIds.add(id);
                if (!keys.contains(orgID)) {
                    keys.add(orgID);
                }
                if (!tableNameDataIdMap.containsKey(tableName)) {
                    tableNameDataIdMap.put(tableName, new HashSet());
                }
                ((Set)tableNameDataIdMap.get(tableName)).add(id);
            }
            if (infos == null) {
                infos = new HashSet<FullOrgUnitInfo>();
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
            orgIdTmpTable = BgDBUtils.insertKey((TempTablePool)pool, (Connection)connection, keys);
            pstmt = connection.prepareStatement("Select FID, FLongNumber, FNumber, FName_" + ctx.getLocale() + " FOrgName FROM T_ORG_CostCenter Where FID IN(Select FID FROM " + orgIdTmpTable + ")");
            rs = pstmt.executeQuery();
            while (rs.next()) {
                orgUnitInfo = new FullOrgUnitInfo();
                orgUnitInfo.setId(BOSUuid.read((String)rs.getString("FID")));
                orgUnitInfo.setLongNumber(rs.getString("FLongNumber"));
                orgUnitInfo.setNumber(rs.getString("FNumber"));
                orgUnitInfo.setName(rs.getString("FOrgName"));
                infos.add(orgUnitInfo);
            }
        }
        catch (Exception e) {
            try {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt);
                BgDBUtils.releaseTmpTable((TempTablePool)pool, orgIdTmpTable);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt);
        BgDBUtils.releaseTmpTable((TempTablePool)pool, (String)orgIdTmpTable);
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        map.put(DATAIDSET, refIds);
        map.put(ORGUNITINFOSET, infos);
        return map;
    }

    private static void dealTableNameList(Connection conn, String tableName, List<String> tablNameList) throws BOSException {
        if (!tablNameList.isEmpty()) {
            tablNameList.clear();
        }
        tablNameList.add(tableName);
        if (BgSchemeConvertToAccIntUtils.isUseAccIntByRefCube(conn, tableName)) {
            tablNameList.remove(tableName);
            try {
                tablNameList.addAll(new HashSet<String>(BgSchemeConvertToAccIntUtils.querySplit(conn, tableName).values()));
            }
            catch (SQLException e) {
                logger.error((Object)"", (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        tablNameList.add(BgCubeUtils.getCubeName(tableName, 16));
        tablNameList.add(BgCubeUtils.getCubeName(tableName, 256));
        tablNameList.add(BgCubeUtils.getCubeName(tableName, 512));
        tablNameList.add(BgCubeUtils.getCubeName(tableName, 1024));
    }

    private static void dealSql(Context ctx, Connection connection, StringBuilder sql, String refField, String tableName) {
        sql.append(" SELECT t.FID dataID, '" + tableName + "' tableName, t.FOrgUnitId || '' FOrgUnitId FROM ");
        sql.append(tableName + " t ");
        sql.append(" WHERE ");
        sql.append(refField);
        sql.append(" = ? ");
    }
}

