/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.app.data;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.ma.base.app.utils.IResultReader;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.base.utils.BgDBUtils;
import com.kingdee.eas.ma.base.utils.DimensionBaseConstants;
import com.kingdee.eas.ma.biz.BizCalcInfo;
import com.kingdee.eas.ma.biz.BizCalcSubsetInfo;
import com.kingdee.eas.ma.biz.BizScopeInfo;
import com.kingdee.eas.ma.biz.ParseException;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.MbgExprParseHelper;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.FunctionExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MdxMemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.MemberExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.NameExpr;
import com.kingdee.eas.ma.biz.execute.calc.impl.expr.expr.VariateExpr;
import com.kingdee.eas.ma.biz.expr.face.IExpress;
import com.kingdee.eas.ma.biz.utils.BizConstants;
import com.kingdee.eas.ma.control.BgControlSettingInfo;
import com.kingdee.eas.ma.mbg.BgExamineInfo;
import com.kingdee.eas.ma.mbg.BgOrgUnitInfo;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgScopeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgTemplateNodeInfo;
import com.kingdee.eas.ma.mbg.DimensionRelationshipInfo;
import com.kingdee.eas.ma.mbg.MbgFunctionHelper;
import com.kingdee.eas.ma.mbg.app.olap.accintolap.BgSchemeAccIntHelper;
import com.kingdee.eas.ma.mbg.common.BgDimensionBaseInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewListObject;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionInfo;
import com.kingdee.eas.ma.mbg.common.MbgViewListDimensionManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListRowCol;
import com.kingdee.eas.ma.mbg.common.MbgViewListSheetManager;
import com.kingdee.eas.ma.mbg.common.MbgViewListXMLParser;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.cube.BgCubeUtils;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.dimension.utils.DimUtils;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyHelper;
import com.kingdee.eas.ma.mbg.update820to850.app.utils.MbgUpdateDataBaseCopyInfo;
import com.kingdee.eas.ma.mbg.utils.BgAnalyseHelper;
import com.kingdee.eas.ma.mbg.utils.DimensionCommonHelper;
import com.kingdee.eas.ma.mbg.utils.ViewlistCombinHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BgOrgMigrationUtils
implements Serializable {
    private static final long serialVersionUID = 9179561352931701566L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.ma.mbg.app.data.BgOrgMigraitonUtils");
    public static final String BGCONTROLRECORD_TYPE = "87500EF6";
    public static final String UPDATEBGVARIATE = "updateBgVariate";
    public static final String UPDATEDIMENSIONRELATION = "updateDimensionRelation";
    public static final String UPDATEBGTEMPLATE = "updateBgTemplate";
    public static final String UPDATEBIZCALC = "updateBizCalc";
    public static final String UPDATEBGEXAMINE = "updateBgExamine";
    public static final String UPDATEBUDGETANDACTUALFORM = "updateBudgetAndActualForm";
    public static final String UPDATEBGADJUSTBILL = "updateBgAdjustBill";
    public static final String UPDATEBGSCHEMEINTEGRATION = "updateBgSchemeIntegration";
    public static final String UPDATEBGCONTROLORGENTRUST = "updateBgControlOrgEntrust";
    public static final String UPDATEBGCONTROLSETTING = "updateBgControlSetting";
    public static final String UPDATEBGCONTROLRECORD = "updateBgControlRecord";

    public static List<BgSchemeInfo> getBgSchemesByViewId(Context ctx, String viewId, String dimNumber) throws SQLException {
        ArrayList<BgSchemeInfo> bgSchemes = new ArrayList<BgSchemeInfo>();
        if (viewId == null) {
            return bgSchemes;
        }
        String sql = "select FID,FNumber,FName_" + ctx.getLocale() + ",FRefCube from T_MBG_BgScheme where FID in (Select sett.FBgSchemeId FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID Where sett.FDimNumber = ?  AND settMember.FMemberId = ?) ";
        IRowSet result = BgDBUtils.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{dimNumber, viewId});
        Object bgSchemeId = null;
        BgSchemeInfo bgSchemeInfo = null;
        while (result.next()) {
            bgSchemeInfo = new BgSchemeInfo();
            bgSchemeInfo.setId(BOSUuid.read((String)result.getString(1)));
            bgSchemeInfo.setNumber(result.getString(2));
            bgSchemeInfo.setName(result.getString(3));
            bgSchemeInfo.setRefCube(result.getString(4));
            bgSchemes.add(bgSchemeInfo);
        }
        return bgSchemes;
    }

    public static boolean updateBgVariate(Context ctx, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        String sql = "update T_MBG_BgVariate set FmemberId = ?,FmemberNumber = ?,FmemberName_" + ctx.getLocale() + " = ? where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' and FmemberId = ? and FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        int in = migOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
            param = new Object[]{arrOrg[1].getId().toString(), arrOrg[1].getNumber(), arrOrg[1].getName(), arrOrg[0].getId().toString()};
            params.add(param);
        }
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)sql, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgVariate sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgVariate sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateDimensionRelation(Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        if (conn == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            final ArrayList<MbgUpdateDataBaseCopyInfo> relationList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
            HashSet<String> oldOrgUnitIds = new HashSet<String>();
            final HashMap<String, BgOrgUnitInfo> refOrgUnits = new HashMap<String, BgOrgUnitInfo>();
            int in = migOrgUnits.size();
            for (int i = 0; i < in; ++i) {
                BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                oldOrgUnitIds.add(arrOrg[0].getOrgUnitID());
                refOrgUnits.put(arrOrg[0].getOrgUnitID(), arrOrg[1]);
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" select FID,FFillterUnitID from T_MBG_DimensionRelationship ship where FDimensionGroupId in ( ").append(" select FID from T_MBG_DimensionRelationGroup where FIsLowerShow = 0 and FIsCsl = 0 and FbgSchemeId in ").append(BgOrgMigrationUtils.getbgSchemeSql(orgViewId)).append(" and FFillterUnitID in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")").append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])oldOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String oldRelationId = res.getString("FID");
                    String newRelationId = BOSUuid.create((BOSObjectType)new DimensionRelationshipInfo().getBOSType()).toString();
                    MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                    copyInfo.setWhere("FID = '" + oldRelationId + "'");
                    copyInfo.addReplace("FID", "'" + newRelationId + "'");
                    copyInfo.addReplace("FCostUnitID", "'" + ((BgOrgUnitInfo)refOrgUnits.get(res.getString("FFillterUnitID"))).getOrgUnitID() + "'");
                    copyInfo.addReplace("FFillterUnitID", "'" + ((BgOrgUnitInfo)refOrgUnits.get(res.getString("FFillterUnitID"))).getOrgUnitID() + "'");
                    relationList.add(copyInfo);
                }
            });
            MbgUpdateDataBaseCopyHelper.copyDataBase(conn, "T_MBG_DimensionRelationship", relationList);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateDimensionRelation sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBgTemplate(Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        if (conn == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        HashSet<String> oldOrgUnitIds = new HashSet<String>();
        HashSet<String> newOrgUnitIds = new HashSet<String>();
        final HashMap<String, BgOrgUnitInfo> refOrgUnits = new HashMap<String, BgOrgUnitInfo>();
        int in = migOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
            oldOrgUnitIds.add(arrOrg[0].getOrgUnitID());
            newOrgUnitIds.add(arrOrg[1].getOrgUnitID());
            refOrgUnits.put(arrOrg[0].getOrgUnitID(), arrOrg[1]);
        }
        final ArrayList<MbgUpdateDataBaseCopyInfo> dataList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        final ArrayList templates = new ArrayList();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select node.FID,node.FBGTEMPLATEID,node.FOrgUnitId from T_MBg_BgTemplateNode node left join T_MBG_bgtemplate template on node.FBGTEMPLATEID  = template.Fid where template.FBGSCHEMEID in ").append(BgOrgMigrationUtils.getbgSchemeSql(orgViewId)).append(" and node.FOrgUnitID in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])oldOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String oldNodeId = res.getString("FID");
                    String newNodeId = BOSUuid.create((BOSObjectType)new BgTemplateNodeInfo().getBOSType()).toString();
                    MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                    copyInfo.setWhere("FID = '" + oldNodeId + "'");
                    copyInfo.addReplace("FID", "'" + newNodeId + "'");
                    copyInfo.addReplace("FOrgUnitId", "'" + ((BgOrgUnitInfo)refOrgUnits.get(res.getString("FOrgUnitID"))).getOrgUnitID() + "'");
                    dataList.add(copyInfo);
                    BgTemplateNodeInfo nodeInfo = new BgTemplateNodeInfo();
                    nodeInfo.setId(BOSUuid.read((String)oldNodeId));
                    BgTemplateInfo templateInfo = new BgTemplateInfo();
                    templateInfo.setId(BOSUuid.read((String)res.getString("FBGTEMPLATEID")));
                    nodeInfo.setBgTemplate(templateInfo);
                    FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)((BgOrgUnitInfo)refOrgUnits.get(res.getString("FOrgUnitID"))).getOrgUnitID()));
                    nodeInfo.setOrgUnit(orgInfo);
                    templates.add(nodeInfo);
                }
            });
            final ArrayList tempTemplate = new ArrayList();
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])newOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String newNodeId = res.getString("FID");
                    BgTemplateNodeInfo nodeInfo = new BgTemplateNodeInfo();
                    nodeInfo.setId(BOSUuid.read((String)newNodeId));
                    BgTemplateInfo templateInfo = new BgTemplateInfo();
                    templateInfo.setId(BOSUuid.read((String)res.getString("FBGTEMPLATEID")));
                    nodeInfo.setBgTemplate(templateInfo);
                    FullOrgUnitInfo orgInfo = new FullOrgUnitInfo();
                    orgInfo.setId(BOSUuid.read((String)res.getString("FOrgUnitId")));
                    nodeInfo.setOrgUnit(orgInfo);
                    tempTemplate.add(nodeInfo);
                }
            });
            for (BgTemplateNodeInfo info : templates) {
                for (BgTemplateNodeInfo tempInfo : tempTemplate) {
                    if (!info.getBgTemplate().getId().equals((Object)tempInfo.getBgTemplate().getId()) || !info.getOrgUnit().getId().equals((Object)tempInfo.getOrgUnit().getId())) continue;
                    Iterator iter = dataList.iterator();
                    while (iter.hasNext()) {
                        MbgUpdateDataBaseCopyInfo copyInfo = (MbgUpdateDataBaseCopyInfo)iter.next();
                        if (!info.getOrgUnit().getId().toString().equals(copyInfo.getReplaceMap().get("FORGUNITID").replace("'", ""))) continue;
                        iter.remove();
                    }
                }
            }
            MbgUpdateDataBaseCopyHelper.copyDataBase(conn, "T_MBg_BgTemplateNode", dataList);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgTemplate sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBizCalc(Context ctx, Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        ArrayList<BizScopeInfo> scopeInfos;
        String functionStr;
        Object[] param;
        ArrayList<Object[]> params;
        block13: {
            if (ctx == null || migOrgUnits == null || orgViewId == null) {
                return false;
            }
            String sql0 = " update T_MBG_BizScope set FBgMemberNum = ?,FBgMemberAlias = ? where FBgMemberNum = ? and FBizDataType = 1 and FBgMemberType = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + " and FBizCalcSubSetId in (select FID from T_MBG_BizCalcSubset where FBizCalcId in ( select FID from T_Mbg_bizCalc where FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ")) and not exists (select * from T_MBG_BizScope where FBgMemberNum = ?) ";
            params = new ArrayList<Object[]>();
            param = null;
            int in = migOrgUnits.size();
            for (int i = 0; i < in; ++i) {
                BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getNumber(), arrOrg[1].getName(), arrOrg[0].getNumber(), arrOrg[1].getNumber()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql0, params);
            String sql1 = " select scope.FID,scope.FBgMemberNum,scope.FBgMemberAlias,scope.FRefField,subset.FID,calc.FID,calc.FbgSchemeId from T_MBG_BizScope scope inner join T_MBG_BizCalcSubset subset on scope.FBIZCALCSUBSETID  = subset.FID  inner join T_MBG_BIzcalc calc on subset.FBIZCALCID  = calc.FID  where scope.FBizDataType = 4 and scope.FBgMemberType = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + "and scope.FBizCalcSubSetId in (select FID from T_MBG_BizCalcSubset  where FBizCalcId in ( select FID from T_Mbg_bizCalc  where FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") )";
            IRowSet rowSet = BgDBUtils.executeQuery((Context)ctx, (String)sql1);
            BizScopeInfo scopeInfo = null;
            BizCalcSubsetInfo subSetInfo = null;
            BizCalcInfo calcInfo = null;
            BgSchemeInfo schemeInfo = null;
            functionStr = null;
            scopeInfos = new ArrayList<BizScopeInfo>();
            while (rowSet.next()) {
                scopeInfo = new BizScopeInfo();
                scopeInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                scopeInfo.setBgMemberNum(rowSet.getString(2));
                scopeInfo.setBgMemberAlias(rowSet.getString(3));
                scopeInfo.setRefField(rowSet.getString(4));
                subSetInfo = new BizCalcSubsetInfo();
                subSetInfo.setId(BOSUuid.read((String)rowSet.getString(5)));
                calcInfo = new BizCalcInfo();
                calcInfo.setId(BOSUuid.read((String)rowSet.getString(6)));
                schemeInfo = new BgSchemeInfo();
                schemeInfo.setId(BOSUuid.read((String)rowSet.getString(7)));
                calcInfo.setBgScheme(schemeInfo);
                subSetInfo.setBizCalc(calcInfo);
                scopeInfo.setBizCalcSubset(subSetInfo);
                scopeInfos.add(scopeInfo);
            }
            if (scopeInfos != null && !scopeInfos.isEmpty()) break block13;
            boolean bl = true;
            return bl;
        }
        try {
            String buildFunctionStr = null;
            for (BizScopeInfo info : scopeInfos) {
                functionStr = info.getBgMemberNum();
                buildFunctionStr = BgOrgMigrationUtils.dealBizCalcFunctionStr(functionStr, migOrgUnits);
                info.setBgMemberNum(buildFunctionStr);
                info.setBgMemberAlias(buildFunctionStr);
            }
            String sql3 = "update T_MBG_BizScope set FBgMemberNum = ?,FBgMemberAlias = ? where FId = ?  and not exists (select * from T_MBG_BizScope where FBgMemberNum = ?)";
            params.clear();
            for (BizScopeInfo info : scopeInfos) {
                param = new Object[]{info.getBgMemberNum(), info.getBgMemberAlias(), info.getId().toString(), info.getBgMemberNum()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql3, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBizCalc sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBizCalc sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"bgOrgMigration updateBizCalc sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"bgOrgMigration updateBizCalc sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static String dealBizCalcFunctionStr(String functionStr, List migOrgUnits) throws Exception {
        if (functionStr == null || migOrgUnits == null) {
            return null;
        }
        IExpress expr = MbgExprParseHelper.parse((String)functionStr);
        Object funParam = null;
        String dimNumber = null;
        String buildFunctionStr = null;
        String planString1 = null;
        String planString2 = null;
        if (expr instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expr;
            if (functionExpr.functionName.equalsIgnoreCase("Remove")) {
                if (functionExpr.params.size() == 2) {
                    planString1 = BgOrgMigrationUtils.convertFunctionExpr(functionExpr.params.get(0), migOrgUnits);
                    planString2 = BgOrgMigrationUtils.convertFunctionExpr(functionExpr.params.get(1), migOrgUnits);
                    buildFunctionStr = BgOrgMigrationUtils.buildRemoveFunctionStr(functionExpr.functionName, planString1, planString2);
                } else {
                    buildFunctionStr = BgOrgMigrationUtils.convertRemoveMember(migOrgUnits, functionStr);
                }
            } else {
                funParam = functionExpr.params.get(0);
                if (funParam instanceof String) {
                    dimNumber = funParam;
                } else if (funParam instanceof MemberExpr) {
                    MemberExpr memberExpr = funParam;
                    dimNumber = memberExpr.getDimNumber();
                }
                dimNumber = DimUtils.getNumber(dimNumber);
                int in = migOrgUnits.size();
                for (int i = 0; i < in; ++i) {
                    BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                    if (!arrOrg[0].getNumber().equals(dimNumber)) continue;
                    dimNumber = arrOrg[1].getNumber();
                    break;
                }
                buildFunctionStr = functionExpr.functionName.equalsIgnoreCase("Children") || functionExpr.functionName.equalsIgnoreCase("IChildrens") || functionExpr.functionName.equalsIgnoreCase("Descendants") || functionExpr.functionName.equalsIgnoreCase("IDescendants") ? MbgFunctionHelper.buildFunctionStr("@" + functionExpr.functionName, DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER, dimNumber, functionExpr.params.get(1).toString()) : MbgFunctionHelper.buildFunctionStr("@" + functionExpr.functionName, DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER, dimNumber);
            }
        }
        return buildFunctionStr;
    }

    private static String buildRemoveFunctionStr(String functionName, String planString1, String planString2) {
        if (functionName == null || planString1 == null || planString2 == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        str.append("@").append(functionName).append("(").append("L1:");
        if (planString1.contains("MBR")) {
            BgOrgMigrationUtils.splitFunctionStr(planString1, str);
        } else if (!planString1.contains("FX")) {
            str.append("FX").append(":").append("[").append(planString1).append("]");
        } else {
            str.append(planString1);
        }
        str.append(",").append("L2:");
        if (planString2.contains("MBR")) {
            BgOrgMigrationUtils.splitFunctionStr(planString2, str);
        } else if (!planString2.contains("FX")) {
            str.append("FX").append(":").append("[").append(planString2).append("]");
        } else {
            str.append(planString2);
        }
        str.append(")");
        return str.toString();
    }

    private static void splitFunctionStr(String planString, StringBuffer str) {
        str.append(planString.substring(0, planString.indexOf("[") + 1));
        str.append(DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER).append(":");
        String dimNumbers = planString.substring(planString.indexOf("[") + 1, planString.indexOf("]"));
        dimNumbers = dimNumbers.replace("\"", "");
        String[] nums = dimNumbers.split(",");
        int in = nums.length;
        for (int i = 0; i < in; ++i) {
            str.append(nums[i].split(":")[1]).append(",");
        }
        str.delete(str.length() - 1, str.length());
        str.append("]");
    }

    private static String convertFunctionExpr(Object obj, List migOrgUnits) {
        String planString = null;
        if (obj instanceof FunctionExpr) {
            FunctionExpr exprStr = (FunctionExpr)obj;
            planString = BgOrgMigrationUtils.convertRemoveMember(migOrgUnits, exprStr.getOriginalExpr());
        } else if (obj instanceof MdxMemberExpr) {
            MdxMemberExpr exprStr = (MdxMemberExpr)obj;
            planString = BgOrgMigrationUtils.convertRemoveMember(migOrgUnits, exprStr.getOriginalExpr());
        } else if (obj instanceof VariateExpr) {
            VariateExpr exprStr = (VariateExpr)obj;
            planString = exprStr.toString();
        } else if (obj instanceof NameExpr) {
            NameExpr exprStr = (NameExpr)obj;
            planString = BgOrgMigrationUtils.convertRemoveMember(migOrgUnits, exprStr.toString());
        }
        return planString;
    }

    private static String convertRemoveMember(List migOrgUnits, String planString) {
        String str = null;
        String replaceStr = null;
        int in = migOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
            str = "\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + arrOrg[0].getNumber() + "\"";
            replaceStr = "\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + arrOrg[1].getNumber() + "\"";
            if (planString == null || !planString.contains(str)) continue;
            planString = planString.replace(str, replaceStr);
        }
        return planString;
    }

    public static boolean updateBgExamine(Context ctx, Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            String sql0 = "update T_Mbg_bgScope set  FBgMemberNum = ?,FBgMemberAlias = ? where FBgMemberNum = ? and FBizDataType = 1 and FBgMemberType = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + "  and FbgExamineId in (select FID from T_mBG_bgExamine where FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") and not exists (select * from T_Mbg_bgScope where FBgMemberNum = ?)";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Object[] param = null;
            ArrayList<String> formulaNumbers = new ArrayList<String>();
            ArrayList<Object[]> formulaParams = new ArrayList<Object[]>();
            String formulaNumber = null;
            HashMap<String, String> refNumber = new HashMap<String, String>();
            int in = migOrgUnits.size();
            for (int i = 0; i < in; ++i) {
                BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getNumber(), arrOrg[1].getName(), arrOrg[0].getNumber(), arrOrg[1].getNumber()};
                params.add(param);
                formulaNumbers.add("\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + arrOrg[0].getNumber() + "\"");
                refNumber.put(arrOrg[0].getNumber(), arrOrg[1].getNumber());
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql0, params);
            String sqlBuff = "select subset.FID,subset.FFormula from T_MBG_BgExamineSubset subset left join T_mBG_bgExamine exam on subset.FBGEXAMINEID = exam.FID where exam.FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            IRowSet res = BgDBUtils.executeQuery((Context)ctx, (String)sqlBuff);
            while (res.next()) {
                String id = res.getString("FID");
                String formula = (String)BgAnalyseHelper.getObject(BgDBUtils.getBytes((ResultSet)res, (String)"FFormula"));
                int in2 = formulaNumbers.size();
                for (int i = 0; i < in2; ++i) {
                    formulaNumber = (String)formulaNumbers.get(i);
                    if (formula == null || !formula.contains(formulaNumber)) continue;
                    String str = formulaNumber.substring(formulaNumber.indexOf(":") + 1, formulaNumber.lastIndexOf("\""));
                    String replaceStr = "\"" + DimensionBaseConstants.DEF_ORGUNIT_SRCNUMBER + ":" + (String)refNumber.get(str) + "\"";
                    byte[] _bytes = BgAnalyseHelper.getBytes(formula.replace(formulaNumber, replaceStr));
                    param = new Object[]{_bytes, id};
                    formulaParams.add(param);
                }
            }
            String sql = "update T_MBG_BgExamineSubset set FFormula = ? where FID = ?";
            BgDBUtils.executeBatch((Context)ctx, (String)sql, formulaParams);
            String sql1 = "select scope.FID,scope.FBgMemberNum,scope.FBgMemberAlias,scope.FRefField,exam.FID,exam.FbgSchemeId from T_Mbg_bgScope scope left join T_mBG_bgExamine exam on exam.FID = scope.FBgexamineId  where scope.FBizDataType = 4 and scope.FBgMemberType = " + BizConstants.BIZ_BGORGUNIT_TYPE_VALUE + "  and scope.FBgexamineId in ( select FID from T_mBG_bgExamine where FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ")";
            IRowSet rowSet = BgDBUtils.executeQuery((Context)ctx, (String)sql1);
            BgScopeInfo scopeInfo = null;
            BgExamineInfo examineInfo = null;
            BgSchemeInfo schemeInfo = null;
            HashSet<BgScopeInfo> scopeInfos = new HashSet<BgScopeInfo>();
            while (rowSet.next()) {
                scopeInfo = new BgScopeInfo();
                scopeInfo.setId(BOSUuid.read((String)rowSet.getString(1)));
                scopeInfo.setBgMemberNum(rowSet.getString(2));
                scopeInfo.setBgMemberAlias(rowSet.getString(3));
                scopeInfo.setRefField(rowSet.getString(4));
                examineInfo = new BgExamineInfo();
                examineInfo.setId(BOSUuid.read((String)rowSet.getString(5)));
                schemeInfo = new BgSchemeInfo();
                schemeInfo.setId(BOSUuid.read((String)rowSet.getString(6)));
                examineInfo.setBgScheme(schemeInfo);
                scopeInfo.setBgExamine(examineInfo);
                scopeInfos.add(scopeInfo);
            }
            if (scopeInfos == null || scopeInfos.isEmpty()) {
                return true;
            }
            String functionStr = null;
            String buildFunctionStr = null;
            for (BgScopeInfo info : scopeInfos) {
                functionStr = info.getBgMemberNum();
                buildFunctionStr = BgOrgMigrationUtils.dealBizCalcFunctionStr(functionStr, migOrgUnits);
                if (buildFunctionStr == null) continue;
                info.setBgMemberNum(buildFunctionStr);
                info.setBgMemberAlias(buildFunctionStr);
            }
            String sql3 = "update T_Mbg_bgScope set FBgMemberNum = ?,FBgMemberAlias = ? where FId = ? and not exists (select * from T_Mbg_bgScope where FbgMemberNum = ?)";
            params.clear();
            for (BgScopeInfo info : scopeInfos) {
                param = new Object[]{info.getBgMemberNum(), info.getBgMemberAlias(), info.getId().toString(), info.getBgMemberNum()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql3, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgExamine sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgExamine sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (BOSException e) {
            logger.error((Object)"bgOrgMigration updateBgExamine sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (ParseException e) {
            logger.error((Object)"bgOrgMigration updateBgExamine sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"bgOrgMigration updateBgExamine sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBudgetAndActualForm(Context ctx, Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            String sql1 = "update T_MBG_BgForm set FOrgUnitID = ? where FOrgUnitID = ? and FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            String sql2 = "update T_MBG_BgForm set FAuditOrgUnitID = ? where FAuditOrgUnitID = ? and FbgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Object[] param = null;
            HashSet<String> oldOrgUnitIds = new HashSet<String>();
            final HashMap<String, BgOrgUnitInfo> numberRef = new HashMap<String, BgOrgUnitInfo>();
            int in = migOrgUnits.size();
            for (int i = 0; i < in; ++i) {
                BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getOrgUnitID(), arrOrg[0].getOrgUnitID()};
                params.add(param);
                oldOrgUnitIds.add(arrOrg[0].getOrgUnitID());
                numberRef.put(arrOrg[0].getNumber(), arrOrg[1]);
            }
            StringBuffer sql = new StringBuffer();
            sql.append("select entry.FID,entry.FDimensionData,tp.FFormType from T_MBG_BgFormEntry entry left join T_MBG_BgForm form on entry.FBgFormId = form.FID").append(" left join T_MBG_BgTemplate tp on form.FBgTemplateID = tp.FID  where tp.FFormType in ( ").append(2).append(",").append(4).append(" ) and form.FbgSchemeId in ").append(BgOrgMigrationUtils.getbgSchemeSql(orgViewId)).append(" and form.FOrgUnitID in ( ");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            final MbgViewListXMLParser viewListParser = new MbgViewListXMLParser(ctx);
            final MbgXMLParser parser2 = new MbgXMLParser(ctx);
            final ArrayList dimensionParam = new ArrayList();
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])oldOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    try {
                        String id = res.getString("FID");
                        byte[] dimensionData = BgDBUtils.getBytes((ResultSet)res, (String)"FDimensionData");
                        int formType = res.getInt("FFormType");
                        BgOrgMigrationUtils.dimensionDataParser(numberRef, dimensionParam, id, dimensionData, formType, viewListParser, parser2, res);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"updateBudgetAndActualForm executeBatchQuery error:", (Throwable)e);
                        throw new SQLException(e);
                    }
                    catch (IOException e) {
                        logger.error((Object)"updateBudgetAndActualForm executeBatchQuery error:", (Throwable)e);
                        throw new SQLException(e);
                    }
                }
            });
            String sqll = "update T_MBG_BgFormEntry set FDimensionData = ? where FID = ?";
            BgDBUtils.executeBatch((Context)ctx, (String)sqll, dimensionParam);
            dimensionParam.clear();
            sql.setLength(0);
            String tmpSql = "update T_MBG_BgTmpData set FOrgUnitID = ? where FOrgUnitID = ? and FbgSchemeRootId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            BgDBUtils.executeBatch((Context)ctx, (String)tmpSql, params);
            tmpSql = " update T_MBG_BgComment set FOrgUnitID = ? where FOrgUnitID = ? and FbgSchemeID in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            BgDBUtils.executeBatch((Context)ctx, (String)tmpSql, params);
            sql.append("select act.FID,act.FDimensionData,tp.FFormType from T_MBG_BgActualRecord act left join T_MBG_BgForm form on act.FBgFormId = form.FID").append(" left join T_MBG_BgTemplate tp on form.FBgTemplateID = tp.FID  where tp.FFormType in ( ").append(2).append(",").append(4).append(" ) and form.FbgSchemeId in ").append(BgOrgMigrationUtils.getbgSchemeSql(orgViewId)).append(" and form.FOrgUnitID in ( ");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])oldOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    try {
                        String id = res.getString("FID");
                        byte[] dimensionData = BgDBUtils.getBytes((ResultSet)res, (String)"FDimensionData");
                        int formType = res.getInt("FFormType");
                        BgOrgMigrationUtils.dimensionDataParser(numberRef, dimensionParam, id, dimensionData, formType, viewListParser, parser2, res);
                    }
                    catch (BOSException e) {
                        logger.error((Object)"updateBudgetAndActualForm executeBatchQuery error:", (Throwable)e);
                        throw new SQLException(e);
                    }
                    catch (IOException e) {
                        logger.error((Object)"updateBudgetAndActualForm executeBatchQuery error:", (Throwable)e);
                        throw new SQLException(e);
                    }
                }
            });
            String sqlact = "update T_MBG_BgActualRecord set FDimensionData = ? where FID = ?";
            BgDBUtils.executeBatch((Context)ctx, (String)sqlact, dimensionParam);
            BgDBUtils.executeBatch((Context)ctx, (String)sql1, params);
            BgDBUtils.executeBatch((Context)ctx, (String)sql2, params);
            List<BgSchemeInfo> bgSchemes = BgOrgMigrationUtils.getBgSchemesByViewId(ctx, orgViewId, DimensionConstants.DEF_ORGUNIT_NUMBER);
            if (bgSchemes == null || bgSchemes.isEmpty()) {
                return false;
            }
            String tableName = null;
            String actualTableName = null;
            String sql3 = null;
            String sql4 = null;
            String sql5 = null;
            String sql6 = null;
            for (BgSchemeInfo info : bgSchemes) {
                tableName = info.getRefCube();
                BgSchemeAccIntHelper accIntHelper = new BgSchemeAccIntHelper(ctx, info.getId().toString(), tableName);
                actualTableName = BgCubeUtils.getDailyActualCubeName(info.getRefCube());
                if (accIntHelper.isUseAccInt()) {
                    Set<String> cubeNames = accIntHelper.getSplitTablesByAcc(null);
                    ArrayList<Object[]> intParams = new ArrayList<Object[]>();
                    for (Object[] objs : params) {
                        Object[] _objs = new Object[objs.length];
                        intParams.add(_objs);
                        for (int o = 0; o < objs.length; ++o) {
                            _objs[o] = accIntHelper.convertOrgObject((String)objs[o]);
                        }
                    }
                    for (String cubeName : cubeNames) {
                        sql3 = "update " + cubeName + " set FOrgUnitID = ? where FOrgUnitID = ? ";
                        BgDBUtils.executeBatch((Context)ctx, (String)sql3, intParams);
                        sql5 = "update " + cubeName + " set FAudOrgUnitID = ? where FAudOrgUnitID = ? ";
                        BgDBUtils.executeBatch((Context)ctx, (String)sql5, params);
                    }
                } else {
                    sql3 = "update " + tableName + " set FOrgUnitID = ? where FOrgUnitID = ? ";
                    BgDBUtils.executeBatch((Context)ctx, (String)sql3, params);
                    sql5 = "update " + tableName + " set FAudOrgUnitID = ? where FAudOrgUnitID = ? ";
                    BgDBUtils.executeBatch((Context)ctx, (String)sql5, params);
                }
                sql4 = "update " + actualTableName + " set FOrgUnitID = ? where FOrgUnitID = ? ";
                sql6 = "update " + actualTableName + " set FAudOrgUnitID = ? where FAudOrgUnitID = ? ";
                BgDBUtils.executeBatch((Context)ctx, (String)sql4, params);
                BgDBUtils.executeBatch((Context)ctx, (String)sql6, params);
            }
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBudgetAndActualForm sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBudgetAndActualForm sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"parse BgForm DimensionData error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private static void dimensionDataParser(Map<String, BgOrgUnitInfo> numberRef, List<Object[]> dimensionParam, String id, byte[] dimensionData, int formType, MbgViewListXMLParser viewListParser, MbgXMLParser parser2, ResultSet queryrst) throws BOSException {
        Object[] param = null;
        byte[] upParse = null;
        try {
            if (formType == 2) {
                MbgViewListManager viewListManager = viewListParser.parse(dimensionData);
                List sheetManagers = viewListManager.getSheetManagers();
                for (MbgViewListSheetManager manager : sheetManagers) {
                    MbgViewListDimensionManager dimensionManager = manager.getDimensionManager();
                    List<MbgViewListDimensionInfo> allDimensions = dimensionManager.getAllDimensions();
                    BgOrgMigrationUtils.convertDimension(numberRef, allDimensions);
                    MbgViewListRowCol rowObj = null;
                    List<IMbgViewListObject> rowCols = dimensionManager.getRowCols();
                    for (IMbgViewListObject rowCol : rowCols) {
                        if (rowCol == null || !(rowCol instanceof MbgViewListRowCol)) continue;
                        rowObj = (MbgViewListRowCol)rowCol;
                        if (rowObj.isCombin()) {
                            MbgViewListDimensionInfo orgDim = (MbgViewListDimensionInfo)DimensionCommonHelper.searchDimension(DimensionConstants.DEF_ORGUNIT_NUMBER, rowObj.getDimensions());
                            if (orgDim == null) continue;
                            BgOrgMigrationUtils.convertCombin(numberRef, rowObj, rowObj.getCombinMembers());
                            BgOrgMigrationUtils.convertCombin(numberRef, rowObj, rowObj.getCombinSelectMembers());
                            BgOrgMigrationUtils.convertDimensionMember(numberRef, orgDim);
                            continue;
                        }
                        List<MbgViewListDimensionInfo> dimensions = rowObj.getDimensions();
                        BgOrgMigrationUtils.convertDimension(numberRef, dimensions);
                    }
                }
                upParse = viewListParser.unParse(viewListManager);
            } else {
                IMbgViewManager viewManager = parser2.parse(dimensionData);
                List<IMbgSheetManager> sheetManagers = viewManager.getSheetManagers();
                for (IMbgSheetManager manager : sheetManagers) {
                    IBgDimensionManager dimensionManager = manager.getDimensionManager();
                    List dimension = dimensionManager.getDimension();
                    int in = dimension.size();
                    for (int i = 0; i < in; ++i) {
                        BgDimensionInfo dimensionInfo = (BgDimensionInfo)dimension.get(i);
                        if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) continue;
                        BgOrgMigrationUtils.convertDimensionMember(numberRef, dimensionInfo);
                    }
                    dimensionManager.reloadDefaultDisplayDimension();
                }
                upParse = MbgXMLParser.unParse(viewManager);
            }
            param = new Object[]{upParse, id};
            dimensionParam.add(param);
        }
        catch (Exception e) {
            logger.error((Object)"dimensionDataParser error :", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private static void convertCombin(Map<String, BgOrgUnitInfo> numberRef, MbgViewListRowCol rowCol, List<BgDimensionMember> combinMembers) {
        List<BgDimensionMember[]> memberList = ViewlistCombinHelper.getDimMembersByCombinMembers(rowCol.getDimensions(), combinMembers, false);
        BgDimensionMember member = null;
        BgDimensionMember newMember = null;
        BgDimensionMember[] com = null;
        ArrayList<BgDimensionMember> noNullList = new ArrayList<BgDimensionMember>();
        block0: for (int m = 0; m < combinMembers.size(); ++m) {
            int c;
            member = combinMembers.get(m);
            com = memberList.get(m);
            noNullList.clear();
            for (c = 0; c < com.length; ++c) {
                if (com[c] == null) continue;
                noNullList.add(com[c]);
            }
            for (c = 0; c < com.length; ++c) {
                if (com[c] == null || !DimensionConstants.DEF_ORGUNIT_NUMBER.equals(com[c].getType())) continue;
                if (!BgOrgMigrationUtils.convertMember(numberRef, com[c])) continue block0;
                newMember = ViewlistCombinHelper.getCombinMemberByDimMember(noNullList.toArray(new BgDimensionMember[0]));
                member.setAttribute(newMember.getAttribute());
                member.setNumber(newMember.getNumber());
                member.setName(newMember.getName());
                continue block0;
            }
        }
    }

    private static void convertDimension(Map<String, BgOrgUnitInfo> numberRef, List<MbgViewListDimensionInfo> allDimensions) {
        for (MbgViewListDimensionInfo dimensionInfo : allDimensions) {
            if (!DimensionConstants.DEF_ORGUNIT_NUMBER.equals(dimensionInfo.getNumber())) continue;
            BgOrgMigrationUtils.convertDimensionMember(numberRef, dimensionInfo);
        }
    }

    private static void convertDimensionMember(Map<String, BgOrgUnitInfo> numberRef, BgDimensionBaseInfo dimensionInfo) {
        List members = dimensionInfo.getMember();
        BgOrgMigrationUtils.convertMember(numberRef, members);
        List selectMembers = dimensionInfo.getSelectMembers();
        BgOrgMigrationUtils.convertMember(numberRef, selectMembers);
    }

    private static void convertMember(Map<String, BgOrgUnitInfo> numberRef, List Members) {
        BgDimensionMember member = null;
        int in = Members.size();
        for (int i = 0; i < in; ++i) {
            member = (BgDimensionMember)Members.get(i);
            BgOrgMigrationUtils.convertMember(numberRef, member);
        }
    }

    public static boolean convertMember(Map<String, BgOrgUnitInfo> numberRef, BgDimensionMember member) {
        if (!numberRef.isEmpty() && numberRef.containsKey(member.getNumber())) {
            member.setAttribute(numberRef.get(member.getNumber()).getOrgUnitID());
            member.setName(numberRef.get(member.getNumber()).getName());
            member.setNumber(numberRef.get(member.getNumber()).getNumber());
            return true;
        }
        return false;
    }

    public static boolean updateBgAdjustBill(Context ctx, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            BgOrgUnitInfo[] arrOrg;
            int i;
            String sql0 = "update T_MBG_BgAdjustBill set FOrgUnit = ? where FOrgUnit = ? and FbgScheme in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
            String sql1 = "update T_MBG_BgAdjustbillentry set FOrgUnit = ? where FOrgUnit = ? and FbgAdjustBill in ( select FID from T_MBG_BgAdjustBill where FBgScheme in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ")";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Object[] param = null;
            int in = migOrgUnits.size();
            for (i = 0; i < in; ++i) {
                arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getOrgUnitID(), arrOrg[0].getOrgUnitID()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql0, params);
            params.clear();
            in = migOrgUnits.size();
            for (i = 0; i < in; ++i) {
                arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getId().toString(), arrOrg[0].getId().toString()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql1, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgAdjustBill sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgAdjustBill sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBgSchemeIntegration(Context ctx, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            BgOrgUnitInfo[] arrOrg;
            int i;
            String sql0 = "update T_MBG_BgSchemeIntegratMember set FNumber = ?,FName = ? where FENTRYID in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' and FBgSchemeIntegrationId in (select FID from T_MBG_BgSchemeIntegration where ( FTargetBgSchemeId in" + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + " or FSourceBgSchemeID in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + " ))) and FNumber = ?";
            String sql1 = "update T_MBG_BgSchemeIntegrationMap set FTargetMemberNumber = ?,FTargetMemberName = ? where FENTRYID in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' and FBgSchemeIntegrationId in (select FID from T_MBG_BgSchemeIntegration where FTargetBgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") ) and FTargetMemberNumber = ?";
            String sql2 = "update T_MBG_BgSchemeIntegrationMap set FSourceMemberNumber = ?,FSourceMemberName = ? where FENTRYID in (select FID from T_MBG_BgSchemeIntegratEntry where FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' and FBgSchemeIntegrationId in (select FID from T_MBG_BgSchemeIntegration where FSourceBgSchemeID in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") ) and FSourceMemberNumber = ?";
            String sql3 = "update T_MBG_BgSchemeIntegrationRpt set FOrgUnitId = ?,FOrgUnitNumber = ?,FOrgUnitName = ? where FIntegrationId in ( select FID from T_MBG_BgSchemeIntegration  where FTargetBgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") and FOrgUnitId = ?";
            String sql4 = "update T_MBG_BgSchemeIntegrationRpt set FSourceOrgUnitID = ?,FSourceOrgUnitNumber = ?,FSourceOrgUnitName = ? where FIntegrationId in ( select FID from T_MBG_BgSchemeIntegration  where FTargetBgSchemeId in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId) + ") and FSourceOrgUnitID = ?";
            ArrayList<Object[]> params = new ArrayList<Object[]>();
            Object[] param = null;
            int in = migOrgUnits.size();
            for (i = 0; i < in; ++i) {
                arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getNumber(), arrOrg[1].getName(), arrOrg[0].getNumber()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql0, params);
            BgDBUtils.executeBatch((Context)ctx, (String)sql1, params);
            BgDBUtils.executeBatch((Context)ctx, (String)sql2, params);
            params.clear();
            in = migOrgUnits.size();
            for (i = 0; i < in; ++i) {
                arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                param = new Object[]{arrOrg[1].getOrgUnitID(), arrOrg[1].getNumber(), arrOrg[1].getName(), arrOrg[0].getOrgUnitID()};
                params.add(param);
            }
            BgDBUtils.executeBatch((Context)ctx, (String)sql3, params);
            BgDBUtils.executeBatch((Context)ctx, (String)sql4, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgSchemeIntegration sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgSchemeIntegration sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBgControlSetting(Connection conn, List migOrgUnits, String orgViewId) throws BOSException {
        if (conn == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        HashSet<String> oldOrgUnitIds = new HashSet<String>();
        final HashMap<String, BgOrgUnitInfo> refOrgUnits = new HashMap<String, BgOrgUnitInfo>();
        int in = migOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
            oldOrgUnitIds.add(arrOrg[0].getOrgUnitID());
            refOrgUnits.put(arrOrg[0].getOrgUnitID(), arrOrg[1]);
        }
        final ArrayList<MbgUpdateDataBaseCopyInfo> relationList = new ArrayList<MbgUpdateDataBaseCopyInfo>();
        try {
            StringBuffer sql = new StringBuffer();
            sql.append("select FID,FOrgUnitId from T_MBG_BgControlSetting  where FSchemeID in ( select FID from T_MBG_BgControlSetScheme where Fschemeid in ").append(BgOrgMigrationUtils.getbgSchemeSql(orgViewId)).append(")").append(" and FOrgUnitID in (");
            MbgSqlHelper.addPlaceHolder((StringBuffer)sql).append(")");
            MbgSqlHelper.executeBatchQuery((Connection)conn, (String)sql.toString(), (List)MbgSqlHelper.getBatchParams(null, (Object[])oldOrgUnitIds.toArray(), (int)50), (IResultReader)new IResultReader(){

                public void read(ResultSet res) throws SQLException {
                    String oldControlSettingId = res.getString("FID");
                    String newControlSettingId = BOSUuid.create((BOSObjectType)new BgControlSettingInfo().getBOSType()).toString();
                    MbgUpdateDataBaseCopyInfo copyInfo = new MbgUpdateDataBaseCopyInfo();
                    copyInfo.setWhere("FID = '" + oldControlSettingId + "'");
                    copyInfo.addReplace("FID", "'" + newControlSettingId + "'");
                    copyInfo.addReplace("FOrgUnitId", "'" + ((BgOrgUnitInfo)refOrgUnits.get(res.getString("FOrgUnitId"))).getOrgUnitID() + "'");
                    relationList.add(copyInfo);
                }
            });
            MbgUpdateDataBaseCopyHelper.copyDataBase(conn, "T_MBG_BgControlSetting", relationList);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgControlSetting sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    public static boolean updateBgControlRecord(Context ctx, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        try {
            List<BgSchemeInfo> bgSchemes = BgOrgMigrationUtils.getBgSchemesByViewId(ctx, orgViewId, DimensionConstants.DEF_ORGUNIT_NUMBER);
            if (bgSchemes == null || bgSchemes.isEmpty()) {
                return false;
            }
            String tableName = null;
            String sql = null;
            for (BgSchemeInfo info : bgSchemes) {
                tableName = BgCubeUtils.getControlCubeName(info.getRefCube());
                sql = "update " + tableName + " set FBizOrgUnitID = ? where FBizOrgUnitID = ?";
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                Object[] param = null;
                int in = migOrgUnits.size();
                for (int i = 0; i < in; ++i) {
                    BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
                    param = new Object[]{arrOrg[1].getOrgUnitID(), arrOrg[0].getOrgUnitID()};
                    params.add(param);
                }
                BgDBUtils.executeBatch((Context)ctx, (String)sql, params);
            }
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgControlRecord  error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgControlSetting sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }

    private static String getbgSchemeSql(String orgViewId) {
        String sql = "(Select sett.FBgSchemeId FROM T_MBG_BgDimSettings sett INNER JOIN T_MBG_BgDimSettingsMember settMember On settMember.FBgDimSettingsId = sett.FID  Where sett.FDimNumber = '" + DimensionConstants.DEF_ORGUNIT_NUMBER + "' And settMember.FType = " + 2 + " AND settMember.FMemberId = '" + orgViewId + "')";
        return sql;
    }

    public static boolean updateBgRefDimMember(Context ctx, List migOrgUnits, String orgViewId) throws BOSException {
        if (ctx == null || migOrgUnits == null || orgViewId == null) {
            return false;
        }
        String sql = "update t_mbg_bgRefDimMember set FOTHERID = ? where  FOTHERID = ? and FBGSCHEMEID in " + BgOrgMigrationUtils.getbgSchemeSql(orgViewId);
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        Object[] param = null;
        int in = migOrgUnits.size();
        for (int i = 0; i < in; ++i) {
            BgOrgUnitInfo[] arrOrg = (BgOrgUnitInfo[])migOrgUnits.get(i);
            param = new Object[]{arrOrg[1].getOrgUnitID().toString(), arrOrg[0].getOrgUnitID().toString()};
            params.add(param);
        }
        try {
            BgDBUtils.executeBatch((Context)ctx, (String)sql, params);
        }
        catch (SQLDataException e) {
            logger.error((Object)"bgOrgMigration updateBgVariate sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        catch (SQLException e) {
            logger.error((Object)"bgOrgMigration updateBgVariate sql error:", (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return true;
    }
}

